#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.

from fenrirscreenreader.core import settingsManager
from fenrirscreenreader.core.i18n import _


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment

    def shutdown(self):
        pass

    def get_description(self):
        return _("Saves your current Fenrir settings so they are the default.")

    def run(self):
        settings_file = self.env["runtime"][
            "SettingsManager"
        ].get_settings_file()
        self.env["runtime"]["SettingsManager"].save_settings(settings_file)
        self.env["runtime"]["OutputManager"].present_text(
            _("Settings saved."), interrupt=True
        )

    def set_callback(self, callback):
        pass
