// license:BSD-3-Clause
// copyright-holders:Olivier Galibert

// Generated file, do not edit, run dsp563xx-make.py instead

#include "emu.h"
#include "dsp563xx.h"

void dsp563xx_device::execute_ipar(u16 kipar)
{
	switch(kipar) {
	case 0: { // -
		break;
		}
	case 1: { //
		break;
		}
	case 2: { // abs a
		unhandled("abs a");
		break;
		}
	case 3: { // abs b
		unhandled("abs b");
		break;
		}
	case 4: { // adc x,a
		unhandled("adc x,a");
		break;
		}
	case 5: { // adc x,b
		unhandled("adc x,b");
		break;
		}
	case 6: { // adc y,a
		unhandled("adc y,a");
		break;
		}
	case 7: { // adc y,b
		unhandled("adc y,b");
		break;
		}
	case 8: { // add b,a
		u64 d = get_a();
		u64 s = get_b();
		set_a(do_add56(util::sext(s, 56), d));
		break;
		}
	case 9: { // add a,b
		u64 d = get_b();
		u64 s = get_a();
		set_b(do_add56(util::sext(s, 56), d));
		break;
		}
	case 10: { // add x,a
		u64 d = get_a();
		u64 s = get_x();
		set_a(do_add56(util::sext(s, 48), d));
		break;
		}
	case 11: { // add x,b
		u64 d = get_b();
		u64 s = get_x();
		set_b(do_add56(util::sext(s, 48), d));
		break;
		}
	case 12: { // add y,a
		u64 d = get_a();
		u64 s = get_y();
		set_a(do_add56(util::sext(s, 48), d));
		break;
		}
	case 13: { // add y,b
		u64 d = get_b();
		u64 s = get_y();
		set_b(do_add56(util::sext(s, 48), d));
		break;
		}
	case 14: { // add x0,a
		u64 d = get_a();
		u32 s = get_x0();
		set_a(do_add56(util::sext(u64(s) << 24, 48), d));
		break;
		}
	case 15: { // add x0,b
		u64 d = get_b();
		u32 s = get_x0();
		set_b(do_add56(util::sext(u64(s) << 24, 48), d));
		break;
		}
	case 16: { // add y0,a
		u64 d = get_a();
		u32 s = get_y0();
		set_a(do_add56(util::sext(u64(s) << 24, 48), d));
		break;
		}
	case 17: { // add y0,b
		u64 d = get_b();
		u32 s = get_y0();
		set_b(do_add56(util::sext(u64(s) << 24, 48), d));
		break;
		}
	case 18: { // add x1,a
		u64 d = get_a();
		u32 s = get_x1();
		set_a(do_add56(util::sext(u64(s) << 24, 48), d));
		break;
		}
	case 19: { // add x1,b
		u64 d = get_b();
		u32 s = get_x1();
		set_b(do_add56(util::sext(u64(s) << 24, 48), d));
		break;
		}
	case 20: { // add y1,a
		u64 d = get_a();
		u32 s = get_y1();
		set_a(do_add56(util::sext(u64(s) << 24, 48), d));
		break;
		}
	case 21: { // add y1,b
		u64 d = get_b();
		u32 s = get_y1();
		set_b(do_add56(util::sext(u64(s) << 24, 48), d));
		break;
		}
	case 22: { // addl b,a
		unhandled("addl b,a");
		break;
		}
	case 23: { // addl a,b
		unhandled("addl a,b");
		break;
		}
	case 24: { // addr b,a
		unhandled("addr b,a");
		break;
		}
	case 25: { // addr a,b
		unhandled("addr a,b");
		break;
		}
	case 26: { // and x0,a
		u32 d_1 = get_a1();
		u32 s = get_x0();
		u32 r = d_1 & s;
		m_ccr = m_ccr & ~(CCR_V|CCR_Z|CCR_N);
		if(!r) {
		m_ccr = m_ccr | CCR_Z;
		} else if(BIT(r, 23)) {
		m_ccr = m_ccr | CCR_N;
		}
		set_a1(r);
		break;
		}
	case 27: { // and x0,b
		u32 d_1 = get_b1();
		u32 s = get_x0();
		u32 r = d_1 & s;
		m_ccr = m_ccr & ~(CCR_V|CCR_Z|CCR_N);
		if(!r) {
		m_ccr = m_ccr | CCR_Z;
		} else if(BIT(r, 23)) {
		m_ccr = m_ccr | CCR_N;
		}
		set_b1(r);
		break;
		}
	case 28: { // and y0,a
		u32 d_1 = get_a1();
		u32 s = get_y0();
		u32 r = d_1 & s;
		m_ccr = m_ccr & ~(CCR_V|CCR_Z|CCR_N);
		if(!r) {
		m_ccr = m_ccr | CCR_Z;
		} else if(BIT(r, 23)) {
		m_ccr = m_ccr | CCR_N;
		}
		set_a1(r);
		break;
		}
	case 29: { // and y0,b
		u32 d_1 = get_b1();
		u32 s = get_y0();
		u32 r = d_1 & s;
		m_ccr = m_ccr & ~(CCR_V|CCR_Z|CCR_N);
		if(!r) {
		m_ccr = m_ccr | CCR_Z;
		} else if(BIT(r, 23)) {
		m_ccr = m_ccr | CCR_N;
		}
		set_b1(r);
		break;
		}
	case 30: { // and x1,a
		u32 d_1 = get_a1();
		u32 s = get_x1();
		u32 r = d_1 & s;
		m_ccr = m_ccr & ~(CCR_V|CCR_Z|CCR_N);
		if(!r) {
		m_ccr = m_ccr | CCR_Z;
		} else if(BIT(r, 23)) {
		m_ccr = m_ccr | CCR_N;
		}
		set_a1(r);
		break;
		}
	case 31: { // and x1,b
		u32 d_1 = get_b1();
		u32 s = get_x1();
		u32 r = d_1 & s;
		m_ccr = m_ccr & ~(CCR_V|CCR_Z|CCR_N);
		if(!r) {
		m_ccr = m_ccr | CCR_Z;
		} else if(BIT(r, 23)) {
		m_ccr = m_ccr | CCR_N;
		}
		set_b1(r);
		break;
		}
	case 32: { // and y1,a
		u32 d_1 = get_a1();
		u32 s = get_y1();
		u32 r = d_1 & s;
		m_ccr = m_ccr & ~(CCR_V|CCR_Z|CCR_N);
		if(!r) {
		m_ccr = m_ccr | CCR_Z;
		} else if(BIT(r, 23)) {
		m_ccr = m_ccr | CCR_N;
		}
		set_a1(r);
		break;
		}
	case 33: { // and y1,b
		u32 d_1 = get_b1();
		u32 s = get_y1();
		u32 r = d_1 & s;
		m_ccr = m_ccr & ~(CCR_V|CCR_Z|CCR_N);
		if(!r) {
		m_ccr = m_ccr | CCR_Z;
		} else if(BIT(r, 23)) {
		m_ccr = m_ccr | CCR_N;
		}
		set_b1(r);
		break;
		}
	case 34: { // asl a
		u64 d = get_a();
		set_a(do_asl56(1, d));
		break;
		}
	case 35: { // asl b
		u64 d = get_b();
		set_b(do_asl56(1, d));
		break;
		}
	case 36: { // asr a
		u64 d = get_a();
		set_a(do_asr56(1, d));
		break;
		}
	case 37: { // asr b
		u64 d = get_b();
		set_b(do_asr56(1, d));
		break;
		}
	case 38: { // clr a
		set_a(0);
		m_ccr = (m_ccr & ~(CCR_E|CCR_N|CCR_V)) | (CCR_U|CCR_Z);
		break;
		}
	case 39: { // clr b
		set_b(0);
		m_ccr = (m_ccr & ~(CCR_E|CCR_N|CCR_V)) | (CCR_U|CCR_Z);
		break;
		}
	case 40: { // cmp b,a
		u64 s = get_b();
		u64 d = get_a();
		(void)do_sub56(util::sext(s, 56), d);
		break;
		}
	case 41: { // cmp a,b
		u64 s = get_a();
		u64 d = get_b();
		(void)do_sub56(util::sext(s, 56), d);
		break;
		}
	case 42: { // cmp x0,a
		u32 s = get_x0();
		u64 d = get_a();
		(void)do_sub56(util::sext(u64(s) << 24, 48), d);
		break;
		}
	case 43: { // cmp x0,b
		u32 s = get_x0();
		u64 d = get_b();
		(void)do_sub56(util::sext(u64(s) << 24, 48), d);
		break;
		}
	case 44: { // cmp y0,a
		u32 s = get_y0();
		u64 d = get_a();
		(void)do_sub56(util::sext(u64(s) << 24, 48), d);
		break;
		}
	case 45: { // cmp y0,b
		u32 s = get_y0();
		u64 d = get_b();
		(void)do_sub56(util::sext(u64(s) << 24, 48), d);
		break;
		}
	case 46: { // cmp x1,a
		u32 s = get_x1();
		u64 d = get_a();
		(void)do_sub56(util::sext(u64(s) << 24, 48), d);
		break;
		}
	case 47: { // cmp x1,b
		u32 s = get_x1();
		u64 d = get_b();
		(void)do_sub56(util::sext(u64(s) << 24, 48), d);
		break;
		}
	case 48: { // cmp y1,a
		u32 s = get_y1();
		u64 d = get_a();
		(void)do_sub56(util::sext(u64(s) << 24, 48), d);
		break;
		}
	case 49: { // cmp y1,b
		u32 s = get_y1();
		u64 d = get_b();
		(void)do_sub56(util::sext(u64(s) << 24, 48), d);
		break;
		}
	case 50: { // cmpm b,a
		unhandled("cmpm b,a");
		break;
		}
	case 51: { // cmpm b,b
		unhandled("cmpm b,b");
		break;
		}
	case 52: { // cmpm x0,a
		unhandled("cmpm x0,a");
		break;
		}
	case 53: { // cmpm x0,b
		unhandled("cmpm x0,b");
		break;
		}
	case 54: { // cmpm y0,a
		unhandled("cmpm y0,a");
		break;
		}
	case 55: { // cmpm y0,b
		unhandled("cmpm y0,b");
		break;
		}
	case 56: { // cmpm x1,a
		unhandled("cmpm x1,a");
		break;
		}
	case 57: { // cmpm x1,b
		unhandled("cmpm x1,b");
		break;
		}
	case 58: { // cmpm y1,a
		unhandled("cmpm y1,a");
		break;
		}
	case 59: { // cmpm y1,b
		unhandled("cmpm y1,b");
		break;
		}
	case 60: { // eor x0,a
		u32 d_1 = get_a1();
		u32 s = get_x0();
		u32 r = d_1 ^ s;
		m_ccr = m_ccr & ~(CCR_V|CCR_Z|CCR_N);
		if(!r) {
		m_ccr = m_ccr | CCR_Z;
		} else if(BIT(r, 23)) {
		m_ccr = m_ccr | CCR_N;
		}
		set_a1(r);
		break;
		}
	case 61: { // eor x0,b
		u32 d_1 = get_b1();
		u32 s = get_x0();
		u32 r = d_1 ^ s;
		m_ccr = m_ccr & ~(CCR_V|CCR_Z|CCR_N);
		if(!r) {
		m_ccr = m_ccr | CCR_Z;
		} else if(BIT(r, 23)) {
		m_ccr = m_ccr | CCR_N;
		}
		set_b1(r);
		break;
		}
	case 62: { // eor y0,a
		u32 d_1 = get_a1();
		u32 s = get_y0();
		u32 r = d_1 ^ s;
		m_ccr = m_ccr & ~(CCR_V|CCR_Z|CCR_N);
		if(!r) {
		m_ccr = m_ccr | CCR_Z;
		} else if(BIT(r, 23)) {
		m_ccr = m_ccr | CCR_N;
		}
		set_a1(r);
		break;
		}
	case 63: { // eor y0,b
		u32 d_1 = get_b1();
		u32 s = get_y0();
		u32 r = d_1 ^ s;
		m_ccr = m_ccr & ~(CCR_V|CCR_Z|CCR_N);
		if(!r) {
		m_ccr = m_ccr | CCR_Z;
		} else if(BIT(r, 23)) {
		m_ccr = m_ccr | CCR_N;
		}
		set_b1(r);
		break;
		}
	case 64: { // eor x1,a
		u32 d_1 = get_a1();
		u32 s = get_x1();
		u32 r = d_1 ^ s;
		m_ccr = m_ccr & ~(CCR_V|CCR_Z|CCR_N);
		if(!r) {
		m_ccr = m_ccr | CCR_Z;
		} else if(BIT(r, 23)) {
		m_ccr = m_ccr | CCR_N;
		}
		set_a1(r);
		break;
		}
	case 65: { // eor x1,b
		u32 d_1 = get_b1();
		u32 s = get_x1();
		u32 r = d_1 ^ s;
		m_ccr = m_ccr & ~(CCR_V|CCR_Z|CCR_N);
		if(!r) {
		m_ccr = m_ccr | CCR_Z;
		} else if(BIT(r, 23)) {
		m_ccr = m_ccr | CCR_N;
		}
		set_b1(r);
		break;
		}
	case 66: { // eor y1,a
		u32 d_1 = get_a1();
		u32 s = get_y1();
		u32 r = d_1 ^ s;
		m_ccr = m_ccr & ~(CCR_V|CCR_Z|CCR_N);
		if(!r) {
		m_ccr = m_ccr | CCR_Z;
		} else if(BIT(r, 23)) {
		m_ccr = m_ccr | CCR_N;
		}
		set_a1(r);
		break;
		}
	case 67: { // eor y1,b
		u32 d_1 = get_b1();
		u32 s = get_y1();
		u32 r = d_1 ^ s;
		m_ccr = m_ccr & ~(CCR_V|CCR_Z|CCR_N);
		if(!r) {
		m_ccr = m_ccr | CCR_Z;
		} else if(BIT(r, 23)) {
		m_ccr = m_ccr | CCR_N;
		}
		set_b1(r);
		break;
		}
	case 68: { // lsl a
		unhandled("lsl a");
		break;
		}
	case 69: { // lsl b
		unhandled("lsl b");
		break;
		}
	case 70: { // lsr a
		unhandled("lsr a");
		break;
		}
	case 71: { // lsr b
		unhandled("lsr b");
		break;
		}
	case 72: { // mac +x0,x0,a
		unhandled("mac +x0,x0,a");
		break;
		}
	case 73: { // mac -x0,x0,a
		unhandled("mac -x0,x0,a");
		break;
		}
	case 74: { // mac +x0,x0,b
		unhandled("mac +x0,x0,b");
		break;
		}
	case 75: { // mac -x0,x0,b
		unhandled("mac -x0,x0,b");
		break;
		}
	case 76: { // mac +y0,y0,a
		unhandled("mac +y0,y0,a");
		break;
		}
	case 77: { // mac -y0,y0,a
		unhandled("mac -y0,y0,a");
		break;
		}
	case 78: { // mac +y0,y0,b
		unhandled("mac +y0,y0,b");
		break;
		}
	case 79: { // mac -y0,y0,b
		unhandled("mac -y0,y0,b");
		break;
		}
	case 80: { // mac +x1,x0,a
		unhandled("mac +x1,x0,a");
		break;
		}
	case 81: { // mac -x1,x0,a
		unhandled("mac -x1,x0,a");
		break;
		}
	case 82: { // mac +x1,x0,b
		unhandled("mac +x1,x0,b");
		break;
		}
	case 83: { // mac -x1,x0,b
		unhandled("mac -x1,x0,b");
		break;
		}
	case 84: { // mac +y1,y0,a
		unhandled("mac +y1,y0,a");
		break;
		}
	case 85: { // mac -y1,y0,a
		unhandled("mac -y1,y0,a");
		break;
		}
	case 86: { // mac +y1,y0,b
		unhandled("mac +y1,y0,b");
		break;
		}
	case 87: { // mac -y1,y0,b
		unhandled("mac -y1,y0,b");
		break;
		}
	case 88: { // mac +x0,y1,a
		unhandled("mac +x0,y1,a");
		break;
		}
	case 89: { // mac -x0,y1,a
		unhandled("mac -x0,y1,a");
		break;
		}
	case 90: { // mac +x0,y1,b
		unhandled("mac +x0,y1,b");
		break;
		}
	case 91: { // mac -x0,y1,b
		unhandled("mac -x0,y1,b");
		break;
		}
	case 92: { // mac +y0,x0,a
		unhandled("mac +y0,x0,a");
		break;
		}
	case 93: { // mac -y0,x0,a
		unhandled("mac -y0,x0,a");
		break;
		}
	case 94: { // mac +y0,x0,b
		unhandled("mac +y0,x0,b");
		break;
		}
	case 95: { // mac -y0,x0,b
		unhandled("mac -y0,x0,b");
		break;
		}
	case 96: { // mac +x1,y0,a
		unhandled("mac +x1,y0,a");
		break;
		}
	case 97: { // mac -x1,y0,a
		unhandled("mac -x1,y0,a");
		break;
		}
	case 98: { // mac +x1,y0,b
		unhandled("mac +x1,y0,b");
		break;
		}
	case 99: { // mac -x1,y0,b
		unhandled("mac -x1,y0,b");
		break;
		}
	case 100: { // mac +y1,x1,a
		unhandled("mac +y1,x1,a");
		break;
		}
	case 101: { // mac -y1,x1,a
		unhandled("mac -y1,x1,a");
		break;
		}
	case 102: { // mac +y1,x1,b
		unhandled("mac +y1,x1,b");
		break;
		}
	case 103: { // mac -y1,x1,b
		unhandled("mac -y1,x1,b");
		break;
		}
	case 104: { // maccr +x0,x0,a
		unhandled("maccr +x0,x0,a");
		break;
		}
	case 105: { // maccr -x0,x0,a
		unhandled("maccr -x0,x0,a");
		break;
		}
	case 106: { // maccr +x0,x0,b
		unhandled("maccr +x0,x0,b");
		break;
		}
	case 107: { // maccr -x0,x0,b
		unhandled("maccr -x0,x0,b");
		break;
		}
	case 108: { // maccr +y0,y0,a
		unhandled("maccr +y0,y0,a");
		break;
		}
	case 109: { // maccr -y0,y0,a
		unhandled("maccr -y0,y0,a");
		break;
		}
	case 110: { // maccr +y0,y0,b
		unhandled("maccr +y0,y0,b");
		break;
		}
	case 111: { // maccr -y0,y0,b
		unhandled("maccr -y0,y0,b");
		break;
		}
	case 112: { // maccr +x1,x0,a
		unhandled("maccr +x1,x0,a");
		break;
		}
	case 113: { // maccr -x1,x0,a
		unhandled("maccr -x1,x0,a");
		break;
		}
	case 114: { // maccr +x1,x0,b
		unhandled("maccr +x1,x0,b");
		break;
		}
	case 115: { // maccr -x1,x0,b
		unhandled("maccr -x1,x0,b");
		break;
		}
	case 116: { // maccr +y1,y0,a
		unhandled("maccr +y1,y0,a");
		break;
		}
	case 117: { // maccr -y1,y0,a
		unhandled("maccr -y1,y0,a");
		break;
		}
	case 118: { // maccr +y1,y0,b
		unhandled("maccr +y1,y0,b");
		break;
		}
	case 119: { // maccr -y1,y0,b
		unhandled("maccr -y1,y0,b");
		break;
		}
	case 120: { // maccr +x0,y1,a
		unhandled("maccr +x0,y1,a");
		break;
		}
	case 121: { // maccr -x0,y1,a
		unhandled("maccr -x0,y1,a");
		break;
		}
	case 122: { // maccr +x0,y1,b
		unhandled("maccr +x0,y1,b");
		break;
		}
	case 123: { // maccr -x0,y1,b
		unhandled("maccr -x0,y1,b");
		break;
		}
	case 124: { // maccr +y0,x0,a
		unhandled("maccr +y0,x0,a");
		break;
		}
	case 125: { // maccr -y0,x0,a
		unhandled("maccr -y0,x0,a");
		break;
		}
	case 126: { // maccr +y0,x0,b
		unhandled("maccr +y0,x0,b");
		break;
		}
	case 127: { // maccr -y0,x0,b
		unhandled("maccr -y0,x0,b");
		break;
		}
	case 128: { // maccr +x1,y0,a
		unhandled("maccr +x1,y0,a");
		break;
		}
	case 129: { // maccr -x1,y0,a
		unhandled("maccr -x1,y0,a");
		break;
		}
	case 130: { // maccr +x1,y0,b
		unhandled("maccr +x1,y0,b");
		break;
		}
	case 131: { // maccr -x1,y0,b
		unhandled("maccr -x1,y0,b");
		break;
		}
	case 132: { // maccr +y1,x1,a
		unhandled("maccr +y1,x1,a");
		break;
		}
	case 133: { // maccr -y1,x1,a
		unhandled("maccr -y1,x1,a");
		break;
		}
	case 134: { // maccr +y1,x1,b
		unhandled("maccr +y1,x1,b");
		break;
		}
	case 135: { // maccr -y1,x1,b
		unhandled("maccr -y1,x1,b");
		break;
		}
	case 136: { // max a,b
		unhandled("max a,b");
		break;
		}
	case 137: { // maxm a,b
		unhandled("maxm a,b");
		break;
		}
	case 138: { // mpy +x0,x0,a
		unhandled("mpy +x0,x0,a");
		break;
		}
	case 139: { // mpy -x0,x0,a
		unhandled("mpy -x0,x0,a");
		break;
		}
	case 140: { // mpy +x0,x0,b
		unhandled("mpy +x0,x0,b");
		break;
		}
	case 141: { // mpy -x0,x0,b
		unhandled("mpy -x0,x0,b");
		break;
		}
	case 142: { // mpy +y0,y0,a
		unhandled("mpy +y0,y0,a");
		break;
		}
	case 143: { // mpy -y0,y0,a
		unhandled("mpy -y0,y0,a");
		break;
		}
	case 144: { // mpy +y0,y0,b
		unhandled("mpy +y0,y0,b");
		break;
		}
	case 145: { // mpy -y0,y0,b
		unhandled("mpy -y0,y0,b");
		break;
		}
	case 146: { // mpy +x1,x0,a
		unhandled("mpy +x1,x0,a");
		break;
		}
	case 147: { // mpy -x1,x0,a
		unhandled("mpy -x1,x0,a");
		break;
		}
	case 148: { // mpy +x1,x0,b
		unhandled("mpy +x1,x0,b");
		break;
		}
	case 149: { // mpy -x1,x0,b
		unhandled("mpy -x1,x0,b");
		break;
		}
	case 150: { // mpy +y1,y0,a
		unhandled("mpy +y1,y0,a");
		break;
		}
	case 151: { // mpy -y1,y0,a
		unhandled("mpy -y1,y0,a");
		break;
		}
	case 152: { // mpy +y1,y0,b
		unhandled("mpy +y1,y0,b");
		break;
		}
	case 153: { // mpy -y1,y0,b
		unhandled("mpy -y1,y0,b");
		break;
		}
	case 154: { // mpy +x0,y1,a
		unhandled("mpy +x0,y1,a");
		break;
		}
	case 155: { // mpy -x0,y1,a
		unhandled("mpy -x0,y1,a");
		break;
		}
	case 156: { // mpy +x0,y1,b
		unhandled("mpy +x0,y1,b");
		break;
		}
	case 157: { // mpy -x0,y1,b
		unhandled("mpy -x0,y1,b");
		break;
		}
	case 158: { // mpy +y0,x0,a
		unhandled("mpy +y0,x0,a");
		break;
		}
	case 159: { // mpy -y0,x0,a
		unhandled("mpy -y0,x0,a");
		break;
		}
	case 160: { // mpy +y0,x0,b
		unhandled("mpy +y0,x0,b");
		break;
		}
	case 161: { // mpy -y0,x0,b
		unhandled("mpy -y0,x0,b");
		break;
		}
	case 162: { // mpy +x1,y0,a
		unhandled("mpy +x1,y0,a");
		break;
		}
	case 163: { // mpy -x1,y0,a
		unhandled("mpy -x1,y0,a");
		break;
		}
	case 164: { // mpy +x1,y0,b
		unhandled("mpy +x1,y0,b");
		break;
		}
	case 165: { // mpy -x1,y0,b
		unhandled("mpy -x1,y0,b");
		break;
		}
	case 166: { // mpy +y1,x1,a
		unhandled("mpy +y1,x1,a");
		break;
		}
	case 167: { // mpy -y1,x1,a
		unhandled("mpy -y1,x1,a");
		break;
		}
	case 168: { // mpy +y1,x1,b
		unhandled("mpy +y1,x1,b");
		break;
		}
	case 169: { // mpy -y1,x1,b
		unhandled("mpy -y1,x1,b");
		break;
		}
	case 170: { // mpyr +x0,x0,a
		unhandled("mpyr +x0,x0,a");
		break;
		}
	case 171: { // mpyr -x0,x0,a
		unhandled("mpyr -x0,x0,a");
		break;
		}
	case 172: { // mpyr +x0,x0,b
		unhandled("mpyr +x0,x0,b");
		break;
		}
	case 173: { // mpyr -x0,x0,b
		unhandled("mpyr -x0,x0,b");
		break;
		}
	case 174: { // mpyr +y0,y0,a
		unhandled("mpyr +y0,y0,a");
		break;
		}
	case 175: { // mpyr -y0,y0,a
		unhandled("mpyr -y0,y0,a");
		break;
		}
	case 176: { // mpyr +y0,y0,b
		unhandled("mpyr +y0,y0,b");
		break;
		}
	case 177: { // mpyr -y0,y0,b
		unhandled("mpyr -y0,y0,b");
		break;
		}
	case 178: { // mpyr +x1,x0,a
		unhandled("mpyr +x1,x0,a");
		break;
		}
	case 179: { // mpyr -x1,x0,a
		unhandled("mpyr -x1,x0,a");
		break;
		}
	case 180: { // mpyr +x1,x0,b
		unhandled("mpyr +x1,x0,b");
		break;
		}
	case 181: { // mpyr -x1,x0,b
		unhandled("mpyr -x1,x0,b");
		break;
		}
	case 182: { // mpyr +y1,y0,a
		unhandled("mpyr +y1,y0,a");
		break;
		}
	case 183: { // mpyr -y1,y0,a
		unhandled("mpyr -y1,y0,a");
		break;
		}
	case 184: { // mpyr +y1,y0,b
		unhandled("mpyr +y1,y0,b");
		break;
		}
	case 185: { // mpyr -y1,y0,b
		unhandled("mpyr -y1,y0,b");
		break;
		}
	case 186: { // mpyr +x0,y1,a
		unhandled("mpyr +x0,y1,a");
		break;
		}
	case 187: { // mpyr -x0,y1,a
		unhandled("mpyr -x0,y1,a");
		break;
		}
	case 188: { // mpyr +x0,y1,b
		unhandled("mpyr +x0,y1,b");
		break;
		}
	case 189: { // mpyr -x0,y1,b
		unhandled("mpyr -x0,y1,b");
		break;
		}
	case 190: { // mpyr +y0,x0,a
		unhandled("mpyr +y0,x0,a");
		break;
		}
	case 191: { // mpyr -y0,x0,a
		unhandled("mpyr -y0,x0,a");
		break;
		}
	case 192: { // mpyr +y0,x0,b
		unhandled("mpyr +y0,x0,b");
		break;
		}
	case 193: { // mpyr -y0,x0,b
		unhandled("mpyr -y0,x0,b");
		break;
		}
	case 194: { // mpyr +x1,y0,a
		unhandled("mpyr +x1,y0,a");
		break;
		}
	case 195: { // mpyr -x1,y0,a
		unhandled("mpyr -x1,y0,a");
		break;
		}
	case 196: { // mpyr +x1,y0,b
		unhandled("mpyr +x1,y0,b");
		break;
		}
	case 197: { // mpyr -x1,y0,b
		unhandled("mpyr -x1,y0,b");
		break;
		}
	case 198: { // mpyr +y1,x1,a
		unhandled("mpyr +y1,x1,a");
		break;
		}
	case 199: { // mpyr -y1,x1,a
		unhandled("mpyr -y1,x1,a");
		break;
		}
	case 200: { // mpyr +y1,x1,b
		unhandled("mpyr +y1,x1,b");
		break;
		}
	case 201: { // mpyr -y1,x1,b
		unhandled("mpyr -y1,x1,b");
		break;
		}
	case 202: { // neg a
		unhandled("neg a");
		break;
		}
	case 203: { // neg b
		unhandled("neg b");
		break;
		}
	case 204: { // not a
		unhandled("not a");
		break;
		}
	case 205: { // not b
		unhandled("not b");
		break;
		}
	case 206: { // or x0,a
		u32 d_1 = get_a1();
		u32 s = get_x0();
		u32 r = d_1 | s;
		m_ccr = m_ccr & ~(CCR_V|CCR_Z|CCR_N);
		if(!r) {
		m_ccr = m_ccr | CCR_Z;
		} else if(BIT(r, 23)) {
		m_ccr = m_ccr | CCR_N;
		}
		set_a1(r);
		break;
		}
	case 207: { // or x0,b
		u32 d_1 = get_b1();
		u32 s = get_x0();
		u32 r = d_1 | s;
		m_ccr = m_ccr & ~(CCR_V|CCR_Z|CCR_N);
		if(!r) {
		m_ccr = m_ccr | CCR_Z;
		} else if(BIT(r, 23)) {
		m_ccr = m_ccr | CCR_N;
		}
		set_b1(r);
		break;
		}
	case 208: { // or y0,a
		u32 d_1 = get_a1();
		u32 s = get_y0();
		u32 r = d_1 | s;
		m_ccr = m_ccr & ~(CCR_V|CCR_Z|CCR_N);
		if(!r) {
		m_ccr = m_ccr | CCR_Z;
		} else if(BIT(r, 23)) {
		m_ccr = m_ccr | CCR_N;
		}
		set_a1(r);
		break;
		}
	case 209: { // or y0,b
		u32 d_1 = get_b1();
		u32 s = get_y0();
		u32 r = d_1 | s;
		m_ccr = m_ccr & ~(CCR_V|CCR_Z|CCR_N);
		if(!r) {
		m_ccr = m_ccr | CCR_Z;
		} else if(BIT(r, 23)) {
		m_ccr = m_ccr | CCR_N;
		}
		set_b1(r);
		break;
		}
	case 210: { // or x1,a
		u32 d_1 = get_a1();
		u32 s = get_x1();
		u32 r = d_1 | s;
		m_ccr = m_ccr & ~(CCR_V|CCR_Z|CCR_N);
		if(!r) {
		m_ccr = m_ccr | CCR_Z;
		} else if(BIT(r, 23)) {
		m_ccr = m_ccr | CCR_N;
		}
		set_a1(r);
		break;
		}
	case 211: { // or x1,b
		u32 d_1 = get_b1();
		u32 s = get_x1();
		u32 r = d_1 | s;
		m_ccr = m_ccr & ~(CCR_V|CCR_Z|CCR_N);
		if(!r) {
		m_ccr = m_ccr | CCR_Z;
		} else if(BIT(r, 23)) {
		m_ccr = m_ccr | CCR_N;
		}
		set_b1(r);
		break;
		}
	case 212: { // or y1,a
		u32 d_1 = get_a1();
		u32 s = get_y1();
		u32 r = d_1 | s;
		m_ccr = m_ccr & ~(CCR_V|CCR_Z|CCR_N);
		if(!r) {
		m_ccr = m_ccr | CCR_Z;
		} else if(BIT(r, 23)) {
		m_ccr = m_ccr | CCR_N;
		}
		set_a1(r);
		break;
		}
	case 213: { // or y1,b
		u32 d_1 = get_b1();
		u32 s = get_y1();
		u32 r = d_1 | s;
		m_ccr = m_ccr & ~(CCR_V|CCR_Z|CCR_N);
		if(!r) {
		m_ccr = m_ccr | CCR_Z;
		} else if(BIT(r, 23)) {
		m_ccr = m_ccr | CCR_N;
		}
		set_b1(r);
		break;
		}
	case 214: { // rnd a
		unhandled("rnd a");
		break;
		}
	case 215: { // rnd b
		unhandled("rnd b");
		break;
		}
	case 216: { // rol a
		unhandled("rol a");
		break;
		}
	case 217: { // rol b
		unhandled("rol b");
		break;
		}
	case 218: { // ror a
		unhandled("ror a");
		break;
		}
	case 219: { // ror b
		unhandled("ror b");
		break;
		}
	case 220: { // sbc x,a
		unhandled("sbc x,a");
		break;
		}
	case 221: { // sbc x,b
		unhandled("sbc x,b");
		break;
		}
	case 222: { // sbc y,a
		unhandled("sbc y,a");
		break;
		}
	case 223: { // sbc y,b
		unhandled("sbc y,b");
		break;
		}
	case 224: { // sub b,a
		u64 d = get_a();
		u64 s = get_b();
		set_a(do_sub56(util::sext(s, 56), d));
		break;
		}
	case 225: { // sub a,b
		u64 d = get_b();
		u64 s = get_a();
		set_b(do_sub56(util::sext(s, 56), d));
		break;
		}
	case 226: { // sub x,a
		u64 d = get_a();
		u64 s = get_x();
		set_a(do_sub56(util::sext(s, 48), d));
		break;
		}
	case 227: { // sub x,b
		u64 d = get_b();
		u64 s = get_x();
		set_b(do_sub56(util::sext(s, 48), d));
		break;
		}
	case 228: { // sub y,a
		u64 d = get_a();
		u64 s = get_y();
		set_a(do_sub56(util::sext(s, 48), d));
		break;
		}
	case 229: { // sub y,b
		u64 d = get_b();
		u64 s = get_y();
		set_b(do_sub56(util::sext(s, 48), d));
		break;
		}
	case 230: { // sub x0,a
		u64 d = get_a();
		u32 s = get_x0();
		set_a(do_sub56(util::sext(u64(s) << 24, 48), d));
		break;
		}
	case 231: { // sub x0,b
		u64 d = get_b();
		u32 s = get_x0();
		set_b(do_sub56(util::sext(u64(s) << 24, 48), d));
		break;
		}
	case 232: { // sub y0,a
		u64 d = get_a();
		u32 s = get_y0();
		set_a(do_sub56(util::sext(u64(s) << 24, 48), d));
		break;
		}
	case 233: { // sub y0,b
		u64 d = get_b();
		u32 s = get_y0();
		set_b(do_sub56(util::sext(u64(s) << 24, 48), d));
		break;
		}
	case 234: { // sub x1,a
		u64 d = get_a();
		u32 s = get_x1();
		set_a(do_sub56(util::sext(u64(s) << 24, 48), d));
		break;
		}
	case 235: { // sub x1,b
		u64 d = get_b();
		u32 s = get_x1();
		set_b(do_sub56(util::sext(u64(s) << 24, 48), d));
		break;
		}
	case 236: { // sub y1,a
		u64 d = get_a();
		u32 s = get_y1();
		set_a(do_sub56(util::sext(u64(s) << 24, 48), d));
		break;
		}
	case 237: { // sub y1,b
		u64 d = get_b();
		u32 s = get_y1();
		set_b(do_sub56(util::sext(u64(s) << 24, 48), d));
		break;
		}
	case 238: { // subl b,a
		unhandled("subl b,a");
		break;
		}
	case 239: { // subl a,b
		unhandled("subl a,b");
		break;
		}
	case 240: { // subr b,a
		unhandled("subr b,a");
		break;
		}
	case 241: { // subr a,b
		unhandled("subr a,b");
		break;
		}
	case 242: { // tfr b,a
		unhandled("tfr b,a");
		break;
		}
	case 243: { // tfr b,b
		unhandled("tfr b,b");
		break;
		}
	case 244: { // tfr x0,a
		unhandled("tfr x0,a");
		break;
		}
	case 245: { // tfr x0,b
		unhandled("tfr x0,b");
		break;
		}
	case 246: { // tfr y0,a
		unhandled("tfr y0,a");
		break;
		}
	case 247: { // tfr y0,b
		unhandled("tfr y0,b");
		break;
		}
	case 248: { // tfr x1,a
		unhandled("tfr x1,a");
		break;
		}
	case 249: { // tfr x1,b
		unhandled("tfr x1,b");
		break;
		}
	case 250: { // tfr y1,a
		unhandled("tfr y1,a");
		break;
		}
	case 251: { // tfr y1,b
		unhandled("tfr y1,b");
		break;
		}
	case 252: { // tst a
		u64 d = get_a();
		do_tst56(d);
		break;
		}
	case 253: { // tst b
		u64 d = get_b();
		do_tst56(d);
		break;
		}
	}
}

void dsp563xx_device::execute_pre_move(u16 kmove, u32 opcode, u32 exv)
{
	switch(kmove) {
	case 0: { // -
		break;
		}
	case 1: { //
		break;
		}
	case 2: { // #[i],x0
		break;
		}
	case 3: { // #[i],x1
		break;
		}
	case 4: { // #[i],y0
		break;
		}
	case 5: { // #[i],y1
		break;
		}
	case 6: { // #[i],a0
		break;
		}
	case 7: { // #[i],b0
		break;
		}
	case 8: { // #[i],a2
		break;
		}
	case 9: { // #[i],b2
		break;
		}
	case 10: { // #[i],a1
		break;
		}
	case 11: { // #[i],b1
		break;
		}
	case 12: { // #[i],a
		break;
		}
	case 13: { // #[i],b
		break;
		}
	case 14: { // #[i],r
		break;
		}
	case 15: { // #[i],n
		break;
		}
	case 16: { // x0,x0
		u32 s = get_x0();
		m_tmp1 = s;
		break;
		}
	case 17: { // x0,x1
		u32 s = get_x0();
		m_tmp1 = s;
		break;
		}
	case 18: { // x0,y0
		u32 s = get_x0();
		m_tmp1 = s;
		break;
		}
	case 19: { // x0,y1
		u32 s = get_x0();
		m_tmp1 = s;
		break;
		}
	case 20: { // x0,a0
		u32 s = get_x0();
		m_tmp1 = s;
		break;
		}
	case 21: { // x0,b0
		u32 s = get_x0();
		m_tmp1 = s;
		break;
		}
	case 22: { // x0,a2
		u32 s = get_x0();
		m_tmp1 = s;
		break;
		}
	case 23: { // x0,b2
		u32 s = get_x0();
		m_tmp1 = s;
		break;
		}
	case 24: { // x0,a1
		u32 s = get_x0();
		m_tmp1 = s;
		break;
		}
	case 25: { // x0,b1
		u32 s = get_x0();
		m_tmp1 = s;
		break;
		}
	case 26: { // x0,a
		u32 s = get_x0();
		m_tmp1 = s;
		break;
		}
	case 27: { // x0,b
		u32 s = get_x0();
		m_tmp1 = s;
		break;
		}
	case 28: { // x0,r
		u32 s = get_x0();
		m_tmp1 = s;
		break;
		}
	case 29: { // x0,n
		u32 s = get_x0();
		m_tmp1 = s;
		break;
		}
	case 30: { // x1,x0
		u32 s = get_x1();
		m_tmp1 = s;
		break;
		}
	case 31: { // x1,x1
		u32 s = get_x1();
		m_tmp1 = s;
		break;
		}
	case 32: { // x1,y0
		u32 s = get_x1();
		m_tmp1 = s;
		break;
		}
	case 33: { // x1,y1
		u32 s = get_x1();
		m_tmp1 = s;
		break;
		}
	case 34: { // x1,a0
		u32 s = get_x1();
		m_tmp1 = s;
		break;
		}
	case 35: { // x1,b0
		u32 s = get_x1();
		m_tmp1 = s;
		break;
		}
	case 36: { // x1,a2
		u32 s = get_x1();
		m_tmp1 = s;
		break;
		}
	case 37: { // x1,b2
		u32 s = get_x1();
		m_tmp1 = s;
		break;
		}
	case 38: { // x1,a1
		u32 s = get_x1();
		m_tmp1 = s;
		break;
		}
	case 39: { // x1,b1
		u32 s = get_x1();
		m_tmp1 = s;
		break;
		}
	case 40: { // x1,a
		u32 s = get_x1();
		m_tmp1 = s;
		break;
		}
	case 41: { // x1,b
		u32 s = get_x1();
		m_tmp1 = s;
		break;
		}
	case 42: { // x1,r
		u32 s = get_x1();
		m_tmp1 = s;
		break;
		}
	case 43: { // x1,n
		u32 s = get_x1();
		m_tmp1 = s;
		break;
		}
	case 44: { // y0,x0
		u32 s = get_y0();
		m_tmp1 = s;
		break;
		}
	case 45: { // y0,x1
		u32 s = get_y0();
		m_tmp1 = s;
		break;
		}
	case 46: { // y0,y0
		u32 s = get_y0();
		m_tmp1 = s;
		break;
		}
	case 47: { // y0,y1
		u32 s = get_y0();
		m_tmp1 = s;
		break;
		}
	case 48: { // y0,a0
		u32 s = get_y0();
		m_tmp1 = s;
		break;
		}
	case 49: { // y0,b0
		u32 s = get_y0();
		m_tmp1 = s;
		break;
		}
	case 50: { // y0,a2
		u32 s = get_y0();
		m_tmp1 = s;
		break;
		}
	case 51: { // y0,b2
		u32 s = get_y0();
		m_tmp1 = s;
		break;
		}
	case 52: { // y0,a1
		u32 s = get_y0();
		m_tmp1 = s;
		break;
		}
	case 53: { // y0,b1
		u32 s = get_y0();
		m_tmp1 = s;
		break;
		}
	case 54: { // y0,a
		u32 s = get_y0();
		m_tmp1 = s;
		break;
		}
	case 55: { // y0,b
		u32 s = get_y0();
		m_tmp1 = s;
		break;
		}
	case 56: { // y0,r
		u32 s = get_y0();
		m_tmp1 = s;
		break;
		}
	case 57: { // y0,n
		u32 s = get_y0();
		m_tmp1 = s;
		break;
		}
	case 58: { // y1,x0
		u32 s = get_y1();
		m_tmp1 = s;
		break;
		}
	case 59: { // y1,x1
		u32 s = get_y1();
		m_tmp1 = s;
		break;
		}
	case 60: { // y1,y0
		u32 s = get_y1();
		m_tmp1 = s;
		break;
		}
	case 61: { // y1,y1
		u32 s = get_y1();
		m_tmp1 = s;
		break;
		}
	case 62: { // y1,a0
		u32 s = get_y1();
		m_tmp1 = s;
		break;
		}
	case 63: { // y1,b0
		u32 s = get_y1();
		m_tmp1 = s;
		break;
		}
	case 64: { // y1,a2
		u32 s = get_y1();
		m_tmp1 = s;
		break;
		}
	case 65: { // y1,b2
		u32 s = get_y1();
		m_tmp1 = s;
		break;
		}
	case 66: { // y1,a1
		u32 s = get_y1();
		m_tmp1 = s;
		break;
		}
	case 67: { // y1,b1
		u32 s = get_y1();
		m_tmp1 = s;
		break;
		}
	case 68: { // y1,a
		u32 s = get_y1();
		m_tmp1 = s;
		break;
		}
	case 69: { // y1,b
		u32 s = get_y1();
		m_tmp1 = s;
		break;
		}
	case 70: { // y1,r
		u32 s = get_y1();
		m_tmp1 = s;
		break;
		}
	case 71: { // y1,n
		u32 s = get_y1();
		m_tmp1 = s;
		break;
		}
	case 72: { // a0,x0
		u32 s = get_a0();
		m_tmp1 = s;
		break;
		}
	case 73: { // a0,x1
		u32 s = get_a0();
		m_tmp1 = s;
		break;
		}
	case 74: { // a0,y0
		u32 s = get_a0();
		m_tmp1 = s;
		break;
		}
	case 75: { // a0,y1
		u32 s = get_a0();
		m_tmp1 = s;
		break;
		}
	case 76: { // a0,a0
		u32 s = get_a0();
		m_tmp1 = s;
		break;
		}
	case 77: { // a0,b0
		u32 s = get_a0();
		m_tmp1 = s;
		break;
		}
	case 78: { // a0,a2
		u32 s = get_a0();
		m_tmp1 = s;
		break;
		}
	case 79: { // a0,b2
		u32 s = get_a0();
		m_tmp1 = s;
		break;
		}
	case 80: { // a0,a1
		u32 s = get_a0();
		m_tmp1 = s;
		break;
		}
	case 81: { // a0,b1
		u32 s = get_a0();
		m_tmp1 = s;
		break;
		}
	case 82: { // a0,a
		u32 s = get_a0();
		m_tmp1 = s;
		break;
		}
	case 83: { // a0,b
		u32 s = get_a0();
		m_tmp1 = s;
		break;
		}
	case 84: { // a0,r
		u32 s = get_a0();
		m_tmp1 = s;
		break;
		}
	case 85: { // a0,n
		u32 s = get_a0();
		m_tmp1 = s;
		break;
		}
	case 86: { // b0,x0
		u32 s = get_b0();
		m_tmp1 = s;
		break;
		}
	case 87: { // b0,x1
		u32 s = get_b0();
		m_tmp1 = s;
		break;
		}
	case 88: { // b0,y0
		u32 s = get_b0();
		m_tmp1 = s;
		break;
		}
	case 89: { // b0,y1
		u32 s = get_b0();
		m_tmp1 = s;
		break;
		}
	case 90: { // b0,a0
		u32 s = get_b0();
		m_tmp1 = s;
		break;
		}
	case 91: { // b0,b0
		u32 s = get_b0();
		m_tmp1 = s;
		break;
		}
	case 92: { // b0,a2
		u32 s = get_b0();
		m_tmp1 = s;
		break;
		}
	case 93: { // b0,b2
		u32 s = get_b0();
		m_tmp1 = s;
		break;
		}
	case 94: { // b0,a1
		u32 s = get_b0();
		m_tmp1 = s;
		break;
		}
	case 95: { // b0,b1
		u32 s = get_b0();
		m_tmp1 = s;
		break;
		}
	case 96: { // b0,a
		u32 s = get_b0();
		m_tmp1 = s;
		break;
		}
	case 97: { // b0,b
		u32 s = get_b0();
		m_tmp1 = s;
		break;
		}
	case 98: { // b0,r
		u32 s = get_b0();
		m_tmp1 = s;
		break;
		}
	case 99: { // b0,n
		u32 s = get_b0();
		m_tmp1 = s;
		break;
		}
	case 100: { // a2,x0
		u32 s = get_a2();
		m_tmp1 = s;
		break;
		}
	case 101: { // a2,x1
		u32 s = get_a2();
		m_tmp1 = s;
		break;
		}
	case 102: { // a2,y0
		u32 s = get_a2();
		m_tmp1 = s;
		break;
		}
	case 103: { // a2,y1
		u32 s = get_a2();
		m_tmp1 = s;
		break;
		}
	case 104: { // a2,a0
		u32 s = get_a2();
		m_tmp1 = s;
		break;
		}
	case 105: { // a2,b0
		u32 s = get_a2();
		m_tmp1 = s;
		break;
		}
	case 106: { // a2,a2
		u32 s = get_a2();
		m_tmp1 = s;
		break;
		}
	case 107: { // a2,b2
		u32 s = get_a2();
		m_tmp1 = s;
		break;
		}
	case 108: { // a2,a1
		u32 s = get_a2();
		m_tmp1 = s;
		break;
		}
	case 109: { // a2,b1
		u32 s = get_a2();
		m_tmp1 = s;
		break;
		}
	case 110: { // a2,a
		u32 s = get_a2();
		m_tmp1 = s;
		break;
		}
	case 111: { // a2,b
		u32 s = get_a2();
		m_tmp1 = s;
		break;
		}
	case 112: { // a2,r
		u32 s = get_a2();
		m_tmp1 = s;
		break;
		}
	case 113: { // a2,n
		u32 s = get_a2();
		m_tmp1 = s;
		break;
		}
	case 114: { // b2,x0
		u32 s = get_b2();
		m_tmp1 = s;
		break;
		}
	case 115: { // b2,x1
		u32 s = get_b2();
		m_tmp1 = s;
		break;
		}
	case 116: { // b2,y0
		u32 s = get_b2();
		m_tmp1 = s;
		break;
		}
	case 117: { // b2,y1
		u32 s = get_b2();
		m_tmp1 = s;
		break;
		}
	case 118: { // b2,a0
		u32 s = get_b2();
		m_tmp1 = s;
		break;
		}
	case 119: { // b2,b0
		u32 s = get_b2();
		m_tmp1 = s;
		break;
		}
	case 120: { // b2,a2
		u32 s = get_b2();
		m_tmp1 = s;
		break;
		}
	case 121: { // b2,b2
		u32 s = get_b2();
		m_tmp1 = s;
		break;
		}
	case 122: { // b2,a1
		u32 s = get_b2();
		m_tmp1 = s;
		break;
		}
	case 123: { // b2,b1
		u32 s = get_b2();
		m_tmp1 = s;
		break;
		}
	case 124: { // b2,a
		u32 s = get_b2();
		m_tmp1 = s;
		break;
		}
	case 125: { // b2,b
		u32 s = get_b2();
		m_tmp1 = s;
		break;
		}
	case 126: { // b2,r
		u32 s = get_b2();
		m_tmp1 = s;
		break;
		}
	case 127: { // b2,n
		u32 s = get_b2();
		m_tmp1 = s;
		break;
		}
	case 128: { // a1,x0
		u32 s = get_a1();
		m_tmp1 = s;
		break;
		}
	case 129: { // a1,x1
		u32 s = get_a1();
		m_tmp1 = s;
		break;
		}
	case 130: { // a1,y0
		u32 s = get_a1();
		m_tmp1 = s;
		break;
		}
	case 131: { // a1,y1
		u32 s = get_a1();
		m_tmp1 = s;
		break;
		}
	case 132: { // a1,a0
		u32 s = get_a1();
		m_tmp1 = s;
		break;
		}
	case 133: { // a1,b0
		u32 s = get_a1();
		m_tmp1 = s;
		break;
		}
	case 134: { // a1,a2
		u32 s = get_a1();
		m_tmp1 = s;
		break;
		}
	case 135: { // a1,b2
		u32 s = get_a1();
		m_tmp1 = s;
		break;
		}
	case 136: { // a1,a1
		u32 s = get_a1();
		m_tmp1 = s;
		break;
		}
	case 137: { // a1,b1
		u32 s = get_a1();
		m_tmp1 = s;
		break;
		}
	case 138: { // a1,a
		u32 s = get_a1();
		m_tmp1 = s;
		break;
		}
	case 139: { // a1,b
		u32 s = get_a1();
		m_tmp1 = s;
		break;
		}
	case 140: { // a1,r
		u32 s = get_a1();
		m_tmp1 = s;
		break;
		}
	case 141: { // a1,n
		u32 s = get_a1();
		m_tmp1 = s;
		break;
		}
	case 142: { // b1,x0
		u32 s = get_b1();
		m_tmp1 = s;
		break;
		}
	case 143: { // b1,x1
		u32 s = get_b1();
		m_tmp1 = s;
		break;
		}
	case 144: { // b1,y0
		u32 s = get_b1();
		m_tmp1 = s;
		break;
		}
	case 145: { // b1,y1
		u32 s = get_b1();
		m_tmp1 = s;
		break;
		}
	case 146: { // b1,a0
		u32 s = get_b1();
		m_tmp1 = s;
		break;
		}
	case 147: { // b1,b0
		u32 s = get_b1();
		m_tmp1 = s;
		break;
		}
	case 148: { // b1,a2
		u32 s = get_b1();
		m_tmp1 = s;
		break;
		}
	case 149: { // b1,b2
		u32 s = get_b1();
		m_tmp1 = s;
		break;
		}
	case 150: { // b1,a1
		u32 s = get_b1();
		m_tmp1 = s;
		break;
		}
	case 151: { // b1,b1
		u32 s = get_b1();
		m_tmp1 = s;
		break;
		}
	case 152: { // b1,a
		u32 s = get_b1();
		m_tmp1 = s;
		break;
		}
	case 153: { // b1,b
		u32 s = get_b1();
		m_tmp1 = s;
		break;
		}
	case 154: { // b1,r
		u32 s = get_b1();
		m_tmp1 = s;
		break;
		}
	case 155: { // b1,n
		u32 s = get_b1();
		m_tmp1 = s;
		break;
		}
	case 156: { // a,x0
		u32 s_h = get_ah();
		m_tmp1 = s_h;
		break;
		}
	case 157: { // a,x1
		u32 s_h = get_ah();
		m_tmp1 = s_h;
		break;
		}
	case 158: { // a,y0
		u32 s_h = get_ah();
		m_tmp1 = s_h;
		break;
		}
	case 159: { // a,y1
		u32 s_h = get_ah();
		m_tmp1 = s_h;
		break;
		}
	case 160: { // a,a0
		u32 s_h = get_ah();
		m_tmp1 = s_h;
		break;
		}
	case 161: { // a,b0
		u32 s_h = get_ah();
		m_tmp1 = s_h;
		break;
		}
	case 162: { // a,a2
		u32 s_h = get_ah();
		m_tmp1 = s_h;
		break;
		}
	case 163: { // a,b2
		u32 s_h = get_ah();
		m_tmp1 = s_h;
		break;
		}
	case 164: { // a,a1
		u32 s_h = get_ah();
		m_tmp1 = s_h;
		break;
		}
	case 165: { // a,b1
		u32 s_h = get_ah();
		m_tmp1 = s_h;
		break;
		}
	case 166: { // a,a
		u32 s_h = get_ah();
		m_tmp1 = s_h;
		break;
		}
	case 167: { // a,b
		u32 s_h = get_ah();
		m_tmp1 = s_h;
		break;
		}
	case 168: { // a,r
		u32 s_h = get_ah();
		m_tmp1 = s_h;
		break;
		}
	case 169: { // a,n
		u32 s_h = get_ah();
		m_tmp1 = s_h;
		break;
		}
	case 170: { // b,x0
		u32 s_h = get_bh();
		m_tmp1 = s_h;
		break;
		}
	case 171: { // b,x1
		u32 s_h = get_bh();
		m_tmp1 = s_h;
		break;
		}
	case 172: { // b,y0
		u32 s_h = get_bh();
		m_tmp1 = s_h;
		break;
		}
	case 173: { // b,y1
		u32 s_h = get_bh();
		m_tmp1 = s_h;
		break;
		}
	case 174: { // b,a0
		u32 s_h = get_bh();
		m_tmp1 = s_h;
		break;
		}
	case 175: { // b,b0
		u32 s_h = get_bh();
		m_tmp1 = s_h;
		break;
		}
	case 176: { // b,a2
		u32 s_h = get_bh();
		m_tmp1 = s_h;
		break;
		}
	case 177: { // b,b2
		u32 s_h = get_bh();
		m_tmp1 = s_h;
		break;
		}
	case 178: { // b,a1
		u32 s_h = get_bh();
		m_tmp1 = s_h;
		break;
		}
	case 179: { // b,b1
		u32 s_h = get_bh();
		m_tmp1 = s_h;
		break;
		}
	case 180: { // b,a
		u32 s_h = get_bh();
		m_tmp1 = s_h;
		break;
		}
	case 181: { // b,b
		u32 s_h = get_bh();
		m_tmp1 = s_h;
		break;
		}
	case 182: { // b,r
		u32 s_h = get_bh();
		m_tmp1 = s_h;
		break;
		}
	case 183: { // b,n
		u32 s_h = get_bh();
		m_tmp1 = s_h;
		break;
		}
	case 184: { // r,x0
		u32 s = get_r(BIT(opcode, 13, 5) & 7);
		m_tmp1 = s;
		break;
		}
	case 185: { // r,x1
		u32 s = get_r(BIT(opcode, 13, 5) & 7);
		m_tmp1 = s;
		break;
		}
	case 186: { // r,y0
		u32 s = get_r(BIT(opcode, 13, 5) & 7);
		m_tmp1 = s;
		break;
		}
	case 187: { // r,y1
		u32 s = get_r(BIT(opcode, 13, 5) & 7);
		m_tmp1 = s;
		break;
		}
	case 188: { // r,a0
		u32 s = get_r(BIT(opcode, 13, 5) & 7);
		m_tmp1 = s;
		break;
		}
	case 189: { // r,b0
		u32 s = get_r(BIT(opcode, 13, 5) & 7);
		m_tmp1 = s;
		break;
		}
	case 190: { // r,a2
		u32 s = get_r(BIT(opcode, 13, 5) & 7);
		m_tmp1 = s;
		break;
		}
	case 191: { // r,b2
		u32 s = get_r(BIT(opcode, 13, 5) & 7);
		m_tmp1 = s;
		break;
		}
	case 192: { // r,a1
		u32 s = get_r(BIT(opcode, 13, 5) & 7);
		m_tmp1 = s;
		break;
		}
	case 193: { // r,b1
		u32 s = get_r(BIT(opcode, 13, 5) & 7);
		m_tmp1 = s;
		break;
		}
	case 194: { // r,a
		u32 s = get_r(BIT(opcode, 13, 5) & 7);
		m_tmp1 = s;
		break;
		}
	case 195: { // r,b
		u32 s = get_r(BIT(opcode, 13, 5) & 7);
		m_tmp1 = s;
		break;
		}
	case 196: { // r,r
		u32 s = get_r(BIT(opcode, 13, 5) & 7);
		m_tmp1 = s;
		break;
		}
	case 197: { // r,n
		u32 s = get_r(BIT(opcode, 13, 5) & 7);
		m_tmp1 = s;
		break;
		}
	case 198: { // n,x0
		u32 s = get_n(BIT(opcode, 13, 5) & 7);
		m_tmp1 = s;
		break;
		}
	case 199: { // n,x1
		u32 s = get_n(BIT(opcode, 13, 5) & 7);
		m_tmp1 = s;
		break;
		}
	case 200: { // n,y0
		u32 s = get_n(BIT(opcode, 13, 5) & 7);
		m_tmp1 = s;
		break;
		}
	case 201: { // n,y1
		u32 s = get_n(BIT(opcode, 13, 5) & 7);
		m_tmp1 = s;
		break;
		}
	case 202: { // n,a0
		u32 s = get_n(BIT(opcode, 13, 5) & 7);
		m_tmp1 = s;
		break;
		}
	case 203: { // n,b0
		u32 s = get_n(BIT(opcode, 13, 5) & 7);
		m_tmp1 = s;
		break;
		}
	case 204: { // n,a2
		u32 s = get_n(BIT(opcode, 13, 5) & 7);
		m_tmp1 = s;
		break;
		}
	case 205: { // n,b2
		u32 s = get_n(BIT(opcode, 13, 5) & 7);
		m_tmp1 = s;
		break;
		}
	case 206: { // n,a1
		u32 s = get_n(BIT(opcode, 13, 5) & 7);
		m_tmp1 = s;
		break;
		}
	case 207: { // n,b1
		u32 s = get_n(BIT(opcode, 13, 5) & 7);
		m_tmp1 = s;
		break;
		}
	case 208: { // n,a
		u32 s = get_n(BIT(opcode, 13, 5) & 7);
		m_tmp1 = s;
		break;
		}
	case 209: { // n,b
		u32 s = get_n(BIT(opcode, 13, 5) & 7);
		m_tmp1 = s;
		break;
		}
	case 210: { // n,r
		u32 s = get_n(BIT(opcode, 13, 5) & 7);
		m_tmp1 = s;
		break;
		}
	case 211: { // n,n
		u32 s = get_n(BIT(opcode, 13, 5) & 7);
		m_tmp1 = s;
		break;
		}
	case 212: { // (r)-n
		int ea_r = BIT(opcode, 8, 5) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		(void)(ea);
		break;
		}
	case 213: { // (r)+n
		int ea_r = BIT(opcode, 8, 5) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		(void)(ea);
		break;
		}
	case 214: { // (r)-
		int ea_r = BIT(opcode, 8, 5) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		(void)(ea);
		break;
		}
	case 215: { // (r)+
		int ea_r = BIT(opcode, 8, 5) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		(void)(ea);
		break;
		}
	case 216: { // x:(r)-n,x0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 217: { // x:(r)+n,x0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 218: { // x:(r)-,x0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 219: { // x:(r)+,x0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 220: { // x:(r),x0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 221: { // x:(r+n),x0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 222: { // x:-(r),x0
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 223: { // y:(r)-n,x0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 224: { // y:(r)+n,x0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 225: { // y:(r)-,x0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 226: { // y:(r)+,x0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 227: { // y:(r),x0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 228: { // y:(r+n),x0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 229: { // y:-(r),x0
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 230: { // x:(r)-n,x1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 231: { // x:(r)+n,x1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 232: { // x:(r)-,x1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 233: { // x:(r)+,x1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 234: { // x:(r),x1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 235: { // x:(r+n),x1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 236: { // x:-(r),x1
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 237: { // y:(r)-n,x1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 238: { // y:(r)+n,x1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 239: { // y:(r)-,x1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 240: { // y:(r)+,x1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 241: { // y:(r),x1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 242: { // y:(r+n),x1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 243: { // y:-(r),x1
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 244: { // x:(r)-n,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 245: { // x:(r)+n,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 246: { // x:(r)-,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 247: { // x:(r)+,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 248: { // x:(r),y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 249: { // x:(r+n),y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 250: { // x:-(r),y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 251: { // y:(r)-n,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 252: { // y:(r)+n,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 253: { // y:(r)-,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 254: { // y:(r)+,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 255: { // y:(r),y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 256: { // y:(r+n),y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 257: { // y:-(r),y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 258: { // x:(r)-n,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 259: { // x:(r)+n,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 260: { // x:(r)-,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 261: { // x:(r)+,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 262: { // x:(r),y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 263: { // x:(r+n),y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 264: { // x:-(r),y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 265: { // y:(r)-n,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 266: { // y:(r)+n,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 267: { // y:(r)-,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 268: { // y:(r)+,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 269: { // y:(r),y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 270: { // y:(r+n),y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 271: { // y:-(r),y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 272: { // x:(r)-n,a0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 273: { // x:(r)+n,a0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 274: { // x:(r)-,a0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 275: { // x:(r)+,a0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 276: { // x:(r),a0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 277: { // x:(r+n),a0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 278: { // x:-(r),a0
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 279: { // y:(r)-n,a0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 280: { // y:(r)+n,a0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 281: { // y:(r)-,a0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 282: { // y:(r)+,a0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 283: { // y:(r),a0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 284: { // y:(r+n),a0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 285: { // y:-(r),a0
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 286: { // x:(r)-n,b0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 287: { // x:(r)+n,b0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 288: { // x:(r)-,b0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 289: { // x:(r)+,b0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 290: { // x:(r),b0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 291: { // x:(r+n),b0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 292: { // x:-(r),b0
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 293: { // y:(r)-n,b0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 294: { // y:(r)+n,b0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 295: { // y:(r)-,b0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 296: { // y:(r)+,b0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 297: { // y:(r),b0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 298: { // y:(r+n),b0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 299: { // y:-(r),b0
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 300: { // x:(r)-n,a2
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 301: { // x:(r)+n,a2
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 302: { // x:(r)-,a2
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 303: { // x:(r)+,a2
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 304: { // x:(r),a2
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 305: { // x:(r+n),a2
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 306: { // x:-(r),a2
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 307: { // y:(r)-n,a2
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 308: { // y:(r)+n,a2
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 309: { // y:(r)-,a2
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 310: { // y:(r)+,a2
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 311: { // y:(r),a2
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 312: { // y:(r+n),a2
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 313: { // y:-(r),a2
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 314: { // x:(r)-n,b2
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 315: { // x:(r)+n,b2
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 316: { // x:(r)-,b2
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 317: { // x:(r)+,b2
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 318: { // x:(r),b2
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 319: { // x:(r+n),b2
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 320: { // x:-(r),b2
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 321: { // y:(r)-n,b2
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 322: { // y:(r)+n,b2
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 323: { // y:(r)-,b2
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 324: { // y:(r)+,b2
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 325: { // y:(r),b2
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 326: { // y:(r+n),b2
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 327: { // y:-(r),b2
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 328: { // x:(r)-n,a1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 329: { // x:(r)+n,a1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 330: { // x:(r)-,a1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 331: { // x:(r)+,a1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 332: { // x:(r),a1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 333: { // x:(r+n),a1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 334: { // x:-(r),a1
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 335: { // y:(r)-n,a1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 336: { // y:(r)+n,a1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 337: { // y:(r)-,a1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 338: { // y:(r)+,a1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 339: { // y:(r),a1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 340: { // y:(r+n),a1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 341: { // y:-(r),a1
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 342: { // x:(r)-n,b1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 343: { // x:(r)+n,b1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 344: { // x:(r)-,b1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 345: { // x:(r)+,b1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 346: { // x:(r),b1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 347: { // x:(r+n),b1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 348: { // x:-(r),b1
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 349: { // y:(r)-n,b1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 350: { // y:(r)+n,b1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 351: { // y:(r)-,b1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 352: { // y:(r)+,b1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 353: { // y:(r),b1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 354: { // y:(r+n),b1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 355: { // y:-(r),b1
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 356: { // x:(r)-n,a
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 357: { // x:(r)+n,a
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 358: { // x:(r)-,a
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 359: { // x:(r)+,a
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 360: { // x:(r),a
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 361: { // x:(r+n),a
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 362: { // x:-(r),a
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 363: { // y:(r)-n,a
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 364: { // y:(r)+n,a
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 365: { // y:(r)-,a
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 366: { // y:(r)+,a
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 367: { // y:(r),a
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 368: { // y:(r+n),a
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 369: { // y:-(r),a
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 370: { // x:(r)-n,b
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 371: { // x:(r)+n,b
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 372: { // x:(r)-,b
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 373: { // x:(r)+,b
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 374: { // x:(r),b
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 375: { // x:(r+n),b
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 376: { // x:-(r),b
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 377: { // y:(r)-n,b
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 378: { // y:(r)+n,b
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 379: { // y:(r)-,b
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 380: { // y:(r)+,b
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 381: { // y:(r),b
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 382: { // y:(r+n),b
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 383: { // y:-(r),b
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 384: { // x:(r)-n,r
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 385: { // x:(r)+n,r
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 386: { // x:(r)-,r
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 387: { // x:(r)+,r
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 388: { // x:(r),r
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 389: { // x:(r+n),r
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 390: { // x:-(r),r
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 391: { // y:(r)-n,r
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 392: { // y:(r)+n,r
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 393: { // y:(r)-,r
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 394: { // y:(r)+,r
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 395: { // y:(r),r
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 396: { // y:(r+n),r
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 397: { // y:-(r),r
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 398: { // x:(r)-n,n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 399: { // x:(r)+n,n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 400: { // x:(r)-,n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 401: { // x:(r)+,n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 402: { // x:(r),n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 403: { // x:(r+n),n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 404: { // x:-(r),n
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_tmp1 = m_x.read_dword(ea);
		break;
		}
	case 405: { // y:(r)-n,n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 406: { // y:(r)+n,n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 407: { // y:(r)-,n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 408: { // y:(r)+,n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 409: { // y:(r),n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 410: { // y:(r+n),n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 411: { // y:-(r),n
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_tmp1 = m_y.read_dword(ea);
		break;
		}
	case 412: { // x0,x:(r)-n
		u32 s = get_x0();
		m_tmp1 = s;
		break;
		}
	case 413: { // x0,x:(r)+n
		u32 s = get_x0();
		m_tmp1 = s;
		break;
		}
	case 414: { // x0,x:(r)-
		u32 s = get_x0();
		m_tmp1 = s;
		break;
		}
	case 415: { // x0,x:(r)+
		u32 s = get_x0();
		m_tmp1 = s;
		break;
		}
	case 416: { // x0,x:(r)
		u32 s = get_x0();
		m_tmp1 = s;
		break;
		}
	case 417: { // x0,x:(r+n)
		u32 s = get_x0();
		m_tmp1 = s;
		break;
		}
	case 418: { // x0,x:-(r)
		u32 s = get_x0();
		m_tmp1 = s;
		break;
		}
	case 419: { // x0,y:(r)-n
		u32 s = get_x0();
		m_tmp1 = s;
		break;
		}
	case 420: { // x0,y:(r)+n
		u32 s = get_x0();
		m_tmp1 = s;
		break;
		}
	case 421: { // x0,y:(r)-
		u32 s = get_x0();
		m_tmp1 = s;
		break;
		}
	case 422: { // x0,y:(r)+
		u32 s = get_x0();
		m_tmp1 = s;
		break;
		}
	case 423: { // x0,y:(r)
		u32 s = get_x0();
		m_tmp1 = s;
		break;
		}
	case 424: { // x0,y:(r+n)
		u32 s = get_x0();
		m_tmp1 = s;
		break;
		}
	case 425: { // x0,y:-(r)
		u32 s = get_x0();
		m_tmp1 = s;
		break;
		}
	case 426: { // x1,x:(r)-n
		u32 s = get_x1();
		m_tmp1 = s;
		break;
		}
	case 427: { // x1,x:(r)+n
		u32 s = get_x1();
		m_tmp1 = s;
		break;
		}
	case 428: { // x1,x:(r)-
		u32 s = get_x1();
		m_tmp1 = s;
		break;
		}
	case 429: { // x1,x:(r)+
		u32 s = get_x1();
		m_tmp1 = s;
		break;
		}
	case 430: { // x1,x:(r)
		u32 s = get_x1();
		m_tmp1 = s;
		break;
		}
	case 431: { // x1,x:(r+n)
		u32 s = get_x1();
		m_tmp1 = s;
		break;
		}
	case 432: { // x1,x:-(r)
		u32 s = get_x1();
		m_tmp1 = s;
		break;
		}
	case 433: { // x1,y:(r)-n
		u32 s = get_x1();
		m_tmp1 = s;
		break;
		}
	case 434: { // x1,y:(r)+n
		u32 s = get_x1();
		m_tmp1 = s;
		break;
		}
	case 435: { // x1,y:(r)-
		u32 s = get_x1();
		m_tmp1 = s;
		break;
		}
	case 436: { // x1,y:(r)+
		u32 s = get_x1();
		m_tmp1 = s;
		break;
		}
	case 437: { // x1,y:(r)
		u32 s = get_x1();
		m_tmp1 = s;
		break;
		}
	case 438: { // x1,y:(r+n)
		u32 s = get_x1();
		m_tmp1 = s;
		break;
		}
	case 439: { // x1,y:-(r)
		u32 s = get_x1();
		m_tmp1 = s;
		break;
		}
	case 440: { // y0,x:(r)-n
		u32 s = get_y0();
		m_tmp1 = s;
		break;
		}
	case 441: { // y0,x:(r)+n
		u32 s = get_y0();
		m_tmp1 = s;
		break;
		}
	case 442: { // y0,x:(r)-
		u32 s = get_y0();
		m_tmp1 = s;
		break;
		}
	case 443: { // y0,x:(r)+
		u32 s = get_y0();
		m_tmp1 = s;
		break;
		}
	case 444: { // y0,x:(r)
		u32 s = get_y0();
		m_tmp1 = s;
		break;
		}
	case 445: { // y0,x:(r+n)
		u32 s = get_y0();
		m_tmp1 = s;
		break;
		}
	case 446: { // y0,x:-(r)
		u32 s = get_y0();
		m_tmp1 = s;
		break;
		}
	case 447: { // y0,y:(r)-n
		u32 s = get_y0();
		m_tmp1 = s;
		break;
		}
	case 448: { // y0,y:(r)+n
		u32 s = get_y0();
		m_tmp1 = s;
		break;
		}
	case 449: { // y0,y:(r)-
		u32 s = get_y0();
		m_tmp1 = s;
		break;
		}
	case 450: { // y0,y:(r)+
		u32 s = get_y0();
		m_tmp1 = s;
		break;
		}
	case 451: { // y0,y:(r)
		u32 s = get_y0();
		m_tmp1 = s;
		break;
		}
	case 452: { // y0,y:(r+n)
		u32 s = get_y0();
		m_tmp1 = s;
		break;
		}
	case 453: { // y0,y:-(r)
		u32 s = get_y0();
		m_tmp1 = s;
		break;
		}
	case 454: { // y1,x:(r)-n
		u32 s = get_y1();
		m_tmp1 = s;
		break;
		}
	case 455: { // y1,x:(r)+n
		u32 s = get_y1();
		m_tmp1 = s;
		break;
		}
	case 456: { // y1,x:(r)-
		u32 s = get_y1();
		m_tmp1 = s;
		break;
		}
	case 457: { // y1,x:(r)+
		u32 s = get_y1();
		m_tmp1 = s;
		break;
		}
	case 458: { // y1,x:(r)
		u32 s = get_y1();
		m_tmp1 = s;
		break;
		}
	case 459: { // y1,x:(r+n)
		u32 s = get_y1();
		m_tmp1 = s;
		break;
		}
	case 460: { // y1,x:-(r)
		u32 s = get_y1();
		m_tmp1 = s;
		break;
		}
	case 461: { // y1,y:(r)-n
		u32 s = get_y1();
		m_tmp1 = s;
		break;
		}
	case 462: { // y1,y:(r)+n
		u32 s = get_y1();
		m_tmp1 = s;
		break;
		}
	case 463: { // y1,y:(r)-
		u32 s = get_y1();
		m_tmp1 = s;
		break;
		}
	case 464: { // y1,y:(r)+
		u32 s = get_y1();
		m_tmp1 = s;
		break;
		}
	case 465: { // y1,y:(r)
		u32 s = get_y1();
		m_tmp1 = s;
		break;
		}
	case 466: { // y1,y:(r+n)
		u32 s = get_y1();
		m_tmp1 = s;
		break;
		}
	case 467: { // y1,y:-(r)
		u32 s = get_y1();
		m_tmp1 = s;
		break;
		}
	case 468: { // a0,x:(r)-n
		u32 s = get_a0();
		m_tmp1 = s;
		break;
		}
	case 469: { // a0,x:(r)+n
		u32 s = get_a0();
		m_tmp1 = s;
		break;
		}
	case 470: { // a0,x:(r)-
		u32 s = get_a0();
		m_tmp1 = s;
		break;
		}
	case 471: { // a0,x:(r)+
		u32 s = get_a0();
		m_tmp1 = s;
		break;
		}
	case 472: { // a0,x:(r)
		u32 s = get_a0();
		m_tmp1 = s;
		break;
		}
	case 473: { // a0,x:(r+n)
		u32 s = get_a0();
		m_tmp1 = s;
		break;
		}
	case 474: { // a0,x:-(r)
		u32 s = get_a0();
		m_tmp1 = s;
		break;
		}
	case 475: { // a0,y:(r)-n
		u32 s = get_a0();
		m_tmp1 = s;
		break;
		}
	case 476: { // a0,y:(r)+n
		u32 s = get_a0();
		m_tmp1 = s;
		break;
		}
	case 477: { // a0,y:(r)-
		u32 s = get_a0();
		m_tmp1 = s;
		break;
		}
	case 478: { // a0,y:(r)+
		u32 s = get_a0();
		m_tmp1 = s;
		break;
		}
	case 479: { // a0,y:(r)
		u32 s = get_a0();
		m_tmp1 = s;
		break;
		}
	case 480: { // a0,y:(r+n)
		u32 s = get_a0();
		m_tmp1 = s;
		break;
		}
	case 481: { // a0,y:-(r)
		u32 s = get_a0();
		m_tmp1 = s;
		break;
		}
	case 482: { // b0,x:(r)-n
		u32 s = get_b0();
		m_tmp1 = s;
		break;
		}
	case 483: { // b0,x:(r)+n
		u32 s = get_b0();
		m_tmp1 = s;
		break;
		}
	case 484: { // b0,x:(r)-
		u32 s = get_b0();
		m_tmp1 = s;
		break;
		}
	case 485: { // b0,x:(r)+
		u32 s = get_b0();
		m_tmp1 = s;
		break;
		}
	case 486: { // b0,x:(r)
		u32 s = get_b0();
		m_tmp1 = s;
		break;
		}
	case 487: { // b0,x:(r+n)
		u32 s = get_b0();
		m_tmp1 = s;
		break;
		}
	case 488: { // b0,x:-(r)
		u32 s = get_b0();
		m_tmp1 = s;
		break;
		}
	case 489: { // b0,y:(r)-n
		u32 s = get_b0();
		m_tmp1 = s;
		break;
		}
	case 490: { // b0,y:(r)+n
		u32 s = get_b0();
		m_tmp1 = s;
		break;
		}
	case 491: { // b0,y:(r)-
		u32 s = get_b0();
		m_tmp1 = s;
		break;
		}
	case 492: { // b0,y:(r)+
		u32 s = get_b0();
		m_tmp1 = s;
		break;
		}
	case 493: { // b0,y:(r)
		u32 s = get_b0();
		m_tmp1 = s;
		break;
		}
	case 494: { // b0,y:(r+n)
		u32 s = get_b0();
		m_tmp1 = s;
		break;
		}
	case 495: { // b0,y:-(r)
		u32 s = get_b0();
		m_tmp1 = s;
		break;
		}
	case 496: { // a2,x:(r)-n
		u32 s = get_a2();
		m_tmp1 = s;
		break;
		}
	case 497: { // a2,x:(r)+n
		u32 s = get_a2();
		m_tmp1 = s;
		break;
		}
	case 498: { // a2,x:(r)-
		u32 s = get_a2();
		m_tmp1 = s;
		break;
		}
	case 499: { // a2,x:(r)+
		u32 s = get_a2();
		m_tmp1 = s;
		break;
		}
	case 500: { // a2,x:(r)
		u32 s = get_a2();
		m_tmp1 = s;
		break;
		}
	case 501: { // a2,x:(r+n)
		u32 s = get_a2();
		m_tmp1 = s;
		break;
		}
	case 502: { // a2,x:-(r)
		u32 s = get_a2();
		m_tmp1 = s;
		break;
		}
	case 503: { // a2,y:(r)-n
		u32 s = get_a2();
		m_tmp1 = s;
		break;
		}
	case 504: { // a2,y:(r)+n
		u32 s = get_a2();
		m_tmp1 = s;
		break;
		}
	case 505: { // a2,y:(r)-
		u32 s = get_a2();
		m_tmp1 = s;
		break;
		}
	case 506: { // a2,y:(r)+
		u32 s = get_a2();
		m_tmp1 = s;
		break;
		}
	case 507: { // a2,y:(r)
		u32 s = get_a2();
		m_tmp1 = s;
		break;
		}
	case 508: { // a2,y:(r+n)
		u32 s = get_a2();
		m_tmp1 = s;
		break;
		}
	case 509: { // a2,y:-(r)
		u32 s = get_a2();
		m_tmp1 = s;
		break;
		}
	case 510: { // b2,x:(r)-n
		u32 s = get_b2();
		m_tmp1 = s;
		break;
		}
	case 511: { // b2,x:(r)+n
		u32 s = get_b2();
		m_tmp1 = s;
		break;
		}
	case 512: { // b2,x:(r)-
		u32 s = get_b2();
		m_tmp1 = s;
		break;
		}
	case 513: { // b2,x:(r)+
		u32 s = get_b2();
		m_tmp1 = s;
		break;
		}
	case 514: { // b2,x:(r)
		u32 s = get_b2();
		m_tmp1 = s;
		break;
		}
	case 515: { // b2,x:(r+n)
		u32 s = get_b2();
		m_tmp1 = s;
		break;
		}
	case 516: { // b2,x:-(r)
		u32 s = get_b2();
		m_tmp1 = s;
		break;
		}
	case 517: { // b2,y:(r)-n
		u32 s = get_b2();
		m_tmp1 = s;
		break;
		}
	case 518: { // b2,y:(r)+n
		u32 s = get_b2();
		m_tmp1 = s;
		break;
		}
	case 519: { // b2,y:(r)-
		u32 s = get_b2();
		m_tmp1 = s;
		break;
		}
	case 520: { // b2,y:(r)+
		u32 s = get_b2();
		m_tmp1 = s;
		break;
		}
	case 521: { // b2,y:(r)
		u32 s = get_b2();
		m_tmp1 = s;
		break;
		}
	case 522: { // b2,y:(r+n)
		u32 s = get_b2();
		m_tmp1 = s;
		break;
		}
	case 523: { // b2,y:-(r)
		u32 s = get_b2();
		m_tmp1 = s;
		break;
		}
	case 524: { // a1,x:(r)-n
		u32 s = get_a1();
		m_tmp1 = s;
		break;
		}
	case 525: { // a1,x:(r)+n
		u32 s = get_a1();
		m_tmp1 = s;
		break;
		}
	case 526: { // a1,x:(r)-
		u32 s = get_a1();
		m_tmp1 = s;
		break;
		}
	case 527: { // a1,x:(r)+
		u32 s = get_a1();
		m_tmp1 = s;
		break;
		}
	case 528: { // a1,x:(r)
		u32 s = get_a1();
		m_tmp1 = s;
		break;
		}
	case 529: { // a1,x:(r+n)
		u32 s = get_a1();
		m_tmp1 = s;
		break;
		}
	case 530: { // a1,x:-(r)
		u32 s = get_a1();
		m_tmp1 = s;
		break;
		}
	case 531: { // a1,y:(r)-n
		u32 s = get_a1();
		m_tmp1 = s;
		break;
		}
	case 532: { // a1,y:(r)+n
		u32 s = get_a1();
		m_tmp1 = s;
		break;
		}
	case 533: { // a1,y:(r)-
		u32 s = get_a1();
		m_tmp1 = s;
		break;
		}
	case 534: { // a1,y:(r)+
		u32 s = get_a1();
		m_tmp1 = s;
		break;
		}
	case 535: { // a1,y:(r)
		u32 s = get_a1();
		m_tmp1 = s;
		break;
		}
	case 536: { // a1,y:(r+n)
		u32 s = get_a1();
		m_tmp1 = s;
		break;
		}
	case 537: { // a1,y:-(r)
		u32 s = get_a1();
		m_tmp1 = s;
		break;
		}
	case 538: { // b1,x:(r)-n
		u32 s = get_b1();
		m_tmp1 = s;
		break;
		}
	case 539: { // b1,x:(r)+n
		u32 s = get_b1();
		m_tmp1 = s;
		break;
		}
	case 540: { // b1,x:(r)-
		u32 s = get_b1();
		m_tmp1 = s;
		break;
		}
	case 541: { // b1,x:(r)+
		u32 s = get_b1();
		m_tmp1 = s;
		break;
		}
	case 542: { // b1,x:(r)
		u32 s = get_b1();
		m_tmp1 = s;
		break;
		}
	case 543: { // b1,x:(r+n)
		u32 s = get_b1();
		m_tmp1 = s;
		break;
		}
	case 544: { // b1,x:-(r)
		u32 s = get_b1();
		m_tmp1 = s;
		break;
		}
	case 545: { // b1,y:(r)-n
		u32 s = get_b1();
		m_tmp1 = s;
		break;
		}
	case 546: { // b1,y:(r)+n
		u32 s = get_b1();
		m_tmp1 = s;
		break;
		}
	case 547: { // b1,y:(r)-
		u32 s = get_b1();
		m_tmp1 = s;
		break;
		}
	case 548: { // b1,y:(r)+
		u32 s = get_b1();
		m_tmp1 = s;
		break;
		}
	case 549: { // b1,y:(r)
		u32 s = get_b1();
		m_tmp1 = s;
		break;
		}
	case 550: { // b1,y:(r+n)
		u32 s = get_b1();
		m_tmp1 = s;
		break;
		}
	case 551: { // b1,y:-(r)
		u32 s = get_b1();
		m_tmp1 = s;
		break;
		}
	case 552: { // a,x:(r)-n
		u32 s_h = get_ah();
		m_tmp1 = s_h;
		break;
		}
	case 553: { // a,x:(r)+n
		u32 s_h = get_ah();
		m_tmp1 = s_h;
		break;
		}
	case 554: { // a,x:(r)-
		u32 s_h = get_ah();
		m_tmp1 = s_h;
		break;
		}
	case 555: { // a,x:(r)+
		u32 s_h = get_ah();
		m_tmp1 = s_h;
		break;
		}
	case 556: { // a,x:(r)
		u32 s_h = get_ah();
		m_tmp1 = s_h;
		break;
		}
	case 557: { // a,x:(r+n)
		u32 s_h = get_ah();
		m_tmp1 = s_h;
		break;
		}
	case 558: { // a,x:-(r)
		u32 s_h = get_ah();
		m_tmp1 = s_h;
		break;
		}
	case 559: { // a,y:(r)-n
		u32 s_h = get_ah();
		m_tmp1 = s_h;
		break;
		}
	case 560: { // a,y:(r)+n
		u32 s_h = get_ah();
		m_tmp1 = s_h;
		break;
		}
	case 561: { // a,y:(r)-
		u32 s_h = get_ah();
		m_tmp1 = s_h;
		break;
		}
	case 562: { // a,y:(r)+
		u32 s_h = get_ah();
		m_tmp1 = s_h;
		break;
		}
	case 563: { // a,y:(r)
		u32 s_h = get_ah();
		m_tmp1 = s_h;
		break;
		}
	case 564: { // a,y:(r+n)
		u32 s_h = get_ah();
		m_tmp1 = s_h;
		break;
		}
	case 565: { // a,y:-(r)
		u32 s_h = get_ah();
		m_tmp1 = s_h;
		break;
		}
	case 566: { // b,x:(r)-n
		u32 s_h = get_bh();
		m_tmp1 = s_h;
		break;
		}
	case 567: { // b,x:(r)+n
		u32 s_h = get_bh();
		m_tmp1 = s_h;
		break;
		}
	case 568: { // b,x:(r)-
		u32 s_h = get_bh();
		m_tmp1 = s_h;
		break;
		}
	case 569: { // b,x:(r)+
		u32 s_h = get_bh();
		m_tmp1 = s_h;
		break;
		}
	case 570: { // b,x:(r)
		u32 s_h = get_bh();
		m_tmp1 = s_h;
		break;
		}
	case 571: { // b,x:(r+n)
		u32 s_h = get_bh();
		m_tmp1 = s_h;
		break;
		}
	case 572: { // b,x:-(r)
		u32 s_h = get_bh();
		m_tmp1 = s_h;
		break;
		}
	case 573: { // b,y:(r)-n
		u32 s_h = get_bh();
		m_tmp1 = s_h;
		break;
		}
	case 574: { // b,y:(r)+n
		u32 s_h = get_bh();
		m_tmp1 = s_h;
		break;
		}
	case 575: { // b,y:(r)-
		u32 s_h = get_bh();
		m_tmp1 = s_h;
		break;
		}
	case 576: { // b,y:(r)+
		u32 s_h = get_bh();
		m_tmp1 = s_h;
		break;
		}
	case 577: { // b,y:(r)
		u32 s_h = get_bh();
		m_tmp1 = s_h;
		break;
		}
	case 578: { // b,y:(r+n)
		u32 s_h = get_bh();
		m_tmp1 = s_h;
		break;
		}
	case 579: { // b,y:-(r)
		u32 s_h = get_bh();
		m_tmp1 = s_h;
		break;
		}
	case 580: { // r,x:(r)-n
		u32 s = get_r(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7);
		m_tmp1 = s;
		break;
		}
	case 581: { // r,x:(r)+n
		u32 s = get_r(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7);
		m_tmp1 = s;
		break;
		}
	case 582: { // r,x:(r)-
		u32 s = get_r(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7);
		m_tmp1 = s;
		break;
		}
	case 583: { // r,x:(r)+
		u32 s = get_r(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7);
		m_tmp1 = s;
		break;
		}
	case 584: { // r,x:(r)
		u32 s = get_r(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7);
		m_tmp1 = s;
		break;
		}
	case 585: { // r,x:(r+n)
		u32 s = get_r(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7);
		m_tmp1 = s;
		break;
		}
	case 586: { // r,x:-(r)
		u32 s = get_r(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7);
		m_tmp1 = s;
		break;
		}
	case 587: { // r,y:(r)-n
		u32 s = get_r(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7);
		m_tmp1 = s;
		break;
		}
	case 588: { // r,y:(r)+n
		u32 s = get_r(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7);
		m_tmp1 = s;
		break;
		}
	case 589: { // r,y:(r)-
		u32 s = get_r(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7);
		m_tmp1 = s;
		break;
		}
	case 590: { // r,y:(r)+
		u32 s = get_r(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7);
		m_tmp1 = s;
		break;
		}
	case 591: { // r,y:(r)
		u32 s = get_r(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7);
		m_tmp1 = s;
		break;
		}
	case 592: { // r,y:(r+n)
		u32 s = get_r(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7);
		m_tmp1 = s;
		break;
		}
	case 593: { // r,y:-(r)
		u32 s = get_r(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7);
		m_tmp1 = s;
		break;
		}
	case 594: { // n,x:(r)-n
		u32 s = get_n(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7);
		m_tmp1 = s;
		break;
		}
	case 595: { // n,x:(r)+n
		u32 s = get_n(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7);
		m_tmp1 = s;
		break;
		}
	case 596: { // n,x:(r)-
		u32 s = get_n(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7);
		m_tmp1 = s;
		break;
		}
	case 597: { // n,x:(r)+
		u32 s = get_n(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7);
		m_tmp1 = s;
		break;
		}
	case 598: { // n,x:(r)
		u32 s = get_n(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7);
		m_tmp1 = s;
		break;
		}
	case 599: { // n,x:(r+n)
		u32 s = get_n(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7);
		m_tmp1 = s;
		break;
		}
	case 600: { // n,x:-(r)
		u32 s = get_n(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7);
		m_tmp1 = s;
		break;
		}
	case 601: { // n,y:(r)-n
		u32 s = get_n(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7);
		m_tmp1 = s;
		break;
		}
	case 602: { // n,y:(r)+n
		u32 s = get_n(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7);
		m_tmp1 = s;
		break;
		}
	case 603: { // n,y:(r)-
		u32 s = get_n(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7);
		m_tmp1 = s;
		break;
		}
	case 604: { // n,y:(r)+
		u32 s = get_n(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7);
		m_tmp1 = s;
		break;
		}
	case 605: { // n,y:(r)
		u32 s = get_n(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7);
		m_tmp1 = s;
		break;
		}
	case 606: { // n,y:(r+n)
		u32 s = get_n(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7);
		m_tmp1 = s;
		break;
		}
	case 607: { // n,y:-(r)
		u32 s = get_n(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7);
		m_tmp1 = s;
		break;
		}
	case 608: { // x:[abs],x0
		u32 abs = exv;
		m_tmp1 = m_x.read_dword(abs);
		break;
		}
	case 609: { // y:[abs],x0
		u32 abs = exv;
		m_tmp1 = m_y.read_dword(abs);
		break;
		}
	case 610: { // x:[abs],x1
		u32 abs = exv;
		m_tmp1 = m_x.read_dword(abs);
		break;
		}
	case 611: { // y:[abs],x1
		u32 abs = exv;
		m_tmp1 = m_y.read_dword(abs);
		break;
		}
	case 612: { // x:[abs],y0
		u32 abs = exv;
		m_tmp1 = m_x.read_dword(abs);
		break;
		}
	case 613: { // y:[abs],y0
		u32 abs = exv;
		m_tmp1 = m_y.read_dword(abs);
		break;
		}
	case 614: { // x:[abs],y1
		u32 abs = exv;
		m_tmp1 = m_x.read_dword(abs);
		break;
		}
	case 615: { // y:[abs],y1
		u32 abs = exv;
		m_tmp1 = m_y.read_dword(abs);
		break;
		}
	case 616: { // x:[abs],a0
		u32 abs = exv;
		m_tmp1 = m_x.read_dword(abs);
		break;
		}
	case 617: { // y:[abs],a0
		u32 abs = exv;
		m_tmp1 = m_y.read_dword(abs);
		break;
		}
	case 618: { // x:[abs],b0
		u32 abs = exv;
		m_tmp1 = m_x.read_dword(abs);
		break;
		}
	case 619: { // y:[abs],b0
		u32 abs = exv;
		m_tmp1 = m_y.read_dword(abs);
		break;
		}
	case 620: { // x:[abs],a2
		u32 abs = exv;
		m_tmp1 = m_x.read_dword(abs);
		break;
		}
	case 621: { // y:[abs],a2
		u32 abs = exv;
		m_tmp1 = m_y.read_dword(abs);
		break;
		}
	case 622: { // x:[abs],b2
		u32 abs = exv;
		m_tmp1 = m_x.read_dword(abs);
		break;
		}
	case 623: { // y:[abs],b2
		u32 abs = exv;
		m_tmp1 = m_y.read_dword(abs);
		break;
		}
	case 624: { // x:[abs],a1
		u32 abs = exv;
		m_tmp1 = m_x.read_dword(abs);
		break;
		}
	case 625: { // y:[abs],a1
		u32 abs = exv;
		m_tmp1 = m_y.read_dword(abs);
		break;
		}
	case 626: { // x:[abs],b1
		u32 abs = exv;
		m_tmp1 = m_x.read_dword(abs);
		break;
		}
	case 627: { // y:[abs],b1
		u32 abs = exv;
		m_tmp1 = m_y.read_dword(abs);
		break;
		}
	case 628: { // x:[abs],a
		u32 abs = exv;
		m_tmp1 = m_x.read_dword(abs);
		break;
		}
	case 629: { // y:[abs],a
		u32 abs = exv;
		m_tmp1 = m_y.read_dword(abs);
		break;
		}
	case 630: { // x:[abs],b
		u32 abs = exv;
		m_tmp1 = m_x.read_dword(abs);
		break;
		}
	case 631: { // y:[abs],b
		u32 abs = exv;
		m_tmp1 = m_y.read_dword(abs);
		break;
		}
	case 632: { // x:[abs],r
		u32 abs = exv;
		m_tmp1 = m_x.read_dword(abs);
		break;
		}
	case 633: { // y:[abs],r
		u32 abs = exv;
		m_tmp1 = m_y.read_dword(abs);
		break;
		}
	case 634: { // x:[abs],n
		u32 abs = exv;
		m_tmp1 = m_x.read_dword(abs);
		break;
		}
	case 635: { // y:[abs],n
		u32 abs = exv;
		m_tmp1 = m_y.read_dword(abs);
		break;
		}
	case 636: { // x0,x:[abs]
		u32 s = get_x0();
		m_tmp1 = s;
		break;
		}
	case 637: { // x0,y:[abs]
		u32 s = get_x0();
		m_tmp1 = s;
		break;
		}
	case 638: { // x1,x:[abs]
		u32 s = get_x1();
		m_tmp1 = s;
		break;
		}
	case 639: { // x1,y:[abs]
		u32 s = get_x1();
		m_tmp1 = s;
		break;
		}
	case 640: { // y0,x:[abs]
		u32 s = get_y0();
		m_tmp1 = s;
		break;
		}
	case 641: { // y0,y:[abs]
		u32 s = get_y0();
		m_tmp1 = s;
		break;
		}
	case 642: { // y1,x:[abs]
		u32 s = get_y1();
		m_tmp1 = s;
		break;
		}
	case 643: { // y1,y:[abs]
		u32 s = get_y1();
		m_tmp1 = s;
		break;
		}
	case 644: { // a0,x:[abs]
		u32 s = get_a0();
		m_tmp1 = s;
		break;
		}
	case 645: { // a0,y:[abs]
		u32 s = get_a0();
		m_tmp1 = s;
		break;
		}
	case 646: { // b0,x:[abs]
		u32 s = get_b0();
		m_tmp1 = s;
		break;
		}
	case 647: { // b0,y:[abs]
		u32 s = get_b0();
		m_tmp1 = s;
		break;
		}
	case 648: { // a2,x:[abs]
		u32 s = get_a2();
		m_tmp1 = s;
		break;
		}
	case 649: { // a2,y:[abs]
		u32 s = get_a2();
		m_tmp1 = s;
		break;
		}
	case 650: { // b2,x:[abs]
		u32 s = get_b2();
		m_tmp1 = s;
		break;
		}
	case 651: { // b2,y:[abs]
		u32 s = get_b2();
		m_tmp1 = s;
		break;
		}
	case 652: { // a1,x:[abs]
		u32 s = get_a1();
		m_tmp1 = s;
		break;
		}
	case 653: { // a1,y:[abs]
		u32 s = get_a1();
		m_tmp1 = s;
		break;
		}
	case 654: { // b1,x:[abs]
		u32 s = get_b1();
		m_tmp1 = s;
		break;
		}
	case 655: { // b1,y:[abs]
		u32 s = get_b1();
		m_tmp1 = s;
		break;
		}
	case 656: { // a,x:[abs]
		u32 s_h = get_ah();
		m_tmp1 = s_h;
		break;
		}
	case 657: { // a,y:[abs]
		u32 s_h = get_ah();
		m_tmp1 = s_h;
		break;
		}
	case 658: { // b,x:[abs]
		u32 s_h = get_bh();
		m_tmp1 = s_h;
		break;
		}
	case 659: { // b,y:[abs]
		u32 s_h = get_bh();
		m_tmp1 = s_h;
		break;
		}
	case 660: { // r,x:[abs]
		u32 s = get_r(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7);
		m_tmp1 = s;
		break;
		}
	case 661: { // r,y:[abs]
		u32 s = get_r(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7);
		m_tmp1 = s;
		break;
		}
	case 662: { // n,x:[abs]
		u32 s = get_n(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7);
		m_tmp1 = s;
		break;
		}
	case 663: { // n,y:[abs]
		u32 s = get_n(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7);
		m_tmp1 = s;
		break;
		}
	case 664: { // #[i],x0
		break;
		}
	case 665: { // #[i],x1
		break;
		}
	case 666: { // #[i],y0
		break;
		}
	case 667: { // #[i],y1
		break;
		}
	case 668: { // #[i],a0
		break;
		}
	case 669: { // #[i],b0
		break;
		}
	case 670: { // #[i],a2
		break;
		}
	case 671: { // #[i],b2
		break;
		}
	case 672: { // #[i],a1
		break;
		}
	case 673: { // #[i],b1
		break;
		}
	case 674: { // #[i],a
		break;
		}
	case 675: { // #[i],b
		break;
		}
	case 676: { // #[i],r
		break;
		}
	case 677: { // #[i],n
		break;
		}
	case 678: { // #[i],x0
		break;
		}
	case 679: { // #[i],x1
		break;
		}
	case 680: { // #[i],y0
		break;
		}
	case 681: { // #[i],y1
		break;
		}
	case 682: { // #[i],a0
		break;
		}
	case 683: { // #[i],b0
		break;
		}
	case 684: { // #[i],a2
		break;
		}
	case 685: { // #[i],b2
		break;
		}
	case 686: { // #[i],a1
		break;
		}
	case 687: { // #[i],b1
		break;
		}
	case 688: { // #[i],a
		break;
		}
	case 689: { // #[i],b
		break;
		}
	case 690: { // #[i],r
		break;
		}
	case 691: { // #[i],n
		break;
		}
	case 692: { // x:[aa],x0
		u32 aa = BIT(opcode, 8, 6);
		m_tmp1 = m_x.read_dword(aa);
		break;
		}
	case 693: { // y:[aa],x0
		u32 aa = BIT(opcode, 8, 6);
		m_tmp1 = m_y.read_dword(aa);
		break;
		}
	case 694: { // x:[aa],x1
		u32 aa = BIT(opcode, 8, 6);
		m_tmp1 = m_x.read_dword(aa);
		break;
		}
	case 695: { // y:[aa],x1
		u32 aa = BIT(opcode, 8, 6);
		m_tmp1 = m_y.read_dword(aa);
		break;
		}
	case 696: { // x:[aa],y0
		u32 aa = BIT(opcode, 8, 6);
		m_tmp1 = m_x.read_dword(aa);
		break;
		}
	case 697: { // y:[aa],y0
		u32 aa = BIT(opcode, 8, 6);
		m_tmp1 = m_y.read_dword(aa);
		break;
		}
	case 698: { // x:[aa],y1
		u32 aa = BIT(opcode, 8, 6);
		m_tmp1 = m_x.read_dword(aa);
		break;
		}
	case 699: { // y:[aa],y1
		u32 aa = BIT(opcode, 8, 6);
		m_tmp1 = m_y.read_dword(aa);
		break;
		}
	case 700: { // x:[aa],a0
		u32 aa = BIT(opcode, 8, 6);
		m_tmp1 = m_x.read_dword(aa);
		break;
		}
	case 701: { // y:[aa],a0
		u32 aa = BIT(opcode, 8, 6);
		m_tmp1 = m_y.read_dword(aa);
		break;
		}
	case 702: { // x:[aa],b0
		u32 aa = BIT(opcode, 8, 6);
		m_tmp1 = m_x.read_dword(aa);
		break;
		}
	case 703: { // y:[aa],b0
		u32 aa = BIT(opcode, 8, 6);
		m_tmp1 = m_y.read_dword(aa);
		break;
		}
	case 704: { // x:[aa],a2
		u32 aa = BIT(opcode, 8, 6);
		m_tmp1 = m_x.read_dword(aa);
		break;
		}
	case 705: { // y:[aa],a2
		u32 aa = BIT(opcode, 8, 6);
		m_tmp1 = m_y.read_dword(aa);
		break;
		}
	case 706: { // x:[aa],b2
		u32 aa = BIT(opcode, 8, 6);
		m_tmp1 = m_x.read_dword(aa);
		break;
		}
	case 707: { // y:[aa],b2
		u32 aa = BIT(opcode, 8, 6);
		m_tmp1 = m_y.read_dword(aa);
		break;
		}
	case 708: { // x:[aa],a1
		u32 aa = BIT(opcode, 8, 6);
		m_tmp1 = m_x.read_dword(aa);
		break;
		}
	case 709: { // y:[aa],a1
		u32 aa = BIT(opcode, 8, 6);
		m_tmp1 = m_y.read_dword(aa);
		break;
		}
	case 710: { // x:[aa],b1
		u32 aa = BIT(opcode, 8, 6);
		m_tmp1 = m_x.read_dword(aa);
		break;
		}
	case 711: { // y:[aa],b1
		u32 aa = BIT(opcode, 8, 6);
		m_tmp1 = m_y.read_dword(aa);
		break;
		}
	case 712: { // x:[aa],a
		u32 aa = BIT(opcode, 8, 6);
		m_tmp1 = m_x.read_dword(aa);
		break;
		}
	case 713: { // y:[aa],a
		u32 aa = BIT(opcode, 8, 6);
		m_tmp1 = m_y.read_dword(aa);
		break;
		}
	case 714: { // x:[aa],b
		u32 aa = BIT(opcode, 8, 6);
		m_tmp1 = m_x.read_dword(aa);
		break;
		}
	case 715: { // y:[aa],b
		u32 aa = BIT(opcode, 8, 6);
		m_tmp1 = m_y.read_dword(aa);
		break;
		}
	case 716: { // x:[aa],r
		u32 aa = BIT(opcode, 8, 6);
		m_tmp1 = m_x.read_dword(aa);
		break;
		}
	case 717: { // y:[aa],r
		u32 aa = BIT(opcode, 8, 6);
		m_tmp1 = m_y.read_dword(aa);
		break;
		}
	case 718: { // x:[aa],n
		u32 aa = BIT(opcode, 8, 6);
		m_tmp1 = m_x.read_dword(aa);
		break;
		}
	case 719: { // y:[aa],n
		u32 aa = BIT(opcode, 8, 6);
		m_tmp1 = m_y.read_dword(aa);
		break;
		}
	case 720: { // x0,x:[aa]
		u32 s = get_x0();
		m_tmp1 = s;
		break;
		}
	case 721: { // x0,y:[aa]
		u32 s = get_x0();
		m_tmp1 = s;
		break;
		}
	case 722: { // x1,x:[aa]
		u32 s = get_x1();
		m_tmp1 = s;
		break;
		}
	case 723: { // x1,y:[aa]
		u32 s = get_x1();
		m_tmp1 = s;
		break;
		}
	case 724: { // y0,x:[aa]
		u32 s = get_y0();
		m_tmp1 = s;
		break;
		}
	case 725: { // y0,y:[aa]
		u32 s = get_y0();
		m_tmp1 = s;
		break;
		}
	case 726: { // y1,x:[aa]
		u32 s = get_y1();
		m_tmp1 = s;
		break;
		}
	case 727: { // y1,y:[aa]
		u32 s = get_y1();
		m_tmp1 = s;
		break;
		}
	case 728: { // a0,x:[aa]
		u32 s = get_a0();
		m_tmp1 = s;
		break;
		}
	case 729: { // a0,y:[aa]
		u32 s = get_a0();
		m_tmp1 = s;
		break;
		}
	case 730: { // b0,x:[aa]
		u32 s = get_b0();
		m_tmp1 = s;
		break;
		}
	case 731: { // b0,y:[aa]
		u32 s = get_b0();
		m_tmp1 = s;
		break;
		}
	case 732: { // a2,x:[aa]
		u32 s = get_a2();
		m_tmp1 = s;
		break;
		}
	case 733: { // a2,y:[aa]
		u32 s = get_a2();
		m_tmp1 = s;
		break;
		}
	case 734: { // b2,x:[aa]
		u32 s = get_b2();
		m_tmp1 = s;
		break;
		}
	case 735: { // b2,y:[aa]
		u32 s = get_b2();
		m_tmp1 = s;
		break;
		}
	case 736: { // a1,x:[aa]
		u32 s = get_a1();
		m_tmp1 = s;
		break;
		}
	case 737: { // a1,y:[aa]
		u32 s = get_a1();
		m_tmp1 = s;
		break;
		}
	case 738: { // b1,x:[aa]
		u32 s = get_b1();
		m_tmp1 = s;
		break;
		}
	case 739: { // b1,y:[aa]
		u32 s = get_b1();
		m_tmp1 = s;
		break;
		}
	case 740: { // a,x:[aa]
		u32 s_h = get_ah();
		m_tmp1 = s_h;
		break;
		}
	case 741: { // a,y:[aa]
		u32 s_h = get_ah();
		m_tmp1 = s_h;
		break;
		}
	case 742: { // b,x:[aa]
		u32 s_h = get_bh();
		m_tmp1 = s_h;
		break;
		}
	case 743: { // b,y:[aa]
		u32 s_h = get_bh();
		m_tmp1 = s_h;
		break;
		}
	case 744: { // r,x:[aa]
		u32 s = get_r(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7);
		m_tmp1 = s;
		break;
		}
	case 745: { // r,y:[aa]
		u32 s = get_r(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7);
		m_tmp1 = s;
		break;
		}
	case 746: { // n,x:[aa]
		u32 s = get_n(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7);
		m_tmp1 = s;
		break;
		}
	case 747: { // n,y:[aa]
		u32 s = get_n(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7);
		m_tmp1 = s;
		break;
		}
	case 748: { // x:(r)-n,x0 a,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s2_h = get_ah();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 749: { // x:(r)+n,x0 a,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s2_h = get_ah();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 750: { // x:(r)-,x0 a,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s2_h = get_ah();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 751: { // x:(r)+,x0 a,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 s2_h = get_ah();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 752: { // x:(r),x0 a,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		u32 s2_h = get_ah();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 753: { // x:(r+n),x0 a,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		u32 s2_h = get_ah();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 754: { // x:-(r),x0 a,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		u32 s2_h = get_ah();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 755: { // x:(r)-n,x0 a,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s2_h = get_ah();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 756: { // x:(r)+n,x0 a,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s2_h = get_ah();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 757: { // x:(r)-,x0 a,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s2_h = get_ah();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 758: { // x:(r)+,x0 a,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 s2_h = get_ah();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 759: { // x:(r),x0 a,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		u32 s2_h = get_ah();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 760: { // x:(r+n),x0 a,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		u32 s2_h = get_ah();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 761: { // x:-(r),x0 a,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		u32 s2_h = get_ah();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 762: { // x:(r)-n,x0 b,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s2_h = get_bh();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 763: { // x:(r)+n,x0 b,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s2_h = get_bh();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 764: { // x:(r)-,x0 b,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s2_h = get_bh();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 765: { // x:(r)+,x0 b,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 s2_h = get_bh();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 766: { // x:(r),x0 b,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		u32 s2_h = get_bh();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 767: { // x:(r+n),x0 b,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		u32 s2_h = get_bh();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 768: { // x:-(r),x0 b,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		u32 s2_h = get_bh();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 769: { // x:(r)-n,x0 b,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s2_h = get_bh();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 770: { // x:(r)+n,x0 b,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s2_h = get_bh();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 771: { // x:(r)-,x0 b,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s2_h = get_bh();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 772: { // x:(r)+,x0 b,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 s2_h = get_bh();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 773: { // x:(r),x0 b,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		u32 s2_h = get_bh();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 774: { // x:(r+n),x0 b,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		u32 s2_h = get_bh();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 775: { // x:-(r),x0 b,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		u32 s2_h = get_bh();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 776: { // x:(r)-n,x1 a,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s2_h = get_ah();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 777: { // x:(r)+n,x1 a,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s2_h = get_ah();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 778: { // x:(r)-,x1 a,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s2_h = get_ah();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 779: { // x:(r)+,x1 a,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 s2_h = get_ah();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 780: { // x:(r),x1 a,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		u32 s2_h = get_ah();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 781: { // x:(r+n),x1 a,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		u32 s2_h = get_ah();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 782: { // x:-(r),x1 a,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		u32 s2_h = get_ah();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 783: { // x:(r)-n,x1 a,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s2_h = get_ah();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 784: { // x:(r)+n,x1 a,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s2_h = get_ah();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 785: { // x:(r)-,x1 a,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s2_h = get_ah();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 786: { // x:(r)+,x1 a,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 s2_h = get_ah();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 787: { // x:(r),x1 a,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		u32 s2_h = get_ah();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 788: { // x:(r+n),x1 a,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		u32 s2_h = get_ah();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 789: { // x:-(r),x1 a,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		u32 s2_h = get_ah();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 790: { // x:(r)-n,x1 b,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s2_h = get_bh();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 791: { // x:(r)+n,x1 b,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s2_h = get_bh();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 792: { // x:(r)-,x1 b,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s2_h = get_bh();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 793: { // x:(r)+,x1 b,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 s2_h = get_bh();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 794: { // x:(r),x1 b,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		u32 s2_h = get_bh();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 795: { // x:(r+n),x1 b,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		u32 s2_h = get_bh();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 796: { // x:-(r),x1 b,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		u32 s2_h = get_bh();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 797: { // x:(r)-n,x1 b,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s2_h = get_bh();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 798: { // x:(r)+n,x1 b,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s2_h = get_bh();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 799: { // x:(r)-,x1 b,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s2_h = get_bh();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 800: { // x:(r)+,x1 b,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 s2_h = get_bh();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 801: { // x:(r),x1 b,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		u32 s2_h = get_bh();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 802: { // x:(r+n),x1 b,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		u32 s2_h = get_bh();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 803: { // x:-(r),x1 b,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		u32 s2_h = get_bh();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 804: { // x:(r)-n,a a,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s2_h = get_ah();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 805: { // x:(r)+n,a a,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s2_h = get_ah();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 806: { // x:(r)-,a a,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s2_h = get_ah();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 807: { // x:(r)+,a a,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 s2_h = get_ah();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 808: { // x:(r),a a,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		u32 s2_h = get_ah();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 809: { // x:(r+n),a a,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		u32 s2_h = get_ah();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 810: { // x:-(r),a a,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		u32 s2_h = get_ah();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 811: { // x:(r)-n,a a,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s2_h = get_ah();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 812: { // x:(r)+n,a a,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s2_h = get_ah();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 813: { // x:(r)-,a a,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s2_h = get_ah();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 814: { // x:(r)+,a a,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 s2_h = get_ah();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 815: { // x:(r),a a,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		u32 s2_h = get_ah();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 816: { // x:(r+n),a a,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		u32 s2_h = get_ah();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 817: { // x:-(r),a a,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		u32 s2_h = get_ah();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 818: { // x:(r)-n,a b,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s2_h = get_bh();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 819: { // x:(r)+n,a b,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s2_h = get_bh();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 820: { // x:(r)-,a b,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s2_h = get_bh();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 821: { // x:(r)+,a b,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 s2_h = get_bh();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 822: { // x:(r),a b,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		u32 s2_h = get_bh();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 823: { // x:(r+n),a b,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		u32 s2_h = get_bh();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 824: { // x:-(r),a b,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		u32 s2_h = get_bh();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 825: { // x:(r)-n,a b,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s2_h = get_bh();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 826: { // x:(r)+n,a b,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s2_h = get_bh();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 827: { // x:(r)-,a b,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s2_h = get_bh();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 828: { // x:(r)+,a b,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 s2_h = get_bh();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 829: { // x:(r),a b,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		u32 s2_h = get_bh();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 830: { // x:(r+n),a b,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		u32 s2_h = get_bh();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 831: { // x:-(r),a b,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		u32 s2_h = get_bh();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 832: { // x:(r)-n,b a,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s2_h = get_ah();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 833: { // x:(r)+n,b a,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s2_h = get_ah();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 834: { // x:(r)-,b a,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s2_h = get_ah();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 835: { // x:(r)+,b a,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 s2_h = get_ah();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 836: { // x:(r),b a,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		u32 s2_h = get_ah();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 837: { // x:(r+n),b a,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		u32 s2_h = get_ah();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 838: { // x:-(r),b a,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		u32 s2_h = get_ah();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 839: { // x:(r)-n,b a,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s2_h = get_ah();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 840: { // x:(r)+n,b a,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s2_h = get_ah();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 841: { // x:(r)-,b a,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s2_h = get_ah();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 842: { // x:(r)+,b a,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 s2_h = get_ah();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 843: { // x:(r),b a,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		u32 s2_h = get_ah();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 844: { // x:(r+n),b a,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		u32 s2_h = get_ah();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 845: { // x:-(r),b a,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		u32 s2_h = get_ah();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 846: { // x:(r)-n,b b,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s2_h = get_bh();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 847: { // x:(r)+n,b b,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s2_h = get_bh();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 848: { // x:(r)-,b b,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s2_h = get_bh();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 849: { // x:(r)+,b b,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 s2_h = get_bh();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 850: { // x:(r),b b,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		u32 s2_h = get_bh();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 851: { // x:(r+n),b b,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		u32 s2_h = get_bh();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 852: { // x:-(r),b b,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		u32 s2_h = get_bh();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 853: { // x:(r)-n,b b,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s2_h = get_bh();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 854: { // x:(r)+n,b b,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s2_h = get_bh();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 855: { // x:(r)-,b b,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s2_h = get_bh();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 856: { // x:(r)+,b b,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 s2_h = get_bh();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 857: { // x:(r),b b,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		u32 s2_h = get_bh();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 858: { // x:(r+n),b b,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		u32 s2_h = get_bh();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 859: { // x:-(r),b b,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		u32 s2_h = get_bh();
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = s2_h;
		break;
		}
	case 860: { // x0,x:(r)-n a,y0
		u32 s1 = get_x0();
		u32 s2_h = get_ah();
		m_tmp1 = s1;
		m_tmp2 = s2_h;
		break;
		}
	case 861: { // x0,x:(r)+n a,y0
		u32 s1 = get_x0();
		u32 s2_h = get_ah();
		m_tmp1 = s1;
		m_tmp2 = s2_h;
		break;
		}
	case 862: { // x0,x:(r)- a,y0
		u32 s1 = get_x0();
		u32 s2_h = get_ah();
		m_tmp1 = s1;
		m_tmp2 = s2_h;
		break;
		}
	case 863: { // x0,x:(r)+ a,y0
		u32 s1 = get_x0();
		u32 s2_h = get_ah();
		m_tmp1 = s1;
		m_tmp2 = s2_h;
		break;
		}
	case 864: { // x0,x:(r) a,y0
		u32 s1 = get_x0();
		u32 s2_h = get_ah();
		m_tmp1 = s1;
		m_tmp2 = s2_h;
		break;
		}
	case 865: { // x0,x:(r+n) a,y0
		u32 s1 = get_x0();
		u32 s2_h = get_ah();
		m_tmp1 = s1;
		m_tmp2 = s2_h;
		break;
		}
	case 866: { // x0,x:-(r) a,y0
		u32 s1 = get_x0();
		u32 s2_h = get_ah();
		m_tmp1 = s1;
		m_tmp2 = s2_h;
		break;
		}
	case 867: { // x0,x:(r)-n a,y1
		u32 s1 = get_x0();
		u32 s2_h = get_ah();
		m_tmp1 = s1;
		m_tmp2 = s2_h;
		break;
		}
	case 868: { // x0,x:(r)+n a,y1
		u32 s1 = get_x0();
		u32 s2_h = get_ah();
		m_tmp1 = s1;
		m_tmp2 = s2_h;
		break;
		}
	case 869: { // x0,x:(r)- a,y1
		u32 s1 = get_x0();
		u32 s2_h = get_ah();
		m_tmp1 = s1;
		m_tmp2 = s2_h;
		break;
		}
	case 870: { // x0,x:(r)+ a,y1
		u32 s1 = get_x0();
		u32 s2_h = get_ah();
		m_tmp1 = s1;
		m_tmp2 = s2_h;
		break;
		}
	case 871: { // x0,x:(r) a,y1
		u32 s1 = get_x0();
		u32 s2_h = get_ah();
		m_tmp1 = s1;
		m_tmp2 = s2_h;
		break;
		}
	case 872: { // x0,x:(r+n) a,y1
		u32 s1 = get_x0();
		u32 s2_h = get_ah();
		m_tmp1 = s1;
		m_tmp2 = s2_h;
		break;
		}
	case 873: { // x0,x:-(r) a,y1
		u32 s1 = get_x0();
		u32 s2_h = get_ah();
		m_tmp1 = s1;
		m_tmp2 = s2_h;
		break;
		}
	case 874: { // x0,x:(r)-n b,y0
		u32 s1 = get_x0();
		u32 s2_h = get_bh();
		m_tmp1 = s1;
		m_tmp2 = s2_h;
		break;
		}
	case 875: { // x0,x:(r)+n b,y0
		u32 s1 = get_x0();
		u32 s2_h = get_bh();
		m_tmp1 = s1;
		m_tmp2 = s2_h;
		break;
		}
	case 876: { // x0,x:(r)- b,y0
		u32 s1 = get_x0();
		u32 s2_h = get_bh();
		m_tmp1 = s1;
		m_tmp2 = s2_h;
		break;
		}
	case 877: { // x0,x:(r)+ b,y0
		u32 s1 = get_x0();
		u32 s2_h = get_bh();
		m_tmp1 = s1;
		m_tmp2 = s2_h;
		break;
		}
	case 878: { // x0,x:(r) b,y0
		u32 s1 = get_x0();
		u32 s2_h = get_bh();
		m_tmp1 = s1;
		m_tmp2 = s2_h;
		break;
		}
	case 879: { // x0,x:(r+n) b,y0
		u32 s1 = get_x0();
		u32 s2_h = get_bh();
		m_tmp1 = s1;
		m_tmp2 = s2_h;
		break;
		}
	case 880: { // x0,x:-(r) b,y0
		u32 s1 = get_x0();
		u32 s2_h = get_bh();
		m_tmp1 = s1;
		m_tmp2 = s2_h;
		break;
		}
	case 881: { // x0,x:(r)-n b,y1
		u32 s1 = get_x0();
		u32 s2_h = get_bh();
		m_tmp1 = s1;
		m_tmp2 = s2_h;
		break;
		}
	case 882: { // x0,x:(r)+n b,y1
		u32 s1 = get_x0();
		u32 s2_h = get_bh();
		m_tmp1 = s1;
		m_tmp2 = s2_h;
		break;
		}
	case 883: { // x0,x:(r)- b,y1
		u32 s1 = get_x0();
		u32 s2_h = get_bh();
		m_tmp1 = s1;
		m_tmp2 = s2_h;
		break;
		}
	case 884: { // x0,x:(r)+ b,y1
		u32 s1 = get_x0();
		u32 s2_h = get_bh();
		m_tmp1 = s1;
		m_tmp2 = s2_h;
		break;
		}
	case 885: { // x0,x:(r) b,y1
		u32 s1 = get_x0();
		u32 s2_h = get_bh();
		m_tmp1 = s1;
		m_tmp2 = s2_h;
		break;
		}
	case 886: { // x0,x:(r+n) b,y1
		u32 s1 = get_x0();
		u32 s2_h = get_bh();
		m_tmp1 = s1;
		m_tmp2 = s2_h;
		break;
		}
	case 887: { // x0,x:-(r) b,y1
		u32 s1 = get_x0();
		u32 s2_h = get_bh();
		m_tmp1 = s1;
		m_tmp2 = s2_h;
		break;
		}
	case 888: { // x1,x:(r)-n a,y0
		u32 s1 = get_x1();
		u32 s2_h = get_ah();
		m_tmp1 = s1;
		m_tmp2 = s2_h;
		break;
		}
	case 889: { // x1,x:(r)+n a,y0
		u32 s1 = get_x1();
		u32 s2_h = get_ah();
		m_tmp1 = s1;
		m_tmp2 = s2_h;
		break;
		}
	case 890: { // x1,x:(r)- a,y0
		u32 s1 = get_x1();
		u32 s2_h = get_ah();
		m_tmp1 = s1;
		m_tmp2 = s2_h;
		break;
		}
	case 891: { // x1,x:(r)+ a,y0
		u32 s1 = get_x1();
		u32 s2_h = get_ah();
		m_tmp1 = s1;
		m_tmp2 = s2_h;
		break;
		}
	case 892: { // x1,x:(r) a,y0
		u32 s1 = get_x1();
		u32 s2_h = get_ah();
		m_tmp1 = s1;
		m_tmp2 = s2_h;
		break;
		}
	case 893: { // x1,x:(r+n) a,y0
		u32 s1 = get_x1();
		u32 s2_h = get_ah();
		m_tmp1 = s1;
		m_tmp2 = s2_h;
		break;
		}
	case 894: { // x1,x:-(r) a,y0
		u32 s1 = get_x1();
		u32 s2_h = get_ah();
		m_tmp1 = s1;
		m_tmp2 = s2_h;
		break;
		}
	case 895: { // x1,x:(r)-n a,y1
		u32 s1 = get_x1();
		u32 s2_h = get_ah();
		m_tmp1 = s1;
		m_tmp2 = s2_h;
		break;
		}
	case 896: { // x1,x:(r)+n a,y1
		u32 s1 = get_x1();
		u32 s2_h = get_ah();
		m_tmp1 = s1;
		m_tmp2 = s2_h;
		break;
		}
	case 897: { // x1,x:(r)- a,y1
		u32 s1 = get_x1();
		u32 s2_h = get_ah();
		m_tmp1 = s1;
		m_tmp2 = s2_h;
		break;
		}
	case 898: { // x1,x:(r)+ a,y1
		u32 s1 = get_x1();
		u32 s2_h = get_ah();
		m_tmp1 = s1;
		m_tmp2 = s2_h;
		break;
		}
	case 899: { // x1,x:(r) a,y1
		u32 s1 = get_x1();
		u32 s2_h = get_ah();
		m_tmp1 = s1;
		m_tmp2 = s2_h;
		break;
		}
	case 900: { // x1,x:(r+n) a,y1
		u32 s1 = get_x1();
		u32 s2_h = get_ah();
		m_tmp1 = s1;
		m_tmp2 = s2_h;
		break;
		}
	case 901: { // x1,x:-(r) a,y1
		u32 s1 = get_x1();
		u32 s2_h = get_ah();
		m_tmp1 = s1;
		m_tmp2 = s2_h;
		break;
		}
	case 902: { // x1,x:(r)-n b,y0
		u32 s1 = get_x1();
		u32 s2_h = get_bh();
		m_tmp1 = s1;
		m_tmp2 = s2_h;
		break;
		}
	case 903: { // x1,x:(r)+n b,y0
		u32 s1 = get_x1();
		u32 s2_h = get_bh();
		m_tmp1 = s1;
		m_tmp2 = s2_h;
		break;
		}
	case 904: { // x1,x:(r)- b,y0
		u32 s1 = get_x1();
		u32 s2_h = get_bh();
		m_tmp1 = s1;
		m_tmp2 = s2_h;
		break;
		}
	case 905: { // x1,x:(r)+ b,y0
		u32 s1 = get_x1();
		u32 s2_h = get_bh();
		m_tmp1 = s1;
		m_tmp2 = s2_h;
		break;
		}
	case 906: { // x1,x:(r) b,y0
		u32 s1 = get_x1();
		u32 s2_h = get_bh();
		m_tmp1 = s1;
		m_tmp2 = s2_h;
		break;
		}
	case 907: { // x1,x:(r+n) b,y0
		u32 s1 = get_x1();
		u32 s2_h = get_bh();
		m_tmp1 = s1;
		m_tmp2 = s2_h;
		break;
		}
	case 908: { // x1,x:-(r) b,y0
		u32 s1 = get_x1();
		u32 s2_h = get_bh();
		m_tmp1 = s1;
		m_tmp2 = s2_h;
		break;
		}
	case 909: { // x1,x:(r)-n b,y1
		u32 s1 = get_x1();
		u32 s2_h = get_bh();
		m_tmp1 = s1;
		m_tmp2 = s2_h;
		break;
		}
	case 910: { // x1,x:(r)+n b,y1
		u32 s1 = get_x1();
		u32 s2_h = get_bh();
		m_tmp1 = s1;
		m_tmp2 = s2_h;
		break;
		}
	case 911: { // x1,x:(r)- b,y1
		u32 s1 = get_x1();
		u32 s2_h = get_bh();
		m_tmp1 = s1;
		m_tmp2 = s2_h;
		break;
		}
	case 912: { // x1,x:(r)+ b,y1
		u32 s1 = get_x1();
		u32 s2_h = get_bh();
		m_tmp1 = s1;
		m_tmp2 = s2_h;
		break;
		}
	case 913: { // x1,x:(r) b,y1
		u32 s1 = get_x1();
		u32 s2_h = get_bh();
		m_tmp1 = s1;
		m_tmp2 = s2_h;
		break;
		}
	case 914: { // x1,x:(r+n) b,y1
		u32 s1 = get_x1();
		u32 s2_h = get_bh();
		m_tmp1 = s1;
		m_tmp2 = s2_h;
		break;
		}
	case 915: { // x1,x:-(r) b,y1
		u32 s1 = get_x1();
		u32 s2_h = get_bh();
		m_tmp1 = s1;
		m_tmp2 = s2_h;
		break;
		}
	case 916: { // a,x:(r)-n a,y0
		u32 s1_h = get_ah();
		u32 s2_h = get_ah();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 917: { // a,x:(r)+n a,y0
		u32 s1_h = get_ah();
		u32 s2_h = get_ah();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 918: { // a,x:(r)- a,y0
		u32 s1_h = get_ah();
		u32 s2_h = get_ah();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 919: { // a,x:(r)+ a,y0
		u32 s1_h = get_ah();
		u32 s2_h = get_ah();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 920: { // a,x:(r) a,y0
		u32 s1_h = get_ah();
		u32 s2_h = get_ah();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 921: { // a,x:(r+n) a,y0
		u32 s1_h = get_ah();
		u32 s2_h = get_ah();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 922: { // a,x:-(r) a,y0
		u32 s1_h = get_ah();
		u32 s2_h = get_ah();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 923: { // a,x:(r)-n a,y1
		u32 s1_h = get_ah();
		u32 s2_h = get_ah();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 924: { // a,x:(r)+n a,y1
		u32 s1_h = get_ah();
		u32 s2_h = get_ah();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 925: { // a,x:(r)- a,y1
		u32 s1_h = get_ah();
		u32 s2_h = get_ah();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 926: { // a,x:(r)+ a,y1
		u32 s1_h = get_ah();
		u32 s2_h = get_ah();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 927: { // a,x:(r) a,y1
		u32 s1_h = get_ah();
		u32 s2_h = get_ah();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 928: { // a,x:(r+n) a,y1
		u32 s1_h = get_ah();
		u32 s2_h = get_ah();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 929: { // a,x:-(r) a,y1
		u32 s1_h = get_ah();
		u32 s2_h = get_ah();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 930: { // a,x:(r)-n b,y0
		u32 s1_h = get_ah();
		u32 s2_h = get_bh();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 931: { // a,x:(r)+n b,y0
		u32 s1_h = get_ah();
		u32 s2_h = get_bh();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 932: { // a,x:(r)- b,y0
		u32 s1_h = get_ah();
		u32 s2_h = get_bh();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 933: { // a,x:(r)+ b,y0
		u32 s1_h = get_ah();
		u32 s2_h = get_bh();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 934: { // a,x:(r) b,y0
		u32 s1_h = get_ah();
		u32 s2_h = get_bh();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 935: { // a,x:(r+n) b,y0
		u32 s1_h = get_ah();
		u32 s2_h = get_bh();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 936: { // a,x:-(r) b,y0
		u32 s1_h = get_ah();
		u32 s2_h = get_bh();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 937: { // a,x:(r)-n b,y1
		u32 s1_h = get_ah();
		u32 s2_h = get_bh();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 938: { // a,x:(r)+n b,y1
		u32 s1_h = get_ah();
		u32 s2_h = get_bh();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 939: { // a,x:(r)- b,y1
		u32 s1_h = get_ah();
		u32 s2_h = get_bh();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 940: { // a,x:(r)+ b,y1
		u32 s1_h = get_ah();
		u32 s2_h = get_bh();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 941: { // a,x:(r) b,y1
		u32 s1_h = get_ah();
		u32 s2_h = get_bh();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 942: { // a,x:(r+n) b,y1
		u32 s1_h = get_ah();
		u32 s2_h = get_bh();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 943: { // a,x:-(r) b,y1
		u32 s1_h = get_ah();
		u32 s2_h = get_bh();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 944: { // b,x:(r)-n a,y0
		u32 s1_h = get_bh();
		u32 s2_h = get_ah();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 945: { // b,x:(r)+n a,y0
		u32 s1_h = get_bh();
		u32 s2_h = get_ah();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 946: { // b,x:(r)- a,y0
		u32 s1_h = get_bh();
		u32 s2_h = get_ah();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 947: { // b,x:(r)+ a,y0
		u32 s1_h = get_bh();
		u32 s2_h = get_ah();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 948: { // b,x:(r) a,y0
		u32 s1_h = get_bh();
		u32 s2_h = get_ah();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 949: { // b,x:(r+n) a,y0
		u32 s1_h = get_bh();
		u32 s2_h = get_ah();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 950: { // b,x:-(r) a,y0
		u32 s1_h = get_bh();
		u32 s2_h = get_ah();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 951: { // b,x:(r)-n a,y1
		u32 s1_h = get_bh();
		u32 s2_h = get_ah();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 952: { // b,x:(r)+n a,y1
		u32 s1_h = get_bh();
		u32 s2_h = get_ah();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 953: { // b,x:(r)- a,y1
		u32 s1_h = get_bh();
		u32 s2_h = get_ah();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 954: { // b,x:(r)+ a,y1
		u32 s1_h = get_bh();
		u32 s2_h = get_ah();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 955: { // b,x:(r) a,y1
		u32 s1_h = get_bh();
		u32 s2_h = get_ah();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 956: { // b,x:(r+n) a,y1
		u32 s1_h = get_bh();
		u32 s2_h = get_ah();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 957: { // b,x:-(r) a,y1
		u32 s1_h = get_bh();
		u32 s2_h = get_ah();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 958: { // b,x:(r)-n b,y0
		u32 s1_h = get_bh();
		u32 s2_h = get_bh();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 959: { // b,x:(r)+n b,y0
		u32 s1_h = get_bh();
		u32 s2_h = get_bh();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 960: { // b,x:(r)- b,y0
		u32 s1_h = get_bh();
		u32 s2_h = get_bh();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 961: { // b,x:(r)+ b,y0
		u32 s1_h = get_bh();
		u32 s2_h = get_bh();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 962: { // b,x:(r) b,y0
		u32 s1_h = get_bh();
		u32 s2_h = get_bh();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 963: { // b,x:(r+n) b,y0
		u32 s1_h = get_bh();
		u32 s2_h = get_bh();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 964: { // b,x:-(r) b,y0
		u32 s1_h = get_bh();
		u32 s2_h = get_bh();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 965: { // b,x:(r)-n b,y1
		u32 s1_h = get_bh();
		u32 s2_h = get_bh();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 966: { // b,x:(r)+n b,y1
		u32 s1_h = get_bh();
		u32 s2_h = get_bh();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 967: { // b,x:(r)- b,y1
		u32 s1_h = get_bh();
		u32 s2_h = get_bh();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 968: { // b,x:(r)+ b,y1
		u32 s1_h = get_bh();
		u32 s2_h = get_bh();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 969: { // b,x:(r) b,y1
		u32 s1_h = get_bh();
		u32 s2_h = get_bh();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 970: { // b,x:(r+n) b,y1
		u32 s1_h = get_bh();
		u32 s2_h = get_bh();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 971: { // b,x:-(r) b,y1
		u32 s1_h = get_bh();
		u32 s2_h = get_bh();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 972: { // x:[abs],x0 a,y0
		u32 abs = exv;
		u32 s2_h = get_ah();
		m_tmp1 = m_x.read_dword(abs);
		m_tmp2 = s2_h;
		break;
		}
	case 973: { // x:[abs],x0 a,y1
		u32 abs = exv;
		u32 s2_h = get_ah();
		m_tmp1 = m_x.read_dword(abs);
		m_tmp2 = s2_h;
		break;
		}
	case 974: { // x:[abs],x0 b,y0
		u32 abs = exv;
		u32 s2_h = get_bh();
		m_tmp1 = m_x.read_dword(abs);
		m_tmp2 = s2_h;
		break;
		}
	case 975: { // x:[abs],x0 b,y1
		u32 abs = exv;
		u32 s2_h = get_bh();
		m_tmp1 = m_x.read_dword(abs);
		m_tmp2 = s2_h;
		break;
		}
	case 976: { // x:[abs],x1 a,y0
		u32 abs = exv;
		u32 s2_h = get_ah();
		m_tmp1 = m_x.read_dword(abs);
		m_tmp2 = s2_h;
		break;
		}
	case 977: { // x:[abs],x1 a,y1
		u32 abs = exv;
		u32 s2_h = get_ah();
		m_tmp1 = m_x.read_dword(abs);
		m_tmp2 = s2_h;
		break;
		}
	case 978: { // x:[abs],x1 b,y0
		u32 abs = exv;
		u32 s2_h = get_bh();
		m_tmp1 = m_x.read_dword(abs);
		m_tmp2 = s2_h;
		break;
		}
	case 979: { // x:[abs],x1 b,y1
		u32 abs = exv;
		u32 s2_h = get_bh();
		m_tmp1 = m_x.read_dword(abs);
		m_tmp2 = s2_h;
		break;
		}
	case 980: { // x:[abs],a a,y0
		u32 abs = exv;
		u32 s2_h = get_ah();
		m_tmp1 = m_x.read_dword(abs);
		m_tmp2 = s2_h;
		break;
		}
	case 981: { // x:[abs],a a,y1
		u32 abs = exv;
		u32 s2_h = get_ah();
		m_tmp1 = m_x.read_dword(abs);
		m_tmp2 = s2_h;
		break;
		}
	case 982: { // x:[abs],a b,y0
		u32 abs = exv;
		u32 s2_h = get_bh();
		m_tmp1 = m_x.read_dword(abs);
		m_tmp2 = s2_h;
		break;
		}
	case 983: { // x:[abs],a b,y1
		u32 abs = exv;
		u32 s2_h = get_bh();
		m_tmp1 = m_x.read_dword(abs);
		m_tmp2 = s2_h;
		break;
		}
	case 984: { // x:[abs],b a,y0
		u32 abs = exv;
		u32 s2_h = get_ah();
		m_tmp1 = m_x.read_dword(abs);
		m_tmp2 = s2_h;
		break;
		}
	case 985: { // x:[abs],b a,y1
		u32 abs = exv;
		u32 s2_h = get_ah();
		m_tmp1 = m_x.read_dword(abs);
		m_tmp2 = s2_h;
		break;
		}
	case 986: { // x:[abs],b b,y0
		u32 abs = exv;
		u32 s2_h = get_bh();
		m_tmp1 = m_x.read_dword(abs);
		m_tmp2 = s2_h;
		break;
		}
	case 987: { // x:[abs],b b,y1
		u32 abs = exv;
		u32 s2_h = get_bh();
		m_tmp1 = m_x.read_dword(abs);
		m_tmp2 = s2_h;
		break;
		}
	case 988: { // x0,x:[abs] a,y0
		u32 s1 = get_x0();
		u32 s2_h = get_ah();
		m_tmp1 = s1;
		m_tmp2 = s2_h;
		break;
		}
	case 989: { // x0,x:[abs] a,y1
		u32 s1 = get_x0();
		u32 s2_h = get_ah();
		m_tmp1 = s1;
		m_tmp2 = s2_h;
		break;
		}
	case 990: { // x0,x:[abs] b,y0
		u32 s1 = get_x0();
		u32 s2_h = get_bh();
		m_tmp1 = s1;
		m_tmp2 = s2_h;
		break;
		}
	case 991: { // x0,x:[abs] b,y1
		u32 s1 = get_x0();
		u32 s2_h = get_bh();
		m_tmp1 = s1;
		m_tmp2 = s2_h;
		break;
		}
	case 992: { // x1,x:[abs] a,y0
		u32 s1 = get_x1();
		u32 s2_h = get_ah();
		m_tmp1 = s1;
		m_tmp2 = s2_h;
		break;
		}
	case 993: { // x1,x:[abs] a,y1
		u32 s1 = get_x1();
		u32 s2_h = get_ah();
		m_tmp1 = s1;
		m_tmp2 = s2_h;
		break;
		}
	case 994: { // x1,x:[abs] b,y0
		u32 s1 = get_x1();
		u32 s2_h = get_bh();
		m_tmp1 = s1;
		m_tmp2 = s2_h;
		break;
		}
	case 995: { // x1,x:[abs] b,y1
		u32 s1 = get_x1();
		u32 s2_h = get_bh();
		m_tmp1 = s1;
		m_tmp2 = s2_h;
		break;
		}
	case 996: { // a,x:[abs] a,y0
		u32 s1_h = get_ah();
		u32 s2_h = get_ah();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 997: { // a,x:[abs] a,y1
		u32 s1_h = get_ah();
		u32 s2_h = get_ah();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 998: { // a,x:[abs] b,y0
		u32 s1_h = get_ah();
		u32 s2_h = get_bh();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 999: { // a,x:[abs] b,y1
		u32 s1_h = get_ah();
		u32 s2_h = get_bh();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1000: { // b,x:[abs] a,y0
		u32 s1_h = get_bh();
		u32 s2_h = get_ah();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1001: { // b,x:[abs] a,y1
		u32 s1_h = get_bh();
		u32 s2_h = get_ah();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1002: { // b,x:[abs] b,y0
		u32 s1_h = get_bh();
		u32 s2_h = get_bh();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1003: { // b,x:[abs] b,y1
		u32 s1_h = get_bh();
		u32 s2_h = get_bh();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1004: { // #[i],x0 a,y0
		u32 s2_h = get_ah();
		m_tmp1 = s2_h;
		break;
		}
	case 1005: { // #[i],x0 a,y1
		u32 s2_h = get_ah();
		m_tmp1 = s2_h;
		break;
		}
	case 1006: { // #[i],x0 b,y0
		u32 s2_h = get_bh();
		m_tmp1 = s2_h;
		break;
		}
	case 1007: { // #[i],x0 b,y1
		u32 s2_h = get_bh();
		m_tmp1 = s2_h;
		break;
		}
	case 1008: { // #[i],x1 a,y0
		u32 s2_h = get_ah();
		m_tmp1 = s2_h;
		break;
		}
	case 1009: { // #[i],x1 a,y1
		u32 s2_h = get_ah();
		m_tmp1 = s2_h;
		break;
		}
	case 1010: { // #[i],x1 b,y0
		u32 s2_h = get_bh();
		m_tmp1 = s2_h;
		break;
		}
	case 1011: { // #[i],x1 b,y1
		u32 s2_h = get_bh();
		m_tmp1 = s2_h;
		break;
		}
	case 1012: { // #[i],a a,y0
		u32 s2_h = get_ah();
		m_tmp1 = s2_h;
		break;
		}
	case 1013: { // #[i],a a,y1
		u32 s2_h = get_ah();
		m_tmp1 = s2_h;
		break;
		}
	case 1014: { // #[i],a b,y0
		u32 s2_h = get_bh();
		m_tmp1 = s2_h;
		break;
		}
	case 1015: { // #[i],a b,y1
		u32 s2_h = get_bh();
		m_tmp1 = s2_h;
		break;
		}
	case 1016: { // #[i],b a,y0
		u32 s2_h = get_ah();
		m_tmp1 = s2_h;
		break;
		}
	case 1017: { // #[i],b a,y1
		u32 s2_h = get_ah();
		m_tmp1 = s2_h;
		break;
		}
	case 1018: { // #[i],b b,y0
		u32 s2_h = get_bh();
		m_tmp1 = s2_h;
		break;
		}
	case 1019: { // #[i],b b,y1
		u32 s2_h = get_bh();
		m_tmp1 = s2_h;
		break;
		}
	case 1020: { // a,x:(r)-n x0,a
		m_tmp1 = get_ah();
		m_tmp2 = get_x0();
		break;
		}
	case 1021: { // a,x:(r)+n x0,a
		m_tmp1 = get_ah();
		m_tmp2 = get_x0();
		break;
		}
	case 1022: { // a,x:(r)- x0,a
		m_tmp1 = get_ah();
		m_tmp2 = get_x0();
		break;
		}
	case 1023: { // a,x:(r)+ x0,a
		m_tmp1 = get_ah();
		m_tmp2 = get_x0();
		break;
		}
	case 1024: { // a,x:(r) x0,a
		m_tmp1 = get_ah();
		m_tmp2 = get_x0();
		break;
		}
	case 1025: { // a,x:(r+n) x0,a
		m_tmp1 = get_ah();
		m_tmp2 = get_x0();
		break;
		}
	case 1026: { // a,x:-(r) x0,a
		m_tmp1 = get_ah();
		m_tmp2 = get_x0();
		break;
		}
	case 1027: { // b,x:(r)-n x0,b
		m_tmp1 = get_bh();
		m_tmp2 = get_x0();
		break;
		}
	case 1028: { // b,x:(r)+n x0,b
		m_tmp1 = get_bh();
		m_tmp2 = get_x0();
		break;
		}
	case 1029: { // b,x:(r)- x0,b
		m_tmp1 = get_bh();
		m_tmp2 = get_x0();
		break;
		}
	case 1030: { // b,x:(r)+ x0,b
		m_tmp1 = get_bh();
		m_tmp2 = get_x0();
		break;
		}
	case 1031: { // b,x:(r) x0,b
		m_tmp1 = get_bh();
		m_tmp2 = get_x0();
		break;
		}
	case 1032: { // b,x:(r+n) x0,b
		m_tmp1 = get_bh();
		m_tmp2 = get_x0();
		break;
		}
	case 1033: { // b,x:-(r) x0,b
		m_tmp1 = get_bh();
		m_tmp2 = get_x0();
		break;
		}
	case 1034: { // a,x:[abs] x0,a
		m_tmp1 = get_ah();
		m_tmp2 = get_x0();
		break;
		}
	case 1035: { // b,x:[abs] x0,b
		m_tmp1 = get_bh();
		m_tmp2 = get_x0();
		break;
		}
	case 1036: { // a,x0 y:(r)-n,y0
		u32 s1_h = get_ah();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1037: { // a,x0 y:(r)+n,y0
		u32 s1_h = get_ah();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1038: { // a,x0 y:(r)-,y0
		u32 s1_h = get_ah();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1039: { // a,x0 y:(r)+,y0
		u32 s1_h = get_ah();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1040: { // a,x0 y:(r),y0
		u32 s1_h = get_ah();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1041: { // a,x0 y:(r+n),y0
		u32 s1_h = get_ah();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1042: { // a,x0 y:-(r),y0
		u32 s1_h = get_ah();
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1043: { // a,x1 y:(r)-n,y0
		u32 s1_h = get_ah();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1044: { // a,x1 y:(r)+n,y0
		u32 s1_h = get_ah();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1045: { // a,x1 y:(r)-,y0
		u32 s1_h = get_ah();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1046: { // a,x1 y:(r)+,y0
		u32 s1_h = get_ah();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1047: { // a,x1 y:(r),y0
		u32 s1_h = get_ah();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1048: { // a,x1 y:(r+n),y0
		u32 s1_h = get_ah();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1049: { // a,x1 y:-(r),y0
		u32 s1_h = get_ah();
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1050: { // b,x0 y:(r)-n,y0
		u32 s1_h = get_bh();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1051: { // b,x0 y:(r)+n,y0
		u32 s1_h = get_bh();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1052: { // b,x0 y:(r)-,y0
		u32 s1_h = get_bh();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1053: { // b,x0 y:(r)+,y0
		u32 s1_h = get_bh();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1054: { // b,x0 y:(r),y0
		u32 s1_h = get_bh();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1055: { // b,x0 y:(r+n),y0
		u32 s1_h = get_bh();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1056: { // b,x0 y:-(r),y0
		u32 s1_h = get_bh();
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1057: { // b,x1 y:(r)-n,y0
		u32 s1_h = get_bh();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1058: { // b,x1 y:(r)+n,y0
		u32 s1_h = get_bh();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1059: { // b,x1 y:(r)-,y0
		u32 s1_h = get_bh();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1060: { // b,x1 y:(r)+,y0
		u32 s1_h = get_bh();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1061: { // b,x1 y:(r),y0
		u32 s1_h = get_bh();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1062: { // b,x1 y:(r+n),y0
		u32 s1_h = get_bh();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1063: { // b,x1 y:-(r),y0
		u32 s1_h = get_bh();
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1064: { // a,x0 y:(r)-n,y1
		u32 s1_h = get_ah();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1065: { // a,x0 y:(r)+n,y1
		u32 s1_h = get_ah();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1066: { // a,x0 y:(r)-,y1
		u32 s1_h = get_ah();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1067: { // a,x0 y:(r)+,y1
		u32 s1_h = get_ah();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1068: { // a,x0 y:(r),y1
		u32 s1_h = get_ah();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1069: { // a,x0 y:(r+n),y1
		u32 s1_h = get_ah();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1070: { // a,x0 y:-(r),y1
		u32 s1_h = get_ah();
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1071: { // a,x1 y:(r)-n,y1
		u32 s1_h = get_ah();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1072: { // a,x1 y:(r)+n,y1
		u32 s1_h = get_ah();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1073: { // a,x1 y:(r)-,y1
		u32 s1_h = get_ah();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1074: { // a,x1 y:(r)+,y1
		u32 s1_h = get_ah();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1075: { // a,x1 y:(r),y1
		u32 s1_h = get_ah();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1076: { // a,x1 y:(r+n),y1
		u32 s1_h = get_ah();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1077: { // a,x1 y:-(r),y1
		u32 s1_h = get_ah();
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1078: { // b,x0 y:(r)-n,y1
		u32 s1_h = get_bh();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1079: { // b,x0 y:(r)+n,y1
		u32 s1_h = get_bh();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1080: { // b,x0 y:(r)-,y1
		u32 s1_h = get_bh();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1081: { // b,x0 y:(r)+,y1
		u32 s1_h = get_bh();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1082: { // b,x0 y:(r),y1
		u32 s1_h = get_bh();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1083: { // b,x0 y:(r+n),y1
		u32 s1_h = get_bh();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1084: { // b,x0 y:-(r),y1
		u32 s1_h = get_bh();
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1085: { // b,x1 y:(r)-n,y1
		u32 s1_h = get_bh();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1086: { // b,x1 y:(r)+n,y1
		u32 s1_h = get_bh();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1087: { // b,x1 y:(r)-,y1
		u32 s1_h = get_bh();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1088: { // b,x1 y:(r)+,y1
		u32 s1_h = get_bh();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1089: { // b,x1 y:(r),y1
		u32 s1_h = get_bh();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1090: { // b,x1 y:(r+n),y1
		u32 s1_h = get_bh();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1091: { // b,x1 y:-(r),y1
		u32 s1_h = get_bh();
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1092: { // a,x0 y:(r)-n,a
		u32 s1_h = get_ah();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1093: { // a,x0 y:(r)+n,a
		u32 s1_h = get_ah();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1094: { // a,x0 y:(r)-,a
		u32 s1_h = get_ah();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1095: { // a,x0 y:(r)+,a
		u32 s1_h = get_ah();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1096: { // a,x0 y:(r),a
		u32 s1_h = get_ah();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1097: { // a,x0 y:(r+n),a
		u32 s1_h = get_ah();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1098: { // a,x0 y:-(r),a
		u32 s1_h = get_ah();
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1099: { // a,x1 y:(r)-n,a
		u32 s1_h = get_ah();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1100: { // a,x1 y:(r)+n,a
		u32 s1_h = get_ah();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1101: { // a,x1 y:(r)-,a
		u32 s1_h = get_ah();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1102: { // a,x1 y:(r)+,a
		u32 s1_h = get_ah();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1103: { // a,x1 y:(r),a
		u32 s1_h = get_ah();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1104: { // a,x1 y:(r+n),a
		u32 s1_h = get_ah();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1105: { // a,x1 y:-(r),a
		u32 s1_h = get_ah();
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1106: { // b,x0 y:(r)-n,a
		u32 s1_h = get_bh();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1107: { // b,x0 y:(r)+n,a
		u32 s1_h = get_bh();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1108: { // b,x0 y:(r)-,a
		u32 s1_h = get_bh();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1109: { // b,x0 y:(r)+,a
		u32 s1_h = get_bh();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1110: { // b,x0 y:(r),a
		u32 s1_h = get_bh();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1111: { // b,x0 y:(r+n),a
		u32 s1_h = get_bh();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1112: { // b,x0 y:-(r),a
		u32 s1_h = get_bh();
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1113: { // b,x1 y:(r)-n,a
		u32 s1_h = get_bh();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1114: { // b,x1 y:(r)+n,a
		u32 s1_h = get_bh();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1115: { // b,x1 y:(r)-,a
		u32 s1_h = get_bh();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1116: { // b,x1 y:(r)+,a
		u32 s1_h = get_bh();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1117: { // b,x1 y:(r),a
		u32 s1_h = get_bh();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1118: { // b,x1 y:(r+n),a
		u32 s1_h = get_bh();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1119: { // b,x1 y:-(r),a
		u32 s1_h = get_bh();
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1120: { // a,x0 y:(r)-n,b
		u32 s1_h = get_ah();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1121: { // a,x0 y:(r)+n,b
		u32 s1_h = get_ah();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1122: { // a,x0 y:(r)-,b
		u32 s1_h = get_ah();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1123: { // a,x0 y:(r)+,b
		u32 s1_h = get_ah();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1124: { // a,x0 y:(r),b
		u32 s1_h = get_ah();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1125: { // a,x0 y:(r+n),b
		u32 s1_h = get_ah();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1126: { // a,x0 y:-(r),b
		u32 s1_h = get_ah();
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1127: { // a,x1 y:(r)-n,b
		u32 s1_h = get_ah();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1128: { // a,x1 y:(r)+n,b
		u32 s1_h = get_ah();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1129: { // a,x1 y:(r)-,b
		u32 s1_h = get_ah();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1130: { // a,x1 y:(r)+,b
		u32 s1_h = get_ah();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1131: { // a,x1 y:(r),b
		u32 s1_h = get_ah();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1132: { // a,x1 y:(r+n),b
		u32 s1_h = get_ah();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1133: { // a,x1 y:-(r),b
		u32 s1_h = get_ah();
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1134: { // b,x0 y:(r)-n,b
		u32 s1_h = get_bh();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1135: { // b,x0 y:(r)+n,b
		u32 s1_h = get_bh();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1136: { // b,x0 y:(r)-,b
		u32 s1_h = get_bh();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1137: { // b,x0 y:(r)+,b
		u32 s1_h = get_bh();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1138: { // b,x0 y:(r),b
		u32 s1_h = get_bh();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1139: { // b,x0 y:(r+n),b
		u32 s1_h = get_bh();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1140: { // b,x0 y:-(r),b
		u32 s1_h = get_bh();
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1141: { // b,x1 y:(r)-n,b
		u32 s1_h = get_bh();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1142: { // b,x1 y:(r)+n,b
		u32 s1_h = get_bh();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1143: { // b,x1 y:(r)-,b
		u32 s1_h = get_bh();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1144: { // b,x1 y:(r)+,b
		u32 s1_h = get_bh();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1145: { // b,x1 y:(r),b
		u32 s1_h = get_bh();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1146: { // b,x1 y:(r+n),b
		u32 s1_h = get_bh();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1147: { // b,x1 y:-(r),b
		u32 s1_h = get_bh();
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1148: { // a,x0 y0,y:(r)-n
		u32 s1_h = get_ah();
		u32 s2 = get_y0();
		m_tmp1 = s1_h;
		m_tmp2 = s2;
		break;
		}
	case 1149: { // a,x0 y0,y:(r)+n
		u32 s1_h = get_ah();
		u32 s2 = get_y0();
		m_tmp1 = s1_h;
		m_tmp2 = s2;
		break;
		}
	case 1150: { // a,x0 y0,y:(r)-
		u32 s1_h = get_ah();
		u32 s2 = get_y0();
		m_tmp1 = s1_h;
		m_tmp2 = s2;
		break;
		}
	case 1151: { // a,x0 y0,y:(r)+
		u32 s1_h = get_ah();
		u32 s2 = get_y0();
		m_tmp1 = s1_h;
		m_tmp2 = s2;
		break;
		}
	case 1152: { // a,x0 y0,y:(r)
		u32 s1_h = get_ah();
		u32 s2 = get_y0();
		m_tmp1 = s1_h;
		m_tmp2 = s2;
		break;
		}
	case 1153: { // a,x0 y0,y:(r+n)
		u32 s1_h = get_ah();
		u32 s2 = get_y0();
		m_tmp1 = s1_h;
		m_tmp2 = s2;
		break;
		}
	case 1154: { // a,x0 y0,y:-(r)
		u32 s1_h = get_ah();
		u32 s2 = get_y0();
		m_tmp1 = s1_h;
		m_tmp2 = s2;
		break;
		}
	case 1155: { // a,x1 y0,y:(r)-n
		u32 s1_h = get_ah();
		u32 s2 = get_y0();
		m_tmp1 = s1_h;
		m_tmp2 = s2;
		break;
		}
	case 1156: { // a,x1 y0,y:(r)+n
		u32 s1_h = get_ah();
		u32 s2 = get_y0();
		m_tmp1 = s1_h;
		m_tmp2 = s2;
		break;
		}
	case 1157: { // a,x1 y0,y:(r)-
		u32 s1_h = get_ah();
		u32 s2 = get_y0();
		m_tmp1 = s1_h;
		m_tmp2 = s2;
		break;
		}
	case 1158: { // a,x1 y0,y:(r)+
		u32 s1_h = get_ah();
		u32 s2 = get_y0();
		m_tmp1 = s1_h;
		m_tmp2 = s2;
		break;
		}
	case 1159: { // a,x1 y0,y:(r)
		u32 s1_h = get_ah();
		u32 s2 = get_y0();
		m_tmp1 = s1_h;
		m_tmp2 = s2;
		break;
		}
	case 1160: { // a,x1 y0,y:(r+n)
		u32 s1_h = get_ah();
		u32 s2 = get_y0();
		m_tmp1 = s1_h;
		m_tmp2 = s2;
		break;
		}
	case 1161: { // a,x1 y0,y:-(r)
		u32 s1_h = get_ah();
		u32 s2 = get_y0();
		m_tmp1 = s1_h;
		m_tmp2 = s2;
		break;
		}
	case 1162: { // b,x0 y0,y:(r)-n
		u32 s1_h = get_bh();
		u32 s2 = get_y0();
		m_tmp1 = s1_h;
		m_tmp2 = s2;
		break;
		}
	case 1163: { // b,x0 y0,y:(r)+n
		u32 s1_h = get_bh();
		u32 s2 = get_y0();
		m_tmp1 = s1_h;
		m_tmp2 = s2;
		break;
		}
	case 1164: { // b,x0 y0,y:(r)-
		u32 s1_h = get_bh();
		u32 s2 = get_y0();
		m_tmp1 = s1_h;
		m_tmp2 = s2;
		break;
		}
	case 1165: { // b,x0 y0,y:(r)+
		u32 s1_h = get_bh();
		u32 s2 = get_y0();
		m_tmp1 = s1_h;
		m_tmp2 = s2;
		break;
		}
	case 1166: { // b,x0 y0,y:(r)
		u32 s1_h = get_bh();
		u32 s2 = get_y0();
		m_tmp1 = s1_h;
		m_tmp2 = s2;
		break;
		}
	case 1167: { // b,x0 y0,y:(r+n)
		u32 s1_h = get_bh();
		u32 s2 = get_y0();
		m_tmp1 = s1_h;
		m_tmp2 = s2;
		break;
		}
	case 1168: { // b,x0 y0,y:-(r)
		u32 s1_h = get_bh();
		u32 s2 = get_y0();
		m_tmp1 = s1_h;
		m_tmp2 = s2;
		break;
		}
	case 1169: { // b,x1 y0,y:(r)-n
		u32 s1_h = get_bh();
		u32 s2 = get_y0();
		m_tmp1 = s1_h;
		m_tmp2 = s2;
		break;
		}
	case 1170: { // b,x1 y0,y:(r)+n
		u32 s1_h = get_bh();
		u32 s2 = get_y0();
		m_tmp1 = s1_h;
		m_tmp2 = s2;
		break;
		}
	case 1171: { // b,x1 y0,y:(r)-
		u32 s1_h = get_bh();
		u32 s2 = get_y0();
		m_tmp1 = s1_h;
		m_tmp2 = s2;
		break;
		}
	case 1172: { // b,x1 y0,y:(r)+
		u32 s1_h = get_bh();
		u32 s2 = get_y0();
		m_tmp1 = s1_h;
		m_tmp2 = s2;
		break;
		}
	case 1173: { // b,x1 y0,y:(r)
		u32 s1_h = get_bh();
		u32 s2 = get_y0();
		m_tmp1 = s1_h;
		m_tmp2 = s2;
		break;
		}
	case 1174: { // b,x1 y0,y:(r+n)
		u32 s1_h = get_bh();
		u32 s2 = get_y0();
		m_tmp1 = s1_h;
		m_tmp2 = s2;
		break;
		}
	case 1175: { // b,x1 y0,y:-(r)
		u32 s1_h = get_bh();
		u32 s2 = get_y0();
		m_tmp1 = s1_h;
		m_tmp2 = s2;
		break;
		}
	case 1176: { // a,x0 y1,y:(r)-n
		u32 s1_h = get_ah();
		u32 s2 = get_y1();
		m_tmp1 = s1_h;
		m_tmp2 = s2;
		break;
		}
	case 1177: { // a,x0 y1,y:(r)+n
		u32 s1_h = get_ah();
		u32 s2 = get_y1();
		m_tmp1 = s1_h;
		m_tmp2 = s2;
		break;
		}
	case 1178: { // a,x0 y1,y:(r)-
		u32 s1_h = get_ah();
		u32 s2 = get_y1();
		m_tmp1 = s1_h;
		m_tmp2 = s2;
		break;
		}
	case 1179: { // a,x0 y1,y:(r)+
		u32 s1_h = get_ah();
		u32 s2 = get_y1();
		m_tmp1 = s1_h;
		m_tmp2 = s2;
		break;
		}
	case 1180: { // a,x0 y1,y:(r)
		u32 s1_h = get_ah();
		u32 s2 = get_y1();
		m_tmp1 = s1_h;
		m_tmp2 = s2;
		break;
		}
	case 1181: { // a,x0 y1,y:(r+n)
		u32 s1_h = get_ah();
		u32 s2 = get_y1();
		m_tmp1 = s1_h;
		m_tmp2 = s2;
		break;
		}
	case 1182: { // a,x0 y1,y:-(r)
		u32 s1_h = get_ah();
		u32 s2 = get_y1();
		m_tmp1 = s1_h;
		m_tmp2 = s2;
		break;
		}
	case 1183: { // a,x1 y1,y:(r)-n
		u32 s1_h = get_ah();
		u32 s2 = get_y1();
		m_tmp1 = s1_h;
		m_tmp2 = s2;
		break;
		}
	case 1184: { // a,x1 y1,y:(r)+n
		u32 s1_h = get_ah();
		u32 s2 = get_y1();
		m_tmp1 = s1_h;
		m_tmp2 = s2;
		break;
		}
	case 1185: { // a,x1 y1,y:(r)-
		u32 s1_h = get_ah();
		u32 s2 = get_y1();
		m_tmp1 = s1_h;
		m_tmp2 = s2;
		break;
		}
	case 1186: { // a,x1 y1,y:(r)+
		u32 s1_h = get_ah();
		u32 s2 = get_y1();
		m_tmp1 = s1_h;
		m_tmp2 = s2;
		break;
		}
	case 1187: { // a,x1 y1,y:(r)
		u32 s1_h = get_ah();
		u32 s2 = get_y1();
		m_tmp1 = s1_h;
		m_tmp2 = s2;
		break;
		}
	case 1188: { // a,x1 y1,y:(r+n)
		u32 s1_h = get_ah();
		u32 s2 = get_y1();
		m_tmp1 = s1_h;
		m_tmp2 = s2;
		break;
		}
	case 1189: { // a,x1 y1,y:-(r)
		u32 s1_h = get_ah();
		u32 s2 = get_y1();
		m_tmp1 = s1_h;
		m_tmp2 = s2;
		break;
		}
	case 1190: { // b,x0 y1,y:(r)-n
		u32 s1_h = get_bh();
		u32 s2 = get_y1();
		m_tmp1 = s1_h;
		m_tmp2 = s2;
		break;
		}
	case 1191: { // b,x0 y1,y:(r)+n
		u32 s1_h = get_bh();
		u32 s2 = get_y1();
		m_tmp1 = s1_h;
		m_tmp2 = s2;
		break;
		}
	case 1192: { // b,x0 y1,y:(r)-
		u32 s1_h = get_bh();
		u32 s2 = get_y1();
		m_tmp1 = s1_h;
		m_tmp2 = s2;
		break;
		}
	case 1193: { // b,x0 y1,y:(r)+
		u32 s1_h = get_bh();
		u32 s2 = get_y1();
		m_tmp1 = s1_h;
		m_tmp2 = s2;
		break;
		}
	case 1194: { // b,x0 y1,y:(r)
		u32 s1_h = get_bh();
		u32 s2 = get_y1();
		m_tmp1 = s1_h;
		m_tmp2 = s2;
		break;
		}
	case 1195: { // b,x0 y1,y:(r+n)
		u32 s1_h = get_bh();
		u32 s2 = get_y1();
		m_tmp1 = s1_h;
		m_tmp2 = s2;
		break;
		}
	case 1196: { // b,x0 y1,y:-(r)
		u32 s1_h = get_bh();
		u32 s2 = get_y1();
		m_tmp1 = s1_h;
		m_tmp2 = s2;
		break;
		}
	case 1197: { // b,x1 y1,y:(r)-n
		u32 s1_h = get_bh();
		u32 s2 = get_y1();
		m_tmp1 = s1_h;
		m_tmp2 = s2;
		break;
		}
	case 1198: { // b,x1 y1,y:(r)+n
		u32 s1_h = get_bh();
		u32 s2 = get_y1();
		m_tmp1 = s1_h;
		m_tmp2 = s2;
		break;
		}
	case 1199: { // b,x1 y1,y:(r)-
		u32 s1_h = get_bh();
		u32 s2 = get_y1();
		m_tmp1 = s1_h;
		m_tmp2 = s2;
		break;
		}
	case 1200: { // b,x1 y1,y:(r)+
		u32 s1_h = get_bh();
		u32 s2 = get_y1();
		m_tmp1 = s1_h;
		m_tmp2 = s2;
		break;
		}
	case 1201: { // b,x1 y1,y:(r)
		u32 s1_h = get_bh();
		u32 s2 = get_y1();
		m_tmp1 = s1_h;
		m_tmp2 = s2;
		break;
		}
	case 1202: { // b,x1 y1,y:(r+n)
		u32 s1_h = get_bh();
		u32 s2 = get_y1();
		m_tmp1 = s1_h;
		m_tmp2 = s2;
		break;
		}
	case 1203: { // b,x1 y1,y:-(r)
		u32 s1_h = get_bh();
		u32 s2 = get_y1();
		m_tmp1 = s1_h;
		m_tmp2 = s2;
		break;
		}
	case 1204: { // a,x0 a,y:(r)-n
		u32 s1_h = get_ah();
		u32 s2_h = get_ah();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1205: { // a,x0 a,y:(r)+n
		u32 s1_h = get_ah();
		u32 s2_h = get_ah();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1206: { // a,x0 a,y:(r)-
		u32 s1_h = get_ah();
		u32 s2_h = get_ah();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1207: { // a,x0 a,y:(r)+
		u32 s1_h = get_ah();
		u32 s2_h = get_ah();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1208: { // a,x0 a,y:(r)
		u32 s1_h = get_ah();
		u32 s2_h = get_ah();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1209: { // a,x0 a,y:(r+n)
		u32 s1_h = get_ah();
		u32 s2_h = get_ah();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1210: { // a,x0 a,y:-(r)
		u32 s1_h = get_ah();
		u32 s2_h = get_ah();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1211: { // a,x1 a,y:(r)-n
		u32 s1_h = get_ah();
		u32 s2_h = get_ah();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1212: { // a,x1 a,y:(r)+n
		u32 s1_h = get_ah();
		u32 s2_h = get_ah();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1213: { // a,x1 a,y:(r)-
		u32 s1_h = get_ah();
		u32 s2_h = get_ah();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1214: { // a,x1 a,y:(r)+
		u32 s1_h = get_ah();
		u32 s2_h = get_ah();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1215: { // a,x1 a,y:(r)
		u32 s1_h = get_ah();
		u32 s2_h = get_ah();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1216: { // a,x1 a,y:(r+n)
		u32 s1_h = get_ah();
		u32 s2_h = get_ah();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1217: { // a,x1 a,y:-(r)
		u32 s1_h = get_ah();
		u32 s2_h = get_ah();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1218: { // b,x0 a,y:(r)-n
		u32 s1_h = get_bh();
		u32 s2_h = get_ah();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1219: { // b,x0 a,y:(r)+n
		u32 s1_h = get_bh();
		u32 s2_h = get_ah();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1220: { // b,x0 a,y:(r)-
		u32 s1_h = get_bh();
		u32 s2_h = get_ah();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1221: { // b,x0 a,y:(r)+
		u32 s1_h = get_bh();
		u32 s2_h = get_ah();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1222: { // b,x0 a,y:(r)
		u32 s1_h = get_bh();
		u32 s2_h = get_ah();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1223: { // b,x0 a,y:(r+n)
		u32 s1_h = get_bh();
		u32 s2_h = get_ah();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1224: { // b,x0 a,y:-(r)
		u32 s1_h = get_bh();
		u32 s2_h = get_ah();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1225: { // b,x1 a,y:(r)-n
		u32 s1_h = get_bh();
		u32 s2_h = get_ah();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1226: { // b,x1 a,y:(r)+n
		u32 s1_h = get_bh();
		u32 s2_h = get_ah();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1227: { // b,x1 a,y:(r)-
		u32 s1_h = get_bh();
		u32 s2_h = get_ah();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1228: { // b,x1 a,y:(r)+
		u32 s1_h = get_bh();
		u32 s2_h = get_ah();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1229: { // b,x1 a,y:(r)
		u32 s1_h = get_bh();
		u32 s2_h = get_ah();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1230: { // b,x1 a,y:(r+n)
		u32 s1_h = get_bh();
		u32 s2_h = get_ah();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1231: { // b,x1 a,y:-(r)
		u32 s1_h = get_bh();
		u32 s2_h = get_ah();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1232: { // a,x0 b,y:(r)-n
		u32 s1_h = get_ah();
		u32 s2_h = get_bh();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1233: { // a,x0 b,y:(r)+n
		u32 s1_h = get_ah();
		u32 s2_h = get_bh();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1234: { // a,x0 b,y:(r)-
		u32 s1_h = get_ah();
		u32 s2_h = get_bh();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1235: { // a,x0 b,y:(r)+
		u32 s1_h = get_ah();
		u32 s2_h = get_bh();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1236: { // a,x0 b,y:(r)
		u32 s1_h = get_ah();
		u32 s2_h = get_bh();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1237: { // a,x0 b,y:(r+n)
		u32 s1_h = get_ah();
		u32 s2_h = get_bh();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1238: { // a,x0 b,y:-(r)
		u32 s1_h = get_ah();
		u32 s2_h = get_bh();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1239: { // a,x1 b,y:(r)-n
		u32 s1_h = get_ah();
		u32 s2_h = get_bh();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1240: { // a,x1 b,y:(r)+n
		u32 s1_h = get_ah();
		u32 s2_h = get_bh();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1241: { // a,x1 b,y:(r)-
		u32 s1_h = get_ah();
		u32 s2_h = get_bh();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1242: { // a,x1 b,y:(r)+
		u32 s1_h = get_ah();
		u32 s2_h = get_bh();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1243: { // a,x1 b,y:(r)
		u32 s1_h = get_ah();
		u32 s2_h = get_bh();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1244: { // a,x1 b,y:(r+n)
		u32 s1_h = get_ah();
		u32 s2_h = get_bh();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1245: { // a,x1 b,y:-(r)
		u32 s1_h = get_ah();
		u32 s2_h = get_bh();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1246: { // b,x0 b,y:(r)-n
		u32 s1_h = get_bh();
		u32 s2_h = get_bh();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1247: { // b,x0 b,y:(r)+n
		u32 s1_h = get_bh();
		u32 s2_h = get_bh();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1248: { // b,x0 b,y:(r)-
		u32 s1_h = get_bh();
		u32 s2_h = get_bh();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1249: { // b,x0 b,y:(r)+
		u32 s1_h = get_bh();
		u32 s2_h = get_bh();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1250: { // b,x0 b,y:(r)
		u32 s1_h = get_bh();
		u32 s2_h = get_bh();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1251: { // b,x0 b,y:(r+n)
		u32 s1_h = get_bh();
		u32 s2_h = get_bh();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1252: { // b,x0 b,y:-(r)
		u32 s1_h = get_bh();
		u32 s2_h = get_bh();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1253: { // b,x1 b,y:(r)-n
		u32 s1_h = get_bh();
		u32 s2_h = get_bh();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1254: { // b,x1 b,y:(r)+n
		u32 s1_h = get_bh();
		u32 s2_h = get_bh();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1255: { // b,x1 b,y:(r)-
		u32 s1_h = get_bh();
		u32 s2_h = get_bh();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1256: { // b,x1 b,y:(r)+
		u32 s1_h = get_bh();
		u32 s2_h = get_bh();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1257: { // b,x1 b,y:(r)
		u32 s1_h = get_bh();
		u32 s2_h = get_bh();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1258: { // b,x1 b,y:(r+n)
		u32 s1_h = get_bh();
		u32 s2_h = get_bh();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1259: { // b,x1 b,y:-(r)
		u32 s1_h = get_bh();
		u32 s2_h = get_bh();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1260: { // a,x0 y:[abs],y0
		u32 s1_h = get_ah();
		u32 abs = exv;
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(abs);
		break;
		}
	case 1261: { // a,x1 y:[abs],y0
		u32 s1_h = get_ah();
		u32 abs = exv;
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(abs);
		break;
		}
	case 1262: { // b,x0 y:[abs],y0
		u32 s1_h = get_bh();
		u32 abs = exv;
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(abs);
		break;
		}
	case 1263: { // b,x1 y:[abs],y0
		u32 s1_h = get_bh();
		u32 abs = exv;
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(abs);
		break;
		}
	case 1264: { // a,x0 y:[abs],y1
		u32 s1_h = get_ah();
		u32 abs = exv;
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(abs);
		break;
		}
	case 1265: { // a,x1 y:[abs],y1
		u32 s1_h = get_ah();
		u32 abs = exv;
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(abs);
		break;
		}
	case 1266: { // b,x0 y:[abs],y1
		u32 s1_h = get_bh();
		u32 abs = exv;
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(abs);
		break;
		}
	case 1267: { // b,x1 y:[abs],y1
		u32 s1_h = get_bh();
		u32 abs = exv;
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(abs);
		break;
		}
	case 1268: { // a,x0 y:[abs],a
		u32 s1_h = get_ah();
		u32 abs = exv;
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(abs);
		break;
		}
	case 1269: { // a,x1 y:[abs],a
		u32 s1_h = get_ah();
		u32 abs = exv;
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(abs);
		break;
		}
	case 1270: { // b,x0 y:[abs],a
		u32 s1_h = get_bh();
		u32 abs = exv;
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(abs);
		break;
		}
	case 1271: { // b,x1 y:[abs],a
		u32 s1_h = get_bh();
		u32 abs = exv;
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(abs);
		break;
		}
	case 1272: { // a,x0 y:[abs],b
		u32 s1_h = get_ah();
		u32 abs = exv;
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(abs);
		break;
		}
	case 1273: { // a,x1 y:[abs],b
		u32 s1_h = get_ah();
		u32 abs = exv;
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(abs);
		break;
		}
	case 1274: { // b,x0 y:[abs],b
		u32 s1_h = get_bh();
		u32 abs = exv;
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(abs);
		break;
		}
	case 1275: { // b,x1 y:[abs],b
		u32 s1_h = get_bh();
		u32 abs = exv;
		m_tmp1 = s1_h;
		m_tmp2 = m_y.read_dword(abs);
		break;
		}
	case 1276: { // a,x0 y0,y:[abs]
		u32 s1_h = get_ah();
		u32 s2 = get_y0();
		m_tmp1 = s1_h;
		m_tmp2 = s2;
		break;
		}
	case 1277: { // a,x1 y0,y:[abs]
		u32 s1_h = get_ah();
		u32 s2 = get_y0();
		m_tmp1 = s1_h;
		m_tmp2 = s2;
		break;
		}
	case 1278: { // b,x0 y0,y:[abs]
		u32 s1_h = get_bh();
		u32 s2 = get_y0();
		m_tmp1 = s1_h;
		m_tmp2 = s2;
		break;
		}
	case 1279: { // b,x1 y0,y:[abs]
		u32 s1_h = get_bh();
		u32 s2 = get_y0();
		m_tmp1 = s1_h;
		m_tmp2 = s2;
		break;
		}
	case 1280: { // a,x0 y1,y:[abs]
		u32 s1_h = get_ah();
		u32 s2 = get_y1();
		m_tmp1 = s1_h;
		m_tmp2 = s2;
		break;
		}
	case 1281: { // a,x1 y1,y:[abs]
		u32 s1_h = get_ah();
		u32 s2 = get_y1();
		m_tmp1 = s1_h;
		m_tmp2 = s2;
		break;
		}
	case 1282: { // b,x0 y1,y:[abs]
		u32 s1_h = get_bh();
		u32 s2 = get_y1();
		m_tmp1 = s1_h;
		m_tmp2 = s2;
		break;
		}
	case 1283: { // b,x1 y1,y:[abs]
		u32 s1_h = get_bh();
		u32 s2 = get_y1();
		m_tmp1 = s1_h;
		m_tmp2 = s2;
		break;
		}
	case 1284: { // a,x0 a,y:[abs]
		u32 s1_h = get_ah();
		u32 s2_h = get_ah();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1285: { // a,x1 a,y:[abs]
		u32 s1_h = get_ah();
		u32 s2_h = get_ah();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1286: { // b,x0 a,y:[abs]
		u32 s1_h = get_bh();
		u32 s2_h = get_ah();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1287: { // b,x1 a,y:[abs]
		u32 s1_h = get_bh();
		u32 s2_h = get_ah();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1288: { // a,x0 b,y:[abs]
		u32 s1_h = get_ah();
		u32 s2_h = get_bh();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1289: { // a,x1 b,y:[abs]
		u32 s1_h = get_ah();
		u32 s2_h = get_bh();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1290: { // b,x0 b,y:[abs]
		u32 s1_h = get_bh();
		u32 s2_h = get_bh();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1291: { // b,x1 b,y:[abs]
		u32 s1_h = get_bh();
		u32 s2_h = get_bh();
		m_tmp1 = s1_h;
		m_tmp2 = s2_h;
		break;
		}
	case 1292: { // a,x0 #[i],y0
		u32 s1_h = get_ah();
		m_tmp1 = s1_h;
		break;
		}
	case 1293: { // a,x1 #[i],y0
		u32 s1_h = get_ah();
		m_tmp1 = s1_h;
		break;
		}
	case 1294: { // b,x0 #[i],y0
		u32 s1_h = get_bh();
		m_tmp1 = s1_h;
		break;
		}
	case 1295: { // b,x1 #[i],y0
		u32 s1_h = get_bh();
		m_tmp1 = s1_h;
		break;
		}
	case 1296: { // a,x0 #[i],y1
		u32 s1_h = get_ah();
		m_tmp1 = s1_h;
		break;
		}
	case 1297: { // a,x1 #[i],y1
		u32 s1_h = get_ah();
		m_tmp1 = s1_h;
		break;
		}
	case 1298: { // b,x0 #[i],y1
		u32 s1_h = get_bh();
		m_tmp1 = s1_h;
		break;
		}
	case 1299: { // b,x1 #[i],y1
		u32 s1_h = get_bh();
		m_tmp1 = s1_h;
		break;
		}
	case 1300: { // a,x0 #[i],a
		u32 s1_h = get_ah();
		m_tmp1 = s1_h;
		break;
		}
	case 1301: { // a,x1 #[i],a
		u32 s1_h = get_ah();
		m_tmp1 = s1_h;
		break;
		}
	case 1302: { // b,x0 #[i],a
		u32 s1_h = get_bh();
		m_tmp1 = s1_h;
		break;
		}
	case 1303: { // b,x1 #[i],a
		u32 s1_h = get_bh();
		m_tmp1 = s1_h;
		break;
		}
	case 1304: { // a,x0 #[i],b
		u32 s1_h = get_ah();
		m_tmp1 = s1_h;
		break;
		}
	case 1305: { // a,x1 #[i],b
		u32 s1_h = get_ah();
		m_tmp1 = s1_h;
		break;
		}
	case 1306: { // b,x0 #[i],b
		u32 s1_h = get_bh();
		m_tmp1 = s1_h;
		break;
		}
	case 1307: { // b,x1 #[i],b
		u32 s1_h = get_bh();
		m_tmp1 = s1_h;
		break;
		}
	case 1308: { // a,y:(r)-n y0,a
		m_tmp1 = get_ah();
		m_tmp2 = get_y0();
		break;
		}
	case 1309: { // a,y:(r)+n y0,a
		m_tmp1 = get_ah();
		m_tmp2 = get_y0();
		break;
		}
	case 1310: { // a,y:(r)- y0,a
		m_tmp1 = get_ah();
		m_tmp2 = get_y0();
		break;
		}
	case 1311: { // a,y:(r)+ y0,a
		m_tmp1 = get_ah();
		m_tmp2 = get_y0();
		break;
		}
	case 1312: { // a,y:(r) y0,a
		m_tmp1 = get_ah();
		m_tmp2 = get_y0();
		break;
		}
	case 1313: { // a,y:(r+n) y0,a
		m_tmp1 = get_ah();
		m_tmp2 = get_y0();
		break;
		}
	case 1314: { // a,y:-(r) y0,a
		m_tmp1 = get_ah();
		m_tmp2 = get_y0();
		break;
		}
	case 1315: { // b,y:(r)-n y0,b
		m_tmp1 = get_bh();
		m_tmp2 = get_y0();
		break;
		}
	case 1316: { // b,y:(r)+n y0,b
		m_tmp1 = get_bh();
		m_tmp2 = get_y0();
		break;
		}
	case 1317: { // b,y:(r)- y0,b
		m_tmp1 = get_bh();
		m_tmp2 = get_y0();
		break;
		}
	case 1318: { // b,y:(r)+ y0,b
		m_tmp1 = get_bh();
		m_tmp2 = get_y0();
		break;
		}
	case 1319: { // b,y:(r) y0,b
		m_tmp1 = get_bh();
		m_tmp2 = get_y0();
		break;
		}
	case 1320: { // b,y:(r+n) y0,b
		m_tmp1 = get_bh();
		m_tmp2 = get_y0();
		break;
		}
	case 1321: { // b,y:-(r) y0,b
		m_tmp1 = get_bh();
		m_tmp2 = get_y0();
		break;
		}
	case 1322: { // a,y:[abs] y0,a
		m_tmp1 = get_ah();
		m_tmp2 = get_y0();
		break;
		}
	case 1323: { // b,y:[abs] y0,b
		m_tmp1 = get_bh();
		m_tmp2 = get_y0();
		break;
		}
	case 1324: { // l:(r)-n,a10
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1325: { // l:(r)+n,a10
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1326: { // l:(r)-,a10
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1327: { // l:(r)+,a10
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1328: { // l:(r),a10
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1329: { // l:(r+n),a10
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1330: { // l:-(r),a10
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1331: { // l:(r)-n,b10
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1332: { // l:(r)+n,b10
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1333: { // l:(r)-,b10
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1334: { // l:(r)+,b10
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1335: { // l:(r),b10
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1336: { // l:(r+n),b10
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1337: { // l:-(r),b10
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1338: { // l:(r)-n,x
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1339: { // l:(r)+n,x
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1340: { // l:(r)-,x
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1341: { // l:(r)+,x
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1342: { // l:(r),x
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1343: { // l:(r+n),x
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1344: { // l:-(r),x
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1345: { // l:(r)-n,y
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1346: { // l:(r)+n,y
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1347: { // l:(r)-,y
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1348: { // l:(r)+,y
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1349: { // l:(r),y
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1350: { // l:(r+n),y
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1351: { // l:-(r),y
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1352: { // l:(r)-n,a
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1353: { // l:(r)+n,a
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1354: { // l:(r)-,a
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1355: { // l:(r)+,a
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1356: { // l:(r),a
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1357: { // l:(r+n),a
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1358: { // l:-(r),a
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1359: { // l:(r)-n,b
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1360: { // l:(r)+n,b
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1361: { // l:(r)-,b
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1362: { // l:(r)+,b
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1363: { // l:(r),b
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1364: { // l:(r+n),b
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1365: { // l:-(r),b
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1366: { // l:(r)-n,ab
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1367: { // l:(r)+n,ab
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1368: { // l:(r)-,ab
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1369: { // l:(r)+,ab
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1370: { // l:(r),ab
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1371: { // l:(r+n),ab
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1372: { // l:-(r),ab
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1373: { // l:(r)-n,ba
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1374: { // l:(r)+n,ba
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1375: { // l:(r)-,ba
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1376: { // l:(r)+,ba
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1377: { // l:(r),ba
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1378: { // l:(r+n),ba
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1379: { // l:-(r),ba
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_tmp1 = m_x.read_dword(ea);
		m_tmp2 = m_y.read_dword(ea);
		break;
		}
	case 1380: { // l:[abs],a10
		u32 abs = exv;
		m_tmp1 = m_x.read_dword(abs);
		m_tmp2 = m_y.read_dword(abs);
		break;
		}
	case 1381: { // l:[abs],b10
		u32 abs = exv;
		m_tmp1 = m_x.read_dword(abs);
		m_tmp2 = m_y.read_dword(abs);
		break;
		}
	case 1382: { // l:[abs],x
		u32 abs = exv;
		m_tmp1 = m_x.read_dword(abs);
		m_tmp2 = m_y.read_dword(abs);
		break;
		}
	case 1383: { // l:[abs],y
		u32 abs = exv;
		m_tmp1 = m_x.read_dword(abs);
		m_tmp2 = m_y.read_dword(abs);
		break;
		}
	case 1384: { // l:[abs],a
		u32 abs = exv;
		m_tmp1 = m_x.read_dword(abs);
		m_tmp2 = m_y.read_dword(abs);
		break;
		}
	case 1385: { // l:[abs],b
		u32 abs = exv;
		m_tmp1 = m_x.read_dword(abs);
		m_tmp2 = m_y.read_dword(abs);
		break;
		}
	case 1386: { // l:[abs],ab
		u32 abs = exv;
		m_tmp1 = m_x.read_dword(abs);
		m_tmp2 = m_y.read_dword(abs);
		break;
		}
	case 1387: { // l:[abs],ba
		u32 abs = exv;
		m_tmp1 = m_x.read_dword(abs);
		m_tmp2 = m_y.read_dword(abs);
		break;
		}
	case 1388: { // l:[aa],a10
		u32 aa = BIT(opcode, 8, 6);
		m_tmp1 = m_x.read_dword(aa);
		m_tmp2 = m_y.read_dword(aa);
		break;
		}
	case 1389: { // l:[aa],b10
		u32 aa = BIT(opcode, 8, 6);
		m_tmp1 = m_x.read_dword(aa);
		m_tmp2 = m_y.read_dword(aa);
		break;
		}
	case 1390: { // l:[aa],x
		u32 aa = BIT(opcode, 8, 6);
		m_tmp1 = m_x.read_dword(aa);
		m_tmp2 = m_y.read_dword(aa);
		break;
		}
	case 1391: { // l:[aa],y
		u32 aa = BIT(opcode, 8, 6);
		m_tmp1 = m_x.read_dword(aa);
		m_tmp2 = m_y.read_dword(aa);
		break;
		}
	case 1392: { // l:[aa],a
		u32 aa = BIT(opcode, 8, 6);
		m_tmp1 = m_x.read_dword(aa);
		m_tmp2 = m_y.read_dword(aa);
		break;
		}
	case 1393: { // l:[aa],b
		u32 aa = BIT(opcode, 8, 6);
		m_tmp1 = m_x.read_dword(aa);
		m_tmp2 = m_y.read_dword(aa);
		break;
		}
	case 1394: { // l:[aa],ab
		u32 aa = BIT(opcode, 8, 6);
		m_tmp1 = m_x.read_dword(aa);
		m_tmp2 = m_y.read_dword(aa);
		break;
		}
	case 1395: { // l:[aa],ba
		u32 aa = BIT(opcode, 8, 6);
		m_tmp1 = m_x.read_dword(aa);
		m_tmp2 = m_y.read_dword(aa);
		break;
		}
	case 1396: { // a10,l:(r)-n
		u64 s = get_a10();
		m_tmp1 = s >> 24;
		m_tmp2 = s & 0xffffff;
		break;
		}
	case 1397: { // a10,l:(r)+n
		u64 s = get_a10();
		m_tmp1 = s >> 24;
		m_tmp2 = s & 0xffffff;
		break;
		}
	case 1398: { // a10,l:(r)-
		u64 s = get_a10();
		m_tmp1 = s >> 24;
		m_tmp2 = s & 0xffffff;
		break;
		}
	case 1399: { // a10,l:(r)+
		u64 s = get_a10();
		m_tmp1 = s >> 24;
		m_tmp2 = s & 0xffffff;
		break;
		}
	case 1400: { // a10,l:(r)
		u64 s = get_a10();
		m_tmp1 = s >> 24;
		m_tmp2 = s & 0xffffff;
		break;
		}
	case 1401: { // a10,l:(r+n)
		u64 s = get_a10();
		m_tmp1 = s >> 24;
		m_tmp2 = s & 0xffffff;
		break;
		}
	case 1402: { // a10,l:-(r)
		u64 s = get_a10();
		m_tmp1 = s >> 24;
		m_tmp2 = s & 0xffffff;
		break;
		}
	case 1403: { // b10,l:(r)-n
		u64 s = get_b10();
		m_tmp1 = s >> 24;
		m_tmp2 = s & 0xffffff;
		break;
		}
	case 1404: { // b10,l:(r)+n
		u64 s = get_b10();
		m_tmp1 = s >> 24;
		m_tmp2 = s & 0xffffff;
		break;
		}
	case 1405: { // b10,l:(r)-
		u64 s = get_b10();
		m_tmp1 = s >> 24;
		m_tmp2 = s & 0xffffff;
		break;
		}
	case 1406: { // b10,l:(r)+
		u64 s = get_b10();
		m_tmp1 = s >> 24;
		m_tmp2 = s & 0xffffff;
		break;
		}
	case 1407: { // b10,l:(r)
		u64 s = get_b10();
		m_tmp1 = s >> 24;
		m_tmp2 = s & 0xffffff;
		break;
		}
	case 1408: { // b10,l:(r+n)
		u64 s = get_b10();
		m_tmp1 = s >> 24;
		m_tmp2 = s & 0xffffff;
		break;
		}
	case 1409: { // b10,l:-(r)
		u64 s = get_b10();
		m_tmp1 = s >> 24;
		m_tmp2 = s & 0xffffff;
		break;
		}
	case 1410: { // x,l:(r)-n
		u64 s = get_x();
		m_tmp1 = s >> 24;
		m_tmp2 = s & 0xffffff;
		break;
		}
	case 1411: { // x,l:(r)+n
		u64 s = get_x();
		m_tmp1 = s >> 24;
		m_tmp2 = s & 0xffffff;
		break;
		}
	case 1412: { // x,l:(r)-
		u64 s = get_x();
		m_tmp1 = s >> 24;
		m_tmp2 = s & 0xffffff;
		break;
		}
	case 1413: { // x,l:(r)+
		u64 s = get_x();
		m_tmp1 = s >> 24;
		m_tmp2 = s & 0xffffff;
		break;
		}
	case 1414: { // x,l:(r)
		u64 s = get_x();
		m_tmp1 = s >> 24;
		m_tmp2 = s & 0xffffff;
		break;
		}
	case 1415: { // x,l:(r+n)
		u64 s = get_x();
		m_tmp1 = s >> 24;
		m_tmp2 = s & 0xffffff;
		break;
		}
	case 1416: { // x,l:-(r)
		u64 s = get_x();
		m_tmp1 = s >> 24;
		m_tmp2 = s & 0xffffff;
		break;
		}
	case 1417: { // y,l:(r)-n
		u64 s = get_y();
		m_tmp1 = s >> 24;
		m_tmp2 = s & 0xffffff;
		break;
		}
	case 1418: { // y,l:(r)+n
		u64 s = get_y();
		m_tmp1 = s >> 24;
		m_tmp2 = s & 0xffffff;
		break;
		}
	case 1419: { // y,l:(r)-
		u64 s = get_y();
		m_tmp1 = s >> 24;
		m_tmp2 = s & 0xffffff;
		break;
		}
	case 1420: { // y,l:(r)+
		u64 s = get_y();
		m_tmp1 = s >> 24;
		m_tmp2 = s & 0xffffff;
		break;
		}
	case 1421: { // y,l:(r)
		u64 s = get_y();
		m_tmp1 = s >> 24;
		m_tmp2 = s & 0xffffff;
		break;
		}
	case 1422: { // y,l:(r+n)
		u64 s = get_y();
		m_tmp1 = s >> 24;
		m_tmp2 = s & 0xffffff;
		break;
		}
	case 1423: { // y,l:-(r)
		u64 s = get_y();
		m_tmp1 = s >> 24;
		m_tmp2 = s & 0xffffff;
		break;
		}
	case 1424: { // a,l:(r)-n
		u64 s_l = get_al();
		m_tmp1 = s_l >> 24;
		m_tmp2 = s_l & 0xffffff;
		break;
		}
	case 1425: { // a,l:(r)+n
		u64 s_l = get_al();
		m_tmp1 = s_l >> 24;
		m_tmp2 = s_l & 0xffffff;
		break;
		}
	case 1426: { // a,l:(r)-
		u64 s_l = get_al();
		m_tmp1 = s_l >> 24;
		m_tmp2 = s_l & 0xffffff;
		break;
		}
	case 1427: { // a,l:(r)+
		u64 s_l = get_al();
		m_tmp1 = s_l >> 24;
		m_tmp2 = s_l & 0xffffff;
		break;
		}
	case 1428: { // a,l:(r)
		u64 s_l = get_al();
		m_tmp1 = s_l >> 24;
		m_tmp2 = s_l & 0xffffff;
		break;
		}
	case 1429: { // a,l:(r+n)
		u64 s_l = get_al();
		m_tmp1 = s_l >> 24;
		m_tmp2 = s_l & 0xffffff;
		break;
		}
	case 1430: { // a,l:-(r)
		u64 s_l = get_al();
		m_tmp1 = s_l >> 24;
		m_tmp2 = s_l & 0xffffff;
		break;
		}
	case 1431: { // b,l:(r)-n
		u64 s_l = get_bl();
		m_tmp1 = s_l >> 24;
		m_tmp2 = s_l & 0xffffff;
		break;
		}
	case 1432: { // b,l:(r)+n
		u64 s_l = get_bl();
		m_tmp1 = s_l >> 24;
		m_tmp2 = s_l & 0xffffff;
		break;
		}
	case 1433: { // b,l:(r)-
		u64 s_l = get_bl();
		m_tmp1 = s_l >> 24;
		m_tmp2 = s_l & 0xffffff;
		break;
		}
	case 1434: { // b,l:(r)+
		u64 s_l = get_bl();
		m_tmp1 = s_l >> 24;
		m_tmp2 = s_l & 0xffffff;
		break;
		}
	case 1435: { // b,l:(r)
		u64 s_l = get_bl();
		m_tmp1 = s_l >> 24;
		m_tmp2 = s_l & 0xffffff;
		break;
		}
	case 1436: { // b,l:(r+n)
		u64 s_l = get_bl();
		m_tmp1 = s_l >> 24;
		m_tmp2 = s_l & 0xffffff;
		break;
		}
	case 1437: { // b,l:-(r)
		u64 s_l = get_bl();
		m_tmp1 = s_l >> 24;
		m_tmp2 = s_l & 0xffffff;
		break;
		}
	case 1438: { // ab,l:(r)-n
		u64 s = get_ab();
		m_tmp1 = s >> 24;
		m_tmp2 = s & 0xffffff;
		break;
		}
	case 1439: { // ab,l:(r)+n
		u64 s = get_ab();
		m_tmp1 = s >> 24;
		m_tmp2 = s & 0xffffff;
		break;
		}
	case 1440: { // ab,l:(r)-
		u64 s = get_ab();
		m_tmp1 = s >> 24;
		m_tmp2 = s & 0xffffff;
		break;
		}
	case 1441: { // ab,l:(r)+
		u64 s = get_ab();
		m_tmp1 = s >> 24;
		m_tmp2 = s & 0xffffff;
		break;
		}
	case 1442: { // ab,l:(r)
		u64 s = get_ab();
		m_tmp1 = s >> 24;
		m_tmp2 = s & 0xffffff;
		break;
		}
	case 1443: { // ab,l:(r+n)
		u64 s = get_ab();
		m_tmp1 = s >> 24;
		m_tmp2 = s & 0xffffff;
		break;
		}
	case 1444: { // ab,l:-(r)
		u64 s = get_ab();
		m_tmp1 = s >> 24;
		m_tmp2 = s & 0xffffff;
		break;
		}
	case 1445: { // ba,l:(r)-n
		u64 s = get_ba();
		m_tmp1 = s >> 24;
		m_tmp2 = s & 0xffffff;
		break;
		}
	case 1446: { // ba,l:(r)+n
		u64 s = get_ba();
		m_tmp1 = s >> 24;
		m_tmp2 = s & 0xffffff;
		break;
		}
	case 1447: { // ba,l:(r)-
		u64 s = get_ba();
		m_tmp1 = s >> 24;
		m_tmp2 = s & 0xffffff;
		break;
		}
	case 1448: { // ba,l:(r)+
		u64 s = get_ba();
		m_tmp1 = s >> 24;
		m_tmp2 = s & 0xffffff;
		break;
		}
	case 1449: { // ba,l:(r)
		u64 s = get_ba();
		m_tmp1 = s >> 24;
		m_tmp2 = s & 0xffffff;
		break;
		}
	case 1450: { // ba,l:(r+n)
		u64 s = get_ba();
		m_tmp1 = s >> 24;
		m_tmp2 = s & 0xffffff;
		break;
		}
	case 1451: { // ba,l:-(r)
		u64 s = get_ba();
		m_tmp1 = s >> 24;
		m_tmp2 = s & 0xffffff;
		break;
		}
	case 1452: { // a10,l:[abs]
		u64 s = get_a10();
		m_tmp1 = s >> 24;
		m_tmp2 = s & 0xffffff;
		break;
		}
	case 1453: { // b10,l:[abs]
		u64 s = get_b10();
		m_tmp1 = s >> 24;
		m_tmp2 = s & 0xffffff;
		break;
		}
	case 1454: { // x,l:[abs]
		u64 s = get_x();
		m_tmp1 = s >> 24;
		m_tmp2 = s & 0xffffff;
		break;
		}
	case 1455: { // y,l:[abs]
		u64 s = get_y();
		m_tmp1 = s >> 24;
		m_tmp2 = s & 0xffffff;
		break;
		}
	case 1456: { // a,l:[abs]
		u64 s_l = get_al();
		m_tmp1 = s_l >> 24;
		m_tmp2 = s_l & 0xffffff;
		break;
		}
	case 1457: { // b,l:[abs]
		u64 s_l = get_bl();
		m_tmp1 = s_l >> 24;
		m_tmp2 = s_l & 0xffffff;
		break;
		}
	case 1458: { // ab,l:[abs]
		u64 s = get_ab();
		m_tmp1 = s >> 24;
		m_tmp2 = s & 0xffffff;
		break;
		}
	case 1459: { // ba,l:[abs]
		u64 s = get_ba();
		m_tmp1 = s >> 24;
		m_tmp2 = s & 0xffffff;
		break;
		}
	case 1460: { // a10,l:[aa]
		u64 s = get_a10();
		m_tmp1 = s >> 24;
		m_tmp2 = s & 0xffffff;
		break;
		}
	case 1461: { // b10,l:[aa]
		u64 s = get_b10();
		m_tmp1 = s >> 24;
		m_tmp2 = s & 0xffffff;
		break;
		}
	case 1462: { // x,l:[aa]
		u64 s = get_x();
		m_tmp1 = s >> 24;
		m_tmp2 = s & 0xffffff;
		break;
		}
	case 1463: { // y,l:[aa]
		u64 s = get_y();
		m_tmp1 = s >> 24;
		m_tmp2 = s & 0xffffff;
		break;
		}
	case 1464: { // a,l:[aa]
		u64 s_l = get_al();
		m_tmp1 = s_l >> 24;
		m_tmp2 = s_l & 0xffffff;
		break;
		}
	case 1465: { // b,l:[aa]
		u64 s_l = get_bl();
		m_tmp1 = s_l >> 24;
		m_tmp2 = s_l & 0xffffff;
		break;
		}
	case 1466: { // ab,l:[aa]
		u64 s = get_ab();
		m_tmp1 = s >> 24;
		m_tmp2 = s & 0xffffff;
		break;
		}
	case 1467: { // ba,l:[aa]
		u64 s = get_ba();
		m_tmp1 = s >> 24;
		m_tmp2 = s & 0xffffff;
		break;
		}
	case 1468: { // x:(r)+n,x0 y:(rh)+n,y0
		unhandled("x:(r)+n,x0 y:(rh)+n,y0");
		break;
		}
	case 1469: { // x:(r)+n,x0 y:(rh)+n,y1
		unhandled("x:(r)+n,x0 y:(rh)+n,y1");
		break;
		}
	case 1470: { // x:(r)+n,x0 y:(rh)+n,a
		unhandled("x:(r)+n,x0 y:(rh)+n,a");
		break;
		}
	case 1471: { // x:(r)+n,x0 y:(rh)+n,b
		unhandled("x:(r)+n,x0 y:(rh)+n,b");
		break;
		}
	case 1472: { // x:(r)+n,x1 y:(rh)+n,y0
		unhandled("x:(r)+n,x1 y:(rh)+n,y0");
		break;
		}
	case 1473: { // x:(r)+n,x1 y:(rh)+n,y1
		unhandled("x:(r)+n,x1 y:(rh)+n,y1");
		break;
		}
	case 1474: { // x:(r)+n,x1 y:(rh)+n,a
		unhandled("x:(r)+n,x1 y:(rh)+n,a");
		break;
		}
	case 1475: { // x:(r)+n,x1 y:(rh)+n,b
		unhandled("x:(r)+n,x1 y:(rh)+n,b");
		break;
		}
	case 1476: { // x:(r)+n,a y:(rh)+n,y0
		unhandled("x:(r)+n,a y:(rh)+n,y0");
		break;
		}
	case 1477: { // x:(r)+n,a y:(rh)+n,y1
		unhandled("x:(r)+n,a y:(rh)+n,y1");
		break;
		}
	case 1478: { // x:(r)+n,a y:(rh)+n,a
		unhandled("x:(r)+n,a y:(rh)+n,a");
		break;
		}
	case 1479: { // x:(r)+n,a y:(rh)+n,b
		unhandled("x:(r)+n,a y:(rh)+n,b");
		break;
		}
	case 1480: { // x:(r)+n,b y:(rh)+n,y0
		unhandled("x:(r)+n,b y:(rh)+n,y0");
		break;
		}
	case 1481: { // x:(r)+n,b y:(rh)+n,y1
		unhandled("x:(r)+n,b y:(rh)+n,y1");
		break;
		}
	case 1482: { // x:(r)+n,b y:(rh)+n,a
		unhandled("x:(r)+n,b y:(rh)+n,a");
		break;
		}
	case 1483: { // x:(r)+n,b y:(rh)+n,b
		unhandled("x:(r)+n,b y:(rh)+n,b");
		break;
		}
	case 1484: { // x:(r)+n,x0 y:(rh)-,y0
		unhandled("x:(r)+n,x0 y:(rh)-,y0");
		break;
		}
	case 1485: { // x:(r)+n,x0 y:(rh)-,y1
		unhandled("x:(r)+n,x0 y:(rh)-,y1");
		break;
		}
	case 1486: { // x:(r)+n,x0 y:(rh)-,a
		unhandled("x:(r)+n,x0 y:(rh)-,a");
		break;
		}
	case 1487: { // x:(r)+n,x0 y:(rh)-,b
		unhandled("x:(r)+n,x0 y:(rh)-,b");
		break;
		}
	case 1488: { // x:(r)+n,x1 y:(rh)-,y0
		unhandled("x:(r)+n,x1 y:(rh)-,y0");
		break;
		}
	case 1489: { // x:(r)+n,x1 y:(rh)-,y1
		unhandled("x:(r)+n,x1 y:(rh)-,y1");
		break;
		}
	case 1490: { // x:(r)+n,x1 y:(rh)-,a
		unhandled("x:(r)+n,x1 y:(rh)-,a");
		break;
		}
	case 1491: { // x:(r)+n,x1 y:(rh)-,b
		unhandled("x:(r)+n,x1 y:(rh)-,b");
		break;
		}
	case 1492: { // x:(r)+n,a y:(rh)-,y0
		unhandled("x:(r)+n,a y:(rh)-,y0");
		break;
		}
	case 1493: { // x:(r)+n,a y:(rh)-,y1
		unhandled("x:(r)+n,a y:(rh)-,y1");
		break;
		}
	case 1494: { // x:(r)+n,a y:(rh)-,a
		unhandled("x:(r)+n,a y:(rh)-,a");
		break;
		}
	case 1495: { // x:(r)+n,a y:(rh)-,b
		unhandled("x:(r)+n,a y:(rh)-,b");
		break;
		}
	case 1496: { // x:(r)+n,b y:(rh)-,y0
		unhandled("x:(r)+n,b y:(rh)-,y0");
		break;
		}
	case 1497: { // x:(r)+n,b y:(rh)-,y1
		unhandled("x:(r)+n,b y:(rh)-,y1");
		break;
		}
	case 1498: { // x:(r)+n,b y:(rh)-,a
		unhandled("x:(r)+n,b y:(rh)-,a");
		break;
		}
	case 1499: { // x:(r)+n,b y:(rh)-,b
		unhandled("x:(r)+n,b y:(rh)-,b");
		break;
		}
	case 1500: { // x:(r)+n,x0 y:(rh)+,y0
		unhandled("x:(r)+n,x0 y:(rh)+,y0");
		break;
		}
	case 1501: { // x:(r)+n,x0 y:(rh)+,y1
		unhandled("x:(r)+n,x0 y:(rh)+,y1");
		break;
		}
	case 1502: { // x:(r)+n,x0 y:(rh)+,a
		unhandled("x:(r)+n,x0 y:(rh)+,a");
		break;
		}
	case 1503: { // x:(r)+n,x0 y:(rh)+,b
		unhandled("x:(r)+n,x0 y:(rh)+,b");
		break;
		}
	case 1504: { // x:(r)+n,x1 y:(rh)+,y0
		unhandled("x:(r)+n,x1 y:(rh)+,y0");
		break;
		}
	case 1505: { // x:(r)+n,x1 y:(rh)+,y1
		unhandled("x:(r)+n,x1 y:(rh)+,y1");
		break;
		}
	case 1506: { // x:(r)+n,x1 y:(rh)+,a
		unhandled("x:(r)+n,x1 y:(rh)+,a");
		break;
		}
	case 1507: { // x:(r)+n,x1 y:(rh)+,b
		unhandled("x:(r)+n,x1 y:(rh)+,b");
		break;
		}
	case 1508: { // x:(r)+n,a y:(rh)+,y0
		unhandled("x:(r)+n,a y:(rh)+,y0");
		break;
		}
	case 1509: { // x:(r)+n,a y:(rh)+,y1
		unhandled("x:(r)+n,a y:(rh)+,y1");
		break;
		}
	case 1510: { // x:(r)+n,a y:(rh)+,a
		unhandled("x:(r)+n,a y:(rh)+,a");
		break;
		}
	case 1511: { // x:(r)+n,a y:(rh)+,b
		unhandled("x:(r)+n,a y:(rh)+,b");
		break;
		}
	case 1512: { // x:(r)+n,b y:(rh)+,y0
		unhandled("x:(r)+n,b y:(rh)+,y0");
		break;
		}
	case 1513: { // x:(r)+n,b y:(rh)+,y1
		unhandled("x:(r)+n,b y:(rh)+,y1");
		break;
		}
	case 1514: { // x:(r)+n,b y:(rh)+,a
		unhandled("x:(r)+n,b y:(rh)+,a");
		break;
		}
	case 1515: { // x:(r)+n,b y:(rh)+,b
		unhandled("x:(r)+n,b y:(rh)+,b");
		break;
		}
	case 1516: { // x:(r)+n,x0 y:(rh),y0
		unhandled("x:(r)+n,x0 y:(rh),y0");
		break;
		}
	case 1517: { // x:(r)+n,x0 y:(rh),y1
		unhandled("x:(r)+n,x0 y:(rh),y1");
		break;
		}
	case 1518: { // x:(r)+n,x0 y:(rh),a
		unhandled("x:(r)+n,x0 y:(rh),a");
		break;
		}
	case 1519: { // x:(r)+n,x0 y:(rh),b
		unhandled("x:(r)+n,x0 y:(rh),b");
		break;
		}
	case 1520: { // x:(r)+n,x1 y:(rh),y0
		unhandled("x:(r)+n,x1 y:(rh),y0");
		break;
		}
	case 1521: { // x:(r)+n,x1 y:(rh),y1
		unhandled("x:(r)+n,x1 y:(rh),y1");
		break;
		}
	case 1522: { // x:(r)+n,x1 y:(rh),a
		unhandled("x:(r)+n,x1 y:(rh),a");
		break;
		}
	case 1523: { // x:(r)+n,x1 y:(rh),b
		unhandled("x:(r)+n,x1 y:(rh),b");
		break;
		}
	case 1524: { // x:(r)+n,a y:(rh),y0
		unhandled("x:(r)+n,a y:(rh),y0");
		break;
		}
	case 1525: { // x:(r)+n,a y:(rh),y1
		unhandled("x:(r)+n,a y:(rh),y1");
		break;
		}
	case 1526: { // x:(r)+n,a y:(rh),a
		unhandled("x:(r)+n,a y:(rh),a");
		break;
		}
	case 1527: { // x:(r)+n,a y:(rh),b
		unhandled("x:(r)+n,a y:(rh),b");
		break;
		}
	case 1528: { // x:(r)+n,b y:(rh),y0
		unhandled("x:(r)+n,b y:(rh),y0");
		break;
		}
	case 1529: { // x:(r)+n,b y:(rh),y1
		unhandled("x:(r)+n,b y:(rh),y1");
		break;
		}
	case 1530: { // x:(r)+n,b y:(rh),a
		unhandled("x:(r)+n,b y:(rh),a");
		break;
		}
	case 1531: { // x:(r)+n,b y:(rh),b
		unhandled("x:(r)+n,b y:(rh),b");
		break;
		}
	case 1532: { // x:(r)-,x0 y:(rh)+n,y0
		unhandled("x:(r)-,x0 y:(rh)+n,y0");
		break;
		}
	case 1533: { // x:(r)-,x0 y:(rh)+n,y1
		unhandled("x:(r)-,x0 y:(rh)+n,y1");
		break;
		}
	case 1534: { // x:(r)-,x0 y:(rh)+n,a
		unhandled("x:(r)-,x0 y:(rh)+n,a");
		break;
		}
	case 1535: { // x:(r)-,x0 y:(rh)+n,b
		unhandled("x:(r)-,x0 y:(rh)+n,b");
		break;
		}
	case 1536: { // x:(r)-,x1 y:(rh)+n,y0
		unhandled("x:(r)-,x1 y:(rh)+n,y0");
		break;
		}
	case 1537: { // x:(r)-,x1 y:(rh)+n,y1
		unhandled("x:(r)-,x1 y:(rh)+n,y1");
		break;
		}
	case 1538: { // x:(r)-,x1 y:(rh)+n,a
		unhandled("x:(r)-,x1 y:(rh)+n,a");
		break;
		}
	case 1539: { // x:(r)-,x1 y:(rh)+n,b
		unhandled("x:(r)-,x1 y:(rh)+n,b");
		break;
		}
	case 1540: { // x:(r)-,a y:(rh)+n,y0
		unhandled("x:(r)-,a y:(rh)+n,y0");
		break;
		}
	case 1541: { // x:(r)-,a y:(rh)+n,y1
		unhandled("x:(r)-,a y:(rh)+n,y1");
		break;
		}
	case 1542: { // x:(r)-,a y:(rh)+n,a
		unhandled("x:(r)-,a y:(rh)+n,a");
		break;
		}
	case 1543: { // x:(r)-,a y:(rh)+n,b
		unhandled("x:(r)-,a y:(rh)+n,b");
		break;
		}
	case 1544: { // x:(r)-,b y:(rh)+n,y0
		unhandled("x:(r)-,b y:(rh)+n,y0");
		break;
		}
	case 1545: { // x:(r)-,b y:(rh)+n,y1
		unhandled("x:(r)-,b y:(rh)+n,y1");
		break;
		}
	case 1546: { // x:(r)-,b y:(rh)+n,a
		unhandled("x:(r)-,b y:(rh)+n,a");
		break;
		}
	case 1547: { // x:(r)-,b y:(rh)+n,b
		unhandled("x:(r)-,b y:(rh)+n,b");
		break;
		}
	case 1548: { // x:(r)-,x0 y:(rh)-,y0
		unhandled("x:(r)-,x0 y:(rh)-,y0");
		break;
		}
	case 1549: { // x:(r)-,x0 y:(rh)-,y1
		unhandled("x:(r)-,x0 y:(rh)-,y1");
		break;
		}
	case 1550: { // x:(r)-,x0 y:(rh)-,a
		unhandled("x:(r)-,x0 y:(rh)-,a");
		break;
		}
	case 1551: { // x:(r)-,x0 y:(rh)-,b
		unhandled("x:(r)-,x0 y:(rh)-,b");
		break;
		}
	case 1552: { // x:(r)-,x1 y:(rh)-,y0
		unhandled("x:(r)-,x1 y:(rh)-,y0");
		break;
		}
	case 1553: { // x:(r)-,x1 y:(rh)-,y1
		unhandled("x:(r)-,x1 y:(rh)-,y1");
		break;
		}
	case 1554: { // x:(r)-,x1 y:(rh)-,a
		unhandled("x:(r)-,x1 y:(rh)-,a");
		break;
		}
	case 1555: { // x:(r)-,x1 y:(rh)-,b
		unhandled("x:(r)-,x1 y:(rh)-,b");
		break;
		}
	case 1556: { // x:(r)-,a y:(rh)-,y0
		unhandled("x:(r)-,a y:(rh)-,y0");
		break;
		}
	case 1557: { // x:(r)-,a y:(rh)-,y1
		unhandled("x:(r)-,a y:(rh)-,y1");
		break;
		}
	case 1558: { // x:(r)-,a y:(rh)-,a
		unhandled("x:(r)-,a y:(rh)-,a");
		break;
		}
	case 1559: { // x:(r)-,a y:(rh)-,b
		unhandled("x:(r)-,a y:(rh)-,b");
		break;
		}
	case 1560: { // x:(r)-,b y:(rh)-,y0
		unhandled("x:(r)-,b y:(rh)-,y0");
		break;
		}
	case 1561: { // x:(r)-,b y:(rh)-,y1
		unhandled("x:(r)-,b y:(rh)-,y1");
		break;
		}
	case 1562: { // x:(r)-,b y:(rh)-,a
		unhandled("x:(r)-,b y:(rh)-,a");
		break;
		}
	case 1563: { // x:(r)-,b y:(rh)-,b
		unhandled("x:(r)-,b y:(rh)-,b");
		break;
		}
	case 1564: { // x:(r)-,x0 y:(rh)+,y0
		unhandled("x:(r)-,x0 y:(rh)+,y0");
		break;
		}
	case 1565: { // x:(r)-,x0 y:(rh)+,y1
		unhandled("x:(r)-,x0 y:(rh)+,y1");
		break;
		}
	case 1566: { // x:(r)-,x0 y:(rh)+,a
		unhandled("x:(r)-,x0 y:(rh)+,a");
		break;
		}
	case 1567: { // x:(r)-,x0 y:(rh)+,b
		unhandled("x:(r)-,x0 y:(rh)+,b");
		break;
		}
	case 1568: { // x:(r)-,x1 y:(rh)+,y0
		unhandled("x:(r)-,x1 y:(rh)+,y0");
		break;
		}
	case 1569: { // x:(r)-,x1 y:(rh)+,y1
		unhandled("x:(r)-,x1 y:(rh)+,y1");
		break;
		}
	case 1570: { // x:(r)-,x1 y:(rh)+,a
		unhandled("x:(r)-,x1 y:(rh)+,a");
		break;
		}
	case 1571: { // x:(r)-,x1 y:(rh)+,b
		unhandled("x:(r)-,x1 y:(rh)+,b");
		break;
		}
	case 1572: { // x:(r)-,a y:(rh)+,y0
		unhandled("x:(r)-,a y:(rh)+,y0");
		break;
		}
	case 1573: { // x:(r)-,a y:(rh)+,y1
		unhandled("x:(r)-,a y:(rh)+,y1");
		break;
		}
	case 1574: { // x:(r)-,a y:(rh)+,a
		unhandled("x:(r)-,a y:(rh)+,a");
		break;
		}
	case 1575: { // x:(r)-,a y:(rh)+,b
		unhandled("x:(r)-,a y:(rh)+,b");
		break;
		}
	case 1576: { // x:(r)-,b y:(rh)+,y0
		unhandled("x:(r)-,b y:(rh)+,y0");
		break;
		}
	case 1577: { // x:(r)-,b y:(rh)+,y1
		unhandled("x:(r)-,b y:(rh)+,y1");
		break;
		}
	case 1578: { // x:(r)-,b y:(rh)+,a
		unhandled("x:(r)-,b y:(rh)+,a");
		break;
		}
	case 1579: { // x:(r)-,b y:(rh)+,b
		unhandled("x:(r)-,b y:(rh)+,b");
		break;
		}
	case 1580: { // x:(r)-,x0 y:(rh),y0
		unhandled("x:(r)-,x0 y:(rh),y0");
		break;
		}
	case 1581: { // x:(r)-,x0 y:(rh),y1
		unhandled("x:(r)-,x0 y:(rh),y1");
		break;
		}
	case 1582: { // x:(r)-,x0 y:(rh),a
		unhandled("x:(r)-,x0 y:(rh),a");
		break;
		}
	case 1583: { // x:(r)-,x0 y:(rh),b
		unhandled("x:(r)-,x0 y:(rh),b");
		break;
		}
	case 1584: { // x:(r)-,x1 y:(rh),y0
		unhandled("x:(r)-,x1 y:(rh),y0");
		break;
		}
	case 1585: { // x:(r)-,x1 y:(rh),y1
		unhandled("x:(r)-,x1 y:(rh),y1");
		break;
		}
	case 1586: { // x:(r)-,x1 y:(rh),a
		unhandled("x:(r)-,x1 y:(rh),a");
		break;
		}
	case 1587: { // x:(r)-,x1 y:(rh),b
		unhandled("x:(r)-,x1 y:(rh),b");
		break;
		}
	case 1588: { // x:(r)-,a y:(rh),y0
		unhandled("x:(r)-,a y:(rh),y0");
		break;
		}
	case 1589: { // x:(r)-,a y:(rh),y1
		unhandled("x:(r)-,a y:(rh),y1");
		break;
		}
	case 1590: { // x:(r)-,a y:(rh),a
		unhandled("x:(r)-,a y:(rh),a");
		break;
		}
	case 1591: { // x:(r)-,a y:(rh),b
		unhandled("x:(r)-,a y:(rh),b");
		break;
		}
	case 1592: { // x:(r)-,b y:(rh),y0
		unhandled("x:(r)-,b y:(rh),y0");
		break;
		}
	case 1593: { // x:(r)-,b y:(rh),y1
		unhandled("x:(r)-,b y:(rh),y1");
		break;
		}
	case 1594: { // x:(r)-,b y:(rh),a
		unhandled("x:(r)-,b y:(rh),a");
		break;
		}
	case 1595: { // x:(r)-,b y:(rh),b
		unhandled("x:(r)-,b y:(rh),b");
		break;
		}
	case 1596: { // x:(r)+,x0 y:(rh)+n,y0
		unhandled("x:(r)+,x0 y:(rh)+n,y0");
		break;
		}
	case 1597: { // x:(r)+,x0 y:(rh)+n,y1
		unhandled("x:(r)+,x0 y:(rh)+n,y1");
		break;
		}
	case 1598: { // x:(r)+,x0 y:(rh)+n,a
		unhandled("x:(r)+,x0 y:(rh)+n,a");
		break;
		}
	case 1599: { // x:(r)+,x0 y:(rh)+n,b
		unhandled("x:(r)+,x0 y:(rh)+n,b");
		break;
		}
	case 1600: { // x:(r)+,x1 y:(rh)+n,y0
		unhandled("x:(r)+,x1 y:(rh)+n,y0");
		break;
		}
	case 1601: { // x:(r)+,x1 y:(rh)+n,y1
		unhandled("x:(r)+,x1 y:(rh)+n,y1");
		break;
		}
	case 1602: { // x:(r)+,x1 y:(rh)+n,a
		unhandled("x:(r)+,x1 y:(rh)+n,a");
		break;
		}
	case 1603: { // x:(r)+,x1 y:(rh)+n,b
		unhandled("x:(r)+,x1 y:(rh)+n,b");
		break;
		}
	case 1604: { // x:(r)+,a y:(rh)+n,y0
		unhandled("x:(r)+,a y:(rh)+n,y0");
		break;
		}
	case 1605: { // x:(r)+,a y:(rh)+n,y1
		unhandled("x:(r)+,a y:(rh)+n,y1");
		break;
		}
	case 1606: { // x:(r)+,a y:(rh)+n,a
		unhandled("x:(r)+,a y:(rh)+n,a");
		break;
		}
	case 1607: { // x:(r)+,a y:(rh)+n,b
		unhandled("x:(r)+,a y:(rh)+n,b");
		break;
		}
	case 1608: { // x:(r)+,b y:(rh)+n,y0
		unhandled("x:(r)+,b y:(rh)+n,y0");
		break;
		}
	case 1609: { // x:(r)+,b y:(rh)+n,y1
		unhandled("x:(r)+,b y:(rh)+n,y1");
		break;
		}
	case 1610: { // x:(r)+,b y:(rh)+n,a
		unhandled("x:(r)+,b y:(rh)+n,a");
		break;
		}
	case 1611: { // x:(r)+,b y:(rh)+n,b
		unhandled("x:(r)+,b y:(rh)+n,b");
		break;
		}
	case 1612: { // x:(r)+,x0 y:(rh)-,y0
		unhandled("x:(r)+,x0 y:(rh)-,y0");
		break;
		}
	case 1613: { // x:(r)+,x0 y:(rh)-,y1
		unhandled("x:(r)+,x0 y:(rh)-,y1");
		break;
		}
	case 1614: { // x:(r)+,x0 y:(rh)-,a
		unhandled("x:(r)+,x0 y:(rh)-,a");
		break;
		}
	case 1615: { // x:(r)+,x0 y:(rh)-,b
		unhandled("x:(r)+,x0 y:(rh)-,b");
		break;
		}
	case 1616: { // x:(r)+,x1 y:(rh)-,y0
		unhandled("x:(r)+,x1 y:(rh)-,y0");
		break;
		}
	case 1617: { // x:(r)+,x1 y:(rh)-,y1
		unhandled("x:(r)+,x1 y:(rh)-,y1");
		break;
		}
	case 1618: { // x:(r)+,x1 y:(rh)-,a
		unhandled("x:(r)+,x1 y:(rh)-,a");
		break;
		}
	case 1619: { // x:(r)+,x1 y:(rh)-,b
		unhandled("x:(r)+,x1 y:(rh)-,b");
		break;
		}
	case 1620: { // x:(r)+,a y:(rh)-,y0
		unhandled("x:(r)+,a y:(rh)-,y0");
		break;
		}
	case 1621: { // x:(r)+,a y:(rh)-,y1
		unhandled("x:(r)+,a y:(rh)-,y1");
		break;
		}
	case 1622: { // x:(r)+,a y:(rh)-,a
		unhandled("x:(r)+,a y:(rh)-,a");
		break;
		}
	case 1623: { // x:(r)+,a y:(rh)-,b
		unhandled("x:(r)+,a y:(rh)-,b");
		break;
		}
	case 1624: { // x:(r)+,b y:(rh)-,y0
		unhandled("x:(r)+,b y:(rh)-,y0");
		break;
		}
	case 1625: { // x:(r)+,b y:(rh)-,y1
		unhandled("x:(r)+,b y:(rh)-,y1");
		break;
		}
	case 1626: { // x:(r)+,b y:(rh)-,a
		unhandled("x:(r)+,b y:(rh)-,a");
		break;
		}
	case 1627: { // x:(r)+,b y:(rh)-,b
		unhandled("x:(r)+,b y:(rh)-,b");
		break;
		}
	case 1628: { // x:(r)+,x0 y:(rh)+,y0
		unhandled("x:(r)+,x0 y:(rh)+,y0");
		break;
		}
	case 1629: { // x:(r)+,x0 y:(rh)+,y1
		unhandled("x:(r)+,x0 y:(rh)+,y1");
		break;
		}
	case 1630: { // x:(r)+,x0 y:(rh)+,a
		unhandled("x:(r)+,x0 y:(rh)+,a");
		break;
		}
	case 1631: { // x:(r)+,x0 y:(rh)+,b
		unhandled("x:(r)+,x0 y:(rh)+,b");
		break;
		}
	case 1632: { // x:(r)+,x1 y:(rh)+,y0
		unhandled("x:(r)+,x1 y:(rh)+,y0");
		break;
		}
	case 1633: { // x:(r)+,x1 y:(rh)+,y1
		unhandled("x:(r)+,x1 y:(rh)+,y1");
		break;
		}
	case 1634: { // x:(r)+,x1 y:(rh)+,a
		unhandled("x:(r)+,x1 y:(rh)+,a");
		break;
		}
	case 1635: { // x:(r)+,x1 y:(rh)+,b
		unhandled("x:(r)+,x1 y:(rh)+,b");
		break;
		}
	case 1636: { // x:(r)+,a y:(rh)+,y0
		unhandled("x:(r)+,a y:(rh)+,y0");
		break;
		}
	case 1637: { // x:(r)+,a y:(rh)+,y1
		unhandled("x:(r)+,a y:(rh)+,y1");
		break;
		}
	case 1638: { // x:(r)+,a y:(rh)+,a
		unhandled("x:(r)+,a y:(rh)+,a");
		break;
		}
	case 1639: { // x:(r)+,a y:(rh)+,b
		unhandled("x:(r)+,a y:(rh)+,b");
		break;
		}
	case 1640: { // x:(r)+,b y:(rh)+,y0
		unhandled("x:(r)+,b y:(rh)+,y0");
		break;
		}
	case 1641: { // x:(r)+,b y:(rh)+,y1
		unhandled("x:(r)+,b y:(rh)+,y1");
		break;
		}
	case 1642: { // x:(r)+,b y:(rh)+,a
		unhandled("x:(r)+,b y:(rh)+,a");
		break;
		}
	case 1643: { // x:(r)+,b y:(rh)+,b
		unhandled("x:(r)+,b y:(rh)+,b");
		break;
		}
	case 1644: { // x:(r)+,x0 y:(rh),y0
		unhandled("x:(r)+,x0 y:(rh),y0");
		break;
		}
	case 1645: { // x:(r)+,x0 y:(rh),y1
		unhandled("x:(r)+,x0 y:(rh),y1");
		break;
		}
	case 1646: { // x:(r)+,x0 y:(rh),a
		unhandled("x:(r)+,x0 y:(rh),a");
		break;
		}
	case 1647: { // x:(r)+,x0 y:(rh),b
		unhandled("x:(r)+,x0 y:(rh),b");
		break;
		}
	case 1648: { // x:(r)+,x1 y:(rh),y0
		unhandled("x:(r)+,x1 y:(rh),y0");
		break;
		}
	case 1649: { // x:(r)+,x1 y:(rh),y1
		unhandled("x:(r)+,x1 y:(rh),y1");
		break;
		}
	case 1650: { // x:(r)+,x1 y:(rh),a
		unhandled("x:(r)+,x1 y:(rh),a");
		break;
		}
	case 1651: { // x:(r)+,x1 y:(rh),b
		unhandled("x:(r)+,x1 y:(rh),b");
		break;
		}
	case 1652: { // x:(r)+,a y:(rh),y0
		unhandled("x:(r)+,a y:(rh),y0");
		break;
		}
	case 1653: { // x:(r)+,a y:(rh),y1
		unhandled("x:(r)+,a y:(rh),y1");
		break;
		}
	case 1654: { // x:(r)+,a y:(rh),a
		unhandled("x:(r)+,a y:(rh),a");
		break;
		}
	case 1655: { // x:(r)+,a y:(rh),b
		unhandled("x:(r)+,a y:(rh),b");
		break;
		}
	case 1656: { // x:(r)+,b y:(rh),y0
		unhandled("x:(r)+,b y:(rh),y0");
		break;
		}
	case 1657: { // x:(r)+,b y:(rh),y1
		unhandled("x:(r)+,b y:(rh),y1");
		break;
		}
	case 1658: { // x:(r)+,b y:(rh),a
		unhandled("x:(r)+,b y:(rh),a");
		break;
		}
	case 1659: { // x:(r)+,b y:(rh),b
		unhandled("x:(r)+,b y:(rh),b");
		break;
		}
	case 1660: { // x:(r),x0 y:(rh)+n,y0
		unhandled("x:(r),x0 y:(rh)+n,y0");
		break;
		}
	case 1661: { // x:(r),x0 y:(rh)+n,y1
		unhandled("x:(r),x0 y:(rh)+n,y1");
		break;
		}
	case 1662: { // x:(r),x0 y:(rh)+n,a
		unhandled("x:(r),x0 y:(rh)+n,a");
		break;
		}
	case 1663: { // x:(r),x0 y:(rh)+n,b
		unhandled("x:(r),x0 y:(rh)+n,b");
		break;
		}
	case 1664: { // x:(r),x1 y:(rh)+n,y0
		unhandled("x:(r),x1 y:(rh)+n,y0");
		break;
		}
	case 1665: { // x:(r),x1 y:(rh)+n,y1
		unhandled("x:(r),x1 y:(rh)+n,y1");
		break;
		}
	case 1666: { // x:(r),x1 y:(rh)+n,a
		unhandled("x:(r),x1 y:(rh)+n,a");
		break;
		}
	case 1667: { // x:(r),x1 y:(rh)+n,b
		unhandled("x:(r),x1 y:(rh)+n,b");
		break;
		}
	case 1668: { // x:(r),a y:(rh)+n,y0
		unhandled("x:(r),a y:(rh)+n,y0");
		break;
		}
	case 1669: { // x:(r),a y:(rh)+n,y1
		unhandled("x:(r),a y:(rh)+n,y1");
		break;
		}
	case 1670: { // x:(r),a y:(rh)+n,a
		unhandled("x:(r),a y:(rh)+n,a");
		break;
		}
	case 1671: { // x:(r),a y:(rh)+n,b
		unhandled("x:(r),a y:(rh)+n,b");
		break;
		}
	case 1672: { // x:(r),b y:(rh)+n,y0
		unhandled("x:(r),b y:(rh)+n,y0");
		break;
		}
	case 1673: { // x:(r),b y:(rh)+n,y1
		unhandled("x:(r),b y:(rh)+n,y1");
		break;
		}
	case 1674: { // x:(r),b y:(rh)+n,a
		unhandled("x:(r),b y:(rh)+n,a");
		break;
		}
	case 1675: { // x:(r),b y:(rh)+n,b
		unhandled("x:(r),b y:(rh)+n,b");
		break;
		}
	case 1676: { // x:(r),x0 y:(rh)-,y0
		unhandled("x:(r),x0 y:(rh)-,y0");
		break;
		}
	case 1677: { // x:(r),x0 y:(rh)-,y1
		unhandled("x:(r),x0 y:(rh)-,y1");
		break;
		}
	case 1678: { // x:(r),x0 y:(rh)-,a
		unhandled("x:(r),x0 y:(rh)-,a");
		break;
		}
	case 1679: { // x:(r),x0 y:(rh)-,b
		unhandled("x:(r),x0 y:(rh)-,b");
		break;
		}
	case 1680: { // x:(r),x1 y:(rh)-,y0
		unhandled("x:(r),x1 y:(rh)-,y0");
		break;
		}
	case 1681: { // x:(r),x1 y:(rh)-,y1
		unhandled("x:(r),x1 y:(rh)-,y1");
		break;
		}
	case 1682: { // x:(r),x1 y:(rh)-,a
		unhandled("x:(r),x1 y:(rh)-,a");
		break;
		}
	case 1683: { // x:(r),x1 y:(rh)-,b
		unhandled("x:(r),x1 y:(rh)-,b");
		break;
		}
	case 1684: { // x:(r),a y:(rh)-,y0
		unhandled("x:(r),a y:(rh)-,y0");
		break;
		}
	case 1685: { // x:(r),a y:(rh)-,y1
		unhandled("x:(r),a y:(rh)-,y1");
		break;
		}
	case 1686: { // x:(r),a y:(rh)-,a
		unhandled("x:(r),a y:(rh)-,a");
		break;
		}
	case 1687: { // x:(r),a y:(rh)-,b
		unhandled("x:(r),a y:(rh)-,b");
		break;
		}
	case 1688: { // x:(r),b y:(rh)-,y0
		unhandled("x:(r),b y:(rh)-,y0");
		break;
		}
	case 1689: { // x:(r),b y:(rh)-,y1
		unhandled("x:(r),b y:(rh)-,y1");
		break;
		}
	case 1690: { // x:(r),b y:(rh)-,a
		unhandled("x:(r),b y:(rh)-,a");
		break;
		}
	case 1691: { // x:(r),b y:(rh)-,b
		unhandled("x:(r),b y:(rh)-,b");
		break;
		}
	case 1692: { // x:(r),x0 y:(rh)+,y0
		unhandled("x:(r),x0 y:(rh)+,y0");
		break;
		}
	case 1693: { // x:(r),x0 y:(rh)+,y1
		unhandled("x:(r),x0 y:(rh)+,y1");
		break;
		}
	case 1694: { // x:(r),x0 y:(rh)+,a
		unhandled("x:(r),x0 y:(rh)+,a");
		break;
		}
	case 1695: { // x:(r),x0 y:(rh)+,b
		unhandled("x:(r),x0 y:(rh)+,b");
		break;
		}
	case 1696: { // x:(r),x1 y:(rh)+,y0
		unhandled("x:(r),x1 y:(rh)+,y0");
		break;
		}
	case 1697: { // x:(r),x1 y:(rh)+,y1
		unhandled("x:(r),x1 y:(rh)+,y1");
		break;
		}
	case 1698: { // x:(r),x1 y:(rh)+,a
		unhandled("x:(r),x1 y:(rh)+,a");
		break;
		}
	case 1699: { // x:(r),x1 y:(rh)+,b
		unhandled("x:(r),x1 y:(rh)+,b");
		break;
		}
	case 1700: { // x:(r),a y:(rh)+,y0
		unhandled("x:(r),a y:(rh)+,y0");
		break;
		}
	case 1701: { // x:(r),a y:(rh)+,y1
		unhandled("x:(r),a y:(rh)+,y1");
		break;
		}
	case 1702: { // x:(r),a y:(rh)+,a
		unhandled("x:(r),a y:(rh)+,a");
		break;
		}
	case 1703: { // x:(r),a y:(rh)+,b
		unhandled("x:(r),a y:(rh)+,b");
		break;
		}
	case 1704: { // x:(r),b y:(rh)+,y0
		unhandled("x:(r),b y:(rh)+,y0");
		break;
		}
	case 1705: { // x:(r),b y:(rh)+,y1
		unhandled("x:(r),b y:(rh)+,y1");
		break;
		}
	case 1706: { // x:(r),b y:(rh)+,a
		unhandled("x:(r),b y:(rh)+,a");
		break;
		}
	case 1707: { // x:(r),b y:(rh)+,b
		unhandled("x:(r),b y:(rh)+,b");
		break;
		}
	case 1708: { // x:(r),x0 y:(rh),y0
		unhandled("x:(r),x0 y:(rh),y0");
		break;
		}
	case 1709: { // x:(r),x0 y:(rh),y1
		unhandled("x:(r),x0 y:(rh),y1");
		break;
		}
	case 1710: { // x:(r),x0 y:(rh),a
		unhandled("x:(r),x0 y:(rh),a");
		break;
		}
	case 1711: { // x:(r),x0 y:(rh),b
		unhandled("x:(r),x0 y:(rh),b");
		break;
		}
	case 1712: { // x:(r),x1 y:(rh),y0
		unhandled("x:(r),x1 y:(rh),y0");
		break;
		}
	case 1713: { // x:(r),x1 y:(rh),y1
		unhandled("x:(r),x1 y:(rh),y1");
		break;
		}
	case 1714: { // x:(r),x1 y:(rh),a
		unhandled("x:(r),x1 y:(rh),a");
		break;
		}
	case 1715: { // x:(r),x1 y:(rh),b
		unhandled("x:(r),x1 y:(rh),b");
		break;
		}
	case 1716: { // x:(r),a y:(rh),y0
		unhandled("x:(r),a y:(rh),y0");
		break;
		}
	case 1717: { // x:(r),a y:(rh),y1
		unhandled("x:(r),a y:(rh),y1");
		break;
		}
	case 1718: { // x:(r),a y:(rh),a
		unhandled("x:(r),a y:(rh),a");
		break;
		}
	case 1719: { // x:(r),a y:(rh),b
		unhandled("x:(r),a y:(rh),b");
		break;
		}
	case 1720: { // x:(r),b y:(rh),y0
		unhandled("x:(r),b y:(rh),y0");
		break;
		}
	case 1721: { // x:(r),b y:(rh),y1
		unhandled("x:(r),b y:(rh),y1");
		break;
		}
	case 1722: { // x:(r),b y:(rh),a
		unhandled("x:(r),b y:(rh),a");
		break;
		}
	case 1723: { // x:(r),b y:(rh),b
		unhandled("x:(r),b y:(rh),b");
		break;
		}
	case 1724: { // x:(r)+n,x0 y0,y:(rh)+n
		unhandled("x:(r)+n,x0 y0,y:(rh)+n");
		break;
		}
	case 1725: { // x:(r)+n,x0 y1,y:(rh)+n
		unhandled("x:(r)+n,x0 y1,y:(rh)+n");
		break;
		}
	case 1726: { // x:(r)+n,x0 a,y:(rh)+n
		unhandled("x:(r)+n,x0 a,y:(rh)+n");
		break;
		}
	case 1727: { // x:(r)+n,x0 b,y:(rh)+n
		unhandled("x:(r)+n,x0 b,y:(rh)+n");
		break;
		}
	case 1728: { // x:(r)+n,x1 y0,y:(rh)+n
		unhandled("x:(r)+n,x1 y0,y:(rh)+n");
		break;
		}
	case 1729: { // x:(r)+n,x1 y1,y:(rh)+n
		unhandled("x:(r)+n,x1 y1,y:(rh)+n");
		break;
		}
	case 1730: { // x:(r)+n,x1 a,y:(rh)+n
		unhandled("x:(r)+n,x1 a,y:(rh)+n");
		break;
		}
	case 1731: { // x:(r)+n,x1 b,y:(rh)+n
		unhandled("x:(r)+n,x1 b,y:(rh)+n");
		break;
		}
	case 1732: { // x:(r)+n,a y0,y:(rh)+n
		unhandled("x:(r)+n,a y0,y:(rh)+n");
		break;
		}
	case 1733: { // x:(r)+n,a y1,y:(rh)+n
		unhandled("x:(r)+n,a y1,y:(rh)+n");
		break;
		}
	case 1734: { // x:(r)+n,a a,y:(rh)+n
		unhandled("x:(r)+n,a a,y:(rh)+n");
		break;
		}
	case 1735: { // x:(r)+n,a b,y:(rh)+n
		unhandled("x:(r)+n,a b,y:(rh)+n");
		break;
		}
	case 1736: { // x:(r)+n,b y0,y:(rh)+n
		unhandled("x:(r)+n,b y0,y:(rh)+n");
		break;
		}
	case 1737: { // x:(r)+n,b y1,y:(rh)+n
		unhandled("x:(r)+n,b y1,y:(rh)+n");
		break;
		}
	case 1738: { // x:(r)+n,b a,y:(rh)+n
		unhandled("x:(r)+n,b a,y:(rh)+n");
		break;
		}
	case 1739: { // x:(r)+n,b b,y:(rh)+n
		unhandled("x:(r)+n,b b,y:(rh)+n");
		break;
		}
	case 1740: { // x:(r)+n,x0 y0,y:(rh)-
		unhandled("x:(r)+n,x0 y0,y:(rh)-");
		break;
		}
	case 1741: { // x:(r)+n,x0 y1,y:(rh)-
		unhandled("x:(r)+n,x0 y1,y:(rh)-");
		break;
		}
	case 1742: { // x:(r)+n,x0 a,y:(rh)-
		unhandled("x:(r)+n,x0 a,y:(rh)-");
		break;
		}
	case 1743: { // x:(r)+n,x0 b,y:(rh)-
		unhandled("x:(r)+n,x0 b,y:(rh)-");
		break;
		}
	case 1744: { // x:(r)+n,x1 y0,y:(rh)-
		unhandled("x:(r)+n,x1 y0,y:(rh)-");
		break;
		}
	case 1745: { // x:(r)+n,x1 y1,y:(rh)-
		unhandled("x:(r)+n,x1 y1,y:(rh)-");
		break;
		}
	case 1746: { // x:(r)+n,x1 a,y:(rh)-
		unhandled("x:(r)+n,x1 a,y:(rh)-");
		break;
		}
	case 1747: { // x:(r)+n,x1 b,y:(rh)-
		unhandled("x:(r)+n,x1 b,y:(rh)-");
		break;
		}
	case 1748: { // x:(r)+n,a y0,y:(rh)-
		unhandled("x:(r)+n,a y0,y:(rh)-");
		break;
		}
	case 1749: { // x:(r)+n,a y1,y:(rh)-
		unhandled("x:(r)+n,a y1,y:(rh)-");
		break;
		}
	case 1750: { // x:(r)+n,a a,y:(rh)-
		unhandled("x:(r)+n,a a,y:(rh)-");
		break;
		}
	case 1751: { // x:(r)+n,a b,y:(rh)-
		unhandled("x:(r)+n,a b,y:(rh)-");
		break;
		}
	case 1752: { // x:(r)+n,b y0,y:(rh)-
		unhandled("x:(r)+n,b y0,y:(rh)-");
		break;
		}
	case 1753: { // x:(r)+n,b y1,y:(rh)-
		unhandled("x:(r)+n,b y1,y:(rh)-");
		break;
		}
	case 1754: { // x:(r)+n,b a,y:(rh)-
		unhandled("x:(r)+n,b a,y:(rh)-");
		break;
		}
	case 1755: { // x:(r)+n,b b,y:(rh)-
		unhandled("x:(r)+n,b b,y:(rh)-");
		break;
		}
	case 1756: { // x:(r)+n,x0 y0,y:(rh)+
		unhandled("x:(r)+n,x0 y0,y:(rh)+");
		break;
		}
	case 1757: { // x:(r)+n,x0 y1,y:(rh)+
		unhandled("x:(r)+n,x0 y1,y:(rh)+");
		break;
		}
	case 1758: { // x:(r)+n,x0 a,y:(rh)+
		unhandled("x:(r)+n,x0 a,y:(rh)+");
		break;
		}
	case 1759: { // x:(r)+n,x0 b,y:(rh)+
		unhandled("x:(r)+n,x0 b,y:(rh)+");
		break;
		}
	case 1760: { // x:(r)+n,x1 y0,y:(rh)+
		unhandled("x:(r)+n,x1 y0,y:(rh)+");
		break;
		}
	case 1761: { // x:(r)+n,x1 y1,y:(rh)+
		unhandled("x:(r)+n,x1 y1,y:(rh)+");
		break;
		}
	case 1762: { // x:(r)+n,x1 a,y:(rh)+
		unhandled("x:(r)+n,x1 a,y:(rh)+");
		break;
		}
	case 1763: { // x:(r)+n,x1 b,y:(rh)+
		unhandled("x:(r)+n,x1 b,y:(rh)+");
		break;
		}
	case 1764: { // x:(r)+n,a y0,y:(rh)+
		unhandled("x:(r)+n,a y0,y:(rh)+");
		break;
		}
	case 1765: { // x:(r)+n,a y1,y:(rh)+
		unhandled("x:(r)+n,a y1,y:(rh)+");
		break;
		}
	case 1766: { // x:(r)+n,a a,y:(rh)+
		unhandled("x:(r)+n,a a,y:(rh)+");
		break;
		}
	case 1767: { // x:(r)+n,a b,y:(rh)+
		unhandled("x:(r)+n,a b,y:(rh)+");
		break;
		}
	case 1768: { // x:(r)+n,b y0,y:(rh)+
		unhandled("x:(r)+n,b y0,y:(rh)+");
		break;
		}
	case 1769: { // x:(r)+n,b y1,y:(rh)+
		unhandled("x:(r)+n,b y1,y:(rh)+");
		break;
		}
	case 1770: { // x:(r)+n,b a,y:(rh)+
		unhandled("x:(r)+n,b a,y:(rh)+");
		break;
		}
	case 1771: { // x:(r)+n,b b,y:(rh)+
		unhandled("x:(r)+n,b b,y:(rh)+");
		break;
		}
	case 1772: { // x:(r)+n,x0 y0,y:(rh)
		unhandled("x:(r)+n,x0 y0,y:(rh)");
		break;
		}
	case 1773: { // x:(r)+n,x0 y1,y:(rh)
		unhandled("x:(r)+n,x0 y1,y:(rh)");
		break;
		}
	case 1774: { // x:(r)+n,x0 a,y:(rh)
		unhandled("x:(r)+n,x0 a,y:(rh)");
		break;
		}
	case 1775: { // x:(r)+n,x0 b,y:(rh)
		unhandled("x:(r)+n,x0 b,y:(rh)");
		break;
		}
	case 1776: { // x:(r)+n,x1 y0,y:(rh)
		unhandled("x:(r)+n,x1 y0,y:(rh)");
		break;
		}
	case 1777: { // x:(r)+n,x1 y1,y:(rh)
		unhandled("x:(r)+n,x1 y1,y:(rh)");
		break;
		}
	case 1778: { // x:(r)+n,x1 a,y:(rh)
		unhandled("x:(r)+n,x1 a,y:(rh)");
		break;
		}
	case 1779: { // x:(r)+n,x1 b,y:(rh)
		unhandled("x:(r)+n,x1 b,y:(rh)");
		break;
		}
	case 1780: { // x:(r)+n,a y0,y:(rh)
		unhandled("x:(r)+n,a y0,y:(rh)");
		break;
		}
	case 1781: { // x:(r)+n,a y1,y:(rh)
		unhandled("x:(r)+n,a y1,y:(rh)");
		break;
		}
	case 1782: { // x:(r)+n,a a,y:(rh)
		unhandled("x:(r)+n,a a,y:(rh)");
		break;
		}
	case 1783: { // x:(r)+n,a b,y:(rh)
		unhandled("x:(r)+n,a b,y:(rh)");
		break;
		}
	case 1784: { // x:(r)+n,b y0,y:(rh)
		unhandled("x:(r)+n,b y0,y:(rh)");
		break;
		}
	case 1785: { // x:(r)+n,b y1,y:(rh)
		unhandled("x:(r)+n,b y1,y:(rh)");
		break;
		}
	case 1786: { // x:(r)+n,b a,y:(rh)
		unhandled("x:(r)+n,b a,y:(rh)");
		break;
		}
	case 1787: { // x:(r)+n,b b,y:(rh)
		unhandled("x:(r)+n,b b,y:(rh)");
		break;
		}
	case 1788: { // x:(r)-,x0 y0,y:(rh)+n
		unhandled("x:(r)-,x0 y0,y:(rh)+n");
		break;
		}
	case 1789: { // x:(r)-,x0 y1,y:(rh)+n
		unhandled("x:(r)-,x0 y1,y:(rh)+n");
		break;
		}
	case 1790: { // x:(r)-,x0 a,y:(rh)+n
		unhandled("x:(r)-,x0 a,y:(rh)+n");
		break;
		}
	case 1791: { // x:(r)-,x0 b,y:(rh)+n
		unhandled("x:(r)-,x0 b,y:(rh)+n");
		break;
		}
	case 1792: { // x:(r)-,x1 y0,y:(rh)+n
		unhandled("x:(r)-,x1 y0,y:(rh)+n");
		break;
		}
	case 1793: { // x:(r)-,x1 y1,y:(rh)+n
		unhandled("x:(r)-,x1 y1,y:(rh)+n");
		break;
		}
	case 1794: { // x:(r)-,x1 a,y:(rh)+n
		unhandled("x:(r)-,x1 a,y:(rh)+n");
		break;
		}
	case 1795: { // x:(r)-,x1 b,y:(rh)+n
		unhandled("x:(r)-,x1 b,y:(rh)+n");
		break;
		}
	case 1796: { // x:(r)-,a y0,y:(rh)+n
		unhandled("x:(r)-,a y0,y:(rh)+n");
		break;
		}
	case 1797: { // x:(r)-,a y1,y:(rh)+n
		unhandled("x:(r)-,a y1,y:(rh)+n");
		break;
		}
	case 1798: { // x:(r)-,a a,y:(rh)+n
		unhandled("x:(r)-,a a,y:(rh)+n");
		break;
		}
	case 1799: { // x:(r)-,a b,y:(rh)+n
		unhandled("x:(r)-,a b,y:(rh)+n");
		break;
		}
	case 1800: { // x:(r)-,b y0,y:(rh)+n
		unhandled("x:(r)-,b y0,y:(rh)+n");
		break;
		}
	case 1801: { // x:(r)-,b y1,y:(rh)+n
		unhandled("x:(r)-,b y1,y:(rh)+n");
		break;
		}
	case 1802: { // x:(r)-,b a,y:(rh)+n
		unhandled("x:(r)-,b a,y:(rh)+n");
		break;
		}
	case 1803: { // x:(r)-,b b,y:(rh)+n
		unhandled("x:(r)-,b b,y:(rh)+n");
		break;
		}
	case 1804: { // x:(r)-,x0 y0,y:(rh)-
		unhandled("x:(r)-,x0 y0,y:(rh)-");
		break;
		}
	case 1805: { // x:(r)-,x0 y1,y:(rh)-
		unhandled("x:(r)-,x0 y1,y:(rh)-");
		break;
		}
	case 1806: { // x:(r)-,x0 a,y:(rh)-
		unhandled("x:(r)-,x0 a,y:(rh)-");
		break;
		}
	case 1807: { // x:(r)-,x0 b,y:(rh)-
		unhandled("x:(r)-,x0 b,y:(rh)-");
		break;
		}
	case 1808: { // x:(r)-,x1 y0,y:(rh)-
		unhandled("x:(r)-,x1 y0,y:(rh)-");
		break;
		}
	case 1809: { // x:(r)-,x1 y1,y:(rh)-
		unhandled("x:(r)-,x1 y1,y:(rh)-");
		break;
		}
	case 1810: { // x:(r)-,x1 a,y:(rh)-
		unhandled("x:(r)-,x1 a,y:(rh)-");
		break;
		}
	case 1811: { // x:(r)-,x1 b,y:(rh)-
		unhandled("x:(r)-,x1 b,y:(rh)-");
		break;
		}
	case 1812: { // x:(r)-,a y0,y:(rh)-
		unhandled("x:(r)-,a y0,y:(rh)-");
		break;
		}
	case 1813: { // x:(r)-,a y1,y:(rh)-
		unhandled("x:(r)-,a y1,y:(rh)-");
		break;
		}
	case 1814: { // x:(r)-,a a,y:(rh)-
		unhandled("x:(r)-,a a,y:(rh)-");
		break;
		}
	case 1815: { // x:(r)-,a b,y:(rh)-
		unhandled("x:(r)-,a b,y:(rh)-");
		break;
		}
	case 1816: { // x:(r)-,b y0,y:(rh)-
		unhandled("x:(r)-,b y0,y:(rh)-");
		break;
		}
	case 1817: { // x:(r)-,b y1,y:(rh)-
		unhandled("x:(r)-,b y1,y:(rh)-");
		break;
		}
	case 1818: { // x:(r)-,b a,y:(rh)-
		unhandled("x:(r)-,b a,y:(rh)-");
		break;
		}
	case 1819: { // x:(r)-,b b,y:(rh)-
		unhandled("x:(r)-,b b,y:(rh)-");
		break;
		}
	case 1820: { // x:(r)-,x0 y0,y:(rh)+
		unhandled("x:(r)-,x0 y0,y:(rh)+");
		break;
		}
	case 1821: { // x:(r)-,x0 y1,y:(rh)+
		unhandled("x:(r)-,x0 y1,y:(rh)+");
		break;
		}
	case 1822: { // x:(r)-,x0 a,y:(rh)+
		unhandled("x:(r)-,x0 a,y:(rh)+");
		break;
		}
	case 1823: { // x:(r)-,x0 b,y:(rh)+
		unhandled("x:(r)-,x0 b,y:(rh)+");
		break;
		}
	case 1824: { // x:(r)-,x1 y0,y:(rh)+
		unhandled("x:(r)-,x1 y0,y:(rh)+");
		break;
		}
	case 1825: { // x:(r)-,x1 y1,y:(rh)+
		unhandled("x:(r)-,x1 y1,y:(rh)+");
		break;
		}
	case 1826: { // x:(r)-,x1 a,y:(rh)+
		unhandled("x:(r)-,x1 a,y:(rh)+");
		break;
		}
	case 1827: { // x:(r)-,x1 b,y:(rh)+
		unhandled("x:(r)-,x1 b,y:(rh)+");
		break;
		}
	case 1828: { // x:(r)-,a y0,y:(rh)+
		unhandled("x:(r)-,a y0,y:(rh)+");
		break;
		}
	case 1829: { // x:(r)-,a y1,y:(rh)+
		unhandled("x:(r)-,a y1,y:(rh)+");
		break;
		}
	case 1830: { // x:(r)-,a a,y:(rh)+
		unhandled("x:(r)-,a a,y:(rh)+");
		break;
		}
	case 1831: { // x:(r)-,a b,y:(rh)+
		unhandled("x:(r)-,a b,y:(rh)+");
		break;
		}
	case 1832: { // x:(r)-,b y0,y:(rh)+
		unhandled("x:(r)-,b y0,y:(rh)+");
		break;
		}
	case 1833: { // x:(r)-,b y1,y:(rh)+
		unhandled("x:(r)-,b y1,y:(rh)+");
		break;
		}
	case 1834: { // x:(r)-,b a,y:(rh)+
		unhandled("x:(r)-,b a,y:(rh)+");
		break;
		}
	case 1835: { // x:(r)-,b b,y:(rh)+
		unhandled("x:(r)-,b b,y:(rh)+");
		break;
		}
	case 1836: { // x:(r)-,x0 y0,y:(rh)
		unhandled("x:(r)-,x0 y0,y:(rh)");
		break;
		}
	case 1837: { // x:(r)-,x0 y1,y:(rh)
		unhandled("x:(r)-,x0 y1,y:(rh)");
		break;
		}
	case 1838: { // x:(r)-,x0 a,y:(rh)
		unhandled("x:(r)-,x0 a,y:(rh)");
		break;
		}
	case 1839: { // x:(r)-,x0 b,y:(rh)
		unhandled("x:(r)-,x0 b,y:(rh)");
		break;
		}
	case 1840: { // x:(r)-,x1 y0,y:(rh)
		unhandled("x:(r)-,x1 y0,y:(rh)");
		break;
		}
	case 1841: { // x:(r)-,x1 y1,y:(rh)
		unhandled("x:(r)-,x1 y1,y:(rh)");
		break;
		}
	case 1842: { // x:(r)-,x1 a,y:(rh)
		unhandled("x:(r)-,x1 a,y:(rh)");
		break;
		}
	case 1843: { // x:(r)-,x1 b,y:(rh)
		unhandled("x:(r)-,x1 b,y:(rh)");
		break;
		}
	case 1844: { // x:(r)-,a y0,y:(rh)
		unhandled("x:(r)-,a y0,y:(rh)");
		break;
		}
	case 1845: { // x:(r)-,a y1,y:(rh)
		unhandled("x:(r)-,a y1,y:(rh)");
		break;
		}
	case 1846: { // x:(r)-,a a,y:(rh)
		unhandled("x:(r)-,a a,y:(rh)");
		break;
		}
	case 1847: { // x:(r)-,a b,y:(rh)
		unhandled("x:(r)-,a b,y:(rh)");
		break;
		}
	case 1848: { // x:(r)-,b y0,y:(rh)
		unhandled("x:(r)-,b y0,y:(rh)");
		break;
		}
	case 1849: { // x:(r)-,b y1,y:(rh)
		unhandled("x:(r)-,b y1,y:(rh)");
		break;
		}
	case 1850: { // x:(r)-,b a,y:(rh)
		unhandled("x:(r)-,b a,y:(rh)");
		break;
		}
	case 1851: { // x:(r)-,b b,y:(rh)
		unhandled("x:(r)-,b b,y:(rh)");
		break;
		}
	case 1852: { // x:(r)+,x0 y0,y:(rh)+n
		unhandled("x:(r)+,x0 y0,y:(rh)+n");
		break;
		}
	case 1853: { // x:(r)+,x0 y1,y:(rh)+n
		unhandled("x:(r)+,x0 y1,y:(rh)+n");
		break;
		}
	case 1854: { // x:(r)+,x0 a,y:(rh)+n
		unhandled("x:(r)+,x0 a,y:(rh)+n");
		break;
		}
	case 1855: { // x:(r)+,x0 b,y:(rh)+n
		unhandled("x:(r)+,x0 b,y:(rh)+n");
		break;
		}
	case 1856: { // x:(r)+,x1 y0,y:(rh)+n
		unhandled("x:(r)+,x1 y0,y:(rh)+n");
		break;
		}
	case 1857: { // x:(r)+,x1 y1,y:(rh)+n
		unhandled("x:(r)+,x1 y1,y:(rh)+n");
		break;
		}
	case 1858: { // x:(r)+,x1 a,y:(rh)+n
		unhandled("x:(r)+,x1 a,y:(rh)+n");
		break;
		}
	case 1859: { // x:(r)+,x1 b,y:(rh)+n
		unhandled("x:(r)+,x1 b,y:(rh)+n");
		break;
		}
	case 1860: { // x:(r)+,a y0,y:(rh)+n
		unhandled("x:(r)+,a y0,y:(rh)+n");
		break;
		}
	case 1861: { // x:(r)+,a y1,y:(rh)+n
		unhandled("x:(r)+,a y1,y:(rh)+n");
		break;
		}
	case 1862: { // x:(r)+,a a,y:(rh)+n
		unhandled("x:(r)+,a a,y:(rh)+n");
		break;
		}
	case 1863: { // x:(r)+,a b,y:(rh)+n
		unhandled("x:(r)+,a b,y:(rh)+n");
		break;
		}
	case 1864: { // x:(r)+,b y0,y:(rh)+n
		unhandled("x:(r)+,b y0,y:(rh)+n");
		break;
		}
	case 1865: { // x:(r)+,b y1,y:(rh)+n
		unhandled("x:(r)+,b y1,y:(rh)+n");
		break;
		}
	case 1866: { // x:(r)+,b a,y:(rh)+n
		unhandled("x:(r)+,b a,y:(rh)+n");
		break;
		}
	case 1867: { // x:(r)+,b b,y:(rh)+n
		unhandled("x:(r)+,b b,y:(rh)+n");
		break;
		}
	case 1868: { // x:(r)+,x0 y0,y:(rh)-
		unhandled("x:(r)+,x0 y0,y:(rh)-");
		break;
		}
	case 1869: { // x:(r)+,x0 y1,y:(rh)-
		unhandled("x:(r)+,x0 y1,y:(rh)-");
		break;
		}
	case 1870: { // x:(r)+,x0 a,y:(rh)-
		unhandled("x:(r)+,x0 a,y:(rh)-");
		break;
		}
	case 1871: { // x:(r)+,x0 b,y:(rh)-
		unhandled("x:(r)+,x0 b,y:(rh)-");
		break;
		}
	case 1872: { // x:(r)+,x1 y0,y:(rh)-
		unhandled("x:(r)+,x1 y0,y:(rh)-");
		break;
		}
	case 1873: { // x:(r)+,x1 y1,y:(rh)-
		unhandled("x:(r)+,x1 y1,y:(rh)-");
		break;
		}
	case 1874: { // x:(r)+,x1 a,y:(rh)-
		unhandled("x:(r)+,x1 a,y:(rh)-");
		break;
		}
	case 1875: { // x:(r)+,x1 b,y:(rh)-
		unhandled("x:(r)+,x1 b,y:(rh)-");
		break;
		}
	case 1876: { // x:(r)+,a y0,y:(rh)-
		unhandled("x:(r)+,a y0,y:(rh)-");
		break;
		}
	case 1877: { // x:(r)+,a y1,y:(rh)-
		unhandled("x:(r)+,a y1,y:(rh)-");
		break;
		}
	case 1878: { // x:(r)+,a a,y:(rh)-
		unhandled("x:(r)+,a a,y:(rh)-");
		break;
		}
	case 1879: { // x:(r)+,a b,y:(rh)-
		unhandled("x:(r)+,a b,y:(rh)-");
		break;
		}
	case 1880: { // x:(r)+,b y0,y:(rh)-
		unhandled("x:(r)+,b y0,y:(rh)-");
		break;
		}
	case 1881: { // x:(r)+,b y1,y:(rh)-
		unhandled("x:(r)+,b y1,y:(rh)-");
		break;
		}
	case 1882: { // x:(r)+,b a,y:(rh)-
		unhandled("x:(r)+,b a,y:(rh)-");
		break;
		}
	case 1883: { // x:(r)+,b b,y:(rh)-
		unhandled("x:(r)+,b b,y:(rh)-");
		break;
		}
	case 1884: { // x:(r)+,x0 y0,y:(rh)+
		unhandled("x:(r)+,x0 y0,y:(rh)+");
		break;
		}
	case 1885: { // x:(r)+,x0 y1,y:(rh)+
		unhandled("x:(r)+,x0 y1,y:(rh)+");
		break;
		}
	case 1886: { // x:(r)+,x0 a,y:(rh)+
		unhandled("x:(r)+,x0 a,y:(rh)+");
		break;
		}
	case 1887: { // x:(r)+,x0 b,y:(rh)+
		unhandled("x:(r)+,x0 b,y:(rh)+");
		break;
		}
	case 1888: { // x:(r)+,x1 y0,y:(rh)+
		unhandled("x:(r)+,x1 y0,y:(rh)+");
		break;
		}
	case 1889: { // x:(r)+,x1 y1,y:(rh)+
		unhandled("x:(r)+,x1 y1,y:(rh)+");
		break;
		}
	case 1890: { // x:(r)+,x1 a,y:(rh)+
		unhandled("x:(r)+,x1 a,y:(rh)+");
		break;
		}
	case 1891: { // x:(r)+,x1 b,y:(rh)+
		unhandled("x:(r)+,x1 b,y:(rh)+");
		break;
		}
	case 1892: { // x:(r)+,a y0,y:(rh)+
		unhandled("x:(r)+,a y0,y:(rh)+");
		break;
		}
	case 1893: { // x:(r)+,a y1,y:(rh)+
		unhandled("x:(r)+,a y1,y:(rh)+");
		break;
		}
	case 1894: { // x:(r)+,a a,y:(rh)+
		unhandled("x:(r)+,a a,y:(rh)+");
		break;
		}
	case 1895: { // x:(r)+,a b,y:(rh)+
		unhandled("x:(r)+,a b,y:(rh)+");
		break;
		}
	case 1896: { // x:(r)+,b y0,y:(rh)+
		unhandled("x:(r)+,b y0,y:(rh)+");
		break;
		}
	case 1897: { // x:(r)+,b y1,y:(rh)+
		unhandled("x:(r)+,b y1,y:(rh)+");
		break;
		}
	case 1898: { // x:(r)+,b a,y:(rh)+
		unhandled("x:(r)+,b a,y:(rh)+");
		break;
		}
	case 1899: { // x:(r)+,b b,y:(rh)+
		unhandled("x:(r)+,b b,y:(rh)+");
		break;
		}
	case 1900: { // x:(r)+,x0 y0,y:(rh)
		unhandled("x:(r)+,x0 y0,y:(rh)");
		break;
		}
	case 1901: { // x:(r)+,x0 y1,y:(rh)
		unhandled("x:(r)+,x0 y1,y:(rh)");
		break;
		}
	case 1902: { // x:(r)+,x0 a,y:(rh)
		unhandled("x:(r)+,x0 a,y:(rh)");
		break;
		}
	case 1903: { // x:(r)+,x0 b,y:(rh)
		unhandled("x:(r)+,x0 b,y:(rh)");
		break;
		}
	case 1904: { // x:(r)+,x1 y0,y:(rh)
		unhandled("x:(r)+,x1 y0,y:(rh)");
		break;
		}
	case 1905: { // x:(r)+,x1 y1,y:(rh)
		unhandled("x:(r)+,x1 y1,y:(rh)");
		break;
		}
	case 1906: { // x:(r)+,x1 a,y:(rh)
		unhandled("x:(r)+,x1 a,y:(rh)");
		break;
		}
	case 1907: { // x:(r)+,x1 b,y:(rh)
		unhandled("x:(r)+,x1 b,y:(rh)");
		break;
		}
	case 1908: { // x:(r)+,a y0,y:(rh)
		unhandled("x:(r)+,a y0,y:(rh)");
		break;
		}
	case 1909: { // x:(r)+,a y1,y:(rh)
		unhandled("x:(r)+,a y1,y:(rh)");
		break;
		}
	case 1910: { // x:(r)+,a a,y:(rh)
		unhandled("x:(r)+,a a,y:(rh)");
		break;
		}
	case 1911: { // x:(r)+,a b,y:(rh)
		unhandled("x:(r)+,a b,y:(rh)");
		break;
		}
	case 1912: { // x:(r)+,b y0,y:(rh)
		unhandled("x:(r)+,b y0,y:(rh)");
		break;
		}
	case 1913: { // x:(r)+,b y1,y:(rh)
		unhandled("x:(r)+,b y1,y:(rh)");
		break;
		}
	case 1914: { // x:(r)+,b a,y:(rh)
		unhandled("x:(r)+,b a,y:(rh)");
		break;
		}
	case 1915: { // x:(r)+,b b,y:(rh)
		unhandled("x:(r)+,b b,y:(rh)");
		break;
		}
	case 1916: { // x:(r),x0 y0,y:(rh)+n
		unhandled("x:(r),x0 y0,y:(rh)+n");
		break;
		}
	case 1917: { // x:(r),x0 y1,y:(rh)+n
		unhandled("x:(r),x0 y1,y:(rh)+n");
		break;
		}
	case 1918: { // x:(r),x0 a,y:(rh)+n
		unhandled("x:(r),x0 a,y:(rh)+n");
		break;
		}
	case 1919: { // x:(r),x0 b,y:(rh)+n
		unhandled("x:(r),x0 b,y:(rh)+n");
		break;
		}
	case 1920: { // x:(r),x1 y0,y:(rh)+n
		unhandled("x:(r),x1 y0,y:(rh)+n");
		break;
		}
	case 1921: { // x:(r),x1 y1,y:(rh)+n
		unhandled("x:(r),x1 y1,y:(rh)+n");
		break;
		}
	case 1922: { // x:(r),x1 a,y:(rh)+n
		unhandled("x:(r),x1 a,y:(rh)+n");
		break;
		}
	case 1923: { // x:(r),x1 b,y:(rh)+n
		unhandled("x:(r),x1 b,y:(rh)+n");
		break;
		}
	case 1924: { // x:(r),a y0,y:(rh)+n
		unhandled("x:(r),a y0,y:(rh)+n");
		break;
		}
	case 1925: { // x:(r),a y1,y:(rh)+n
		unhandled("x:(r),a y1,y:(rh)+n");
		break;
		}
	case 1926: { // x:(r),a a,y:(rh)+n
		unhandled("x:(r),a a,y:(rh)+n");
		break;
		}
	case 1927: { // x:(r),a b,y:(rh)+n
		unhandled("x:(r),a b,y:(rh)+n");
		break;
		}
	case 1928: { // x:(r),b y0,y:(rh)+n
		unhandled("x:(r),b y0,y:(rh)+n");
		break;
		}
	case 1929: { // x:(r),b y1,y:(rh)+n
		unhandled("x:(r),b y1,y:(rh)+n");
		break;
		}
	case 1930: { // x:(r),b a,y:(rh)+n
		unhandled("x:(r),b a,y:(rh)+n");
		break;
		}
	case 1931: { // x:(r),b b,y:(rh)+n
		unhandled("x:(r),b b,y:(rh)+n");
		break;
		}
	case 1932: { // x:(r),x0 y0,y:(rh)-
		unhandled("x:(r),x0 y0,y:(rh)-");
		break;
		}
	case 1933: { // x:(r),x0 y1,y:(rh)-
		unhandled("x:(r),x0 y1,y:(rh)-");
		break;
		}
	case 1934: { // x:(r),x0 a,y:(rh)-
		unhandled("x:(r),x0 a,y:(rh)-");
		break;
		}
	case 1935: { // x:(r),x0 b,y:(rh)-
		unhandled("x:(r),x0 b,y:(rh)-");
		break;
		}
	case 1936: { // x:(r),x1 y0,y:(rh)-
		unhandled("x:(r),x1 y0,y:(rh)-");
		break;
		}
	case 1937: { // x:(r),x1 y1,y:(rh)-
		unhandled("x:(r),x1 y1,y:(rh)-");
		break;
		}
	case 1938: { // x:(r),x1 a,y:(rh)-
		unhandled("x:(r),x1 a,y:(rh)-");
		break;
		}
	case 1939: { // x:(r),x1 b,y:(rh)-
		unhandled("x:(r),x1 b,y:(rh)-");
		break;
		}
	case 1940: { // x:(r),a y0,y:(rh)-
		unhandled("x:(r),a y0,y:(rh)-");
		break;
		}
	case 1941: { // x:(r),a y1,y:(rh)-
		unhandled("x:(r),a y1,y:(rh)-");
		break;
		}
	case 1942: { // x:(r),a a,y:(rh)-
		unhandled("x:(r),a a,y:(rh)-");
		break;
		}
	case 1943: { // x:(r),a b,y:(rh)-
		unhandled("x:(r),a b,y:(rh)-");
		break;
		}
	case 1944: { // x:(r),b y0,y:(rh)-
		unhandled("x:(r),b y0,y:(rh)-");
		break;
		}
	case 1945: { // x:(r),b y1,y:(rh)-
		unhandled("x:(r),b y1,y:(rh)-");
		break;
		}
	case 1946: { // x:(r),b a,y:(rh)-
		unhandled("x:(r),b a,y:(rh)-");
		break;
		}
	case 1947: { // x:(r),b b,y:(rh)-
		unhandled("x:(r),b b,y:(rh)-");
		break;
		}
	case 1948: { // x:(r),x0 y0,y:(rh)+
		unhandled("x:(r),x0 y0,y:(rh)+");
		break;
		}
	case 1949: { // x:(r),x0 y1,y:(rh)+
		unhandled("x:(r),x0 y1,y:(rh)+");
		break;
		}
	case 1950: { // x:(r),x0 a,y:(rh)+
		unhandled("x:(r),x0 a,y:(rh)+");
		break;
		}
	case 1951: { // x:(r),x0 b,y:(rh)+
		unhandled("x:(r),x0 b,y:(rh)+");
		break;
		}
	case 1952: { // x:(r),x1 y0,y:(rh)+
		unhandled("x:(r),x1 y0,y:(rh)+");
		break;
		}
	case 1953: { // x:(r),x1 y1,y:(rh)+
		unhandled("x:(r),x1 y1,y:(rh)+");
		break;
		}
	case 1954: { // x:(r),x1 a,y:(rh)+
		unhandled("x:(r),x1 a,y:(rh)+");
		break;
		}
	case 1955: { // x:(r),x1 b,y:(rh)+
		unhandled("x:(r),x1 b,y:(rh)+");
		break;
		}
	case 1956: { // x:(r),a y0,y:(rh)+
		unhandled("x:(r),a y0,y:(rh)+");
		break;
		}
	case 1957: { // x:(r),a y1,y:(rh)+
		unhandled("x:(r),a y1,y:(rh)+");
		break;
		}
	case 1958: { // x:(r),a a,y:(rh)+
		unhandled("x:(r),a a,y:(rh)+");
		break;
		}
	case 1959: { // x:(r),a b,y:(rh)+
		unhandled("x:(r),a b,y:(rh)+");
		break;
		}
	case 1960: { // x:(r),b y0,y:(rh)+
		unhandled("x:(r),b y0,y:(rh)+");
		break;
		}
	case 1961: { // x:(r),b y1,y:(rh)+
		unhandled("x:(r),b y1,y:(rh)+");
		break;
		}
	case 1962: { // x:(r),b a,y:(rh)+
		unhandled("x:(r),b a,y:(rh)+");
		break;
		}
	case 1963: { // x:(r),b b,y:(rh)+
		unhandled("x:(r),b b,y:(rh)+");
		break;
		}
	case 1964: { // x:(r),x0 y0,y:(rh)
		unhandled("x:(r),x0 y0,y:(rh)");
		break;
		}
	case 1965: { // x:(r),x0 y1,y:(rh)
		unhandled("x:(r),x0 y1,y:(rh)");
		break;
		}
	case 1966: { // x:(r),x0 a,y:(rh)
		unhandled("x:(r),x0 a,y:(rh)");
		break;
		}
	case 1967: { // x:(r),x0 b,y:(rh)
		unhandled("x:(r),x0 b,y:(rh)");
		break;
		}
	case 1968: { // x:(r),x1 y0,y:(rh)
		unhandled("x:(r),x1 y0,y:(rh)");
		break;
		}
	case 1969: { // x:(r),x1 y1,y:(rh)
		unhandled("x:(r),x1 y1,y:(rh)");
		break;
		}
	case 1970: { // x:(r),x1 a,y:(rh)
		unhandled("x:(r),x1 a,y:(rh)");
		break;
		}
	case 1971: { // x:(r),x1 b,y:(rh)
		unhandled("x:(r),x1 b,y:(rh)");
		break;
		}
	case 1972: { // x:(r),a y0,y:(rh)
		unhandled("x:(r),a y0,y:(rh)");
		break;
		}
	case 1973: { // x:(r),a y1,y:(rh)
		unhandled("x:(r),a y1,y:(rh)");
		break;
		}
	case 1974: { // x:(r),a a,y:(rh)
		unhandled("x:(r),a a,y:(rh)");
		break;
		}
	case 1975: { // x:(r),a b,y:(rh)
		unhandled("x:(r),a b,y:(rh)");
		break;
		}
	case 1976: { // x:(r),b y0,y:(rh)
		unhandled("x:(r),b y0,y:(rh)");
		break;
		}
	case 1977: { // x:(r),b y1,y:(rh)
		unhandled("x:(r),b y1,y:(rh)");
		break;
		}
	case 1978: { // x:(r),b a,y:(rh)
		unhandled("x:(r),b a,y:(rh)");
		break;
		}
	case 1979: { // x:(r),b b,y:(rh)
		unhandled("x:(r),b b,y:(rh)");
		break;
		}
	case 1980: { // x0,x:(r)+n y:(rh)+n,y0
		unhandled("x0,x:(r)+n y:(rh)+n,y0");
		break;
		}
	case 1981: { // x0,x:(r)+n y:(rh)+n,y1
		unhandled("x0,x:(r)+n y:(rh)+n,y1");
		break;
		}
	case 1982: { // x0,x:(r)+n y:(rh)+n,a
		unhandled("x0,x:(r)+n y:(rh)+n,a");
		break;
		}
	case 1983: { // x0,x:(r)+n y:(rh)+n,b
		unhandled("x0,x:(r)+n y:(rh)+n,b");
		break;
		}
	case 1984: { // x1,x:(r)+n y:(rh)+n,y0
		unhandled("x1,x:(r)+n y:(rh)+n,y0");
		break;
		}
	case 1985: { // x1,x:(r)+n y:(rh)+n,y1
		unhandled("x1,x:(r)+n y:(rh)+n,y1");
		break;
		}
	case 1986: { // x1,x:(r)+n y:(rh)+n,a
		unhandled("x1,x:(r)+n y:(rh)+n,a");
		break;
		}
	case 1987: { // x1,x:(r)+n y:(rh)+n,b
		unhandled("x1,x:(r)+n y:(rh)+n,b");
		break;
		}
	case 1988: { // a,x:(r)+n y:(rh)+n,y0
		unhandled("a,x:(r)+n y:(rh)+n,y0");
		break;
		}
	case 1989: { // a,x:(r)+n y:(rh)+n,y1
		unhandled("a,x:(r)+n y:(rh)+n,y1");
		break;
		}
	case 1990: { // a,x:(r)+n y:(rh)+n,a
		unhandled("a,x:(r)+n y:(rh)+n,a");
		break;
		}
	case 1991: { // a,x:(r)+n y:(rh)+n,b
		unhandled("a,x:(r)+n y:(rh)+n,b");
		break;
		}
	case 1992: { // b,x:(r)+n y:(rh)+n,y0
		unhandled("b,x:(r)+n y:(rh)+n,y0");
		break;
		}
	case 1993: { // b,x:(r)+n y:(rh)+n,y1
		unhandled("b,x:(r)+n y:(rh)+n,y1");
		break;
		}
	case 1994: { // b,x:(r)+n y:(rh)+n,a
		unhandled("b,x:(r)+n y:(rh)+n,a");
		break;
		}
	case 1995: { // b,x:(r)+n y:(rh)+n,b
		unhandled("b,x:(r)+n y:(rh)+n,b");
		break;
		}
	case 1996: { // x0,x:(r)+n y:(rh)-,y0
		unhandled("x0,x:(r)+n y:(rh)-,y0");
		break;
		}
	case 1997: { // x0,x:(r)+n y:(rh)-,y1
		unhandled("x0,x:(r)+n y:(rh)-,y1");
		break;
		}
	case 1998: { // x0,x:(r)+n y:(rh)-,a
		unhandled("x0,x:(r)+n y:(rh)-,a");
		break;
		}
	case 1999: { // x0,x:(r)+n y:(rh)-,b
		unhandled("x0,x:(r)+n y:(rh)-,b");
		break;
		}
	case 2000: { // x1,x:(r)+n y:(rh)-,y0
		unhandled("x1,x:(r)+n y:(rh)-,y0");
		break;
		}
	case 2001: { // x1,x:(r)+n y:(rh)-,y1
		unhandled("x1,x:(r)+n y:(rh)-,y1");
		break;
		}
	case 2002: { // x1,x:(r)+n y:(rh)-,a
		unhandled("x1,x:(r)+n y:(rh)-,a");
		break;
		}
	case 2003: { // x1,x:(r)+n y:(rh)-,b
		unhandled("x1,x:(r)+n y:(rh)-,b");
		break;
		}
	case 2004: { // a,x:(r)+n y:(rh)-,y0
		unhandled("a,x:(r)+n y:(rh)-,y0");
		break;
		}
	case 2005: { // a,x:(r)+n y:(rh)-,y1
		unhandled("a,x:(r)+n y:(rh)-,y1");
		break;
		}
	case 2006: { // a,x:(r)+n y:(rh)-,a
		unhandled("a,x:(r)+n y:(rh)-,a");
		break;
		}
	case 2007: { // a,x:(r)+n y:(rh)-,b
		unhandled("a,x:(r)+n y:(rh)-,b");
		break;
		}
	case 2008: { // b,x:(r)+n y:(rh)-,y0
		unhandled("b,x:(r)+n y:(rh)-,y0");
		break;
		}
	case 2009: { // b,x:(r)+n y:(rh)-,y1
		unhandled("b,x:(r)+n y:(rh)-,y1");
		break;
		}
	case 2010: { // b,x:(r)+n y:(rh)-,a
		unhandled("b,x:(r)+n y:(rh)-,a");
		break;
		}
	case 2011: { // b,x:(r)+n y:(rh)-,b
		unhandled("b,x:(r)+n y:(rh)-,b");
		break;
		}
	case 2012: { // x0,x:(r)+n y:(rh)+,y0
		unhandled("x0,x:(r)+n y:(rh)+,y0");
		break;
		}
	case 2013: { // x0,x:(r)+n y:(rh)+,y1
		unhandled("x0,x:(r)+n y:(rh)+,y1");
		break;
		}
	case 2014: { // x0,x:(r)+n y:(rh)+,a
		unhandled("x0,x:(r)+n y:(rh)+,a");
		break;
		}
	case 2015: { // x0,x:(r)+n y:(rh)+,b
		unhandled("x0,x:(r)+n y:(rh)+,b");
		break;
		}
	case 2016: { // x1,x:(r)+n y:(rh)+,y0
		unhandled("x1,x:(r)+n y:(rh)+,y0");
		break;
		}
	case 2017: { // x1,x:(r)+n y:(rh)+,y1
		unhandled("x1,x:(r)+n y:(rh)+,y1");
		break;
		}
	case 2018: { // x1,x:(r)+n y:(rh)+,a
		unhandled("x1,x:(r)+n y:(rh)+,a");
		break;
		}
	case 2019: { // x1,x:(r)+n y:(rh)+,b
		unhandled("x1,x:(r)+n y:(rh)+,b");
		break;
		}
	case 2020: { // a,x:(r)+n y:(rh)+,y0
		unhandled("a,x:(r)+n y:(rh)+,y0");
		break;
		}
	case 2021: { // a,x:(r)+n y:(rh)+,y1
		unhandled("a,x:(r)+n y:(rh)+,y1");
		break;
		}
	case 2022: { // a,x:(r)+n y:(rh)+,a
		unhandled("a,x:(r)+n y:(rh)+,a");
		break;
		}
	case 2023: { // a,x:(r)+n y:(rh)+,b
		unhandled("a,x:(r)+n y:(rh)+,b");
		break;
		}
	case 2024: { // b,x:(r)+n y:(rh)+,y0
		unhandled("b,x:(r)+n y:(rh)+,y0");
		break;
		}
	case 2025: { // b,x:(r)+n y:(rh)+,y1
		unhandled("b,x:(r)+n y:(rh)+,y1");
		break;
		}
	case 2026: { // b,x:(r)+n y:(rh)+,a
		unhandled("b,x:(r)+n y:(rh)+,a");
		break;
		}
	case 2027: { // b,x:(r)+n y:(rh)+,b
		unhandled("b,x:(r)+n y:(rh)+,b");
		break;
		}
	case 2028: { // x0,x:(r)+n y:(rh),y0
		unhandled("x0,x:(r)+n y:(rh),y0");
		break;
		}
	case 2029: { // x0,x:(r)+n y:(rh),y1
		unhandled("x0,x:(r)+n y:(rh),y1");
		break;
		}
	case 2030: { // x0,x:(r)+n y:(rh),a
		unhandled("x0,x:(r)+n y:(rh),a");
		break;
		}
	case 2031: { // x0,x:(r)+n y:(rh),b
		unhandled("x0,x:(r)+n y:(rh),b");
		break;
		}
	case 2032: { // x1,x:(r)+n y:(rh),y0
		unhandled("x1,x:(r)+n y:(rh),y0");
		break;
		}
	case 2033: { // x1,x:(r)+n y:(rh),y1
		unhandled("x1,x:(r)+n y:(rh),y1");
		break;
		}
	case 2034: { // x1,x:(r)+n y:(rh),a
		unhandled("x1,x:(r)+n y:(rh),a");
		break;
		}
	case 2035: { // x1,x:(r)+n y:(rh),b
		unhandled("x1,x:(r)+n y:(rh),b");
		break;
		}
	case 2036: { // a,x:(r)+n y:(rh),y0
		unhandled("a,x:(r)+n y:(rh),y0");
		break;
		}
	case 2037: { // a,x:(r)+n y:(rh),y1
		unhandled("a,x:(r)+n y:(rh),y1");
		break;
		}
	case 2038: { // a,x:(r)+n y:(rh),a
		unhandled("a,x:(r)+n y:(rh),a");
		break;
		}
	case 2039: { // a,x:(r)+n y:(rh),b
		unhandled("a,x:(r)+n y:(rh),b");
		break;
		}
	case 2040: { // b,x:(r)+n y:(rh),y0
		unhandled("b,x:(r)+n y:(rh),y0");
		break;
		}
	case 2041: { // b,x:(r)+n y:(rh),y1
		unhandled("b,x:(r)+n y:(rh),y1");
		break;
		}
	case 2042: { // b,x:(r)+n y:(rh),a
		unhandled("b,x:(r)+n y:(rh),a");
		break;
		}
	case 2043: { // b,x:(r)+n y:(rh),b
		unhandled("b,x:(r)+n y:(rh),b");
		break;
		}
	case 2044: { // x0,x:(r)- y:(rh)+n,y0
		unhandled("x0,x:(r)- y:(rh)+n,y0");
		break;
		}
	case 2045: { // x0,x:(r)- y:(rh)+n,y1
		unhandled("x0,x:(r)- y:(rh)+n,y1");
		break;
		}
	case 2046: { // x0,x:(r)- y:(rh)+n,a
		unhandled("x0,x:(r)- y:(rh)+n,a");
		break;
		}
	case 2047: { // x0,x:(r)- y:(rh)+n,b
		unhandled("x0,x:(r)- y:(rh)+n,b");
		break;
		}
	case 2048: { // x1,x:(r)- y:(rh)+n,y0
		unhandled("x1,x:(r)- y:(rh)+n,y0");
		break;
		}
	case 2049: { // x1,x:(r)- y:(rh)+n,y1
		unhandled("x1,x:(r)- y:(rh)+n,y1");
		break;
		}
	case 2050: { // x1,x:(r)- y:(rh)+n,a
		unhandled("x1,x:(r)- y:(rh)+n,a");
		break;
		}
	case 2051: { // x1,x:(r)- y:(rh)+n,b
		unhandled("x1,x:(r)- y:(rh)+n,b");
		break;
		}
	case 2052: { // a,x:(r)- y:(rh)+n,y0
		unhandled("a,x:(r)- y:(rh)+n,y0");
		break;
		}
	case 2053: { // a,x:(r)- y:(rh)+n,y1
		unhandled("a,x:(r)- y:(rh)+n,y1");
		break;
		}
	case 2054: { // a,x:(r)- y:(rh)+n,a
		unhandled("a,x:(r)- y:(rh)+n,a");
		break;
		}
	case 2055: { // a,x:(r)- y:(rh)+n,b
		unhandled("a,x:(r)- y:(rh)+n,b");
		break;
		}
	case 2056: { // b,x:(r)- y:(rh)+n,y0
		unhandled("b,x:(r)- y:(rh)+n,y0");
		break;
		}
	case 2057: { // b,x:(r)- y:(rh)+n,y1
		unhandled("b,x:(r)- y:(rh)+n,y1");
		break;
		}
	case 2058: { // b,x:(r)- y:(rh)+n,a
		unhandled("b,x:(r)- y:(rh)+n,a");
		break;
		}
	case 2059: { // b,x:(r)- y:(rh)+n,b
		unhandled("b,x:(r)- y:(rh)+n,b");
		break;
		}
	case 2060: { // x0,x:(r)- y:(rh)-,y0
		unhandled("x0,x:(r)- y:(rh)-,y0");
		break;
		}
	case 2061: { // x0,x:(r)- y:(rh)-,y1
		unhandled("x0,x:(r)- y:(rh)-,y1");
		break;
		}
	case 2062: { // x0,x:(r)- y:(rh)-,a
		unhandled("x0,x:(r)- y:(rh)-,a");
		break;
		}
	case 2063: { // x0,x:(r)- y:(rh)-,b
		unhandled("x0,x:(r)- y:(rh)-,b");
		break;
		}
	case 2064: { // x1,x:(r)- y:(rh)-,y0
		unhandled("x1,x:(r)- y:(rh)-,y0");
		break;
		}
	case 2065: { // x1,x:(r)- y:(rh)-,y1
		unhandled("x1,x:(r)- y:(rh)-,y1");
		break;
		}
	case 2066: { // x1,x:(r)- y:(rh)-,a
		unhandled("x1,x:(r)- y:(rh)-,a");
		break;
		}
	case 2067: { // x1,x:(r)- y:(rh)-,b
		unhandled("x1,x:(r)- y:(rh)-,b");
		break;
		}
	case 2068: { // a,x:(r)- y:(rh)-,y0
		unhandled("a,x:(r)- y:(rh)-,y0");
		break;
		}
	case 2069: { // a,x:(r)- y:(rh)-,y1
		unhandled("a,x:(r)- y:(rh)-,y1");
		break;
		}
	case 2070: { // a,x:(r)- y:(rh)-,a
		unhandled("a,x:(r)- y:(rh)-,a");
		break;
		}
	case 2071: { // a,x:(r)- y:(rh)-,b
		unhandled("a,x:(r)- y:(rh)-,b");
		break;
		}
	case 2072: { // b,x:(r)- y:(rh)-,y0
		unhandled("b,x:(r)- y:(rh)-,y0");
		break;
		}
	case 2073: { // b,x:(r)- y:(rh)-,y1
		unhandled("b,x:(r)- y:(rh)-,y1");
		break;
		}
	case 2074: { // b,x:(r)- y:(rh)-,a
		unhandled("b,x:(r)- y:(rh)-,a");
		break;
		}
	case 2075: { // b,x:(r)- y:(rh)-,b
		unhandled("b,x:(r)- y:(rh)-,b");
		break;
		}
	case 2076: { // x0,x:(r)- y:(rh)+,y0
		unhandled("x0,x:(r)- y:(rh)+,y0");
		break;
		}
	case 2077: { // x0,x:(r)- y:(rh)+,y1
		unhandled("x0,x:(r)- y:(rh)+,y1");
		break;
		}
	case 2078: { // x0,x:(r)- y:(rh)+,a
		unhandled("x0,x:(r)- y:(rh)+,a");
		break;
		}
	case 2079: { // x0,x:(r)- y:(rh)+,b
		unhandled("x0,x:(r)- y:(rh)+,b");
		break;
		}
	case 2080: { // x1,x:(r)- y:(rh)+,y0
		unhandled("x1,x:(r)- y:(rh)+,y0");
		break;
		}
	case 2081: { // x1,x:(r)- y:(rh)+,y1
		unhandled("x1,x:(r)- y:(rh)+,y1");
		break;
		}
	case 2082: { // x1,x:(r)- y:(rh)+,a
		unhandled("x1,x:(r)- y:(rh)+,a");
		break;
		}
	case 2083: { // x1,x:(r)- y:(rh)+,b
		unhandled("x1,x:(r)- y:(rh)+,b");
		break;
		}
	case 2084: { // a,x:(r)- y:(rh)+,y0
		unhandled("a,x:(r)- y:(rh)+,y0");
		break;
		}
	case 2085: { // a,x:(r)- y:(rh)+,y1
		unhandled("a,x:(r)- y:(rh)+,y1");
		break;
		}
	case 2086: { // a,x:(r)- y:(rh)+,a
		unhandled("a,x:(r)- y:(rh)+,a");
		break;
		}
	case 2087: { // a,x:(r)- y:(rh)+,b
		unhandled("a,x:(r)- y:(rh)+,b");
		break;
		}
	case 2088: { // b,x:(r)- y:(rh)+,y0
		unhandled("b,x:(r)- y:(rh)+,y0");
		break;
		}
	case 2089: { // b,x:(r)- y:(rh)+,y1
		unhandled("b,x:(r)- y:(rh)+,y1");
		break;
		}
	case 2090: { // b,x:(r)- y:(rh)+,a
		unhandled("b,x:(r)- y:(rh)+,a");
		break;
		}
	case 2091: { // b,x:(r)- y:(rh)+,b
		unhandled("b,x:(r)- y:(rh)+,b");
		break;
		}
	case 2092: { // x0,x:(r)- y:(rh),y0
		unhandled("x0,x:(r)- y:(rh),y0");
		break;
		}
	case 2093: { // x0,x:(r)- y:(rh),y1
		unhandled("x0,x:(r)- y:(rh),y1");
		break;
		}
	case 2094: { // x0,x:(r)- y:(rh),a
		unhandled("x0,x:(r)- y:(rh),a");
		break;
		}
	case 2095: { // x0,x:(r)- y:(rh),b
		unhandled("x0,x:(r)- y:(rh),b");
		break;
		}
	case 2096: { // x1,x:(r)- y:(rh),y0
		unhandled("x1,x:(r)- y:(rh),y0");
		break;
		}
	case 2097: { // x1,x:(r)- y:(rh),y1
		unhandled("x1,x:(r)- y:(rh),y1");
		break;
		}
	case 2098: { // x1,x:(r)- y:(rh),a
		unhandled("x1,x:(r)- y:(rh),a");
		break;
		}
	case 2099: { // x1,x:(r)- y:(rh),b
		unhandled("x1,x:(r)- y:(rh),b");
		break;
		}
	case 2100: { // a,x:(r)- y:(rh),y0
		unhandled("a,x:(r)- y:(rh),y0");
		break;
		}
	case 2101: { // a,x:(r)- y:(rh),y1
		unhandled("a,x:(r)- y:(rh),y1");
		break;
		}
	case 2102: { // a,x:(r)- y:(rh),a
		unhandled("a,x:(r)- y:(rh),a");
		break;
		}
	case 2103: { // a,x:(r)- y:(rh),b
		unhandled("a,x:(r)- y:(rh),b");
		break;
		}
	case 2104: { // b,x:(r)- y:(rh),y0
		unhandled("b,x:(r)- y:(rh),y0");
		break;
		}
	case 2105: { // b,x:(r)- y:(rh),y1
		unhandled("b,x:(r)- y:(rh),y1");
		break;
		}
	case 2106: { // b,x:(r)- y:(rh),a
		unhandled("b,x:(r)- y:(rh),a");
		break;
		}
	case 2107: { // b,x:(r)- y:(rh),b
		unhandled("b,x:(r)- y:(rh),b");
		break;
		}
	case 2108: { // x0,x:(r)+ y:(rh)+n,y0
		unhandled("x0,x:(r)+ y:(rh)+n,y0");
		break;
		}
	case 2109: { // x0,x:(r)+ y:(rh)+n,y1
		unhandled("x0,x:(r)+ y:(rh)+n,y1");
		break;
		}
	case 2110: { // x0,x:(r)+ y:(rh)+n,a
		unhandled("x0,x:(r)+ y:(rh)+n,a");
		break;
		}
	case 2111: { // x0,x:(r)+ y:(rh)+n,b
		unhandled("x0,x:(r)+ y:(rh)+n,b");
		break;
		}
	case 2112: { // x1,x:(r)+ y:(rh)+n,y0
		unhandled("x1,x:(r)+ y:(rh)+n,y0");
		break;
		}
	case 2113: { // x1,x:(r)+ y:(rh)+n,y1
		unhandled("x1,x:(r)+ y:(rh)+n,y1");
		break;
		}
	case 2114: { // x1,x:(r)+ y:(rh)+n,a
		unhandled("x1,x:(r)+ y:(rh)+n,a");
		break;
		}
	case 2115: { // x1,x:(r)+ y:(rh)+n,b
		unhandled("x1,x:(r)+ y:(rh)+n,b");
		break;
		}
	case 2116: { // a,x:(r)+ y:(rh)+n,y0
		unhandled("a,x:(r)+ y:(rh)+n,y0");
		break;
		}
	case 2117: { // a,x:(r)+ y:(rh)+n,y1
		unhandled("a,x:(r)+ y:(rh)+n,y1");
		break;
		}
	case 2118: { // a,x:(r)+ y:(rh)+n,a
		unhandled("a,x:(r)+ y:(rh)+n,a");
		break;
		}
	case 2119: { // a,x:(r)+ y:(rh)+n,b
		unhandled("a,x:(r)+ y:(rh)+n,b");
		break;
		}
	case 2120: { // b,x:(r)+ y:(rh)+n,y0
		unhandled("b,x:(r)+ y:(rh)+n,y0");
		break;
		}
	case 2121: { // b,x:(r)+ y:(rh)+n,y1
		unhandled("b,x:(r)+ y:(rh)+n,y1");
		break;
		}
	case 2122: { // b,x:(r)+ y:(rh)+n,a
		unhandled("b,x:(r)+ y:(rh)+n,a");
		break;
		}
	case 2123: { // b,x:(r)+ y:(rh)+n,b
		unhandled("b,x:(r)+ y:(rh)+n,b");
		break;
		}
	case 2124: { // x0,x:(r)+ y:(rh)-,y0
		unhandled("x0,x:(r)+ y:(rh)-,y0");
		break;
		}
	case 2125: { // x0,x:(r)+ y:(rh)-,y1
		unhandled("x0,x:(r)+ y:(rh)-,y1");
		break;
		}
	case 2126: { // x0,x:(r)+ y:(rh)-,a
		unhandled("x0,x:(r)+ y:(rh)-,a");
		break;
		}
	case 2127: { // x0,x:(r)+ y:(rh)-,b
		unhandled("x0,x:(r)+ y:(rh)-,b");
		break;
		}
	case 2128: { // x1,x:(r)+ y:(rh)-,y0
		unhandled("x1,x:(r)+ y:(rh)-,y0");
		break;
		}
	case 2129: { // x1,x:(r)+ y:(rh)-,y1
		unhandled("x1,x:(r)+ y:(rh)-,y1");
		break;
		}
	case 2130: { // x1,x:(r)+ y:(rh)-,a
		unhandled("x1,x:(r)+ y:(rh)-,a");
		break;
		}
	case 2131: { // x1,x:(r)+ y:(rh)-,b
		unhandled("x1,x:(r)+ y:(rh)-,b");
		break;
		}
	case 2132: { // a,x:(r)+ y:(rh)-,y0
		unhandled("a,x:(r)+ y:(rh)-,y0");
		break;
		}
	case 2133: { // a,x:(r)+ y:(rh)-,y1
		unhandled("a,x:(r)+ y:(rh)-,y1");
		break;
		}
	case 2134: { // a,x:(r)+ y:(rh)-,a
		unhandled("a,x:(r)+ y:(rh)-,a");
		break;
		}
	case 2135: { // a,x:(r)+ y:(rh)-,b
		unhandled("a,x:(r)+ y:(rh)-,b");
		break;
		}
	case 2136: { // b,x:(r)+ y:(rh)-,y0
		unhandled("b,x:(r)+ y:(rh)-,y0");
		break;
		}
	case 2137: { // b,x:(r)+ y:(rh)-,y1
		unhandled("b,x:(r)+ y:(rh)-,y1");
		break;
		}
	case 2138: { // b,x:(r)+ y:(rh)-,a
		unhandled("b,x:(r)+ y:(rh)-,a");
		break;
		}
	case 2139: { // b,x:(r)+ y:(rh)-,b
		unhandled("b,x:(r)+ y:(rh)-,b");
		break;
		}
	case 2140: { // x0,x:(r)+ y:(rh)+,y0
		unhandled("x0,x:(r)+ y:(rh)+,y0");
		break;
		}
	case 2141: { // x0,x:(r)+ y:(rh)+,y1
		unhandled("x0,x:(r)+ y:(rh)+,y1");
		break;
		}
	case 2142: { // x0,x:(r)+ y:(rh)+,a
		unhandled("x0,x:(r)+ y:(rh)+,a");
		break;
		}
	case 2143: { // x0,x:(r)+ y:(rh)+,b
		unhandled("x0,x:(r)+ y:(rh)+,b");
		break;
		}
	case 2144: { // x1,x:(r)+ y:(rh)+,y0
		unhandled("x1,x:(r)+ y:(rh)+,y0");
		break;
		}
	case 2145: { // x1,x:(r)+ y:(rh)+,y1
		unhandled("x1,x:(r)+ y:(rh)+,y1");
		break;
		}
	case 2146: { // x1,x:(r)+ y:(rh)+,a
		unhandled("x1,x:(r)+ y:(rh)+,a");
		break;
		}
	case 2147: { // x1,x:(r)+ y:(rh)+,b
		unhandled("x1,x:(r)+ y:(rh)+,b");
		break;
		}
	case 2148: { // a,x:(r)+ y:(rh)+,y0
		unhandled("a,x:(r)+ y:(rh)+,y0");
		break;
		}
	case 2149: { // a,x:(r)+ y:(rh)+,y1
		unhandled("a,x:(r)+ y:(rh)+,y1");
		break;
		}
	case 2150: { // a,x:(r)+ y:(rh)+,a
		unhandled("a,x:(r)+ y:(rh)+,a");
		break;
		}
	case 2151: { // a,x:(r)+ y:(rh)+,b
		unhandled("a,x:(r)+ y:(rh)+,b");
		break;
		}
	case 2152: { // b,x:(r)+ y:(rh)+,y0
		unhandled("b,x:(r)+ y:(rh)+,y0");
		break;
		}
	case 2153: { // b,x:(r)+ y:(rh)+,y1
		unhandled("b,x:(r)+ y:(rh)+,y1");
		break;
		}
	case 2154: { // b,x:(r)+ y:(rh)+,a
		unhandled("b,x:(r)+ y:(rh)+,a");
		break;
		}
	case 2155: { // b,x:(r)+ y:(rh)+,b
		unhandled("b,x:(r)+ y:(rh)+,b");
		break;
		}
	case 2156: { // x0,x:(r)+ y:(rh),y0
		unhandled("x0,x:(r)+ y:(rh),y0");
		break;
		}
	case 2157: { // x0,x:(r)+ y:(rh),y1
		unhandled("x0,x:(r)+ y:(rh),y1");
		break;
		}
	case 2158: { // x0,x:(r)+ y:(rh),a
		unhandled("x0,x:(r)+ y:(rh),a");
		break;
		}
	case 2159: { // x0,x:(r)+ y:(rh),b
		unhandled("x0,x:(r)+ y:(rh),b");
		break;
		}
	case 2160: { // x1,x:(r)+ y:(rh),y0
		unhandled("x1,x:(r)+ y:(rh),y0");
		break;
		}
	case 2161: { // x1,x:(r)+ y:(rh),y1
		unhandled("x1,x:(r)+ y:(rh),y1");
		break;
		}
	case 2162: { // x1,x:(r)+ y:(rh),a
		unhandled("x1,x:(r)+ y:(rh),a");
		break;
		}
	case 2163: { // x1,x:(r)+ y:(rh),b
		unhandled("x1,x:(r)+ y:(rh),b");
		break;
		}
	case 2164: { // a,x:(r)+ y:(rh),y0
		unhandled("a,x:(r)+ y:(rh),y0");
		break;
		}
	case 2165: { // a,x:(r)+ y:(rh),y1
		unhandled("a,x:(r)+ y:(rh),y1");
		break;
		}
	case 2166: { // a,x:(r)+ y:(rh),a
		unhandled("a,x:(r)+ y:(rh),a");
		break;
		}
	case 2167: { // a,x:(r)+ y:(rh),b
		unhandled("a,x:(r)+ y:(rh),b");
		break;
		}
	case 2168: { // b,x:(r)+ y:(rh),y0
		unhandled("b,x:(r)+ y:(rh),y0");
		break;
		}
	case 2169: { // b,x:(r)+ y:(rh),y1
		unhandled("b,x:(r)+ y:(rh),y1");
		break;
		}
	case 2170: { // b,x:(r)+ y:(rh),a
		unhandled("b,x:(r)+ y:(rh),a");
		break;
		}
	case 2171: { // b,x:(r)+ y:(rh),b
		unhandled("b,x:(r)+ y:(rh),b");
		break;
		}
	case 2172: { // x0,x:(r) y:(rh)+n,y0
		unhandled("x0,x:(r) y:(rh)+n,y0");
		break;
		}
	case 2173: { // x0,x:(r) y:(rh)+n,y1
		unhandled("x0,x:(r) y:(rh)+n,y1");
		break;
		}
	case 2174: { // x0,x:(r) y:(rh)+n,a
		unhandled("x0,x:(r) y:(rh)+n,a");
		break;
		}
	case 2175: { // x0,x:(r) y:(rh)+n,b
		unhandled("x0,x:(r) y:(rh)+n,b");
		break;
		}
	case 2176: { // x1,x:(r) y:(rh)+n,y0
		unhandled("x1,x:(r) y:(rh)+n,y0");
		break;
		}
	case 2177: { // x1,x:(r) y:(rh)+n,y1
		unhandled("x1,x:(r) y:(rh)+n,y1");
		break;
		}
	case 2178: { // x1,x:(r) y:(rh)+n,a
		unhandled("x1,x:(r) y:(rh)+n,a");
		break;
		}
	case 2179: { // x1,x:(r) y:(rh)+n,b
		unhandled("x1,x:(r) y:(rh)+n,b");
		break;
		}
	case 2180: { // a,x:(r) y:(rh)+n,y0
		unhandled("a,x:(r) y:(rh)+n,y0");
		break;
		}
	case 2181: { // a,x:(r) y:(rh)+n,y1
		unhandled("a,x:(r) y:(rh)+n,y1");
		break;
		}
	case 2182: { // a,x:(r) y:(rh)+n,a
		unhandled("a,x:(r) y:(rh)+n,a");
		break;
		}
	case 2183: { // a,x:(r) y:(rh)+n,b
		unhandled("a,x:(r) y:(rh)+n,b");
		break;
		}
	case 2184: { // b,x:(r) y:(rh)+n,y0
		unhandled("b,x:(r) y:(rh)+n,y0");
		break;
		}
	case 2185: { // b,x:(r) y:(rh)+n,y1
		unhandled("b,x:(r) y:(rh)+n,y1");
		break;
		}
	case 2186: { // b,x:(r) y:(rh)+n,a
		unhandled("b,x:(r) y:(rh)+n,a");
		break;
		}
	case 2187: { // b,x:(r) y:(rh)+n,b
		unhandled("b,x:(r) y:(rh)+n,b");
		break;
		}
	case 2188: { // x0,x:(r) y:(rh)-,y0
		unhandled("x0,x:(r) y:(rh)-,y0");
		break;
		}
	case 2189: { // x0,x:(r) y:(rh)-,y1
		unhandled("x0,x:(r) y:(rh)-,y1");
		break;
		}
	case 2190: { // x0,x:(r) y:(rh)-,a
		unhandled("x0,x:(r) y:(rh)-,a");
		break;
		}
	case 2191: { // x0,x:(r) y:(rh)-,b
		unhandled("x0,x:(r) y:(rh)-,b");
		break;
		}
	case 2192: { // x1,x:(r) y:(rh)-,y0
		unhandled("x1,x:(r) y:(rh)-,y0");
		break;
		}
	case 2193: { // x1,x:(r) y:(rh)-,y1
		unhandled("x1,x:(r) y:(rh)-,y1");
		break;
		}
	case 2194: { // x1,x:(r) y:(rh)-,a
		unhandled("x1,x:(r) y:(rh)-,a");
		break;
		}
	case 2195: { // x1,x:(r) y:(rh)-,b
		unhandled("x1,x:(r) y:(rh)-,b");
		break;
		}
	case 2196: { // a,x:(r) y:(rh)-,y0
		unhandled("a,x:(r) y:(rh)-,y0");
		break;
		}
	case 2197: { // a,x:(r) y:(rh)-,y1
		unhandled("a,x:(r) y:(rh)-,y1");
		break;
		}
	case 2198: { // a,x:(r) y:(rh)-,a
		unhandled("a,x:(r) y:(rh)-,a");
		break;
		}
	case 2199: { // a,x:(r) y:(rh)-,b
		unhandled("a,x:(r) y:(rh)-,b");
		break;
		}
	case 2200: { // b,x:(r) y:(rh)-,y0
		unhandled("b,x:(r) y:(rh)-,y0");
		break;
		}
	case 2201: { // b,x:(r) y:(rh)-,y1
		unhandled("b,x:(r) y:(rh)-,y1");
		break;
		}
	case 2202: { // b,x:(r) y:(rh)-,a
		unhandled("b,x:(r) y:(rh)-,a");
		break;
		}
	case 2203: { // b,x:(r) y:(rh)-,b
		unhandled("b,x:(r) y:(rh)-,b");
		break;
		}
	case 2204: { // x0,x:(r) y:(rh)+,y0
		unhandled("x0,x:(r) y:(rh)+,y0");
		break;
		}
	case 2205: { // x0,x:(r) y:(rh)+,y1
		unhandled("x0,x:(r) y:(rh)+,y1");
		break;
		}
	case 2206: { // x0,x:(r) y:(rh)+,a
		unhandled("x0,x:(r) y:(rh)+,a");
		break;
		}
	case 2207: { // x0,x:(r) y:(rh)+,b
		unhandled("x0,x:(r) y:(rh)+,b");
		break;
		}
	case 2208: { // x1,x:(r) y:(rh)+,y0
		unhandled("x1,x:(r) y:(rh)+,y0");
		break;
		}
	case 2209: { // x1,x:(r) y:(rh)+,y1
		unhandled("x1,x:(r) y:(rh)+,y1");
		break;
		}
	case 2210: { // x1,x:(r) y:(rh)+,a
		unhandled("x1,x:(r) y:(rh)+,a");
		break;
		}
	case 2211: { // x1,x:(r) y:(rh)+,b
		unhandled("x1,x:(r) y:(rh)+,b");
		break;
		}
	case 2212: { // a,x:(r) y:(rh)+,y0
		unhandled("a,x:(r) y:(rh)+,y0");
		break;
		}
	case 2213: { // a,x:(r) y:(rh)+,y1
		unhandled("a,x:(r) y:(rh)+,y1");
		break;
		}
	case 2214: { // a,x:(r) y:(rh)+,a
		unhandled("a,x:(r) y:(rh)+,a");
		break;
		}
	case 2215: { // a,x:(r) y:(rh)+,b
		unhandled("a,x:(r) y:(rh)+,b");
		break;
		}
	case 2216: { // b,x:(r) y:(rh)+,y0
		unhandled("b,x:(r) y:(rh)+,y0");
		break;
		}
	case 2217: { // b,x:(r) y:(rh)+,y1
		unhandled("b,x:(r) y:(rh)+,y1");
		break;
		}
	case 2218: { // b,x:(r) y:(rh)+,a
		unhandled("b,x:(r) y:(rh)+,a");
		break;
		}
	case 2219: { // b,x:(r) y:(rh)+,b
		unhandled("b,x:(r) y:(rh)+,b");
		break;
		}
	case 2220: { // x0,x:(r) y:(rh),y0
		unhandled("x0,x:(r) y:(rh),y0");
		break;
		}
	case 2221: { // x0,x:(r) y:(rh),y1
		unhandled("x0,x:(r) y:(rh),y1");
		break;
		}
	case 2222: { // x0,x:(r) y:(rh),a
		unhandled("x0,x:(r) y:(rh),a");
		break;
		}
	case 2223: { // x0,x:(r) y:(rh),b
		unhandled("x0,x:(r) y:(rh),b");
		break;
		}
	case 2224: { // x1,x:(r) y:(rh),y0
		unhandled("x1,x:(r) y:(rh),y0");
		break;
		}
	case 2225: { // x1,x:(r) y:(rh),y1
		unhandled("x1,x:(r) y:(rh),y1");
		break;
		}
	case 2226: { // x1,x:(r) y:(rh),a
		unhandled("x1,x:(r) y:(rh),a");
		break;
		}
	case 2227: { // x1,x:(r) y:(rh),b
		unhandled("x1,x:(r) y:(rh),b");
		break;
		}
	case 2228: { // a,x:(r) y:(rh),y0
		unhandled("a,x:(r) y:(rh),y0");
		break;
		}
	case 2229: { // a,x:(r) y:(rh),y1
		unhandled("a,x:(r) y:(rh),y1");
		break;
		}
	case 2230: { // a,x:(r) y:(rh),a
		unhandled("a,x:(r) y:(rh),a");
		break;
		}
	case 2231: { // a,x:(r) y:(rh),b
		unhandled("a,x:(r) y:(rh),b");
		break;
		}
	case 2232: { // b,x:(r) y:(rh),y0
		unhandled("b,x:(r) y:(rh),y0");
		break;
		}
	case 2233: { // b,x:(r) y:(rh),y1
		unhandled("b,x:(r) y:(rh),y1");
		break;
		}
	case 2234: { // b,x:(r) y:(rh),a
		unhandled("b,x:(r) y:(rh),a");
		break;
		}
	case 2235: { // b,x:(r) y:(rh),b
		unhandled("b,x:(r) y:(rh),b");
		break;
		}
	case 2236: { // x0,x:(r)+n y0,y:(rh)+n
		unhandled("x0,x:(r)+n y0,y:(rh)+n");
		break;
		}
	case 2237: { // x0,x:(r)+n y1,y:(rh)+n
		unhandled("x0,x:(r)+n y1,y:(rh)+n");
		break;
		}
	case 2238: { // x0,x:(r)+n a,y:(rh)+n
		unhandled("x0,x:(r)+n a,y:(rh)+n");
		break;
		}
	case 2239: { // x0,x:(r)+n b,y:(rh)+n
		unhandled("x0,x:(r)+n b,y:(rh)+n");
		break;
		}
	case 2240: { // x1,x:(r)+n y0,y:(rh)+n
		unhandled("x1,x:(r)+n y0,y:(rh)+n");
		break;
		}
	case 2241: { // x1,x:(r)+n y1,y:(rh)+n
		unhandled("x1,x:(r)+n y1,y:(rh)+n");
		break;
		}
	case 2242: { // x1,x:(r)+n a,y:(rh)+n
		unhandled("x1,x:(r)+n a,y:(rh)+n");
		break;
		}
	case 2243: { // x1,x:(r)+n b,y:(rh)+n
		unhandled("x1,x:(r)+n b,y:(rh)+n");
		break;
		}
	case 2244: { // a,x:(r)+n y0,y:(rh)+n
		unhandled("a,x:(r)+n y0,y:(rh)+n");
		break;
		}
	case 2245: { // a,x:(r)+n y1,y:(rh)+n
		unhandled("a,x:(r)+n y1,y:(rh)+n");
		break;
		}
	case 2246: { // a,x:(r)+n a,y:(rh)+n
		unhandled("a,x:(r)+n a,y:(rh)+n");
		break;
		}
	case 2247: { // a,x:(r)+n b,y:(rh)+n
		unhandled("a,x:(r)+n b,y:(rh)+n");
		break;
		}
	case 2248: { // b,x:(r)+n y0,y:(rh)+n
		unhandled("b,x:(r)+n y0,y:(rh)+n");
		break;
		}
	case 2249: { // b,x:(r)+n y1,y:(rh)+n
		unhandled("b,x:(r)+n y1,y:(rh)+n");
		break;
		}
	case 2250: { // b,x:(r)+n a,y:(rh)+n
		unhandled("b,x:(r)+n a,y:(rh)+n");
		break;
		}
	case 2251: { // b,x:(r)+n b,y:(rh)+n
		unhandled("b,x:(r)+n b,y:(rh)+n");
		break;
		}
	case 2252: { // x0,x:(r)+n y0,y:(rh)-
		unhandled("x0,x:(r)+n y0,y:(rh)-");
		break;
		}
	case 2253: { // x0,x:(r)+n y1,y:(rh)-
		unhandled("x0,x:(r)+n y1,y:(rh)-");
		break;
		}
	case 2254: { // x0,x:(r)+n a,y:(rh)-
		unhandled("x0,x:(r)+n a,y:(rh)-");
		break;
		}
	case 2255: { // x0,x:(r)+n b,y:(rh)-
		unhandled("x0,x:(r)+n b,y:(rh)-");
		break;
		}
	case 2256: { // x1,x:(r)+n y0,y:(rh)-
		unhandled("x1,x:(r)+n y0,y:(rh)-");
		break;
		}
	case 2257: { // x1,x:(r)+n y1,y:(rh)-
		unhandled("x1,x:(r)+n y1,y:(rh)-");
		break;
		}
	case 2258: { // x1,x:(r)+n a,y:(rh)-
		unhandled("x1,x:(r)+n a,y:(rh)-");
		break;
		}
	case 2259: { // x1,x:(r)+n b,y:(rh)-
		unhandled("x1,x:(r)+n b,y:(rh)-");
		break;
		}
	case 2260: { // a,x:(r)+n y0,y:(rh)-
		unhandled("a,x:(r)+n y0,y:(rh)-");
		break;
		}
	case 2261: { // a,x:(r)+n y1,y:(rh)-
		unhandled("a,x:(r)+n y1,y:(rh)-");
		break;
		}
	case 2262: { // a,x:(r)+n a,y:(rh)-
		unhandled("a,x:(r)+n a,y:(rh)-");
		break;
		}
	case 2263: { // a,x:(r)+n b,y:(rh)-
		unhandled("a,x:(r)+n b,y:(rh)-");
		break;
		}
	case 2264: { // b,x:(r)+n y0,y:(rh)-
		unhandled("b,x:(r)+n y0,y:(rh)-");
		break;
		}
	case 2265: { // b,x:(r)+n y1,y:(rh)-
		unhandled("b,x:(r)+n y1,y:(rh)-");
		break;
		}
	case 2266: { // b,x:(r)+n a,y:(rh)-
		unhandled("b,x:(r)+n a,y:(rh)-");
		break;
		}
	case 2267: { // b,x:(r)+n b,y:(rh)-
		unhandled("b,x:(r)+n b,y:(rh)-");
		break;
		}
	case 2268: { // x0,x:(r)+n y0,y:(rh)+
		unhandled("x0,x:(r)+n y0,y:(rh)+");
		break;
		}
	case 2269: { // x0,x:(r)+n y1,y:(rh)+
		unhandled("x0,x:(r)+n y1,y:(rh)+");
		break;
		}
	case 2270: { // x0,x:(r)+n a,y:(rh)+
		unhandled("x0,x:(r)+n a,y:(rh)+");
		break;
		}
	case 2271: { // x0,x:(r)+n b,y:(rh)+
		unhandled("x0,x:(r)+n b,y:(rh)+");
		break;
		}
	case 2272: { // x1,x:(r)+n y0,y:(rh)+
		unhandled("x1,x:(r)+n y0,y:(rh)+");
		break;
		}
	case 2273: { // x1,x:(r)+n y1,y:(rh)+
		unhandled("x1,x:(r)+n y1,y:(rh)+");
		break;
		}
	case 2274: { // x1,x:(r)+n a,y:(rh)+
		unhandled("x1,x:(r)+n a,y:(rh)+");
		break;
		}
	case 2275: { // x1,x:(r)+n b,y:(rh)+
		unhandled("x1,x:(r)+n b,y:(rh)+");
		break;
		}
	case 2276: { // a,x:(r)+n y0,y:(rh)+
		unhandled("a,x:(r)+n y0,y:(rh)+");
		break;
		}
	case 2277: { // a,x:(r)+n y1,y:(rh)+
		unhandled("a,x:(r)+n y1,y:(rh)+");
		break;
		}
	case 2278: { // a,x:(r)+n a,y:(rh)+
		unhandled("a,x:(r)+n a,y:(rh)+");
		break;
		}
	case 2279: { // a,x:(r)+n b,y:(rh)+
		unhandled("a,x:(r)+n b,y:(rh)+");
		break;
		}
	case 2280: { // b,x:(r)+n y0,y:(rh)+
		unhandled("b,x:(r)+n y0,y:(rh)+");
		break;
		}
	case 2281: { // b,x:(r)+n y1,y:(rh)+
		unhandled("b,x:(r)+n y1,y:(rh)+");
		break;
		}
	case 2282: { // b,x:(r)+n a,y:(rh)+
		unhandled("b,x:(r)+n a,y:(rh)+");
		break;
		}
	case 2283: { // b,x:(r)+n b,y:(rh)+
		unhandled("b,x:(r)+n b,y:(rh)+");
		break;
		}
	case 2284: { // x0,x:(r)+n y0,y:(rh)
		unhandled("x0,x:(r)+n y0,y:(rh)");
		break;
		}
	case 2285: { // x0,x:(r)+n y1,y:(rh)
		unhandled("x0,x:(r)+n y1,y:(rh)");
		break;
		}
	case 2286: { // x0,x:(r)+n a,y:(rh)
		unhandled("x0,x:(r)+n a,y:(rh)");
		break;
		}
	case 2287: { // x0,x:(r)+n b,y:(rh)
		unhandled("x0,x:(r)+n b,y:(rh)");
		break;
		}
	case 2288: { // x1,x:(r)+n y0,y:(rh)
		unhandled("x1,x:(r)+n y0,y:(rh)");
		break;
		}
	case 2289: { // x1,x:(r)+n y1,y:(rh)
		unhandled("x1,x:(r)+n y1,y:(rh)");
		break;
		}
	case 2290: { // x1,x:(r)+n a,y:(rh)
		unhandled("x1,x:(r)+n a,y:(rh)");
		break;
		}
	case 2291: { // x1,x:(r)+n b,y:(rh)
		unhandled("x1,x:(r)+n b,y:(rh)");
		break;
		}
	case 2292: { // a,x:(r)+n y0,y:(rh)
		unhandled("a,x:(r)+n y0,y:(rh)");
		break;
		}
	case 2293: { // a,x:(r)+n y1,y:(rh)
		unhandled("a,x:(r)+n y1,y:(rh)");
		break;
		}
	case 2294: { // a,x:(r)+n a,y:(rh)
		unhandled("a,x:(r)+n a,y:(rh)");
		break;
		}
	case 2295: { // a,x:(r)+n b,y:(rh)
		unhandled("a,x:(r)+n b,y:(rh)");
		break;
		}
	case 2296: { // b,x:(r)+n y0,y:(rh)
		unhandled("b,x:(r)+n y0,y:(rh)");
		break;
		}
	case 2297: { // b,x:(r)+n y1,y:(rh)
		unhandled("b,x:(r)+n y1,y:(rh)");
		break;
		}
	case 2298: { // b,x:(r)+n a,y:(rh)
		unhandled("b,x:(r)+n a,y:(rh)");
		break;
		}
	case 2299: { // b,x:(r)+n b,y:(rh)
		unhandled("b,x:(r)+n b,y:(rh)");
		break;
		}
	case 2300: { // x0,x:(r)- y0,y:(rh)+n
		unhandled("x0,x:(r)- y0,y:(rh)+n");
		break;
		}
	case 2301: { // x0,x:(r)- y1,y:(rh)+n
		unhandled("x0,x:(r)- y1,y:(rh)+n");
		break;
		}
	case 2302: { // x0,x:(r)- a,y:(rh)+n
		unhandled("x0,x:(r)- a,y:(rh)+n");
		break;
		}
	case 2303: { // x0,x:(r)- b,y:(rh)+n
		unhandled("x0,x:(r)- b,y:(rh)+n");
		break;
		}
	case 2304: { // x1,x:(r)- y0,y:(rh)+n
		unhandled("x1,x:(r)- y0,y:(rh)+n");
		break;
		}
	case 2305: { // x1,x:(r)- y1,y:(rh)+n
		unhandled("x1,x:(r)- y1,y:(rh)+n");
		break;
		}
	case 2306: { // x1,x:(r)- a,y:(rh)+n
		unhandled("x1,x:(r)- a,y:(rh)+n");
		break;
		}
	case 2307: { // x1,x:(r)- b,y:(rh)+n
		unhandled("x1,x:(r)- b,y:(rh)+n");
		break;
		}
	case 2308: { // a,x:(r)- y0,y:(rh)+n
		unhandled("a,x:(r)- y0,y:(rh)+n");
		break;
		}
	case 2309: { // a,x:(r)- y1,y:(rh)+n
		unhandled("a,x:(r)- y1,y:(rh)+n");
		break;
		}
	case 2310: { // a,x:(r)- a,y:(rh)+n
		unhandled("a,x:(r)- a,y:(rh)+n");
		break;
		}
	case 2311: { // a,x:(r)- b,y:(rh)+n
		unhandled("a,x:(r)- b,y:(rh)+n");
		break;
		}
	case 2312: { // b,x:(r)- y0,y:(rh)+n
		unhandled("b,x:(r)- y0,y:(rh)+n");
		break;
		}
	case 2313: { // b,x:(r)- y1,y:(rh)+n
		unhandled("b,x:(r)- y1,y:(rh)+n");
		break;
		}
	case 2314: { // b,x:(r)- a,y:(rh)+n
		unhandled("b,x:(r)- a,y:(rh)+n");
		break;
		}
	case 2315: { // b,x:(r)- b,y:(rh)+n
		unhandled("b,x:(r)- b,y:(rh)+n");
		break;
		}
	case 2316: { // x0,x:(r)- y0,y:(rh)-
		unhandled("x0,x:(r)- y0,y:(rh)-");
		break;
		}
	case 2317: { // x0,x:(r)- y1,y:(rh)-
		unhandled("x0,x:(r)- y1,y:(rh)-");
		break;
		}
	case 2318: { // x0,x:(r)- a,y:(rh)-
		unhandled("x0,x:(r)- a,y:(rh)-");
		break;
		}
	case 2319: { // x0,x:(r)- b,y:(rh)-
		unhandled("x0,x:(r)- b,y:(rh)-");
		break;
		}
	case 2320: { // x1,x:(r)- y0,y:(rh)-
		unhandled("x1,x:(r)- y0,y:(rh)-");
		break;
		}
	case 2321: { // x1,x:(r)- y1,y:(rh)-
		unhandled("x1,x:(r)- y1,y:(rh)-");
		break;
		}
	case 2322: { // x1,x:(r)- a,y:(rh)-
		unhandled("x1,x:(r)- a,y:(rh)-");
		break;
		}
	case 2323: { // x1,x:(r)- b,y:(rh)-
		unhandled("x1,x:(r)- b,y:(rh)-");
		break;
		}
	case 2324: { // a,x:(r)- y0,y:(rh)-
		unhandled("a,x:(r)- y0,y:(rh)-");
		break;
		}
	case 2325: { // a,x:(r)- y1,y:(rh)-
		unhandled("a,x:(r)- y1,y:(rh)-");
		break;
		}
	case 2326: { // a,x:(r)- a,y:(rh)-
		unhandled("a,x:(r)- a,y:(rh)-");
		break;
		}
	case 2327: { // a,x:(r)- b,y:(rh)-
		unhandled("a,x:(r)- b,y:(rh)-");
		break;
		}
	case 2328: { // b,x:(r)- y0,y:(rh)-
		unhandled("b,x:(r)- y0,y:(rh)-");
		break;
		}
	case 2329: { // b,x:(r)- y1,y:(rh)-
		unhandled("b,x:(r)- y1,y:(rh)-");
		break;
		}
	case 2330: { // b,x:(r)- a,y:(rh)-
		unhandled("b,x:(r)- a,y:(rh)-");
		break;
		}
	case 2331: { // b,x:(r)- b,y:(rh)-
		unhandled("b,x:(r)- b,y:(rh)-");
		break;
		}
	case 2332: { // x0,x:(r)- y0,y:(rh)+
		unhandled("x0,x:(r)- y0,y:(rh)+");
		break;
		}
	case 2333: { // x0,x:(r)- y1,y:(rh)+
		unhandled("x0,x:(r)- y1,y:(rh)+");
		break;
		}
	case 2334: { // x0,x:(r)- a,y:(rh)+
		unhandled("x0,x:(r)- a,y:(rh)+");
		break;
		}
	case 2335: { // x0,x:(r)- b,y:(rh)+
		unhandled("x0,x:(r)- b,y:(rh)+");
		break;
		}
	case 2336: { // x1,x:(r)- y0,y:(rh)+
		unhandled("x1,x:(r)- y0,y:(rh)+");
		break;
		}
	case 2337: { // x1,x:(r)- y1,y:(rh)+
		unhandled("x1,x:(r)- y1,y:(rh)+");
		break;
		}
	case 2338: { // x1,x:(r)- a,y:(rh)+
		unhandled("x1,x:(r)- a,y:(rh)+");
		break;
		}
	case 2339: { // x1,x:(r)- b,y:(rh)+
		unhandled("x1,x:(r)- b,y:(rh)+");
		break;
		}
	case 2340: { // a,x:(r)- y0,y:(rh)+
		unhandled("a,x:(r)- y0,y:(rh)+");
		break;
		}
	case 2341: { // a,x:(r)- y1,y:(rh)+
		unhandled("a,x:(r)- y1,y:(rh)+");
		break;
		}
	case 2342: { // a,x:(r)- a,y:(rh)+
		unhandled("a,x:(r)- a,y:(rh)+");
		break;
		}
	case 2343: { // a,x:(r)- b,y:(rh)+
		unhandled("a,x:(r)- b,y:(rh)+");
		break;
		}
	case 2344: { // b,x:(r)- y0,y:(rh)+
		unhandled("b,x:(r)- y0,y:(rh)+");
		break;
		}
	case 2345: { // b,x:(r)- y1,y:(rh)+
		unhandled("b,x:(r)- y1,y:(rh)+");
		break;
		}
	case 2346: { // b,x:(r)- a,y:(rh)+
		unhandled("b,x:(r)- a,y:(rh)+");
		break;
		}
	case 2347: { // b,x:(r)- b,y:(rh)+
		unhandled("b,x:(r)- b,y:(rh)+");
		break;
		}
	case 2348: { // x0,x:(r)- y0,y:(rh)
		unhandled("x0,x:(r)- y0,y:(rh)");
		break;
		}
	case 2349: { // x0,x:(r)- y1,y:(rh)
		unhandled("x0,x:(r)- y1,y:(rh)");
		break;
		}
	case 2350: { // x0,x:(r)- a,y:(rh)
		unhandled("x0,x:(r)- a,y:(rh)");
		break;
		}
	case 2351: { // x0,x:(r)- b,y:(rh)
		unhandled("x0,x:(r)- b,y:(rh)");
		break;
		}
	case 2352: { // x1,x:(r)- y0,y:(rh)
		unhandled("x1,x:(r)- y0,y:(rh)");
		break;
		}
	case 2353: { // x1,x:(r)- y1,y:(rh)
		unhandled("x1,x:(r)- y1,y:(rh)");
		break;
		}
	case 2354: { // x1,x:(r)- a,y:(rh)
		unhandled("x1,x:(r)- a,y:(rh)");
		break;
		}
	case 2355: { // x1,x:(r)- b,y:(rh)
		unhandled("x1,x:(r)- b,y:(rh)");
		break;
		}
	case 2356: { // a,x:(r)- y0,y:(rh)
		unhandled("a,x:(r)- y0,y:(rh)");
		break;
		}
	case 2357: { // a,x:(r)- y1,y:(rh)
		unhandled("a,x:(r)- y1,y:(rh)");
		break;
		}
	case 2358: { // a,x:(r)- a,y:(rh)
		unhandled("a,x:(r)- a,y:(rh)");
		break;
		}
	case 2359: { // a,x:(r)- b,y:(rh)
		unhandled("a,x:(r)- b,y:(rh)");
		break;
		}
	case 2360: { // b,x:(r)- y0,y:(rh)
		unhandled("b,x:(r)- y0,y:(rh)");
		break;
		}
	case 2361: { // b,x:(r)- y1,y:(rh)
		unhandled("b,x:(r)- y1,y:(rh)");
		break;
		}
	case 2362: { // b,x:(r)- a,y:(rh)
		unhandled("b,x:(r)- a,y:(rh)");
		break;
		}
	case 2363: { // b,x:(r)- b,y:(rh)
		unhandled("b,x:(r)- b,y:(rh)");
		break;
		}
	case 2364: { // x0,x:(r)+ y0,y:(rh)+n
		unhandled("x0,x:(r)+ y0,y:(rh)+n");
		break;
		}
	case 2365: { // x0,x:(r)+ y1,y:(rh)+n
		unhandled("x0,x:(r)+ y1,y:(rh)+n");
		break;
		}
	case 2366: { // x0,x:(r)+ a,y:(rh)+n
		unhandled("x0,x:(r)+ a,y:(rh)+n");
		break;
		}
	case 2367: { // x0,x:(r)+ b,y:(rh)+n
		unhandled("x0,x:(r)+ b,y:(rh)+n");
		break;
		}
	case 2368: { // x1,x:(r)+ y0,y:(rh)+n
		unhandled("x1,x:(r)+ y0,y:(rh)+n");
		break;
		}
	case 2369: { // x1,x:(r)+ y1,y:(rh)+n
		unhandled("x1,x:(r)+ y1,y:(rh)+n");
		break;
		}
	case 2370: { // x1,x:(r)+ a,y:(rh)+n
		unhandled("x1,x:(r)+ a,y:(rh)+n");
		break;
		}
	case 2371: { // x1,x:(r)+ b,y:(rh)+n
		unhandled("x1,x:(r)+ b,y:(rh)+n");
		break;
		}
	case 2372: { // a,x:(r)+ y0,y:(rh)+n
		unhandled("a,x:(r)+ y0,y:(rh)+n");
		break;
		}
	case 2373: { // a,x:(r)+ y1,y:(rh)+n
		unhandled("a,x:(r)+ y1,y:(rh)+n");
		break;
		}
	case 2374: { // a,x:(r)+ a,y:(rh)+n
		unhandled("a,x:(r)+ a,y:(rh)+n");
		break;
		}
	case 2375: { // a,x:(r)+ b,y:(rh)+n
		unhandled("a,x:(r)+ b,y:(rh)+n");
		break;
		}
	case 2376: { // b,x:(r)+ y0,y:(rh)+n
		unhandled("b,x:(r)+ y0,y:(rh)+n");
		break;
		}
	case 2377: { // b,x:(r)+ y1,y:(rh)+n
		unhandled("b,x:(r)+ y1,y:(rh)+n");
		break;
		}
	case 2378: { // b,x:(r)+ a,y:(rh)+n
		unhandled("b,x:(r)+ a,y:(rh)+n");
		break;
		}
	case 2379: { // b,x:(r)+ b,y:(rh)+n
		unhandled("b,x:(r)+ b,y:(rh)+n");
		break;
		}
	case 2380: { // x0,x:(r)+ y0,y:(rh)-
		unhandled("x0,x:(r)+ y0,y:(rh)-");
		break;
		}
	case 2381: { // x0,x:(r)+ y1,y:(rh)-
		unhandled("x0,x:(r)+ y1,y:(rh)-");
		break;
		}
	case 2382: { // x0,x:(r)+ a,y:(rh)-
		unhandled("x0,x:(r)+ a,y:(rh)-");
		break;
		}
	case 2383: { // x0,x:(r)+ b,y:(rh)-
		unhandled("x0,x:(r)+ b,y:(rh)-");
		break;
		}
	case 2384: { // x1,x:(r)+ y0,y:(rh)-
		unhandled("x1,x:(r)+ y0,y:(rh)-");
		break;
		}
	case 2385: { // x1,x:(r)+ y1,y:(rh)-
		unhandled("x1,x:(r)+ y1,y:(rh)-");
		break;
		}
	case 2386: { // x1,x:(r)+ a,y:(rh)-
		unhandled("x1,x:(r)+ a,y:(rh)-");
		break;
		}
	case 2387: { // x1,x:(r)+ b,y:(rh)-
		unhandled("x1,x:(r)+ b,y:(rh)-");
		break;
		}
	case 2388: { // a,x:(r)+ y0,y:(rh)-
		unhandled("a,x:(r)+ y0,y:(rh)-");
		break;
		}
	case 2389: { // a,x:(r)+ y1,y:(rh)-
		unhandled("a,x:(r)+ y1,y:(rh)-");
		break;
		}
	case 2390: { // a,x:(r)+ a,y:(rh)-
		unhandled("a,x:(r)+ a,y:(rh)-");
		break;
		}
	case 2391: { // a,x:(r)+ b,y:(rh)-
		unhandled("a,x:(r)+ b,y:(rh)-");
		break;
		}
	case 2392: { // b,x:(r)+ y0,y:(rh)-
		unhandled("b,x:(r)+ y0,y:(rh)-");
		break;
		}
	case 2393: { // b,x:(r)+ y1,y:(rh)-
		unhandled("b,x:(r)+ y1,y:(rh)-");
		break;
		}
	case 2394: { // b,x:(r)+ a,y:(rh)-
		unhandled("b,x:(r)+ a,y:(rh)-");
		break;
		}
	case 2395: { // b,x:(r)+ b,y:(rh)-
		unhandled("b,x:(r)+ b,y:(rh)-");
		break;
		}
	case 2396: { // x0,x:(r)+ y0,y:(rh)+
		unhandled("x0,x:(r)+ y0,y:(rh)+");
		break;
		}
	case 2397: { // x0,x:(r)+ y1,y:(rh)+
		unhandled("x0,x:(r)+ y1,y:(rh)+");
		break;
		}
	case 2398: { // x0,x:(r)+ a,y:(rh)+
		unhandled("x0,x:(r)+ a,y:(rh)+");
		break;
		}
	case 2399: { // x0,x:(r)+ b,y:(rh)+
		unhandled("x0,x:(r)+ b,y:(rh)+");
		break;
		}
	case 2400: { // x1,x:(r)+ y0,y:(rh)+
		unhandled("x1,x:(r)+ y0,y:(rh)+");
		break;
		}
	case 2401: { // x1,x:(r)+ y1,y:(rh)+
		unhandled("x1,x:(r)+ y1,y:(rh)+");
		break;
		}
	case 2402: { // x1,x:(r)+ a,y:(rh)+
		unhandled("x1,x:(r)+ a,y:(rh)+");
		break;
		}
	case 2403: { // x1,x:(r)+ b,y:(rh)+
		unhandled("x1,x:(r)+ b,y:(rh)+");
		break;
		}
	case 2404: { // a,x:(r)+ y0,y:(rh)+
		unhandled("a,x:(r)+ y0,y:(rh)+");
		break;
		}
	case 2405: { // a,x:(r)+ y1,y:(rh)+
		unhandled("a,x:(r)+ y1,y:(rh)+");
		break;
		}
	case 2406: { // a,x:(r)+ a,y:(rh)+
		unhandled("a,x:(r)+ a,y:(rh)+");
		break;
		}
	case 2407: { // a,x:(r)+ b,y:(rh)+
		unhandled("a,x:(r)+ b,y:(rh)+");
		break;
		}
	case 2408: { // b,x:(r)+ y0,y:(rh)+
		unhandled("b,x:(r)+ y0,y:(rh)+");
		break;
		}
	case 2409: { // b,x:(r)+ y1,y:(rh)+
		unhandled("b,x:(r)+ y1,y:(rh)+");
		break;
		}
	case 2410: { // b,x:(r)+ a,y:(rh)+
		unhandled("b,x:(r)+ a,y:(rh)+");
		break;
		}
	case 2411: { // b,x:(r)+ b,y:(rh)+
		unhandled("b,x:(r)+ b,y:(rh)+");
		break;
		}
	case 2412: { // x0,x:(r)+ y0,y:(rh)
		unhandled("x0,x:(r)+ y0,y:(rh)");
		break;
		}
	case 2413: { // x0,x:(r)+ y1,y:(rh)
		unhandled("x0,x:(r)+ y1,y:(rh)");
		break;
		}
	case 2414: { // x0,x:(r)+ a,y:(rh)
		unhandled("x0,x:(r)+ a,y:(rh)");
		break;
		}
	case 2415: { // x0,x:(r)+ b,y:(rh)
		unhandled("x0,x:(r)+ b,y:(rh)");
		break;
		}
	case 2416: { // x1,x:(r)+ y0,y:(rh)
		unhandled("x1,x:(r)+ y0,y:(rh)");
		break;
		}
	case 2417: { // x1,x:(r)+ y1,y:(rh)
		unhandled("x1,x:(r)+ y1,y:(rh)");
		break;
		}
	case 2418: { // x1,x:(r)+ a,y:(rh)
		unhandled("x1,x:(r)+ a,y:(rh)");
		break;
		}
	case 2419: { // x1,x:(r)+ b,y:(rh)
		unhandled("x1,x:(r)+ b,y:(rh)");
		break;
		}
	case 2420: { // a,x:(r)+ y0,y:(rh)
		unhandled("a,x:(r)+ y0,y:(rh)");
		break;
		}
	case 2421: { // a,x:(r)+ y1,y:(rh)
		unhandled("a,x:(r)+ y1,y:(rh)");
		break;
		}
	case 2422: { // a,x:(r)+ a,y:(rh)
		unhandled("a,x:(r)+ a,y:(rh)");
		break;
		}
	case 2423: { // a,x:(r)+ b,y:(rh)
		unhandled("a,x:(r)+ b,y:(rh)");
		break;
		}
	case 2424: { // b,x:(r)+ y0,y:(rh)
		unhandled("b,x:(r)+ y0,y:(rh)");
		break;
		}
	case 2425: { // b,x:(r)+ y1,y:(rh)
		unhandled("b,x:(r)+ y1,y:(rh)");
		break;
		}
	case 2426: { // b,x:(r)+ a,y:(rh)
		unhandled("b,x:(r)+ a,y:(rh)");
		break;
		}
	case 2427: { // b,x:(r)+ b,y:(rh)
		unhandled("b,x:(r)+ b,y:(rh)");
		break;
		}
	case 2428: { // x0,x:(r) y0,y:(rh)+n
		unhandled("x0,x:(r) y0,y:(rh)+n");
		break;
		}
	case 2429: { // x0,x:(r) y1,y:(rh)+n
		unhandled("x0,x:(r) y1,y:(rh)+n");
		break;
		}
	case 2430: { // x0,x:(r) a,y:(rh)+n
		unhandled("x0,x:(r) a,y:(rh)+n");
		break;
		}
	case 2431: { // x0,x:(r) b,y:(rh)+n
		unhandled("x0,x:(r) b,y:(rh)+n");
		break;
		}
	case 2432: { // x1,x:(r) y0,y:(rh)+n
		unhandled("x1,x:(r) y0,y:(rh)+n");
		break;
		}
	case 2433: { // x1,x:(r) y1,y:(rh)+n
		unhandled("x1,x:(r) y1,y:(rh)+n");
		break;
		}
	case 2434: { // x1,x:(r) a,y:(rh)+n
		unhandled("x1,x:(r) a,y:(rh)+n");
		break;
		}
	case 2435: { // x1,x:(r) b,y:(rh)+n
		unhandled("x1,x:(r) b,y:(rh)+n");
		break;
		}
	case 2436: { // a,x:(r) y0,y:(rh)+n
		unhandled("a,x:(r) y0,y:(rh)+n");
		break;
		}
	case 2437: { // a,x:(r) y1,y:(rh)+n
		unhandled("a,x:(r) y1,y:(rh)+n");
		break;
		}
	case 2438: { // a,x:(r) a,y:(rh)+n
		unhandled("a,x:(r) a,y:(rh)+n");
		break;
		}
	case 2439: { // a,x:(r) b,y:(rh)+n
		unhandled("a,x:(r) b,y:(rh)+n");
		break;
		}
	case 2440: { // b,x:(r) y0,y:(rh)+n
		unhandled("b,x:(r) y0,y:(rh)+n");
		break;
		}
	case 2441: { // b,x:(r) y1,y:(rh)+n
		unhandled("b,x:(r) y1,y:(rh)+n");
		break;
		}
	case 2442: { // b,x:(r) a,y:(rh)+n
		unhandled("b,x:(r) a,y:(rh)+n");
		break;
		}
	case 2443: { // b,x:(r) b,y:(rh)+n
		unhandled("b,x:(r) b,y:(rh)+n");
		break;
		}
	case 2444: { // x0,x:(r) y0,y:(rh)-
		unhandled("x0,x:(r) y0,y:(rh)-");
		break;
		}
	case 2445: { // x0,x:(r) y1,y:(rh)-
		unhandled("x0,x:(r) y1,y:(rh)-");
		break;
		}
	case 2446: { // x0,x:(r) a,y:(rh)-
		unhandled("x0,x:(r) a,y:(rh)-");
		break;
		}
	case 2447: { // x0,x:(r) b,y:(rh)-
		unhandled("x0,x:(r) b,y:(rh)-");
		break;
		}
	case 2448: { // x1,x:(r) y0,y:(rh)-
		unhandled("x1,x:(r) y0,y:(rh)-");
		break;
		}
	case 2449: { // x1,x:(r) y1,y:(rh)-
		unhandled("x1,x:(r) y1,y:(rh)-");
		break;
		}
	case 2450: { // x1,x:(r) a,y:(rh)-
		unhandled("x1,x:(r) a,y:(rh)-");
		break;
		}
	case 2451: { // x1,x:(r) b,y:(rh)-
		unhandled("x1,x:(r) b,y:(rh)-");
		break;
		}
	case 2452: { // a,x:(r) y0,y:(rh)-
		unhandled("a,x:(r) y0,y:(rh)-");
		break;
		}
	case 2453: { // a,x:(r) y1,y:(rh)-
		unhandled("a,x:(r) y1,y:(rh)-");
		break;
		}
	case 2454: { // a,x:(r) a,y:(rh)-
		unhandled("a,x:(r) a,y:(rh)-");
		break;
		}
	case 2455: { // a,x:(r) b,y:(rh)-
		unhandled("a,x:(r) b,y:(rh)-");
		break;
		}
	case 2456: { // b,x:(r) y0,y:(rh)-
		unhandled("b,x:(r) y0,y:(rh)-");
		break;
		}
	case 2457: { // b,x:(r) y1,y:(rh)-
		unhandled("b,x:(r) y1,y:(rh)-");
		break;
		}
	case 2458: { // b,x:(r) a,y:(rh)-
		unhandled("b,x:(r) a,y:(rh)-");
		break;
		}
	case 2459: { // b,x:(r) b,y:(rh)-
		unhandled("b,x:(r) b,y:(rh)-");
		break;
		}
	case 2460: { // x0,x:(r) y0,y:(rh)+
		unhandled("x0,x:(r) y0,y:(rh)+");
		break;
		}
	case 2461: { // x0,x:(r) y1,y:(rh)+
		unhandled("x0,x:(r) y1,y:(rh)+");
		break;
		}
	case 2462: { // x0,x:(r) a,y:(rh)+
		unhandled("x0,x:(r) a,y:(rh)+");
		break;
		}
	case 2463: { // x0,x:(r) b,y:(rh)+
		unhandled("x0,x:(r) b,y:(rh)+");
		break;
		}
	case 2464: { // x1,x:(r) y0,y:(rh)+
		unhandled("x1,x:(r) y0,y:(rh)+");
		break;
		}
	case 2465: { // x1,x:(r) y1,y:(rh)+
		unhandled("x1,x:(r) y1,y:(rh)+");
		break;
		}
	case 2466: { // x1,x:(r) a,y:(rh)+
		unhandled("x1,x:(r) a,y:(rh)+");
		break;
		}
	case 2467: { // x1,x:(r) b,y:(rh)+
		unhandled("x1,x:(r) b,y:(rh)+");
		break;
		}
	case 2468: { // a,x:(r) y0,y:(rh)+
		unhandled("a,x:(r) y0,y:(rh)+");
		break;
		}
	case 2469: { // a,x:(r) y1,y:(rh)+
		unhandled("a,x:(r) y1,y:(rh)+");
		break;
		}
	case 2470: { // a,x:(r) a,y:(rh)+
		unhandled("a,x:(r) a,y:(rh)+");
		break;
		}
	case 2471: { // a,x:(r) b,y:(rh)+
		unhandled("a,x:(r) b,y:(rh)+");
		break;
		}
	case 2472: { // b,x:(r) y0,y:(rh)+
		unhandled("b,x:(r) y0,y:(rh)+");
		break;
		}
	case 2473: { // b,x:(r) y1,y:(rh)+
		unhandled("b,x:(r) y1,y:(rh)+");
		break;
		}
	case 2474: { // b,x:(r) a,y:(rh)+
		unhandled("b,x:(r) a,y:(rh)+");
		break;
		}
	case 2475: { // b,x:(r) b,y:(rh)+
		unhandled("b,x:(r) b,y:(rh)+");
		break;
		}
	case 2476: { // x0,x:(r) y0,y:(rh)
		unhandled("x0,x:(r) y0,y:(rh)");
		break;
		}
	case 2477: { // x0,x:(r) y1,y:(rh)
		unhandled("x0,x:(r) y1,y:(rh)");
		break;
		}
	case 2478: { // x0,x:(r) a,y:(rh)
		unhandled("x0,x:(r) a,y:(rh)");
		break;
		}
	case 2479: { // x0,x:(r) b,y:(rh)
		unhandled("x0,x:(r) b,y:(rh)");
		break;
		}
	case 2480: { // x1,x:(r) y0,y:(rh)
		unhandled("x1,x:(r) y0,y:(rh)");
		break;
		}
	case 2481: { // x1,x:(r) y1,y:(rh)
		unhandled("x1,x:(r) y1,y:(rh)");
		break;
		}
	case 2482: { // x1,x:(r) a,y:(rh)
		unhandled("x1,x:(r) a,y:(rh)");
		break;
		}
	case 2483: { // x1,x:(r) b,y:(rh)
		unhandled("x1,x:(r) b,y:(rh)");
		break;
		}
	case 2484: { // a,x:(r) y0,y:(rh)
		unhandled("a,x:(r) y0,y:(rh)");
		break;
		}
	case 2485: { // a,x:(r) y1,y:(rh)
		unhandled("a,x:(r) y1,y:(rh)");
		break;
		}
	case 2486: { // a,x:(r) a,y:(rh)
		unhandled("a,x:(r) a,y:(rh)");
		break;
		}
	case 2487: { // a,x:(r) b,y:(rh)
		unhandled("a,x:(r) b,y:(rh)");
		break;
		}
	case 2488: { // b,x:(r) y0,y:(rh)
		unhandled("b,x:(r) y0,y:(rh)");
		break;
		}
	case 2489: { // b,x:(r) y1,y:(rh)
		unhandled("b,x:(r) y1,y:(rh)");
		break;
		}
	case 2490: { // b,x:(r) a,y:(rh)
		unhandled("b,x:(r) a,y:(rh)");
		break;
		}
	case 2491: { // b,x:(r) b,y:(rh)
		unhandled("b,x:(r) b,y:(rh)");
		break;
		}
	case 2492: { // ifcc
		unhandled("ifcc");
		break;
		}
	case 2493: { // ifge
		unhandled("ifge");
		break;
		}
	case 2494: { // ifne
		unhandled("ifne");
		break;
		}
	case 2495: { // ifpl
		unhandled("ifpl");
		break;
		}
	case 2496: { // ifnn
		unhandled("ifnn");
		break;
		}
	case 2497: { // ifec
		unhandled("ifec");
		break;
		}
	case 2498: { // iflc
		unhandled("iflc");
		break;
		}
	case 2499: { // ifgt
		unhandled("ifgt");
		break;
		}
	case 2500: { // ifcs
		unhandled("ifcs");
		break;
		}
	case 2501: { // iflt
		unhandled("iflt");
		break;
		}
	case 2502: { // ifeq
		unhandled("ifeq");
		break;
		}
	case 2503: { // ifmi
		unhandled("ifmi");
		break;
		}
	case 2504: { // ifnr
		unhandled("ifnr");
		break;
		}
	case 2505: { // ifes
		unhandled("ifes");
		break;
		}
	case 2506: { // ifls
		unhandled("ifls");
		break;
		}
	case 2507: { // ifle
		unhandled("ifle");
		break;
		}
	case 2508: { // ifcc.u
		unhandled("ifcc.u");
		break;
		}
	case 2509: { // ifge.u
		unhandled("ifge.u");
		break;
		}
	case 2510: { // ifne.u
		unhandled("ifne.u");
		break;
		}
	case 2511: { // ifpl.u
		unhandled("ifpl.u");
		break;
		}
	case 2512: { // ifnn.u
		unhandled("ifnn.u");
		break;
		}
	case 2513: { // ifec.u
		unhandled("ifec.u");
		break;
		}
	case 2514: { // iflc.u
		unhandled("iflc.u");
		break;
		}
	case 2515: { // ifgt.u
		unhandled("ifgt.u");
		break;
		}
	case 2516: { // ifcs.u
		unhandled("ifcs.u");
		break;
		}
	case 2517: { // iflt.u
		unhandled("iflt.u");
		break;
		}
	case 2518: { // ifeq.u
		unhandled("ifeq.u");
		break;
		}
	case 2519: { // ifmi.u
		unhandled("ifmi.u");
		break;
		}
	case 2520: { // ifnr.u
		unhandled("ifnr.u");
		break;
		}
	case 2521: { // ifes.u
		unhandled("ifes.u");
		break;
		}
	case 2522: { // ifls.u
		unhandled("ifls.u");
		break;
		}
	case 2523: { // ifle.u
		unhandled("ifle.u");
		break;
		}
	}
}

void dsp563xx_device::execute_post_move(u16 kmove, u32 opcode, u32 exv)
{
	switch(kmove) {
	case 0: { // -
		break;
		}
	case 1: { //
		break;
		}
	case 2: { // #[i],x0
		u32 i = BIT(opcode, 8, 8);
		set_x0f(i);
		break;
		}
	case 3: { // #[i],x1
		u32 i = BIT(opcode, 8, 8);
		set_x1f(i);
		break;
		}
	case 4: { // #[i],y0
		u32 i = BIT(opcode, 8, 8);
		set_y0f(i);
		break;
		}
	case 5: { // #[i],y1
		u32 i = BIT(opcode, 8, 8);
		set_y1f(i);
		break;
		}
	case 6: { // #[i],a0
		u32 i = BIT(opcode, 8, 8);
		set_a0(i);
		break;
		}
	case 7: { // #[i],b0
		u32 i = BIT(opcode, 8, 8);
		set_b0(i);
		break;
		}
	case 8: { // #[i],a2
		u32 i = BIT(opcode, 8, 8);
		set_a2(i);
		break;
		}
	case 9: { // #[i],b2
		u32 i = BIT(opcode, 8, 8);
		set_b2(i);
		break;
		}
	case 10: { // #[i],a1
		u32 i = BIT(opcode, 8, 8);
		set_a1(i);
		break;
		}
	case 11: { // #[i],b1
		u32 i = BIT(opcode, 8, 8);
		set_b1(i);
		break;
		}
	case 12: { // #[i],a
		u32 i = BIT(opcode, 8, 8);
		set_af(i);
		break;
		}
	case 13: { // #[i],b
		u32 i = BIT(opcode, 8, 8);
		set_bf(i);
		break;
		}
	case 14: { // #[i],r
		u32 i = BIT(opcode, 8, 8);
		set_r(BIT(opcode, 16, 5) & 7, i);
		break;
		}
	case 15: { // #[i],n
		u32 i = BIT(opcode, 8, 8);
		set_n(BIT(opcode, 16, 5) & 7, i);
		break;
		}
	case 16: { // x0,x0
		set_x0(m_tmp1);
		break;
		}
	case 17: { // x0,x1
		set_x1(m_tmp1);
		break;
		}
	case 18: { // x0,y0
		set_y0(m_tmp1);
		break;
		}
	case 19: { // x0,y1
		set_y1(m_tmp1);
		break;
		}
	case 20: { // x0,a0
		set_a0(m_tmp1);
		break;
		}
	case 21: { // x0,b0
		set_b0(m_tmp1);
		break;
		}
	case 22: { // x0,a2
		set_a2(m_tmp1);
		break;
		}
	case 23: { // x0,b2
		set_b2(m_tmp1);
		break;
		}
	case 24: { // x0,a1
		set_a1(m_tmp1);
		break;
		}
	case 25: { // x0,b1
		set_b1(m_tmp1);
		break;
		}
	case 26: { // x0,a
		set_ah(m_tmp1);
		break;
		}
	case 27: { // x0,b
		set_bh(m_tmp1);
		break;
		}
	case 28: { // x0,r
		set_r(BIT(opcode, 8, 5) & 7, m_tmp1);
		break;
		}
	case 29: { // x0,n
		set_n(BIT(opcode, 8, 5) & 7, m_tmp1);
		break;
		}
	case 30: { // x1,x0
		set_x0(m_tmp1);
		break;
		}
	case 31: { // x1,x1
		set_x1(m_tmp1);
		break;
		}
	case 32: { // x1,y0
		set_y0(m_tmp1);
		break;
		}
	case 33: { // x1,y1
		set_y1(m_tmp1);
		break;
		}
	case 34: { // x1,a0
		set_a0(m_tmp1);
		break;
		}
	case 35: { // x1,b0
		set_b0(m_tmp1);
		break;
		}
	case 36: { // x1,a2
		set_a2(m_tmp1);
		break;
		}
	case 37: { // x1,b2
		set_b2(m_tmp1);
		break;
		}
	case 38: { // x1,a1
		set_a1(m_tmp1);
		break;
		}
	case 39: { // x1,b1
		set_b1(m_tmp1);
		break;
		}
	case 40: { // x1,a
		set_ah(m_tmp1);
		break;
		}
	case 41: { // x1,b
		set_bh(m_tmp1);
		break;
		}
	case 42: { // x1,r
		set_r(BIT(opcode, 8, 5) & 7, m_tmp1);
		break;
		}
	case 43: { // x1,n
		set_n(BIT(opcode, 8, 5) & 7, m_tmp1);
		break;
		}
	case 44: { // y0,x0
		set_x0(m_tmp1);
		break;
		}
	case 45: { // y0,x1
		set_x1(m_tmp1);
		break;
		}
	case 46: { // y0,y0
		set_y0(m_tmp1);
		break;
		}
	case 47: { // y0,y1
		set_y1(m_tmp1);
		break;
		}
	case 48: { // y0,a0
		set_a0(m_tmp1);
		break;
		}
	case 49: { // y0,b0
		set_b0(m_tmp1);
		break;
		}
	case 50: { // y0,a2
		set_a2(m_tmp1);
		break;
		}
	case 51: { // y0,b2
		set_b2(m_tmp1);
		break;
		}
	case 52: { // y0,a1
		set_a1(m_tmp1);
		break;
		}
	case 53: { // y0,b1
		set_b1(m_tmp1);
		break;
		}
	case 54: { // y0,a
		set_ah(m_tmp1);
		break;
		}
	case 55: { // y0,b
		set_bh(m_tmp1);
		break;
		}
	case 56: { // y0,r
		set_r(BIT(opcode, 8, 5) & 7, m_tmp1);
		break;
		}
	case 57: { // y0,n
		set_n(BIT(opcode, 8, 5) & 7, m_tmp1);
		break;
		}
	case 58: { // y1,x0
		set_x0(m_tmp1);
		break;
		}
	case 59: { // y1,x1
		set_x1(m_tmp1);
		break;
		}
	case 60: { // y1,y0
		set_y0(m_tmp1);
		break;
		}
	case 61: { // y1,y1
		set_y1(m_tmp1);
		break;
		}
	case 62: { // y1,a0
		set_a0(m_tmp1);
		break;
		}
	case 63: { // y1,b0
		set_b0(m_tmp1);
		break;
		}
	case 64: { // y1,a2
		set_a2(m_tmp1);
		break;
		}
	case 65: { // y1,b2
		set_b2(m_tmp1);
		break;
		}
	case 66: { // y1,a1
		set_a1(m_tmp1);
		break;
		}
	case 67: { // y1,b1
		set_b1(m_tmp1);
		break;
		}
	case 68: { // y1,a
		set_ah(m_tmp1);
		break;
		}
	case 69: { // y1,b
		set_bh(m_tmp1);
		break;
		}
	case 70: { // y1,r
		set_r(BIT(opcode, 8, 5) & 7, m_tmp1);
		break;
		}
	case 71: { // y1,n
		set_n(BIT(opcode, 8, 5) & 7, m_tmp1);
		break;
		}
	case 72: { // a0,x0
		set_x0(m_tmp1);
		break;
		}
	case 73: { // a0,x1
		set_x1(m_tmp1);
		break;
		}
	case 74: { // a0,y0
		set_y0(m_tmp1);
		break;
		}
	case 75: { // a0,y1
		set_y1(m_tmp1);
		break;
		}
	case 76: { // a0,a0
		set_a0(m_tmp1);
		break;
		}
	case 77: { // a0,b0
		set_b0(m_tmp1);
		break;
		}
	case 78: { // a0,a2
		set_a2(m_tmp1);
		break;
		}
	case 79: { // a0,b2
		set_b2(m_tmp1);
		break;
		}
	case 80: { // a0,a1
		set_a1(m_tmp1);
		break;
		}
	case 81: { // a0,b1
		set_b1(m_tmp1);
		break;
		}
	case 82: { // a0,a
		set_ah(m_tmp1);
		break;
		}
	case 83: { // a0,b
		set_bh(m_tmp1);
		break;
		}
	case 84: { // a0,r
		set_r(BIT(opcode, 8, 5) & 7, m_tmp1);
		break;
		}
	case 85: { // a0,n
		set_n(BIT(opcode, 8, 5) & 7, m_tmp1);
		break;
		}
	case 86: { // b0,x0
		set_x0(m_tmp1);
		break;
		}
	case 87: { // b0,x1
		set_x1(m_tmp1);
		break;
		}
	case 88: { // b0,y0
		set_y0(m_tmp1);
		break;
		}
	case 89: { // b0,y1
		set_y1(m_tmp1);
		break;
		}
	case 90: { // b0,a0
		set_a0(m_tmp1);
		break;
		}
	case 91: { // b0,b0
		set_b0(m_tmp1);
		break;
		}
	case 92: { // b0,a2
		set_a2(m_tmp1);
		break;
		}
	case 93: { // b0,b2
		set_b2(m_tmp1);
		break;
		}
	case 94: { // b0,a1
		set_a1(m_tmp1);
		break;
		}
	case 95: { // b0,b1
		set_b1(m_tmp1);
		break;
		}
	case 96: { // b0,a
		set_ah(m_tmp1);
		break;
		}
	case 97: { // b0,b
		set_bh(m_tmp1);
		break;
		}
	case 98: { // b0,r
		set_r(BIT(opcode, 8, 5) & 7, m_tmp1);
		break;
		}
	case 99: { // b0,n
		set_n(BIT(opcode, 8, 5) & 7, m_tmp1);
		break;
		}
	case 100: { // a2,x0
		set_x0(m_tmp1);
		break;
		}
	case 101: { // a2,x1
		set_x1(m_tmp1);
		break;
		}
	case 102: { // a2,y0
		set_y0(m_tmp1);
		break;
		}
	case 103: { // a2,y1
		set_y1(m_tmp1);
		break;
		}
	case 104: { // a2,a0
		set_a0(m_tmp1);
		break;
		}
	case 105: { // a2,b0
		set_b0(m_tmp1);
		break;
		}
	case 106: { // a2,a2
		set_a2(m_tmp1);
		break;
		}
	case 107: { // a2,b2
		set_b2(m_tmp1);
		break;
		}
	case 108: { // a2,a1
		set_a1(m_tmp1);
		break;
		}
	case 109: { // a2,b1
		set_b1(m_tmp1);
		break;
		}
	case 110: { // a2,a
		set_ah(m_tmp1);
		break;
		}
	case 111: { // a2,b
		set_bh(m_tmp1);
		break;
		}
	case 112: { // a2,r
		set_r(BIT(opcode, 8, 5) & 7, m_tmp1);
		break;
		}
	case 113: { // a2,n
		set_n(BIT(opcode, 8, 5) & 7, m_tmp1);
		break;
		}
	case 114: { // b2,x0
		set_x0(m_tmp1);
		break;
		}
	case 115: { // b2,x1
		set_x1(m_tmp1);
		break;
		}
	case 116: { // b2,y0
		set_y0(m_tmp1);
		break;
		}
	case 117: { // b2,y1
		set_y1(m_tmp1);
		break;
		}
	case 118: { // b2,a0
		set_a0(m_tmp1);
		break;
		}
	case 119: { // b2,b0
		set_b0(m_tmp1);
		break;
		}
	case 120: { // b2,a2
		set_a2(m_tmp1);
		break;
		}
	case 121: { // b2,b2
		set_b2(m_tmp1);
		break;
		}
	case 122: { // b2,a1
		set_a1(m_tmp1);
		break;
		}
	case 123: { // b2,b1
		set_b1(m_tmp1);
		break;
		}
	case 124: { // b2,a
		set_ah(m_tmp1);
		break;
		}
	case 125: { // b2,b
		set_bh(m_tmp1);
		break;
		}
	case 126: { // b2,r
		set_r(BIT(opcode, 8, 5) & 7, m_tmp1);
		break;
		}
	case 127: { // b2,n
		set_n(BIT(opcode, 8, 5) & 7, m_tmp1);
		break;
		}
	case 128: { // a1,x0
		set_x0(m_tmp1);
		break;
		}
	case 129: { // a1,x1
		set_x1(m_tmp1);
		break;
		}
	case 130: { // a1,y0
		set_y0(m_tmp1);
		break;
		}
	case 131: { // a1,y1
		set_y1(m_tmp1);
		break;
		}
	case 132: { // a1,a0
		set_a0(m_tmp1);
		break;
		}
	case 133: { // a1,b0
		set_b0(m_tmp1);
		break;
		}
	case 134: { // a1,a2
		set_a2(m_tmp1);
		break;
		}
	case 135: { // a1,b2
		set_b2(m_tmp1);
		break;
		}
	case 136: { // a1,a1
		set_a1(m_tmp1);
		break;
		}
	case 137: { // a1,b1
		set_b1(m_tmp1);
		break;
		}
	case 138: { // a1,a
		set_ah(m_tmp1);
		break;
		}
	case 139: { // a1,b
		set_bh(m_tmp1);
		break;
		}
	case 140: { // a1,r
		set_r(BIT(opcode, 8, 5) & 7, m_tmp1);
		break;
		}
	case 141: { // a1,n
		set_n(BIT(opcode, 8, 5) & 7, m_tmp1);
		break;
		}
	case 142: { // b1,x0
		set_x0(m_tmp1);
		break;
		}
	case 143: { // b1,x1
		set_x1(m_tmp1);
		break;
		}
	case 144: { // b1,y0
		set_y0(m_tmp1);
		break;
		}
	case 145: { // b1,y1
		set_y1(m_tmp1);
		break;
		}
	case 146: { // b1,a0
		set_a0(m_tmp1);
		break;
		}
	case 147: { // b1,b0
		set_b0(m_tmp1);
		break;
		}
	case 148: { // b1,a2
		set_a2(m_tmp1);
		break;
		}
	case 149: { // b1,b2
		set_b2(m_tmp1);
		break;
		}
	case 150: { // b1,a1
		set_a1(m_tmp1);
		break;
		}
	case 151: { // b1,b1
		set_b1(m_tmp1);
		break;
		}
	case 152: { // b1,a
		set_ah(m_tmp1);
		break;
		}
	case 153: { // b1,b
		set_bh(m_tmp1);
		break;
		}
	case 154: { // b1,r
		set_r(BIT(opcode, 8, 5) & 7, m_tmp1);
		break;
		}
	case 155: { // b1,n
		set_n(BIT(opcode, 8, 5) & 7, m_tmp1);
		break;
		}
	case 156: { // a,x0
		set_x0(m_tmp1);
		break;
		}
	case 157: { // a,x1
		set_x1(m_tmp1);
		break;
		}
	case 158: { // a,y0
		set_y0(m_tmp1);
		break;
		}
	case 159: { // a,y1
		set_y1(m_tmp1);
		break;
		}
	case 160: { // a,a0
		set_a0(m_tmp1);
		break;
		}
	case 161: { // a,b0
		set_b0(m_tmp1);
		break;
		}
	case 162: { // a,a2
		set_a2(m_tmp1);
		break;
		}
	case 163: { // a,b2
		set_b2(m_tmp1);
		break;
		}
	case 164: { // a,a1
		set_a1(m_tmp1);
		break;
		}
	case 165: { // a,b1
		set_b1(m_tmp1);
		break;
		}
	case 166: { // a,a
		set_ah(m_tmp1);
		break;
		}
	case 167: { // a,b
		set_bh(m_tmp1);
		break;
		}
	case 168: { // a,r
		set_r(BIT(opcode, 8, 5) & 7, m_tmp1);
		break;
		}
	case 169: { // a,n
		set_n(BIT(opcode, 8, 5) & 7, m_tmp1);
		break;
		}
	case 170: { // b,x0
		set_x0(m_tmp1);
		break;
		}
	case 171: { // b,x1
		set_x1(m_tmp1);
		break;
		}
	case 172: { // b,y0
		set_y0(m_tmp1);
		break;
		}
	case 173: { // b,y1
		set_y1(m_tmp1);
		break;
		}
	case 174: { // b,a0
		set_a0(m_tmp1);
		break;
		}
	case 175: { // b,b0
		set_b0(m_tmp1);
		break;
		}
	case 176: { // b,a2
		set_a2(m_tmp1);
		break;
		}
	case 177: { // b,b2
		set_b2(m_tmp1);
		break;
		}
	case 178: { // b,a1
		set_a1(m_tmp1);
		break;
		}
	case 179: { // b,b1
		set_b1(m_tmp1);
		break;
		}
	case 180: { // b,a
		set_ah(m_tmp1);
		break;
		}
	case 181: { // b,b
		set_bh(m_tmp1);
		break;
		}
	case 182: { // b,r
		set_r(BIT(opcode, 8, 5) & 7, m_tmp1);
		break;
		}
	case 183: { // b,n
		set_n(BIT(opcode, 8, 5) & 7, m_tmp1);
		break;
		}
	case 184: { // r,x0
		set_x0(m_tmp1);
		break;
		}
	case 185: { // r,x1
		set_x1(m_tmp1);
		break;
		}
	case 186: { // r,y0
		set_y0(m_tmp1);
		break;
		}
	case 187: { // r,y1
		set_y1(m_tmp1);
		break;
		}
	case 188: { // r,a0
		set_a0(m_tmp1);
		break;
		}
	case 189: { // r,b0
		set_b0(m_tmp1);
		break;
		}
	case 190: { // r,a2
		set_a2(m_tmp1);
		break;
		}
	case 191: { // r,b2
		set_b2(m_tmp1);
		break;
		}
	case 192: { // r,a1
		set_a1(m_tmp1);
		break;
		}
	case 193: { // r,b1
		set_b1(m_tmp1);
		break;
		}
	case 194: { // r,a
		set_ah(m_tmp1);
		break;
		}
	case 195: { // r,b
		set_bh(m_tmp1);
		break;
		}
	case 196: { // r,r
		set_r(BIT(opcode, 8, 5) & 7, m_tmp1);
		break;
		}
	case 197: { // r,n
		set_n(BIT(opcode, 8, 5) & 7, m_tmp1);
		break;
		}
	case 198: { // n,x0
		set_x0(m_tmp1);
		break;
		}
	case 199: { // n,x1
		set_x1(m_tmp1);
		break;
		}
	case 200: { // n,y0
		set_y0(m_tmp1);
		break;
		}
	case 201: { // n,y1
		set_y1(m_tmp1);
		break;
		}
	case 202: { // n,a0
		set_a0(m_tmp1);
		break;
		}
	case 203: { // n,b0
		set_b0(m_tmp1);
		break;
		}
	case 204: { // n,a2
		set_a2(m_tmp1);
		break;
		}
	case 205: { // n,b2
		set_b2(m_tmp1);
		break;
		}
	case 206: { // n,a1
		set_a1(m_tmp1);
		break;
		}
	case 207: { // n,b1
		set_b1(m_tmp1);
		break;
		}
	case 208: { // n,a
		set_ah(m_tmp1);
		break;
		}
	case 209: { // n,b
		set_bh(m_tmp1);
		break;
		}
	case 210: { // n,r
		set_r(BIT(opcode, 8, 5) & 7, m_tmp1);
		break;
		}
	case 211: { // n,n
		set_n(BIT(opcode, 8, 5) & 7, m_tmp1);
		break;
		}
	case 212: { // (r)-n
		break;
		}
	case 213: { // (r)+n
		break;
		}
	case 214: { // (r)-
		break;
		}
	case 215: { // (r)+
		break;
		}
	case 216: { // x:(r)-n,x0
		set_x0(m_tmp1);
		break;
		}
	case 217: { // x:(r)+n,x0
		set_x0(m_tmp1);
		break;
		}
	case 218: { // x:(r)-,x0
		set_x0(m_tmp1);
		break;
		}
	case 219: { // x:(r)+,x0
		set_x0(m_tmp1);
		break;
		}
	case 220: { // x:(r),x0
		set_x0(m_tmp1);
		break;
		}
	case 221: { // x:(r+n),x0
		set_x0(m_tmp1);
		break;
		}
	case 222: { // x:-(r),x0
		set_x0(m_tmp1);
		break;
		}
	case 223: { // y:(r)-n,x0
		set_x0(m_tmp1);
		break;
		}
	case 224: { // y:(r)+n,x0
		set_x0(m_tmp1);
		break;
		}
	case 225: { // y:(r)-,x0
		set_x0(m_tmp1);
		break;
		}
	case 226: { // y:(r)+,x0
		set_x0(m_tmp1);
		break;
		}
	case 227: { // y:(r),x0
		set_x0(m_tmp1);
		break;
		}
	case 228: { // y:(r+n),x0
		set_x0(m_tmp1);
		break;
		}
	case 229: { // y:-(r),x0
		set_x0(m_tmp1);
		break;
		}
	case 230: { // x:(r)-n,x1
		set_x1(m_tmp1);
		break;
		}
	case 231: { // x:(r)+n,x1
		set_x1(m_tmp1);
		break;
		}
	case 232: { // x:(r)-,x1
		set_x1(m_tmp1);
		break;
		}
	case 233: { // x:(r)+,x1
		set_x1(m_tmp1);
		break;
		}
	case 234: { // x:(r),x1
		set_x1(m_tmp1);
		break;
		}
	case 235: { // x:(r+n),x1
		set_x1(m_tmp1);
		break;
		}
	case 236: { // x:-(r),x1
		set_x1(m_tmp1);
		break;
		}
	case 237: { // y:(r)-n,x1
		set_x1(m_tmp1);
		break;
		}
	case 238: { // y:(r)+n,x1
		set_x1(m_tmp1);
		break;
		}
	case 239: { // y:(r)-,x1
		set_x1(m_tmp1);
		break;
		}
	case 240: { // y:(r)+,x1
		set_x1(m_tmp1);
		break;
		}
	case 241: { // y:(r),x1
		set_x1(m_tmp1);
		break;
		}
	case 242: { // y:(r+n),x1
		set_x1(m_tmp1);
		break;
		}
	case 243: { // y:-(r),x1
		set_x1(m_tmp1);
		break;
		}
	case 244: { // x:(r)-n,y0
		set_y0(m_tmp1);
		break;
		}
	case 245: { // x:(r)+n,y0
		set_y0(m_tmp1);
		break;
		}
	case 246: { // x:(r)-,y0
		set_y0(m_tmp1);
		break;
		}
	case 247: { // x:(r)+,y0
		set_y0(m_tmp1);
		break;
		}
	case 248: { // x:(r),y0
		set_y0(m_tmp1);
		break;
		}
	case 249: { // x:(r+n),y0
		set_y0(m_tmp1);
		break;
		}
	case 250: { // x:-(r),y0
		set_y0(m_tmp1);
		break;
		}
	case 251: { // y:(r)-n,y0
		set_y0(m_tmp1);
		break;
		}
	case 252: { // y:(r)+n,y0
		set_y0(m_tmp1);
		break;
		}
	case 253: { // y:(r)-,y0
		set_y0(m_tmp1);
		break;
		}
	case 254: { // y:(r)+,y0
		set_y0(m_tmp1);
		break;
		}
	case 255: { // y:(r),y0
		set_y0(m_tmp1);
		break;
		}
	case 256: { // y:(r+n),y0
		set_y0(m_tmp1);
		break;
		}
	case 257: { // y:-(r),y0
		set_y0(m_tmp1);
		break;
		}
	case 258: { // x:(r)-n,y1
		set_y1(m_tmp1);
		break;
		}
	case 259: { // x:(r)+n,y1
		set_y1(m_tmp1);
		break;
		}
	case 260: { // x:(r)-,y1
		set_y1(m_tmp1);
		break;
		}
	case 261: { // x:(r)+,y1
		set_y1(m_tmp1);
		break;
		}
	case 262: { // x:(r),y1
		set_y1(m_tmp1);
		break;
		}
	case 263: { // x:(r+n),y1
		set_y1(m_tmp1);
		break;
		}
	case 264: { // x:-(r),y1
		set_y1(m_tmp1);
		break;
		}
	case 265: { // y:(r)-n,y1
		set_y1(m_tmp1);
		break;
		}
	case 266: { // y:(r)+n,y1
		set_y1(m_tmp1);
		break;
		}
	case 267: { // y:(r)-,y1
		set_y1(m_tmp1);
		break;
		}
	case 268: { // y:(r)+,y1
		set_y1(m_tmp1);
		break;
		}
	case 269: { // y:(r),y1
		set_y1(m_tmp1);
		break;
		}
	case 270: { // y:(r+n),y1
		set_y1(m_tmp1);
		break;
		}
	case 271: { // y:-(r),y1
		set_y1(m_tmp1);
		break;
		}
	case 272: { // x:(r)-n,a0
		set_a0(m_tmp1);
		break;
		}
	case 273: { // x:(r)+n,a0
		set_a0(m_tmp1);
		break;
		}
	case 274: { // x:(r)-,a0
		set_a0(m_tmp1);
		break;
		}
	case 275: { // x:(r)+,a0
		set_a0(m_tmp1);
		break;
		}
	case 276: { // x:(r),a0
		set_a0(m_tmp1);
		break;
		}
	case 277: { // x:(r+n),a0
		set_a0(m_tmp1);
		break;
		}
	case 278: { // x:-(r),a0
		set_a0(m_tmp1);
		break;
		}
	case 279: { // y:(r)-n,a0
		set_a0(m_tmp1);
		break;
		}
	case 280: { // y:(r)+n,a0
		set_a0(m_tmp1);
		break;
		}
	case 281: { // y:(r)-,a0
		set_a0(m_tmp1);
		break;
		}
	case 282: { // y:(r)+,a0
		set_a0(m_tmp1);
		break;
		}
	case 283: { // y:(r),a0
		set_a0(m_tmp1);
		break;
		}
	case 284: { // y:(r+n),a0
		set_a0(m_tmp1);
		break;
		}
	case 285: { // y:-(r),a0
		set_a0(m_tmp1);
		break;
		}
	case 286: { // x:(r)-n,b0
		set_b0(m_tmp1);
		break;
		}
	case 287: { // x:(r)+n,b0
		set_b0(m_tmp1);
		break;
		}
	case 288: { // x:(r)-,b0
		set_b0(m_tmp1);
		break;
		}
	case 289: { // x:(r)+,b0
		set_b0(m_tmp1);
		break;
		}
	case 290: { // x:(r),b0
		set_b0(m_tmp1);
		break;
		}
	case 291: { // x:(r+n),b0
		set_b0(m_tmp1);
		break;
		}
	case 292: { // x:-(r),b0
		set_b0(m_tmp1);
		break;
		}
	case 293: { // y:(r)-n,b0
		set_b0(m_tmp1);
		break;
		}
	case 294: { // y:(r)+n,b0
		set_b0(m_tmp1);
		break;
		}
	case 295: { // y:(r)-,b0
		set_b0(m_tmp1);
		break;
		}
	case 296: { // y:(r)+,b0
		set_b0(m_tmp1);
		break;
		}
	case 297: { // y:(r),b0
		set_b0(m_tmp1);
		break;
		}
	case 298: { // y:(r+n),b0
		set_b0(m_tmp1);
		break;
		}
	case 299: { // y:-(r),b0
		set_b0(m_tmp1);
		break;
		}
	case 300: { // x:(r)-n,a2
		set_a2(m_tmp1);
		break;
		}
	case 301: { // x:(r)+n,a2
		set_a2(m_tmp1);
		break;
		}
	case 302: { // x:(r)-,a2
		set_a2(m_tmp1);
		break;
		}
	case 303: { // x:(r)+,a2
		set_a2(m_tmp1);
		break;
		}
	case 304: { // x:(r),a2
		set_a2(m_tmp1);
		break;
		}
	case 305: { // x:(r+n),a2
		set_a2(m_tmp1);
		break;
		}
	case 306: { // x:-(r),a2
		set_a2(m_tmp1);
		break;
		}
	case 307: { // y:(r)-n,a2
		set_a2(m_tmp1);
		break;
		}
	case 308: { // y:(r)+n,a2
		set_a2(m_tmp1);
		break;
		}
	case 309: { // y:(r)-,a2
		set_a2(m_tmp1);
		break;
		}
	case 310: { // y:(r)+,a2
		set_a2(m_tmp1);
		break;
		}
	case 311: { // y:(r),a2
		set_a2(m_tmp1);
		break;
		}
	case 312: { // y:(r+n),a2
		set_a2(m_tmp1);
		break;
		}
	case 313: { // y:-(r),a2
		set_a2(m_tmp1);
		break;
		}
	case 314: { // x:(r)-n,b2
		set_b2(m_tmp1);
		break;
		}
	case 315: { // x:(r)+n,b2
		set_b2(m_tmp1);
		break;
		}
	case 316: { // x:(r)-,b2
		set_b2(m_tmp1);
		break;
		}
	case 317: { // x:(r)+,b2
		set_b2(m_tmp1);
		break;
		}
	case 318: { // x:(r),b2
		set_b2(m_tmp1);
		break;
		}
	case 319: { // x:(r+n),b2
		set_b2(m_tmp1);
		break;
		}
	case 320: { // x:-(r),b2
		set_b2(m_tmp1);
		break;
		}
	case 321: { // y:(r)-n,b2
		set_b2(m_tmp1);
		break;
		}
	case 322: { // y:(r)+n,b2
		set_b2(m_tmp1);
		break;
		}
	case 323: { // y:(r)-,b2
		set_b2(m_tmp1);
		break;
		}
	case 324: { // y:(r)+,b2
		set_b2(m_tmp1);
		break;
		}
	case 325: { // y:(r),b2
		set_b2(m_tmp1);
		break;
		}
	case 326: { // y:(r+n),b2
		set_b2(m_tmp1);
		break;
		}
	case 327: { // y:-(r),b2
		set_b2(m_tmp1);
		break;
		}
	case 328: { // x:(r)-n,a1
		set_a1(m_tmp1);
		break;
		}
	case 329: { // x:(r)+n,a1
		set_a1(m_tmp1);
		break;
		}
	case 330: { // x:(r)-,a1
		set_a1(m_tmp1);
		break;
		}
	case 331: { // x:(r)+,a1
		set_a1(m_tmp1);
		break;
		}
	case 332: { // x:(r),a1
		set_a1(m_tmp1);
		break;
		}
	case 333: { // x:(r+n),a1
		set_a1(m_tmp1);
		break;
		}
	case 334: { // x:-(r),a1
		set_a1(m_tmp1);
		break;
		}
	case 335: { // y:(r)-n,a1
		set_a1(m_tmp1);
		break;
		}
	case 336: { // y:(r)+n,a1
		set_a1(m_tmp1);
		break;
		}
	case 337: { // y:(r)-,a1
		set_a1(m_tmp1);
		break;
		}
	case 338: { // y:(r)+,a1
		set_a1(m_tmp1);
		break;
		}
	case 339: { // y:(r),a1
		set_a1(m_tmp1);
		break;
		}
	case 340: { // y:(r+n),a1
		set_a1(m_tmp1);
		break;
		}
	case 341: { // y:-(r),a1
		set_a1(m_tmp1);
		break;
		}
	case 342: { // x:(r)-n,b1
		set_b1(m_tmp1);
		break;
		}
	case 343: { // x:(r)+n,b1
		set_b1(m_tmp1);
		break;
		}
	case 344: { // x:(r)-,b1
		set_b1(m_tmp1);
		break;
		}
	case 345: { // x:(r)+,b1
		set_b1(m_tmp1);
		break;
		}
	case 346: { // x:(r),b1
		set_b1(m_tmp1);
		break;
		}
	case 347: { // x:(r+n),b1
		set_b1(m_tmp1);
		break;
		}
	case 348: { // x:-(r),b1
		set_b1(m_tmp1);
		break;
		}
	case 349: { // y:(r)-n,b1
		set_b1(m_tmp1);
		break;
		}
	case 350: { // y:(r)+n,b1
		set_b1(m_tmp1);
		break;
		}
	case 351: { // y:(r)-,b1
		set_b1(m_tmp1);
		break;
		}
	case 352: { // y:(r)+,b1
		set_b1(m_tmp1);
		break;
		}
	case 353: { // y:(r),b1
		set_b1(m_tmp1);
		break;
		}
	case 354: { // y:(r+n),b1
		set_b1(m_tmp1);
		break;
		}
	case 355: { // y:-(r),b1
		set_b1(m_tmp1);
		break;
		}
	case 356: { // x:(r)-n,a
		set_ah(m_tmp1);
		break;
		}
	case 357: { // x:(r)+n,a
		set_ah(m_tmp1);
		break;
		}
	case 358: { // x:(r)-,a
		set_ah(m_tmp1);
		break;
		}
	case 359: { // x:(r)+,a
		set_ah(m_tmp1);
		break;
		}
	case 360: { // x:(r),a
		set_ah(m_tmp1);
		break;
		}
	case 361: { // x:(r+n),a
		set_ah(m_tmp1);
		break;
		}
	case 362: { // x:-(r),a
		set_ah(m_tmp1);
		break;
		}
	case 363: { // y:(r)-n,a
		set_ah(m_tmp1);
		break;
		}
	case 364: { // y:(r)+n,a
		set_ah(m_tmp1);
		break;
		}
	case 365: { // y:(r)-,a
		set_ah(m_tmp1);
		break;
		}
	case 366: { // y:(r)+,a
		set_ah(m_tmp1);
		break;
		}
	case 367: { // y:(r),a
		set_ah(m_tmp1);
		break;
		}
	case 368: { // y:(r+n),a
		set_ah(m_tmp1);
		break;
		}
	case 369: { // y:-(r),a
		set_ah(m_tmp1);
		break;
		}
	case 370: { // x:(r)-n,b
		set_bh(m_tmp1);
		break;
		}
	case 371: { // x:(r)+n,b
		set_bh(m_tmp1);
		break;
		}
	case 372: { // x:(r)-,b
		set_bh(m_tmp1);
		break;
		}
	case 373: { // x:(r)+,b
		set_bh(m_tmp1);
		break;
		}
	case 374: { // x:(r),b
		set_bh(m_tmp1);
		break;
		}
	case 375: { // x:(r+n),b
		set_bh(m_tmp1);
		break;
		}
	case 376: { // x:-(r),b
		set_bh(m_tmp1);
		break;
		}
	case 377: { // y:(r)-n,b
		set_bh(m_tmp1);
		break;
		}
	case 378: { // y:(r)+n,b
		set_bh(m_tmp1);
		break;
		}
	case 379: { // y:(r)-,b
		set_bh(m_tmp1);
		break;
		}
	case 380: { // y:(r)+,b
		set_bh(m_tmp1);
		break;
		}
	case 381: { // y:(r),b
		set_bh(m_tmp1);
		break;
		}
	case 382: { // y:(r+n),b
		set_bh(m_tmp1);
		break;
		}
	case 383: { // y:-(r),b
		set_bh(m_tmp1);
		break;
		}
	case 384: { // x:(r)-n,r
		set_r(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7, m_tmp1);
		break;
		}
	case 385: { // x:(r)+n,r
		set_r(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7, m_tmp1);
		break;
		}
	case 386: { // x:(r)-,r
		set_r(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7, m_tmp1);
		break;
		}
	case 387: { // x:(r)+,r
		set_r(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7, m_tmp1);
		break;
		}
	case 388: { // x:(r),r
		set_r(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7, m_tmp1);
		break;
		}
	case 389: { // x:(r+n),r
		set_r(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7, m_tmp1);
		break;
		}
	case 390: { // x:-(r),r
		set_r(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7, m_tmp1);
		break;
		}
	case 391: { // y:(r)-n,r
		set_r(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7, m_tmp1);
		break;
		}
	case 392: { // y:(r)+n,r
		set_r(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7, m_tmp1);
		break;
		}
	case 393: { // y:(r)-,r
		set_r(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7, m_tmp1);
		break;
		}
	case 394: { // y:(r)+,r
		set_r(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7, m_tmp1);
		break;
		}
	case 395: { // y:(r),r
		set_r(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7, m_tmp1);
		break;
		}
	case 396: { // y:(r+n),r
		set_r(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7, m_tmp1);
		break;
		}
	case 397: { // y:-(r),r
		set_r(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7, m_tmp1);
		break;
		}
	case 398: { // x:(r)-n,n
		set_n(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7, m_tmp1);
		break;
		}
	case 399: { // x:(r)+n,n
		set_n(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7, m_tmp1);
		break;
		}
	case 400: { // x:(r)-,n
		set_n(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7, m_tmp1);
		break;
		}
	case 401: { // x:(r)+,n
		set_n(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7, m_tmp1);
		break;
		}
	case 402: { // x:(r),n
		set_n(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7, m_tmp1);
		break;
		}
	case 403: { // x:(r+n),n
		set_n(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7, m_tmp1);
		break;
		}
	case 404: { // x:-(r),n
		set_n(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7, m_tmp1);
		break;
		}
	case 405: { // y:(r)-n,n
		set_n(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7, m_tmp1);
		break;
		}
	case 406: { // y:(r)+n,n
		set_n(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7, m_tmp1);
		break;
		}
	case 407: { // y:(r)-,n
		set_n(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7, m_tmp1);
		break;
		}
	case 408: { // y:(r)+,n
		set_n(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7, m_tmp1);
		break;
		}
	case 409: { // y:(r),n
		set_n(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7, m_tmp1);
		break;
		}
	case 410: { // y:(r+n),n
		set_n(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7, m_tmp1);
		break;
		}
	case 411: { // y:-(r),n
		set_n(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7, m_tmp1);
		break;
		}
	case 412: { // x0,x:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 413: { // x0,x:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 414: { // x0,x:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 415: { // x0,x:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 416: { // x0,x:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 417: { // x0,x:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 418: { // x0,x:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 419: { // x0,y:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 420: { // x0,y:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 421: { // x0,y:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 422: { // x0,y:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 423: { // x0,y:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 424: { // x0,y:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 425: { // x0,y:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 426: { // x1,x:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 427: { // x1,x:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 428: { // x1,x:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 429: { // x1,x:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 430: { // x1,x:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 431: { // x1,x:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 432: { // x1,x:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 433: { // x1,y:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 434: { // x1,y:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 435: { // x1,y:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 436: { // x1,y:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 437: { // x1,y:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 438: { // x1,y:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 439: { // x1,y:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 440: { // y0,x:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 441: { // y0,x:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 442: { // y0,x:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 443: { // y0,x:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 444: { // y0,x:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 445: { // y0,x:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 446: { // y0,x:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 447: { // y0,y:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 448: { // y0,y:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 449: { // y0,y:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 450: { // y0,y:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 451: { // y0,y:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 452: { // y0,y:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 453: { // y0,y:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 454: { // y1,x:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 455: { // y1,x:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 456: { // y1,x:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 457: { // y1,x:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 458: { // y1,x:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 459: { // y1,x:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 460: { // y1,x:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 461: { // y1,y:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 462: { // y1,y:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 463: { // y1,y:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 464: { // y1,y:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 465: { // y1,y:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 466: { // y1,y:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 467: { // y1,y:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 468: { // a0,x:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 469: { // a0,x:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 470: { // a0,x:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 471: { // a0,x:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 472: { // a0,x:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 473: { // a0,x:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 474: { // a0,x:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 475: { // a0,y:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 476: { // a0,y:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 477: { // a0,y:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 478: { // a0,y:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 479: { // a0,y:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 480: { // a0,y:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 481: { // a0,y:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 482: { // b0,x:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 483: { // b0,x:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 484: { // b0,x:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 485: { // b0,x:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 486: { // b0,x:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 487: { // b0,x:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 488: { // b0,x:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 489: { // b0,y:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 490: { // b0,y:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 491: { // b0,y:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 492: { // b0,y:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 493: { // b0,y:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 494: { // b0,y:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 495: { // b0,y:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 496: { // a2,x:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 497: { // a2,x:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 498: { // a2,x:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 499: { // a2,x:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 500: { // a2,x:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 501: { // a2,x:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 502: { // a2,x:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 503: { // a2,y:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 504: { // a2,y:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 505: { // a2,y:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 506: { // a2,y:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 507: { // a2,y:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 508: { // a2,y:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 509: { // a2,y:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 510: { // b2,x:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 511: { // b2,x:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 512: { // b2,x:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 513: { // b2,x:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 514: { // b2,x:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 515: { // b2,x:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 516: { // b2,x:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 517: { // b2,y:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 518: { // b2,y:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 519: { // b2,y:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 520: { // b2,y:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 521: { // b2,y:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 522: { // b2,y:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 523: { // b2,y:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 524: { // a1,x:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 525: { // a1,x:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 526: { // a1,x:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 527: { // a1,x:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 528: { // a1,x:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 529: { // a1,x:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 530: { // a1,x:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 531: { // a1,y:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 532: { // a1,y:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 533: { // a1,y:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 534: { // a1,y:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 535: { // a1,y:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 536: { // a1,y:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 537: { // a1,y:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 538: { // b1,x:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 539: { // b1,x:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 540: { // b1,x:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 541: { // b1,x:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 542: { // b1,x:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 543: { // b1,x:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 544: { // b1,x:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 545: { // b1,y:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 546: { // b1,y:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 547: { // b1,y:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 548: { // b1,y:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 549: { // b1,y:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 550: { // b1,y:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 551: { // b1,y:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 552: { // a,x:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 553: { // a,x:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 554: { // a,x:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 555: { // a,x:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 556: { // a,x:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 557: { // a,x:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 558: { // a,x:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 559: { // a,y:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 560: { // a,y:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 561: { // a,y:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 562: { // a,y:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 563: { // a,y:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 564: { // a,y:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 565: { // a,y:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 566: { // b,x:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 567: { // b,x:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 568: { // b,x:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 569: { // b,x:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 570: { // b,x:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 571: { // b,x:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 572: { // b,x:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 573: { // b,y:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 574: { // b,y:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 575: { // b,y:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 576: { // b,y:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 577: { // b,y:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 578: { // b,y:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 579: { // b,y:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 580: { // r,x:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 581: { // r,x:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 582: { // r,x:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 583: { // r,x:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 584: { // r,x:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 585: { // r,x:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 586: { // r,x:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 587: { // r,y:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 588: { // r,y:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 589: { // r,y:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 590: { // r,y:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 591: { // r,y:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 592: { // r,y:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 593: { // r,y:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 594: { // n,x:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 595: { // n,x:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 596: { // n,x:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 597: { // n,x:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 598: { // n,x:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 599: { // n,x:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 600: { // n,x:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		break;
		}
	case 601: { // n,y:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 602: { // n,y:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 603: { // n,y:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 604: { // n,y:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 605: { // n,y:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 606: { // n,y:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 607: { // n,y:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_y.write_dword(ea, m_tmp1);
		break;
		}
	case 608: { // x:[abs],x0
		set_x0(m_tmp1);
		break;
		}
	case 609: { // y:[abs],x0
		set_x0(m_tmp1);
		break;
		}
	case 610: { // x:[abs],x1
		set_x1(m_tmp1);
		break;
		}
	case 611: { // y:[abs],x1
		set_x1(m_tmp1);
		break;
		}
	case 612: { // x:[abs],y0
		set_y0(m_tmp1);
		break;
		}
	case 613: { // y:[abs],y0
		set_y0(m_tmp1);
		break;
		}
	case 614: { // x:[abs],y1
		set_y1(m_tmp1);
		break;
		}
	case 615: { // y:[abs],y1
		set_y1(m_tmp1);
		break;
		}
	case 616: { // x:[abs],a0
		set_a0(m_tmp1);
		break;
		}
	case 617: { // y:[abs],a0
		set_a0(m_tmp1);
		break;
		}
	case 618: { // x:[abs],b0
		set_b0(m_tmp1);
		break;
		}
	case 619: { // y:[abs],b0
		set_b0(m_tmp1);
		break;
		}
	case 620: { // x:[abs],a2
		set_a2(m_tmp1);
		break;
		}
	case 621: { // y:[abs],a2
		set_a2(m_tmp1);
		break;
		}
	case 622: { // x:[abs],b2
		set_b2(m_tmp1);
		break;
		}
	case 623: { // y:[abs],b2
		set_b2(m_tmp1);
		break;
		}
	case 624: { // x:[abs],a1
		set_a1(m_tmp1);
		break;
		}
	case 625: { // y:[abs],a1
		set_a1(m_tmp1);
		break;
		}
	case 626: { // x:[abs],b1
		set_b1(m_tmp1);
		break;
		}
	case 627: { // y:[abs],b1
		set_b1(m_tmp1);
		break;
		}
	case 628: { // x:[abs],a
		set_ah(m_tmp1);
		break;
		}
	case 629: { // y:[abs],a
		set_ah(m_tmp1);
		break;
		}
	case 630: { // x:[abs],b
		set_bh(m_tmp1);
		break;
		}
	case 631: { // y:[abs],b
		set_bh(m_tmp1);
		break;
		}
	case 632: { // x:[abs],r
		set_r(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7, m_tmp1);
		break;
		}
	case 633: { // y:[abs],r
		set_r(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7, m_tmp1);
		break;
		}
	case 634: { // x:[abs],n
		set_n(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7, m_tmp1);
		break;
		}
	case 635: { // y:[abs],n
		set_n(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7, m_tmp1);
		break;
		}
	case 636: { // x0,x:[abs]
		u32 abs = exv;
		m_x.write_dword(abs, m_tmp1);
		break;
		}
	case 637: { // x0,y:[abs]
		u32 abs = exv;
		m_y.write_dword(abs, m_tmp1);
		break;
		}
	case 638: { // x1,x:[abs]
		u32 abs = exv;
		m_x.write_dword(abs, m_tmp1);
		break;
		}
	case 639: { // x1,y:[abs]
		u32 abs = exv;
		m_y.write_dword(abs, m_tmp1);
		break;
		}
	case 640: { // y0,x:[abs]
		u32 abs = exv;
		m_x.write_dword(abs, m_tmp1);
		break;
		}
	case 641: { // y0,y:[abs]
		u32 abs = exv;
		m_y.write_dword(abs, m_tmp1);
		break;
		}
	case 642: { // y1,x:[abs]
		u32 abs = exv;
		m_x.write_dword(abs, m_tmp1);
		break;
		}
	case 643: { // y1,y:[abs]
		u32 abs = exv;
		m_y.write_dword(abs, m_tmp1);
		break;
		}
	case 644: { // a0,x:[abs]
		u32 abs = exv;
		m_x.write_dword(abs, m_tmp1);
		break;
		}
	case 645: { // a0,y:[abs]
		u32 abs = exv;
		m_y.write_dword(abs, m_tmp1);
		break;
		}
	case 646: { // b0,x:[abs]
		u32 abs = exv;
		m_x.write_dword(abs, m_tmp1);
		break;
		}
	case 647: { // b0,y:[abs]
		u32 abs = exv;
		m_y.write_dword(abs, m_tmp1);
		break;
		}
	case 648: { // a2,x:[abs]
		u32 abs = exv;
		m_x.write_dword(abs, m_tmp1);
		break;
		}
	case 649: { // a2,y:[abs]
		u32 abs = exv;
		m_y.write_dword(abs, m_tmp1);
		break;
		}
	case 650: { // b2,x:[abs]
		u32 abs = exv;
		m_x.write_dword(abs, m_tmp1);
		break;
		}
	case 651: { // b2,y:[abs]
		u32 abs = exv;
		m_y.write_dword(abs, m_tmp1);
		break;
		}
	case 652: { // a1,x:[abs]
		u32 abs = exv;
		m_x.write_dword(abs, m_tmp1);
		break;
		}
	case 653: { // a1,y:[abs]
		u32 abs = exv;
		m_y.write_dword(abs, m_tmp1);
		break;
		}
	case 654: { // b1,x:[abs]
		u32 abs = exv;
		m_x.write_dword(abs, m_tmp1);
		break;
		}
	case 655: { // b1,y:[abs]
		u32 abs = exv;
		m_y.write_dword(abs, m_tmp1);
		break;
		}
	case 656: { // a,x:[abs]
		u32 abs = exv;
		m_x.write_dword(abs, m_tmp1);
		break;
		}
	case 657: { // a,y:[abs]
		u32 abs = exv;
		m_y.write_dword(abs, m_tmp1);
		break;
		}
	case 658: { // b,x:[abs]
		u32 abs = exv;
		m_x.write_dword(abs, m_tmp1);
		break;
		}
	case 659: { // b,y:[abs]
		u32 abs = exv;
		m_y.write_dword(abs, m_tmp1);
		break;
		}
	case 660: { // r,x:[abs]
		u32 abs = exv;
		m_x.write_dword(abs, m_tmp1);
		break;
		}
	case 661: { // r,y:[abs]
		u32 abs = exv;
		m_y.write_dword(abs, m_tmp1);
		break;
		}
	case 662: { // n,x:[abs]
		u32 abs = exv;
		m_x.write_dword(abs, m_tmp1);
		break;
		}
	case 663: { // n,y:[abs]
		u32 abs = exv;
		m_y.write_dword(abs, m_tmp1);
		break;
		}
	case 664: { // #[i],x0
		u32 i = exv;
		set_x0(i);
		break;
		}
	case 665: { // #[i],x1
		u32 i = exv;
		set_x1(i);
		break;
		}
	case 666: { // #[i],y0
		u32 i = exv;
		set_y0(i);
		break;
		}
	case 667: { // #[i],y1
		u32 i = exv;
		set_y1(i);
		break;
		}
	case 668: { // #[i],a0
		u32 i = exv;
		set_a0(i);
		break;
		}
	case 669: { // #[i],b0
		u32 i = exv;
		set_b0(i);
		break;
		}
	case 670: { // #[i],a2
		u32 i = exv;
		set_a2(i);
		break;
		}
	case 671: { // #[i],b2
		u32 i = exv;
		set_b2(i);
		break;
		}
	case 672: { // #[i],a1
		u32 i = exv;
		set_a1(i);
		break;
		}
	case 673: { // #[i],b1
		u32 i = exv;
		set_b1(i);
		break;
		}
	case 674: { // #[i],a
		u32 i = exv;
		set_ah(i);
		break;
		}
	case 675: { // #[i],b
		u32 i = exv;
		set_bh(i);
		break;
		}
	case 676: { // #[i],r
		u32 i = exv;
		set_r(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7, i);
		break;
		}
	case 677: { // #[i],n
		u32 i = exv;
		set_n(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7, i);
		break;
		}
	case 678: { // #[i],x0
		u32 i = exv;
		set_x0(i);
		break;
		}
	case 679: { // #[i],x1
		u32 i = exv;
		set_x1(i);
		break;
		}
	case 680: { // #[i],y0
		u32 i = exv;
		set_y0(i);
		break;
		}
	case 681: { // #[i],y1
		u32 i = exv;
		set_y1(i);
		break;
		}
	case 682: { // #[i],a0
		u32 i = exv;
		set_a0(i);
		break;
		}
	case 683: { // #[i],b0
		u32 i = exv;
		set_b0(i);
		break;
		}
	case 684: { // #[i],a2
		u32 i = exv;
		set_a2(i);
		break;
		}
	case 685: { // #[i],b2
		u32 i = exv;
		set_b2(i);
		break;
		}
	case 686: { // #[i],a1
		u32 i = exv;
		set_a1(i);
		break;
		}
	case 687: { // #[i],b1
		u32 i = exv;
		set_b1(i);
		break;
		}
	case 688: { // #[i],a
		u32 i = exv;
		set_ah(i);
		break;
		}
	case 689: { // #[i],b
		u32 i = exv;
		set_bh(i);
		break;
		}
	case 690: { // #[i],r
		u32 i = exv;
		set_r(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7, i);
		break;
		}
	case 691: { // #[i],n
		u32 i = exv;
		set_n(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7, i);
		break;
		}
	case 692: { // x:[aa],x0
		set_x0(m_tmp1);
		break;
		}
	case 693: { // y:[aa],x0
		set_x0(m_tmp1);
		break;
		}
	case 694: { // x:[aa],x1
		set_x1(m_tmp1);
		break;
		}
	case 695: { // y:[aa],x1
		set_x1(m_tmp1);
		break;
		}
	case 696: { // x:[aa],y0
		set_y0(m_tmp1);
		break;
		}
	case 697: { // y:[aa],y0
		set_y0(m_tmp1);
		break;
		}
	case 698: { // x:[aa],y1
		set_y1(m_tmp1);
		break;
		}
	case 699: { // y:[aa],y1
		set_y1(m_tmp1);
		break;
		}
	case 700: { // x:[aa],a0
		set_a0(m_tmp1);
		break;
		}
	case 701: { // y:[aa],a0
		set_a0(m_tmp1);
		break;
		}
	case 702: { // x:[aa],b0
		set_b0(m_tmp1);
		break;
		}
	case 703: { // y:[aa],b0
		set_b0(m_tmp1);
		break;
		}
	case 704: { // x:[aa],a2
		set_a2(m_tmp1);
		break;
		}
	case 705: { // y:[aa],a2
		set_a2(m_tmp1);
		break;
		}
	case 706: { // x:[aa],b2
		set_b2(m_tmp1);
		break;
		}
	case 707: { // y:[aa],b2
		set_b2(m_tmp1);
		break;
		}
	case 708: { // x:[aa],a1
		set_a1(m_tmp1);
		break;
		}
	case 709: { // y:[aa],a1
		set_a1(m_tmp1);
		break;
		}
	case 710: { // x:[aa],b1
		set_b1(m_tmp1);
		break;
		}
	case 711: { // y:[aa],b1
		set_b1(m_tmp1);
		break;
		}
	case 712: { // x:[aa],a
		set_ah(m_tmp1);
		break;
		}
	case 713: { // y:[aa],a
		set_ah(m_tmp1);
		break;
		}
	case 714: { // x:[aa],b
		set_bh(m_tmp1);
		break;
		}
	case 715: { // y:[aa],b
		set_bh(m_tmp1);
		break;
		}
	case 716: { // x:[aa],r
		set_r(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7, m_tmp1);
		break;
		}
	case 717: { // y:[aa],r
		set_r(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7, m_tmp1);
		break;
		}
	case 718: { // x:[aa],n
		set_n(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7, m_tmp1);
		break;
		}
	case 719: { // y:[aa],n
		set_n(bitswap<5>(opcode, 21, 20, 18, 17, 16) & 7, m_tmp1);
		break;
		}
	case 720: { // x0,x:[aa]
		u32 aa = BIT(opcode, 8, 6);
		m_x.write_dword(aa, m_tmp1);
		break;
		}
	case 721: { // x0,y:[aa]
		u32 aa = BIT(opcode, 8, 6);
		m_y.write_dword(aa, m_tmp1);
		break;
		}
	case 722: { // x1,x:[aa]
		u32 aa = BIT(opcode, 8, 6);
		m_x.write_dword(aa, m_tmp1);
		break;
		}
	case 723: { // x1,y:[aa]
		u32 aa = BIT(opcode, 8, 6);
		m_y.write_dword(aa, m_tmp1);
		break;
		}
	case 724: { // y0,x:[aa]
		u32 aa = BIT(opcode, 8, 6);
		m_x.write_dword(aa, m_tmp1);
		break;
		}
	case 725: { // y0,y:[aa]
		u32 aa = BIT(opcode, 8, 6);
		m_y.write_dword(aa, m_tmp1);
		break;
		}
	case 726: { // y1,x:[aa]
		u32 aa = BIT(opcode, 8, 6);
		m_x.write_dword(aa, m_tmp1);
		break;
		}
	case 727: { // y1,y:[aa]
		u32 aa = BIT(opcode, 8, 6);
		m_y.write_dword(aa, m_tmp1);
		break;
		}
	case 728: { // a0,x:[aa]
		u32 aa = BIT(opcode, 8, 6);
		m_x.write_dword(aa, m_tmp1);
		break;
		}
	case 729: { // a0,y:[aa]
		u32 aa = BIT(opcode, 8, 6);
		m_y.write_dword(aa, m_tmp1);
		break;
		}
	case 730: { // b0,x:[aa]
		u32 aa = BIT(opcode, 8, 6);
		m_x.write_dword(aa, m_tmp1);
		break;
		}
	case 731: { // b0,y:[aa]
		u32 aa = BIT(opcode, 8, 6);
		m_y.write_dword(aa, m_tmp1);
		break;
		}
	case 732: { // a2,x:[aa]
		u32 aa = BIT(opcode, 8, 6);
		m_x.write_dword(aa, m_tmp1);
		break;
		}
	case 733: { // a2,y:[aa]
		u32 aa = BIT(opcode, 8, 6);
		m_y.write_dword(aa, m_tmp1);
		break;
		}
	case 734: { // b2,x:[aa]
		u32 aa = BIT(opcode, 8, 6);
		m_x.write_dword(aa, m_tmp1);
		break;
		}
	case 735: { // b2,y:[aa]
		u32 aa = BIT(opcode, 8, 6);
		m_y.write_dword(aa, m_tmp1);
		break;
		}
	case 736: { // a1,x:[aa]
		u32 aa = BIT(opcode, 8, 6);
		m_x.write_dword(aa, m_tmp1);
		break;
		}
	case 737: { // a1,y:[aa]
		u32 aa = BIT(opcode, 8, 6);
		m_y.write_dword(aa, m_tmp1);
		break;
		}
	case 738: { // b1,x:[aa]
		u32 aa = BIT(opcode, 8, 6);
		m_x.write_dword(aa, m_tmp1);
		break;
		}
	case 739: { // b1,y:[aa]
		u32 aa = BIT(opcode, 8, 6);
		m_y.write_dword(aa, m_tmp1);
		break;
		}
	case 740: { // a,x:[aa]
		u32 aa = BIT(opcode, 8, 6);
		m_x.write_dword(aa, m_tmp1);
		break;
		}
	case 741: { // a,y:[aa]
		u32 aa = BIT(opcode, 8, 6);
		m_y.write_dword(aa, m_tmp1);
		break;
		}
	case 742: { // b,x:[aa]
		u32 aa = BIT(opcode, 8, 6);
		m_x.write_dword(aa, m_tmp1);
		break;
		}
	case 743: { // b,y:[aa]
		u32 aa = BIT(opcode, 8, 6);
		m_y.write_dword(aa, m_tmp1);
		break;
		}
	case 744: { // r,x:[aa]
		u32 aa = BIT(opcode, 8, 6);
		m_x.write_dword(aa, m_tmp1);
		break;
		}
	case 745: { // r,y:[aa]
		u32 aa = BIT(opcode, 8, 6);
		m_y.write_dword(aa, m_tmp1);
		break;
		}
	case 746: { // n,x:[aa]
		u32 aa = BIT(opcode, 8, 6);
		m_x.write_dword(aa, m_tmp1);
		break;
		}
	case 747: { // n,y:[aa]
		u32 aa = BIT(opcode, 8, 6);
		m_y.write_dword(aa, m_tmp1);
		break;
		}
	case 748: { // x:(r)-n,x0 a,y0
		set_x0(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 749: { // x:(r)+n,x0 a,y0
		set_x0(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 750: { // x:(r)-,x0 a,y0
		set_x0(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 751: { // x:(r)+,x0 a,y0
		set_x0(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 752: { // x:(r),x0 a,y0
		set_x0(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 753: { // x:(r+n),x0 a,y0
		set_x0(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 754: { // x:-(r),x0 a,y0
		set_x0(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 755: { // x:(r)-n,x0 a,y1
		set_x0(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 756: { // x:(r)+n,x0 a,y1
		set_x0(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 757: { // x:(r)-,x0 a,y1
		set_x0(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 758: { // x:(r)+,x0 a,y1
		set_x0(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 759: { // x:(r),x0 a,y1
		set_x0(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 760: { // x:(r+n),x0 a,y1
		set_x0(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 761: { // x:-(r),x0 a,y1
		set_x0(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 762: { // x:(r)-n,x0 b,y0
		set_x0(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 763: { // x:(r)+n,x0 b,y0
		set_x0(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 764: { // x:(r)-,x0 b,y0
		set_x0(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 765: { // x:(r)+,x0 b,y0
		set_x0(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 766: { // x:(r),x0 b,y0
		set_x0(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 767: { // x:(r+n),x0 b,y0
		set_x0(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 768: { // x:-(r),x0 b,y0
		set_x0(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 769: { // x:(r)-n,x0 b,y1
		set_x0(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 770: { // x:(r)+n,x0 b,y1
		set_x0(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 771: { // x:(r)-,x0 b,y1
		set_x0(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 772: { // x:(r)+,x0 b,y1
		set_x0(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 773: { // x:(r),x0 b,y1
		set_x0(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 774: { // x:(r+n),x0 b,y1
		set_x0(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 775: { // x:-(r),x0 b,y1
		set_x0(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 776: { // x:(r)-n,x1 a,y0
		set_x1(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 777: { // x:(r)+n,x1 a,y0
		set_x1(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 778: { // x:(r)-,x1 a,y0
		set_x1(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 779: { // x:(r)+,x1 a,y0
		set_x1(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 780: { // x:(r),x1 a,y0
		set_x1(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 781: { // x:(r+n),x1 a,y0
		set_x1(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 782: { // x:-(r),x1 a,y0
		set_x1(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 783: { // x:(r)-n,x1 a,y1
		set_x1(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 784: { // x:(r)+n,x1 a,y1
		set_x1(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 785: { // x:(r)-,x1 a,y1
		set_x1(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 786: { // x:(r)+,x1 a,y1
		set_x1(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 787: { // x:(r),x1 a,y1
		set_x1(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 788: { // x:(r+n),x1 a,y1
		set_x1(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 789: { // x:-(r),x1 a,y1
		set_x1(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 790: { // x:(r)-n,x1 b,y0
		set_x1(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 791: { // x:(r)+n,x1 b,y0
		set_x1(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 792: { // x:(r)-,x1 b,y0
		set_x1(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 793: { // x:(r)+,x1 b,y0
		set_x1(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 794: { // x:(r),x1 b,y0
		set_x1(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 795: { // x:(r+n),x1 b,y0
		set_x1(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 796: { // x:-(r),x1 b,y0
		set_x1(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 797: { // x:(r)-n,x1 b,y1
		set_x1(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 798: { // x:(r)+n,x1 b,y1
		set_x1(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 799: { // x:(r)-,x1 b,y1
		set_x1(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 800: { // x:(r)+,x1 b,y1
		set_x1(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 801: { // x:(r),x1 b,y1
		set_x1(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 802: { // x:(r+n),x1 b,y1
		set_x1(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 803: { // x:-(r),x1 b,y1
		set_x1(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 804: { // x:(r)-n,a a,y0
		set_ah(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 805: { // x:(r)+n,a a,y0
		set_ah(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 806: { // x:(r)-,a a,y0
		set_ah(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 807: { // x:(r)+,a a,y0
		set_ah(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 808: { // x:(r),a a,y0
		set_ah(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 809: { // x:(r+n),a a,y0
		set_ah(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 810: { // x:-(r),a a,y0
		set_ah(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 811: { // x:(r)-n,a a,y1
		set_ah(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 812: { // x:(r)+n,a a,y1
		set_ah(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 813: { // x:(r)-,a a,y1
		set_ah(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 814: { // x:(r)+,a a,y1
		set_ah(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 815: { // x:(r),a a,y1
		set_ah(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 816: { // x:(r+n),a a,y1
		set_ah(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 817: { // x:-(r),a a,y1
		set_ah(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 818: { // x:(r)-n,a b,y0
		set_ah(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 819: { // x:(r)+n,a b,y0
		set_ah(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 820: { // x:(r)-,a b,y0
		set_ah(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 821: { // x:(r)+,a b,y0
		set_ah(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 822: { // x:(r),a b,y0
		set_ah(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 823: { // x:(r+n),a b,y0
		set_ah(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 824: { // x:-(r),a b,y0
		set_ah(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 825: { // x:(r)-n,a b,y1
		set_ah(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 826: { // x:(r)+n,a b,y1
		set_ah(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 827: { // x:(r)-,a b,y1
		set_ah(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 828: { // x:(r)+,a b,y1
		set_ah(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 829: { // x:(r),a b,y1
		set_ah(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 830: { // x:(r+n),a b,y1
		set_ah(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 831: { // x:-(r),a b,y1
		set_ah(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 832: { // x:(r)-n,b a,y0
		set_bh(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 833: { // x:(r)+n,b a,y0
		set_bh(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 834: { // x:(r)-,b a,y0
		set_bh(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 835: { // x:(r)+,b a,y0
		set_bh(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 836: { // x:(r),b a,y0
		set_bh(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 837: { // x:(r+n),b a,y0
		set_bh(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 838: { // x:-(r),b a,y0
		set_bh(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 839: { // x:(r)-n,b a,y1
		set_bh(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 840: { // x:(r)+n,b a,y1
		set_bh(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 841: { // x:(r)-,b a,y1
		set_bh(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 842: { // x:(r)+,b a,y1
		set_bh(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 843: { // x:(r),b a,y1
		set_bh(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 844: { // x:(r+n),b a,y1
		set_bh(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 845: { // x:-(r),b a,y1
		set_bh(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 846: { // x:(r)-n,b b,y0
		set_bh(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 847: { // x:(r)+n,b b,y0
		set_bh(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 848: { // x:(r)-,b b,y0
		set_bh(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 849: { // x:(r)+,b b,y0
		set_bh(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 850: { // x:(r),b b,y0
		set_bh(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 851: { // x:(r+n),b b,y0
		set_bh(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 852: { // x:-(r),b b,y0
		set_bh(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 853: { // x:(r)-n,b b,y1
		set_bh(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 854: { // x:(r)+n,b b,y1
		set_bh(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 855: { // x:(r)-,b b,y1
		set_bh(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 856: { // x:(r)+,b b,y1
		set_bh(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 857: { // x:(r),b b,y1
		set_bh(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 858: { // x:(r+n),b b,y1
		set_bh(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 859: { // x:-(r),b b,y1
		set_bh(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 860: { // x0,x:(r)-n a,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 861: { // x0,x:(r)+n a,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 862: { // x0,x:(r)- a,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_x.write_dword(ea, m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 863: { // x0,x:(r)+ a,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_x.write_dword(ea, m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 864: { // x0,x:(r) a,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 865: { // x0,x:(r+n) a,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 866: { // x0,x:-(r) a,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 867: { // x0,x:(r)-n a,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 868: { // x0,x:(r)+n a,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 869: { // x0,x:(r)- a,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_x.write_dword(ea, m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 870: { // x0,x:(r)+ a,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_x.write_dword(ea, m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 871: { // x0,x:(r) a,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 872: { // x0,x:(r+n) a,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 873: { // x0,x:-(r) a,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 874: { // x0,x:(r)-n b,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 875: { // x0,x:(r)+n b,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 876: { // x0,x:(r)- b,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_x.write_dword(ea, m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 877: { // x0,x:(r)+ b,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_x.write_dword(ea, m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 878: { // x0,x:(r) b,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 879: { // x0,x:(r+n) b,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 880: { // x0,x:-(r) b,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 881: { // x0,x:(r)-n b,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 882: { // x0,x:(r)+n b,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 883: { // x0,x:(r)- b,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_x.write_dword(ea, m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 884: { // x0,x:(r)+ b,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_x.write_dword(ea, m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 885: { // x0,x:(r) b,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 886: { // x0,x:(r+n) b,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 887: { // x0,x:-(r) b,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 888: { // x1,x:(r)-n a,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 889: { // x1,x:(r)+n a,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 890: { // x1,x:(r)- a,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_x.write_dword(ea, m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 891: { // x1,x:(r)+ a,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_x.write_dword(ea, m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 892: { // x1,x:(r) a,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 893: { // x1,x:(r+n) a,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 894: { // x1,x:-(r) a,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 895: { // x1,x:(r)-n a,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 896: { // x1,x:(r)+n a,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 897: { // x1,x:(r)- a,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_x.write_dword(ea, m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 898: { // x1,x:(r)+ a,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_x.write_dword(ea, m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 899: { // x1,x:(r) a,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 900: { // x1,x:(r+n) a,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 901: { // x1,x:-(r) a,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 902: { // x1,x:(r)-n b,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 903: { // x1,x:(r)+n b,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 904: { // x1,x:(r)- b,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_x.write_dword(ea, m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 905: { // x1,x:(r)+ b,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_x.write_dword(ea, m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 906: { // x1,x:(r) b,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 907: { // x1,x:(r+n) b,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 908: { // x1,x:-(r) b,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 909: { // x1,x:(r)-n b,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 910: { // x1,x:(r)+n b,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 911: { // x1,x:(r)- b,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_x.write_dword(ea, m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 912: { // x1,x:(r)+ b,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_x.write_dword(ea, m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 913: { // x1,x:(r) b,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 914: { // x1,x:(r+n) b,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 915: { // x1,x:-(r) b,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 916: { // a,x:(r)-n a,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 917: { // a,x:(r)+n a,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 918: { // a,x:(r)- a,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_x.write_dword(ea, m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 919: { // a,x:(r)+ a,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_x.write_dword(ea, m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 920: { // a,x:(r) a,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 921: { // a,x:(r+n) a,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 922: { // a,x:-(r) a,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 923: { // a,x:(r)-n a,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 924: { // a,x:(r)+n a,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 925: { // a,x:(r)- a,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_x.write_dword(ea, m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 926: { // a,x:(r)+ a,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_x.write_dword(ea, m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 927: { // a,x:(r) a,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 928: { // a,x:(r+n) a,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 929: { // a,x:-(r) a,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 930: { // a,x:(r)-n b,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 931: { // a,x:(r)+n b,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 932: { // a,x:(r)- b,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_x.write_dword(ea, m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 933: { // a,x:(r)+ b,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_x.write_dword(ea, m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 934: { // a,x:(r) b,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 935: { // a,x:(r+n) b,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 936: { // a,x:-(r) b,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 937: { // a,x:(r)-n b,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 938: { // a,x:(r)+n b,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 939: { // a,x:(r)- b,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_x.write_dword(ea, m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 940: { // a,x:(r)+ b,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_x.write_dword(ea, m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 941: { // a,x:(r) b,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 942: { // a,x:(r+n) b,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 943: { // a,x:-(r) b,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 944: { // b,x:(r)-n a,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 945: { // b,x:(r)+n a,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 946: { // b,x:(r)- a,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_x.write_dword(ea, m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 947: { // b,x:(r)+ a,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_x.write_dword(ea, m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 948: { // b,x:(r) a,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 949: { // b,x:(r+n) a,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 950: { // b,x:-(r) a,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 951: { // b,x:(r)-n a,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 952: { // b,x:(r)+n a,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 953: { // b,x:(r)- a,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_x.write_dword(ea, m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 954: { // b,x:(r)+ a,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_x.write_dword(ea, m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 955: { // b,x:(r) a,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 956: { // b,x:(r+n) a,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 957: { // b,x:-(r) a,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 958: { // b,x:(r)-n b,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 959: { // b,x:(r)+n b,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 960: { // b,x:(r)- b,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_x.write_dword(ea, m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 961: { // b,x:(r)+ b,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_x.write_dword(ea, m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 962: { // b,x:(r) b,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 963: { // b,x:(r+n) b,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 964: { // b,x:-(r) b,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 965: { // b,x:(r)-n b,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 966: { // b,x:(r)+n b,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 967: { // b,x:(r)- b,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_x.write_dword(ea, m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 968: { // b,x:(r)+ b,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_x.write_dword(ea, m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 969: { // b,x:(r) b,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 970: { // b,x:(r+n) b,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 971: { // b,x:-(r) b,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 972: { // x:[abs],x0 a,y0
		set_x0(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 973: { // x:[abs],x0 a,y1
		set_x0(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 974: { // x:[abs],x0 b,y0
		set_x0(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 975: { // x:[abs],x0 b,y1
		set_x0(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 976: { // x:[abs],x1 a,y0
		set_x1(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 977: { // x:[abs],x1 a,y1
		set_x1(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 978: { // x:[abs],x1 b,y0
		set_x1(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 979: { // x:[abs],x1 b,y1
		set_x1(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 980: { // x:[abs],a a,y0
		set_ah(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 981: { // x:[abs],a a,y1
		set_ah(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 982: { // x:[abs],a b,y0
		set_ah(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 983: { // x:[abs],a b,y1
		set_ah(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 984: { // x:[abs],b a,y0
		set_bh(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 985: { // x:[abs],b a,y1
		set_bh(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 986: { // x:[abs],b b,y0
		set_bh(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 987: { // x:[abs],b b,y1
		set_bh(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 988: { // x0,x:[abs] a,y0
		u32 abs = exv;
		m_x.write_dword(abs, m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 989: { // x0,x:[abs] a,y1
		u32 abs = exv;
		m_x.write_dword(abs, m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 990: { // x0,x:[abs] b,y0
		u32 abs = exv;
		m_x.write_dword(abs, m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 991: { // x0,x:[abs] b,y1
		u32 abs = exv;
		m_x.write_dword(abs, m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 992: { // x1,x:[abs] a,y0
		u32 abs = exv;
		m_x.write_dword(abs, m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 993: { // x1,x:[abs] a,y1
		u32 abs = exv;
		m_x.write_dword(abs, m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 994: { // x1,x:[abs] b,y0
		u32 abs = exv;
		m_x.write_dword(abs, m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 995: { // x1,x:[abs] b,y1
		u32 abs = exv;
		m_x.write_dword(abs, m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 996: { // a,x:[abs] a,y0
		u32 abs = exv;
		m_x.write_dword(abs, m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 997: { // a,x:[abs] a,y1
		u32 abs = exv;
		m_x.write_dword(abs, m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 998: { // a,x:[abs] b,y0
		u32 abs = exv;
		m_x.write_dword(abs, m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 999: { // a,x:[abs] b,y1
		u32 abs = exv;
		m_x.write_dword(abs, m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 1000: { // b,x:[abs] a,y0
		u32 abs = exv;
		m_x.write_dword(abs, m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 1001: { // b,x:[abs] a,y1
		u32 abs = exv;
		m_x.write_dword(abs, m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 1002: { // b,x:[abs] b,y0
		u32 abs = exv;
		m_x.write_dword(abs, m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 1003: { // b,x:[abs] b,y1
		u32 abs = exv;
		m_x.write_dword(abs, m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 1004: { // #[i],x0 a,y0
		u32 i = exv;
		set_y0(m_tmp1);
		set_x0(i);
		break;
		}
	case 1005: { // #[i],x0 a,y1
		u32 i = exv;
		set_y1(m_tmp1);
		set_x0(i);
		break;
		}
	case 1006: { // #[i],x0 b,y0
		u32 i = exv;
		set_y0(m_tmp1);
		set_x0(i);
		break;
		}
	case 1007: { // #[i],x0 b,y1
		u32 i = exv;
		set_y1(m_tmp1);
		set_x0(i);
		break;
		}
	case 1008: { // #[i],x1 a,y0
		u32 i = exv;
		set_y0(m_tmp1);
		set_x1(i);
		break;
		}
	case 1009: { // #[i],x1 a,y1
		u32 i = exv;
		set_y1(m_tmp1);
		set_x1(i);
		break;
		}
	case 1010: { // #[i],x1 b,y0
		u32 i = exv;
		set_y0(m_tmp1);
		set_x1(i);
		break;
		}
	case 1011: { // #[i],x1 b,y1
		u32 i = exv;
		set_y1(m_tmp1);
		set_x1(i);
		break;
		}
	case 1012: { // #[i],a a,y0
		u32 i = exv;
		set_y0(m_tmp1);
		set_ah(i);
		break;
		}
	case 1013: { // #[i],a a,y1
		u32 i = exv;
		set_y1(m_tmp1);
		set_ah(i);
		break;
		}
	case 1014: { // #[i],a b,y0
		u32 i = exv;
		set_y0(m_tmp1);
		set_ah(i);
		break;
		}
	case 1015: { // #[i],a b,y1
		u32 i = exv;
		set_y1(m_tmp1);
		set_ah(i);
		break;
		}
	case 1016: { // #[i],b a,y0
		u32 i = exv;
		set_y0(m_tmp1);
		set_bh(i);
		break;
		}
	case 1017: { // #[i],b a,y1
		u32 i = exv;
		set_y1(m_tmp1);
		set_bh(i);
		break;
		}
	case 1018: { // #[i],b b,y0
		u32 i = exv;
		set_y0(m_tmp1);
		set_bh(i);
		break;
		}
	case 1019: { // #[i],b b,y1
		u32 i = exv;
		set_y1(m_tmp1);
		set_bh(i);
		break;
		}
	case 1020: { // a,x:(r)-n x0,a
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		set_ah(m_tmp2);
		break;
		}
	case 1021: { // a,x:(r)+n x0,a
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		set_ah(m_tmp2);
		break;
		}
	case 1022: { // a,x:(r)- x0,a
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_x.write_dword(ea, m_tmp1);
		set_ah(m_tmp2);
		break;
		}
	case 1023: { // a,x:(r)+ x0,a
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_x.write_dword(ea, m_tmp1);
		set_ah(m_tmp2);
		break;
		}
	case 1024: { // a,x:(r) x0,a
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		set_ah(m_tmp2);
		break;
		}
	case 1025: { // a,x:(r+n) x0,a
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		set_ah(m_tmp2);
		break;
		}
	case 1026: { // a,x:-(r) x0,a
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		set_ah(m_tmp2);
		break;
		}
	case 1027: { // b,x:(r)-n x0,b
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		set_bh(m_tmp2);
		break;
		}
	case 1028: { // b,x:(r)+n x0,b
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		set_bh(m_tmp2);
		break;
		}
	case 1029: { // b,x:(r)- x0,b
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_x.write_dword(ea, m_tmp1);
		set_bh(m_tmp2);
		break;
		}
	case 1030: { // b,x:(r)+ x0,b
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_x.write_dword(ea, m_tmp1);
		set_bh(m_tmp2);
		break;
		}
	case 1031: { // b,x:(r) x0,b
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		set_bh(m_tmp2);
		break;
		}
	case 1032: { // b,x:(r+n) x0,b
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		set_bh(m_tmp2);
		break;
		}
	case 1033: { // b,x:-(r) x0,b
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		set_bh(m_tmp2);
		break;
		}
	case 1034: { // a,x:[abs] x0,a
		u32 abs = exv;
		m_x.write_dword(abs, m_tmp1);
		set_ah(m_tmp2);
		break;
		}
	case 1035: { // b,x:[abs] x0,b
		u32 abs = exv;
		m_x.write_dword(abs, m_tmp1);
		set_bh(m_tmp2);
		break;
		}
	case 1036: { // a,x0 y:(r)-n,y0
		set_x0(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 1037: { // a,x0 y:(r)+n,y0
		set_x0(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 1038: { // a,x0 y:(r)-,y0
		set_x0(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 1039: { // a,x0 y:(r)+,y0
		set_x0(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 1040: { // a,x0 y:(r),y0
		set_x0(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 1041: { // a,x0 y:(r+n),y0
		set_x0(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 1042: { // a,x0 y:-(r),y0
		set_x0(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 1043: { // a,x1 y:(r)-n,y0
		set_x1(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 1044: { // a,x1 y:(r)+n,y0
		set_x1(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 1045: { // a,x1 y:(r)-,y0
		set_x1(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 1046: { // a,x1 y:(r)+,y0
		set_x1(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 1047: { // a,x1 y:(r),y0
		set_x1(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 1048: { // a,x1 y:(r+n),y0
		set_x1(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 1049: { // a,x1 y:-(r),y0
		set_x1(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 1050: { // b,x0 y:(r)-n,y0
		set_x0(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 1051: { // b,x0 y:(r)+n,y0
		set_x0(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 1052: { // b,x0 y:(r)-,y0
		set_x0(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 1053: { // b,x0 y:(r)+,y0
		set_x0(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 1054: { // b,x0 y:(r),y0
		set_x0(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 1055: { // b,x0 y:(r+n),y0
		set_x0(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 1056: { // b,x0 y:-(r),y0
		set_x0(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 1057: { // b,x1 y:(r)-n,y0
		set_x1(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 1058: { // b,x1 y:(r)+n,y0
		set_x1(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 1059: { // b,x1 y:(r)-,y0
		set_x1(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 1060: { // b,x1 y:(r)+,y0
		set_x1(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 1061: { // b,x1 y:(r),y0
		set_x1(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 1062: { // b,x1 y:(r+n),y0
		set_x1(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 1063: { // b,x1 y:-(r),y0
		set_x1(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 1064: { // a,x0 y:(r)-n,y1
		set_x0(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 1065: { // a,x0 y:(r)+n,y1
		set_x0(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 1066: { // a,x0 y:(r)-,y1
		set_x0(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 1067: { // a,x0 y:(r)+,y1
		set_x0(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 1068: { // a,x0 y:(r),y1
		set_x0(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 1069: { // a,x0 y:(r+n),y1
		set_x0(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 1070: { // a,x0 y:-(r),y1
		set_x0(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 1071: { // a,x1 y:(r)-n,y1
		set_x1(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 1072: { // a,x1 y:(r)+n,y1
		set_x1(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 1073: { // a,x1 y:(r)-,y1
		set_x1(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 1074: { // a,x1 y:(r)+,y1
		set_x1(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 1075: { // a,x1 y:(r),y1
		set_x1(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 1076: { // a,x1 y:(r+n),y1
		set_x1(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 1077: { // a,x1 y:-(r),y1
		set_x1(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 1078: { // b,x0 y:(r)-n,y1
		set_x0(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 1079: { // b,x0 y:(r)+n,y1
		set_x0(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 1080: { // b,x0 y:(r)-,y1
		set_x0(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 1081: { // b,x0 y:(r)+,y1
		set_x0(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 1082: { // b,x0 y:(r),y1
		set_x0(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 1083: { // b,x0 y:(r+n),y1
		set_x0(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 1084: { // b,x0 y:-(r),y1
		set_x0(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 1085: { // b,x1 y:(r)-n,y1
		set_x1(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 1086: { // b,x1 y:(r)+n,y1
		set_x1(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 1087: { // b,x1 y:(r)-,y1
		set_x1(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 1088: { // b,x1 y:(r)+,y1
		set_x1(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 1089: { // b,x1 y:(r),y1
		set_x1(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 1090: { // b,x1 y:(r+n),y1
		set_x1(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 1091: { // b,x1 y:-(r),y1
		set_x1(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 1092: { // a,x0 y:(r)-n,a
		set_x0(m_tmp1);
		set_ah(m_tmp2);
		break;
		}
	case 1093: { // a,x0 y:(r)+n,a
		set_x0(m_tmp1);
		set_ah(m_tmp2);
		break;
		}
	case 1094: { // a,x0 y:(r)-,a
		set_x0(m_tmp1);
		set_ah(m_tmp2);
		break;
		}
	case 1095: { // a,x0 y:(r)+,a
		set_x0(m_tmp1);
		set_ah(m_tmp2);
		break;
		}
	case 1096: { // a,x0 y:(r),a
		set_x0(m_tmp1);
		set_ah(m_tmp2);
		break;
		}
	case 1097: { // a,x0 y:(r+n),a
		set_x0(m_tmp1);
		set_ah(m_tmp2);
		break;
		}
	case 1098: { // a,x0 y:-(r),a
		set_x0(m_tmp1);
		set_ah(m_tmp2);
		break;
		}
	case 1099: { // a,x1 y:(r)-n,a
		set_x1(m_tmp1);
		set_ah(m_tmp2);
		break;
		}
	case 1100: { // a,x1 y:(r)+n,a
		set_x1(m_tmp1);
		set_ah(m_tmp2);
		break;
		}
	case 1101: { // a,x1 y:(r)-,a
		set_x1(m_tmp1);
		set_ah(m_tmp2);
		break;
		}
	case 1102: { // a,x1 y:(r)+,a
		set_x1(m_tmp1);
		set_ah(m_tmp2);
		break;
		}
	case 1103: { // a,x1 y:(r),a
		set_x1(m_tmp1);
		set_ah(m_tmp2);
		break;
		}
	case 1104: { // a,x1 y:(r+n),a
		set_x1(m_tmp1);
		set_ah(m_tmp2);
		break;
		}
	case 1105: { // a,x1 y:-(r),a
		set_x1(m_tmp1);
		set_ah(m_tmp2);
		break;
		}
	case 1106: { // b,x0 y:(r)-n,a
		set_x0(m_tmp1);
		set_ah(m_tmp2);
		break;
		}
	case 1107: { // b,x0 y:(r)+n,a
		set_x0(m_tmp1);
		set_ah(m_tmp2);
		break;
		}
	case 1108: { // b,x0 y:(r)-,a
		set_x0(m_tmp1);
		set_ah(m_tmp2);
		break;
		}
	case 1109: { // b,x0 y:(r)+,a
		set_x0(m_tmp1);
		set_ah(m_tmp2);
		break;
		}
	case 1110: { // b,x0 y:(r),a
		set_x0(m_tmp1);
		set_ah(m_tmp2);
		break;
		}
	case 1111: { // b,x0 y:(r+n),a
		set_x0(m_tmp1);
		set_ah(m_tmp2);
		break;
		}
	case 1112: { // b,x0 y:-(r),a
		set_x0(m_tmp1);
		set_ah(m_tmp2);
		break;
		}
	case 1113: { // b,x1 y:(r)-n,a
		set_x1(m_tmp1);
		set_ah(m_tmp2);
		break;
		}
	case 1114: { // b,x1 y:(r)+n,a
		set_x1(m_tmp1);
		set_ah(m_tmp2);
		break;
		}
	case 1115: { // b,x1 y:(r)-,a
		set_x1(m_tmp1);
		set_ah(m_tmp2);
		break;
		}
	case 1116: { // b,x1 y:(r)+,a
		set_x1(m_tmp1);
		set_ah(m_tmp2);
		break;
		}
	case 1117: { // b,x1 y:(r),a
		set_x1(m_tmp1);
		set_ah(m_tmp2);
		break;
		}
	case 1118: { // b,x1 y:(r+n),a
		set_x1(m_tmp1);
		set_ah(m_tmp2);
		break;
		}
	case 1119: { // b,x1 y:-(r),a
		set_x1(m_tmp1);
		set_ah(m_tmp2);
		break;
		}
	case 1120: { // a,x0 y:(r)-n,b
		set_x0(m_tmp1);
		set_bh(m_tmp2);
		break;
		}
	case 1121: { // a,x0 y:(r)+n,b
		set_x0(m_tmp1);
		set_bh(m_tmp2);
		break;
		}
	case 1122: { // a,x0 y:(r)-,b
		set_x0(m_tmp1);
		set_bh(m_tmp2);
		break;
		}
	case 1123: { // a,x0 y:(r)+,b
		set_x0(m_tmp1);
		set_bh(m_tmp2);
		break;
		}
	case 1124: { // a,x0 y:(r),b
		set_x0(m_tmp1);
		set_bh(m_tmp2);
		break;
		}
	case 1125: { // a,x0 y:(r+n),b
		set_x0(m_tmp1);
		set_bh(m_tmp2);
		break;
		}
	case 1126: { // a,x0 y:-(r),b
		set_x0(m_tmp1);
		set_bh(m_tmp2);
		break;
		}
	case 1127: { // a,x1 y:(r)-n,b
		set_x1(m_tmp1);
		set_bh(m_tmp2);
		break;
		}
	case 1128: { // a,x1 y:(r)+n,b
		set_x1(m_tmp1);
		set_bh(m_tmp2);
		break;
		}
	case 1129: { // a,x1 y:(r)-,b
		set_x1(m_tmp1);
		set_bh(m_tmp2);
		break;
		}
	case 1130: { // a,x1 y:(r)+,b
		set_x1(m_tmp1);
		set_bh(m_tmp2);
		break;
		}
	case 1131: { // a,x1 y:(r),b
		set_x1(m_tmp1);
		set_bh(m_tmp2);
		break;
		}
	case 1132: { // a,x1 y:(r+n),b
		set_x1(m_tmp1);
		set_bh(m_tmp2);
		break;
		}
	case 1133: { // a,x1 y:-(r),b
		set_x1(m_tmp1);
		set_bh(m_tmp2);
		break;
		}
	case 1134: { // b,x0 y:(r)-n,b
		set_x0(m_tmp1);
		set_bh(m_tmp2);
		break;
		}
	case 1135: { // b,x0 y:(r)+n,b
		set_x0(m_tmp1);
		set_bh(m_tmp2);
		break;
		}
	case 1136: { // b,x0 y:(r)-,b
		set_x0(m_tmp1);
		set_bh(m_tmp2);
		break;
		}
	case 1137: { // b,x0 y:(r)+,b
		set_x0(m_tmp1);
		set_bh(m_tmp2);
		break;
		}
	case 1138: { // b,x0 y:(r),b
		set_x0(m_tmp1);
		set_bh(m_tmp2);
		break;
		}
	case 1139: { // b,x0 y:(r+n),b
		set_x0(m_tmp1);
		set_bh(m_tmp2);
		break;
		}
	case 1140: { // b,x0 y:-(r),b
		set_x0(m_tmp1);
		set_bh(m_tmp2);
		break;
		}
	case 1141: { // b,x1 y:(r)-n,b
		set_x1(m_tmp1);
		set_bh(m_tmp2);
		break;
		}
	case 1142: { // b,x1 y:(r)+n,b
		set_x1(m_tmp1);
		set_bh(m_tmp2);
		break;
		}
	case 1143: { // b,x1 y:(r)-,b
		set_x1(m_tmp1);
		set_bh(m_tmp2);
		break;
		}
	case 1144: { // b,x1 y:(r)+,b
		set_x1(m_tmp1);
		set_bh(m_tmp2);
		break;
		}
	case 1145: { // b,x1 y:(r),b
		set_x1(m_tmp1);
		set_bh(m_tmp2);
		break;
		}
	case 1146: { // b,x1 y:(r+n),b
		set_x1(m_tmp1);
		set_bh(m_tmp2);
		break;
		}
	case 1147: { // b,x1 y:-(r),b
		set_x1(m_tmp1);
		set_bh(m_tmp2);
		break;
		}
	case 1148: { // a,x0 y0,y:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_x0(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1149: { // a,x0 y0,y:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_x0(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1150: { // a,x0 y0,y:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_x0(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1151: { // a,x0 y0,y:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_x0(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1152: { // a,x0 y0,y:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_x0(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1153: { // a,x0 y0,y:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_x0(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1154: { // a,x0 y0,y:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_x0(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1155: { // a,x1 y0,y:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_x1(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1156: { // a,x1 y0,y:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_x1(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1157: { // a,x1 y0,y:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_x1(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1158: { // a,x1 y0,y:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_x1(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1159: { // a,x1 y0,y:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_x1(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1160: { // a,x1 y0,y:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_x1(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1161: { // a,x1 y0,y:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_x1(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1162: { // b,x0 y0,y:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_x0(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1163: { // b,x0 y0,y:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_x0(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1164: { // b,x0 y0,y:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_x0(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1165: { // b,x0 y0,y:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_x0(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1166: { // b,x0 y0,y:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_x0(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1167: { // b,x0 y0,y:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_x0(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1168: { // b,x0 y0,y:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_x0(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1169: { // b,x1 y0,y:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_x1(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1170: { // b,x1 y0,y:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_x1(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1171: { // b,x1 y0,y:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_x1(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1172: { // b,x1 y0,y:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_x1(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1173: { // b,x1 y0,y:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_x1(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1174: { // b,x1 y0,y:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_x1(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1175: { // b,x1 y0,y:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_x1(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1176: { // a,x0 y1,y:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_x0(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1177: { // a,x0 y1,y:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_x0(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1178: { // a,x0 y1,y:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_x0(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1179: { // a,x0 y1,y:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_x0(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1180: { // a,x0 y1,y:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_x0(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1181: { // a,x0 y1,y:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_x0(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1182: { // a,x0 y1,y:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_x0(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1183: { // a,x1 y1,y:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_x1(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1184: { // a,x1 y1,y:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_x1(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1185: { // a,x1 y1,y:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_x1(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1186: { // a,x1 y1,y:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_x1(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1187: { // a,x1 y1,y:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_x1(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1188: { // a,x1 y1,y:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_x1(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1189: { // a,x1 y1,y:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_x1(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1190: { // b,x0 y1,y:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_x0(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1191: { // b,x0 y1,y:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_x0(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1192: { // b,x0 y1,y:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_x0(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1193: { // b,x0 y1,y:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_x0(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1194: { // b,x0 y1,y:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_x0(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1195: { // b,x0 y1,y:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_x0(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1196: { // b,x0 y1,y:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_x0(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1197: { // b,x1 y1,y:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_x1(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1198: { // b,x1 y1,y:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_x1(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1199: { // b,x1 y1,y:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_x1(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1200: { // b,x1 y1,y:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_x1(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1201: { // b,x1 y1,y:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_x1(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1202: { // b,x1 y1,y:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_x1(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1203: { // b,x1 y1,y:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_x1(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1204: { // a,x0 a,y:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_x0(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1205: { // a,x0 a,y:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_x0(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1206: { // a,x0 a,y:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_x0(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1207: { // a,x0 a,y:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_x0(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1208: { // a,x0 a,y:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_x0(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1209: { // a,x0 a,y:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_x0(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1210: { // a,x0 a,y:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_x0(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1211: { // a,x1 a,y:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_x1(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1212: { // a,x1 a,y:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_x1(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1213: { // a,x1 a,y:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_x1(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1214: { // a,x1 a,y:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_x1(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1215: { // a,x1 a,y:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_x1(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1216: { // a,x1 a,y:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_x1(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1217: { // a,x1 a,y:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_x1(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1218: { // b,x0 a,y:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_x0(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1219: { // b,x0 a,y:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_x0(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1220: { // b,x0 a,y:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_x0(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1221: { // b,x0 a,y:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_x0(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1222: { // b,x0 a,y:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_x0(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1223: { // b,x0 a,y:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_x0(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1224: { // b,x0 a,y:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_x0(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1225: { // b,x1 a,y:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_x1(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1226: { // b,x1 a,y:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_x1(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1227: { // b,x1 a,y:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_x1(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1228: { // b,x1 a,y:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_x1(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1229: { // b,x1 a,y:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_x1(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1230: { // b,x1 a,y:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_x1(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1231: { // b,x1 a,y:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_x1(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1232: { // a,x0 b,y:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_x0(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1233: { // a,x0 b,y:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_x0(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1234: { // a,x0 b,y:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_x0(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1235: { // a,x0 b,y:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_x0(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1236: { // a,x0 b,y:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_x0(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1237: { // a,x0 b,y:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_x0(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1238: { // a,x0 b,y:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_x0(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1239: { // a,x1 b,y:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_x1(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1240: { // a,x1 b,y:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_x1(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1241: { // a,x1 b,y:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_x1(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1242: { // a,x1 b,y:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_x1(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1243: { // a,x1 b,y:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_x1(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1244: { // a,x1 b,y:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_x1(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1245: { // a,x1 b,y:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_x1(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1246: { // b,x0 b,y:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_x0(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1247: { // b,x0 b,y:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_x0(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1248: { // b,x0 b,y:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_x0(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1249: { // b,x0 b,y:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_x0(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1250: { // b,x0 b,y:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_x0(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1251: { // b,x0 b,y:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_x0(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1252: { // b,x0 b,y:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_x0(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1253: { // b,x1 b,y:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_x1(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1254: { // b,x1 b,y:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_x1(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1255: { // b,x1 b,y:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_x1(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1256: { // b,x1 b,y:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_x1(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1257: { // b,x1 b,y:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_x1(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1258: { // b,x1 b,y:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_x1(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1259: { // b,x1 b,y:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_x1(m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1260: { // a,x0 y:[abs],y0
		set_x0(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 1261: { // a,x1 y:[abs],y0
		set_x1(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 1262: { // b,x0 y:[abs],y0
		set_x0(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 1263: { // b,x1 y:[abs],y0
		set_x1(m_tmp1);
		set_y0(m_tmp2);
		break;
		}
	case 1264: { // a,x0 y:[abs],y1
		set_x0(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 1265: { // a,x1 y:[abs],y1
		set_x1(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 1266: { // b,x0 y:[abs],y1
		set_x0(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 1267: { // b,x1 y:[abs],y1
		set_x1(m_tmp1);
		set_y1(m_tmp2);
		break;
		}
	case 1268: { // a,x0 y:[abs],a
		set_x0(m_tmp1);
		set_ah(m_tmp2);
		break;
		}
	case 1269: { // a,x1 y:[abs],a
		set_x1(m_tmp1);
		set_ah(m_tmp2);
		break;
		}
	case 1270: { // b,x0 y:[abs],a
		set_x0(m_tmp1);
		set_ah(m_tmp2);
		break;
		}
	case 1271: { // b,x1 y:[abs],a
		set_x1(m_tmp1);
		set_ah(m_tmp2);
		break;
		}
	case 1272: { // a,x0 y:[abs],b
		set_x0(m_tmp1);
		set_bh(m_tmp2);
		break;
		}
	case 1273: { // a,x1 y:[abs],b
		set_x1(m_tmp1);
		set_bh(m_tmp2);
		break;
		}
	case 1274: { // b,x0 y:[abs],b
		set_x0(m_tmp1);
		set_bh(m_tmp2);
		break;
		}
	case 1275: { // b,x1 y:[abs],b
		set_x1(m_tmp1);
		set_bh(m_tmp2);
		break;
		}
	case 1276: { // a,x0 y0,y:[abs]
		u32 abs = exv;
		set_x0(m_tmp1);
		m_y.write_dword(abs, m_tmp2);
		break;
		}
	case 1277: { // a,x1 y0,y:[abs]
		u32 abs = exv;
		set_x1(m_tmp1);
		m_y.write_dword(abs, m_tmp2);
		break;
		}
	case 1278: { // b,x0 y0,y:[abs]
		u32 abs = exv;
		set_x0(m_tmp1);
		m_y.write_dword(abs, m_tmp2);
		break;
		}
	case 1279: { // b,x1 y0,y:[abs]
		u32 abs = exv;
		set_x1(m_tmp1);
		m_y.write_dword(abs, m_tmp2);
		break;
		}
	case 1280: { // a,x0 y1,y:[abs]
		u32 abs = exv;
		set_x0(m_tmp1);
		m_y.write_dword(abs, m_tmp2);
		break;
		}
	case 1281: { // a,x1 y1,y:[abs]
		u32 abs = exv;
		set_x1(m_tmp1);
		m_y.write_dword(abs, m_tmp2);
		break;
		}
	case 1282: { // b,x0 y1,y:[abs]
		u32 abs = exv;
		set_x0(m_tmp1);
		m_y.write_dword(abs, m_tmp2);
		break;
		}
	case 1283: { // b,x1 y1,y:[abs]
		u32 abs = exv;
		set_x1(m_tmp1);
		m_y.write_dword(abs, m_tmp2);
		break;
		}
	case 1284: { // a,x0 a,y:[abs]
		u32 abs = exv;
		set_x0(m_tmp1);
		m_y.write_dword(abs, m_tmp2);
		break;
		}
	case 1285: { // a,x1 a,y:[abs]
		u32 abs = exv;
		set_x1(m_tmp1);
		m_y.write_dword(abs, m_tmp2);
		break;
		}
	case 1286: { // b,x0 a,y:[abs]
		u32 abs = exv;
		set_x0(m_tmp1);
		m_y.write_dword(abs, m_tmp2);
		break;
		}
	case 1287: { // b,x1 a,y:[abs]
		u32 abs = exv;
		set_x1(m_tmp1);
		m_y.write_dword(abs, m_tmp2);
		break;
		}
	case 1288: { // a,x0 b,y:[abs]
		u32 abs = exv;
		set_x0(m_tmp1);
		m_y.write_dword(abs, m_tmp2);
		break;
		}
	case 1289: { // a,x1 b,y:[abs]
		u32 abs = exv;
		set_x1(m_tmp1);
		m_y.write_dword(abs, m_tmp2);
		break;
		}
	case 1290: { // b,x0 b,y:[abs]
		u32 abs = exv;
		set_x0(m_tmp1);
		m_y.write_dword(abs, m_tmp2);
		break;
		}
	case 1291: { // b,x1 b,y:[abs]
		u32 abs = exv;
		set_x1(m_tmp1);
		m_y.write_dword(abs, m_tmp2);
		break;
		}
	case 1292: { // a,x0 #[i],y0
		u32 i = exv;
		set_x0(m_tmp1);
		set_y0(i);
		break;
		}
	case 1293: { // a,x1 #[i],y0
		u32 i = exv;
		set_x1(m_tmp1);
		set_y0(i);
		break;
		}
	case 1294: { // b,x0 #[i],y0
		u32 i = exv;
		set_x0(m_tmp1);
		set_y0(i);
		break;
		}
	case 1295: { // b,x1 #[i],y0
		u32 i = exv;
		set_x1(m_tmp1);
		set_y0(i);
		break;
		}
	case 1296: { // a,x0 #[i],y1
		u32 i = exv;
		set_x0(m_tmp1);
		set_y1(i);
		break;
		}
	case 1297: { // a,x1 #[i],y1
		u32 i = exv;
		set_x1(m_tmp1);
		set_y1(i);
		break;
		}
	case 1298: { // b,x0 #[i],y1
		u32 i = exv;
		set_x0(m_tmp1);
		set_y1(i);
		break;
		}
	case 1299: { // b,x1 #[i],y1
		u32 i = exv;
		set_x1(m_tmp1);
		set_y1(i);
		break;
		}
	case 1300: { // a,x0 #[i],a
		u32 i = exv;
		set_x0(m_tmp1);
		set_ah(i);
		break;
		}
	case 1301: { // a,x1 #[i],a
		u32 i = exv;
		set_x1(m_tmp1);
		set_ah(i);
		break;
		}
	case 1302: { // b,x0 #[i],a
		u32 i = exv;
		set_x0(m_tmp1);
		set_ah(i);
		break;
		}
	case 1303: { // b,x1 #[i],a
		u32 i = exv;
		set_x1(m_tmp1);
		set_ah(i);
		break;
		}
	case 1304: { // a,x0 #[i],b
		u32 i = exv;
		set_x0(m_tmp1);
		set_bh(i);
		break;
		}
	case 1305: { // a,x1 #[i],b
		u32 i = exv;
		set_x1(m_tmp1);
		set_bh(i);
		break;
		}
	case 1306: { // b,x0 #[i],b
		u32 i = exv;
		set_x0(m_tmp1);
		set_bh(i);
		break;
		}
	case 1307: { // b,x1 #[i],b
		u32 i = exv;
		set_x1(m_tmp1);
		set_bh(i);
		break;
		}
	case 1308: { // a,y:(r)-n y0,a
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_y.write_dword(ea, m_tmp1);
		set_ah(m_tmp2);
		break;
		}
	case 1309: { // a,y:(r)+n y0,a
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_y.write_dword(ea, m_tmp1);
		set_ah(m_tmp2);
		break;
		}
	case 1310: { // a,y:(r)- y0,a
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_y.write_dword(ea, m_tmp1);
		set_ah(m_tmp2);
		break;
		}
	case 1311: { // a,y:(r)+ y0,a
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_y.write_dword(ea, m_tmp1);
		set_ah(m_tmp2);
		break;
		}
	case 1312: { // a,y:(r) y0,a
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_y.write_dword(ea, m_tmp1);
		set_ah(m_tmp2);
		break;
		}
	case 1313: { // a,y:(r+n) y0,a
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_y.write_dword(ea, m_tmp1);
		set_ah(m_tmp2);
		break;
		}
	case 1314: { // a,y:-(r) y0,a
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_y.write_dword(ea, m_tmp1);
		set_ah(m_tmp2);
		break;
		}
	case 1315: { // b,y:(r)-n y0,b
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_y.write_dword(ea, m_tmp1);
		set_bh(m_tmp2);
		break;
		}
	case 1316: { // b,y:(r)+n y0,b
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_y.write_dword(ea, m_tmp1);
		set_bh(m_tmp2);
		break;
		}
	case 1317: { // b,y:(r)- y0,b
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_y.write_dword(ea, m_tmp1);
		set_bh(m_tmp2);
		break;
		}
	case 1318: { // b,y:(r)+ y0,b
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_y.write_dword(ea, m_tmp1);
		set_bh(m_tmp2);
		break;
		}
	case 1319: { // b,y:(r) y0,b
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_y.write_dword(ea, m_tmp1);
		set_bh(m_tmp2);
		break;
		}
	case 1320: { // b,y:(r+n) y0,b
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_y.write_dword(ea, m_tmp1);
		set_bh(m_tmp2);
		break;
		}
	case 1321: { // b,y:-(r) y0,b
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_y.write_dword(ea, m_tmp1);
		set_bh(m_tmp2);
		break;
		}
	case 1322: { // a,y:[abs] y0,a
		u32 abs = exv;
		m_y.write_dword(abs, m_tmp1);
		set_ah(m_tmp2);
		break;
		}
	case 1323: { // b,y:[abs] y0,b
		u32 abs = exv;
		m_y.write_dword(abs, m_tmp1);
		set_bh(m_tmp2);
		break;
		}
	case 1324: { // l:(r)-n,a10
		set_a10(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1325: { // l:(r)+n,a10
		set_a10(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1326: { // l:(r)-,a10
		set_a10(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1327: { // l:(r)+,a10
		set_a10(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1328: { // l:(r),a10
		set_a10(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1329: { // l:(r+n),a10
		set_a10(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1330: { // l:-(r),a10
		set_a10(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1331: { // l:(r)-n,b10
		set_b10(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1332: { // l:(r)+n,b10
		set_b10(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1333: { // l:(r)-,b10
		set_b10(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1334: { // l:(r)+,b10
		set_b10(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1335: { // l:(r),b10
		set_b10(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1336: { // l:(r+n),b10
		set_b10(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1337: { // l:-(r),b10
		set_b10(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1338: { // l:(r)-n,x
		set_x(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1339: { // l:(r)+n,x
		set_x(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1340: { // l:(r)-,x
		set_x(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1341: { // l:(r)+,x
		set_x(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1342: { // l:(r),x
		set_x(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1343: { // l:(r+n),x
		set_x(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1344: { // l:-(r),x
		set_x(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1345: { // l:(r)-n,y
		set_y(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1346: { // l:(r)+n,y
		set_y(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1347: { // l:(r)-,y
		set_y(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1348: { // l:(r)+,y
		set_y(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1349: { // l:(r),y
		set_y(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1350: { // l:(r+n),y
		set_y(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1351: { // l:-(r),y
		set_y(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1352: { // l:(r)-n,a
		set_al(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1353: { // l:(r)+n,a
		set_al(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1354: { // l:(r)-,a
		set_al(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1355: { // l:(r)+,a
		set_al(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1356: { // l:(r),a
		set_al(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1357: { // l:(r+n),a
		set_al(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1358: { // l:-(r),a
		set_al(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1359: { // l:(r)-n,b
		set_bl(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1360: { // l:(r)+n,b
		set_bl(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1361: { // l:(r)-,b
		set_bl(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1362: { // l:(r)+,b
		set_bl(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1363: { // l:(r),b
		set_bl(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1364: { // l:(r+n),b
		set_bl(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1365: { // l:-(r),b
		set_bl(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1366: { // l:(r)-n,ab
		set_ab(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1367: { // l:(r)+n,ab
		set_ab(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1368: { // l:(r)-,ab
		set_ab(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1369: { // l:(r)+,ab
		set_ab(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1370: { // l:(r),ab
		set_ab(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1371: { // l:(r+n),ab
		set_ab(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1372: { // l:-(r),ab
		set_ab(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1373: { // l:(r)-n,ba
		set_ba(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1374: { // l:(r)+n,ba
		set_ba(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1375: { // l:(r)-,ba
		set_ba(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1376: { // l:(r)+,ba
		set_ba(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1377: { // l:(r),ba
		set_ba(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1378: { // l:(r+n),ba
		set_ba(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1379: { // l:-(r),ba
		set_ba(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1380: { // l:[abs],a10
		set_a10(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1381: { // l:[abs],b10
		set_b10(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1382: { // l:[abs],x
		set_x(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1383: { // l:[abs],y
		set_y(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1384: { // l:[abs],a
		set_al(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1385: { // l:[abs],b
		set_bl(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1386: { // l:[abs],ab
		set_ab(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1387: { // l:[abs],ba
		set_ba(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1388: { // l:[aa],a10
		set_a10(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1389: { // l:[aa],b10
		set_b10(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1390: { // l:[aa],x
		set_x(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1391: { // l:[aa],y
		set_y(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1392: { // l:[aa],a
		set_al(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1393: { // l:[aa],b
		set_bl(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1394: { // l:[aa],ab
		set_ab(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1395: { // l:[aa],ba
		set_ba(m_tmp1 << 24 | m_tmp2);
		break;
		}
	case 1396: { // a10,l:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1397: { // a10,l:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1398: { // a10,l:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_x.write_dword(ea, m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1399: { // a10,l:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_x.write_dword(ea, m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1400: { // a10,l:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1401: { // a10,l:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1402: { // a10,l:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1403: { // b10,l:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1404: { // b10,l:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1405: { // b10,l:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_x.write_dword(ea, m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1406: { // b10,l:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_x.write_dword(ea, m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1407: { // b10,l:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1408: { // b10,l:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1409: { // b10,l:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1410: { // x,l:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1411: { // x,l:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1412: { // x,l:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_x.write_dword(ea, m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1413: { // x,l:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_x.write_dword(ea, m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1414: { // x,l:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1415: { // x,l:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1416: { // x,l:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1417: { // y,l:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1418: { // y,l:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1419: { // y,l:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_x.write_dword(ea, m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1420: { // y,l:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_x.write_dword(ea, m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1421: { // y,l:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1422: { // y,l:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1423: { // y,l:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1424: { // a,l:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1425: { // a,l:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1426: { // a,l:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_x.write_dword(ea, m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1427: { // a,l:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_x.write_dword(ea, m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1428: { // a,l:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1429: { // a,l:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1430: { // a,l:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1431: { // b,l:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1432: { // b,l:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1433: { // b,l:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_x.write_dword(ea, m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1434: { // b,l:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_x.write_dword(ea, m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1435: { // b,l:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1436: { // b,l:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1437: { // b,l:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1438: { // ab,l:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1439: { // ab,l:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1440: { // ab,l:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_x.write_dword(ea, m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1441: { // ab,l:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_x.write_dword(ea, m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1442: { // ab,l:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1443: { // ab,l:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1444: { // ab,l:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1445: { // ba,l:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1446: { // ba,l:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1447: { // ba,l:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_x.write_dword(ea, m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1448: { // ba,l:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_x.write_dword(ea, m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1449: { // ba,l:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1450: { // ba,l:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_x.write_dword(ea, m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1451: { // ba,l:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_x.write_dword(ea, m_tmp1);
		m_y.write_dword(ea, m_tmp2);
		break;
		}
	case 1452: { // a10,l:[abs]
		u32 abs = exv;
		m_x.write_dword(abs, m_tmp1);
		m_y.write_dword(abs, m_tmp2);
		break;
		}
	case 1453: { // b10,l:[abs]
		u32 abs = exv;
		m_x.write_dword(abs, m_tmp1);
		m_y.write_dword(abs, m_tmp2);
		break;
		}
	case 1454: { // x,l:[abs]
		u32 abs = exv;
		m_x.write_dword(abs, m_tmp1);
		m_y.write_dword(abs, m_tmp2);
		break;
		}
	case 1455: { // y,l:[abs]
		u32 abs = exv;
		m_x.write_dword(abs, m_tmp1);
		m_y.write_dword(abs, m_tmp2);
		break;
		}
	case 1456: { // a,l:[abs]
		u32 abs = exv;
		m_x.write_dword(abs, m_tmp1);
		m_y.write_dword(abs, m_tmp2);
		break;
		}
	case 1457: { // b,l:[abs]
		u32 abs = exv;
		m_x.write_dword(abs, m_tmp1);
		m_y.write_dword(abs, m_tmp2);
		break;
		}
	case 1458: { // ab,l:[abs]
		u32 abs = exv;
		m_x.write_dword(abs, m_tmp1);
		m_y.write_dword(abs, m_tmp2);
		break;
		}
	case 1459: { // ba,l:[abs]
		u32 abs = exv;
		m_x.write_dword(abs, m_tmp1);
		m_y.write_dword(abs, m_tmp2);
		break;
		}
	case 1460: { // a10,l:[aa]
		u32 aa = BIT(opcode, 8, 6);
		m_x.write_dword(aa, m_tmp1);
		m_y.write_dword(aa, m_tmp2);
		break;
		}
	case 1461: { // b10,l:[aa]
		u32 aa = BIT(opcode, 8, 6);
		m_x.write_dword(aa, m_tmp1);
		m_y.write_dword(aa, m_tmp2);
		break;
		}
	case 1462: { // x,l:[aa]
		u32 aa = BIT(opcode, 8, 6);
		m_x.write_dword(aa, m_tmp1);
		m_y.write_dword(aa, m_tmp2);
		break;
		}
	case 1463: { // y,l:[aa]
		u32 aa = BIT(opcode, 8, 6);
		m_x.write_dword(aa, m_tmp1);
		m_y.write_dword(aa, m_tmp2);
		break;
		}
	case 1464: { // a,l:[aa]
		u32 aa = BIT(opcode, 8, 6);
		m_x.write_dword(aa, m_tmp1);
		m_y.write_dword(aa, m_tmp2);
		break;
		}
	case 1465: { // b,l:[aa]
		u32 aa = BIT(opcode, 8, 6);
		m_x.write_dword(aa, m_tmp1);
		m_y.write_dword(aa, m_tmp2);
		break;
		}
	case 1466: { // ab,l:[aa]
		u32 aa = BIT(opcode, 8, 6);
		m_x.write_dword(aa, m_tmp1);
		m_y.write_dword(aa, m_tmp2);
		break;
		}
	case 1467: { // ba,l:[aa]
		u32 aa = BIT(opcode, 8, 6);
		m_x.write_dword(aa, m_tmp1);
		m_y.write_dword(aa, m_tmp2);
		break;
		}
	case 1468: { // x:(r)+n,x0 y:(rh)+n,y0
		unhandled("x:(r)+n,x0 y:(rh)+n,y0");
		break;
		}
	case 1469: { // x:(r)+n,x0 y:(rh)+n,y1
		unhandled("x:(r)+n,x0 y:(rh)+n,y1");
		break;
		}
	case 1470: { // x:(r)+n,x0 y:(rh)+n,a
		unhandled("x:(r)+n,x0 y:(rh)+n,a");
		break;
		}
	case 1471: { // x:(r)+n,x0 y:(rh)+n,b
		unhandled("x:(r)+n,x0 y:(rh)+n,b");
		break;
		}
	case 1472: { // x:(r)+n,x1 y:(rh)+n,y0
		unhandled("x:(r)+n,x1 y:(rh)+n,y0");
		break;
		}
	case 1473: { // x:(r)+n,x1 y:(rh)+n,y1
		unhandled("x:(r)+n,x1 y:(rh)+n,y1");
		break;
		}
	case 1474: { // x:(r)+n,x1 y:(rh)+n,a
		unhandled("x:(r)+n,x1 y:(rh)+n,a");
		break;
		}
	case 1475: { // x:(r)+n,x1 y:(rh)+n,b
		unhandled("x:(r)+n,x1 y:(rh)+n,b");
		break;
		}
	case 1476: { // x:(r)+n,a y:(rh)+n,y0
		unhandled("x:(r)+n,a y:(rh)+n,y0");
		break;
		}
	case 1477: { // x:(r)+n,a y:(rh)+n,y1
		unhandled("x:(r)+n,a y:(rh)+n,y1");
		break;
		}
	case 1478: { // x:(r)+n,a y:(rh)+n,a
		unhandled("x:(r)+n,a y:(rh)+n,a");
		break;
		}
	case 1479: { // x:(r)+n,a y:(rh)+n,b
		unhandled("x:(r)+n,a y:(rh)+n,b");
		break;
		}
	case 1480: { // x:(r)+n,b y:(rh)+n,y0
		unhandled("x:(r)+n,b y:(rh)+n,y0");
		break;
		}
	case 1481: { // x:(r)+n,b y:(rh)+n,y1
		unhandled("x:(r)+n,b y:(rh)+n,y1");
		break;
		}
	case 1482: { // x:(r)+n,b y:(rh)+n,a
		unhandled("x:(r)+n,b y:(rh)+n,a");
		break;
		}
	case 1483: { // x:(r)+n,b y:(rh)+n,b
		unhandled("x:(r)+n,b y:(rh)+n,b");
		break;
		}
	case 1484: { // x:(r)+n,x0 y:(rh)-,y0
		unhandled("x:(r)+n,x0 y:(rh)-,y0");
		break;
		}
	case 1485: { // x:(r)+n,x0 y:(rh)-,y1
		unhandled("x:(r)+n,x0 y:(rh)-,y1");
		break;
		}
	case 1486: { // x:(r)+n,x0 y:(rh)-,a
		unhandled("x:(r)+n,x0 y:(rh)-,a");
		break;
		}
	case 1487: { // x:(r)+n,x0 y:(rh)-,b
		unhandled("x:(r)+n,x0 y:(rh)-,b");
		break;
		}
	case 1488: { // x:(r)+n,x1 y:(rh)-,y0
		unhandled("x:(r)+n,x1 y:(rh)-,y0");
		break;
		}
	case 1489: { // x:(r)+n,x1 y:(rh)-,y1
		unhandled("x:(r)+n,x1 y:(rh)-,y1");
		break;
		}
	case 1490: { // x:(r)+n,x1 y:(rh)-,a
		unhandled("x:(r)+n,x1 y:(rh)-,a");
		break;
		}
	case 1491: { // x:(r)+n,x1 y:(rh)-,b
		unhandled("x:(r)+n,x1 y:(rh)-,b");
		break;
		}
	case 1492: { // x:(r)+n,a y:(rh)-,y0
		unhandled("x:(r)+n,a y:(rh)-,y0");
		break;
		}
	case 1493: { // x:(r)+n,a y:(rh)-,y1
		unhandled("x:(r)+n,a y:(rh)-,y1");
		break;
		}
	case 1494: { // x:(r)+n,a y:(rh)-,a
		unhandled("x:(r)+n,a y:(rh)-,a");
		break;
		}
	case 1495: { // x:(r)+n,a y:(rh)-,b
		unhandled("x:(r)+n,a y:(rh)-,b");
		break;
		}
	case 1496: { // x:(r)+n,b y:(rh)-,y0
		unhandled("x:(r)+n,b y:(rh)-,y0");
		break;
		}
	case 1497: { // x:(r)+n,b y:(rh)-,y1
		unhandled("x:(r)+n,b y:(rh)-,y1");
		break;
		}
	case 1498: { // x:(r)+n,b y:(rh)-,a
		unhandled("x:(r)+n,b y:(rh)-,a");
		break;
		}
	case 1499: { // x:(r)+n,b y:(rh)-,b
		unhandled("x:(r)+n,b y:(rh)-,b");
		break;
		}
	case 1500: { // x:(r)+n,x0 y:(rh)+,y0
		unhandled("x:(r)+n,x0 y:(rh)+,y0");
		break;
		}
	case 1501: { // x:(r)+n,x0 y:(rh)+,y1
		unhandled("x:(r)+n,x0 y:(rh)+,y1");
		break;
		}
	case 1502: { // x:(r)+n,x0 y:(rh)+,a
		unhandled("x:(r)+n,x0 y:(rh)+,a");
		break;
		}
	case 1503: { // x:(r)+n,x0 y:(rh)+,b
		unhandled("x:(r)+n,x0 y:(rh)+,b");
		break;
		}
	case 1504: { // x:(r)+n,x1 y:(rh)+,y0
		unhandled("x:(r)+n,x1 y:(rh)+,y0");
		break;
		}
	case 1505: { // x:(r)+n,x1 y:(rh)+,y1
		unhandled("x:(r)+n,x1 y:(rh)+,y1");
		break;
		}
	case 1506: { // x:(r)+n,x1 y:(rh)+,a
		unhandled("x:(r)+n,x1 y:(rh)+,a");
		break;
		}
	case 1507: { // x:(r)+n,x1 y:(rh)+,b
		unhandled("x:(r)+n,x1 y:(rh)+,b");
		break;
		}
	case 1508: { // x:(r)+n,a y:(rh)+,y0
		unhandled("x:(r)+n,a y:(rh)+,y0");
		break;
		}
	case 1509: { // x:(r)+n,a y:(rh)+,y1
		unhandled("x:(r)+n,a y:(rh)+,y1");
		break;
		}
	case 1510: { // x:(r)+n,a y:(rh)+,a
		unhandled("x:(r)+n,a y:(rh)+,a");
		break;
		}
	case 1511: { // x:(r)+n,a y:(rh)+,b
		unhandled("x:(r)+n,a y:(rh)+,b");
		break;
		}
	case 1512: { // x:(r)+n,b y:(rh)+,y0
		unhandled("x:(r)+n,b y:(rh)+,y0");
		break;
		}
	case 1513: { // x:(r)+n,b y:(rh)+,y1
		unhandled("x:(r)+n,b y:(rh)+,y1");
		break;
		}
	case 1514: { // x:(r)+n,b y:(rh)+,a
		unhandled("x:(r)+n,b y:(rh)+,a");
		break;
		}
	case 1515: { // x:(r)+n,b y:(rh)+,b
		unhandled("x:(r)+n,b y:(rh)+,b");
		break;
		}
	case 1516: { // x:(r)+n,x0 y:(rh),y0
		unhandled("x:(r)+n,x0 y:(rh),y0");
		break;
		}
	case 1517: { // x:(r)+n,x0 y:(rh),y1
		unhandled("x:(r)+n,x0 y:(rh),y1");
		break;
		}
	case 1518: { // x:(r)+n,x0 y:(rh),a
		unhandled("x:(r)+n,x0 y:(rh),a");
		break;
		}
	case 1519: { // x:(r)+n,x0 y:(rh),b
		unhandled("x:(r)+n,x0 y:(rh),b");
		break;
		}
	case 1520: { // x:(r)+n,x1 y:(rh),y0
		unhandled("x:(r)+n,x1 y:(rh),y0");
		break;
		}
	case 1521: { // x:(r)+n,x1 y:(rh),y1
		unhandled("x:(r)+n,x1 y:(rh),y1");
		break;
		}
	case 1522: { // x:(r)+n,x1 y:(rh),a
		unhandled("x:(r)+n,x1 y:(rh),a");
		break;
		}
	case 1523: { // x:(r)+n,x1 y:(rh),b
		unhandled("x:(r)+n,x1 y:(rh),b");
		break;
		}
	case 1524: { // x:(r)+n,a y:(rh),y0
		unhandled("x:(r)+n,a y:(rh),y0");
		break;
		}
	case 1525: { // x:(r)+n,a y:(rh),y1
		unhandled("x:(r)+n,a y:(rh),y1");
		break;
		}
	case 1526: { // x:(r)+n,a y:(rh),a
		unhandled("x:(r)+n,a y:(rh),a");
		break;
		}
	case 1527: { // x:(r)+n,a y:(rh),b
		unhandled("x:(r)+n,a y:(rh),b");
		break;
		}
	case 1528: { // x:(r)+n,b y:(rh),y0
		unhandled("x:(r)+n,b y:(rh),y0");
		break;
		}
	case 1529: { // x:(r)+n,b y:(rh),y1
		unhandled("x:(r)+n,b y:(rh),y1");
		break;
		}
	case 1530: { // x:(r)+n,b y:(rh),a
		unhandled("x:(r)+n,b y:(rh),a");
		break;
		}
	case 1531: { // x:(r)+n,b y:(rh),b
		unhandled("x:(r)+n,b y:(rh),b");
		break;
		}
	case 1532: { // x:(r)-,x0 y:(rh)+n,y0
		unhandled("x:(r)-,x0 y:(rh)+n,y0");
		break;
		}
	case 1533: { // x:(r)-,x0 y:(rh)+n,y1
		unhandled("x:(r)-,x0 y:(rh)+n,y1");
		break;
		}
	case 1534: { // x:(r)-,x0 y:(rh)+n,a
		unhandled("x:(r)-,x0 y:(rh)+n,a");
		break;
		}
	case 1535: { // x:(r)-,x0 y:(rh)+n,b
		unhandled("x:(r)-,x0 y:(rh)+n,b");
		break;
		}
	case 1536: { // x:(r)-,x1 y:(rh)+n,y0
		unhandled("x:(r)-,x1 y:(rh)+n,y0");
		break;
		}
	case 1537: { // x:(r)-,x1 y:(rh)+n,y1
		unhandled("x:(r)-,x1 y:(rh)+n,y1");
		break;
		}
	case 1538: { // x:(r)-,x1 y:(rh)+n,a
		unhandled("x:(r)-,x1 y:(rh)+n,a");
		break;
		}
	case 1539: { // x:(r)-,x1 y:(rh)+n,b
		unhandled("x:(r)-,x1 y:(rh)+n,b");
		break;
		}
	case 1540: { // x:(r)-,a y:(rh)+n,y0
		unhandled("x:(r)-,a y:(rh)+n,y0");
		break;
		}
	case 1541: { // x:(r)-,a y:(rh)+n,y1
		unhandled("x:(r)-,a y:(rh)+n,y1");
		break;
		}
	case 1542: { // x:(r)-,a y:(rh)+n,a
		unhandled("x:(r)-,a y:(rh)+n,a");
		break;
		}
	case 1543: { // x:(r)-,a y:(rh)+n,b
		unhandled("x:(r)-,a y:(rh)+n,b");
		break;
		}
	case 1544: { // x:(r)-,b y:(rh)+n,y0
		unhandled("x:(r)-,b y:(rh)+n,y0");
		break;
		}
	case 1545: { // x:(r)-,b y:(rh)+n,y1
		unhandled("x:(r)-,b y:(rh)+n,y1");
		break;
		}
	case 1546: { // x:(r)-,b y:(rh)+n,a
		unhandled("x:(r)-,b y:(rh)+n,a");
		break;
		}
	case 1547: { // x:(r)-,b y:(rh)+n,b
		unhandled("x:(r)-,b y:(rh)+n,b");
		break;
		}
	case 1548: { // x:(r)-,x0 y:(rh)-,y0
		unhandled("x:(r)-,x0 y:(rh)-,y0");
		break;
		}
	case 1549: { // x:(r)-,x0 y:(rh)-,y1
		unhandled("x:(r)-,x0 y:(rh)-,y1");
		break;
		}
	case 1550: { // x:(r)-,x0 y:(rh)-,a
		unhandled("x:(r)-,x0 y:(rh)-,a");
		break;
		}
	case 1551: { // x:(r)-,x0 y:(rh)-,b
		unhandled("x:(r)-,x0 y:(rh)-,b");
		break;
		}
	case 1552: { // x:(r)-,x1 y:(rh)-,y0
		unhandled("x:(r)-,x1 y:(rh)-,y0");
		break;
		}
	case 1553: { // x:(r)-,x1 y:(rh)-,y1
		unhandled("x:(r)-,x1 y:(rh)-,y1");
		break;
		}
	case 1554: { // x:(r)-,x1 y:(rh)-,a
		unhandled("x:(r)-,x1 y:(rh)-,a");
		break;
		}
	case 1555: { // x:(r)-,x1 y:(rh)-,b
		unhandled("x:(r)-,x1 y:(rh)-,b");
		break;
		}
	case 1556: { // x:(r)-,a y:(rh)-,y0
		unhandled("x:(r)-,a y:(rh)-,y0");
		break;
		}
	case 1557: { // x:(r)-,a y:(rh)-,y1
		unhandled("x:(r)-,a y:(rh)-,y1");
		break;
		}
	case 1558: { // x:(r)-,a y:(rh)-,a
		unhandled("x:(r)-,a y:(rh)-,a");
		break;
		}
	case 1559: { // x:(r)-,a y:(rh)-,b
		unhandled("x:(r)-,a y:(rh)-,b");
		break;
		}
	case 1560: { // x:(r)-,b y:(rh)-,y0
		unhandled("x:(r)-,b y:(rh)-,y0");
		break;
		}
	case 1561: { // x:(r)-,b y:(rh)-,y1
		unhandled("x:(r)-,b y:(rh)-,y1");
		break;
		}
	case 1562: { // x:(r)-,b y:(rh)-,a
		unhandled("x:(r)-,b y:(rh)-,a");
		break;
		}
	case 1563: { // x:(r)-,b y:(rh)-,b
		unhandled("x:(r)-,b y:(rh)-,b");
		break;
		}
	case 1564: { // x:(r)-,x0 y:(rh)+,y0
		unhandled("x:(r)-,x0 y:(rh)+,y0");
		break;
		}
	case 1565: { // x:(r)-,x0 y:(rh)+,y1
		unhandled("x:(r)-,x0 y:(rh)+,y1");
		break;
		}
	case 1566: { // x:(r)-,x0 y:(rh)+,a
		unhandled("x:(r)-,x0 y:(rh)+,a");
		break;
		}
	case 1567: { // x:(r)-,x0 y:(rh)+,b
		unhandled("x:(r)-,x0 y:(rh)+,b");
		break;
		}
	case 1568: { // x:(r)-,x1 y:(rh)+,y0
		unhandled("x:(r)-,x1 y:(rh)+,y0");
		break;
		}
	case 1569: { // x:(r)-,x1 y:(rh)+,y1
		unhandled("x:(r)-,x1 y:(rh)+,y1");
		break;
		}
	case 1570: { // x:(r)-,x1 y:(rh)+,a
		unhandled("x:(r)-,x1 y:(rh)+,a");
		break;
		}
	case 1571: { // x:(r)-,x1 y:(rh)+,b
		unhandled("x:(r)-,x1 y:(rh)+,b");
		break;
		}
	case 1572: { // x:(r)-,a y:(rh)+,y0
		unhandled("x:(r)-,a y:(rh)+,y0");
		break;
		}
	case 1573: { // x:(r)-,a y:(rh)+,y1
		unhandled("x:(r)-,a y:(rh)+,y1");
		break;
		}
	case 1574: { // x:(r)-,a y:(rh)+,a
		unhandled("x:(r)-,a y:(rh)+,a");
		break;
		}
	case 1575: { // x:(r)-,a y:(rh)+,b
		unhandled("x:(r)-,a y:(rh)+,b");
		break;
		}
	case 1576: { // x:(r)-,b y:(rh)+,y0
		unhandled("x:(r)-,b y:(rh)+,y0");
		break;
		}
	case 1577: { // x:(r)-,b y:(rh)+,y1
		unhandled("x:(r)-,b y:(rh)+,y1");
		break;
		}
	case 1578: { // x:(r)-,b y:(rh)+,a
		unhandled("x:(r)-,b y:(rh)+,a");
		break;
		}
	case 1579: { // x:(r)-,b y:(rh)+,b
		unhandled("x:(r)-,b y:(rh)+,b");
		break;
		}
	case 1580: { // x:(r)-,x0 y:(rh),y0
		unhandled("x:(r)-,x0 y:(rh),y0");
		break;
		}
	case 1581: { // x:(r)-,x0 y:(rh),y1
		unhandled("x:(r)-,x0 y:(rh),y1");
		break;
		}
	case 1582: { // x:(r)-,x0 y:(rh),a
		unhandled("x:(r)-,x0 y:(rh),a");
		break;
		}
	case 1583: { // x:(r)-,x0 y:(rh),b
		unhandled("x:(r)-,x0 y:(rh),b");
		break;
		}
	case 1584: { // x:(r)-,x1 y:(rh),y0
		unhandled("x:(r)-,x1 y:(rh),y0");
		break;
		}
	case 1585: { // x:(r)-,x1 y:(rh),y1
		unhandled("x:(r)-,x1 y:(rh),y1");
		break;
		}
	case 1586: { // x:(r)-,x1 y:(rh),a
		unhandled("x:(r)-,x1 y:(rh),a");
		break;
		}
	case 1587: { // x:(r)-,x1 y:(rh),b
		unhandled("x:(r)-,x1 y:(rh),b");
		break;
		}
	case 1588: { // x:(r)-,a y:(rh),y0
		unhandled("x:(r)-,a y:(rh),y0");
		break;
		}
	case 1589: { // x:(r)-,a y:(rh),y1
		unhandled("x:(r)-,a y:(rh),y1");
		break;
		}
	case 1590: { // x:(r)-,a y:(rh),a
		unhandled("x:(r)-,a y:(rh),a");
		break;
		}
	case 1591: { // x:(r)-,a y:(rh),b
		unhandled("x:(r)-,a y:(rh),b");
		break;
		}
	case 1592: { // x:(r)-,b y:(rh),y0
		unhandled("x:(r)-,b y:(rh),y0");
		break;
		}
	case 1593: { // x:(r)-,b y:(rh),y1
		unhandled("x:(r)-,b y:(rh),y1");
		break;
		}
	case 1594: { // x:(r)-,b y:(rh),a
		unhandled("x:(r)-,b y:(rh),a");
		break;
		}
	case 1595: { // x:(r)-,b y:(rh),b
		unhandled("x:(r)-,b y:(rh),b");
		break;
		}
	case 1596: { // x:(r)+,x0 y:(rh)+n,y0
		unhandled("x:(r)+,x0 y:(rh)+n,y0");
		break;
		}
	case 1597: { // x:(r)+,x0 y:(rh)+n,y1
		unhandled("x:(r)+,x0 y:(rh)+n,y1");
		break;
		}
	case 1598: { // x:(r)+,x0 y:(rh)+n,a
		unhandled("x:(r)+,x0 y:(rh)+n,a");
		break;
		}
	case 1599: { // x:(r)+,x0 y:(rh)+n,b
		unhandled("x:(r)+,x0 y:(rh)+n,b");
		break;
		}
	case 1600: { // x:(r)+,x1 y:(rh)+n,y0
		unhandled("x:(r)+,x1 y:(rh)+n,y0");
		break;
		}
	case 1601: { // x:(r)+,x1 y:(rh)+n,y1
		unhandled("x:(r)+,x1 y:(rh)+n,y1");
		break;
		}
	case 1602: { // x:(r)+,x1 y:(rh)+n,a
		unhandled("x:(r)+,x1 y:(rh)+n,a");
		break;
		}
	case 1603: { // x:(r)+,x1 y:(rh)+n,b
		unhandled("x:(r)+,x1 y:(rh)+n,b");
		break;
		}
	case 1604: { // x:(r)+,a y:(rh)+n,y0
		unhandled("x:(r)+,a y:(rh)+n,y0");
		break;
		}
	case 1605: { // x:(r)+,a y:(rh)+n,y1
		unhandled("x:(r)+,a y:(rh)+n,y1");
		break;
		}
	case 1606: { // x:(r)+,a y:(rh)+n,a
		unhandled("x:(r)+,a y:(rh)+n,a");
		break;
		}
	case 1607: { // x:(r)+,a y:(rh)+n,b
		unhandled("x:(r)+,a y:(rh)+n,b");
		break;
		}
	case 1608: { // x:(r)+,b y:(rh)+n,y0
		unhandled("x:(r)+,b y:(rh)+n,y0");
		break;
		}
	case 1609: { // x:(r)+,b y:(rh)+n,y1
		unhandled("x:(r)+,b y:(rh)+n,y1");
		break;
		}
	case 1610: { // x:(r)+,b y:(rh)+n,a
		unhandled("x:(r)+,b y:(rh)+n,a");
		break;
		}
	case 1611: { // x:(r)+,b y:(rh)+n,b
		unhandled("x:(r)+,b y:(rh)+n,b");
		break;
		}
	case 1612: { // x:(r)+,x0 y:(rh)-,y0
		unhandled("x:(r)+,x0 y:(rh)-,y0");
		break;
		}
	case 1613: { // x:(r)+,x0 y:(rh)-,y1
		unhandled("x:(r)+,x0 y:(rh)-,y1");
		break;
		}
	case 1614: { // x:(r)+,x0 y:(rh)-,a
		unhandled("x:(r)+,x0 y:(rh)-,a");
		break;
		}
	case 1615: { // x:(r)+,x0 y:(rh)-,b
		unhandled("x:(r)+,x0 y:(rh)-,b");
		break;
		}
	case 1616: { // x:(r)+,x1 y:(rh)-,y0
		unhandled("x:(r)+,x1 y:(rh)-,y0");
		break;
		}
	case 1617: { // x:(r)+,x1 y:(rh)-,y1
		unhandled("x:(r)+,x1 y:(rh)-,y1");
		break;
		}
	case 1618: { // x:(r)+,x1 y:(rh)-,a
		unhandled("x:(r)+,x1 y:(rh)-,a");
		break;
		}
	case 1619: { // x:(r)+,x1 y:(rh)-,b
		unhandled("x:(r)+,x1 y:(rh)-,b");
		break;
		}
	case 1620: { // x:(r)+,a y:(rh)-,y0
		unhandled("x:(r)+,a y:(rh)-,y0");
		break;
		}
	case 1621: { // x:(r)+,a y:(rh)-,y1
		unhandled("x:(r)+,a y:(rh)-,y1");
		break;
		}
	case 1622: { // x:(r)+,a y:(rh)-,a
		unhandled("x:(r)+,a y:(rh)-,a");
		break;
		}
	case 1623: { // x:(r)+,a y:(rh)-,b
		unhandled("x:(r)+,a y:(rh)-,b");
		break;
		}
	case 1624: { // x:(r)+,b y:(rh)-,y0
		unhandled("x:(r)+,b y:(rh)-,y0");
		break;
		}
	case 1625: { // x:(r)+,b y:(rh)-,y1
		unhandled("x:(r)+,b y:(rh)-,y1");
		break;
		}
	case 1626: { // x:(r)+,b y:(rh)-,a
		unhandled("x:(r)+,b y:(rh)-,a");
		break;
		}
	case 1627: { // x:(r)+,b y:(rh)-,b
		unhandled("x:(r)+,b y:(rh)-,b");
		break;
		}
	case 1628: { // x:(r)+,x0 y:(rh)+,y0
		unhandled("x:(r)+,x0 y:(rh)+,y0");
		break;
		}
	case 1629: { // x:(r)+,x0 y:(rh)+,y1
		unhandled("x:(r)+,x0 y:(rh)+,y1");
		break;
		}
	case 1630: { // x:(r)+,x0 y:(rh)+,a
		unhandled("x:(r)+,x0 y:(rh)+,a");
		break;
		}
	case 1631: { // x:(r)+,x0 y:(rh)+,b
		unhandled("x:(r)+,x0 y:(rh)+,b");
		break;
		}
	case 1632: { // x:(r)+,x1 y:(rh)+,y0
		unhandled("x:(r)+,x1 y:(rh)+,y0");
		break;
		}
	case 1633: { // x:(r)+,x1 y:(rh)+,y1
		unhandled("x:(r)+,x1 y:(rh)+,y1");
		break;
		}
	case 1634: { // x:(r)+,x1 y:(rh)+,a
		unhandled("x:(r)+,x1 y:(rh)+,a");
		break;
		}
	case 1635: { // x:(r)+,x1 y:(rh)+,b
		unhandled("x:(r)+,x1 y:(rh)+,b");
		break;
		}
	case 1636: { // x:(r)+,a y:(rh)+,y0
		unhandled("x:(r)+,a y:(rh)+,y0");
		break;
		}
	case 1637: { // x:(r)+,a y:(rh)+,y1
		unhandled("x:(r)+,a y:(rh)+,y1");
		break;
		}
	case 1638: { // x:(r)+,a y:(rh)+,a
		unhandled("x:(r)+,a y:(rh)+,a");
		break;
		}
	case 1639: { // x:(r)+,a y:(rh)+,b
		unhandled("x:(r)+,a y:(rh)+,b");
		break;
		}
	case 1640: { // x:(r)+,b y:(rh)+,y0
		unhandled("x:(r)+,b y:(rh)+,y0");
		break;
		}
	case 1641: { // x:(r)+,b y:(rh)+,y1
		unhandled("x:(r)+,b y:(rh)+,y1");
		break;
		}
	case 1642: { // x:(r)+,b y:(rh)+,a
		unhandled("x:(r)+,b y:(rh)+,a");
		break;
		}
	case 1643: { // x:(r)+,b y:(rh)+,b
		unhandled("x:(r)+,b y:(rh)+,b");
		break;
		}
	case 1644: { // x:(r)+,x0 y:(rh),y0
		unhandled("x:(r)+,x0 y:(rh),y0");
		break;
		}
	case 1645: { // x:(r)+,x0 y:(rh),y1
		unhandled("x:(r)+,x0 y:(rh),y1");
		break;
		}
	case 1646: { // x:(r)+,x0 y:(rh),a
		unhandled("x:(r)+,x0 y:(rh),a");
		break;
		}
	case 1647: { // x:(r)+,x0 y:(rh),b
		unhandled("x:(r)+,x0 y:(rh),b");
		break;
		}
	case 1648: { // x:(r)+,x1 y:(rh),y0
		unhandled("x:(r)+,x1 y:(rh),y0");
		break;
		}
	case 1649: { // x:(r)+,x1 y:(rh),y1
		unhandled("x:(r)+,x1 y:(rh),y1");
		break;
		}
	case 1650: { // x:(r)+,x1 y:(rh),a
		unhandled("x:(r)+,x1 y:(rh),a");
		break;
		}
	case 1651: { // x:(r)+,x1 y:(rh),b
		unhandled("x:(r)+,x1 y:(rh),b");
		break;
		}
	case 1652: { // x:(r)+,a y:(rh),y0
		unhandled("x:(r)+,a y:(rh),y0");
		break;
		}
	case 1653: { // x:(r)+,a y:(rh),y1
		unhandled("x:(r)+,a y:(rh),y1");
		break;
		}
	case 1654: { // x:(r)+,a y:(rh),a
		unhandled("x:(r)+,a y:(rh),a");
		break;
		}
	case 1655: { // x:(r)+,a y:(rh),b
		unhandled("x:(r)+,a y:(rh),b");
		break;
		}
	case 1656: { // x:(r)+,b y:(rh),y0
		unhandled("x:(r)+,b y:(rh),y0");
		break;
		}
	case 1657: { // x:(r)+,b y:(rh),y1
		unhandled("x:(r)+,b y:(rh),y1");
		break;
		}
	case 1658: { // x:(r)+,b y:(rh),a
		unhandled("x:(r)+,b y:(rh),a");
		break;
		}
	case 1659: { // x:(r)+,b y:(rh),b
		unhandled("x:(r)+,b y:(rh),b");
		break;
		}
	case 1660: { // x:(r),x0 y:(rh)+n,y0
		unhandled("x:(r),x0 y:(rh)+n,y0");
		break;
		}
	case 1661: { // x:(r),x0 y:(rh)+n,y1
		unhandled("x:(r),x0 y:(rh)+n,y1");
		break;
		}
	case 1662: { // x:(r),x0 y:(rh)+n,a
		unhandled("x:(r),x0 y:(rh)+n,a");
		break;
		}
	case 1663: { // x:(r),x0 y:(rh)+n,b
		unhandled("x:(r),x0 y:(rh)+n,b");
		break;
		}
	case 1664: { // x:(r),x1 y:(rh)+n,y0
		unhandled("x:(r),x1 y:(rh)+n,y0");
		break;
		}
	case 1665: { // x:(r),x1 y:(rh)+n,y1
		unhandled("x:(r),x1 y:(rh)+n,y1");
		break;
		}
	case 1666: { // x:(r),x1 y:(rh)+n,a
		unhandled("x:(r),x1 y:(rh)+n,a");
		break;
		}
	case 1667: { // x:(r),x1 y:(rh)+n,b
		unhandled("x:(r),x1 y:(rh)+n,b");
		break;
		}
	case 1668: { // x:(r),a y:(rh)+n,y0
		unhandled("x:(r),a y:(rh)+n,y0");
		break;
		}
	case 1669: { // x:(r),a y:(rh)+n,y1
		unhandled("x:(r),a y:(rh)+n,y1");
		break;
		}
	case 1670: { // x:(r),a y:(rh)+n,a
		unhandled("x:(r),a y:(rh)+n,a");
		break;
		}
	case 1671: { // x:(r),a y:(rh)+n,b
		unhandled("x:(r),a y:(rh)+n,b");
		break;
		}
	case 1672: { // x:(r),b y:(rh)+n,y0
		unhandled("x:(r),b y:(rh)+n,y0");
		break;
		}
	case 1673: { // x:(r),b y:(rh)+n,y1
		unhandled("x:(r),b y:(rh)+n,y1");
		break;
		}
	case 1674: { // x:(r),b y:(rh)+n,a
		unhandled("x:(r),b y:(rh)+n,a");
		break;
		}
	case 1675: { // x:(r),b y:(rh)+n,b
		unhandled("x:(r),b y:(rh)+n,b");
		break;
		}
	case 1676: { // x:(r),x0 y:(rh)-,y0
		unhandled("x:(r),x0 y:(rh)-,y0");
		break;
		}
	case 1677: { // x:(r),x0 y:(rh)-,y1
		unhandled("x:(r),x0 y:(rh)-,y1");
		break;
		}
	case 1678: { // x:(r),x0 y:(rh)-,a
		unhandled("x:(r),x0 y:(rh)-,a");
		break;
		}
	case 1679: { // x:(r),x0 y:(rh)-,b
		unhandled("x:(r),x0 y:(rh)-,b");
		break;
		}
	case 1680: { // x:(r),x1 y:(rh)-,y0
		unhandled("x:(r),x1 y:(rh)-,y0");
		break;
		}
	case 1681: { // x:(r),x1 y:(rh)-,y1
		unhandled("x:(r),x1 y:(rh)-,y1");
		break;
		}
	case 1682: { // x:(r),x1 y:(rh)-,a
		unhandled("x:(r),x1 y:(rh)-,a");
		break;
		}
	case 1683: { // x:(r),x1 y:(rh)-,b
		unhandled("x:(r),x1 y:(rh)-,b");
		break;
		}
	case 1684: { // x:(r),a y:(rh)-,y0
		unhandled("x:(r),a y:(rh)-,y0");
		break;
		}
	case 1685: { // x:(r),a y:(rh)-,y1
		unhandled("x:(r),a y:(rh)-,y1");
		break;
		}
	case 1686: { // x:(r),a y:(rh)-,a
		unhandled("x:(r),a y:(rh)-,a");
		break;
		}
	case 1687: { // x:(r),a y:(rh)-,b
		unhandled("x:(r),a y:(rh)-,b");
		break;
		}
	case 1688: { // x:(r),b y:(rh)-,y0
		unhandled("x:(r),b y:(rh)-,y0");
		break;
		}
	case 1689: { // x:(r),b y:(rh)-,y1
		unhandled("x:(r),b y:(rh)-,y1");
		break;
		}
	case 1690: { // x:(r),b y:(rh)-,a
		unhandled("x:(r),b y:(rh)-,a");
		break;
		}
	case 1691: { // x:(r),b y:(rh)-,b
		unhandled("x:(r),b y:(rh)-,b");
		break;
		}
	case 1692: { // x:(r),x0 y:(rh)+,y0
		unhandled("x:(r),x0 y:(rh)+,y0");
		break;
		}
	case 1693: { // x:(r),x0 y:(rh)+,y1
		unhandled("x:(r),x0 y:(rh)+,y1");
		break;
		}
	case 1694: { // x:(r),x0 y:(rh)+,a
		unhandled("x:(r),x0 y:(rh)+,a");
		break;
		}
	case 1695: { // x:(r),x0 y:(rh)+,b
		unhandled("x:(r),x0 y:(rh)+,b");
		break;
		}
	case 1696: { // x:(r),x1 y:(rh)+,y0
		unhandled("x:(r),x1 y:(rh)+,y0");
		break;
		}
	case 1697: { // x:(r),x1 y:(rh)+,y1
		unhandled("x:(r),x1 y:(rh)+,y1");
		break;
		}
	case 1698: { // x:(r),x1 y:(rh)+,a
		unhandled("x:(r),x1 y:(rh)+,a");
		break;
		}
	case 1699: { // x:(r),x1 y:(rh)+,b
		unhandled("x:(r),x1 y:(rh)+,b");
		break;
		}
	case 1700: { // x:(r),a y:(rh)+,y0
		unhandled("x:(r),a y:(rh)+,y0");
		break;
		}
	case 1701: { // x:(r),a y:(rh)+,y1
		unhandled("x:(r),a y:(rh)+,y1");
		break;
		}
	case 1702: { // x:(r),a y:(rh)+,a
		unhandled("x:(r),a y:(rh)+,a");
		break;
		}
	case 1703: { // x:(r),a y:(rh)+,b
		unhandled("x:(r),a y:(rh)+,b");
		break;
		}
	case 1704: { // x:(r),b y:(rh)+,y0
		unhandled("x:(r),b y:(rh)+,y0");
		break;
		}
	case 1705: { // x:(r),b y:(rh)+,y1
		unhandled("x:(r),b y:(rh)+,y1");
		break;
		}
	case 1706: { // x:(r),b y:(rh)+,a
		unhandled("x:(r),b y:(rh)+,a");
		break;
		}
	case 1707: { // x:(r),b y:(rh)+,b
		unhandled("x:(r),b y:(rh)+,b");
		break;
		}
	case 1708: { // x:(r),x0 y:(rh),y0
		unhandled("x:(r),x0 y:(rh),y0");
		break;
		}
	case 1709: { // x:(r),x0 y:(rh),y1
		unhandled("x:(r),x0 y:(rh),y1");
		break;
		}
	case 1710: { // x:(r),x0 y:(rh),a
		unhandled("x:(r),x0 y:(rh),a");
		break;
		}
	case 1711: { // x:(r),x0 y:(rh),b
		unhandled("x:(r),x0 y:(rh),b");
		break;
		}
	case 1712: { // x:(r),x1 y:(rh),y0
		unhandled("x:(r),x1 y:(rh),y0");
		break;
		}
	case 1713: { // x:(r),x1 y:(rh),y1
		unhandled("x:(r),x1 y:(rh),y1");
		break;
		}
	case 1714: { // x:(r),x1 y:(rh),a
		unhandled("x:(r),x1 y:(rh),a");
		break;
		}
	case 1715: { // x:(r),x1 y:(rh),b
		unhandled("x:(r),x1 y:(rh),b");
		break;
		}
	case 1716: { // x:(r),a y:(rh),y0
		unhandled("x:(r),a y:(rh),y0");
		break;
		}
	case 1717: { // x:(r),a y:(rh),y1
		unhandled("x:(r),a y:(rh),y1");
		break;
		}
	case 1718: { // x:(r),a y:(rh),a
		unhandled("x:(r),a y:(rh),a");
		break;
		}
	case 1719: { // x:(r),a y:(rh),b
		unhandled("x:(r),a y:(rh),b");
		break;
		}
	case 1720: { // x:(r),b y:(rh),y0
		unhandled("x:(r),b y:(rh),y0");
		break;
		}
	case 1721: { // x:(r),b y:(rh),y1
		unhandled("x:(r),b y:(rh),y1");
		break;
		}
	case 1722: { // x:(r),b y:(rh),a
		unhandled("x:(r),b y:(rh),a");
		break;
		}
	case 1723: { // x:(r),b y:(rh),b
		unhandled("x:(r),b y:(rh),b");
		break;
		}
	case 1724: { // x:(r)+n,x0 y0,y:(rh)+n
		unhandled("x:(r)+n,x0 y0,y:(rh)+n");
		break;
		}
	case 1725: { // x:(r)+n,x0 y1,y:(rh)+n
		unhandled("x:(r)+n,x0 y1,y:(rh)+n");
		break;
		}
	case 1726: { // x:(r)+n,x0 a,y:(rh)+n
		unhandled("x:(r)+n,x0 a,y:(rh)+n");
		break;
		}
	case 1727: { // x:(r)+n,x0 b,y:(rh)+n
		unhandled("x:(r)+n,x0 b,y:(rh)+n");
		break;
		}
	case 1728: { // x:(r)+n,x1 y0,y:(rh)+n
		unhandled("x:(r)+n,x1 y0,y:(rh)+n");
		break;
		}
	case 1729: { // x:(r)+n,x1 y1,y:(rh)+n
		unhandled("x:(r)+n,x1 y1,y:(rh)+n");
		break;
		}
	case 1730: { // x:(r)+n,x1 a,y:(rh)+n
		unhandled("x:(r)+n,x1 a,y:(rh)+n");
		break;
		}
	case 1731: { // x:(r)+n,x1 b,y:(rh)+n
		unhandled("x:(r)+n,x1 b,y:(rh)+n");
		break;
		}
	case 1732: { // x:(r)+n,a y0,y:(rh)+n
		unhandled("x:(r)+n,a y0,y:(rh)+n");
		break;
		}
	case 1733: { // x:(r)+n,a y1,y:(rh)+n
		unhandled("x:(r)+n,a y1,y:(rh)+n");
		break;
		}
	case 1734: { // x:(r)+n,a a,y:(rh)+n
		unhandled("x:(r)+n,a a,y:(rh)+n");
		break;
		}
	case 1735: { // x:(r)+n,a b,y:(rh)+n
		unhandled("x:(r)+n,a b,y:(rh)+n");
		break;
		}
	case 1736: { // x:(r)+n,b y0,y:(rh)+n
		unhandled("x:(r)+n,b y0,y:(rh)+n");
		break;
		}
	case 1737: { // x:(r)+n,b y1,y:(rh)+n
		unhandled("x:(r)+n,b y1,y:(rh)+n");
		break;
		}
	case 1738: { // x:(r)+n,b a,y:(rh)+n
		unhandled("x:(r)+n,b a,y:(rh)+n");
		break;
		}
	case 1739: { // x:(r)+n,b b,y:(rh)+n
		unhandled("x:(r)+n,b b,y:(rh)+n");
		break;
		}
	case 1740: { // x:(r)+n,x0 y0,y:(rh)-
		unhandled("x:(r)+n,x0 y0,y:(rh)-");
		break;
		}
	case 1741: { // x:(r)+n,x0 y1,y:(rh)-
		unhandled("x:(r)+n,x0 y1,y:(rh)-");
		break;
		}
	case 1742: { // x:(r)+n,x0 a,y:(rh)-
		unhandled("x:(r)+n,x0 a,y:(rh)-");
		break;
		}
	case 1743: { // x:(r)+n,x0 b,y:(rh)-
		unhandled("x:(r)+n,x0 b,y:(rh)-");
		break;
		}
	case 1744: { // x:(r)+n,x1 y0,y:(rh)-
		unhandled("x:(r)+n,x1 y0,y:(rh)-");
		break;
		}
	case 1745: { // x:(r)+n,x1 y1,y:(rh)-
		unhandled("x:(r)+n,x1 y1,y:(rh)-");
		break;
		}
	case 1746: { // x:(r)+n,x1 a,y:(rh)-
		unhandled("x:(r)+n,x1 a,y:(rh)-");
		break;
		}
	case 1747: { // x:(r)+n,x1 b,y:(rh)-
		unhandled("x:(r)+n,x1 b,y:(rh)-");
		break;
		}
	case 1748: { // x:(r)+n,a y0,y:(rh)-
		unhandled("x:(r)+n,a y0,y:(rh)-");
		break;
		}
	case 1749: { // x:(r)+n,a y1,y:(rh)-
		unhandled("x:(r)+n,a y1,y:(rh)-");
		break;
		}
	case 1750: { // x:(r)+n,a a,y:(rh)-
		unhandled("x:(r)+n,a a,y:(rh)-");
		break;
		}
	case 1751: { // x:(r)+n,a b,y:(rh)-
		unhandled("x:(r)+n,a b,y:(rh)-");
		break;
		}
	case 1752: { // x:(r)+n,b y0,y:(rh)-
		unhandled("x:(r)+n,b y0,y:(rh)-");
		break;
		}
	case 1753: { // x:(r)+n,b y1,y:(rh)-
		unhandled("x:(r)+n,b y1,y:(rh)-");
		break;
		}
	case 1754: { // x:(r)+n,b a,y:(rh)-
		unhandled("x:(r)+n,b a,y:(rh)-");
		break;
		}
	case 1755: { // x:(r)+n,b b,y:(rh)-
		unhandled("x:(r)+n,b b,y:(rh)-");
		break;
		}
	case 1756: { // x:(r)+n,x0 y0,y:(rh)+
		unhandled("x:(r)+n,x0 y0,y:(rh)+");
		break;
		}
	case 1757: { // x:(r)+n,x0 y1,y:(rh)+
		unhandled("x:(r)+n,x0 y1,y:(rh)+");
		break;
		}
	case 1758: { // x:(r)+n,x0 a,y:(rh)+
		unhandled("x:(r)+n,x0 a,y:(rh)+");
		break;
		}
	case 1759: { // x:(r)+n,x0 b,y:(rh)+
		unhandled("x:(r)+n,x0 b,y:(rh)+");
		break;
		}
	case 1760: { // x:(r)+n,x1 y0,y:(rh)+
		unhandled("x:(r)+n,x1 y0,y:(rh)+");
		break;
		}
	case 1761: { // x:(r)+n,x1 y1,y:(rh)+
		unhandled("x:(r)+n,x1 y1,y:(rh)+");
		break;
		}
	case 1762: { // x:(r)+n,x1 a,y:(rh)+
		unhandled("x:(r)+n,x1 a,y:(rh)+");
		break;
		}
	case 1763: { // x:(r)+n,x1 b,y:(rh)+
		unhandled("x:(r)+n,x1 b,y:(rh)+");
		break;
		}
	case 1764: { // x:(r)+n,a y0,y:(rh)+
		unhandled("x:(r)+n,a y0,y:(rh)+");
		break;
		}
	case 1765: { // x:(r)+n,a y1,y:(rh)+
		unhandled("x:(r)+n,a y1,y:(rh)+");
		break;
		}
	case 1766: { // x:(r)+n,a a,y:(rh)+
		unhandled("x:(r)+n,a a,y:(rh)+");
		break;
		}
	case 1767: { // x:(r)+n,a b,y:(rh)+
		unhandled("x:(r)+n,a b,y:(rh)+");
		break;
		}
	case 1768: { // x:(r)+n,b y0,y:(rh)+
		unhandled("x:(r)+n,b y0,y:(rh)+");
		break;
		}
	case 1769: { // x:(r)+n,b y1,y:(rh)+
		unhandled("x:(r)+n,b y1,y:(rh)+");
		break;
		}
	case 1770: { // x:(r)+n,b a,y:(rh)+
		unhandled("x:(r)+n,b a,y:(rh)+");
		break;
		}
	case 1771: { // x:(r)+n,b b,y:(rh)+
		unhandled("x:(r)+n,b b,y:(rh)+");
		break;
		}
	case 1772: { // x:(r)+n,x0 y0,y:(rh)
		unhandled("x:(r)+n,x0 y0,y:(rh)");
		break;
		}
	case 1773: { // x:(r)+n,x0 y1,y:(rh)
		unhandled("x:(r)+n,x0 y1,y:(rh)");
		break;
		}
	case 1774: { // x:(r)+n,x0 a,y:(rh)
		unhandled("x:(r)+n,x0 a,y:(rh)");
		break;
		}
	case 1775: { // x:(r)+n,x0 b,y:(rh)
		unhandled("x:(r)+n,x0 b,y:(rh)");
		break;
		}
	case 1776: { // x:(r)+n,x1 y0,y:(rh)
		unhandled("x:(r)+n,x1 y0,y:(rh)");
		break;
		}
	case 1777: { // x:(r)+n,x1 y1,y:(rh)
		unhandled("x:(r)+n,x1 y1,y:(rh)");
		break;
		}
	case 1778: { // x:(r)+n,x1 a,y:(rh)
		unhandled("x:(r)+n,x1 a,y:(rh)");
		break;
		}
	case 1779: { // x:(r)+n,x1 b,y:(rh)
		unhandled("x:(r)+n,x1 b,y:(rh)");
		break;
		}
	case 1780: { // x:(r)+n,a y0,y:(rh)
		unhandled("x:(r)+n,a y0,y:(rh)");
		break;
		}
	case 1781: { // x:(r)+n,a y1,y:(rh)
		unhandled("x:(r)+n,a y1,y:(rh)");
		break;
		}
	case 1782: { // x:(r)+n,a a,y:(rh)
		unhandled("x:(r)+n,a a,y:(rh)");
		break;
		}
	case 1783: { // x:(r)+n,a b,y:(rh)
		unhandled("x:(r)+n,a b,y:(rh)");
		break;
		}
	case 1784: { // x:(r)+n,b y0,y:(rh)
		unhandled("x:(r)+n,b y0,y:(rh)");
		break;
		}
	case 1785: { // x:(r)+n,b y1,y:(rh)
		unhandled("x:(r)+n,b y1,y:(rh)");
		break;
		}
	case 1786: { // x:(r)+n,b a,y:(rh)
		unhandled("x:(r)+n,b a,y:(rh)");
		break;
		}
	case 1787: { // x:(r)+n,b b,y:(rh)
		unhandled("x:(r)+n,b b,y:(rh)");
		break;
		}
	case 1788: { // x:(r)-,x0 y0,y:(rh)+n
		unhandled("x:(r)-,x0 y0,y:(rh)+n");
		break;
		}
	case 1789: { // x:(r)-,x0 y1,y:(rh)+n
		unhandled("x:(r)-,x0 y1,y:(rh)+n");
		break;
		}
	case 1790: { // x:(r)-,x0 a,y:(rh)+n
		unhandled("x:(r)-,x0 a,y:(rh)+n");
		break;
		}
	case 1791: { // x:(r)-,x0 b,y:(rh)+n
		unhandled("x:(r)-,x0 b,y:(rh)+n");
		break;
		}
	case 1792: { // x:(r)-,x1 y0,y:(rh)+n
		unhandled("x:(r)-,x1 y0,y:(rh)+n");
		break;
		}
	case 1793: { // x:(r)-,x1 y1,y:(rh)+n
		unhandled("x:(r)-,x1 y1,y:(rh)+n");
		break;
		}
	case 1794: { // x:(r)-,x1 a,y:(rh)+n
		unhandled("x:(r)-,x1 a,y:(rh)+n");
		break;
		}
	case 1795: { // x:(r)-,x1 b,y:(rh)+n
		unhandled("x:(r)-,x1 b,y:(rh)+n");
		break;
		}
	case 1796: { // x:(r)-,a y0,y:(rh)+n
		unhandled("x:(r)-,a y0,y:(rh)+n");
		break;
		}
	case 1797: { // x:(r)-,a y1,y:(rh)+n
		unhandled("x:(r)-,a y1,y:(rh)+n");
		break;
		}
	case 1798: { // x:(r)-,a a,y:(rh)+n
		unhandled("x:(r)-,a a,y:(rh)+n");
		break;
		}
	case 1799: { // x:(r)-,a b,y:(rh)+n
		unhandled("x:(r)-,a b,y:(rh)+n");
		break;
		}
	case 1800: { // x:(r)-,b y0,y:(rh)+n
		unhandled("x:(r)-,b y0,y:(rh)+n");
		break;
		}
	case 1801: { // x:(r)-,b y1,y:(rh)+n
		unhandled("x:(r)-,b y1,y:(rh)+n");
		break;
		}
	case 1802: { // x:(r)-,b a,y:(rh)+n
		unhandled("x:(r)-,b a,y:(rh)+n");
		break;
		}
	case 1803: { // x:(r)-,b b,y:(rh)+n
		unhandled("x:(r)-,b b,y:(rh)+n");
		break;
		}
	case 1804: { // x:(r)-,x0 y0,y:(rh)-
		unhandled("x:(r)-,x0 y0,y:(rh)-");
		break;
		}
	case 1805: { // x:(r)-,x0 y1,y:(rh)-
		unhandled("x:(r)-,x0 y1,y:(rh)-");
		break;
		}
	case 1806: { // x:(r)-,x0 a,y:(rh)-
		unhandled("x:(r)-,x0 a,y:(rh)-");
		break;
		}
	case 1807: { // x:(r)-,x0 b,y:(rh)-
		unhandled("x:(r)-,x0 b,y:(rh)-");
		break;
		}
	case 1808: { // x:(r)-,x1 y0,y:(rh)-
		unhandled("x:(r)-,x1 y0,y:(rh)-");
		break;
		}
	case 1809: { // x:(r)-,x1 y1,y:(rh)-
		unhandled("x:(r)-,x1 y1,y:(rh)-");
		break;
		}
	case 1810: { // x:(r)-,x1 a,y:(rh)-
		unhandled("x:(r)-,x1 a,y:(rh)-");
		break;
		}
	case 1811: { // x:(r)-,x1 b,y:(rh)-
		unhandled("x:(r)-,x1 b,y:(rh)-");
		break;
		}
	case 1812: { // x:(r)-,a y0,y:(rh)-
		unhandled("x:(r)-,a y0,y:(rh)-");
		break;
		}
	case 1813: { // x:(r)-,a y1,y:(rh)-
		unhandled("x:(r)-,a y1,y:(rh)-");
		break;
		}
	case 1814: { // x:(r)-,a a,y:(rh)-
		unhandled("x:(r)-,a a,y:(rh)-");
		break;
		}
	case 1815: { // x:(r)-,a b,y:(rh)-
		unhandled("x:(r)-,a b,y:(rh)-");
		break;
		}
	case 1816: { // x:(r)-,b y0,y:(rh)-
		unhandled("x:(r)-,b y0,y:(rh)-");
		break;
		}
	case 1817: { // x:(r)-,b y1,y:(rh)-
		unhandled("x:(r)-,b y1,y:(rh)-");
		break;
		}
	case 1818: { // x:(r)-,b a,y:(rh)-
		unhandled("x:(r)-,b a,y:(rh)-");
		break;
		}
	case 1819: { // x:(r)-,b b,y:(rh)-
		unhandled("x:(r)-,b b,y:(rh)-");
		break;
		}
	case 1820: { // x:(r)-,x0 y0,y:(rh)+
		unhandled("x:(r)-,x0 y0,y:(rh)+");
		break;
		}
	case 1821: { // x:(r)-,x0 y1,y:(rh)+
		unhandled("x:(r)-,x0 y1,y:(rh)+");
		break;
		}
	case 1822: { // x:(r)-,x0 a,y:(rh)+
		unhandled("x:(r)-,x0 a,y:(rh)+");
		break;
		}
	case 1823: { // x:(r)-,x0 b,y:(rh)+
		unhandled("x:(r)-,x0 b,y:(rh)+");
		break;
		}
	case 1824: { // x:(r)-,x1 y0,y:(rh)+
		unhandled("x:(r)-,x1 y0,y:(rh)+");
		break;
		}
	case 1825: { // x:(r)-,x1 y1,y:(rh)+
		unhandled("x:(r)-,x1 y1,y:(rh)+");
		break;
		}
	case 1826: { // x:(r)-,x1 a,y:(rh)+
		unhandled("x:(r)-,x1 a,y:(rh)+");
		break;
		}
	case 1827: { // x:(r)-,x1 b,y:(rh)+
		unhandled("x:(r)-,x1 b,y:(rh)+");
		break;
		}
	case 1828: { // x:(r)-,a y0,y:(rh)+
		unhandled("x:(r)-,a y0,y:(rh)+");
		break;
		}
	case 1829: { // x:(r)-,a y1,y:(rh)+
		unhandled("x:(r)-,a y1,y:(rh)+");
		break;
		}
	case 1830: { // x:(r)-,a a,y:(rh)+
		unhandled("x:(r)-,a a,y:(rh)+");
		break;
		}
	case 1831: { // x:(r)-,a b,y:(rh)+
		unhandled("x:(r)-,a b,y:(rh)+");
		break;
		}
	case 1832: { // x:(r)-,b y0,y:(rh)+
		unhandled("x:(r)-,b y0,y:(rh)+");
		break;
		}
	case 1833: { // x:(r)-,b y1,y:(rh)+
		unhandled("x:(r)-,b y1,y:(rh)+");
		break;
		}
	case 1834: { // x:(r)-,b a,y:(rh)+
		unhandled("x:(r)-,b a,y:(rh)+");
		break;
		}
	case 1835: { // x:(r)-,b b,y:(rh)+
		unhandled("x:(r)-,b b,y:(rh)+");
		break;
		}
	case 1836: { // x:(r)-,x0 y0,y:(rh)
		unhandled("x:(r)-,x0 y0,y:(rh)");
		break;
		}
	case 1837: { // x:(r)-,x0 y1,y:(rh)
		unhandled("x:(r)-,x0 y1,y:(rh)");
		break;
		}
	case 1838: { // x:(r)-,x0 a,y:(rh)
		unhandled("x:(r)-,x0 a,y:(rh)");
		break;
		}
	case 1839: { // x:(r)-,x0 b,y:(rh)
		unhandled("x:(r)-,x0 b,y:(rh)");
		break;
		}
	case 1840: { // x:(r)-,x1 y0,y:(rh)
		unhandled("x:(r)-,x1 y0,y:(rh)");
		break;
		}
	case 1841: { // x:(r)-,x1 y1,y:(rh)
		unhandled("x:(r)-,x1 y1,y:(rh)");
		break;
		}
	case 1842: { // x:(r)-,x1 a,y:(rh)
		unhandled("x:(r)-,x1 a,y:(rh)");
		break;
		}
	case 1843: { // x:(r)-,x1 b,y:(rh)
		unhandled("x:(r)-,x1 b,y:(rh)");
		break;
		}
	case 1844: { // x:(r)-,a y0,y:(rh)
		unhandled("x:(r)-,a y0,y:(rh)");
		break;
		}
	case 1845: { // x:(r)-,a y1,y:(rh)
		unhandled("x:(r)-,a y1,y:(rh)");
		break;
		}
	case 1846: { // x:(r)-,a a,y:(rh)
		unhandled("x:(r)-,a a,y:(rh)");
		break;
		}
	case 1847: { // x:(r)-,a b,y:(rh)
		unhandled("x:(r)-,a b,y:(rh)");
		break;
		}
	case 1848: { // x:(r)-,b y0,y:(rh)
		unhandled("x:(r)-,b y0,y:(rh)");
		break;
		}
	case 1849: { // x:(r)-,b y1,y:(rh)
		unhandled("x:(r)-,b y1,y:(rh)");
		break;
		}
	case 1850: { // x:(r)-,b a,y:(rh)
		unhandled("x:(r)-,b a,y:(rh)");
		break;
		}
	case 1851: { // x:(r)-,b b,y:(rh)
		unhandled("x:(r)-,b b,y:(rh)");
		break;
		}
	case 1852: { // x:(r)+,x0 y0,y:(rh)+n
		unhandled("x:(r)+,x0 y0,y:(rh)+n");
		break;
		}
	case 1853: { // x:(r)+,x0 y1,y:(rh)+n
		unhandled("x:(r)+,x0 y1,y:(rh)+n");
		break;
		}
	case 1854: { // x:(r)+,x0 a,y:(rh)+n
		unhandled("x:(r)+,x0 a,y:(rh)+n");
		break;
		}
	case 1855: { // x:(r)+,x0 b,y:(rh)+n
		unhandled("x:(r)+,x0 b,y:(rh)+n");
		break;
		}
	case 1856: { // x:(r)+,x1 y0,y:(rh)+n
		unhandled("x:(r)+,x1 y0,y:(rh)+n");
		break;
		}
	case 1857: { // x:(r)+,x1 y1,y:(rh)+n
		unhandled("x:(r)+,x1 y1,y:(rh)+n");
		break;
		}
	case 1858: { // x:(r)+,x1 a,y:(rh)+n
		unhandled("x:(r)+,x1 a,y:(rh)+n");
		break;
		}
	case 1859: { // x:(r)+,x1 b,y:(rh)+n
		unhandled("x:(r)+,x1 b,y:(rh)+n");
		break;
		}
	case 1860: { // x:(r)+,a y0,y:(rh)+n
		unhandled("x:(r)+,a y0,y:(rh)+n");
		break;
		}
	case 1861: { // x:(r)+,a y1,y:(rh)+n
		unhandled("x:(r)+,a y1,y:(rh)+n");
		break;
		}
	case 1862: { // x:(r)+,a a,y:(rh)+n
		unhandled("x:(r)+,a a,y:(rh)+n");
		break;
		}
	case 1863: { // x:(r)+,a b,y:(rh)+n
		unhandled("x:(r)+,a b,y:(rh)+n");
		break;
		}
	case 1864: { // x:(r)+,b y0,y:(rh)+n
		unhandled("x:(r)+,b y0,y:(rh)+n");
		break;
		}
	case 1865: { // x:(r)+,b y1,y:(rh)+n
		unhandled("x:(r)+,b y1,y:(rh)+n");
		break;
		}
	case 1866: { // x:(r)+,b a,y:(rh)+n
		unhandled("x:(r)+,b a,y:(rh)+n");
		break;
		}
	case 1867: { // x:(r)+,b b,y:(rh)+n
		unhandled("x:(r)+,b b,y:(rh)+n");
		break;
		}
	case 1868: { // x:(r)+,x0 y0,y:(rh)-
		unhandled("x:(r)+,x0 y0,y:(rh)-");
		break;
		}
	case 1869: { // x:(r)+,x0 y1,y:(rh)-
		unhandled("x:(r)+,x0 y1,y:(rh)-");
		break;
		}
	case 1870: { // x:(r)+,x0 a,y:(rh)-
		unhandled("x:(r)+,x0 a,y:(rh)-");
		break;
		}
	case 1871: { // x:(r)+,x0 b,y:(rh)-
		unhandled("x:(r)+,x0 b,y:(rh)-");
		break;
		}
	case 1872: { // x:(r)+,x1 y0,y:(rh)-
		unhandled("x:(r)+,x1 y0,y:(rh)-");
		break;
		}
	case 1873: { // x:(r)+,x1 y1,y:(rh)-
		unhandled("x:(r)+,x1 y1,y:(rh)-");
		break;
		}
	case 1874: { // x:(r)+,x1 a,y:(rh)-
		unhandled("x:(r)+,x1 a,y:(rh)-");
		break;
		}
	case 1875: { // x:(r)+,x1 b,y:(rh)-
		unhandled("x:(r)+,x1 b,y:(rh)-");
		break;
		}
	case 1876: { // x:(r)+,a y0,y:(rh)-
		unhandled("x:(r)+,a y0,y:(rh)-");
		break;
		}
	case 1877: { // x:(r)+,a y1,y:(rh)-
		unhandled("x:(r)+,a y1,y:(rh)-");
		break;
		}
	case 1878: { // x:(r)+,a a,y:(rh)-
		unhandled("x:(r)+,a a,y:(rh)-");
		break;
		}
	case 1879: { // x:(r)+,a b,y:(rh)-
		unhandled("x:(r)+,a b,y:(rh)-");
		break;
		}
	case 1880: { // x:(r)+,b y0,y:(rh)-
		unhandled("x:(r)+,b y0,y:(rh)-");
		break;
		}
	case 1881: { // x:(r)+,b y1,y:(rh)-
		unhandled("x:(r)+,b y1,y:(rh)-");
		break;
		}
	case 1882: { // x:(r)+,b a,y:(rh)-
		unhandled("x:(r)+,b a,y:(rh)-");
		break;
		}
	case 1883: { // x:(r)+,b b,y:(rh)-
		unhandled("x:(r)+,b b,y:(rh)-");
		break;
		}
	case 1884: { // x:(r)+,x0 y0,y:(rh)+
		unhandled("x:(r)+,x0 y0,y:(rh)+");
		break;
		}
	case 1885: { // x:(r)+,x0 y1,y:(rh)+
		unhandled("x:(r)+,x0 y1,y:(rh)+");
		break;
		}
	case 1886: { // x:(r)+,x0 a,y:(rh)+
		unhandled("x:(r)+,x0 a,y:(rh)+");
		break;
		}
	case 1887: { // x:(r)+,x0 b,y:(rh)+
		unhandled("x:(r)+,x0 b,y:(rh)+");
		break;
		}
	case 1888: { // x:(r)+,x1 y0,y:(rh)+
		unhandled("x:(r)+,x1 y0,y:(rh)+");
		break;
		}
	case 1889: { // x:(r)+,x1 y1,y:(rh)+
		unhandled("x:(r)+,x1 y1,y:(rh)+");
		break;
		}
	case 1890: { // x:(r)+,x1 a,y:(rh)+
		unhandled("x:(r)+,x1 a,y:(rh)+");
		break;
		}
	case 1891: { // x:(r)+,x1 b,y:(rh)+
		unhandled("x:(r)+,x1 b,y:(rh)+");
		break;
		}
	case 1892: { // x:(r)+,a y0,y:(rh)+
		unhandled("x:(r)+,a y0,y:(rh)+");
		break;
		}
	case 1893: { // x:(r)+,a y1,y:(rh)+
		unhandled("x:(r)+,a y1,y:(rh)+");
		break;
		}
	case 1894: { // x:(r)+,a a,y:(rh)+
		unhandled("x:(r)+,a a,y:(rh)+");
		break;
		}
	case 1895: { // x:(r)+,a b,y:(rh)+
		unhandled("x:(r)+,a b,y:(rh)+");
		break;
		}
	case 1896: { // x:(r)+,b y0,y:(rh)+
		unhandled("x:(r)+,b y0,y:(rh)+");
		break;
		}
	case 1897: { // x:(r)+,b y1,y:(rh)+
		unhandled("x:(r)+,b y1,y:(rh)+");
		break;
		}
	case 1898: { // x:(r)+,b a,y:(rh)+
		unhandled("x:(r)+,b a,y:(rh)+");
		break;
		}
	case 1899: { // x:(r)+,b b,y:(rh)+
		unhandled("x:(r)+,b b,y:(rh)+");
		break;
		}
	case 1900: { // x:(r)+,x0 y0,y:(rh)
		unhandled("x:(r)+,x0 y0,y:(rh)");
		break;
		}
	case 1901: { // x:(r)+,x0 y1,y:(rh)
		unhandled("x:(r)+,x0 y1,y:(rh)");
		break;
		}
	case 1902: { // x:(r)+,x0 a,y:(rh)
		unhandled("x:(r)+,x0 a,y:(rh)");
		break;
		}
	case 1903: { // x:(r)+,x0 b,y:(rh)
		unhandled("x:(r)+,x0 b,y:(rh)");
		break;
		}
	case 1904: { // x:(r)+,x1 y0,y:(rh)
		unhandled("x:(r)+,x1 y0,y:(rh)");
		break;
		}
	case 1905: { // x:(r)+,x1 y1,y:(rh)
		unhandled("x:(r)+,x1 y1,y:(rh)");
		break;
		}
	case 1906: { // x:(r)+,x1 a,y:(rh)
		unhandled("x:(r)+,x1 a,y:(rh)");
		break;
		}
	case 1907: { // x:(r)+,x1 b,y:(rh)
		unhandled("x:(r)+,x1 b,y:(rh)");
		break;
		}
	case 1908: { // x:(r)+,a y0,y:(rh)
		unhandled("x:(r)+,a y0,y:(rh)");
		break;
		}
	case 1909: { // x:(r)+,a y1,y:(rh)
		unhandled("x:(r)+,a y1,y:(rh)");
		break;
		}
	case 1910: { // x:(r)+,a a,y:(rh)
		unhandled("x:(r)+,a a,y:(rh)");
		break;
		}
	case 1911: { // x:(r)+,a b,y:(rh)
		unhandled("x:(r)+,a b,y:(rh)");
		break;
		}
	case 1912: { // x:(r)+,b y0,y:(rh)
		unhandled("x:(r)+,b y0,y:(rh)");
		break;
		}
	case 1913: { // x:(r)+,b y1,y:(rh)
		unhandled("x:(r)+,b y1,y:(rh)");
		break;
		}
	case 1914: { // x:(r)+,b a,y:(rh)
		unhandled("x:(r)+,b a,y:(rh)");
		break;
		}
	case 1915: { // x:(r)+,b b,y:(rh)
		unhandled("x:(r)+,b b,y:(rh)");
		break;
		}
	case 1916: { // x:(r),x0 y0,y:(rh)+n
		unhandled("x:(r),x0 y0,y:(rh)+n");
		break;
		}
	case 1917: { // x:(r),x0 y1,y:(rh)+n
		unhandled("x:(r),x0 y1,y:(rh)+n");
		break;
		}
	case 1918: { // x:(r),x0 a,y:(rh)+n
		unhandled("x:(r),x0 a,y:(rh)+n");
		break;
		}
	case 1919: { // x:(r),x0 b,y:(rh)+n
		unhandled("x:(r),x0 b,y:(rh)+n");
		break;
		}
	case 1920: { // x:(r),x1 y0,y:(rh)+n
		unhandled("x:(r),x1 y0,y:(rh)+n");
		break;
		}
	case 1921: { // x:(r),x1 y1,y:(rh)+n
		unhandled("x:(r),x1 y1,y:(rh)+n");
		break;
		}
	case 1922: { // x:(r),x1 a,y:(rh)+n
		unhandled("x:(r),x1 a,y:(rh)+n");
		break;
		}
	case 1923: { // x:(r),x1 b,y:(rh)+n
		unhandled("x:(r),x1 b,y:(rh)+n");
		break;
		}
	case 1924: { // x:(r),a y0,y:(rh)+n
		unhandled("x:(r),a y0,y:(rh)+n");
		break;
		}
	case 1925: { // x:(r),a y1,y:(rh)+n
		unhandled("x:(r),a y1,y:(rh)+n");
		break;
		}
	case 1926: { // x:(r),a a,y:(rh)+n
		unhandled("x:(r),a a,y:(rh)+n");
		break;
		}
	case 1927: { // x:(r),a b,y:(rh)+n
		unhandled("x:(r),a b,y:(rh)+n");
		break;
		}
	case 1928: { // x:(r),b y0,y:(rh)+n
		unhandled("x:(r),b y0,y:(rh)+n");
		break;
		}
	case 1929: { // x:(r),b y1,y:(rh)+n
		unhandled("x:(r),b y1,y:(rh)+n");
		break;
		}
	case 1930: { // x:(r),b a,y:(rh)+n
		unhandled("x:(r),b a,y:(rh)+n");
		break;
		}
	case 1931: { // x:(r),b b,y:(rh)+n
		unhandled("x:(r),b b,y:(rh)+n");
		break;
		}
	case 1932: { // x:(r),x0 y0,y:(rh)-
		unhandled("x:(r),x0 y0,y:(rh)-");
		break;
		}
	case 1933: { // x:(r),x0 y1,y:(rh)-
		unhandled("x:(r),x0 y1,y:(rh)-");
		break;
		}
	case 1934: { // x:(r),x0 a,y:(rh)-
		unhandled("x:(r),x0 a,y:(rh)-");
		break;
		}
	case 1935: { // x:(r),x0 b,y:(rh)-
		unhandled("x:(r),x0 b,y:(rh)-");
		break;
		}
	case 1936: { // x:(r),x1 y0,y:(rh)-
		unhandled("x:(r),x1 y0,y:(rh)-");
		break;
		}
	case 1937: { // x:(r),x1 y1,y:(rh)-
		unhandled("x:(r),x1 y1,y:(rh)-");
		break;
		}
	case 1938: { // x:(r),x1 a,y:(rh)-
		unhandled("x:(r),x1 a,y:(rh)-");
		break;
		}
	case 1939: { // x:(r),x1 b,y:(rh)-
		unhandled("x:(r),x1 b,y:(rh)-");
		break;
		}
	case 1940: { // x:(r),a y0,y:(rh)-
		unhandled("x:(r),a y0,y:(rh)-");
		break;
		}
	case 1941: { // x:(r),a y1,y:(rh)-
		unhandled("x:(r),a y1,y:(rh)-");
		break;
		}
	case 1942: { // x:(r),a a,y:(rh)-
		unhandled("x:(r),a a,y:(rh)-");
		break;
		}
	case 1943: { // x:(r),a b,y:(rh)-
		unhandled("x:(r),a b,y:(rh)-");
		break;
		}
	case 1944: { // x:(r),b y0,y:(rh)-
		unhandled("x:(r),b y0,y:(rh)-");
		break;
		}
	case 1945: { // x:(r),b y1,y:(rh)-
		unhandled("x:(r),b y1,y:(rh)-");
		break;
		}
	case 1946: { // x:(r),b a,y:(rh)-
		unhandled("x:(r),b a,y:(rh)-");
		break;
		}
	case 1947: { // x:(r),b b,y:(rh)-
		unhandled("x:(r),b b,y:(rh)-");
		break;
		}
	case 1948: { // x:(r),x0 y0,y:(rh)+
		unhandled("x:(r),x0 y0,y:(rh)+");
		break;
		}
	case 1949: { // x:(r),x0 y1,y:(rh)+
		unhandled("x:(r),x0 y1,y:(rh)+");
		break;
		}
	case 1950: { // x:(r),x0 a,y:(rh)+
		unhandled("x:(r),x0 a,y:(rh)+");
		break;
		}
	case 1951: { // x:(r),x0 b,y:(rh)+
		unhandled("x:(r),x0 b,y:(rh)+");
		break;
		}
	case 1952: { // x:(r),x1 y0,y:(rh)+
		unhandled("x:(r),x1 y0,y:(rh)+");
		break;
		}
	case 1953: { // x:(r),x1 y1,y:(rh)+
		unhandled("x:(r),x1 y1,y:(rh)+");
		break;
		}
	case 1954: { // x:(r),x1 a,y:(rh)+
		unhandled("x:(r),x1 a,y:(rh)+");
		break;
		}
	case 1955: { // x:(r),x1 b,y:(rh)+
		unhandled("x:(r),x1 b,y:(rh)+");
		break;
		}
	case 1956: { // x:(r),a y0,y:(rh)+
		unhandled("x:(r),a y0,y:(rh)+");
		break;
		}
	case 1957: { // x:(r),a y1,y:(rh)+
		unhandled("x:(r),a y1,y:(rh)+");
		break;
		}
	case 1958: { // x:(r),a a,y:(rh)+
		unhandled("x:(r),a a,y:(rh)+");
		break;
		}
	case 1959: { // x:(r),a b,y:(rh)+
		unhandled("x:(r),a b,y:(rh)+");
		break;
		}
	case 1960: { // x:(r),b y0,y:(rh)+
		unhandled("x:(r),b y0,y:(rh)+");
		break;
		}
	case 1961: { // x:(r),b y1,y:(rh)+
		unhandled("x:(r),b y1,y:(rh)+");
		break;
		}
	case 1962: { // x:(r),b a,y:(rh)+
		unhandled("x:(r),b a,y:(rh)+");
		break;
		}
	case 1963: { // x:(r),b b,y:(rh)+
		unhandled("x:(r),b b,y:(rh)+");
		break;
		}
	case 1964: { // x:(r),x0 y0,y:(rh)
		unhandled("x:(r),x0 y0,y:(rh)");
		break;
		}
	case 1965: { // x:(r),x0 y1,y:(rh)
		unhandled("x:(r),x0 y1,y:(rh)");
		break;
		}
	case 1966: { // x:(r),x0 a,y:(rh)
		unhandled("x:(r),x0 a,y:(rh)");
		break;
		}
	case 1967: { // x:(r),x0 b,y:(rh)
		unhandled("x:(r),x0 b,y:(rh)");
		break;
		}
	case 1968: { // x:(r),x1 y0,y:(rh)
		unhandled("x:(r),x1 y0,y:(rh)");
		break;
		}
	case 1969: { // x:(r),x1 y1,y:(rh)
		unhandled("x:(r),x1 y1,y:(rh)");
		break;
		}
	case 1970: { // x:(r),x1 a,y:(rh)
		unhandled("x:(r),x1 a,y:(rh)");
		break;
		}
	case 1971: { // x:(r),x1 b,y:(rh)
		unhandled("x:(r),x1 b,y:(rh)");
		break;
		}
	case 1972: { // x:(r),a y0,y:(rh)
		unhandled("x:(r),a y0,y:(rh)");
		break;
		}
	case 1973: { // x:(r),a y1,y:(rh)
		unhandled("x:(r),a y1,y:(rh)");
		break;
		}
	case 1974: { // x:(r),a a,y:(rh)
		unhandled("x:(r),a a,y:(rh)");
		break;
		}
	case 1975: { // x:(r),a b,y:(rh)
		unhandled("x:(r),a b,y:(rh)");
		break;
		}
	case 1976: { // x:(r),b y0,y:(rh)
		unhandled("x:(r),b y0,y:(rh)");
		break;
		}
	case 1977: { // x:(r),b y1,y:(rh)
		unhandled("x:(r),b y1,y:(rh)");
		break;
		}
	case 1978: { // x:(r),b a,y:(rh)
		unhandled("x:(r),b a,y:(rh)");
		break;
		}
	case 1979: { // x:(r),b b,y:(rh)
		unhandled("x:(r),b b,y:(rh)");
		break;
		}
	case 1980: { // x0,x:(r)+n y:(rh)+n,y0
		unhandled("x0,x:(r)+n y:(rh)+n,y0");
		break;
		}
	case 1981: { // x0,x:(r)+n y:(rh)+n,y1
		unhandled("x0,x:(r)+n y:(rh)+n,y1");
		break;
		}
	case 1982: { // x0,x:(r)+n y:(rh)+n,a
		unhandled("x0,x:(r)+n y:(rh)+n,a");
		break;
		}
	case 1983: { // x0,x:(r)+n y:(rh)+n,b
		unhandled("x0,x:(r)+n y:(rh)+n,b");
		break;
		}
	case 1984: { // x1,x:(r)+n y:(rh)+n,y0
		unhandled("x1,x:(r)+n y:(rh)+n,y0");
		break;
		}
	case 1985: { // x1,x:(r)+n y:(rh)+n,y1
		unhandled("x1,x:(r)+n y:(rh)+n,y1");
		break;
		}
	case 1986: { // x1,x:(r)+n y:(rh)+n,a
		unhandled("x1,x:(r)+n y:(rh)+n,a");
		break;
		}
	case 1987: { // x1,x:(r)+n y:(rh)+n,b
		unhandled("x1,x:(r)+n y:(rh)+n,b");
		break;
		}
	case 1988: { // a,x:(r)+n y:(rh)+n,y0
		unhandled("a,x:(r)+n y:(rh)+n,y0");
		break;
		}
	case 1989: { // a,x:(r)+n y:(rh)+n,y1
		unhandled("a,x:(r)+n y:(rh)+n,y1");
		break;
		}
	case 1990: { // a,x:(r)+n y:(rh)+n,a
		unhandled("a,x:(r)+n y:(rh)+n,a");
		break;
		}
	case 1991: { // a,x:(r)+n y:(rh)+n,b
		unhandled("a,x:(r)+n y:(rh)+n,b");
		break;
		}
	case 1992: { // b,x:(r)+n y:(rh)+n,y0
		unhandled("b,x:(r)+n y:(rh)+n,y0");
		break;
		}
	case 1993: { // b,x:(r)+n y:(rh)+n,y1
		unhandled("b,x:(r)+n y:(rh)+n,y1");
		break;
		}
	case 1994: { // b,x:(r)+n y:(rh)+n,a
		unhandled("b,x:(r)+n y:(rh)+n,a");
		break;
		}
	case 1995: { // b,x:(r)+n y:(rh)+n,b
		unhandled("b,x:(r)+n y:(rh)+n,b");
		break;
		}
	case 1996: { // x0,x:(r)+n y:(rh)-,y0
		unhandled("x0,x:(r)+n y:(rh)-,y0");
		break;
		}
	case 1997: { // x0,x:(r)+n y:(rh)-,y1
		unhandled("x0,x:(r)+n y:(rh)-,y1");
		break;
		}
	case 1998: { // x0,x:(r)+n y:(rh)-,a
		unhandled("x0,x:(r)+n y:(rh)-,a");
		break;
		}
	case 1999: { // x0,x:(r)+n y:(rh)-,b
		unhandled("x0,x:(r)+n y:(rh)-,b");
		break;
		}
	case 2000: { // x1,x:(r)+n y:(rh)-,y0
		unhandled("x1,x:(r)+n y:(rh)-,y0");
		break;
		}
	case 2001: { // x1,x:(r)+n y:(rh)-,y1
		unhandled("x1,x:(r)+n y:(rh)-,y1");
		break;
		}
	case 2002: { // x1,x:(r)+n y:(rh)-,a
		unhandled("x1,x:(r)+n y:(rh)-,a");
		break;
		}
	case 2003: { // x1,x:(r)+n y:(rh)-,b
		unhandled("x1,x:(r)+n y:(rh)-,b");
		break;
		}
	case 2004: { // a,x:(r)+n y:(rh)-,y0
		unhandled("a,x:(r)+n y:(rh)-,y0");
		break;
		}
	case 2005: { // a,x:(r)+n y:(rh)-,y1
		unhandled("a,x:(r)+n y:(rh)-,y1");
		break;
		}
	case 2006: { // a,x:(r)+n y:(rh)-,a
		unhandled("a,x:(r)+n y:(rh)-,a");
		break;
		}
	case 2007: { // a,x:(r)+n y:(rh)-,b
		unhandled("a,x:(r)+n y:(rh)-,b");
		break;
		}
	case 2008: { // b,x:(r)+n y:(rh)-,y0
		unhandled("b,x:(r)+n y:(rh)-,y0");
		break;
		}
	case 2009: { // b,x:(r)+n y:(rh)-,y1
		unhandled("b,x:(r)+n y:(rh)-,y1");
		break;
		}
	case 2010: { // b,x:(r)+n y:(rh)-,a
		unhandled("b,x:(r)+n y:(rh)-,a");
		break;
		}
	case 2011: { // b,x:(r)+n y:(rh)-,b
		unhandled("b,x:(r)+n y:(rh)-,b");
		break;
		}
	case 2012: { // x0,x:(r)+n y:(rh)+,y0
		unhandled("x0,x:(r)+n y:(rh)+,y0");
		break;
		}
	case 2013: { // x0,x:(r)+n y:(rh)+,y1
		unhandled("x0,x:(r)+n y:(rh)+,y1");
		break;
		}
	case 2014: { // x0,x:(r)+n y:(rh)+,a
		unhandled("x0,x:(r)+n y:(rh)+,a");
		break;
		}
	case 2015: { // x0,x:(r)+n y:(rh)+,b
		unhandled("x0,x:(r)+n y:(rh)+,b");
		break;
		}
	case 2016: { // x1,x:(r)+n y:(rh)+,y0
		unhandled("x1,x:(r)+n y:(rh)+,y0");
		break;
		}
	case 2017: { // x1,x:(r)+n y:(rh)+,y1
		unhandled("x1,x:(r)+n y:(rh)+,y1");
		break;
		}
	case 2018: { // x1,x:(r)+n y:(rh)+,a
		unhandled("x1,x:(r)+n y:(rh)+,a");
		break;
		}
	case 2019: { // x1,x:(r)+n y:(rh)+,b
		unhandled("x1,x:(r)+n y:(rh)+,b");
		break;
		}
	case 2020: { // a,x:(r)+n y:(rh)+,y0
		unhandled("a,x:(r)+n y:(rh)+,y0");
		break;
		}
	case 2021: { // a,x:(r)+n y:(rh)+,y1
		unhandled("a,x:(r)+n y:(rh)+,y1");
		break;
		}
	case 2022: { // a,x:(r)+n y:(rh)+,a
		unhandled("a,x:(r)+n y:(rh)+,a");
		break;
		}
	case 2023: { // a,x:(r)+n y:(rh)+,b
		unhandled("a,x:(r)+n y:(rh)+,b");
		break;
		}
	case 2024: { // b,x:(r)+n y:(rh)+,y0
		unhandled("b,x:(r)+n y:(rh)+,y0");
		break;
		}
	case 2025: { // b,x:(r)+n y:(rh)+,y1
		unhandled("b,x:(r)+n y:(rh)+,y1");
		break;
		}
	case 2026: { // b,x:(r)+n y:(rh)+,a
		unhandled("b,x:(r)+n y:(rh)+,a");
		break;
		}
	case 2027: { // b,x:(r)+n y:(rh)+,b
		unhandled("b,x:(r)+n y:(rh)+,b");
		break;
		}
	case 2028: { // x0,x:(r)+n y:(rh),y0
		unhandled("x0,x:(r)+n y:(rh),y0");
		break;
		}
	case 2029: { // x0,x:(r)+n y:(rh),y1
		unhandled("x0,x:(r)+n y:(rh),y1");
		break;
		}
	case 2030: { // x0,x:(r)+n y:(rh),a
		unhandled("x0,x:(r)+n y:(rh),a");
		break;
		}
	case 2031: { // x0,x:(r)+n y:(rh),b
		unhandled("x0,x:(r)+n y:(rh),b");
		break;
		}
	case 2032: { // x1,x:(r)+n y:(rh),y0
		unhandled("x1,x:(r)+n y:(rh),y0");
		break;
		}
	case 2033: { // x1,x:(r)+n y:(rh),y1
		unhandled("x1,x:(r)+n y:(rh),y1");
		break;
		}
	case 2034: { // x1,x:(r)+n y:(rh),a
		unhandled("x1,x:(r)+n y:(rh),a");
		break;
		}
	case 2035: { // x1,x:(r)+n y:(rh),b
		unhandled("x1,x:(r)+n y:(rh),b");
		break;
		}
	case 2036: { // a,x:(r)+n y:(rh),y0
		unhandled("a,x:(r)+n y:(rh),y0");
		break;
		}
	case 2037: { // a,x:(r)+n y:(rh),y1
		unhandled("a,x:(r)+n y:(rh),y1");
		break;
		}
	case 2038: { // a,x:(r)+n y:(rh),a
		unhandled("a,x:(r)+n y:(rh),a");
		break;
		}
	case 2039: { // a,x:(r)+n y:(rh),b
		unhandled("a,x:(r)+n y:(rh),b");
		break;
		}
	case 2040: { // b,x:(r)+n y:(rh),y0
		unhandled("b,x:(r)+n y:(rh),y0");
		break;
		}
	case 2041: { // b,x:(r)+n y:(rh),y1
		unhandled("b,x:(r)+n y:(rh),y1");
		break;
		}
	case 2042: { // b,x:(r)+n y:(rh),a
		unhandled("b,x:(r)+n y:(rh),a");
		break;
		}
	case 2043: { // b,x:(r)+n y:(rh),b
		unhandled("b,x:(r)+n y:(rh),b");
		break;
		}
	case 2044: { // x0,x:(r)- y:(rh)+n,y0
		unhandled("x0,x:(r)- y:(rh)+n,y0");
		break;
		}
	case 2045: { // x0,x:(r)- y:(rh)+n,y1
		unhandled("x0,x:(r)- y:(rh)+n,y1");
		break;
		}
	case 2046: { // x0,x:(r)- y:(rh)+n,a
		unhandled("x0,x:(r)- y:(rh)+n,a");
		break;
		}
	case 2047: { // x0,x:(r)- y:(rh)+n,b
		unhandled("x0,x:(r)- y:(rh)+n,b");
		break;
		}
	case 2048: { // x1,x:(r)- y:(rh)+n,y0
		unhandled("x1,x:(r)- y:(rh)+n,y0");
		break;
		}
	case 2049: { // x1,x:(r)- y:(rh)+n,y1
		unhandled("x1,x:(r)- y:(rh)+n,y1");
		break;
		}
	case 2050: { // x1,x:(r)- y:(rh)+n,a
		unhandled("x1,x:(r)- y:(rh)+n,a");
		break;
		}
	case 2051: { // x1,x:(r)- y:(rh)+n,b
		unhandled("x1,x:(r)- y:(rh)+n,b");
		break;
		}
	case 2052: { // a,x:(r)- y:(rh)+n,y0
		unhandled("a,x:(r)- y:(rh)+n,y0");
		break;
		}
	case 2053: { // a,x:(r)- y:(rh)+n,y1
		unhandled("a,x:(r)- y:(rh)+n,y1");
		break;
		}
	case 2054: { // a,x:(r)- y:(rh)+n,a
		unhandled("a,x:(r)- y:(rh)+n,a");
		break;
		}
	case 2055: { // a,x:(r)- y:(rh)+n,b
		unhandled("a,x:(r)- y:(rh)+n,b");
		break;
		}
	case 2056: { // b,x:(r)- y:(rh)+n,y0
		unhandled("b,x:(r)- y:(rh)+n,y0");
		break;
		}
	case 2057: { // b,x:(r)- y:(rh)+n,y1
		unhandled("b,x:(r)- y:(rh)+n,y1");
		break;
		}
	case 2058: { // b,x:(r)- y:(rh)+n,a
		unhandled("b,x:(r)- y:(rh)+n,a");
		break;
		}
	case 2059: { // b,x:(r)- y:(rh)+n,b
		unhandled("b,x:(r)- y:(rh)+n,b");
		break;
		}
	case 2060: { // x0,x:(r)- y:(rh)-,y0
		unhandled("x0,x:(r)- y:(rh)-,y0");
		break;
		}
	case 2061: { // x0,x:(r)- y:(rh)-,y1
		unhandled("x0,x:(r)- y:(rh)-,y1");
		break;
		}
	case 2062: { // x0,x:(r)- y:(rh)-,a
		unhandled("x0,x:(r)- y:(rh)-,a");
		break;
		}
	case 2063: { // x0,x:(r)- y:(rh)-,b
		unhandled("x0,x:(r)- y:(rh)-,b");
		break;
		}
	case 2064: { // x1,x:(r)- y:(rh)-,y0
		unhandled("x1,x:(r)- y:(rh)-,y0");
		break;
		}
	case 2065: { // x1,x:(r)- y:(rh)-,y1
		unhandled("x1,x:(r)- y:(rh)-,y1");
		break;
		}
	case 2066: { // x1,x:(r)- y:(rh)-,a
		unhandled("x1,x:(r)- y:(rh)-,a");
		break;
		}
	case 2067: { // x1,x:(r)- y:(rh)-,b
		unhandled("x1,x:(r)- y:(rh)-,b");
		break;
		}
	case 2068: { // a,x:(r)- y:(rh)-,y0
		unhandled("a,x:(r)- y:(rh)-,y0");
		break;
		}
	case 2069: { // a,x:(r)- y:(rh)-,y1
		unhandled("a,x:(r)- y:(rh)-,y1");
		break;
		}
	case 2070: { // a,x:(r)- y:(rh)-,a
		unhandled("a,x:(r)- y:(rh)-,a");
		break;
		}
	case 2071: { // a,x:(r)- y:(rh)-,b
		unhandled("a,x:(r)- y:(rh)-,b");
		break;
		}
	case 2072: { // b,x:(r)- y:(rh)-,y0
		unhandled("b,x:(r)- y:(rh)-,y0");
		break;
		}
	case 2073: { // b,x:(r)- y:(rh)-,y1
		unhandled("b,x:(r)- y:(rh)-,y1");
		break;
		}
	case 2074: { // b,x:(r)- y:(rh)-,a
		unhandled("b,x:(r)- y:(rh)-,a");
		break;
		}
	case 2075: { // b,x:(r)- y:(rh)-,b
		unhandled("b,x:(r)- y:(rh)-,b");
		break;
		}
	case 2076: { // x0,x:(r)- y:(rh)+,y0
		unhandled("x0,x:(r)- y:(rh)+,y0");
		break;
		}
	case 2077: { // x0,x:(r)- y:(rh)+,y1
		unhandled("x0,x:(r)- y:(rh)+,y1");
		break;
		}
	case 2078: { // x0,x:(r)- y:(rh)+,a
		unhandled("x0,x:(r)- y:(rh)+,a");
		break;
		}
	case 2079: { // x0,x:(r)- y:(rh)+,b
		unhandled("x0,x:(r)- y:(rh)+,b");
		break;
		}
	case 2080: { // x1,x:(r)- y:(rh)+,y0
		unhandled("x1,x:(r)- y:(rh)+,y0");
		break;
		}
	case 2081: { // x1,x:(r)- y:(rh)+,y1
		unhandled("x1,x:(r)- y:(rh)+,y1");
		break;
		}
	case 2082: { // x1,x:(r)- y:(rh)+,a
		unhandled("x1,x:(r)- y:(rh)+,a");
		break;
		}
	case 2083: { // x1,x:(r)- y:(rh)+,b
		unhandled("x1,x:(r)- y:(rh)+,b");
		break;
		}
	case 2084: { // a,x:(r)- y:(rh)+,y0
		unhandled("a,x:(r)- y:(rh)+,y0");
		break;
		}
	case 2085: { // a,x:(r)- y:(rh)+,y1
		unhandled("a,x:(r)- y:(rh)+,y1");
		break;
		}
	case 2086: { // a,x:(r)- y:(rh)+,a
		unhandled("a,x:(r)- y:(rh)+,a");
		break;
		}
	case 2087: { // a,x:(r)- y:(rh)+,b
		unhandled("a,x:(r)- y:(rh)+,b");
		break;
		}
	case 2088: { // b,x:(r)- y:(rh)+,y0
		unhandled("b,x:(r)- y:(rh)+,y0");
		break;
		}
	case 2089: { // b,x:(r)- y:(rh)+,y1
		unhandled("b,x:(r)- y:(rh)+,y1");
		break;
		}
	case 2090: { // b,x:(r)- y:(rh)+,a
		unhandled("b,x:(r)- y:(rh)+,a");
		break;
		}
	case 2091: { // b,x:(r)- y:(rh)+,b
		unhandled("b,x:(r)- y:(rh)+,b");
		break;
		}
	case 2092: { // x0,x:(r)- y:(rh),y0
		unhandled("x0,x:(r)- y:(rh),y0");
		break;
		}
	case 2093: { // x0,x:(r)- y:(rh),y1
		unhandled("x0,x:(r)- y:(rh),y1");
		break;
		}
	case 2094: { // x0,x:(r)- y:(rh),a
		unhandled("x0,x:(r)- y:(rh),a");
		break;
		}
	case 2095: { // x0,x:(r)- y:(rh),b
		unhandled("x0,x:(r)- y:(rh),b");
		break;
		}
	case 2096: { // x1,x:(r)- y:(rh),y0
		unhandled("x1,x:(r)- y:(rh),y0");
		break;
		}
	case 2097: { // x1,x:(r)- y:(rh),y1
		unhandled("x1,x:(r)- y:(rh),y1");
		break;
		}
	case 2098: { // x1,x:(r)- y:(rh),a
		unhandled("x1,x:(r)- y:(rh),a");
		break;
		}
	case 2099: { // x1,x:(r)- y:(rh),b
		unhandled("x1,x:(r)- y:(rh),b");
		break;
		}
	case 2100: { // a,x:(r)- y:(rh),y0
		unhandled("a,x:(r)- y:(rh),y0");
		break;
		}
	case 2101: { // a,x:(r)- y:(rh),y1
		unhandled("a,x:(r)- y:(rh),y1");
		break;
		}
	case 2102: { // a,x:(r)- y:(rh),a
		unhandled("a,x:(r)- y:(rh),a");
		break;
		}
	case 2103: { // a,x:(r)- y:(rh),b
		unhandled("a,x:(r)- y:(rh),b");
		break;
		}
	case 2104: { // b,x:(r)- y:(rh),y0
		unhandled("b,x:(r)- y:(rh),y0");
		break;
		}
	case 2105: { // b,x:(r)- y:(rh),y1
		unhandled("b,x:(r)- y:(rh),y1");
		break;
		}
	case 2106: { // b,x:(r)- y:(rh),a
		unhandled("b,x:(r)- y:(rh),a");
		break;
		}
	case 2107: { // b,x:(r)- y:(rh),b
		unhandled("b,x:(r)- y:(rh),b");
		break;
		}
	case 2108: { // x0,x:(r)+ y:(rh)+n,y0
		unhandled("x0,x:(r)+ y:(rh)+n,y0");
		break;
		}
	case 2109: { // x0,x:(r)+ y:(rh)+n,y1
		unhandled("x0,x:(r)+ y:(rh)+n,y1");
		break;
		}
	case 2110: { // x0,x:(r)+ y:(rh)+n,a
		unhandled("x0,x:(r)+ y:(rh)+n,a");
		break;
		}
	case 2111: { // x0,x:(r)+ y:(rh)+n,b
		unhandled("x0,x:(r)+ y:(rh)+n,b");
		break;
		}
	case 2112: { // x1,x:(r)+ y:(rh)+n,y0
		unhandled("x1,x:(r)+ y:(rh)+n,y0");
		break;
		}
	case 2113: { // x1,x:(r)+ y:(rh)+n,y1
		unhandled("x1,x:(r)+ y:(rh)+n,y1");
		break;
		}
	case 2114: { // x1,x:(r)+ y:(rh)+n,a
		unhandled("x1,x:(r)+ y:(rh)+n,a");
		break;
		}
	case 2115: { // x1,x:(r)+ y:(rh)+n,b
		unhandled("x1,x:(r)+ y:(rh)+n,b");
		break;
		}
	case 2116: { // a,x:(r)+ y:(rh)+n,y0
		unhandled("a,x:(r)+ y:(rh)+n,y0");
		break;
		}
	case 2117: { // a,x:(r)+ y:(rh)+n,y1
		unhandled("a,x:(r)+ y:(rh)+n,y1");
		break;
		}
	case 2118: { // a,x:(r)+ y:(rh)+n,a
		unhandled("a,x:(r)+ y:(rh)+n,a");
		break;
		}
	case 2119: { // a,x:(r)+ y:(rh)+n,b
		unhandled("a,x:(r)+ y:(rh)+n,b");
		break;
		}
	case 2120: { // b,x:(r)+ y:(rh)+n,y0
		unhandled("b,x:(r)+ y:(rh)+n,y0");
		break;
		}
	case 2121: { // b,x:(r)+ y:(rh)+n,y1
		unhandled("b,x:(r)+ y:(rh)+n,y1");
		break;
		}
	case 2122: { // b,x:(r)+ y:(rh)+n,a
		unhandled("b,x:(r)+ y:(rh)+n,a");
		break;
		}
	case 2123: { // b,x:(r)+ y:(rh)+n,b
		unhandled("b,x:(r)+ y:(rh)+n,b");
		break;
		}
	case 2124: { // x0,x:(r)+ y:(rh)-,y0
		unhandled("x0,x:(r)+ y:(rh)-,y0");
		break;
		}
	case 2125: { // x0,x:(r)+ y:(rh)-,y1
		unhandled("x0,x:(r)+ y:(rh)-,y1");
		break;
		}
	case 2126: { // x0,x:(r)+ y:(rh)-,a
		unhandled("x0,x:(r)+ y:(rh)-,a");
		break;
		}
	case 2127: { // x0,x:(r)+ y:(rh)-,b
		unhandled("x0,x:(r)+ y:(rh)-,b");
		break;
		}
	case 2128: { // x1,x:(r)+ y:(rh)-,y0
		unhandled("x1,x:(r)+ y:(rh)-,y0");
		break;
		}
	case 2129: { // x1,x:(r)+ y:(rh)-,y1
		unhandled("x1,x:(r)+ y:(rh)-,y1");
		break;
		}
	case 2130: { // x1,x:(r)+ y:(rh)-,a
		unhandled("x1,x:(r)+ y:(rh)-,a");
		break;
		}
	case 2131: { // x1,x:(r)+ y:(rh)-,b
		unhandled("x1,x:(r)+ y:(rh)-,b");
		break;
		}
	case 2132: { // a,x:(r)+ y:(rh)-,y0
		unhandled("a,x:(r)+ y:(rh)-,y0");
		break;
		}
	case 2133: { // a,x:(r)+ y:(rh)-,y1
		unhandled("a,x:(r)+ y:(rh)-,y1");
		break;
		}
	case 2134: { // a,x:(r)+ y:(rh)-,a
		unhandled("a,x:(r)+ y:(rh)-,a");
		break;
		}
	case 2135: { // a,x:(r)+ y:(rh)-,b
		unhandled("a,x:(r)+ y:(rh)-,b");
		break;
		}
	case 2136: { // b,x:(r)+ y:(rh)-,y0
		unhandled("b,x:(r)+ y:(rh)-,y0");
		break;
		}
	case 2137: { // b,x:(r)+ y:(rh)-,y1
		unhandled("b,x:(r)+ y:(rh)-,y1");
		break;
		}
	case 2138: { // b,x:(r)+ y:(rh)-,a
		unhandled("b,x:(r)+ y:(rh)-,a");
		break;
		}
	case 2139: { // b,x:(r)+ y:(rh)-,b
		unhandled("b,x:(r)+ y:(rh)-,b");
		break;
		}
	case 2140: { // x0,x:(r)+ y:(rh)+,y0
		unhandled("x0,x:(r)+ y:(rh)+,y0");
		break;
		}
	case 2141: { // x0,x:(r)+ y:(rh)+,y1
		unhandled("x0,x:(r)+ y:(rh)+,y1");
		break;
		}
	case 2142: { // x0,x:(r)+ y:(rh)+,a
		unhandled("x0,x:(r)+ y:(rh)+,a");
		break;
		}
	case 2143: { // x0,x:(r)+ y:(rh)+,b
		unhandled("x0,x:(r)+ y:(rh)+,b");
		break;
		}
	case 2144: { // x1,x:(r)+ y:(rh)+,y0
		unhandled("x1,x:(r)+ y:(rh)+,y0");
		break;
		}
	case 2145: { // x1,x:(r)+ y:(rh)+,y1
		unhandled("x1,x:(r)+ y:(rh)+,y1");
		break;
		}
	case 2146: { // x1,x:(r)+ y:(rh)+,a
		unhandled("x1,x:(r)+ y:(rh)+,a");
		break;
		}
	case 2147: { // x1,x:(r)+ y:(rh)+,b
		unhandled("x1,x:(r)+ y:(rh)+,b");
		break;
		}
	case 2148: { // a,x:(r)+ y:(rh)+,y0
		unhandled("a,x:(r)+ y:(rh)+,y0");
		break;
		}
	case 2149: { // a,x:(r)+ y:(rh)+,y1
		unhandled("a,x:(r)+ y:(rh)+,y1");
		break;
		}
	case 2150: { // a,x:(r)+ y:(rh)+,a
		unhandled("a,x:(r)+ y:(rh)+,a");
		break;
		}
	case 2151: { // a,x:(r)+ y:(rh)+,b
		unhandled("a,x:(r)+ y:(rh)+,b");
		break;
		}
	case 2152: { // b,x:(r)+ y:(rh)+,y0
		unhandled("b,x:(r)+ y:(rh)+,y0");
		break;
		}
	case 2153: { // b,x:(r)+ y:(rh)+,y1
		unhandled("b,x:(r)+ y:(rh)+,y1");
		break;
		}
	case 2154: { // b,x:(r)+ y:(rh)+,a
		unhandled("b,x:(r)+ y:(rh)+,a");
		break;
		}
	case 2155: { // b,x:(r)+ y:(rh)+,b
		unhandled("b,x:(r)+ y:(rh)+,b");
		break;
		}
	case 2156: { // x0,x:(r)+ y:(rh),y0
		unhandled("x0,x:(r)+ y:(rh),y0");
		break;
		}
	case 2157: { // x0,x:(r)+ y:(rh),y1
		unhandled("x0,x:(r)+ y:(rh),y1");
		break;
		}
	case 2158: { // x0,x:(r)+ y:(rh),a
		unhandled("x0,x:(r)+ y:(rh),a");
		break;
		}
	case 2159: { // x0,x:(r)+ y:(rh),b
		unhandled("x0,x:(r)+ y:(rh),b");
		break;
		}
	case 2160: { // x1,x:(r)+ y:(rh),y0
		unhandled("x1,x:(r)+ y:(rh),y0");
		break;
		}
	case 2161: { // x1,x:(r)+ y:(rh),y1
		unhandled("x1,x:(r)+ y:(rh),y1");
		break;
		}
	case 2162: { // x1,x:(r)+ y:(rh),a
		unhandled("x1,x:(r)+ y:(rh),a");
		break;
		}
	case 2163: { // x1,x:(r)+ y:(rh),b
		unhandled("x1,x:(r)+ y:(rh),b");
		break;
		}
	case 2164: { // a,x:(r)+ y:(rh),y0
		unhandled("a,x:(r)+ y:(rh),y0");
		break;
		}
	case 2165: { // a,x:(r)+ y:(rh),y1
		unhandled("a,x:(r)+ y:(rh),y1");
		break;
		}
	case 2166: { // a,x:(r)+ y:(rh),a
		unhandled("a,x:(r)+ y:(rh),a");
		break;
		}
	case 2167: { // a,x:(r)+ y:(rh),b
		unhandled("a,x:(r)+ y:(rh),b");
		break;
		}
	case 2168: { // b,x:(r)+ y:(rh),y0
		unhandled("b,x:(r)+ y:(rh),y0");
		break;
		}
	case 2169: { // b,x:(r)+ y:(rh),y1
		unhandled("b,x:(r)+ y:(rh),y1");
		break;
		}
	case 2170: { // b,x:(r)+ y:(rh),a
		unhandled("b,x:(r)+ y:(rh),a");
		break;
		}
	case 2171: { // b,x:(r)+ y:(rh),b
		unhandled("b,x:(r)+ y:(rh),b");
		break;
		}
	case 2172: { // x0,x:(r) y:(rh)+n,y0
		unhandled("x0,x:(r) y:(rh)+n,y0");
		break;
		}
	case 2173: { // x0,x:(r) y:(rh)+n,y1
		unhandled("x0,x:(r) y:(rh)+n,y1");
		break;
		}
	case 2174: { // x0,x:(r) y:(rh)+n,a
		unhandled("x0,x:(r) y:(rh)+n,a");
		break;
		}
	case 2175: { // x0,x:(r) y:(rh)+n,b
		unhandled("x0,x:(r) y:(rh)+n,b");
		break;
		}
	case 2176: { // x1,x:(r) y:(rh)+n,y0
		unhandled("x1,x:(r) y:(rh)+n,y0");
		break;
		}
	case 2177: { // x1,x:(r) y:(rh)+n,y1
		unhandled("x1,x:(r) y:(rh)+n,y1");
		break;
		}
	case 2178: { // x1,x:(r) y:(rh)+n,a
		unhandled("x1,x:(r) y:(rh)+n,a");
		break;
		}
	case 2179: { // x1,x:(r) y:(rh)+n,b
		unhandled("x1,x:(r) y:(rh)+n,b");
		break;
		}
	case 2180: { // a,x:(r) y:(rh)+n,y0
		unhandled("a,x:(r) y:(rh)+n,y0");
		break;
		}
	case 2181: { // a,x:(r) y:(rh)+n,y1
		unhandled("a,x:(r) y:(rh)+n,y1");
		break;
		}
	case 2182: { // a,x:(r) y:(rh)+n,a
		unhandled("a,x:(r) y:(rh)+n,a");
		break;
		}
	case 2183: { // a,x:(r) y:(rh)+n,b
		unhandled("a,x:(r) y:(rh)+n,b");
		break;
		}
	case 2184: { // b,x:(r) y:(rh)+n,y0
		unhandled("b,x:(r) y:(rh)+n,y0");
		break;
		}
	case 2185: { // b,x:(r) y:(rh)+n,y1
		unhandled("b,x:(r) y:(rh)+n,y1");
		break;
		}
	case 2186: { // b,x:(r) y:(rh)+n,a
		unhandled("b,x:(r) y:(rh)+n,a");
		break;
		}
	case 2187: { // b,x:(r) y:(rh)+n,b
		unhandled("b,x:(r) y:(rh)+n,b");
		break;
		}
	case 2188: { // x0,x:(r) y:(rh)-,y0
		unhandled("x0,x:(r) y:(rh)-,y0");
		break;
		}
	case 2189: { // x0,x:(r) y:(rh)-,y1
		unhandled("x0,x:(r) y:(rh)-,y1");
		break;
		}
	case 2190: { // x0,x:(r) y:(rh)-,a
		unhandled("x0,x:(r) y:(rh)-,a");
		break;
		}
	case 2191: { // x0,x:(r) y:(rh)-,b
		unhandled("x0,x:(r) y:(rh)-,b");
		break;
		}
	case 2192: { // x1,x:(r) y:(rh)-,y0
		unhandled("x1,x:(r) y:(rh)-,y0");
		break;
		}
	case 2193: { // x1,x:(r) y:(rh)-,y1
		unhandled("x1,x:(r) y:(rh)-,y1");
		break;
		}
	case 2194: { // x1,x:(r) y:(rh)-,a
		unhandled("x1,x:(r) y:(rh)-,a");
		break;
		}
	case 2195: { // x1,x:(r) y:(rh)-,b
		unhandled("x1,x:(r) y:(rh)-,b");
		break;
		}
	case 2196: { // a,x:(r) y:(rh)-,y0
		unhandled("a,x:(r) y:(rh)-,y0");
		break;
		}
	case 2197: { // a,x:(r) y:(rh)-,y1
		unhandled("a,x:(r) y:(rh)-,y1");
		break;
		}
	case 2198: { // a,x:(r) y:(rh)-,a
		unhandled("a,x:(r) y:(rh)-,a");
		break;
		}
	case 2199: { // a,x:(r) y:(rh)-,b
		unhandled("a,x:(r) y:(rh)-,b");
		break;
		}
	case 2200: { // b,x:(r) y:(rh)-,y0
		unhandled("b,x:(r) y:(rh)-,y0");
		break;
		}
	case 2201: { // b,x:(r) y:(rh)-,y1
		unhandled("b,x:(r) y:(rh)-,y1");
		break;
		}
	case 2202: { // b,x:(r) y:(rh)-,a
		unhandled("b,x:(r) y:(rh)-,a");
		break;
		}
	case 2203: { // b,x:(r) y:(rh)-,b
		unhandled("b,x:(r) y:(rh)-,b");
		break;
		}
	case 2204: { // x0,x:(r) y:(rh)+,y0
		unhandled("x0,x:(r) y:(rh)+,y0");
		break;
		}
	case 2205: { // x0,x:(r) y:(rh)+,y1
		unhandled("x0,x:(r) y:(rh)+,y1");
		break;
		}
	case 2206: { // x0,x:(r) y:(rh)+,a
		unhandled("x0,x:(r) y:(rh)+,a");
		break;
		}
	case 2207: { // x0,x:(r) y:(rh)+,b
		unhandled("x0,x:(r) y:(rh)+,b");
		break;
		}
	case 2208: { // x1,x:(r) y:(rh)+,y0
		unhandled("x1,x:(r) y:(rh)+,y0");
		break;
		}
	case 2209: { // x1,x:(r) y:(rh)+,y1
		unhandled("x1,x:(r) y:(rh)+,y1");
		break;
		}
	case 2210: { // x1,x:(r) y:(rh)+,a
		unhandled("x1,x:(r) y:(rh)+,a");
		break;
		}
	case 2211: { // x1,x:(r) y:(rh)+,b
		unhandled("x1,x:(r) y:(rh)+,b");
		break;
		}
	case 2212: { // a,x:(r) y:(rh)+,y0
		unhandled("a,x:(r) y:(rh)+,y0");
		break;
		}
	case 2213: { // a,x:(r) y:(rh)+,y1
		unhandled("a,x:(r) y:(rh)+,y1");
		break;
		}
	case 2214: { // a,x:(r) y:(rh)+,a
		unhandled("a,x:(r) y:(rh)+,a");
		break;
		}
	case 2215: { // a,x:(r) y:(rh)+,b
		unhandled("a,x:(r) y:(rh)+,b");
		break;
		}
	case 2216: { // b,x:(r) y:(rh)+,y0
		unhandled("b,x:(r) y:(rh)+,y0");
		break;
		}
	case 2217: { // b,x:(r) y:(rh)+,y1
		unhandled("b,x:(r) y:(rh)+,y1");
		break;
		}
	case 2218: { // b,x:(r) y:(rh)+,a
		unhandled("b,x:(r) y:(rh)+,a");
		break;
		}
	case 2219: { // b,x:(r) y:(rh)+,b
		unhandled("b,x:(r) y:(rh)+,b");
		break;
		}
	case 2220: { // x0,x:(r) y:(rh),y0
		unhandled("x0,x:(r) y:(rh),y0");
		break;
		}
	case 2221: { // x0,x:(r) y:(rh),y1
		unhandled("x0,x:(r) y:(rh),y1");
		break;
		}
	case 2222: { // x0,x:(r) y:(rh),a
		unhandled("x0,x:(r) y:(rh),a");
		break;
		}
	case 2223: { // x0,x:(r) y:(rh),b
		unhandled("x0,x:(r) y:(rh),b");
		break;
		}
	case 2224: { // x1,x:(r) y:(rh),y0
		unhandled("x1,x:(r) y:(rh),y0");
		break;
		}
	case 2225: { // x1,x:(r) y:(rh),y1
		unhandled("x1,x:(r) y:(rh),y1");
		break;
		}
	case 2226: { // x1,x:(r) y:(rh),a
		unhandled("x1,x:(r) y:(rh),a");
		break;
		}
	case 2227: { // x1,x:(r) y:(rh),b
		unhandled("x1,x:(r) y:(rh),b");
		break;
		}
	case 2228: { // a,x:(r) y:(rh),y0
		unhandled("a,x:(r) y:(rh),y0");
		break;
		}
	case 2229: { // a,x:(r) y:(rh),y1
		unhandled("a,x:(r) y:(rh),y1");
		break;
		}
	case 2230: { // a,x:(r) y:(rh),a
		unhandled("a,x:(r) y:(rh),a");
		break;
		}
	case 2231: { // a,x:(r) y:(rh),b
		unhandled("a,x:(r) y:(rh),b");
		break;
		}
	case 2232: { // b,x:(r) y:(rh),y0
		unhandled("b,x:(r) y:(rh),y0");
		break;
		}
	case 2233: { // b,x:(r) y:(rh),y1
		unhandled("b,x:(r) y:(rh),y1");
		break;
		}
	case 2234: { // b,x:(r) y:(rh),a
		unhandled("b,x:(r) y:(rh),a");
		break;
		}
	case 2235: { // b,x:(r) y:(rh),b
		unhandled("b,x:(r) y:(rh),b");
		break;
		}
	case 2236: { // x0,x:(r)+n y0,y:(rh)+n
		unhandled("x0,x:(r)+n y0,y:(rh)+n");
		break;
		}
	case 2237: { // x0,x:(r)+n y1,y:(rh)+n
		unhandled("x0,x:(r)+n y1,y:(rh)+n");
		break;
		}
	case 2238: { // x0,x:(r)+n a,y:(rh)+n
		unhandled("x0,x:(r)+n a,y:(rh)+n");
		break;
		}
	case 2239: { // x0,x:(r)+n b,y:(rh)+n
		unhandled("x0,x:(r)+n b,y:(rh)+n");
		break;
		}
	case 2240: { // x1,x:(r)+n y0,y:(rh)+n
		unhandled("x1,x:(r)+n y0,y:(rh)+n");
		break;
		}
	case 2241: { // x1,x:(r)+n y1,y:(rh)+n
		unhandled("x1,x:(r)+n y1,y:(rh)+n");
		break;
		}
	case 2242: { // x1,x:(r)+n a,y:(rh)+n
		unhandled("x1,x:(r)+n a,y:(rh)+n");
		break;
		}
	case 2243: { // x1,x:(r)+n b,y:(rh)+n
		unhandled("x1,x:(r)+n b,y:(rh)+n");
		break;
		}
	case 2244: { // a,x:(r)+n y0,y:(rh)+n
		unhandled("a,x:(r)+n y0,y:(rh)+n");
		break;
		}
	case 2245: { // a,x:(r)+n y1,y:(rh)+n
		unhandled("a,x:(r)+n y1,y:(rh)+n");
		break;
		}
	case 2246: { // a,x:(r)+n a,y:(rh)+n
		unhandled("a,x:(r)+n a,y:(rh)+n");
		break;
		}
	case 2247: { // a,x:(r)+n b,y:(rh)+n
		unhandled("a,x:(r)+n b,y:(rh)+n");
		break;
		}
	case 2248: { // b,x:(r)+n y0,y:(rh)+n
		unhandled("b,x:(r)+n y0,y:(rh)+n");
		break;
		}
	case 2249: { // b,x:(r)+n y1,y:(rh)+n
		unhandled("b,x:(r)+n y1,y:(rh)+n");
		break;
		}
	case 2250: { // b,x:(r)+n a,y:(rh)+n
		unhandled("b,x:(r)+n a,y:(rh)+n");
		break;
		}
	case 2251: { // b,x:(r)+n b,y:(rh)+n
		unhandled("b,x:(r)+n b,y:(rh)+n");
		break;
		}
	case 2252: { // x0,x:(r)+n y0,y:(rh)-
		unhandled("x0,x:(r)+n y0,y:(rh)-");
		break;
		}
	case 2253: { // x0,x:(r)+n y1,y:(rh)-
		unhandled("x0,x:(r)+n y1,y:(rh)-");
		break;
		}
	case 2254: { // x0,x:(r)+n a,y:(rh)-
		unhandled("x0,x:(r)+n a,y:(rh)-");
		break;
		}
	case 2255: { // x0,x:(r)+n b,y:(rh)-
		unhandled("x0,x:(r)+n b,y:(rh)-");
		break;
		}
	case 2256: { // x1,x:(r)+n y0,y:(rh)-
		unhandled("x1,x:(r)+n y0,y:(rh)-");
		break;
		}
	case 2257: { // x1,x:(r)+n y1,y:(rh)-
		unhandled("x1,x:(r)+n y1,y:(rh)-");
		break;
		}
	case 2258: { // x1,x:(r)+n a,y:(rh)-
		unhandled("x1,x:(r)+n a,y:(rh)-");
		break;
		}
	case 2259: { // x1,x:(r)+n b,y:(rh)-
		unhandled("x1,x:(r)+n b,y:(rh)-");
		break;
		}
	case 2260: { // a,x:(r)+n y0,y:(rh)-
		unhandled("a,x:(r)+n y0,y:(rh)-");
		break;
		}
	case 2261: { // a,x:(r)+n y1,y:(rh)-
		unhandled("a,x:(r)+n y1,y:(rh)-");
		break;
		}
	case 2262: { // a,x:(r)+n a,y:(rh)-
		unhandled("a,x:(r)+n a,y:(rh)-");
		break;
		}
	case 2263: { // a,x:(r)+n b,y:(rh)-
		unhandled("a,x:(r)+n b,y:(rh)-");
		break;
		}
	case 2264: { // b,x:(r)+n y0,y:(rh)-
		unhandled("b,x:(r)+n y0,y:(rh)-");
		break;
		}
	case 2265: { // b,x:(r)+n y1,y:(rh)-
		unhandled("b,x:(r)+n y1,y:(rh)-");
		break;
		}
	case 2266: { // b,x:(r)+n a,y:(rh)-
		unhandled("b,x:(r)+n a,y:(rh)-");
		break;
		}
	case 2267: { // b,x:(r)+n b,y:(rh)-
		unhandled("b,x:(r)+n b,y:(rh)-");
		break;
		}
	case 2268: { // x0,x:(r)+n y0,y:(rh)+
		unhandled("x0,x:(r)+n y0,y:(rh)+");
		break;
		}
	case 2269: { // x0,x:(r)+n y1,y:(rh)+
		unhandled("x0,x:(r)+n y1,y:(rh)+");
		break;
		}
	case 2270: { // x0,x:(r)+n a,y:(rh)+
		unhandled("x0,x:(r)+n a,y:(rh)+");
		break;
		}
	case 2271: { // x0,x:(r)+n b,y:(rh)+
		unhandled("x0,x:(r)+n b,y:(rh)+");
		break;
		}
	case 2272: { // x1,x:(r)+n y0,y:(rh)+
		unhandled("x1,x:(r)+n y0,y:(rh)+");
		break;
		}
	case 2273: { // x1,x:(r)+n y1,y:(rh)+
		unhandled("x1,x:(r)+n y1,y:(rh)+");
		break;
		}
	case 2274: { // x1,x:(r)+n a,y:(rh)+
		unhandled("x1,x:(r)+n a,y:(rh)+");
		break;
		}
	case 2275: { // x1,x:(r)+n b,y:(rh)+
		unhandled("x1,x:(r)+n b,y:(rh)+");
		break;
		}
	case 2276: { // a,x:(r)+n y0,y:(rh)+
		unhandled("a,x:(r)+n y0,y:(rh)+");
		break;
		}
	case 2277: { // a,x:(r)+n y1,y:(rh)+
		unhandled("a,x:(r)+n y1,y:(rh)+");
		break;
		}
	case 2278: { // a,x:(r)+n a,y:(rh)+
		unhandled("a,x:(r)+n a,y:(rh)+");
		break;
		}
	case 2279: { // a,x:(r)+n b,y:(rh)+
		unhandled("a,x:(r)+n b,y:(rh)+");
		break;
		}
	case 2280: { // b,x:(r)+n y0,y:(rh)+
		unhandled("b,x:(r)+n y0,y:(rh)+");
		break;
		}
	case 2281: { // b,x:(r)+n y1,y:(rh)+
		unhandled("b,x:(r)+n y1,y:(rh)+");
		break;
		}
	case 2282: { // b,x:(r)+n a,y:(rh)+
		unhandled("b,x:(r)+n a,y:(rh)+");
		break;
		}
	case 2283: { // b,x:(r)+n b,y:(rh)+
		unhandled("b,x:(r)+n b,y:(rh)+");
		break;
		}
	case 2284: { // x0,x:(r)+n y0,y:(rh)
		unhandled("x0,x:(r)+n y0,y:(rh)");
		break;
		}
	case 2285: { // x0,x:(r)+n y1,y:(rh)
		unhandled("x0,x:(r)+n y1,y:(rh)");
		break;
		}
	case 2286: { // x0,x:(r)+n a,y:(rh)
		unhandled("x0,x:(r)+n a,y:(rh)");
		break;
		}
	case 2287: { // x0,x:(r)+n b,y:(rh)
		unhandled("x0,x:(r)+n b,y:(rh)");
		break;
		}
	case 2288: { // x1,x:(r)+n y0,y:(rh)
		unhandled("x1,x:(r)+n y0,y:(rh)");
		break;
		}
	case 2289: { // x1,x:(r)+n y1,y:(rh)
		unhandled("x1,x:(r)+n y1,y:(rh)");
		break;
		}
	case 2290: { // x1,x:(r)+n a,y:(rh)
		unhandled("x1,x:(r)+n a,y:(rh)");
		break;
		}
	case 2291: { // x1,x:(r)+n b,y:(rh)
		unhandled("x1,x:(r)+n b,y:(rh)");
		break;
		}
	case 2292: { // a,x:(r)+n y0,y:(rh)
		unhandled("a,x:(r)+n y0,y:(rh)");
		break;
		}
	case 2293: { // a,x:(r)+n y1,y:(rh)
		unhandled("a,x:(r)+n y1,y:(rh)");
		break;
		}
	case 2294: { // a,x:(r)+n a,y:(rh)
		unhandled("a,x:(r)+n a,y:(rh)");
		break;
		}
	case 2295: { // a,x:(r)+n b,y:(rh)
		unhandled("a,x:(r)+n b,y:(rh)");
		break;
		}
	case 2296: { // b,x:(r)+n y0,y:(rh)
		unhandled("b,x:(r)+n y0,y:(rh)");
		break;
		}
	case 2297: { // b,x:(r)+n y1,y:(rh)
		unhandled("b,x:(r)+n y1,y:(rh)");
		break;
		}
	case 2298: { // b,x:(r)+n a,y:(rh)
		unhandled("b,x:(r)+n a,y:(rh)");
		break;
		}
	case 2299: { // b,x:(r)+n b,y:(rh)
		unhandled("b,x:(r)+n b,y:(rh)");
		break;
		}
	case 2300: { // x0,x:(r)- y0,y:(rh)+n
		unhandled("x0,x:(r)- y0,y:(rh)+n");
		break;
		}
	case 2301: { // x0,x:(r)- y1,y:(rh)+n
		unhandled("x0,x:(r)- y1,y:(rh)+n");
		break;
		}
	case 2302: { // x0,x:(r)- a,y:(rh)+n
		unhandled("x0,x:(r)- a,y:(rh)+n");
		break;
		}
	case 2303: { // x0,x:(r)- b,y:(rh)+n
		unhandled("x0,x:(r)- b,y:(rh)+n");
		break;
		}
	case 2304: { // x1,x:(r)- y0,y:(rh)+n
		unhandled("x1,x:(r)- y0,y:(rh)+n");
		break;
		}
	case 2305: { // x1,x:(r)- y1,y:(rh)+n
		unhandled("x1,x:(r)- y1,y:(rh)+n");
		break;
		}
	case 2306: { // x1,x:(r)- a,y:(rh)+n
		unhandled("x1,x:(r)- a,y:(rh)+n");
		break;
		}
	case 2307: { // x1,x:(r)- b,y:(rh)+n
		unhandled("x1,x:(r)- b,y:(rh)+n");
		break;
		}
	case 2308: { // a,x:(r)- y0,y:(rh)+n
		unhandled("a,x:(r)- y0,y:(rh)+n");
		break;
		}
	case 2309: { // a,x:(r)- y1,y:(rh)+n
		unhandled("a,x:(r)- y1,y:(rh)+n");
		break;
		}
	case 2310: { // a,x:(r)- a,y:(rh)+n
		unhandled("a,x:(r)- a,y:(rh)+n");
		break;
		}
	case 2311: { // a,x:(r)- b,y:(rh)+n
		unhandled("a,x:(r)- b,y:(rh)+n");
		break;
		}
	case 2312: { // b,x:(r)- y0,y:(rh)+n
		unhandled("b,x:(r)- y0,y:(rh)+n");
		break;
		}
	case 2313: { // b,x:(r)- y1,y:(rh)+n
		unhandled("b,x:(r)- y1,y:(rh)+n");
		break;
		}
	case 2314: { // b,x:(r)- a,y:(rh)+n
		unhandled("b,x:(r)- a,y:(rh)+n");
		break;
		}
	case 2315: { // b,x:(r)- b,y:(rh)+n
		unhandled("b,x:(r)- b,y:(rh)+n");
		break;
		}
	case 2316: { // x0,x:(r)- y0,y:(rh)-
		unhandled("x0,x:(r)- y0,y:(rh)-");
		break;
		}
	case 2317: { // x0,x:(r)- y1,y:(rh)-
		unhandled("x0,x:(r)- y1,y:(rh)-");
		break;
		}
	case 2318: { // x0,x:(r)- a,y:(rh)-
		unhandled("x0,x:(r)- a,y:(rh)-");
		break;
		}
	case 2319: { // x0,x:(r)- b,y:(rh)-
		unhandled("x0,x:(r)- b,y:(rh)-");
		break;
		}
	case 2320: { // x1,x:(r)- y0,y:(rh)-
		unhandled("x1,x:(r)- y0,y:(rh)-");
		break;
		}
	case 2321: { // x1,x:(r)- y1,y:(rh)-
		unhandled("x1,x:(r)- y1,y:(rh)-");
		break;
		}
	case 2322: { // x1,x:(r)- a,y:(rh)-
		unhandled("x1,x:(r)- a,y:(rh)-");
		break;
		}
	case 2323: { // x1,x:(r)- b,y:(rh)-
		unhandled("x1,x:(r)- b,y:(rh)-");
		break;
		}
	case 2324: { // a,x:(r)- y0,y:(rh)-
		unhandled("a,x:(r)- y0,y:(rh)-");
		break;
		}
	case 2325: { // a,x:(r)- y1,y:(rh)-
		unhandled("a,x:(r)- y1,y:(rh)-");
		break;
		}
	case 2326: { // a,x:(r)- a,y:(rh)-
		unhandled("a,x:(r)- a,y:(rh)-");
		break;
		}
	case 2327: { // a,x:(r)- b,y:(rh)-
		unhandled("a,x:(r)- b,y:(rh)-");
		break;
		}
	case 2328: { // b,x:(r)- y0,y:(rh)-
		unhandled("b,x:(r)- y0,y:(rh)-");
		break;
		}
	case 2329: { // b,x:(r)- y1,y:(rh)-
		unhandled("b,x:(r)- y1,y:(rh)-");
		break;
		}
	case 2330: { // b,x:(r)- a,y:(rh)-
		unhandled("b,x:(r)- a,y:(rh)-");
		break;
		}
	case 2331: { // b,x:(r)- b,y:(rh)-
		unhandled("b,x:(r)- b,y:(rh)-");
		break;
		}
	case 2332: { // x0,x:(r)- y0,y:(rh)+
		unhandled("x0,x:(r)- y0,y:(rh)+");
		break;
		}
	case 2333: { // x0,x:(r)- y1,y:(rh)+
		unhandled("x0,x:(r)- y1,y:(rh)+");
		break;
		}
	case 2334: { // x0,x:(r)- a,y:(rh)+
		unhandled("x0,x:(r)- a,y:(rh)+");
		break;
		}
	case 2335: { // x0,x:(r)- b,y:(rh)+
		unhandled("x0,x:(r)- b,y:(rh)+");
		break;
		}
	case 2336: { // x1,x:(r)- y0,y:(rh)+
		unhandled("x1,x:(r)- y0,y:(rh)+");
		break;
		}
	case 2337: { // x1,x:(r)- y1,y:(rh)+
		unhandled("x1,x:(r)- y1,y:(rh)+");
		break;
		}
	case 2338: { // x1,x:(r)- a,y:(rh)+
		unhandled("x1,x:(r)- a,y:(rh)+");
		break;
		}
	case 2339: { // x1,x:(r)- b,y:(rh)+
		unhandled("x1,x:(r)- b,y:(rh)+");
		break;
		}
	case 2340: { // a,x:(r)- y0,y:(rh)+
		unhandled("a,x:(r)- y0,y:(rh)+");
		break;
		}
	case 2341: { // a,x:(r)- y1,y:(rh)+
		unhandled("a,x:(r)- y1,y:(rh)+");
		break;
		}
	case 2342: { // a,x:(r)- a,y:(rh)+
		unhandled("a,x:(r)- a,y:(rh)+");
		break;
		}
	case 2343: { // a,x:(r)- b,y:(rh)+
		unhandled("a,x:(r)- b,y:(rh)+");
		break;
		}
	case 2344: { // b,x:(r)- y0,y:(rh)+
		unhandled("b,x:(r)- y0,y:(rh)+");
		break;
		}
	case 2345: { // b,x:(r)- y1,y:(rh)+
		unhandled("b,x:(r)- y1,y:(rh)+");
		break;
		}
	case 2346: { // b,x:(r)- a,y:(rh)+
		unhandled("b,x:(r)- a,y:(rh)+");
		break;
		}
	case 2347: { // b,x:(r)- b,y:(rh)+
		unhandled("b,x:(r)- b,y:(rh)+");
		break;
		}
	case 2348: { // x0,x:(r)- y0,y:(rh)
		unhandled("x0,x:(r)- y0,y:(rh)");
		break;
		}
	case 2349: { // x0,x:(r)- y1,y:(rh)
		unhandled("x0,x:(r)- y1,y:(rh)");
		break;
		}
	case 2350: { // x0,x:(r)- a,y:(rh)
		unhandled("x0,x:(r)- a,y:(rh)");
		break;
		}
	case 2351: { // x0,x:(r)- b,y:(rh)
		unhandled("x0,x:(r)- b,y:(rh)");
		break;
		}
	case 2352: { // x1,x:(r)- y0,y:(rh)
		unhandled("x1,x:(r)- y0,y:(rh)");
		break;
		}
	case 2353: { // x1,x:(r)- y1,y:(rh)
		unhandled("x1,x:(r)- y1,y:(rh)");
		break;
		}
	case 2354: { // x1,x:(r)- a,y:(rh)
		unhandled("x1,x:(r)- a,y:(rh)");
		break;
		}
	case 2355: { // x1,x:(r)- b,y:(rh)
		unhandled("x1,x:(r)- b,y:(rh)");
		break;
		}
	case 2356: { // a,x:(r)- y0,y:(rh)
		unhandled("a,x:(r)- y0,y:(rh)");
		break;
		}
	case 2357: { // a,x:(r)- y1,y:(rh)
		unhandled("a,x:(r)- y1,y:(rh)");
		break;
		}
	case 2358: { // a,x:(r)- a,y:(rh)
		unhandled("a,x:(r)- a,y:(rh)");
		break;
		}
	case 2359: { // a,x:(r)- b,y:(rh)
		unhandled("a,x:(r)- b,y:(rh)");
		break;
		}
	case 2360: { // b,x:(r)- y0,y:(rh)
		unhandled("b,x:(r)- y0,y:(rh)");
		break;
		}
	case 2361: { // b,x:(r)- y1,y:(rh)
		unhandled("b,x:(r)- y1,y:(rh)");
		break;
		}
	case 2362: { // b,x:(r)- a,y:(rh)
		unhandled("b,x:(r)- a,y:(rh)");
		break;
		}
	case 2363: { // b,x:(r)- b,y:(rh)
		unhandled("b,x:(r)- b,y:(rh)");
		break;
		}
	case 2364: { // x0,x:(r)+ y0,y:(rh)+n
		unhandled("x0,x:(r)+ y0,y:(rh)+n");
		break;
		}
	case 2365: { // x0,x:(r)+ y1,y:(rh)+n
		unhandled("x0,x:(r)+ y1,y:(rh)+n");
		break;
		}
	case 2366: { // x0,x:(r)+ a,y:(rh)+n
		unhandled("x0,x:(r)+ a,y:(rh)+n");
		break;
		}
	case 2367: { // x0,x:(r)+ b,y:(rh)+n
		unhandled("x0,x:(r)+ b,y:(rh)+n");
		break;
		}
	case 2368: { // x1,x:(r)+ y0,y:(rh)+n
		unhandled("x1,x:(r)+ y0,y:(rh)+n");
		break;
		}
	case 2369: { // x1,x:(r)+ y1,y:(rh)+n
		unhandled("x1,x:(r)+ y1,y:(rh)+n");
		break;
		}
	case 2370: { // x1,x:(r)+ a,y:(rh)+n
		unhandled("x1,x:(r)+ a,y:(rh)+n");
		break;
		}
	case 2371: { // x1,x:(r)+ b,y:(rh)+n
		unhandled("x1,x:(r)+ b,y:(rh)+n");
		break;
		}
	case 2372: { // a,x:(r)+ y0,y:(rh)+n
		unhandled("a,x:(r)+ y0,y:(rh)+n");
		break;
		}
	case 2373: { // a,x:(r)+ y1,y:(rh)+n
		unhandled("a,x:(r)+ y1,y:(rh)+n");
		break;
		}
	case 2374: { // a,x:(r)+ a,y:(rh)+n
		unhandled("a,x:(r)+ a,y:(rh)+n");
		break;
		}
	case 2375: { // a,x:(r)+ b,y:(rh)+n
		unhandled("a,x:(r)+ b,y:(rh)+n");
		break;
		}
	case 2376: { // b,x:(r)+ y0,y:(rh)+n
		unhandled("b,x:(r)+ y0,y:(rh)+n");
		break;
		}
	case 2377: { // b,x:(r)+ y1,y:(rh)+n
		unhandled("b,x:(r)+ y1,y:(rh)+n");
		break;
		}
	case 2378: { // b,x:(r)+ a,y:(rh)+n
		unhandled("b,x:(r)+ a,y:(rh)+n");
		break;
		}
	case 2379: { // b,x:(r)+ b,y:(rh)+n
		unhandled("b,x:(r)+ b,y:(rh)+n");
		break;
		}
	case 2380: { // x0,x:(r)+ y0,y:(rh)-
		unhandled("x0,x:(r)+ y0,y:(rh)-");
		break;
		}
	case 2381: { // x0,x:(r)+ y1,y:(rh)-
		unhandled("x0,x:(r)+ y1,y:(rh)-");
		break;
		}
	case 2382: { // x0,x:(r)+ a,y:(rh)-
		unhandled("x0,x:(r)+ a,y:(rh)-");
		break;
		}
	case 2383: { // x0,x:(r)+ b,y:(rh)-
		unhandled("x0,x:(r)+ b,y:(rh)-");
		break;
		}
	case 2384: { // x1,x:(r)+ y0,y:(rh)-
		unhandled("x1,x:(r)+ y0,y:(rh)-");
		break;
		}
	case 2385: { // x1,x:(r)+ y1,y:(rh)-
		unhandled("x1,x:(r)+ y1,y:(rh)-");
		break;
		}
	case 2386: { // x1,x:(r)+ a,y:(rh)-
		unhandled("x1,x:(r)+ a,y:(rh)-");
		break;
		}
	case 2387: { // x1,x:(r)+ b,y:(rh)-
		unhandled("x1,x:(r)+ b,y:(rh)-");
		break;
		}
	case 2388: { // a,x:(r)+ y0,y:(rh)-
		unhandled("a,x:(r)+ y0,y:(rh)-");
		break;
		}
	case 2389: { // a,x:(r)+ y1,y:(rh)-
		unhandled("a,x:(r)+ y1,y:(rh)-");
		break;
		}
	case 2390: { // a,x:(r)+ a,y:(rh)-
		unhandled("a,x:(r)+ a,y:(rh)-");
		break;
		}
	case 2391: { // a,x:(r)+ b,y:(rh)-
		unhandled("a,x:(r)+ b,y:(rh)-");
		break;
		}
	case 2392: { // b,x:(r)+ y0,y:(rh)-
		unhandled("b,x:(r)+ y0,y:(rh)-");
		break;
		}
	case 2393: { // b,x:(r)+ y1,y:(rh)-
		unhandled("b,x:(r)+ y1,y:(rh)-");
		break;
		}
	case 2394: { // b,x:(r)+ a,y:(rh)-
		unhandled("b,x:(r)+ a,y:(rh)-");
		break;
		}
	case 2395: { // b,x:(r)+ b,y:(rh)-
		unhandled("b,x:(r)+ b,y:(rh)-");
		break;
		}
	case 2396: { // x0,x:(r)+ y0,y:(rh)+
		unhandled("x0,x:(r)+ y0,y:(rh)+");
		break;
		}
	case 2397: { // x0,x:(r)+ y1,y:(rh)+
		unhandled("x0,x:(r)+ y1,y:(rh)+");
		break;
		}
	case 2398: { // x0,x:(r)+ a,y:(rh)+
		unhandled("x0,x:(r)+ a,y:(rh)+");
		break;
		}
	case 2399: { // x0,x:(r)+ b,y:(rh)+
		unhandled("x0,x:(r)+ b,y:(rh)+");
		break;
		}
	case 2400: { // x1,x:(r)+ y0,y:(rh)+
		unhandled("x1,x:(r)+ y0,y:(rh)+");
		break;
		}
	case 2401: { // x1,x:(r)+ y1,y:(rh)+
		unhandled("x1,x:(r)+ y1,y:(rh)+");
		break;
		}
	case 2402: { // x1,x:(r)+ a,y:(rh)+
		unhandled("x1,x:(r)+ a,y:(rh)+");
		break;
		}
	case 2403: { // x1,x:(r)+ b,y:(rh)+
		unhandled("x1,x:(r)+ b,y:(rh)+");
		break;
		}
	case 2404: { // a,x:(r)+ y0,y:(rh)+
		unhandled("a,x:(r)+ y0,y:(rh)+");
		break;
		}
	case 2405: { // a,x:(r)+ y1,y:(rh)+
		unhandled("a,x:(r)+ y1,y:(rh)+");
		break;
		}
	case 2406: { // a,x:(r)+ a,y:(rh)+
		unhandled("a,x:(r)+ a,y:(rh)+");
		break;
		}
	case 2407: { // a,x:(r)+ b,y:(rh)+
		unhandled("a,x:(r)+ b,y:(rh)+");
		break;
		}
	case 2408: { // b,x:(r)+ y0,y:(rh)+
		unhandled("b,x:(r)+ y0,y:(rh)+");
		break;
		}
	case 2409: { // b,x:(r)+ y1,y:(rh)+
		unhandled("b,x:(r)+ y1,y:(rh)+");
		break;
		}
	case 2410: { // b,x:(r)+ a,y:(rh)+
		unhandled("b,x:(r)+ a,y:(rh)+");
		break;
		}
	case 2411: { // b,x:(r)+ b,y:(rh)+
		unhandled("b,x:(r)+ b,y:(rh)+");
		break;
		}
	case 2412: { // x0,x:(r)+ y0,y:(rh)
		unhandled("x0,x:(r)+ y0,y:(rh)");
		break;
		}
	case 2413: { // x0,x:(r)+ y1,y:(rh)
		unhandled("x0,x:(r)+ y1,y:(rh)");
		break;
		}
	case 2414: { // x0,x:(r)+ a,y:(rh)
		unhandled("x0,x:(r)+ a,y:(rh)");
		break;
		}
	case 2415: { // x0,x:(r)+ b,y:(rh)
		unhandled("x0,x:(r)+ b,y:(rh)");
		break;
		}
	case 2416: { // x1,x:(r)+ y0,y:(rh)
		unhandled("x1,x:(r)+ y0,y:(rh)");
		break;
		}
	case 2417: { // x1,x:(r)+ y1,y:(rh)
		unhandled("x1,x:(r)+ y1,y:(rh)");
		break;
		}
	case 2418: { // x1,x:(r)+ a,y:(rh)
		unhandled("x1,x:(r)+ a,y:(rh)");
		break;
		}
	case 2419: { // x1,x:(r)+ b,y:(rh)
		unhandled("x1,x:(r)+ b,y:(rh)");
		break;
		}
	case 2420: { // a,x:(r)+ y0,y:(rh)
		unhandled("a,x:(r)+ y0,y:(rh)");
		break;
		}
	case 2421: { // a,x:(r)+ y1,y:(rh)
		unhandled("a,x:(r)+ y1,y:(rh)");
		break;
		}
	case 2422: { // a,x:(r)+ a,y:(rh)
		unhandled("a,x:(r)+ a,y:(rh)");
		break;
		}
	case 2423: { // a,x:(r)+ b,y:(rh)
		unhandled("a,x:(r)+ b,y:(rh)");
		break;
		}
	case 2424: { // b,x:(r)+ y0,y:(rh)
		unhandled("b,x:(r)+ y0,y:(rh)");
		break;
		}
	case 2425: { // b,x:(r)+ y1,y:(rh)
		unhandled("b,x:(r)+ y1,y:(rh)");
		break;
		}
	case 2426: { // b,x:(r)+ a,y:(rh)
		unhandled("b,x:(r)+ a,y:(rh)");
		break;
		}
	case 2427: { // b,x:(r)+ b,y:(rh)
		unhandled("b,x:(r)+ b,y:(rh)");
		break;
		}
	case 2428: { // x0,x:(r) y0,y:(rh)+n
		unhandled("x0,x:(r) y0,y:(rh)+n");
		break;
		}
	case 2429: { // x0,x:(r) y1,y:(rh)+n
		unhandled("x0,x:(r) y1,y:(rh)+n");
		break;
		}
	case 2430: { // x0,x:(r) a,y:(rh)+n
		unhandled("x0,x:(r) a,y:(rh)+n");
		break;
		}
	case 2431: { // x0,x:(r) b,y:(rh)+n
		unhandled("x0,x:(r) b,y:(rh)+n");
		break;
		}
	case 2432: { // x1,x:(r) y0,y:(rh)+n
		unhandled("x1,x:(r) y0,y:(rh)+n");
		break;
		}
	case 2433: { // x1,x:(r) y1,y:(rh)+n
		unhandled("x1,x:(r) y1,y:(rh)+n");
		break;
		}
	case 2434: { // x1,x:(r) a,y:(rh)+n
		unhandled("x1,x:(r) a,y:(rh)+n");
		break;
		}
	case 2435: { // x1,x:(r) b,y:(rh)+n
		unhandled("x1,x:(r) b,y:(rh)+n");
		break;
		}
	case 2436: { // a,x:(r) y0,y:(rh)+n
		unhandled("a,x:(r) y0,y:(rh)+n");
		break;
		}
	case 2437: { // a,x:(r) y1,y:(rh)+n
		unhandled("a,x:(r) y1,y:(rh)+n");
		break;
		}
	case 2438: { // a,x:(r) a,y:(rh)+n
		unhandled("a,x:(r) a,y:(rh)+n");
		break;
		}
	case 2439: { // a,x:(r) b,y:(rh)+n
		unhandled("a,x:(r) b,y:(rh)+n");
		break;
		}
	case 2440: { // b,x:(r) y0,y:(rh)+n
		unhandled("b,x:(r) y0,y:(rh)+n");
		break;
		}
	case 2441: { // b,x:(r) y1,y:(rh)+n
		unhandled("b,x:(r) y1,y:(rh)+n");
		break;
		}
	case 2442: { // b,x:(r) a,y:(rh)+n
		unhandled("b,x:(r) a,y:(rh)+n");
		break;
		}
	case 2443: { // b,x:(r) b,y:(rh)+n
		unhandled("b,x:(r) b,y:(rh)+n");
		break;
		}
	case 2444: { // x0,x:(r) y0,y:(rh)-
		unhandled("x0,x:(r) y0,y:(rh)-");
		break;
		}
	case 2445: { // x0,x:(r) y1,y:(rh)-
		unhandled("x0,x:(r) y1,y:(rh)-");
		break;
		}
	case 2446: { // x0,x:(r) a,y:(rh)-
		unhandled("x0,x:(r) a,y:(rh)-");
		break;
		}
	case 2447: { // x0,x:(r) b,y:(rh)-
		unhandled("x0,x:(r) b,y:(rh)-");
		break;
		}
	case 2448: { // x1,x:(r) y0,y:(rh)-
		unhandled("x1,x:(r) y0,y:(rh)-");
		break;
		}
	case 2449: { // x1,x:(r) y1,y:(rh)-
		unhandled("x1,x:(r) y1,y:(rh)-");
		break;
		}
	case 2450: { // x1,x:(r) a,y:(rh)-
		unhandled("x1,x:(r) a,y:(rh)-");
		break;
		}
	case 2451: { // x1,x:(r) b,y:(rh)-
		unhandled("x1,x:(r) b,y:(rh)-");
		break;
		}
	case 2452: { // a,x:(r) y0,y:(rh)-
		unhandled("a,x:(r) y0,y:(rh)-");
		break;
		}
	case 2453: { // a,x:(r) y1,y:(rh)-
		unhandled("a,x:(r) y1,y:(rh)-");
		break;
		}
	case 2454: { // a,x:(r) a,y:(rh)-
		unhandled("a,x:(r) a,y:(rh)-");
		break;
		}
	case 2455: { // a,x:(r) b,y:(rh)-
		unhandled("a,x:(r) b,y:(rh)-");
		break;
		}
	case 2456: { // b,x:(r) y0,y:(rh)-
		unhandled("b,x:(r) y0,y:(rh)-");
		break;
		}
	case 2457: { // b,x:(r) y1,y:(rh)-
		unhandled("b,x:(r) y1,y:(rh)-");
		break;
		}
	case 2458: { // b,x:(r) a,y:(rh)-
		unhandled("b,x:(r) a,y:(rh)-");
		break;
		}
	case 2459: { // b,x:(r) b,y:(rh)-
		unhandled("b,x:(r) b,y:(rh)-");
		break;
		}
	case 2460: { // x0,x:(r) y0,y:(rh)+
		unhandled("x0,x:(r) y0,y:(rh)+");
		break;
		}
	case 2461: { // x0,x:(r) y1,y:(rh)+
		unhandled("x0,x:(r) y1,y:(rh)+");
		break;
		}
	case 2462: { // x0,x:(r) a,y:(rh)+
		unhandled("x0,x:(r) a,y:(rh)+");
		break;
		}
	case 2463: { // x0,x:(r) b,y:(rh)+
		unhandled("x0,x:(r) b,y:(rh)+");
		break;
		}
	case 2464: { // x1,x:(r) y0,y:(rh)+
		unhandled("x1,x:(r) y0,y:(rh)+");
		break;
		}
	case 2465: { // x1,x:(r) y1,y:(rh)+
		unhandled("x1,x:(r) y1,y:(rh)+");
		break;
		}
	case 2466: { // x1,x:(r) a,y:(rh)+
		unhandled("x1,x:(r) a,y:(rh)+");
		break;
		}
	case 2467: { // x1,x:(r) b,y:(rh)+
		unhandled("x1,x:(r) b,y:(rh)+");
		break;
		}
	case 2468: { // a,x:(r) y0,y:(rh)+
		unhandled("a,x:(r) y0,y:(rh)+");
		break;
		}
	case 2469: { // a,x:(r) y1,y:(rh)+
		unhandled("a,x:(r) y1,y:(rh)+");
		break;
		}
	case 2470: { // a,x:(r) a,y:(rh)+
		unhandled("a,x:(r) a,y:(rh)+");
		break;
		}
	case 2471: { // a,x:(r) b,y:(rh)+
		unhandled("a,x:(r) b,y:(rh)+");
		break;
		}
	case 2472: { // b,x:(r) y0,y:(rh)+
		unhandled("b,x:(r) y0,y:(rh)+");
		break;
		}
	case 2473: { // b,x:(r) y1,y:(rh)+
		unhandled("b,x:(r) y1,y:(rh)+");
		break;
		}
	case 2474: { // b,x:(r) a,y:(rh)+
		unhandled("b,x:(r) a,y:(rh)+");
		break;
		}
	case 2475: { // b,x:(r) b,y:(rh)+
		unhandled("b,x:(r) b,y:(rh)+");
		break;
		}
	case 2476: { // x0,x:(r) y0,y:(rh)
		unhandled("x0,x:(r) y0,y:(rh)");
		break;
		}
	case 2477: { // x0,x:(r) y1,y:(rh)
		unhandled("x0,x:(r) y1,y:(rh)");
		break;
		}
	case 2478: { // x0,x:(r) a,y:(rh)
		unhandled("x0,x:(r) a,y:(rh)");
		break;
		}
	case 2479: { // x0,x:(r) b,y:(rh)
		unhandled("x0,x:(r) b,y:(rh)");
		break;
		}
	case 2480: { // x1,x:(r) y0,y:(rh)
		unhandled("x1,x:(r) y0,y:(rh)");
		break;
		}
	case 2481: { // x1,x:(r) y1,y:(rh)
		unhandled("x1,x:(r) y1,y:(rh)");
		break;
		}
	case 2482: { // x1,x:(r) a,y:(rh)
		unhandled("x1,x:(r) a,y:(rh)");
		break;
		}
	case 2483: { // x1,x:(r) b,y:(rh)
		unhandled("x1,x:(r) b,y:(rh)");
		break;
		}
	case 2484: { // a,x:(r) y0,y:(rh)
		unhandled("a,x:(r) y0,y:(rh)");
		break;
		}
	case 2485: { // a,x:(r) y1,y:(rh)
		unhandled("a,x:(r) y1,y:(rh)");
		break;
		}
	case 2486: { // a,x:(r) a,y:(rh)
		unhandled("a,x:(r) a,y:(rh)");
		break;
		}
	case 2487: { // a,x:(r) b,y:(rh)
		unhandled("a,x:(r) b,y:(rh)");
		break;
		}
	case 2488: { // b,x:(r) y0,y:(rh)
		unhandled("b,x:(r) y0,y:(rh)");
		break;
		}
	case 2489: { // b,x:(r) y1,y:(rh)
		unhandled("b,x:(r) y1,y:(rh)");
		break;
		}
	case 2490: { // b,x:(r) a,y:(rh)
		unhandled("b,x:(r) a,y:(rh)");
		break;
		}
	case 2491: { // b,x:(r) b,y:(rh)
		unhandled("b,x:(r) b,y:(rh)");
		break;
		}
	case 2492: { // ifcc
		unhandled("ifcc");
		break;
		}
	case 2493: { // ifge
		unhandled("ifge");
		break;
		}
	case 2494: { // ifne
		unhandled("ifne");
		break;
		}
	case 2495: { // ifpl
		unhandled("ifpl");
		break;
		}
	case 2496: { // ifnn
		unhandled("ifnn");
		break;
		}
	case 2497: { // ifec
		unhandled("ifec");
		break;
		}
	case 2498: { // iflc
		unhandled("iflc");
		break;
		}
	case 2499: { // ifgt
		unhandled("ifgt");
		break;
		}
	case 2500: { // ifcs
		unhandled("ifcs");
		break;
		}
	case 2501: { // iflt
		unhandled("iflt");
		break;
		}
	case 2502: { // ifeq
		unhandled("ifeq");
		break;
		}
	case 2503: { // ifmi
		unhandled("ifmi");
		break;
		}
	case 2504: { // ifnr
		unhandled("ifnr");
		break;
		}
	case 2505: { // ifes
		unhandled("ifes");
		break;
		}
	case 2506: { // ifls
		unhandled("ifls");
		break;
		}
	case 2507: { // ifle
		unhandled("ifle");
		break;
		}
	case 2508: { // ifcc.u
		unhandled("ifcc.u");
		break;
		}
	case 2509: { // ifge.u
		unhandled("ifge.u");
		break;
		}
	case 2510: { // ifne.u
		unhandled("ifne.u");
		break;
		}
	case 2511: { // ifpl.u
		unhandled("ifpl.u");
		break;
		}
	case 2512: { // ifnn.u
		unhandled("ifnn.u");
		break;
		}
	case 2513: { // ifec.u
		unhandled("ifec.u");
		break;
		}
	case 2514: { // iflc.u
		unhandled("iflc.u");
		break;
		}
	case 2515: { // ifgt.u
		unhandled("ifgt.u");
		break;
		}
	case 2516: { // ifcs.u
		unhandled("ifcs.u");
		break;
		}
	case 2517: { // iflt.u
		unhandled("iflt.u");
		break;
		}
	case 2518: { // ifeq.u
		unhandled("ifeq.u");
		break;
		}
	case 2519: { // ifmi.u
		unhandled("ifmi.u");
		break;
		}
	case 2520: { // ifnr.u
		unhandled("ifnr.u");
		break;
		}
	case 2521: { // ifes.u
		unhandled("ifes.u");
		break;
		}
	case 2522: { // ifls.u
		unhandled("ifls.u");
		break;
		}
	case 2523: { // ifle.u
		unhandled("ifle.u");
		break;
		}
	}
}

void dsp563xx_device::execute_npar(u16 knpar, u32 opcode, u32 exv)
{
	switch(knpar) {
	case 0: { // -
		break;
		}
	case 1: { //
		break;
		}
	case 2: { // move x:(r+[o]),x0
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		set_x0(m_x.read_dword(r + o));
		break;
		}
	case 3: { // move x:(r+[o]),x1
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		set_x1(m_x.read_dword(r + o));
		break;
		}
	case 4: { // move x:(r+[o]),y0
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		set_y0(m_x.read_dword(r + o));
		break;
		}
	case 5: { // move x:(r+[o]),y1
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		set_y1(m_x.read_dword(r + o));
		break;
		}
	case 6: { // move x:(r+[o]),a0
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		set_a0(m_x.read_dword(r + o));
		break;
		}
	case 7: { // move x:(r+[o]),b0
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		set_b0(m_x.read_dword(r + o));
		break;
		}
	case 8: { // move x:(r+[o]),a2
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		set_a2(m_x.read_dword(r + o));
		break;
		}
	case 9: { // move x:(r+[o]),b2
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		set_b2(m_x.read_dword(r + o));
		break;
		}
	case 10: { // move x:(r+[o]),a1
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		set_a1(m_x.read_dword(r + o));
		break;
		}
	case 11: { // move x:(r+[o]),b1
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		set_b1(m_x.read_dword(r + o));
		break;
		}
	case 12: { // move x:(r+[o]),a
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		set_ah(m_x.read_dword(r + o));
		break;
		}
	case 13: { // move x:(r+[o]),b
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		set_bh(m_x.read_dword(r + o));
		break;
		}
	case 14: { // move x:(r+[o]),r
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		set_r(BIT(opcode, 0, 6) & 7, m_x.read_dword(r + o));
		break;
		}
	case 15: { // move x:(r+[o]),n
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		set_n(BIT(opcode, 0, 6) & 7, m_x.read_dword(r + o));
		break;
		}
	case 16: { // move x:(r+[o]),m
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		set_m(BIT(opcode, 0, 6) & 7, m_x.read_dword(r + o));
		break;
		}
	case 17: { // move x:(r+[o]),ep
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		set_ep(m_x.read_dword(r + o));
		break;
		}
	case 18: { // move x:(r+[o]),vba
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		set_vba(m_x.read_dword(r + o));
		break;
		}
	case 19: { // move x:(r+[o]),sc
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		set_sc(m_x.read_dword(r + o));
		break;
		}
	case 20: { // move x:(r+[o]),sz
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		set_sz(m_x.read_dword(r + o));
		break;
		}
	case 21: { // move x:(r+[o]),sr
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		set_sr(m_x.read_dword(r + o));
		break;
		}
	case 22: { // move x:(r+[o]),omr
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		set_omr(m_x.read_dword(r + o));
		break;
		}
	case 23: { // move x:(r+[o]),sp
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		set_sp(m_x.read_dword(r + o));
		break;
		}
	case 24: { // move x:(r+[o]),ssh
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		set_ssh(m_x.read_dword(r + o));
		break;
		}
	case 25: { // move x:(r+[o]),ssl
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		set_ssl(m_x.read_dword(r + o));
		break;
		}
	case 26: { // move x:(r+[o]),la
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		set_la(m_x.read_dword(r + o));
		break;
		}
	case 27: { // move x:(r+[o]),lc
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		set_lc(m_x.read_dword(r + o));
		break;
		}
	case 28: { // move y:(r+[o]),x0
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		set_x0(m_y.read_dword(r + o));
		break;
		}
	case 29: { // move y:(r+[o]),x1
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		set_x1(m_y.read_dword(r + o));
		break;
		}
	case 30: { // move y:(r+[o]),y0
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		set_y0(m_y.read_dword(r + o));
		break;
		}
	case 31: { // move y:(r+[o]),y1
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		set_y1(m_y.read_dword(r + o));
		break;
		}
	case 32: { // move y:(r+[o]),a0
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		set_a0(m_y.read_dword(r + o));
		break;
		}
	case 33: { // move y:(r+[o]),b0
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		set_b0(m_y.read_dword(r + o));
		break;
		}
	case 34: { // move y:(r+[o]),a2
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		set_a2(m_y.read_dword(r + o));
		break;
		}
	case 35: { // move y:(r+[o]),b2
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		set_b2(m_y.read_dword(r + o));
		break;
		}
	case 36: { // move y:(r+[o]),a1
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		set_a1(m_y.read_dword(r + o));
		break;
		}
	case 37: { // move y:(r+[o]),b1
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		set_b1(m_y.read_dword(r + o));
		break;
		}
	case 38: { // move y:(r+[o]),a
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		set_ah(m_y.read_dword(r + o));
		break;
		}
	case 39: { // move y:(r+[o]),b
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		set_bh(m_y.read_dword(r + o));
		break;
		}
	case 40: { // move y:(r+[o]),r
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		set_r(BIT(opcode, 0, 6) & 7, m_y.read_dword(r + o));
		break;
		}
	case 41: { // move y:(r+[o]),n
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		set_n(BIT(opcode, 0, 6) & 7, m_y.read_dword(r + o));
		break;
		}
	case 42: { // move y:(r+[o]),m
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		set_m(BIT(opcode, 0, 6) & 7, m_y.read_dword(r + o));
		break;
		}
	case 43: { // move y:(r+[o]),ep
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		set_ep(m_y.read_dword(r + o));
		break;
		}
	case 44: { // move y:(r+[o]),vba
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		set_vba(m_y.read_dword(r + o));
		break;
		}
	case 45: { // move y:(r+[o]),sc
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		set_sc(m_y.read_dword(r + o));
		break;
		}
	case 46: { // move y:(r+[o]),sz
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		set_sz(m_y.read_dword(r + o));
		break;
		}
	case 47: { // move y:(r+[o]),sr
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		set_sr(m_y.read_dword(r + o));
		break;
		}
	case 48: { // move y:(r+[o]),omr
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		set_omr(m_y.read_dword(r + o));
		break;
		}
	case 49: { // move y:(r+[o]),sp
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		set_sp(m_y.read_dword(r + o));
		break;
		}
	case 50: { // move y:(r+[o]),ssh
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		set_ssh(m_y.read_dword(r + o));
		break;
		}
	case 51: { // move y:(r+[o]),ssl
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		set_ssl(m_y.read_dword(r + o));
		break;
		}
	case 52: { // move y:(r+[o]),la
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		set_la(m_y.read_dword(r + o));
		break;
		}
	case 53: { // move y:(r+[o]),lc
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		set_lc(m_y.read_dword(r + o));
		break;
		}
	case 54: { // move x0,x:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		u32 s = get_x0();
		m_x.write_dword(r + o, s);
		break;
		}
	case 55: { // move x1,x:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		u32 s = get_x1();
		m_x.write_dword(r + o, s);
		break;
		}
	case 56: { // move y0,x:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		u32 s = get_y0();
		m_x.write_dword(r + o, s);
		break;
		}
	case 57: { // move y1,x:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		u32 s = get_y1();
		m_x.write_dword(r + o, s);
		break;
		}
	case 58: { // move a0,x:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		u32 s = get_a0();
		m_x.write_dword(r + o, s);
		break;
		}
	case 59: { // move b0,x:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		u32 s = get_b0();
		m_x.write_dword(r + o, s);
		break;
		}
	case 60: { // move a2,x:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		u32 s = get_a2();
		m_x.write_dword(r + o, s);
		break;
		}
	case 61: { // move b2,x:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		u32 s = get_b2();
		m_x.write_dword(r + o, s);
		break;
		}
	case 62: { // move a1,x:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		u32 s = get_a1();
		m_x.write_dword(r + o, s);
		break;
		}
	case 63: { // move b1,x:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		u32 s = get_b1();
		m_x.write_dword(r + o, s);
		break;
		}
	case 64: { // move a,x:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		u32 s_h = get_ah();
		m_x.write_dword(r + o, s_h);
		break;
		}
	case 65: { // move b,x:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		u32 s_h = get_bh();
		m_x.write_dword(r + o, s_h);
		break;
		}
	case 66: { // move r,x:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		u32 s = get_r(BIT(opcode, 0, 6) & 7);
		m_x.write_dword(r + o, s);
		break;
		}
	case 67: { // move n,x:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		u32 s = get_n(BIT(opcode, 0, 6) & 7);
		m_x.write_dword(r + o, s);
		break;
		}
	case 68: { // move m,x:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		u32 s = get_m(BIT(opcode, 0, 6) & 7);
		m_x.write_dword(r + o, s);
		break;
		}
	case 69: { // move ep,x:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		u32 s = get_ep();
		m_x.write_dword(r + o, s);
		break;
		}
	case 70: { // move vba,x:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		u32 s = get_vba();
		m_x.write_dword(r + o, s);
		break;
		}
	case 71: { // move sc,x:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		u32 s = get_sc();
		m_x.write_dword(r + o, s);
		break;
		}
	case 72: { // move sz,x:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		u32 s = get_sz();
		m_x.write_dword(r + o, s);
		break;
		}
	case 73: { // move sr,x:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		u32 s = get_sr();
		m_x.write_dword(r + o, s);
		break;
		}
	case 74: { // move omr,x:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		u32 s = get_omr();
		m_x.write_dword(r + o, s);
		break;
		}
	case 75: { // move sp,x:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		u32 s = get_sp();
		m_x.write_dword(r + o, s);
		break;
		}
	case 76: { // move ssh,x:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		u32 s = get_ssh();
		m_x.write_dword(r + o, s);
		break;
		}
	case 77: { // move ssl,x:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		u32 s = get_ssl();
		m_x.write_dword(r + o, s);
		break;
		}
	case 78: { // move la,x:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		u32 s = get_la();
		m_x.write_dword(r + o, s);
		break;
		}
	case 79: { // move lc,x:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		u32 s = get_lc();
		m_x.write_dword(r + o, s);
		break;
		}
	case 80: { // move x0,y:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		u32 s = get_x0();
		m_y.write_dword(r + o, s);
		break;
		}
	case 81: { // move x1,y:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		u32 s = get_x1();
		m_y.write_dword(r + o, s);
		break;
		}
	case 82: { // move y0,y:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		u32 s = get_y0();
		m_y.write_dword(r + o, s);
		break;
		}
	case 83: { // move y1,y:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		u32 s = get_y1();
		m_y.write_dword(r + o, s);
		break;
		}
	case 84: { // move a0,y:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		u32 s = get_a0();
		m_y.write_dword(r + o, s);
		break;
		}
	case 85: { // move b0,y:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		u32 s = get_b0();
		m_y.write_dword(r + o, s);
		break;
		}
	case 86: { // move a2,y:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		u32 s = get_a2();
		m_y.write_dword(r + o, s);
		break;
		}
	case 87: { // move b2,y:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		u32 s = get_b2();
		m_y.write_dword(r + o, s);
		break;
		}
	case 88: { // move a1,y:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		u32 s = get_a1();
		m_y.write_dword(r + o, s);
		break;
		}
	case 89: { // move b1,y:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		u32 s = get_b1();
		m_y.write_dword(r + o, s);
		break;
		}
	case 90: { // move a,y:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		u32 s_h = get_ah();
		m_y.write_dword(r + o, s_h);
		break;
		}
	case 91: { // move b,y:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		u32 s_h = get_bh();
		m_y.write_dword(r + o, s_h);
		break;
		}
	case 92: { // move r,y:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		u32 s = get_r(BIT(opcode, 0, 6) & 7);
		m_y.write_dword(r + o, s);
		break;
		}
	case 93: { // move n,y:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		u32 s = get_n(BIT(opcode, 0, 6) & 7);
		m_y.write_dword(r + o, s);
		break;
		}
	case 94: { // move m,y:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		u32 s = get_m(BIT(opcode, 0, 6) & 7);
		m_y.write_dword(r + o, s);
		break;
		}
	case 95: { // move ep,y:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		u32 s = get_ep();
		m_y.write_dword(r + o, s);
		break;
		}
	case 96: { // move vba,y:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		u32 s = get_vba();
		m_y.write_dword(r + o, s);
		break;
		}
	case 97: { // move sc,y:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		u32 s = get_sc();
		m_y.write_dword(r + o, s);
		break;
		}
	case 98: { // move sz,y:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		u32 s = get_sz();
		m_y.write_dword(r + o, s);
		break;
		}
	case 99: { // move sr,y:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		u32 s = get_sr();
		m_y.write_dword(r + o, s);
		break;
		}
	case 100: { // move omr,y:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		u32 s = get_omr();
		m_y.write_dword(r + o, s);
		break;
		}
	case 101: { // move sp,y:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		u32 s = get_sp();
		m_y.write_dword(r + o, s);
		break;
		}
	case 102: { // move ssh,y:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		u32 s = get_ssh();
		m_y.write_dword(r + o, s);
		break;
		}
	case 103: { // move ssl,y:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		u32 s = get_ssl();
		m_y.write_dword(r + o, s);
		break;
		}
	case 104: { // move la,y:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		u32 s = get_la();
		m_y.write_dword(r + o, s);
		break;
		}
	case 105: { // move lc,y:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = exv;
		u32 s = get_lc();
		m_y.write_dword(r + o, s);
		break;
		}
	case 106: { // move x:(r+[o]),x0
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = util::sext(bitswap<7>(opcode, 16, 15, 14, 13, 12, 11, 6), 7);
		set_x0(m_x.read_dword(r + o));
		break;
		}
	case 107: { // move x:(r+[o]),x1
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = util::sext(bitswap<7>(opcode, 16, 15, 14, 13, 12, 11, 6), 7);
		set_x1(m_x.read_dword(r + o));
		break;
		}
	case 108: { // move x:(r+[o]),y0
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = util::sext(bitswap<7>(opcode, 16, 15, 14, 13, 12, 11, 6), 7);
		set_y0(m_x.read_dword(r + o));
		break;
		}
	case 109: { // move x:(r+[o]),y1
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = util::sext(bitswap<7>(opcode, 16, 15, 14, 13, 12, 11, 6), 7);
		set_y1(m_x.read_dword(r + o));
		break;
		}
	case 110: { // move x:(r+[o]),a0
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = util::sext(bitswap<7>(opcode, 16, 15, 14, 13, 12, 11, 6), 7);
		set_a0(m_x.read_dword(r + o));
		break;
		}
	case 111: { // move x:(r+[o]),b0
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = util::sext(bitswap<7>(opcode, 16, 15, 14, 13, 12, 11, 6), 7);
		set_b0(m_x.read_dword(r + o));
		break;
		}
	case 112: { // move x:(r+[o]),a2
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = util::sext(bitswap<7>(opcode, 16, 15, 14, 13, 12, 11, 6), 7);
		set_a2(m_x.read_dword(r + o));
		break;
		}
	case 113: { // move x:(r+[o]),b2
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = util::sext(bitswap<7>(opcode, 16, 15, 14, 13, 12, 11, 6), 7);
		set_b2(m_x.read_dword(r + o));
		break;
		}
	case 114: { // move x:(r+[o]),a1
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = util::sext(bitswap<7>(opcode, 16, 15, 14, 13, 12, 11, 6), 7);
		set_a1(m_x.read_dword(r + o));
		break;
		}
	case 115: { // move x:(r+[o]),b1
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = util::sext(bitswap<7>(opcode, 16, 15, 14, 13, 12, 11, 6), 7);
		set_b1(m_x.read_dword(r + o));
		break;
		}
	case 116: { // move x:(r+[o]),a
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = util::sext(bitswap<7>(opcode, 16, 15, 14, 13, 12, 11, 6), 7);
		set_ah(m_x.read_dword(r + o));
		break;
		}
	case 117: { // move x:(r+[o]),b
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = util::sext(bitswap<7>(opcode, 16, 15, 14, 13, 12, 11, 6), 7);
		set_bh(m_x.read_dword(r + o));
		break;
		}
	case 118: { // move y:(r+[o]),x0
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = util::sext(bitswap<7>(opcode, 16, 15, 14, 13, 12, 11, 6), 7);
		set_x0(m_y.read_dword(r + o));
		break;
		}
	case 119: { // move y:(r+[o]),x1
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = util::sext(bitswap<7>(opcode, 16, 15, 14, 13, 12, 11, 6), 7);
		set_x1(m_y.read_dword(r + o));
		break;
		}
	case 120: { // move y:(r+[o]),y0
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = util::sext(bitswap<7>(opcode, 16, 15, 14, 13, 12, 11, 6), 7);
		set_y0(m_y.read_dword(r + o));
		break;
		}
	case 121: { // move y:(r+[o]),y1
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = util::sext(bitswap<7>(opcode, 16, 15, 14, 13, 12, 11, 6), 7);
		set_y1(m_y.read_dword(r + o));
		break;
		}
	case 122: { // move y:(r+[o]),a0
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = util::sext(bitswap<7>(opcode, 16, 15, 14, 13, 12, 11, 6), 7);
		set_a0(m_y.read_dword(r + o));
		break;
		}
	case 123: { // move y:(r+[o]),b0
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = util::sext(bitswap<7>(opcode, 16, 15, 14, 13, 12, 11, 6), 7);
		set_b0(m_y.read_dword(r + o));
		break;
		}
	case 124: { // move y:(r+[o]),a2
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = util::sext(bitswap<7>(opcode, 16, 15, 14, 13, 12, 11, 6), 7);
		set_a2(m_y.read_dword(r + o));
		break;
		}
	case 125: { // move y:(r+[o]),b2
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = util::sext(bitswap<7>(opcode, 16, 15, 14, 13, 12, 11, 6), 7);
		set_b2(m_y.read_dword(r + o));
		break;
		}
	case 126: { // move y:(r+[o]),a1
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = util::sext(bitswap<7>(opcode, 16, 15, 14, 13, 12, 11, 6), 7);
		set_a1(m_y.read_dword(r + o));
		break;
		}
	case 127: { // move y:(r+[o]),b1
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = util::sext(bitswap<7>(opcode, 16, 15, 14, 13, 12, 11, 6), 7);
		set_b1(m_y.read_dword(r + o));
		break;
		}
	case 128: { // move y:(r+[o]),a
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = util::sext(bitswap<7>(opcode, 16, 15, 14, 13, 12, 11, 6), 7);
		set_ah(m_y.read_dword(r + o));
		break;
		}
	case 129: { // move y:(r+[o]),b
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = util::sext(bitswap<7>(opcode, 16, 15, 14, 13, 12, 11, 6), 7);
		set_bh(m_y.read_dword(r + o));
		break;
		}
	case 130: { // move x0,x:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = util::sext(bitswap<7>(opcode, 16, 15, 14, 13, 12, 11, 6), 7);
		u32 s = get_x0();
		m_x.write_dword(r + o, s);
		break;
		}
	case 131: { // move x1,x:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = util::sext(bitswap<7>(opcode, 16, 15, 14, 13, 12, 11, 6), 7);
		u32 s = get_x1();
		m_x.write_dword(r + o, s);
		break;
		}
	case 132: { // move y0,x:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = util::sext(bitswap<7>(opcode, 16, 15, 14, 13, 12, 11, 6), 7);
		u32 s = get_y0();
		m_x.write_dword(r + o, s);
		break;
		}
	case 133: { // move y1,x:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = util::sext(bitswap<7>(opcode, 16, 15, 14, 13, 12, 11, 6), 7);
		u32 s = get_y1();
		m_x.write_dword(r + o, s);
		break;
		}
	case 134: { // move a0,x:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = util::sext(bitswap<7>(opcode, 16, 15, 14, 13, 12, 11, 6), 7);
		u32 s = get_a0();
		m_x.write_dword(r + o, s);
		break;
		}
	case 135: { // move b0,x:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = util::sext(bitswap<7>(opcode, 16, 15, 14, 13, 12, 11, 6), 7);
		u32 s = get_b0();
		m_x.write_dword(r + o, s);
		break;
		}
	case 136: { // move a2,x:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = util::sext(bitswap<7>(opcode, 16, 15, 14, 13, 12, 11, 6), 7);
		u32 s = get_a2();
		m_x.write_dword(r + o, s);
		break;
		}
	case 137: { // move b2,x:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = util::sext(bitswap<7>(opcode, 16, 15, 14, 13, 12, 11, 6), 7);
		u32 s = get_b2();
		m_x.write_dword(r + o, s);
		break;
		}
	case 138: { // move a1,x:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = util::sext(bitswap<7>(opcode, 16, 15, 14, 13, 12, 11, 6), 7);
		u32 s = get_a1();
		m_x.write_dword(r + o, s);
		break;
		}
	case 139: { // move b1,x:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = util::sext(bitswap<7>(opcode, 16, 15, 14, 13, 12, 11, 6), 7);
		u32 s = get_b1();
		m_x.write_dword(r + o, s);
		break;
		}
	case 140: { // move a,x:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = util::sext(bitswap<7>(opcode, 16, 15, 14, 13, 12, 11, 6), 7);
		u32 s_h = get_ah();
		m_x.write_dword(r + o, s_h);
		break;
		}
	case 141: { // move b,x:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = util::sext(bitswap<7>(opcode, 16, 15, 14, 13, 12, 11, 6), 7);
		u32 s_h = get_bh();
		m_x.write_dword(r + o, s_h);
		break;
		}
	case 142: { // move x0,y:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = util::sext(bitswap<7>(opcode, 16, 15, 14, 13, 12, 11, 6), 7);
		u32 s = get_x0();
		m_y.write_dword(r + o, s);
		break;
		}
	case 143: { // move x1,y:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = util::sext(bitswap<7>(opcode, 16, 15, 14, 13, 12, 11, 6), 7);
		u32 s = get_x1();
		m_y.write_dword(r + o, s);
		break;
		}
	case 144: { // move y0,y:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = util::sext(bitswap<7>(opcode, 16, 15, 14, 13, 12, 11, 6), 7);
		u32 s = get_y0();
		m_y.write_dword(r + o, s);
		break;
		}
	case 145: { // move y1,y:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = util::sext(bitswap<7>(opcode, 16, 15, 14, 13, 12, 11, 6), 7);
		u32 s = get_y1();
		m_y.write_dword(r + o, s);
		break;
		}
	case 146: { // move a0,y:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = util::sext(bitswap<7>(opcode, 16, 15, 14, 13, 12, 11, 6), 7);
		u32 s = get_a0();
		m_y.write_dword(r + o, s);
		break;
		}
	case 147: { // move b0,y:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = util::sext(bitswap<7>(opcode, 16, 15, 14, 13, 12, 11, 6), 7);
		u32 s = get_b0();
		m_y.write_dword(r + o, s);
		break;
		}
	case 148: { // move a2,y:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = util::sext(bitswap<7>(opcode, 16, 15, 14, 13, 12, 11, 6), 7);
		u32 s = get_a2();
		m_y.write_dword(r + o, s);
		break;
		}
	case 149: { // move b2,y:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = util::sext(bitswap<7>(opcode, 16, 15, 14, 13, 12, 11, 6), 7);
		u32 s = get_b2();
		m_y.write_dword(r + o, s);
		break;
		}
	case 150: { // move a1,y:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = util::sext(bitswap<7>(opcode, 16, 15, 14, 13, 12, 11, 6), 7);
		u32 s = get_a1();
		m_y.write_dword(r + o, s);
		break;
		}
	case 151: { // move b1,y:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = util::sext(bitswap<7>(opcode, 16, 15, 14, 13, 12, 11, 6), 7);
		u32 s = get_b1();
		m_y.write_dword(r + o, s);
		break;
		}
	case 152: { // move a,y:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = util::sext(bitswap<7>(opcode, 16, 15, 14, 13, 12, 11, 6), 7);
		u32 s_h = get_ah();
		m_y.write_dword(r + o, s_h);
		break;
		}
	case 153: { // move b,y:(r+[o])
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = util::sext(bitswap<7>(opcode, 16, 15, 14, 13, 12, 11, 6), 7);
		u32 s_h = get_bh();
		m_y.write_dword(r + o, s_h);
		break;
		}
	case 154: { // add #[i],a
		u64 d = get_a();
		u32 i = BIT(opcode, 8, 6);
		d = do_add56(u64(i) << 24, d);
		break;
		}
	case 155: { // add #[i],b
		u64 d = get_b();
		u32 i = BIT(opcode, 8, 6);
		d = do_add56(u64(i) << 24, d);
		break;
		}
	case 156: { // add #[i],a
		u64 d = get_a();
		u32 i = exv;
		d = do_add56(util::sext(i << 24, 48), d);
		break;
		}
	case 157: { // add #[i],b
		u64 d = get_b();
		u32 i = exv;
		d = do_add56(util::sext(i << 24, 48), d);
		break;
		}
	case 158: { // and #[i],a
		u32 d_1 = get_a1();
		u32 i = BIT(opcode, 8, 6);
		u32 r = d_1 & i;
		m_ccr = m_ccr & ~(CCR_V|CCR_Z|CCR_N);
		if(!r) {
		m_ccr = m_ccr | CCR_Z;
		} else if(BIT(r, 23)) {
		m_ccr = m_ccr | CCR_N;
		}
		set_a1(r);
		break;
		}
	case 159: { // and #[i],b
		u32 d_1 = get_b1();
		u32 i = BIT(opcode, 8, 6);
		u32 r = d_1 & i;
		m_ccr = m_ccr & ~(CCR_V|CCR_Z|CCR_N);
		if(!r) {
		m_ccr = m_ccr | CCR_Z;
		} else if(BIT(r, 23)) {
		m_ccr = m_ccr | CCR_N;
		}
		set_b1(r);
		break;
		}
	case 160: { // and #[i],a
		u32 d_1 = get_a1();
		u32 i = exv;
		u32 r = d_1 & i;
		m_ccr = m_ccr & ~(CCR_V|CCR_Z|CCR_N);
		if(!r) {
		m_ccr = m_ccr | CCR_Z;
		} else if(BIT(r, 23)) {
		m_ccr = m_ccr | CCR_N;
		}
		set_a1(r);
		break;
		}
	case 161: { // and #[i],b
		u32 d_1 = get_b1();
		u32 i = exv;
		u32 r = d_1 & i;
		m_ccr = m_ccr & ~(CCR_V|CCR_Z|CCR_N);
		if(!r) {
		m_ccr = m_ccr | CCR_Z;
		} else if(BIT(r, 23)) {
		m_ccr = m_ccr | CCR_N;
		}
		set_b1(r);
		break;
		}
	case 162: { // andi #[i],mr
		u32 ctrl = get_mr();
		u32 i = BIT(opcode, 8, 8);
		set_mr(ctrl & i);
		break;
		}
	case 163: { // andi #[i],ccr
		u32 ctrl = get_ccr();
		u32 i = BIT(opcode, 8, 8);
		set_ccr(ctrl & i);
		break;
		}
	case 164: { // andi #[i],com
		u32 ctrl = get_com();
		u32 i = BIT(opcode, 8, 8);
		set_com(ctrl & i);
		break;
		}
	case 165: { // andi #[i],eom
		u32 ctrl = get_eom();
		u32 i = BIT(opcode, 8, 8);
		set_eom(ctrl & i);
		break;
		}
	case 166: { // asl #[i],a,a
		u32 i = BIT(opcode, 1, 6);
		u64 s2 = get_a();
		set_a(do_asl56(i, s2));
		break;
		}
	case 167: { // asl #[i],a,b
		u32 i = BIT(opcode, 1, 6);
		u64 s2 = get_a();
		set_b(do_asl56(i, s2));
		break;
		}
	case 168: { // asl #[i],b,a
		u32 i = BIT(opcode, 1, 6);
		u64 s2 = get_b();
		set_a(do_asl56(i, s2));
		break;
		}
	case 169: { // asl #[i],b,b
		u32 i = BIT(opcode, 1, 6);
		u64 s2 = get_b();
		set_b(do_asl56(i, s2));
		break;
		}
	case 170: { // asl a1,a,a
		u32 s1 = get_a1();
		u64 s2 = get_a();
		set_a(do_asl56(s1, s2));
		break;
		}
	case 171: { // asl a1,a,b
		u32 s1 = get_a1();
		u64 s2 = get_a();
		set_b(do_asl56(s1, s2));
		break;
		}
	case 172: { // asl b1,a,a
		u32 s1 = get_b1();
		u64 s2 = get_a();
		set_a(do_asl56(s1, s2));
		break;
		}
	case 173: { // asl b1,a,b
		u32 s1 = get_b1();
		u64 s2 = get_a();
		set_b(do_asl56(s1, s2));
		break;
		}
	case 174: { // asl x0,a,a
		u32 s1 = get_x0();
		u64 s2 = get_a();
		set_a(do_asl56(s1, s2));
		break;
		}
	case 175: { // asl x0,a,b
		u32 s1 = get_x0();
		u64 s2 = get_a();
		set_b(do_asl56(s1, s2));
		break;
		}
	case 176: { // asl y0,a,a
		u32 s1 = get_y0();
		u64 s2 = get_a();
		set_a(do_asl56(s1, s2));
		break;
		}
	case 177: { // asl y0,a,b
		u32 s1 = get_y0();
		u64 s2 = get_a();
		set_b(do_asl56(s1, s2));
		break;
		}
	case 178: { // asl x1,a,a
		u32 s1 = get_x1();
		u64 s2 = get_a();
		set_a(do_asl56(s1, s2));
		break;
		}
	case 179: { // asl x1,a,b
		u32 s1 = get_x1();
		u64 s2 = get_a();
		set_b(do_asl56(s1, s2));
		break;
		}
	case 180: { // asl y1,a,a
		u32 s1 = get_y1();
		u64 s2 = get_a();
		set_a(do_asl56(s1, s2));
		break;
		}
	case 181: { // asl y1,a,b
		u32 s1 = get_y1();
		u64 s2 = get_a();
		set_b(do_asl56(s1, s2));
		break;
		}
	case 182: { // asl a1,b,a
		u32 s1 = get_a1();
		u64 s2 = get_b();
		set_a(do_asl56(s1, s2));
		break;
		}
	case 183: { // asl a1,b,b
		u32 s1 = get_a1();
		u64 s2 = get_b();
		set_b(do_asl56(s1, s2));
		break;
		}
	case 184: { // asl b1,b,a
		u32 s1 = get_b1();
		u64 s2 = get_b();
		set_a(do_asl56(s1, s2));
		break;
		}
	case 185: { // asl b1,b,b
		u32 s1 = get_b1();
		u64 s2 = get_b();
		set_b(do_asl56(s1, s2));
		break;
		}
	case 186: { // asl x0,b,a
		u32 s1 = get_x0();
		u64 s2 = get_b();
		set_a(do_asl56(s1, s2));
		break;
		}
	case 187: { // asl x0,b,b
		u32 s1 = get_x0();
		u64 s2 = get_b();
		set_b(do_asl56(s1, s2));
		break;
		}
	case 188: { // asl y0,b,a
		u32 s1 = get_y0();
		u64 s2 = get_b();
		set_a(do_asl56(s1, s2));
		break;
		}
	case 189: { // asl y0,b,b
		u32 s1 = get_y0();
		u64 s2 = get_b();
		set_b(do_asl56(s1, s2));
		break;
		}
	case 190: { // asl x1,b,a
		u32 s1 = get_x1();
		u64 s2 = get_b();
		set_a(do_asl56(s1, s2));
		break;
		}
	case 191: { // asl x1,b,b
		u32 s1 = get_x1();
		u64 s2 = get_b();
		set_b(do_asl56(s1, s2));
		break;
		}
	case 192: { // asl y1,b,a
		u32 s1 = get_y1();
		u64 s2 = get_b();
		set_a(do_asl56(s1, s2));
		break;
		}
	case 193: { // asl y1,b,b
		u32 s1 = get_y1();
		u64 s2 = get_b();
		set_b(do_asl56(s1, s2));
		break;
		}
	case 194: { // asr #[i],a,a
		u32 i = BIT(opcode, 1, 6);
		u64 s2 = get_a();
		set_a(do_asr56(i, s2));
		break;
		}
	case 195: { // asr #[i],a,b
		u32 i = BIT(opcode, 1, 6);
		u64 s2 = get_a();
		set_b(do_asr56(i, s2));
		break;
		}
	case 196: { // asr #[i],b,a
		u32 i = BIT(opcode, 1, 6);
		u64 s2 = get_b();
		set_a(do_asr56(i, s2));
		break;
		}
	case 197: { // asr #[i],b,b
		u32 i = BIT(opcode, 1, 6);
		u64 s2 = get_b();
		set_b(do_asr56(i, s2));
		break;
		}
	case 198: { // asr a1,a,a
		u32 s1 = get_a1();
		u64 s2 = get_a();
		set_a(do_asr56(s1, s2));
		break;
		}
	case 199: { // asr a1,a,b
		u32 s1 = get_a1();
		u64 s2 = get_a();
		set_b(do_asr56(s1, s2));
		break;
		}
	case 200: { // asr b1,a,a
		u32 s1 = get_b1();
		u64 s2 = get_a();
		set_a(do_asr56(s1, s2));
		break;
		}
	case 201: { // asr b1,a,b
		u32 s1 = get_b1();
		u64 s2 = get_a();
		set_b(do_asr56(s1, s2));
		break;
		}
	case 202: { // asr x0,a,a
		u32 s1 = get_x0();
		u64 s2 = get_a();
		set_a(do_asr56(s1, s2));
		break;
		}
	case 203: { // asr x0,a,b
		u32 s1 = get_x0();
		u64 s2 = get_a();
		set_b(do_asr56(s1, s2));
		break;
		}
	case 204: { // asr y0,a,a
		u32 s1 = get_y0();
		u64 s2 = get_a();
		set_a(do_asr56(s1, s2));
		break;
		}
	case 205: { // asr y0,a,b
		u32 s1 = get_y0();
		u64 s2 = get_a();
		set_b(do_asr56(s1, s2));
		break;
		}
	case 206: { // asr x1,a,a
		u32 s1 = get_x1();
		u64 s2 = get_a();
		set_a(do_asr56(s1, s2));
		break;
		}
	case 207: { // asr x1,a,b
		u32 s1 = get_x1();
		u64 s2 = get_a();
		set_b(do_asr56(s1, s2));
		break;
		}
	case 208: { // asr y1,a,a
		u32 s1 = get_y1();
		u64 s2 = get_a();
		set_a(do_asr56(s1, s2));
		break;
		}
	case 209: { // asr y1,a,b
		u32 s1 = get_y1();
		u64 s2 = get_a();
		set_b(do_asr56(s1, s2));
		break;
		}
	case 210: { // asr a1,b,a
		u32 s1 = get_a1();
		u64 s2 = get_b();
		set_a(do_asr56(s1, s2));
		break;
		}
	case 211: { // asr a1,b,b
		u32 s1 = get_a1();
		u64 s2 = get_b();
		set_b(do_asr56(s1, s2));
		break;
		}
	case 212: { // asr b1,b,a
		u32 s1 = get_b1();
		u64 s2 = get_b();
		set_a(do_asr56(s1, s2));
		break;
		}
	case 213: { // asr b1,b,b
		u32 s1 = get_b1();
		u64 s2 = get_b();
		set_b(do_asr56(s1, s2));
		break;
		}
	case 214: { // asr x0,b,a
		u32 s1 = get_x0();
		u64 s2 = get_b();
		set_a(do_asr56(s1, s2));
		break;
		}
	case 215: { // asr x0,b,b
		u32 s1 = get_x0();
		u64 s2 = get_b();
		set_b(do_asr56(s1, s2));
		break;
		}
	case 216: { // asr y0,b,a
		u32 s1 = get_y0();
		u64 s2 = get_b();
		set_a(do_asr56(s1, s2));
		break;
		}
	case 217: { // asr y0,b,b
		u32 s1 = get_y0();
		u64 s2 = get_b();
		set_b(do_asr56(s1, s2));
		break;
		}
	case 218: { // asr x1,b,a
		u32 s1 = get_x1();
		u64 s2 = get_b();
		set_a(do_asr56(s1, s2));
		break;
		}
	case 219: { // asr x1,b,b
		u32 s1 = get_x1();
		u64 s2 = get_b();
		set_b(do_asr56(s1, s2));
		break;
		}
	case 220: { // asr y1,b,a
		u32 s1 = get_y1();
		u64 s2 = get_b();
		set_a(do_asr56(s1, s2));
		break;
		}
	case 221: { // asr y1,b,b
		u32 s1 = get_y1();
		u64 s2 = get_b();
		set_b(do_asr56(s1, s2));
		break;
		}
	case 222: { // bcc [x]
		bool cc = test_cc();
		u32 x = (m_pc+exv) & 0xffffff;
		if(cc) {
		m_npc = x;
		}
		break;
		}
	case 223: { // bge [x]
		bool cc = test_ge();
		u32 x = (m_pc+exv) & 0xffffff;
		if(cc) {
		m_npc = x;
		}
		break;
		}
	case 224: { // bne [x]
		bool cc = test_ne();
		u32 x = (m_pc+exv) & 0xffffff;
		if(cc) {
		m_npc = x;
		}
		break;
		}
	case 225: { // bpl [x]
		bool cc = test_pl();
		u32 x = (m_pc+exv) & 0xffffff;
		if(cc) {
		m_npc = x;
		}
		break;
		}
	case 226: { // bnn [x]
		bool cc = test_nn();
		u32 x = (m_pc+exv) & 0xffffff;
		if(cc) {
		m_npc = x;
		}
		break;
		}
	case 227: { // bec [x]
		bool cc = test_ec();
		u32 x = (m_pc+exv) & 0xffffff;
		if(cc) {
		m_npc = x;
		}
		break;
		}
	case 228: { // blc [x]
		u32 cc = get_lc();
		u32 x = (m_pc+exv) & 0xffffff;
		if(cc) {
		m_npc = x;
		}
		break;
		}
	case 229: { // bgt [x]
		bool cc = test_gt();
		u32 x = (m_pc+exv) & 0xffffff;
		if(cc) {
		m_npc = x;
		}
		break;
		}
	case 230: { // bcs [x]
		bool cc = test_cs();
		u32 x = (m_pc+exv) & 0xffffff;
		if(cc) {
		m_npc = x;
		}
		break;
		}
	case 231: { // blt [x]
		bool cc = test_lt();
		u32 x = (m_pc+exv) & 0xffffff;
		if(cc) {
		m_npc = x;
		}
		break;
		}
	case 232: { // beq [x]
		bool cc = test_eq();
		u32 x = (m_pc+exv) & 0xffffff;
		if(cc) {
		m_npc = x;
		}
		break;
		}
	case 233: { // bmi [x]
		bool cc = test_mi();
		u32 x = (m_pc+exv) & 0xffffff;
		if(cc) {
		m_npc = x;
		}
		break;
		}
	case 234: { // bnr [x]
		bool cc = test_nr();
		u32 x = (m_pc+exv) & 0xffffff;
		if(cc) {
		m_npc = x;
		}
		break;
		}
	case 235: { // bes [x]
		bool cc = test_es();
		u32 x = (m_pc+exv) & 0xffffff;
		if(cc) {
		m_npc = x;
		}
		break;
		}
	case 236: { // bls [x]
		bool cc = test_ls();
		u32 x = (m_pc+exv) & 0xffffff;
		if(cc) {
		m_npc = x;
		}
		break;
		}
	case 237: { // ble [x]
		bool cc = test_le();
		u32 x = (m_pc+exv) & 0xffffff;
		if(cc) {
		m_npc = x;
		}
		break;
		}
	case 238: { // bcc [x]
		bool cc = test_cc();
		u32 x = (m_pc + util::sext(bitswap<9>(opcode, 9, 8, 7, 6, 4, 3, 2, 1, 0), 9)) & 0xffffff;
		if(cc) {
		m_npc = x;
		}
		break;
		}
	case 239: { // bge [x]
		bool cc = test_ge();
		u32 x = (m_pc + util::sext(bitswap<9>(opcode, 9, 8, 7, 6, 4, 3, 2, 1, 0), 9)) & 0xffffff;
		if(cc) {
		m_npc = x;
		}
		break;
		}
	case 240: { // bne [x]
		bool cc = test_ne();
		u32 x = (m_pc + util::sext(bitswap<9>(opcode, 9, 8, 7, 6, 4, 3, 2, 1, 0), 9)) & 0xffffff;
		if(cc) {
		m_npc = x;
		}
		break;
		}
	case 241: { // bpl [x]
		bool cc = test_pl();
		u32 x = (m_pc + util::sext(bitswap<9>(opcode, 9, 8, 7, 6, 4, 3, 2, 1, 0), 9)) & 0xffffff;
		if(cc) {
		m_npc = x;
		}
		break;
		}
	case 242: { // bnn [x]
		bool cc = test_nn();
		u32 x = (m_pc + util::sext(bitswap<9>(opcode, 9, 8, 7, 6, 4, 3, 2, 1, 0), 9)) & 0xffffff;
		if(cc) {
		m_npc = x;
		}
		break;
		}
	case 243: { // bec [x]
		bool cc = test_ec();
		u32 x = (m_pc + util::sext(bitswap<9>(opcode, 9, 8, 7, 6, 4, 3, 2, 1, 0), 9)) & 0xffffff;
		if(cc) {
		m_npc = x;
		}
		break;
		}
	case 244: { // blc [x]
		u32 cc = get_lc();
		u32 x = (m_pc + util::sext(bitswap<9>(opcode, 9, 8, 7, 6, 4, 3, 2, 1, 0), 9)) & 0xffffff;
		if(cc) {
		m_npc = x;
		}
		break;
		}
	case 245: { // bgt [x]
		bool cc = test_gt();
		u32 x = (m_pc + util::sext(bitswap<9>(opcode, 9, 8, 7, 6, 4, 3, 2, 1, 0), 9)) & 0xffffff;
		if(cc) {
		m_npc = x;
		}
		break;
		}
	case 246: { // bcs [x]
		bool cc = test_cs();
		u32 x = (m_pc + util::sext(bitswap<9>(opcode, 9, 8, 7, 6, 4, 3, 2, 1, 0), 9)) & 0xffffff;
		if(cc) {
		m_npc = x;
		}
		break;
		}
	case 247: { // blt [x]
		bool cc = test_lt();
		u32 x = (m_pc + util::sext(bitswap<9>(opcode, 9, 8, 7, 6, 4, 3, 2, 1, 0), 9)) & 0xffffff;
		if(cc) {
		m_npc = x;
		}
		break;
		}
	case 248: { // beq [x]
		bool cc = test_eq();
		u32 x = (m_pc + util::sext(bitswap<9>(opcode, 9, 8, 7, 6, 4, 3, 2, 1, 0), 9)) & 0xffffff;
		if(cc) {
		m_npc = x;
		}
		break;
		}
	case 249: { // bmi [x]
		bool cc = test_mi();
		u32 x = (m_pc + util::sext(bitswap<9>(opcode, 9, 8, 7, 6, 4, 3, 2, 1, 0), 9)) & 0xffffff;
		if(cc) {
		m_npc = x;
		}
		break;
		}
	case 250: { // bnr [x]
		bool cc = test_nr();
		u32 x = (m_pc + util::sext(bitswap<9>(opcode, 9, 8, 7, 6, 4, 3, 2, 1, 0), 9)) & 0xffffff;
		if(cc) {
		m_npc = x;
		}
		break;
		}
	case 251: { // bes [x]
		bool cc = test_es();
		u32 x = (m_pc + util::sext(bitswap<9>(opcode, 9, 8, 7, 6, 4, 3, 2, 1, 0), 9)) & 0xffffff;
		if(cc) {
		m_npc = x;
		}
		break;
		}
	case 252: { // bls [x]
		bool cc = test_ls();
		u32 x = (m_pc + util::sext(bitswap<9>(opcode, 9, 8, 7, 6, 4, 3, 2, 1, 0), 9)) & 0xffffff;
		if(cc) {
		m_npc = x;
		}
		break;
		}
	case 253: { // ble [x]
		bool cc = test_le();
		u32 x = (m_pc + util::sext(bitswap<9>(opcode, 9, 8, 7, 6, 4, 3, 2, 1, 0), 9)) & 0xffffff;
		if(cc) {
		m_npc = x;
		}
		break;
		}
	case 254: { // bcc r
		bool cc = test_cc();
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		if(cc) {
		m_npc = m_pc + r;
		}
		break;
		}
	case 255: { // bge r
		bool cc = test_ge();
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		if(cc) {
		m_npc = m_pc + r;
		}
		break;
		}
	case 256: { // bne r
		bool cc = test_ne();
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		if(cc) {
		m_npc = m_pc + r;
		}
		break;
		}
	case 257: { // bpl r
		bool cc = test_pl();
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		if(cc) {
		m_npc = m_pc + r;
		}
		break;
		}
	case 258: { // bnn r
		bool cc = test_nn();
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		if(cc) {
		m_npc = m_pc + r;
		}
		break;
		}
	case 259: { // bec r
		bool cc = test_ec();
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		if(cc) {
		m_npc = m_pc + r;
		}
		break;
		}
	case 260: { // blc r
		u32 cc = get_lc();
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		if(cc) {
		m_npc = m_pc + r;
		}
		break;
		}
	case 261: { // bgt r
		bool cc = test_gt();
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		if(cc) {
		m_npc = m_pc + r;
		}
		break;
		}
	case 262: { // bcs r
		bool cc = test_cs();
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		if(cc) {
		m_npc = m_pc + r;
		}
		break;
		}
	case 263: { // blt r
		bool cc = test_lt();
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		if(cc) {
		m_npc = m_pc + r;
		}
		break;
		}
	case 264: { // beq r
		bool cc = test_eq();
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		if(cc) {
		m_npc = m_pc + r;
		}
		break;
		}
	case 265: { // bmi r
		bool cc = test_mi();
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		if(cc) {
		m_npc = m_pc + r;
		}
		break;
		}
	case 266: { // bnr r
		bool cc = test_nr();
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		if(cc) {
		m_npc = m_pc + r;
		}
		break;
		}
	case 267: { // bes r
		bool cc = test_es();
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		if(cc) {
		m_npc = m_pc + r;
		}
		break;
		}
	case 268: { // bls r
		bool cc = test_ls();
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		if(cc) {
		m_npc = m_pc + r;
		}
		break;
		}
	case 269: { // ble r
		bool cc = test_le();
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		if(cc) {
		m_npc = m_pc + r;
		}
		break;
		}
	case 270: { // bchg #[n],x:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_x.read_dword(ea);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		m_x.write_dword(ea, t ^ m);
		break;
		}
	case 271: { // bchg #[n],y:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_y.read_dword(ea);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		m_y.write_dword(ea, t ^ m);
		break;
		}
	case 272: { // bchg #[n],x:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_x.read_dword(ea);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		m_x.write_dword(ea, t ^ m);
		break;
		}
	case 273: { // bchg #[n],y:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_y.read_dword(ea);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		m_y.write_dword(ea, t ^ m);
		break;
		}
	case 274: { // bchg #[n],x:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_x.read_dword(ea);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		m_x.write_dword(ea, t ^ m);
		break;
		}
	case 275: { // bchg #[n],y:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_y.read_dword(ea);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		m_y.write_dword(ea, t ^ m);
		break;
		}
	case 276: { // bchg #[n],x:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_x.read_dword(ea);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		m_x.write_dword(ea, t ^ m);
		break;
		}
	case 277: { // bchg #[n],y:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_y.read_dword(ea);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		m_y.write_dword(ea, t ^ m);
		break;
		}
	case 278: { // bchg #[n],x:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_x.read_dword(ea);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		m_x.write_dword(ea, t ^ m);
		break;
		}
	case 279: { // bchg #[n],y:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_y.read_dword(ea);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		m_y.write_dword(ea, t ^ m);
		break;
		}
	case 280: { // bchg #[n],x:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_x.read_dword(ea);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		m_x.write_dword(ea, t ^ m);
		break;
		}
	case 281: { // bchg #[n],y:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_y.read_dword(ea);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		m_y.write_dword(ea, t ^ m);
		break;
		}
	case 282: { // bchg #[n],x:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_x.read_dword(ea);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		m_x.write_dword(ea, t ^ m);
		break;
		}
	case 283: { // bchg #[n],y:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_y.read_dword(ea);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		m_y.write_dword(ea, t ^ m);
		break;
		}
	case 284: { // bchg #[n],x:[abs]
		u32 abs = exv;
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_x.read_dword(abs);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		m_x.write_dword(abs, t ^ m);
		break;
		}
	case 285: { // bchg #[n],y:[abs]
		u32 abs = exv;
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_y.read_dword(abs);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		m_y.write_dword(abs, t ^ m);
		break;
		}
	case 286: { // bchg #[n],x:[aa]
		u32 aa = BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_x.read_dword(aa);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		m_x.write_dword(aa, t ^ m);
		break;
		}
	case 287: { // bchg #[n],y:[aa]
		u32 aa = BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_y.read_dword(aa);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		m_y.write_dword(aa, t ^ m);
		break;
		}
	case 288: { // bchg #[n],x:[pp]
		u32 pp = 0xffffc0 + BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_x.read_dword(pp);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		m_x.write_dword(pp, t ^ m);
		break;
		}
	case 289: { // bchg #[n],y:[pp]
		u32 pp = 0xffffc0 + BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_y.read_dword(pp);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		m_y.write_dword(pp, t ^ m);
		break;
		}
	case 290: { // bchg #[n],x:[qq]
		u32 qq = 0xffff80 + BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_x.read_dword(qq);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		m_x.write_dword(qq, t ^ m);
		break;
		}
	case 291: { // bchg #[n],y:[qq]
		u32 qq = 0xffff80 + BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_y.read_dword(qq);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		m_y.write_dword(qq, t ^ m);
		break;
		}
	case 292: { // bchg #[n],x0
		u32 d = get_x0();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_x0(t ^ m);
		break;
		}
	case 293: { // bchg #[n],x1
		u32 d = get_x1();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_x1(t ^ m);
		break;
		}
	case 294: { // bchg #[n],y0
		u32 d = get_y0();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_y0(t ^ m);
		break;
		}
	case 295: { // bchg #[n],y1
		u32 d = get_y1();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_y1(t ^ m);
		break;
		}
	case 296: { // bchg #[n],a0
		u32 d = get_a0();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_a0(t ^ m);
		break;
		}
	case 297: { // bchg #[n],b0
		u32 d = get_b0();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_b0(t ^ m);
		break;
		}
	case 298: { // bchg #[n],a2
		u32 d = get_a2();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_a2(t ^ m);
		break;
		}
	case 299: { // bchg #[n],b2
		u32 d = get_b2();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_b2(t ^ m);
		break;
		}
	case 300: { // bchg #[n],a1
		u32 d = get_a1();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_a1(t ^ m);
		break;
		}
	case 301: { // bchg #[n],b1
		u32 d = get_b1();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_b1(t ^ m);
		break;
		}
	case 302: { // bchg #[n],a
		u32 d_h = get_ah();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d_h;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_ah(t ^ m);
		break;
		}
	case 303: { // bchg #[n],b
		u32 d_h = get_bh();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d_h;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_bh(t ^ m);
		break;
		}
	case 304: { // bchg #[n],r
		u32 d = get_r(BIT(opcode, 8, 6) & 7);
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_r(BIT(opcode, 8, 6) & 7, t ^ m);
		break;
		}
	case 305: { // bchg #[n],n
		u32 d = get_n(BIT(opcode, 8, 6) & 7);
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_n(BIT(opcode, 8, 6) & 7, t ^ m);
		break;
		}
	case 306: { // bchg #[n],m
		u32 d = get_m(BIT(opcode, 8, 6) & 7);
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_m(BIT(opcode, 8, 6) & 7, t ^ m);
		break;
		}
	case 307: { // bchg #[n],ep
		u32 d = get_ep();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_ep(t ^ m);
		break;
		}
	case 308: { // bchg #[n],vba
		u32 d = get_vba();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_vba(t ^ m);
		break;
		}
	case 309: { // bchg #[n],sc
		u32 d = get_sc();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_sc(t ^ m);
		break;
		}
	case 310: { // bchg #[n],sz
		u32 d = get_sz();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_sz(t ^ m);
		break;
		}
	case 311: { // bchg #[n],sr
		u32 d = get_sr();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_sr(t ^ m);
		break;
		}
	case 312: { // bchg #[n],omr
		u32 d = get_omr();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_omr(t ^ m);
		break;
		}
	case 313: { // bchg #[n],sp
		u32 d = get_sp();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_sp(t ^ m);
		break;
		}
	case 314: { // bchg #[n],ssh
		u32 d = get_ssh();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_ssh(t ^ m);
		break;
		}
	case 315: { // bchg #[n],ssl
		u32 d = get_ssl();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_ssl(t ^ m);
		break;
		}
	case 316: { // bchg #[n],la
		u32 d = get_la();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_la(t ^ m);
		break;
		}
	case 317: { // bchg #[n],lc
		u32 d = get_lc();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_lc(t ^ m);
		break;
		}
	case 318: { // bclr #[n],x:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_x.read_dword(ea);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		m_x.write_dword(ea, t & ~m);
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 319: { // bclr #[n],y:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_y.read_dword(ea);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		m_y.write_dword(ea, t & ~m);
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 320: { // bclr #[n],x:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_x.read_dword(ea);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		m_x.write_dword(ea, t & ~m);
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 321: { // bclr #[n],y:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_y.read_dword(ea);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		m_y.write_dword(ea, t & ~m);
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 322: { // bclr #[n],x:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_x.read_dword(ea);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		m_x.write_dword(ea, t & ~m);
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 323: { // bclr #[n],y:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_y.read_dword(ea);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		m_y.write_dword(ea, t & ~m);
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 324: { // bclr #[n],x:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_x.read_dword(ea);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		m_x.write_dword(ea, t & ~m);
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 325: { // bclr #[n],y:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_y.read_dword(ea);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		m_y.write_dword(ea, t & ~m);
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 326: { // bclr #[n],x:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_x.read_dword(ea);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		m_x.write_dword(ea, t & ~m);
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 327: { // bclr #[n],y:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_y.read_dword(ea);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		m_y.write_dword(ea, t & ~m);
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 328: { // bclr #[n],x:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_x.read_dword(ea);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		m_x.write_dword(ea, t & ~m);
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 329: { // bclr #[n],y:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_y.read_dword(ea);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		m_y.write_dword(ea, t & ~m);
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 330: { // bclr #[n],x:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_x.read_dword(ea);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		m_x.write_dword(ea, t & ~m);
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 331: { // bclr #[n],y:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_y.read_dword(ea);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		m_y.write_dword(ea, t & ~m);
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 332: { // bclr #[n],x:[abs]
		u32 abs = exv;
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_x.read_dword(abs);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		m_x.write_dword(abs, t & ~m);
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 333: { // bclr #[n],y:[abs]
		u32 abs = exv;
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_y.read_dword(abs);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		m_y.write_dword(abs, t & ~m);
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 334: { // bclr #[n],x:[aa]
		u32 aa = BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_x.read_dword(aa);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		m_x.write_dword(aa, t & ~m);
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 335: { // bclr #[n],y:[aa]
		u32 aa = BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_y.read_dword(aa);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		m_y.write_dword(aa, t & ~m);
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 336: { // bclr #[n],x:[pp]
		u32 pp = 0xffffc0 + BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_x.read_dword(pp);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		m_x.write_dword(pp, t & ~m);
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 337: { // bclr #[n],y:[pp]
		u32 pp = 0xffffc0 + BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_y.read_dword(pp);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		m_y.write_dword(pp, t & ~m);
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 338: { // bclr #[n],x:[qq]
		u32 qq = 0xffff80 + BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_x.read_dword(qq);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		m_x.write_dword(qq, t & ~m);
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 339: { // bclr #[n],y:[qq]
		u32 qq = 0xffff80 + BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_y.read_dword(qq);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		m_y.write_dword(qq, t & ~m);
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 340: { // bclr #[n],x0
		u32 d = get_x0();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_x0(t & ~m);
		break;
		}
	case 341: { // bclr #[n],x1
		u32 d = get_x1();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_x1(t & ~m);
		break;
		}
	case 342: { // bclr #[n],y0
		u32 d = get_y0();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_y0(t & ~m);
		break;
		}
	case 343: { // bclr #[n],y1
		u32 d = get_y1();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_y1(t & ~m);
		break;
		}
	case 344: { // bclr #[n],a0
		u32 d = get_a0();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_a0(t & ~m);
		break;
		}
	case 345: { // bclr #[n],b0
		u32 d = get_b0();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_b0(t & ~m);
		break;
		}
	case 346: { // bclr #[n],a2
		u32 d = get_a2();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_a2(t & ~m);
		break;
		}
	case 347: { // bclr #[n],b2
		u32 d = get_b2();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_b2(t & ~m);
		break;
		}
	case 348: { // bclr #[n],a1
		u32 d = get_a1();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_a1(t & ~m);
		break;
		}
	case 349: { // bclr #[n],b1
		u32 d = get_b1();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_b1(t & ~m);
		break;
		}
	case 350: { // bclr #[n],a
		u32 d_h = get_ah();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d_h;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_ah(t & ~m);
		break;
		}
	case 351: { // bclr #[n],b
		u32 d_h = get_bh();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d_h;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_bh(t & ~m);
		break;
		}
	case 352: { // bclr #[n],r
		u32 d = get_r(BIT(opcode, 8, 6) & 7);
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_r(BIT(opcode, 8, 6) & 7, t & ~m);
		break;
		}
	case 353: { // bclr #[n],n
		u32 d = get_n(BIT(opcode, 8, 6) & 7);
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_n(BIT(opcode, 8, 6) & 7, t & ~m);
		break;
		}
	case 354: { // bclr #[n],m
		u32 d = get_m(BIT(opcode, 8, 6) & 7);
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_m(BIT(opcode, 8, 6) & 7, t & ~m);
		break;
		}
	case 355: { // bclr #[n],ep
		u32 d = get_ep();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_ep(t & ~m);
		break;
		}
	case 356: { // bclr #[n],vba
		u32 d = get_vba();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_vba(t & ~m);
		break;
		}
	case 357: { // bclr #[n],sc
		u32 d = get_sc();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_sc(t & ~m);
		break;
		}
	case 358: { // bclr #[n],sz
		u32 d = get_sz();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_sz(t & ~m);
		break;
		}
	case 359: { // bclr #[n],sr
		u32 d = get_sr();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_sr(t & ~m);
		break;
		}
	case 360: { // bclr #[n],omr
		u32 d = get_omr();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_omr(t & ~m);
		break;
		}
	case 361: { // bclr #[n],sp
		u32 d = get_sp();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_sp(t & ~m);
		break;
		}
	case 362: { // bclr #[n],ssh
		u32 d = get_ssh();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_ssh(t & ~m);
		break;
		}
	case 363: { // bclr #[n],ssl
		u32 d = get_ssl();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_ssl(t & ~m);
		break;
		}
	case 364: { // bclr #[n],la
		u32 d = get_la();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_la(t & ~m);
		break;
		}
	case 365: { // bclr #[n],lc
		u32 d = get_lc();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_lc(t & ~m);
		break;
		}
	case 366: { // bra [x]
		u32 x = (m_pc+exv) & 0xffffff;
		m_npc = x;
		break;
		}
	case 367: { // bra [x]
		u32 x = (m_pc + util::sext(bitswap<9>(opcode, 9, 8, 7, 6, 4, 3, 2, 1, 0), 9)) & 0xffffff;
		m_npc = x;
		break;
		}
	case 368: { // bra r
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		m_npc = m_pc + r;
		break;
		}
	case 369: { // brclr #[n],x:(r)-n,[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(m_x.read_dword(ea), n))
		m_npc = x;
		break;
		}
	case 370: { // brclr #[n],y:(r)-n,[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(m_y.read_dword(ea), n))
		m_npc = x;
		break;
		}
	case 371: { // brclr #[n],x:(r)+n,[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(m_x.read_dword(ea), n))
		m_npc = x;
		break;
		}
	case 372: { // brclr #[n],y:(r)+n,[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(m_y.read_dword(ea), n))
		m_npc = x;
		break;
		}
	case 373: { // brclr #[n],x:(r)-,[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(m_x.read_dword(ea), n))
		m_npc = x;
		break;
		}
	case 374: { // brclr #[n],y:(r)-,[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(m_y.read_dword(ea), n))
		m_npc = x;
		break;
		}
	case 375: { // brclr #[n],x:(r)+,[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(m_x.read_dword(ea), n))
		m_npc = x;
		break;
		}
	case 376: { // brclr #[n],y:(r)+,[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(m_y.read_dword(ea), n))
		m_npc = x;
		break;
		}
	case 377: { // brclr #[n],x:(r),[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(m_x.read_dword(ea), n))
		m_npc = x;
		break;
		}
	case 378: { // brclr #[n],y:(r),[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(m_y.read_dword(ea), n))
		m_npc = x;
		break;
		}
	case 379: { // brclr #[n],x:(r+n),[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(m_x.read_dword(ea), n))
		m_npc = x;
		break;
		}
	case 380: { // brclr #[n],y:(r+n),[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(m_y.read_dword(ea), n))
		m_npc = x;
		break;
		}
	case 381: { // brclr #[n],x:-(r),[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(m_x.read_dword(ea), n))
		m_npc = x;
		break;
		}
	case 382: { // brclr #[n],y:-(r),[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(m_y.read_dword(ea), n))
		m_npc = x;
		break;
		}
	case 383: { // brclr #[n],x:[abs],[x]
		u32 abs = exv;
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(m_x.read_dword(abs), n))
		m_npc = x;
		break;
		}
	case 384: { // brclr #[n],y:[abs],[x]
		u32 abs = exv;
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(m_y.read_dword(abs), n))
		m_npc = x;
		break;
		}
	case 385: { // brclr #[n],x:[aa],[x]
		u32 aa = BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(m_x.read_dword(aa), n))
		m_npc = x;
		break;
		}
	case 386: { // brclr #[n],y:[aa],[x]
		u32 aa = BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(m_y.read_dword(aa), n))
		m_npc = x;
		break;
		}
	case 387: { // brclr #[n],x:[pp],[x]
		u32 pp = 0xffffc0 + BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(m_x.read_dword(pp), n))
		m_npc = x;
		break;
		}
	case 388: { // brclr #[n],y:[pp],[x]
		u32 pp = 0xffffc0 + BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(m_y.read_dword(pp), n))
		m_npc = x;
		break;
		}
	case 389: { // brclr #[n],x:[qq],[x]
		u32 qq = 0xffff80 + BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(m_x.read_dword(qq), n))
		m_npc = x;
		break;
		}
	case 390: { // brclr #[n],y:[qq],[x]
		u32 qq = 0xffff80 + BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(m_y.read_dword(qq), n))
		m_npc = x;
		break;
		}
	case 391: { // brclr #[n],x0,[x]
		u32 s = get_x0();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(s, n))
		m_npc = x;
		break;
		}
	case 392: { // brclr #[n],x1,[x]
		u32 s = get_x1();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(s, n))
		m_npc = x;
		break;
		}
	case 393: { // brclr #[n],y0,[x]
		u32 s = get_y0();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(s, n))
		m_npc = x;
		break;
		}
	case 394: { // brclr #[n],y1,[x]
		u32 s = get_y1();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(s, n))
		m_npc = x;
		break;
		}
	case 395: { // brclr #[n],a0,[x]
		u32 s = get_a0();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(s, n))
		m_npc = x;
		break;
		}
	case 396: { // brclr #[n],b0,[x]
		u32 s = get_b0();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(s, n))
		m_npc = x;
		break;
		}
	case 397: { // brclr #[n],a2,[x]
		u32 s = get_a2();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(s, n))
		m_npc = x;
		break;
		}
	case 398: { // brclr #[n],b2,[x]
		u32 s = get_b2();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(s, n))
		m_npc = x;
		break;
		}
	case 399: { // brclr #[n],a1,[x]
		u32 s = get_a1();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(s, n))
		m_npc = x;
		break;
		}
	case 400: { // brclr #[n],b1,[x]
		u32 s = get_b1();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(s, n))
		m_npc = x;
		break;
		}
	case 401: { // brclr #[n],a,[x]
		u32 s_h = get_ah();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(s_h, n))
		m_npc = x;
		break;
		}
	case 402: { // brclr #[n],b,[x]
		u32 s_h = get_bh();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(s_h, n))
		m_npc = x;
		break;
		}
	case 403: { // brclr #[n],r,[x]
		u32 s = get_r(BIT(opcode, 8, 6) & 7);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(s, n))
		m_npc = x;
		break;
		}
	case 404: { // brclr #[n],n,[x]
		u32 s = get_n(BIT(opcode, 8, 6) & 7);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(s, n))
		m_npc = x;
		break;
		}
	case 405: { // brclr #[n],m,[x]
		u32 s = get_m(BIT(opcode, 8, 6) & 7);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(s, n))
		m_npc = x;
		break;
		}
	case 406: { // brclr #[n],ep,[x]
		u32 s = get_ep();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(s, n))
		m_npc = x;
		break;
		}
	case 407: { // brclr #[n],vba,[x]
		u32 s = get_vba();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(s, n))
		m_npc = x;
		break;
		}
	case 408: { // brclr #[n],sc,[x]
		u32 s = get_sc();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(s, n))
		m_npc = x;
		break;
		}
	case 409: { // brclr #[n],sz,[x]
		u32 s = get_sz();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(s, n))
		m_npc = x;
		break;
		}
	case 410: { // brclr #[n],sr,[x]
		u32 s = get_sr();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(s, n))
		m_npc = x;
		break;
		}
	case 411: { // brclr #[n],omr,[x]
		u32 s = get_omr();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(s, n))
		m_npc = x;
		break;
		}
	case 412: { // brclr #[n],sp,[x]
		u32 s = get_sp();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(s, n))
		m_npc = x;
		break;
		}
	case 413: { // brclr #[n],ssh,[x]
		u32 s = get_ssh();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(s, n))
		m_npc = x;
		break;
		}
	case 414: { // brclr #[n],ssl,[x]
		u32 s = get_ssl();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(s, n))
		m_npc = x;
		break;
		}
	case 415: { // brclr #[n],la,[x]
		u32 s = get_la();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(s, n))
		m_npc = x;
		break;
		}
	case 416: { // brclr #[n],lc,[x]
		u32 s = get_lc();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(s, n))
		m_npc = x;
		break;
		}
	case 417: { // brkcc
		bool cc = test_cc();
		if(cc) {
		m_npc = get_la()+1;
		m_mr = (m_mr & ~MR_LF) | ((get_ssl() >> 8) & MR_LF);
		m_emr = (m_emr & ~EMR_FV) | ((get_ssl() >> 16) & EMR_FV);
		dec_sp();
		set_la(get_ssh());
		set_lc(get_ssl());
		dec_sp();
		}
		break;
		}
	case 418: { // brkge
		bool cc = test_ge();
		if(cc) {
		m_npc = get_la()+1;
		m_mr = (m_mr & ~MR_LF) | ((get_ssl() >> 8) & MR_LF);
		m_emr = (m_emr & ~EMR_FV) | ((get_ssl() >> 16) & EMR_FV);
		dec_sp();
		set_la(get_ssh());
		set_lc(get_ssl());
		dec_sp();
		}
		break;
		}
	case 419: { // brkne
		bool cc = test_ne();
		if(cc) {
		m_npc = get_la()+1;
		m_mr = (m_mr & ~MR_LF) | ((get_ssl() >> 8) & MR_LF);
		m_emr = (m_emr & ~EMR_FV) | ((get_ssl() >> 16) & EMR_FV);
		dec_sp();
		set_la(get_ssh());
		set_lc(get_ssl());
		dec_sp();
		}
		break;
		}
	case 420: { // brkpl
		bool cc = test_pl();
		if(cc) {
		m_npc = get_la()+1;
		m_mr = (m_mr & ~MR_LF) | ((get_ssl() >> 8) & MR_LF);
		m_emr = (m_emr & ~EMR_FV) | ((get_ssl() >> 16) & EMR_FV);
		dec_sp();
		set_la(get_ssh());
		set_lc(get_ssl());
		dec_sp();
		}
		break;
		}
	case 421: { // brknn
		bool cc = test_nn();
		if(cc) {
		m_npc = get_la()+1;
		m_mr = (m_mr & ~MR_LF) | ((get_ssl() >> 8) & MR_LF);
		m_emr = (m_emr & ~EMR_FV) | ((get_ssl() >> 16) & EMR_FV);
		dec_sp();
		set_la(get_ssh());
		set_lc(get_ssl());
		dec_sp();
		}
		break;
		}
	case 422: { // brkec
		bool cc = test_ec();
		if(cc) {
		m_npc = get_la()+1;
		m_mr = (m_mr & ~MR_LF) | ((get_ssl() >> 8) & MR_LF);
		m_emr = (m_emr & ~EMR_FV) | ((get_ssl() >> 16) & EMR_FV);
		dec_sp();
		set_la(get_ssh());
		set_lc(get_ssl());
		dec_sp();
		}
		break;
		}
	case 423: { // brklc
		u32 cc = get_lc();
		if(cc) {
		m_npc = get_la()+1;
		m_mr = (m_mr & ~MR_LF) | ((get_ssl() >> 8) & MR_LF);
		m_emr = (m_emr & ~EMR_FV) | ((get_ssl() >> 16) & EMR_FV);
		dec_sp();
		set_la(get_ssh());
		set_lc(get_ssl());
		dec_sp();
		}
		break;
		}
	case 424: { // brkgt
		bool cc = test_gt();
		if(cc) {
		m_npc = get_la()+1;
		m_mr = (m_mr & ~MR_LF) | ((get_ssl() >> 8) & MR_LF);
		m_emr = (m_emr & ~EMR_FV) | ((get_ssl() >> 16) & EMR_FV);
		dec_sp();
		set_la(get_ssh());
		set_lc(get_ssl());
		dec_sp();
		}
		break;
		}
	case 425: { // brkcs
		bool cc = test_cs();
		if(cc) {
		m_npc = get_la()+1;
		m_mr = (m_mr & ~MR_LF) | ((get_ssl() >> 8) & MR_LF);
		m_emr = (m_emr & ~EMR_FV) | ((get_ssl() >> 16) & EMR_FV);
		dec_sp();
		set_la(get_ssh());
		set_lc(get_ssl());
		dec_sp();
		}
		break;
		}
	case 426: { // brklt
		bool cc = test_lt();
		if(cc) {
		m_npc = get_la()+1;
		m_mr = (m_mr & ~MR_LF) | ((get_ssl() >> 8) & MR_LF);
		m_emr = (m_emr & ~EMR_FV) | ((get_ssl() >> 16) & EMR_FV);
		dec_sp();
		set_la(get_ssh());
		set_lc(get_ssl());
		dec_sp();
		}
		break;
		}
	case 427: { // brkeq
		bool cc = test_eq();
		if(cc) {
		m_npc = get_la()+1;
		m_mr = (m_mr & ~MR_LF) | ((get_ssl() >> 8) & MR_LF);
		m_emr = (m_emr & ~EMR_FV) | ((get_ssl() >> 16) & EMR_FV);
		dec_sp();
		set_la(get_ssh());
		set_lc(get_ssl());
		dec_sp();
		}
		break;
		}
	case 428: { // brkmi
		bool cc = test_mi();
		if(cc) {
		m_npc = get_la()+1;
		m_mr = (m_mr & ~MR_LF) | ((get_ssl() >> 8) & MR_LF);
		m_emr = (m_emr & ~EMR_FV) | ((get_ssl() >> 16) & EMR_FV);
		dec_sp();
		set_la(get_ssh());
		set_lc(get_ssl());
		dec_sp();
		}
		break;
		}
	case 429: { // brknr
		bool cc = test_nr();
		if(cc) {
		m_npc = get_la()+1;
		m_mr = (m_mr & ~MR_LF) | ((get_ssl() >> 8) & MR_LF);
		m_emr = (m_emr & ~EMR_FV) | ((get_ssl() >> 16) & EMR_FV);
		dec_sp();
		set_la(get_ssh());
		set_lc(get_ssl());
		dec_sp();
		}
		break;
		}
	case 430: { // brkes
		bool cc = test_es();
		if(cc) {
		m_npc = get_la()+1;
		m_mr = (m_mr & ~MR_LF) | ((get_ssl() >> 8) & MR_LF);
		m_emr = (m_emr & ~EMR_FV) | ((get_ssl() >> 16) & EMR_FV);
		dec_sp();
		set_la(get_ssh());
		set_lc(get_ssl());
		dec_sp();
		}
		break;
		}
	case 431: { // brkls
		bool cc = test_ls();
		if(cc) {
		m_npc = get_la()+1;
		m_mr = (m_mr & ~MR_LF) | ((get_ssl() >> 8) & MR_LF);
		m_emr = (m_emr & ~EMR_FV) | ((get_ssl() >> 16) & EMR_FV);
		dec_sp();
		set_la(get_ssh());
		set_lc(get_ssl());
		dec_sp();
		}
		break;
		}
	case 432: { // brkle
		bool cc = test_le();
		if(cc) {
		m_npc = get_la()+1;
		m_mr = (m_mr & ~MR_LF) | ((get_ssl() >> 8) & MR_LF);
		m_emr = (m_emr & ~EMR_FV) | ((get_ssl() >> 16) & EMR_FV);
		dec_sp();
		set_la(get_ssh());
		set_lc(get_ssl());
		dec_sp();
		}
		break;
		}
	case 433: { // brset #[n],x:(r)-n,[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(m_x.read_dword(ea), n))
		m_npc = x;
		break;
		}
	case 434: { // brset #[n],y:(r)-n,[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(m_y.read_dword(ea), n))
		m_npc = x;
		break;
		}
	case 435: { // brset #[n],x:(r)+n,[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(m_x.read_dword(ea), n))
		m_npc = x;
		break;
		}
	case 436: { // brset #[n],y:(r)+n,[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(m_y.read_dword(ea), n))
		m_npc = x;
		break;
		}
	case 437: { // brset #[n],x:(r)-,[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(m_x.read_dword(ea), n))
		m_npc = x;
		break;
		}
	case 438: { // brset #[n],y:(r)-,[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(m_y.read_dword(ea), n))
		m_npc = x;
		break;
		}
	case 439: { // brset #[n],x:(r)+,[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(m_x.read_dword(ea), n))
		m_npc = x;
		break;
		}
	case 440: { // brset #[n],y:(r)+,[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(m_y.read_dword(ea), n))
		m_npc = x;
		break;
		}
	case 441: { // brset #[n],x:(r),[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(m_x.read_dword(ea), n))
		m_npc = x;
		break;
		}
	case 442: { // brset #[n],y:(r),[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(m_y.read_dword(ea), n))
		m_npc = x;
		break;
		}
	case 443: { // brset #[n],x:(r+n),[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(m_x.read_dword(ea), n))
		m_npc = x;
		break;
		}
	case 444: { // brset #[n],y:(r+n),[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(m_y.read_dword(ea), n))
		m_npc = x;
		break;
		}
	case 445: { // brset #[n],x:-(r),[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(m_x.read_dword(ea), n))
		m_npc = x;
		break;
		}
	case 446: { // brset #[n],y:-(r),[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(m_y.read_dword(ea), n))
		m_npc = x;
		break;
		}
	case 447: { // brset #[n],x:[abs],[x]
		u32 abs = exv;
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(m_x.read_dword(abs), n))
		m_npc = x;
		break;
		}
	case 448: { // brset #[n],y:[abs],[x]
		u32 abs = exv;
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(m_y.read_dword(abs), n))
		m_npc = x;
		break;
		}
	case 449: { // brset #[n],x:[aa],[x]
		u32 aa = BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(m_x.read_dword(aa), n))
		m_npc = x;
		break;
		}
	case 450: { // brset #[n],y:[aa],[x]
		u32 aa = BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(m_y.read_dword(aa), n))
		m_npc = x;
		break;
		}
	case 451: { // brset #[n],x:[pp],[x]
		u32 pp = 0xffffc0 + BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(m_x.read_dword(pp), n))
		m_npc = x;
		break;
		}
	case 452: { // brset #[n],y:[pp],[x]
		u32 pp = 0xffffc0 + BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(m_y.read_dword(pp), n))
		m_npc = x;
		break;
		}
	case 453: { // brset #[n],x:[qq],[x]
		u32 qq = 0xffff80 + BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(m_x.read_dword(qq), n))
		m_npc = x;
		break;
		}
	case 454: { // brset #[n],y:[qq],[x]
		u32 qq = 0xffff80 + BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(m_y.read_dword(qq), n))
		m_npc = x;
		break;
		}
	case 455: { // brset #[n],x0,[x]
		u32 s = get_x0();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(s, n))
		m_npc = x;
		break;
		}
	case 456: { // brset #[n],x1,[x]
		u32 s = get_x1();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(s, n))
		m_npc = x;
		break;
		}
	case 457: { // brset #[n],y0,[x]
		u32 s = get_y0();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(s, n))
		m_npc = x;
		break;
		}
	case 458: { // brset #[n],y1,[x]
		u32 s = get_y1();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(s, n))
		m_npc = x;
		break;
		}
	case 459: { // brset #[n],a0,[x]
		u32 s = get_a0();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(s, n))
		m_npc = x;
		break;
		}
	case 460: { // brset #[n],b0,[x]
		u32 s = get_b0();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(s, n))
		m_npc = x;
		break;
		}
	case 461: { // brset #[n],a2,[x]
		u32 s = get_a2();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(s, n))
		m_npc = x;
		break;
		}
	case 462: { // brset #[n],b2,[x]
		u32 s = get_b2();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(s, n))
		m_npc = x;
		break;
		}
	case 463: { // brset #[n],a1,[x]
		u32 s = get_a1();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(s, n))
		m_npc = x;
		break;
		}
	case 464: { // brset #[n],b1,[x]
		u32 s = get_b1();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(s, n))
		m_npc = x;
		break;
		}
	case 465: { // brset #[n],a,[x]
		u32 s_h = get_ah();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(s_h, n))
		m_npc = x;
		break;
		}
	case 466: { // brset #[n],b,[x]
		u32 s_h = get_bh();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(s_h, n))
		m_npc = x;
		break;
		}
	case 467: { // brset #[n],r,[x]
		u32 s = get_r(BIT(opcode, 8, 6) & 7);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(s, n))
		m_npc = x;
		break;
		}
	case 468: { // brset #[n],n,[x]
		u32 s = get_n(BIT(opcode, 8, 6) & 7);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(s, n))
		m_npc = x;
		break;
		}
	case 469: { // brset #[n],m,[x]
		u32 s = get_m(BIT(opcode, 8, 6) & 7);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(s, n))
		m_npc = x;
		break;
		}
	case 470: { // brset #[n],ep,[x]
		u32 s = get_ep();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(s, n))
		m_npc = x;
		break;
		}
	case 471: { // brset #[n],vba,[x]
		u32 s = get_vba();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(s, n))
		m_npc = x;
		break;
		}
	case 472: { // brset #[n],sc,[x]
		u32 s = get_sc();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(s, n))
		m_npc = x;
		break;
		}
	case 473: { // brset #[n],sz,[x]
		u32 s = get_sz();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(s, n))
		m_npc = x;
		break;
		}
	case 474: { // brset #[n],sr,[x]
		u32 s = get_sr();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(s, n))
		m_npc = x;
		break;
		}
	case 475: { // brset #[n],omr,[x]
		u32 s = get_omr();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(s, n))
		m_npc = x;
		break;
		}
	case 476: { // brset #[n],sp,[x]
		u32 s = get_sp();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(s, n))
		m_npc = x;
		break;
		}
	case 477: { // brset #[n],ssh,[x]
		u32 s = get_ssh();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(s, n))
		m_npc = x;
		break;
		}
	case 478: { // brset #[n],ssl,[x]
		u32 s = get_ssl();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(s, n))
		m_npc = x;
		break;
		}
	case 479: { // brset #[n],la,[x]
		u32 s = get_la();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(s, n))
		m_npc = x;
		break;
		}
	case 480: { // brset #[n],lc,[x]
		u32 s = get_lc();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(s, n))
		m_npc = x;
		break;
		}
	case 481: { // bscc [x]
		bool cc = test_cc();
		u32 x = (m_pc+exv) & 0xffffff;
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 482: { // bsge [x]
		bool cc = test_ge();
		u32 x = (m_pc+exv) & 0xffffff;
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 483: { // bsne [x]
		bool cc = test_ne();
		u32 x = (m_pc+exv) & 0xffffff;
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 484: { // bspl [x]
		bool cc = test_pl();
		u32 x = (m_pc+exv) & 0xffffff;
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 485: { // bsnn [x]
		bool cc = test_nn();
		u32 x = (m_pc+exv) & 0xffffff;
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 486: { // bsec [x]
		bool cc = test_ec();
		u32 x = (m_pc+exv) & 0xffffff;
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 487: { // bslc [x]
		u32 cc = get_lc();
		u32 x = (m_pc+exv) & 0xffffff;
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 488: { // bsgt [x]
		bool cc = test_gt();
		u32 x = (m_pc+exv) & 0xffffff;
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 489: { // bscs [x]
		bool cc = test_cs();
		u32 x = (m_pc+exv) & 0xffffff;
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 490: { // bslt [x]
		bool cc = test_lt();
		u32 x = (m_pc+exv) & 0xffffff;
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 491: { // bseq [x]
		bool cc = test_eq();
		u32 x = (m_pc+exv) & 0xffffff;
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 492: { // bsmi [x]
		bool cc = test_mi();
		u32 x = (m_pc+exv) & 0xffffff;
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 493: { // bsnr [x]
		bool cc = test_nr();
		u32 x = (m_pc+exv) & 0xffffff;
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 494: { // bses [x]
		bool cc = test_es();
		u32 x = (m_pc+exv) & 0xffffff;
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 495: { // bsls [x]
		bool cc = test_ls();
		u32 x = (m_pc+exv) & 0xffffff;
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 496: { // bsle [x]
		bool cc = test_le();
		u32 x = (m_pc+exv) & 0xffffff;
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 497: { // bscc [x]
		bool cc = test_cc();
		u32 x = (m_pc + util::sext(bitswap<9>(opcode, 9, 8, 7, 6, 4, 3, 2, 1, 0), 9)) & 0xffffff;
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 498: { // bsge [x]
		bool cc = test_ge();
		u32 x = (m_pc + util::sext(bitswap<9>(opcode, 9, 8, 7, 6, 4, 3, 2, 1, 0), 9)) & 0xffffff;
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 499: { // bsne [x]
		bool cc = test_ne();
		u32 x = (m_pc + util::sext(bitswap<9>(opcode, 9, 8, 7, 6, 4, 3, 2, 1, 0), 9)) & 0xffffff;
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 500: { // bspl [x]
		bool cc = test_pl();
		u32 x = (m_pc + util::sext(bitswap<9>(opcode, 9, 8, 7, 6, 4, 3, 2, 1, 0), 9)) & 0xffffff;
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 501: { // bsnn [x]
		bool cc = test_nn();
		u32 x = (m_pc + util::sext(bitswap<9>(opcode, 9, 8, 7, 6, 4, 3, 2, 1, 0), 9)) & 0xffffff;
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 502: { // bsec [x]
		bool cc = test_ec();
		u32 x = (m_pc + util::sext(bitswap<9>(opcode, 9, 8, 7, 6, 4, 3, 2, 1, 0), 9)) & 0xffffff;
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 503: { // bslc [x]
		u32 cc = get_lc();
		u32 x = (m_pc + util::sext(bitswap<9>(opcode, 9, 8, 7, 6, 4, 3, 2, 1, 0), 9)) & 0xffffff;
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 504: { // bsgt [x]
		bool cc = test_gt();
		u32 x = (m_pc + util::sext(bitswap<9>(opcode, 9, 8, 7, 6, 4, 3, 2, 1, 0), 9)) & 0xffffff;
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 505: { // bscs [x]
		bool cc = test_cs();
		u32 x = (m_pc + util::sext(bitswap<9>(opcode, 9, 8, 7, 6, 4, 3, 2, 1, 0), 9)) & 0xffffff;
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 506: { // bslt [x]
		bool cc = test_lt();
		u32 x = (m_pc + util::sext(bitswap<9>(opcode, 9, 8, 7, 6, 4, 3, 2, 1, 0), 9)) & 0xffffff;
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 507: { // bseq [x]
		bool cc = test_eq();
		u32 x = (m_pc + util::sext(bitswap<9>(opcode, 9, 8, 7, 6, 4, 3, 2, 1, 0), 9)) & 0xffffff;
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 508: { // bsmi [x]
		bool cc = test_mi();
		u32 x = (m_pc + util::sext(bitswap<9>(opcode, 9, 8, 7, 6, 4, 3, 2, 1, 0), 9)) & 0xffffff;
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 509: { // bsnr [x]
		bool cc = test_nr();
		u32 x = (m_pc + util::sext(bitswap<9>(opcode, 9, 8, 7, 6, 4, 3, 2, 1, 0), 9)) & 0xffffff;
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 510: { // bses [x]
		bool cc = test_es();
		u32 x = (m_pc + util::sext(bitswap<9>(opcode, 9, 8, 7, 6, 4, 3, 2, 1, 0), 9)) & 0xffffff;
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 511: { // bsls [x]
		bool cc = test_ls();
		u32 x = (m_pc + util::sext(bitswap<9>(opcode, 9, 8, 7, 6, 4, 3, 2, 1, 0), 9)) & 0xffffff;
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 512: { // bsle [x]
		bool cc = test_le();
		u32 x = (m_pc + util::sext(bitswap<9>(opcode, 9, 8, 7, 6, 4, 3, 2, 1, 0), 9)) & 0xffffff;
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 513: { // bscc r
		bool cc = test_cc();
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = m_pc + r;
		}
		break;
		}
	case 514: { // bsge r
		bool cc = test_ge();
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = m_pc + r;
		}
		break;
		}
	case 515: { // bsne r
		bool cc = test_ne();
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = m_pc + r;
		}
		break;
		}
	case 516: { // bspl r
		bool cc = test_pl();
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = m_pc + r;
		}
		break;
		}
	case 517: { // bsnn r
		bool cc = test_nn();
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = m_pc + r;
		}
		break;
		}
	case 518: { // bsec r
		bool cc = test_ec();
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = m_pc + r;
		}
		break;
		}
	case 519: { // bslc r
		u32 cc = get_lc();
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = m_pc + r;
		}
		break;
		}
	case 520: { // bsgt r
		bool cc = test_gt();
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = m_pc + r;
		}
		break;
		}
	case 521: { // bscs r
		bool cc = test_cs();
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = m_pc + r;
		}
		break;
		}
	case 522: { // bslt r
		bool cc = test_lt();
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = m_pc + r;
		}
		break;
		}
	case 523: { // bseq r
		bool cc = test_eq();
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = m_pc + r;
		}
		break;
		}
	case 524: { // bsmi r
		bool cc = test_mi();
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = m_pc + r;
		}
		break;
		}
	case 525: { // bsnr r
		bool cc = test_nr();
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = m_pc + r;
		}
		break;
		}
	case 526: { // bses r
		bool cc = test_es();
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = m_pc + r;
		}
		break;
		}
	case 527: { // bsls r
		bool cc = test_ls();
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = m_pc + r;
		}
		break;
		}
	case 528: { // bsle r
		bool cc = test_le();
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = m_pc + r;
		}
		break;
		}
	case 529: { // bsclr #[n],x:(r)-n,[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(m_x.read_dword(ea), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 530: { // bsclr #[n],y:(r)-n,[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(m_y.read_dword(ea), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 531: { // bsclr #[n],x:(r)+n,[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(m_x.read_dword(ea), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 532: { // bsclr #[n],y:(r)+n,[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(m_y.read_dword(ea), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 533: { // bsclr #[n],x:(r)-,[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(m_x.read_dword(ea), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 534: { // bsclr #[n],y:(r)-,[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(m_y.read_dword(ea), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 535: { // bsclr #[n],x:(r)+,[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(m_x.read_dword(ea), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 536: { // bsclr #[n],y:(r)+,[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(m_y.read_dword(ea), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 537: { // bsclr #[n],x:(r),[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(m_x.read_dword(ea), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 538: { // bsclr #[n],y:(r),[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(m_y.read_dword(ea), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 539: { // bsclr #[n],x:(r+n),[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(m_x.read_dword(ea), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 540: { // bsclr #[n],y:(r+n),[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(m_y.read_dword(ea), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 541: { // bsclr #[n],x:-(r),[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(m_x.read_dword(ea), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 542: { // bsclr #[n],y:-(r),[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(m_y.read_dword(ea), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 543: { // bsclr #[n],x:[abs],[x]
		u32 abs = exv;
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(m_x.read_dword(abs), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 544: { // bsclr #[n],y:[abs],[x]
		u32 abs = exv;
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(m_y.read_dword(abs), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 545: { // bsclr #[n],x:[aa],[x]
		u32 aa = BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(m_x.read_dword(aa), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 546: { // bsclr #[n],y:[aa],[x]
		u32 aa = BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(m_y.read_dword(aa), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 547: { // bsclr #[n],x:[pp],[x]
		u32 pp = 0xffffc0 + BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(m_x.read_dword(pp), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 548: { // bsclr #[n],y:[pp],[x]
		u32 pp = 0xffffc0 + BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(m_y.read_dword(pp), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 549: { // bsclr #[n],x:[qq],[x]
		u32 qq = 0xffff80 + BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(m_x.read_dword(qq), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 550: { // bsclr #[n],y:[qq],[x]
		u32 qq = 0xffff80 + BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(m_y.read_dword(qq), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 551: { // bsclr #[n],x0,[x]
		u32 s = get_x0();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(s, n)) {
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 552: { // bsclr #[n],x1,[x]
		u32 s = get_x1();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(s, n)) {
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 553: { // bsclr #[n],y0,[x]
		u32 s = get_y0();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(s, n)) {
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 554: { // bsclr #[n],y1,[x]
		u32 s = get_y1();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(s, n)) {
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 555: { // bsclr #[n],a0,[x]
		u32 s = get_a0();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(s, n)) {
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 556: { // bsclr #[n],b0,[x]
		u32 s = get_b0();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(s, n)) {
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 557: { // bsclr #[n],a2,[x]
		u32 s = get_a2();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(s, n)) {
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 558: { // bsclr #[n],b2,[x]
		u32 s = get_b2();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(s, n)) {
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 559: { // bsclr #[n],a1,[x]
		u32 s = get_a1();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(s, n)) {
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 560: { // bsclr #[n],b1,[x]
		u32 s = get_b1();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(s, n)) {
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 561: { // bsclr #[n],a,[x]
		u32 s_h = get_ah();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(s_h, n)) {
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 562: { // bsclr #[n],b,[x]
		u32 s_h = get_bh();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(s_h, n)) {
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 563: { // bsclr #[n],r,[x]
		u32 s = get_r(BIT(opcode, 8, 6) & 7);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(s, n)) {
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 564: { // bsclr #[n],n,[x]
		u32 s = get_n(BIT(opcode, 8, 6) & 7);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(s, n)) {
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 565: { // bsclr #[n],m,[x]
		u32 s = get_m(BIT(opcode, 8, 6) & 7);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(s, n)) {
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 566: { // bsclr #[n],ep,[x]
		u32 s = get_ep();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(s, n)) {
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 567: { // bsclr #[n],vba,[x]
		u32 s = get_vba();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(s, n)) {
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 568: { // bsclr #[n],sc,[x]
		u32 s = get_sc();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(s, n)) {
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 569: { // bsclr #[n],sz,[x]
		u32 s = get_sz();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(s, n)) {
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 570: { // bsclr #[n],sr,[x]
		u32 s = get_sr();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(s, n)) {
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 571: { // bsclr #[n],omr,[x]
		u32 s = get_omr();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(s, n)) {
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 572: { // bsclr #[n],sp,[x]
		u32 s = get_sp();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(s, n)) {
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 573: { // bsclr #[n],ssh,[x]
		u32 s = get_ssh();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(s, n)) {
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 574: { // bsclr #[n],ssl,[x]
		u32 s = get_ssl();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(s, n)) {
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 575: { // bsclr #[n],la,[x]
		u32 s = get_la();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(s, n)) {
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 576: { // bsclr #[n],lc,[x]
		u32 s = get_lc();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(!BIT(s, n)) {
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 577: { // bset #[n],x:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_x.read_dword(ea);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		m_x.write_dword(ea, t | m);
		}
		break;
		}
	case 578: { // bset #[n],y:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_y.read_dword(ea);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		m_y.write_dword(ea, t | m);
		}
		break;
		}
	case 579: { // bset #[n],x:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_x.read_dword(ea);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		m_x.write_dword(ea, t | m);
		}
		break;
		}
	case 580: { // bset #[n],y:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_y.read_dword(ea);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		m_y.write_dword(ea, t | m);
		}
		break;
		}
	case 581: { // bset #[n],x:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_x.read_dword(ea);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		m_x.write_dword(ea, t | m);
		}
		break;
		}
	case 582: { // bset #[n],y:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_y.read_dword(ea);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		m_y.write_dword(ea, t | m);
		}
		break;
		}
	case 583: { // bset #[n],x:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_x.read_dword(ea);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		m_x.write_dword(ea, t | m);
		}
		break;
		}
	case 584: { // bset #[n],y:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_y.read_dword(ea);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		m_y.write_dword(ea, t | m);
		}
		break;
		}
	case 585: { // bset #[n],x:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_x.read_dword(ea);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		m_x.write_dword(ea, t | m);
		}
		break;
		}
	case 586: { // bset #[n],y:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_y.read_dword(ea);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		m_y.write_dword(ea, t | m);
		}
		break;
		}
	case 587: { // bset #[n],x:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_x.read_dword(ea);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		m_x.write_dword(ea, t | m);
		}
		break;
		}
	case 588: { // bset #[n],y:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_y.read_dword(ea);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		m_y.write_dword(ea, t | m);
		}
		break;
		}
	case 589: { // bset #[n],x:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_x.read_dword(ea);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		m_x.write_dword(ea, t | m);
		}
		break;
		}
	case 590: { // bset #[n],y:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_y.read_dword(ea);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		m_y.write_dword(ea, t | m);
		}
		break;
		}
	case 591: { // bset #[n],x:[abs]
		u32 abs = exv;
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_x.read_dword(abs);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		m_x.write_dword(abs, t | m);
		}
		break;
		}
	case 592: { // bset #[n],y:[abs]
		u32 abs = exv;
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_y.read_dword(abs);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		m_y.write_dword(abs, t | m);
		}
		break;
		}
	case 593: { // bset #[n],x:[aa]
		u32 aa = BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_x.read_dword(aa);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		m_x.write_dword(aa, t | m);
		}
		break;
		}
	case 594: { // bset #[n],y:[aa]
		u32 aa = BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_y.read_dword(aa);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		m_y.write_dword(aa, t | m);
		}
		break;
		}
	case 595: { // bset #[n],x:[pp]
		u32 pp = 0xffffc0 + BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_x.read_dword(pp);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		m_x.write_dword(pp, t | m);
		}
		break;
		}
	case 596: { // bset #[n],y:[pp]
		u32 pp = 0xffffc0 + BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_y.read_dword(pp);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		m_y.write_dword(pp, t | m);
		}
		break;
		}
	case 597: { // bset #[n],x:[qq]
		u32 qq = 0xffff80 + BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_x.read_dword(qq);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		m_x.write_dword(qq, t | m);
		}
		break;
		}
	case 598: { // bset #[n],y:[qq]
		u32 qq = 0xffff80 + BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_y.read_dword(qq);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		m_y.write_dword(qq, t | m);
		}
		break;
		}
	case 599: { // bset #[n],x0
		u32 d = get_x0();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_x0(t | m);
		break;
		}
	case 600: { // bset #[n],x1
		u32 d = get_x1();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_x1(t | m);
		break;
		}
	case 601: { // bset #[n],y0
		u32 d = get_y0();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_y0(t | m);
		break;
		}
	case 602: { // bset #[n],y1
		u32 d = get_y1();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_y1(t | m);
		break;
		}
	case 603: { // bset #[n],a0
		u32 d = get_a0();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_a0(t | m);
		break;
		}
	case 604: { // bset #[n],b0
		u32 d = get_b0();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_b0(t | m);
		break;
		}
	case 605: { // bset #[n],a2
		u32 d = get_a2();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_a2(t | m);
		break;
		}
	case 606: { // bset #[n],b2
		u32 d = get_b2();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_b2(t | m);
		break;
		}
	case 607: { // bset #[n],a1
		u32 d = get_a1();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_a1(t | m);
		break;
		}
	case 608: { // bset #[n],b1
		u32 d = get_b1();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_b1(t | m);
		break;
		}
	case 609: { // bset #[n],a
		u32 d_h = get_ah();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d_h;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_ah(t | m);
		break;
		}
	case 610: { // bset #[n],b
		u32 d_h = get_bh();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d_h;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_bh(t | m);
		break;
		}
	case 611: { // bset #[n],r
		u32 d = get_r(BIT(opcode, 8, 6) & 7);
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_r(BIT(opcode, 8, 6) & 7, t | m);
		break;
		}
	case 612: { // bset #[n],n
		u32 d = get_n(BIT(opcode, 8, 6) & 7);
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_n(BIT(opcode, 8, 6) & 7, t | m);
		break;
		}
	case 613: { // bset #[n],m
		u32 d = get_m(BIT(opcode, 8, 6) & 7);
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_m(BIT(opcode, 8, 6) & 7, t | m);
		break;
		}
	case 614: { // bset #[n],ep
		u32 d = get_ep();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_ep(t | m);
		break;
		}
	case 615: { // bset #[n],vba
		u32 d = get_vba();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_vba(t | m);
		break;
		}
	case 616: { // bset #[n],sc
		u32 d = get_sc();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_sc(t | m);
		break;
		}
	case 617: { // bset #[n],sz
		u32 d = get_sz();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_sz(t | m);
		break;
		}
	case 618: { // bset #[n],sr
		u32 d = get_sr();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_sr(t | m);
		break;
		}
	case 619: { // bset #[n],omr
		u32 d = get_omr();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_omr(t | m);
		break;
		}
	case 620: { // bset #[n],sp
		u32 d = get_sp();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_sp(t | m);
		break;
		}
	case 621: { // bset #[n],ssh
		u32 d = get_ssh();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_ssh(t | m);
		break;
		}
	case 622: { // bset #[n],ssl
		u32 d = get_ssl();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_ssl(t | m);
		break;
		}
	case 623: { // bset #[n],la
		u32 d = get_la();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_la(t | m);
		break;
		}
	case 624: { // bset #[n],lc
		u32 d = get_lc();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		set_lc(t | m);
		break;
		}
	case 625: { // bsr [x]
		u32 x = (m_pc+exv) & 0xffffff;
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		break;
		}
	case 626: { // bsr [x]
		u32 x = (m_pc + util::sext(bitswap<9>(opcode, 9, 8, 7, 6, 4, 3, 2, 1, 0), 9)) & 0xffffff;
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		break;
		}
	case 627: { // bsr r
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = m_pc + r;
		break;
		}
	case 628: { // bsset #[n],x:(r)-n,[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(m_x.read_dword(ea), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 629: { // bsset #[n],y:(r)-n,[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(m_y.read_dword(ea), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 630: { // bsset #[n],x:(r)+n,[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(m_x.read_dword(ea), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 631: { // bsset #[n],y:(r)+n,[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(m_y.read_dword(ea), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 632: { // bsset #[n],x:(r)-,[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(m_x.read_dword(ea), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 633: { // bsset #[n],y:(r)-,[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(m_y.read_dword(ea), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 634: { // bsset #[n],x:(r)+,[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(m_x.read_dword(ea), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 635: { // bsset #[n],y:(r)+,[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(m_y.read_dword(ea), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 636: { // bsset #[n],x:(r),[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(m_x.read_dword(ea), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 637: { // bsset #[n],y:(r),[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(m_y.read_dword(ea), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 638: { // bsset #[n],x:(r+n),[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(m_x.read_dword(ea), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 639: { // bsset #[n],y:(r+n),[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(m_y.read_dword(ea), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 640: { // bsset #[n],x:-(r),[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(m_x.read_dword(ea), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 641: { // bsset #[n],y:-(r),[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(m_y.read_dword(ea), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 642: { // bsset #[n],x:[abs],[x]
		u32 abs = exv;
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(m_x.read_dword(abs), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 643: { // bsset #[n],y:[abs],[x]
		u32 abs = exv;
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(m_y.read_dword(abs), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 644: { // bsset #[n],x:[aa],[x]
		u32 aa = BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(m_x.read_dword(aa), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 645: { // bsset #[n],y:[aa],[x]
		u32 aa = BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(m_y.read_dword(aa), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 646: { // bsset #[n],x:[pp],[x]
		u32 pp = 0xffffc0 + BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(m_x.read_dword(pp), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 647: { // bsset #[n],y:[pp],[x]
		u32 pp = 0xffffc0 + BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(m_y.read_dword(pp), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 648: { // bsset #[n],x:[qq],[x]
		u32 qq = 0xffff80 + BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(m_x.read_dword(qq), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 649: { // bsset #[n],y:[qq],[x]
		u32 qq = 0xffff80 + BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(m_y.read_dword(qq), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 650: { // bsset #[n],x0,[x]
		u32 s = get_x0();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 651: { // bsset #[n],x1,[x]
		u32 s = get_x1();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 652: { // bsset #[n],y0,[x]
		u32 s = get_y0();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 653: { // bsset #[n],y1,[x]
		u32 s = get_y1();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 654: { // bsset #[n],a0,[x]
		u32 s = get_a0();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 655: { // bsset #[n],b0,[x]
		u32 s = get_b0();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 656: { // bsset #[n],a2,[x]
		u32 s = get_a2();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 657: { // bsset #[n],b2,[x]
		u32 s = get_b2();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 658: { // bsset #[n],a1,[x]
		u32 s = get_a1();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 659: { // bsset #[n],b1,[x]
		u32 s = get_b1();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 660: { // bsset #[n],a,[x]
		u32 s_h = get_ah();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(s_h, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 661: { // bsset #[n],b,[x]
		u32 s_h = get_bh();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(s_h, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 662: { // bsset #[n],r,[x]
		u32 s = get_r(BIT(opcode, 8, 6) & 7);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 663: { // bsset #[n],n,[x]
		u32 s = get_n(BIT(opcode, 8, 6) & 7);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 664: { // bsset #[n],m,[x]
		u32 s = get_m(BIT(opcode, 8, 6) & 7);
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 665: { // bsset #[n],ep,[x]
		u32 s = get_ep();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 666: { // bsset #[n],vba,[x]
		u32 s = get_vba();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 667: { // bsset #[n],sc,[x]
		u32 s = get_sc();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 668: { // bsset #[n],sz,[x]
		u32 s = get_sz();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 669: { // bsset #[n],sr,[x]
		u32 s = get_sr();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 670: { // bsset #[n],omr,[x]
		u32 s = get_omr();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 671: { // bsset #[n],sp,[x]
		u32 s = get_sp();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 672: { // bsset #[n],ssh,[x]
		u32 s = get_ssh();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 673: { // bsset #[n],ssl,[x]
		u32 s = get_ssl();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 674: { // bsset #[n],la,[x]
		u32 s = get_la();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 675: { // bsset #[n],lc,[x]
		u32 s = get_lc();
		u32 n = BIT(opcode, 0, 5);
		u32 x = (m_pc+exv) & 0xffffff;
		if(BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 676: { // btst #[n],x:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_x.read_dword(ea);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 677: { // btst #[n],y:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_y.read_dword(ea);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 678: { // btst #[n],x:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_x.read_dword(ea);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 679: { // btst #[n],y:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_y.read_dword(ea);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 680: { // btst #[n],x:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_x.read_dword(ea);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 681: { // btst #[n],y:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_y.read_dword(ea);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 682: { // btst #[n],x:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_x.read_dword(ea);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 683: { // btst #[n],y:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_y.read_dword(ea);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 684: { // btst #[n],x:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_x.read_dword(ea);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 685: { // btst #[n],y:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_y.read_dword(ea);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 686: { // btst #[n],x:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_x.read_dword(ea);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 687: { // btst #[n],y:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_y.read_dword(ea);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 688: { // btst #[n],x:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_x.read_dword(ea);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 689: { // btst #[n],y:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_y.read_dword(ea);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 690: { // btst #[n],x:[abs]
		u32 abs = exv;
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_x.read_dword(abs);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 691: { // btst #[n],y:[abs]
		u32 abs = exv;
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_y.read_dword(abs);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 692: { // btst #[n],x:[aa]
		unhandled("btst #[n],x:[aa]");
		break;
		}
	case 693: { // btst #[n],y:[aa]
		unhandled("btst #[n],y:[aa]");
		break;
		}
	case 694: { // btst #[n],x:[pp]
		u32 pp = 0xffffc0 + BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_x.read_dword(pp);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 695: { // btst #[n],y:[pp]
		u32 pp = 0xffffc0 + BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_y.read_dword(pp);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 696: { // btst #[n],x:[qq]
		u32 qq = 0xffff80 + BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_x.read_dword(qq);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 697: { // btst #[n],y:[qq]
		u32 qq = 0xffff80 + BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 t = m_y.read_dword(qq);
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 698: { // btst #[n],x0
		u32 d = get_x0();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 699: { // btst #[n],x1
		u32 d = get_x1();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 700: { // btst #[n],y0
		u32 d = get_y0();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 701: { // btst #[n],y1
		u32 d = get_y1();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 702: { // btst #[n],a0
		u32 d = get_a0();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 703: { // btst #[n],b0
		u32 d = get_b0();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 704: { // btst #[n],a2
		u32 d = get_a2();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 705: { // btst #[n],b2
		u32 d = get_b2();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 706: { // btst #[n],a1
		u32 d = get_a1();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 707: { // btst #[n],b1
		u32 d = get_b1();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 708: { // btst #[n],a
		u64 d = get_a();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 709: { // btst #[n],b
		u64 d = get_b();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 710: { // btst #[n],r
		u32 d = get_r(BIT(opcode, 8, 6) & 7);
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 711: { // btst #[n],n
		u32 d = get_n(BIT(opcode, 8, 6) & 7);
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 712: { // btst #[n],m
		u32 d = get_m(BIT(opcode, 8, 6) & 7);
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 713: { // btst #[n],ep
		u32 d = get_ep();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 714: { // btst #[n],vba
		u32 d = get_vba();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 715: { // btst #[n],sc
		u32 d = get_sc();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 716: { // btst #[n],sz
		u32 d = get_sz();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 717: { // btst #[n],sr
		u32 d = get_sr();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 718: { // btst #[n],omr
		u32 d = get_omr();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 719: { // btst #[n],sp
		u32 d = get_sp();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 720: { // btst #[n],ssh
		u32 d = get_ssh();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 721: { // btst #[n],ssl
		u32 d = get_ssl();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 722: { // btst #[n],la
		u32 d = get_la();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 723: { // btst #[n],lc
		u32 d = get_lc();
		u32 n = BIT(opcode, 0, 5);
		u32 t = d;
		u32 m = 1 << n;
		if(t & m) {
		m_ccr |= CCR_C;
		} else {
		m_ccr &= ~CCR_C;
		}
		break;
		}
	case 724: { // clb a,a
		unhandled("clb a,a");
		break;
		}
	case 725: { // clb a,b
		unhandled("clb a,b");
		break;
		}
	case 726: { // clb b,a
		unhandled("clb b,a");
		break;
		}
	case 727: { // clb b,b
		unhandled("clb b,b");
		break;
		}
	case 728: { // cmp #[i],a
		u32 i = BIT(opcode, 8, 6);
		u64 d = get_a();
		(void)do_sub56(u64(i) << 24, d);
		break;
		}
	case 729: { // cmp #[i],b
		u32 i = BIT(opcode, 8, 6);
		u64 d = get_b();
		(void)do_sub56(u64(i) << 24, d);
		break;
		}
	case 730: { // cmp #[i],a
		u32 i = exv;
		u64 d = get_a();
		(void)do_sub56(util::sext(u64(i) << 24, 48), d);
		break;
		}
	case 731: { // cmp #[i],b
		u32 i = exv;
		u64 d = get_b();
		(void)do_sub56(util::sext(u64(i) << 24, 48), d);
		break;
		}
	case 732: { // cmpu b,a
		unhandled("cmpu b,a");
		break;
		}
	case 733: { // cmpu b,b
		unhandled("cmpu b,b");
		break;
		}
	case 734: { // cmpu x0,a
		unhandled("cmpu x0,a");
		break;
		}
	case 735: { // cmpu x0,b
		unhandled("cmpu x0,b");
		break;
		}
	case 736: { // cmpu y0,a
		unhandled("cmpu y0,a");
		break;
		}
	case 737: { // cmpu y0,b
		unhandled("cmpu y0,b");
		break;
		}
	case 738: { // cmpu x1,a
		unhandled("cmpu x1,a");
		break;
		}
	case 739: { // cmpu x1,b
		unhandled("cmpu x1,b");
		break;
		}
	case 740: { // cmpu y1,a
		unhandled("cmpu y1,a");
		break;
		}
	case 741: { // cmpu y1,b
		unhandled("cmpu y1,b");
		break;
		}
	case 742: { // debug
		unhandled("debug");
		break;
		}
	case 743: { // debugcc
		unhandled("debugcc");
		break;
		}
	case 744: { // debugge
		unhandled("debugge");
		break;
		}
	case 745: { // debugne
		unhandled("debugne");
		break;
		}
	case 746: { // debugpl
		unhandled("debugpl");
		break;
		}
	case 747: { // debugnn
		unhandled("debugnn");
		break;
		}
	case 748: { // debugec
		unhandled("debugec");
		break;
		}
	case 749: { // debuglc
		unhandled("debuglc");
		break;
		}
	case 750: { // debuggt
		unhandled("debuggt");
		break;
		}
	case 751: { // debugcs
		unhandled("debugcs");
		break;
		}
	case 752: { // debuglt
		unhandled("debuglt");
		break;
		}
	case 753: { // debugeq
		unhandled("debugeq");
		break;
		}
	case 754: { // debugmi
		unhandled("debugmi");
		break;
		}
	case 755: { // debugnr
		unhandled("debugnr");
		break;
		}
	case 756: { // debuges
		unhandled("debuges");
		break;
		}
	case 757: { // debugls
		unhandled("debugls");
		break;
		}
	case 758: { // debugle
		unhandled("debugle");
		break;
		}
	case 759: { // dec a
		unhandled("dec a");
		break;
		}
	case 760: { // dec b
		unhandled("dec b");
		break;
		}
	case 761: { // div x0,a
		unhandled("div x0,a");
		break;
		}
	case 762: { // div x0,b
		unhandled("div x0,b");
		break;
		}
	case 763: { // div y0,a
		unhandled("div y0,a");
		break;
		}
	case 764: { // div y0,b
		unhandled("div y0,b");
		break;
		}
	case 765: { // div x1,a
		unhandled("div x1,a");
		break;
		}
	case 766: { // div x1,b
		unhandled("div x1,b");
		break;
		}
	case 767: { // div y1,a
		unhandled("div y1,a");
		break;
		}
	case 768: { // div y1,b
		unhandled("div y1,b");
		break;
		}
	case 769: { // dmacss +x0,x0,a
		unhandled("dmacss +x0,x0,a");
		break;
		}
	case 770: { // dmacss +y0,y0,a
		unhandled("dmacss +y0,y0,a");
		break;
		}
	case 771: { // dmacss +x1,x0,a
		unhandled("dmacss +x1,x0,a");
		break;
		}
	case 772: { // dmacss +y1,y0,a
		unhandled("dmacss +y1,y0,a");
		break;
		}
	case 773: { // dmacss +x1,x1,a
		unhandled("dmacss +x1,x1,a");
		break;
		}
	case 774: { // dmacss +y1,y1,a
		unhandled("dmacss +y1,y1,a");
		break;
		}
	case 775: { // dmacss +x0,x1,a
		unhandled("dmacss +x0,x1,a");
		break;
		}
	case 776: { // dmacss +y0,y1,a
		unhandled("dmacss +y0,y1,a");
		break;
		}
	case 777: { // dmacss +x0,y1,a
		unhandled("dmacss +x0,y1,a");
		break;
		}
	case 778: { // dmacss +y0,x0,a
		unhandled("dmacss +y0,x0,a");
		break;
		}
	case 779: { // dmacss +x1,y0,a
		unhandled("dmacss +x1,y0,a");
		break;
		}
	case 780: { // dmacss +y1,x1,a
		unhandled("dmacss +y1,x1,a");
		break;
		}
	case 781: { // dmacss +y1,x0,a
		unhandled("dmacss +y1,x0,a");
		break;
		}
	case 782: { // dmacss +x0,y0,a
		unhandled("dmacss +x0,y0,a");
		break;
		}
	case 783: { // dmacss +y0,x1,a
		unhandled("dmacss +y0,x1,a");
		break;
		}
	case 784: { // dmacss +x1,y1,a
		unhandled("dmacss +x1,y1,a");
		break;
		}
	case 785: { // dmacss -x0,x0,a
		unhandled("dmacss -x0,x0,a");
		break;
		}
	case 786: { // dmacss -y0,y0,a
		unhandled("dmacss -y0,y0,a");
		break;
		}
	case 787: { // dmacss -x1,x0,a
		unhandled("dmacss -x1,x0,a");
		break;
		}
	case 788: { // dmacss -y1,y0,a
		unhandled("dmacss -y1,y0,a");
		break;
		}
	case 789: { // dmacss -x1,x1,a
		unhandled("dmacss -x1,x1,a");
		break;
		}
	case 790: { // dmacss -y1,y1,a
		unhandled("dmacss -y1,y1,a");
		break;
		}
	case 791: { // dmacss -x0,x1,a
		unhandled("dmacss -x0,x1,a");
		break;
		}
	case 792: { // dmacss -y0,y1,a
		unhandled("dmacss -y0,y1,a");
		break;
		}
	case 793: { // dmacss -x0,y1,a
		unhandled("dmacss -x0,y1,a");
		break;
		}
	case 794: { // dmacss -y0,x0,a
		unhandled("dmacss -y0,x0,a");
		break;
		}
	case 795: { // dmacss -x1,y0,a
		unhandled("dmacss -x1,y0,a");
		break;
		}
	case 796: { // dmacss -y1,x1,a
		unhandled("dmacss -y1,x1,a");
		break;
		}
	case 797: { // dmacss -y1,x0,a
		unhandled("dmacss -y1,x0,a");
		break;
		}
	case 798: { // dmacss -x0,y0,a
		unhandled("dmacss -x0,y0,a");
		break;
		}
	case 799: { // dmacss -y0,x1,a
		unhandled("dmacss -y0,x1,a");
		break;
		}
	case 800: { // dmacss -x1,y1,a
		unhandled("dmacss -x1,y1,a");
		break;
		}
	case 801: { // dmacss +x0,x0,b
		unhandled("dmacss +x0,x0,b");
		break;
		}
	case 802: { // dmacss +y0,y0,b
		unhandled("dmacss +y0,y0,b");
		break;
		}
	case 803: { // dmacss +x1,x0,b
		unhandled("dmacss +x1,x0,b");
		break;
		}
	case 804: { // dmacss +y1,y0,b
		unhandled("dmacss +y1,y0,b");
		break;
		}
	case 805: { // dmacss +x1,x1,b
		unhandled("dmacss +x1,x1,b");
		break;
		}
	case 806: { // dmacss +y1,y1,b
		unhandled("dmacss +y1,y1,b");
		break;
		}
	case 807: { // dmacss +x0,x1,b
		unhandled("dmacss +x0,x1,b");
		break;
		}
	case 808: { // dmacss +y0,y1,b
		unhandled("dmacss +y0,y1,b");
		break;
		}
	case 809: { // dmacss +x0,y1,b
		unhandled("dmacss +x0,y1,b");
		break;
		}
	case 810: { // dmacss +y0,x0,b
		unhandled("dmacss +y0,x0,b");
		break;
		}
	case 811: { // dmacss +x1,y0,b
		unhandled("dmacss +x1,y0,b");
		break;
		}
	case 812: { // dmacss +y1,x1,b
		unhandled("dmacss +y1,x1,b");
		break;
		}
	case 813: { // dmacss +y1,x0,b
		unhandled("dmacss +y1,x0,b");
		break;
		}
	case 814: { // dmacss +x0,y0,b
		unhandled("dmacss +x0,y0,b");
		break;
		}
	case 815: { // dmacss +y0,x1,b
		unhandled("dmacss +y0,x1,b");
		break;
		}
	case 816: { // dmacss +x1,y1,b
		unhandled("dmacss +x1,y1,b");
		break;
		}
	case 817: { // dmacss -x0,x0,b
		unhandled("dmacss -x0,x0,b");
		break;
		}
	case 818: { // dmacss -y0,y0,b
		unhandled("dmacss -y0,y0,b");
		break;
		}
	case 819: { // dmacss -x1,x0,b
		unhandled("dmacss -x1,x0,b");
		break;
		}
	case 820: { // dmacss -y1,y0,b
		unhandled("dmacss -y1,y0,b");
		break;
		}
	case 821: { // dmacss -x1,x1,b
		unhandled("dmacss -x1,x1,b");
		break;
		}
	case 822: { // dmacss -y1,y1,b
		unhandled("dmacss -y1,y1,b");
		break;
		}
	case 823: { // dmacss -x0,x1,b
		unhandled("dmacss -x0,x1,b");
		break;
		}
	case 824: { // dmacss -y0,y1,b
		unhandled("dmacss -y0,y1,b");
		break;
		}
	case 825: { // dmacss -x0,y1,b
		unhandled("dmacss -x0,y1,b");
		break;
		}
	case 826: { // dmacss -y0,x0,b
		unhandled("dmacss -y0,x0,b");
		break;
		}
	case 827: { // dmacss -x1,y0,b
		unhandled("dmacss -x1,y0,b");
		break;
		}
	case 828: { // dmacss -y1,x1,b
		unhandled("dmacss -y1,x1,b");
		break;
		}
	case 829: { // dmacss -y1,x0,b
		unhandled("dmacss -y1,x0,b");
		break;
		}
	case 830: { // dmacss -x0,y0,b
		unhandled("dmacss -x0,y0,b");
		break;
		}
	case 831: { // dmacss -y0,x1,b
		unhandled("dmacss -y0,x1,b");
		break;
		}
	case 832: { // dmacss -x1,y1,b
		unhandled("dmacss -x1,y1,b");
		break;
		}
	case 833: { // dmacsu +x0,x0,a
		unhandled("dmacsu +x0,x0,a");
		break;
		}
	case 834: { // dmacsu +y0,y0,a
		unhandled("dmacsu +y0,y0,a");
		break;
		}
	case 835: { // dmacsu +x1,x0,a
		unhandled("dmacsu +x1,x0,a");
		break;
		}
	case 836: { // dmacsu +y1,y0,a
		unhandled("dmacsu +y1,y0,a");
		break;
		}
	case 837: { // dmacsu +x1,x1,a
		unhandled("dmacsu +x1,x1,a");
		break;
		}
	case 838: { // dmacsu +y1,y1,a
		unhandled("dmacsu +y1,y1,a");
		break;
		}
	case 839: { // dmacsu +x0,x1,a
		unhandled("dmacsu +x0,x1,a");
		break;
		}
	case 840: { // dmacsu +y0,y1,a
		unhandled("dmacsu +y0,y1,a");
		break;
		}
	case 841: { // dmacsu +x0,y1,a
		unhandled("dmacsu +x0,y1,a");
		break;
		}
	case 842: { // dmacsu +y0,x0,a
		unhandled("dmacsu +y0,x0,a");
		break;
		}
	case 843: { // dmacsu +x1,y0,a
		unhandled("dmacsu +x1,y0,a");
		break;
		}
	case 844: { // dmacsu +y1,x1,a
		unhandled("dmacsu +y1,x1,a");
		break;
		}
	case 845: { // dmacsu +y1,x0,a
		unhandled("dmacsu +y1,x0,a");
		break;
		}
	case 846: { // dmacsu +x0,y0,a
		unhandled("dmacsu +x0,y0,a");
		break;
		}
	case 847: { // dmacsu +y0,x1,a
		unhandled("dmacsu +y0,x1,a");
		break;
		}
	case 848: { // dmacsu +x1,y1,a
		unhandled("dmacsu +x1,y1,a");
		break;
		}
	case 849: { // dmacsu -x0,x0,a
		unhandled("dmacsu -x0,x0,a");
		break;
		}
	case 850: { // dmacsu -y0,y0,a
		unhandled("dmacsu -y0,y0,a");
		break;
		}
	case 851: { // dmacsu -x1,x0,a
		unhandled("dmacsu -x1,x0,a");
		break;
		}
	case 852: { // dmacsu -y1,y0,a
		unhandled("dmacsu -y1,y0,a");
		break;
		}
	case 853: { // dmacsu -x1,x1,a
		unhandled("dmacsu -x1,x1,a");
		break;
		}
	case 854: { // dmacsu -y1,y1,a
		unhandled("dmacsu -y1,y1,a");
		break;
		}
	case 855: { // dmacsu -x0,x1,a
		unhandled("dmacsu -x0,x1,a");
		break;
		}
	case 856: { // dmacsu -y0,y1,a
		unhandled("dmacsu -y0,y1,a");
		break;
		}
	case 857: { // dmacsu -x0,y1,a
		unhandled("dmacsu -x0,y1,a");
		break;
		}
	case 858: { // dmacsu -y0,x0,a
		unhandled("dmacsu -y0,x0,a");
		break;
		}
	case 859: { // dmacsu -x1,y0,a
		unhandled("dmacsu -x1,y0,a");
		break;
		}
	case 860: { // dmacsu -y1,x1,a
		unhandled("dmacsu -y1,x1,a");
		break;
		}
	case 861: { // dmacsu -y1,x0,a
		unhandled("dmacsu -y1,x0,a");
		break;
		}
	case 862: { // dmacsu -x0,y0,a
		unhandled("dmacsu -x0,y0,a");
		break;
		}
	case 863: { // dmacsu -y0,x1,a
		unhandled("dmacsu -y0,x1,a");
		break;
		}
	case 864: { // dmacsu -x1,y1,a
		unhandled("dmacsu -x1,y1,a");
		break;
		}
	case 865: { // dmacsu +x0,x0,b
		unhandled("dmacsu +x0,x0,b");
		break;
		}
	case 866: { // dmacsu +y0,y0,b
		unhandled("dmacsu +y0,y0,b");
		break;
		}
	case 867: { // dmacsu +x1,x0,b
		unhandled("dmacsu +x1,x0,b");
		break;
		}
	case 868: { // dmacsu +y1,y0,b
		unhandled("dmacsu +y1,y0,b");
		break;
		}
	case 869: { // dmacsu +x1,x1,b
		unhandled("dmacsu +x1,x1,b");
		break;
		}
	case 870: { // dmacsu +y1,y1,b
		unhandled("dmacsu +y1,y1,b");
		break;
		}
	case 871: { // dmacsu +x0,x1,b
		unhandled("dmacsu +x0,x1,b");
		break;
		}
	case 872: { // dmacsu +y0,y1,b
		unhandled("dmacsu +y0,y1,b");
		break;
		}
	case 873: { // dmacsu +x0,y1,b
		unhandled("dmacsu +x0,y1,b");
		break;
		}
	case 874: { // dmacsu +y0,x0,b
		unhandled("dmacsu +y0,x0,b");
		break;
		}
	case 875: { // dmacsu +x1,y0,b
		unhandled("dmacsu +x1,y0,b");
		break;
		}
	case 876: { // dmacsu +y1,x1,b
		unhandled("dmacsu +y1,x1,b");
		break;
		}
	case 877: { // dmacsu +y1,x0,b
		unhandled("dmacsu +y1,x0,b");
		break;
		}
	case 878: { // dmacsu +x0,y0,b
		unhandled("dmacsu +x0,y0,b");
		break;
		}
	case 879: { // dmacsu +y0,x1,b
		unhandled("dmacsu +y0,x1,b");
		break;
		}
	case 880: { // dmacsu +x1,y1,b
		unhandled("dmacsu +x1,y1,b");
		break;
		}
	case 881: { // dmacsu -x0,x0,b
		unhandled("dmacsu -x0,x0,b");
		break;
		}
	case 882: { // dmacsu -y0,y0,b
		unhandled("dmacsu -y0,y0,b");
		break;
		}
	case 883: { // dmacsu -x1,x0,b
		unhandled("dmacsu -x1,x0,b");
		break;
		}
	case 884: { // dmacsu -y1,y0,b
		unhandled("dmacsu -y1,y0,b");
		break;
		}
	case 885: { // dmacsu -x1,x1,b
		unhandled("dmacsu -x1,x1,b");
		break;
		}
	case 886: { // dmacsu -y1,y1,b
		unhandled("dmacsu -y1,y1,b");
		break;
		}
	case 887: { // dmacsu -x0,x1,b
		unhandled("dmacsu -x0,x1,b");
		break;
		}
	case 888: { // dmacsu -y0,y1,b
		unhandled("dmacsu -y0,y1,b");
		break;
		}
	case 889: { // dmacsu -x0,y1,b
		unhandled("dmacsu -x0,y1,b");
		break;
		}
	case 890: { // dmacsu -y0,x0,b
		unhandled("dmacsu -y0,x0,b");
		break;
		}
	case 891: { // dmacsu -x1,y0,b
		unhandled("dmacsu -x1,y0,b");
		break;
		}
	case 892: { // dmacsu -y1,x1,b
		unhandled("dmacsu -y1,x1,b");
		break;
		}
	case 893: { // dmacsu -y1,x0,b
		unhandled("dmacsu -y1,x0,b");
		break;
		}
	case 894: { // dmacsu -x0,y0,b
		unhandled("dmacsu -x0,y0,b");
		break;
		}
	case 895: { // dmacsu -y0,x1,b
		unhandled("dmacsu -y0,x1,b");
		break;
		}
	case 896: { // dmacsu -x1,y1,b
		unhandled("dmacsu -x1,y1,b");
		break;
		}
	case 897: { // dmacuu +x0,x0,a
		unhandled("dmacuu +x0,x0,a");
		break;
		}
	case 898: { // dmacuu +y0,y0,a
		unhandled("dmacuu +y0,y0,a");
		break;
		}
	case 899: { // dmacuu +x1,x0,a
		unhandled("dmacuu +x1,x0,a");
		break;
		}
	case 900: { // dmacuu +y1,y0,a
		unhandled("dmacuu +y1,y0,a");
		break;
		}
	case 901: { // dmacuu +x1,x1,a
		unhandled("dmacuu +x1,x1,a");
		break;
		}
	case 902: { // dmacuu +y1,y1,a
		unhandled("dmacuu +y1,y1,a");
		break;
		}
	case 903: { // dmacuu +x0,x1,a
		unhandled("dmacuu +x0,x1,a");
		break;
		}
	case 904: { // dmacuu +y0,y1,a
		unhandled("dmacuu +y0,y1,a");
		break;
		}
	case 905: { // dmacuu +x0,y1,a
		unhandled("dmacuu +x0,y1,a");
		break;
		}
	case 906: { // dmacuu +y0,x0,a
		unhandled("dmacuu +y0,x0,a");
		break;
		}
	case 907: { // dmacuu +x1,y0,a
		unhandled("dmacuu +x1,y0,a");
		break;
		}
	case 908: { // dmacuu +y1,x1,a
		unhandled("dmacuu +y1,x1,a");
		break;
		}
	case 909: { // dmacuu +y1,x0,a
		unhandled("dmacuu +y1,x0,a");
		break;
		}
	case 910: { // dmacuu +x0,y0,a
		unhandled("dmacuu +x0,y0,a");
		break;
		}
	case 911: { // dmacuu +y0,x1,a
		unhandled("dmacuu +y0,x1,a");
		break;
		}
	case 912: { // dmacuu +x1,y1,a
		unhandled("dmacuu +x1,y1,a");
		break;
		}
	case 913: { // dmacuu -x0,x0,a
		unhandled("dmacuu -x0,x0,a");
		break;
		}
	case 914: { // dmacuu -y0,y0,a
		unhandled("dmacuu -y0,y0,a");
		break;
		}
	case 915: { // dmacuu -x1,x0,a
		unhandled("dmacuu -x1,x0,a");
		break;
		}
	case 916: { // dmacuu -y1,y0,a
		unhandled("dmacuu -y1,y0,a");
		break;
		}
	case 917: { // dmacuu -x1,x1,a
		unhandled("dmacuu -x1,x1,a");
		break;
		}
	case 918: { // dmacuu -y1,y1,a
		unhandled("dmacuu -y1,y1,a");
		break;
		}
	case 919: { // dmacuu -x0,x1,a
		unhandled("dmacuu -x0,x1,a");
		break;
		}
	case 920: { // dmacuu -y0,y1,a
		unhandled("dmacuu -y0,y1,a");
		break;
		}
	case 921: { // dmacuu -x0,y1,a
		unhandled("dmacuu -x0,y1,a");
		break;
		}
	case 922: { // dmacuu -y0,x0,a
		unhandled("dmacuu -y0,x0,a");
		break;
		}
	case 923: { // dmacuu -x1,y0,a
		unhandled("dmacuu -x1,y0,a");
		break;
		}
	case 924: { // dmacuu -y1,x1,a
		unhandled("dmacuu -y1,x1,a");
		break;
		}
	case 925: { // dmacuu -y1,x0,a
		unhandled("dmacuu -y1,x0,a");
		break;
		}
	case 926: { // dmacuu -x0,y0,a
		unhandled("dmacuu -x0,y0,a");
		break;
		}
	case 927: { // dmacuu -y0,x1,a
		unhandled("dmacuu -y0,x1,a");
		break;
		}
	case 928: { // dmacuu -x1,y1,a
		unhandled("dmacuu -x1,y1,a");
		break;
		}
	case 929: { // dmacuu +x0,x0,b
		unhandled("dmacuu +x0,x0,b");
		break;
		}
	case 930: { // dmacuu +y0,y0,b
		unhandled("dmacuu +y0,y0,b");
		break;
		}
	case 931: { // dmacuu +x1,x0,b
		unhandled("dmacuu +x1,x0,b");
		break;
		}
	case 932: { // dmacuu +y1,y0,b
		unhandled("dmacuu +y1,y0,b");
		break;
		}
	case 933: { // dmacuu +x1,x1,b
		unhandled("dmacuu +x1,x1,b");
		break;
		}
	case 934: { // dmacuu +y1,y1,b
		unhandled("dmacuu +y1,y1,b");
		break;
		}
	case 935: { // dmacuu +x0,x1,b
		unhandled("dmacuu +x0,x1,b");
		break;
		}
	case 936: { // dmacuu +y0,y1,b
		unhandled("dmacuu +y0,y1,b");
		break;
		}
	case 937: { // dmacuu +x0,y1,b
		unhandled("dmacuu +x0,y1,b");
		break;
		}
	case 938: { // dmacuu +y0,x0,b
		unhandled("dmacuu +y0,x0,b");
		break;
		}
	case 939: { // dmacuu +x1,y0,b
		unhandled("dmacuu +x1,y0,b");
		break;
		}
	case 940: { // dmacuu +y1,x1,b
		unhandled("dmacuu +y1,x1,b");
		break;
		}
	case 941: { // dmacuu +y1,x0,b
		unhandled("dmacuu +y1,x0,b");
		break;
		}
	case 942: { // dmacuu +x0,y0,b
		unhandled("dmacuu +x0,y0,b");
		break;
		}
	case 943: { // dmacuu +y0,x1,b
		unhandled("dmacuu +y0,x1,b");
		break;
		}
	case 944: { // dmacuu +x1,y1,b
		unhandled("dmacuu +x1,y1,b");
		break;
		}
	case 945: { // dmacuu -x0,x0,b
		unhandled("dmacuu -x0,x0,b");
		break;
		}
	case 946: { // dmacuu -y0,y0,b
		unhandled("dmacuu -y0,y0,b");
		break;
		}
	case 947: { // dmacuu -x1,x0,b
		unhandled("dmacuu -x1,x0,b");
		break;
		}
	case 948: { // dmacuu -y1,y0,b
		unhandled("dmacuu -y1,y0,b");
		break;
		}
	case 949: { // dmacuu -x1,x1,b
		unhandled("dmacuu -x1,x1,b");
		break;
		}
	case 950: { // dmacuu -y1,y1,b
		unhandled("dmacuu -y1,y1,b");
		break;
		}
	case 951: { // dmacuu -x0,x1,b
		unhandled("dmacuu -x0,x1,b");
		break;
		}
	case 952: { // dmacuu -y0,y1,b
		unhandled("dmacuu -y0,y1,b");
		break;
		}
	case 953: { // dmacuu -x0,y1,b
		unhandled("dmacuu -x0,y1,b");
		break;
		}
	case 954: { // dmacuu -y0,x0,b
		unhandled("dmacuu -y0,x0,b");
		break;
		}
	case 955: { // dmacuu -x1,y0,b
		unhandled("dmacuu -x1,y0,b");
		break;
		}
	case 956: { // dmacuu -y1,x1,b
		unhandled("dmacuu -y1,x1,b");
		break;
		}
	case 957: { // dmacuu -y1,x0,b
		unhandled("dmacuu -y1,x0,b");
		break;
		}
	case 958: { // dmacuu -x0,y0,b
		unhandled("dmacuu -x0,y0,b");
		break;
		}
	case 959: { // dmacuu -y0,x1,b
		unhandled("dmacuu -y0,x1,b");
		break;
		}
	case 960: { // dmacuu -x1,y1,b
		unhandled("dmacuu -x1,y1,b");
		break;
		}
	case 961: { // do x:(r)-n,[expr]
		unhandled("do x:(r)-n,[expr]");
		break;
		}
	case 962: { // do y:(r)-n,[expr]
		unhandled("do y:(r)-n,[expr]");
		break;
		}
	case 963: { // do x:(r)+n,[expr]
		unhandled("do x:(r)+n,[expr]");
		break;
		}
	case 964: { // do y:(r)+n,[expr]
		unhandled("do y:(r)+n,[expr]");
		break;
		}
	case 965: { // do x:(r)-,[expr]
		unhandled("do x:(r)-,[expr]");
		break;
		}
	case 966: { // do y:(r)-,[expr]
		unhandled("do y:(r)-,[expr]");
		break;
		}
	case 967: { // do x:(r)+,[expr]
		unhandled("do x:(r)+,[expr]");
		break;
		}
	case 968: { // do y:(r)+,[expr]
		unhandled("do y:(r)+,[expr]");
		break;
		}
	case 969: { // do x:(r),[expr]
		unhandled("do x:(r),[expr]");
		break;
		}
	case 970: { // do y:(r),[expr]
		unhandled("do y:(r),[expr]");
		break;
		}
	case 971: { // do x:(r+n),[expr]
		unhandled("do x:(r+n),[expr]");
		break;
		}
	case 972: { // do y:(r+n),[expr]
		unhandled("do y:(r+n),[expr]");
		break;
		}
	case 973: { // do x:-(r),[expr]
		unhandled("do x:-(r),[expr]");
		break;
		}
	case 974: { // do y:-(r),[expr]
		unhandled("do y:-(r),[expr]");
		break;
		}
	case 975: { // do x:[aa],[expr]
		unhandled("do x:[aa],[expr]");
		break;
		}
	case 976: { // do y:[aa],[expr]
		unhandled("do y:[aa],[expr]");
		break;
		}
	case 977: { // do #[i],[expr]
		u32 i = bitswap<12>(opcode, 3, 2, 1, 0, 15, 14, 13, 12, 11, 10, 9, 8);
		u32 expr = exv;
		inc_sp();
		set_ssh(get_la());
		set_ssl(get_lc());
		set_lc(i);
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		set_la(expr);
		m_mr |= MR_LF;
		break;
		}
	case 978: { // do x0,[expr]
		u32 s = get_x0();
		u32 expr = exv;
		inc_sp();
		set_ssh(get_la());
		set_ssl(get_lc());
		set_lc(s);
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		set_la(expr);
		m_mr |= MR_LF;
		break;
		}
	case 979: { // do x1,[expr]
		u32 s = get_x1();
		u32 expr = exv;
		inc_sp();
		set_ssh(get_la());
		set_ssl(get_lc());
		set_lc(s);
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		set_la(expr);
		m_mr |= MR_LF;
		break;
		}
	case 980: { // do y0,[expr]
		u32 s = get_y0();
		u32 expr = exv;
		inc_sp();
		set_ssh(get_la());
		set_ssl(get_lc());
		set_lc(s);
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		set_la(expr);
		m_mr |= MR_LF;
		break;
		}
	case 981: { // do y1,[expr]
		u32 s = get_y1();
		u32 expr = exv;
		inc_sp();
		set_ssh(get_la());
		set_ssl(get_lc());
		set_lc(s);
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		set_la(expr);
		m_mr |= MR_LF;
		break;
		}
	case 982: { // do a0,[expr]
		u32 s = get_a0();
		u32 expr = exv;
		inc_sp();
		set_ssh(get_la());
		set_ssl(get_lc());
		set_lc(s);
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		set_la(expr);
		m_mr |= MR_LF;
		break;
		}
	case 983: { // do b0,[expr]
		u32 s = get_b0();
		u32 expr = exv;
		inc_sp();
		set_ssh(get_la());
		set_ssl(get_lc());
		set_lc(s);
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		set_la(expr);
		m_mr |= MR_LF;
		break;
		}
	case 984: { // do a2,[expr]
		u32 s = get_a2();
		u32 expr = exv;
		inc_sp();
		set_ssh(get_la());
		set_ssl(get_lc());
		set_lc(s);
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		set_la(expr);
		m_mr |= MR_LF;
		break;
		}
	case 985: { // do b2,[expr]
		u32 s = get_b2();
		u32 expr = exv;
		inc_sp();
		set_ssh(get_la());
		set_ssl(get_lc());
		set_lc(s);
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		set_la(expr);
		m_mr |= MR_LF;
		break;
		}
	case 986: { // do a1,[expr]
		u32 s = get_a1();
		u32 expr = exv;
		inc_sp();
		set_ssh(get_la());
		set_ssl(get_lc());
		set_lc(s);
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		set_la(expr);
		m_mr |= MR_LF;
		break;
		}
	case 987: { // do b1,[expr]
		u32 s = get_b1();
		u32 expr = exv;
		inc_sp();
		set_ssh(get_la());
		set_ssl(get_lc());
		set_lc(s);
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		set_la(expr);
		m_mr |= MR_LF;
		break;
		}
	case 988: { // do a,[expr]
		u64 s = get_a();
		u32 expr = exv;
		inc_sp();
		set_ssh(get_la());
		set_ssl(get_lc());
		set_lc(s);
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		set_la(expr);
		m_mr |= MR_LF;
		break;
		}
	case 989: { // do b,[expr]
		u64 s = get_b();
		u32 expr = exv;
		inc_sp();
		set_ssh(get_la());
		set_ssl(get_lc());
		set_lc(s);
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		set_la(expr);
		m_mr |= MR_LF;
		break;
		}
	case 990: { // do r,[expr]
		u32 s = get_r(BIT(opcode, 8, 6) & 7);
		u32 expr = exv;
		inc_sp();
		set_ssh(get_la());
		set_ssl(get_lc());
		set_lc(s);
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		set_la(expr);
		m_mr |= MR_LF;
		break;
		}
	case 991: { // do n,[expr]
		u32 s = get_n(BIT(opcode, 8, 6) & 7);
		u32 expr = exv;
		inc_sp();
		set_ssh(get_la());
		set_ssl(get_lc());
		set_lc(s);
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		set_la(expr);
		m_mr |= MR_LF;
		break;
		}
	case 992: { // do m,[expr]
		u32 s = get_m(BIT(opcode, 8, 6) & 7);
		u32 expr = exv;
		inc_sp();
		set_ssh(get_la());
		set_ssl(get_lc());
		set_lc(s);
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		set_la(expr);
		m_mr |= MR_LF;
		break;
		}
	case 993: { // do ep,[expr]
		u32 s = get_ep();
		u32 expr = exv;
		inc_sp();
		set_ssh(get_la());
		set_ssl(get_lc());
		set_lc(s);
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		set_la(expr);
		m_mr |= MR_LF;
		break;
		}
	case 994: { // do vba,[expr]
		u32 s = get_vba();
		u32 expr = exv;
		inc_sp();
		set_ssh(get_la());
		set_ssl(get_lc());
		set_lc(s);
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		set_la(expr);
		m_mr |= MR_LF;
		break;
		}
	case 995: { // do sc,[expr]
		u32 s = get_sc();
		u32 expr = exv;
		inc_sp();
		set_ssh(get_la());
		set_ssl(get_lc());
		set_lc(s);
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		set_la(expr);
		m_mr |= MR_LF;
		break;
		}
	case 996: { // do sz,[expr]
		u32 s = get_sz();
		u32 expr = exv;
		inc_sp();
		set_ssh(get_la());
		set_ssl(get_lc());
		set_lc(s);
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		set_la(expr);
		m_mr |= MR_LF;
		break;
		}
	case 997: { // do sr,[expr]
		u32 s = get_sr();
		u32 expr = exv;
		inc_sp();
		set_ssh(get_la());
		set_ssl(get_lc());
		set_lc(s);
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		set_la(expr);
		m_mr |= MR_LF;
		break;
		}
	case 998: { // do omr,[expr]
		u32 s = get_omr();
		u32 expr = exv;
		inc_sp();
		set_ssh(get_la());
		set_ssl(get_lc());
		set_lc(s);
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		set_la(expr);
		m_mr |= MR_LF;
		break;
		}
	case 999: { // do sp,[expr]
		u32 s = get_sp();
		u32 expr = exv;
		inc_sp();
		set_ssh(get_la());
		set_ssl(get_lc());
		set_lc(s);
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		set_la(expr);
		m_mr |= MR_LF;
		break;
		}
	case 1000: { // do ssl,[expr]
		u32 s = get_ssl();
		u32 expr = exv;
		inc_sp();
		set_ssh(get_la());
		set_ssl(get_lc());
		set_lc(s);
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		set_la(expr);
		m_mr |= MR_LF;
		break;
		}
	case 1001: { // do la,[expr]
		u32 s = get_la();
		u32 expr = exv;
		inc_sp();
		set_ssh(get_la());
		set_ssl(get_lc());
		set_lc(s);
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		set_la(expr);
		m_mr |= MR_LF;
		break;
		}
	case 1002: { // do lc,[expr]
		u32 s = get_lc();
		u32 expr = exv;
		inc_sp();
		set_ssh(get_la());
		set_ssl(get_lc());
		set_lc(s);
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		set_la(expr);
		m_mr |= MR_LF;
		break;
		}
	case 1003: { // do forever,[expr]
		u32 expr = exv;
		inc_sp();
		set_ssh(get_la());
		set_ssl(get_lc());
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		set_la(expr);
		m_mr |= MR_LF;
		m_emr |= EMR_FV;
		break;
		}
	case 1004: { // dor x:(r)-n,[expr]
		unhandled("dor x:(r)-n,[expr]");
		break;
		}
	case 1005: { // dor y:(r)-n,[expr]
		unhandled("dor y:(r)-n,[expr]");
		break;
		}
	case 1006: { // dor x:(r)+n,[expr]
		unhandled("dor x:(r)+n,[expr]");
		break;
		}
	case 1007: { // dor y:(r)+n,[expr]
		unhandled("dor y:(r)+n,[expr]");
		break;
		}
	case 1008: { // dor x:(r)-,[expr]
		unhandled("dor x:(r)-,[expr]");
		break;
		}
	case 1009: { // dor y:(r)-,[expr]
		unhandled("dor y:(r)-,[expr]");
		break;
		}
	case 1010: { // dor x:(r)+,[expr]
		unhandled("dor x:(r)+,[expr]");
		break;
		}
	case 1011: { // dor y:(r)+,[expr]
		unhandled("dor y:(r)+,[expr]");
		break;
		}
	case 1012: { // dor x:(r),[expr]
		unhandled("dor x:(r),[expr]");
		break;
		}
	case 1013: { // dor y:(r),[expr]
		unhandled("dor y:(r),[expr]");
		break;
		}
	case 1014: { // dor x:(r+n),[expr]
		unhandled("dor x:(r+n),[expr]");
		break;
		}
	case 1015: { // dor y:(r+n),[expr]
		unhandled("dor y:(r+n),[expr]");
		break;
		}
	case 1016: { // dor x:-(r),[expr]
		unhandled("dor x:-(r),[expr]");
		break;
		}
	case 1017: { // dor y:-(r),[expr]
		unhandled("dor y:-(r),[expr]");
		break;
		}
	case 1018: { // dor x:[aa],[expr]
		unhandled("dor x:[aa],[expr]");
		break;
		}
	case 1019: { // dor y:[aa],[expr]
		unhandled("dor y:[aa],[expr]");
		break;
		}
	case 1020: { // dor #[i],[expr]
		u32 i = bitswap<12>(opcode, 3, 2, 1, 0, 15, 14, 13, 12, 11, 10, 9, 8);
		u32 expr = (m_pc+exv) & 0xffffff;
		inc_sp();
		set_ssh(get_la());
		set_ssl(get_lc());
		set_lc(i);
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		set_la(expr);
		m_mr |= MR_LF;
		break;
		}
	case 1021: { // dor x0,[expr]
		u32 s = get_x0();
		u32 expr = (m_pc+exv) & 0xffffff;
		inc_sp();
		set_ssh(get_la());
		set_ssl(get_lc());
		set_lc(s);
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		set_la(expr);
		m_mr |= MR_LF;
		break;
		}
	case 1022: { // dor x1,[expr]
		u32 s = get_x1();
		u32 expr = (m_pc+exv) & 0xffffff;
		inc_sp();
		set_ssh(get_la());
		set_ssl(get_lc());
		set_lc(s);
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		set_la(expr);
		m_mr |= MR_LF;
		break;
		}
	case 1023: { // dor y0,[expr]
		u32 s = get_y0();
		u32 expr = (m_pc+exv) & 0xffffff;
		inc_sp();
		set_ssh(get_la());
		set_ssl(get_lc());
		set_lc(s);
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		set_la(expr);
		m_mr |= MR_LF;
		break;
		}
	case 1024: { // dor y1,[expr]
		u32 s = get_y1();
		u32 expr = (m_pc+exv) & 0xffffff;
		inc_sp();
		set_ssh(get_la());
		set_ssl(get_lc());
		set_lc(s);
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		set_la(expr);
		m_mr |= MR_LF;
		break;
		}
	case 1025: { // dor a0,[expr]
		u32 s = get_a0();
		u32 expr = (m_pc+exv) & 0xffffff;
		inc_sp();
		set_ssh(get_la());
		set_ssl(get_lc());
		set_lc(s);
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		set_la(expr);
		m_mr |= MR_LF;
		break;
		}
	case 1026: { // dor b0,[expr]
		u32 s = get_b0();
		u32 expr = (m_pc+exv) & 0xffffff;
		inc_sp();
		set_ssh(get_la());
		set_ssl(get_lc());
		set_lc(s);
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		set_la(expr);
		m_mr |= MR_LF;
		break;
		}
	case 1027: { // dor a2,[expr]
		u32 s = get_a2();
		u32 expr = (m_pc+exv) & 0xffffff;
		inc_sp();
		set_ssh(get_la());
		set_ssl(get_lc());
		set_lc(s);
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		set_la(expr);
		m_mr |= MR_LF;
		break;
		}
	case 1028: { // dor b2,[expr]
		u32 s = get_b2();
		u32 expr = (m_pc+exv) & 0xffffff;
		inc_sp();
		set_ssh(get_la());
		set_ssl(get_lc());
		set_lc(s);
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		set_la(expr);
		m_mr |= MR_LF;
		break;
		}
	case 1029: { // dor a1,[expr]
		u32 s = get_a1();
		u32 expr = (m_pc+exv) & 0xffffff;
		inc_sp();
		set_ssh(get_la());
		set_ssl(get_lc());
		set_lc(s);
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		set_la(expr);
		m_mr |= MR_LF;
		break;
		}
	case 1030: { // dor b1,[expr]
		u32 s = get_b1();
		u32 expr = (m_pc+exv) & 0xffffff;
		inc_sp();
		set_ssh(get_la());
		set_ssl(get_lc());
		set_lc(s);
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		set_la(expr);
		m_mr |= MR_LF;
		break;
		}
	case 1031: { // dor a,[expr]
		u64 s = get_a();
		u32 expr = (m_pc+exv) & 0xffffff;
		inc_sp();
		set_ssh(get_la());
		set_ssl(get_lc());
		set_lc(s);
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		set_la(expr);
		m_mr |= MR_LF;
		break;
		}
	case 1032: { // dor b,[expr]
		u64 s = get_b();
		u32 expr = (m_pc+exv) & 0xffffff;
		inc_sp();
		set_ssh(get_la());
		set_ssl(get_lc());
		set_lc(s);
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		set_la(expr);
		m_mr |= MR_LF;
		break;
		}
	case 1033: { // dor r,[expr]
		u32 s = get_r(BIT(opcode, 8, 6) & 7);
		u32 expr = (m_pc+exv) & 0xffffff;
		inc_sp();
		set_ssh(get_la());
		set_ssl(get_lc());
		set_lc(s);
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		set_la(expr);
		m_mr |= MR_LF;
		break;
		}
	case 1034: { // dor n,[expr]
		u32 s = get_n(BIT(opcode, 8, 6) & 7);
		u32 expr = (m_pc+exv) & 0xffffff;
		inc_sp();
		set_ssh(get_la());
		set_ssl(get_lc());
		set_lc(s);
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		set_la(expr);
		m_mr |= MR_LF;
		break;
		}
	case 1035: { // dor m,[expr]
		u32 s = get_m(BIT(opcode, 8, 6) & 7);
		u32 expr = (m_pc+exv) & 0xffffff;
		inc_sp();
		set_ssh(get_la());
		set_ssl(get_lc());
		set_lc(s);
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		set_la(expr);
		m_mr |= MR_LF;
		break;
		}
	case 1036: { // dor ep,[expr]
		u32 s = get_ep();
		u32 expr = (m_pc+exv) & 0xffffff;
		inc_sp();
		set_ssh(get_la());
		set_ssl(get_lc());
		set_lc(s);
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		set_la(expr);
		m_mr |= MR_LF;
		break;
		}
	case 1037: { // dor vba,[expr]
		u32 s = get_vba();
		u32 expr = (m_pc+exv) & 0xffffff;
		inc_sp();
		set_ssh(get_la());
		set_ssl(get_lc());
		set_lc(s);
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		set_la(expr);
		m_mr |= MR_LF;
		break;
		}
	case 1038: { // dor sc,[expr]
		u32 s = get_sc();
		u32 expr = (m_pc+exv) & 0xffffff;
		inc_sp();
		set_ssh(get_la());
		set_ssl(get_lc());
		set_lc(s);
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		set_la(expr);
		m_mr |= MR_LF;
		break;
		}
	case 1039: { // dor sz,[expr]
		u32 s = get_sz();
		u32 expr = (m_pc+exv) & 0xffffff;
		inc_sp();
		set_ssh(get_la());
		set_ssl(get_lc());
		set_lc(s);
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		set_la(expr);
		m_mr |= MR_LF;
		break;
		}
	case 1040: { // dor sr,[expr]
		u32 s = get_sr();
		u32 expr = (m_pc+exv) & 0xffffff;
		inc_sp();
		set_ssh(get_la());
		set_ssl(get_lc());
		set_lc(s);
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		set_la(expr);
		m_mr |= MR_LF;
		break;
		}
	case 1041: { // dor omr,[expr]
		u32 s = get_omr();
		u32 expr = (m_pc+exv) & 0xffffff;
		inc_sp();
		set_ssh(get_la());
		set_ssl(get_lc());
		set_lc(s);
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		set_la(expr);
		m_mr |= MR_LF;
		break;
		}
	case 1042: { // dor sp,[expr]
		u32 s = get_sp();
		u32 expr = (m_pc+exv) & 0xffffff;
		inc_sp();
		set_ssh(get_la());
		set_ssl(get_lc());
		set_lc(s);
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		set_la(expr);
		m_mr |= MR_LF;
		break;
		}
	case 1043: { // dor ssl,[expr]
		u32 s = get_ssl();
		u32 expr = (m_pc+exv) & 0xffffff;
		inc_sp();
		set_ssh(get_la());
		set_ssl(get_lc());
		set_lc(s);
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		set_la(expr);
		m_mr |= MR_LF;
		break;
		}
	case 1044: { // dor la,[expr]
		u32 s = get_la();
		u32 expr = (m_pc+exv) & 0xffffff;
		inc_sp();
		set_ssh(get_la());
		set_ssl(get_lc());
		set_lc(s);
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		set_la(expr);
		m_mr |= MR_LF;
		break;
		}
	case 1045: { // dor lc,[expr]
		u32 s = get_lc();
		u32 expr = (m_pc+exv) & 0xffffff;
		inc_sp();
		set_ssh(get_la());
		set_ssl(get_lc());
		set_lc(s);
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		set_la(expr);
		m_mr |= MR_LF;
		break;
		}
	case 1046: { // dor forever,[expr]
		u32 expr = (m_pc+exv) & 0xffffff;
		inc_sp();
		set_ssh(get_la());
		set_ssl(get_lc());
		inc_sp();
		set_ssh(m_pc+2);
		set_ssl(get_sr());
		set_la(expr);
		m_mr |= MR_LF;
		m_emr |= EMR_FV;
		break;
		}
	case 1047: { // enddo
		unhandled("enddo");
		break;
		}
	case 1048: { // eor #[i],a
		u32 d_1 = get_a1();
		u32 i = BIT(opcode, 8, 6);
		u32 r = d_1 ^ i;
		m_ccr = m_ccr & ~(CCR_V|CCR_Z|CCR_N);
		if(!r) {
		m_ccr = m_ccr | CCR_Z;
		} else if(BIT(r, 23)) {
		m_ccr = m_ccr | CCR_N;
		}
		set_a1(r);
		break;
		}
	case 1049: { // eor #[i],b
		u32 d_1 = get_b1();
		u32 i = BIT(opcode, 8, 6);
		u32 r = d_1 ^ i;
		m_ccr = m_ccr & ~(CCR_V|CCR_Z|CCR_N);
		if(!r) {
		m_ccr = m_ccr | CCR_Z;
		} else if(BIT(r, 23)) {
		m_ccr = m_ccr | CCR_N;
		}
		set_b1(r);
		break;
		}
	case 1050: { // eor #[i],a
		u32 d_1 = get_a1();
		u32 i = exv;
		u32 r = d_1 ^ i;
		m_ccr = m_ccr & ~(CCR_V|CCR_Z|CCR_N);
		if(!r) {
		m_ccr = m_ccr | CCR_Z;
		} else if(BIT(r, 23)) {
		m_ccr = m_ccr | CCR_N;
		}
		set_a1(r);
		break;
		}
	case 1051: { // eor #[i],b
		u32 d_1 = get_b1();
		u32 i = exv;
		u32 r = d_1 ^ i;
		m_ccr = m_ccr & ~(CCR_V|CCR_Z|CCR_N);
		if(!r) {
		m_ccr = m_ccr | CCR_Z;
		} else if(BIT(r, 23)) {
		m_ccr = m_ccr | CCR_N;
		}
		set_b1(r);
		break;
		}
	case 1052: { // extract a1,a,d
		unhandled("extract a1,a,d");
		break;
		}
	case 1053: { // extract a1,b,d
		unhandled("extract a1,b,d");
		break;
		}
	case 1054: { // extract b1,a,d
		unhandled("extract b1,a,d");
		break;
		}
	case 1055: { // extract b1,b,d
		unhandled("extract b1,b,d");
		break;
		}
	case 1056: { // extract x0,a,d
		unhandled("extract x0,a,d");
		break;
		}
	case 1057: { // extract x0,b,d
		unhandled("extract x0,b,d");
		break;
		}
	case 1058: { // extract y0,a,d
		unhandled("extract y0,a,d");
		break;
		}
	case 1059: { // extract y0,b,d
		unhandled("extract y0,b,d");
		break;
		}
	case 1060: { // extract x1,a,d
		unhandled("extract x1,a,d");
		break;
		}
	case 1061: { // extract x1,b,d
		unhandled("extract x1,b,d");
		break;
		}
	case 1062: { // extract y1,a,d
		unhandled("extract y1,a,d");
		break;
		}
	case 1063: { // extract y1,b,d
		unhandled("extract y1,b,d");
		break;
		}
	case 1064: { // extract #[co],a,a
		unhandled("extract #[co],a,a");
		break;
		}
	case 1065: { // extract #[co],a,b
		unhandled("extract #[co],a,b");
		break;
		}
	case 1066: { // extract #[co],b,a
		unhandled("extract #[co],b,a");
		break;
		}
	case 1067: { // extract #[co],b,b
		unhandled("extract #[co],b,b");
		break;
		}
	case 1068: { // extractu a1,a,d
		unhandled("extractu a1,a,d");
		break;
		}
	case 1069: { // extractu a1,b,d
		unhandled("extractu a1,b,d");
		break;
		}
	case 1070: { // extractu b1,a,d
		unhandled("extractu b1,a,d");
		break;
		}
	case 1071: { // extractu b1,b,d
		unhandled("extractu b1,b,d");
		break;
		}
	case 1072: { // extractu x0,a,d
		unhandled("extractu x0,a,d");
		break;
		}
	case 1073: { // extractu x0,b,d
		unhandled("extractu x0,b,d");
		break;
		}
	case 1074: { // extractu y0,a,d
		unhandled("extractu y0,a,d");
		break;
		}
	case 1075: { // extractu y0,b,d
		unhandled("extractu y0,b,d");
		break;
		}
	case 1076: { // extractu x1,a,d
		unhandled("extractu x1,a,d");
		break;
		}
	case 1077: { // extractu x1,b,d
		unhandled("extractu x1,b,d");
		break;
		}
	case 1078: { // extractu y1,a,d
		unhandled("extractu y1,a,d");
		break;
		}
	case 1079: { // extractu y1,b,d
		unhandled("extractu y1,b,d");
		break;
		}
	case 1080: { // extractu #[co],a,a
		unhandled("extractu #[co],a,a");
		break;
		}
	case 1081: { // extractu #[co],a,b
		unhandled("extractu #[co],a,b");
		break;
		}
	case 1082: { // extractu #[co],b,a
		unhandled("extractu #[co],b,a");
		break;
		}
	case 1083: { // extractu #[co],b,b
		unhandled("extractu #[co],b,b");
		break;
		}
	case 1084: { // illegal
		unhandled("illegal");
		break;
		}
	case 1085: { // inc a
		unhandled("inc a");
		break;
		}
	case 1086: { // inc b
		unhandled("inc b");
		break;
		}
	case 1087: { // insert a1,a0,d
		unhandled("insert a1,a0,d");
		break;
		}
	case 1088: { // insert a1,b0,d
		unhandled("insert a1,b0,d");
		break;
		}
	case 1089: { // insert a1,x0,d
		unhandled("insert a1,x0,d");
		break;
		}
	case 1090: { // insert a1,y0,d
		unhandled("insert a1,y0,d");
		break;
		}
	case 1091: { // insert a1,x1,d
		unhandled("insert a1,x1,d");
		break;
		}
	case 1092: { // insert a1,y1,d
		unhandled("insert a1,y1,d");
		break;
		}
	case 1093: { // insert b1,a0,d
		unhandled("insert b1,a0,d");
		break;
		}
	case 1094: { // insert b1,b0,d
		unhandled("insert b1,b0,d");
		break;
		}
	case 1095: { // insert b1,x0,d
		unhandled("insert b1,x0,d");
		break;
		}
	case 1096: { // insert b1,y0,d
		unhandled("insert b1,y0,d");
		break;
		}
	case 1097: { // insert b1,x1,d
		unhandled("insert b1,x1,d");
		break;
		}
	case 1098: { // insert b1,y1,d
		unhandled("insert b1,y1,d");
		break;
		}
	case 1099: { // insert x0,a0,d
		unhandled("insert x0,a0,d");
		break;
		}
	case 1100: { // insert x0,b0,d
		unhandled("insert x0,b0,d");
		break;
		}
	case 1101: { // insert x0,x0,d
		unhandled("insert x0,x0,d");
		break;
		}
	case 1102: { // insert x0,y0,d
		unhandled("insert x0,y0,d");
		break;
		}
	case 1103: { // insert x0,x1,d
		unhandled("insert x0,x1,d");
		break;
		}
	case 1104: { // insert x0,y1,d
		unhandled("insert x0,y1,d");
		break;
		}
	case 1105: { // insert y0,a0,d
		unhandled("insert y0,a0,d");
		break;
		}
	case 1106: { // insert y0,b0,d
		unhandled("insert y0,b0,d");
		break;
		}
	case 1107: { // insert y0,x0,d
		unhandled("insert y0,x0,d");
		break;
		}
	case 1108: { // insert y0,y0,d
		unhandled("insert y0,y0,d");
		break;
		}
	case 1109: { // insert y0,x1,d
		unhandled("insert y0,x1,d");
		break;
		}
	case 1110: { // insert y0,y1,d
		unhandled("insert y0,y1,d");
		break;
		}
	case 1111: { // insert x1,a0,d
		unhandled("insert x1,a0,d");
		break;
		}
	case 1112: { // insert x1,b0,d
		unhandled("insert x1,b0,d");
		break;
		}
	case 1113: { // insert x1,x0,d
		unhandled("insert x1,x0,d");
		break;
		}
	case 1114: { // insert x1,y0,d
		unhandled("insert x1,y0,d");
		break;
		}
	case 1115: { // insert x1,x1,d
		unhandled("insert x1,x1,d");
		break;
		}
	case 1116: { // insert x1,y1,d
		unhandled("insert x1,y1,d");
		break;
		}
	case 1117: { // insert y1,a0,d
		unhandled("insert y1,a0,d");
		break;
		}
	case 1118: { // insert y1,b0,d
		unhandled("insert y1,b0,d");
		break;
		}
	case 1119: { // insert y1,x0,d
		unhandled("insert y1,x0,d");
		break;
		}
	case 1120: { // insert y1,y0,d
		unhandled("insert y1,y0,d");
		break;
		}
	case 1121: { // insert y1,x1,d
		unhandled("insert y1,x1,d");
		break;
		}
	case 1122: { // insert y1,y1,d
		unhandled("insert y1,y1,d");
		break;
		}
	case 1123: { // insert #[co],a0,a
		unhandled("insert #[co],a0,a");
		break;
		}
	case 1124: { // insert #[co],a0,b
		unhandled("insert #[co],a0,b");
		break;
		}
	case 1125: { // insert #[co],b0,a
		unhandled("insert #[co],b0,a");
		break;
		}
	case 1126: { // insert #[co],b0,b
		unhandled("insert #[co],b0,b");
		break;
		}
	case 1127: { // insert #[co],x0,a
		unhandled("insert #[co],x0,a");
		break;
		}
	case 1128: { // insert #[co],x0,b
		unhandled("insert #[co],x0,b");
		break;
		}
	case 1129: { // insert #[co],y0,a
		unhandled("insert #[co],y0,a");
		break;
		}
	case 1130: { // insert #[co],y0,b
		unhandled("insert #[co],y0,b");
		break;
		}
	case 1131: { // insert #[co],x1,a
		unhandled("insert #[co],x1,a");
		break;
		}
	case 1132: { // insert #[co],x1,b
		unhandled("insert #[co],x1,b");
		break;
		}
	case 1133: { // insert #[co],y1,a
		unhandled("insert #[co],y1,a");
		break;
		}
	case 1134: { // insert #[co],y1,b
		unhandled("insert #[co],y1,b");
		break;
		}
	case 1135: { // jcc [x]
		bool cc = test_cc();
		u32 x = BIT(opcode, 0, 12);
		if(cc) {
		m_npc = x;
		}
		break;
		}
	case 1136: { // jge [x]
		bool cc = test_ge();
		u32 x = BIT(opcode, 0, 12);
		if(cc) {
		m_npc = x;
		}
		break;
		}
	case 1137: { // jne [x]
		bool cc = test_ne();
		u32 x = BIT(opcode, 0, 12);
		if(cc) {
		m_npc = x;
		}
		break;
		}
	case 1138: { // jpl [x]
		bool cc = test_pl();
		u32 x = BIT(opcode, 0, 12);
		if(cc) {
		m_npc = x;
		}
		break;
		}
	case 1139: { // jnn [x]
		bool cc = test_nn();
		u32 x = BIT(opcode, 0, 12);
		if(cc) {
		m_npc = x;
		}
		break;
		}
	case 1140: { // jec [x]
		bool cc = test_ec();
		u32 x = BIT(opcode, 0, 12);
		if(cc) {
		m_npc = x;
		}
		break;
		}
	case 1141: { // jlc [x]
		u32 cc = get_lc();
		u32 x = BIT(opcode, 0, 12);
		if(cc) {
		m_npc = x;
		}
		break;
		}
	case 1142: { // jgt [x]
		bool cc = test_gt();
		u32 x = BIT(opcode, 0, 12);
		if(cc) {
		m_npc = x;
		}
		break;
		}
	case 1143: { // jcs [x]
		bool cc = test_cs();
		u32 x = BIT(opcode, 0, 12);
		if(cc) {
		m_npc = x;
		}
		break;
		}
	case 1144: { // jlt [x]
		bool cc = test_lt();
		u32 x = BIT(opcode, 0, 12);
		if(cc) {
		m_npc = x;
		}
		break;
		}
	case 1145: { // jeq [x]
		bool cc = test_eq();
		u32 x = BIT(opcode, 0, 12);
		if(cc) {
		m_npc = x;
		}
		break;
		}
	case 1146: { // jmi [x]
		bool cc = test_mi();
		u32 x = BIT(opcode, 0, 12);
		if(cc) {
		m_npc = x;
		}
		break;
		}
	case 1147: { // jnr [x]
		bool cc = test_nr();
		u32 x = BIT(opcode, 0, 12);
		if(cc) {
		m_npc = x;
		}
		break;
		}
	case 1148: { // jes [x]
		bool cc = test_es();
		u32 x = BIT(opcode, 0, 12);
		if(cc) {
		m_npc = x;
		}
		break;
		}
	case 1149: { // jls [x]
		bool cc = test_ls();
		u32 x = BIT(opcode, 0, 12);
		if(cc) {
		m_npc = x;
		}
		break;
		}
	case 1150: { // jle [x]
		bool cc = test_le();
		u32 x = BIT(opcode, 0, 12);
		if(cc) {
		m_npc = x;
		}
		break;
		}
	case 1151: { // jcc (r)-n
		bool cc = test_cc();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1152: { // jge (r)-n
		bool cc = test_ge();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1153: { // jne (r)-n
		bool cc = test_ne();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1154: { // jpl (r)-n
		bool cc = test_pl();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1155: { // jnn (r)-n
		bool cc = test_nn();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1156: { // jec (r)-n
		bool cc = test_ec();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1157: { // jlc (r)-n
		u32 cc = get_lc();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1158: { // jgt (r)-n
		bool cc = test_gt();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1159: { // jcs (r)-n
		bool cc = test_cs();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1160: { // jlt (r)-n
		bool cc = test_lt();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1161: { // jeq (r)-n
		bool cc = test_eq();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1162: { // jmi (r)-n
		bool cc = test_mi();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1163: { // jnr (r)-n
		bool cc = test_nr();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1164: { // jes (r)-n
		bool cc = test_es();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1165: { // jls (r)-n
		bool cc = test_ls();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1166: { // jle (r)-n
		bool cc = test_le();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1167: { // jcc (r)+n
		bool cc = test_cc();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1168: { // jge (r)+n
		bool cc = test_ge();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1169: { // jne (r)+n
		bool cc = test_ne();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1170: { // jpl (r)+n
		bool cc = test_pl();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1171: { // jnn (r)+n
		bool cc = test_nn();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1172: { // jec (r)+n
		bool cc = test_ec();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1173: { // jlc (r)+n
		u32 cc = get_lc();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1174: { // jgt (r)+n
		bool cc = test_gt();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1175: { // jcs (r)+n
		bool cc = test_cs();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1176: { // jlt (r)+n
		bool cc = test_lt();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1177: { // jeq (r)+n
		bool cc = test_eq();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1178: { // jmi (r)+n
		bool cc = test_mi();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1179: { // jnr (r)+n
		bool cc = test_nr();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1180: { // jes (r)+n
		bool cc = test_es();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1181: { // jls (r)+n
		bool cc = test_ls();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1182: { // jle (r)+n
		bool cc = test_le();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1183: { // jcc (r)-
		bool cc = test_cc();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1184: { // jge (r)-
		bool cc = test_ge();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1185: { // jne (r)-
		bool cc = test_ne();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1186: { // jpl (r)-
		bool cc = test_pl();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1187: { // jnn (r)-
		bool cc = test_nn();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1188: { // jec (r)-
		bool cc = test_ec();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1189: { // jlc (r)-
		u32 cc = get_lc();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1190: { // jgt (r)-
		bool cc = test_gt();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1191: { // jcs (r)-
		bool cc = test_cs();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1192: { // jlt (r)-
		bool cc = test_lt();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1193: { // jeq (r)-
		bool cc = test_eq();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1194: { // jmi (r)-
		bool cc = test_mi();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1195: { // jnr (r)-
		bool cc = test_nr();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1196: { // jes (r)-
		bool cc = test_es();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1197: { // jls (r)-
		bool cc = test_ls();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1198: { // jle (r)-
		bool cc = test_le();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1199: { // jcc (r)+
		bool cc = test_cc();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1200: { // jge (r)+
		bool cc = test_ge();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1201: { // jne (r)+
		bool cc = test_ne();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1202: { // jpl (r)+
		bool cc = test_pl();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1203: { // jnn (r)+
		bool cc = test_nn();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1204: { // jec (r)+
		bool cc = test_ec();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1205: { // jlc (r)+
		u32 cc = get_lc();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1206: { // jgt (r)+
		bool cc = test_gt();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1207: { // jcs (r)+
		bool cc = test_cs();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1208: { // jlt (r)+
		bool cc = test_lt();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1209: { // jeq (r)+
		bool cc = test_eq();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1210: { // jmi (r)+
		bool cc = test_mi();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1211: { // jnr (r)+
		bool cc = test_nr();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1212: { // jes (r)+
		bool cc = test_es();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1213: { // jls (r)+
		bool cc = test_ls();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1214: { // jle (r)+
		bool cc = test_le();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1215: { // jcc (r)
		bool cc = test_cc();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1216: { // jge (r)
		bool cc = test_ge();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1217: { // jne (r)
		bool cc = test_ne();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1218: { // jpl (r)
		bool cc = test_pl();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1219: { // jnn (r)
		bool cc = test_nn();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1220: { // jec (r)
		bool cc = test_ec();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1221: { // jlc (r)
		u32 cc = get_lc();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1222: { // jgt (r)
		bool cc = test_gt();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1223: { // jcs (r)
		bool cc = test_cs();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1224: { // jlt (r)
		bool cc = test_lt();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1225: { // jeq (r)
		bool cc = test_eq();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1226: { // jmi (r)
		bool cc = test_mi();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1227: { // jnr (r)
		bool cc = test_nr();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1228: { // jes (r)
		bool cc = test_es();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1229: { // jls (r)
		bool cc = test_ls();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1230: { // jle (r)
		bool cc = test_le();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1231: { // jcc (r+n)
		bool cc = test_cc();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1232: { // jge (r+n)
		bool cc = test_ge();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1233: { // jne (r+n)
		bool cc = test_ne();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1234: { // jpl (r+n)
		bool cc = test_pl();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1235: { // jnn (r+n)
		bool cc = test_nn();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1236: { // jec (r+n)
		bool cc = test_ec();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1237: { // jlc (r+n)
		u32 cc = get_lc();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1238: { // jgt (r+n)
		bool cc = test_gt();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1239: { // jcs (r+n)
		bool cc = test_cs();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1240: { // jlt (r+n)
		bool cc = test_lt();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1241: { // jeq (r+n)
		bool cc = test_eq();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1242: { // jmi (r+n)
		bool cc = test_mi();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1243: { // jnr (r+n)
		bool cc = test_nr();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1244: { // jes (r+n)
		bool cc = test_es();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1245: { // jls (r+n)
		bool cc = test_ls();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1246: { // jle (r+n)
		bool cc = test_le();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1247: { // jcc -(r)
		bool cc = test_cc();
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1248: { // jge -(r)
		bool cc = test_ge();
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1249: { // jne -(r)
		bool cc = test_ne();
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1250: { // jpl -(r)
		bool cc = test_pl();
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1251: { // jnn -(r)
		bool cc = test_nn();
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1252: { // jec -(r)
		bool cc = test_ec();
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1253: { // jlc -(r)
		u32 cc = get_lc();
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1254: { // jgt -(r)
		bool cc = test_gt();
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1255: { // jcs -(r)
		bool cc = test_cs();
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1256: { // jlt -(r)
		bool cc = test_lt();
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1257: { // jeq -(r)
		bool cc = test_eq();
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1258: { // jmi -(r)
		bool cc = test_mi();
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1259: { // jnr -(r)
		bool cc = test_nr();
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1260: { // jes -(r)
		bool cc = test_es();
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1261: { // jls -(r)
		bool cc = test_ls();
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1262: { // jle -(r)
		bool cc = test_le();
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		if(cc) {
		m_npc = ea;
		}
		break;
		}
	case 1263: { // jcc [abs]
		bool cc = test_cc();
		u32 abs = exv;
		if(cc) {
		m_npc = abs;
		}
		break;
		}
	case 1264: { // jge [abs]
		bool cc = test_ge();
		u32 abs = exv;
		if(cc) {
		m_npc = abs;
		}
		break;
		}
	case 1265: { // jne [abs]
		bool cc = test_ne();
		u32 abs = exv;
		if(cc) {
		m_npc = abs;
		}
		break;
		}
	case 1266: { // jpl [abs]
		bool cc = test_pl();
		u32 abs = exv;
		if(cc) {
		m_npc = abs;
		}
		break;
		}
	case 1267: { // jnn [abs]
		bool cc = test_nn();
		u32 abs = exv;
		if(cc) {
		m_npc = abs;
		}
		break;
		}
	case 1268: { // jec [abs]
		bool cc = test_ec();
		u32 abs = exv;
		if(cc) {
		m_npc = abs;
		}
		break;
		}
	case 1269: { // jlc [abs]
		u32 cc = get_lc();
		u32 abs = exv;
		if(cc) {
		m_npc = abs;
		}
		break;
		}
	case 1270: { // jgt [abs]
		bool cc = test_gt();
		u32 abs = exv;
		if(cc) {
		m_npc = abs;
		}
		break;
		}
	case 1271: { // jcs [abs]
		bool cc = test_cs();
		u32 abs = exv;
		if(cc) {
		m_npc = abs;
		}
		break;
		}
	case 1272: { // jlt [abs]
		bool cc = test_lt();
		u32 abs = exv;
		if(cc) {
		m_npc = abs;
		}
		break;
		}
	case 1273: { // jeq [abs]
		bool cc = test_eq();
		u32 abs = exv;
		if(cc) {
		m_npc = abs;
		}
		break;
		}
	case 1274: { // jmi [abs]
		bool cc = test_mi();
		u32 abs = exv;
		if(cc) {
		m_npc = abs;
		}
		break;
		}
	case 1275: { // jnr [abs]
		bool cc = test_nr();
		u32 abs = exv;
		if(cc) {
		m_npc = abs;
		}
		break;
		}
	case 1276: { // jes [abs]
		bool cc = test_es();
		u32 abs = exv;
		if(cc) {
		m_npc = abs;
		}
		break;
		}
	case 1277: { // jls [abs]
		bool cc = test_ls();
		u32 abs = exv;
		if(cc) {
		m_npc = abs;
		}
		break;
		}
	case 1278: { // jle [abs]
		bool cc = test_le();
		u32 abs = exv;
		if(cc) {
		m_npc = abs;
		}
		break;
		}
	case 1279: { // jclr #[n],x:(r)-n,[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(m_x.read_dword(ea), n))
		m_npc = x;
		break;
		}
	case 1280: { // jclr #[n],y:(r)-n,[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(m_y.read_dword(ea), n))
		m_npc = x;
		break;
		}
	case 1281: { // jclr #[n],x:(r)+n,[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(m_x.read_dword(ea), n))
		m_npc = x;
		break;
		}
	case 1282: { // jclr #[n],y:(r)+n,[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(m_y.read_dword(ea), n))
		m_npc = x;
		break;
		}
	case 1283: { // jclr #[n],x:(r)-,[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(m_x.read_dword(ea), n))
		m_npc = x;
		break;
		}
	case 1284: { // jclr #[n],y:(r)-,[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(m_y.read_dword(ea), n))
		m_npc = x;
		break;
		}
	case 1285: { // jclr #[n],x:(r)+,[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(m_x.read_dword(ea), n))
		m_npc = x;
		break;
		}
	case 1286: { // jclr #[n],y:(r)+,[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(m_y.read_dword(ea), n))
		m_npc = x;
		break;
		}
	case 1287: { // jclr #[n],x:(r),[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(m_x.read_dword(ea), n))
		m_npc = x;
		break;
		}
	case 1288: { // jclr #[n],y:(r),[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(m_y.read_dword(ea), n))
		m_npc = x;
		break;
		}
	case 1289: { // jclr #[n],x:(r+n),[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(m_x.read_dword(ea), n))
		m_npc = x;
		break;
		}
	case 1290: { // jclr #[n],y:(r+n),[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(m_y.read_dword(ea), n))
		m_npc = x;
		break;
		}
	case 1291: { // jclr #[n],x:-(r),[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(m_x.read_dword(ea), n))
		m_npc = x;
		break;
		}
	case 1292: { // jclr #[n],y:-(r),[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(m_y.read_dword(ea), n))
		m_npc = x;
		break;
		}
	case 1293: { // jclr #[n],x:[aa],[x]
		u32 aa = BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(m_x.read_dword(aa), n))
		m_npc = x;
		break;
		}
	case 1294: { // jclr #[n],y:[aa],[x]
		u32 aa = BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(m_y.read_dword(aa), n))
		m_npc = x;
		break;
		}
	case 1295: { // jclr #[n],x:[pp],[x]
		u32 pp = 0xffffc0 + BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(m_x.read_dword(pp), n))
		m_npc = x;
		break;
		}
	case 1296: { // jclr #[n],y:[pp],[x]
		u32 pp = 0xffffc0 + BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(m_y.read_dword(pp), n))
		m_npc = x;
		break;
		}
	case 1297: { // jclr #[n],x:[qq],[x]
		u32 qq = 0xffff80 + BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(m_x.read_dword(qq), n))
		m_npc = x;
		break;
		}
	case 1298: { // jclr #[n],y:[qq],[x]
		u32 qq = 0xffff80 + BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(m_y.read_dword(qq), n))
		m_npc = x;
		break;
		}
	case 1299: { // jclr #[n],x0,[x]
		u32 s = get_x0();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(s, n))
		m_npc = x;
		break;
		}
	case 1300: { // jclr #[n],x1,[x]
		u32 s = get_x1();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(s, n))
		m_npc = x;
		break;
		}
	case 1301: { // jclr #[n],y0,[x]
		u32 s = get_y0();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(s, n))
		m_npc = x;
		break;
		}
	case 1302: { // jclr #[n],y1,[x]
		u32 s = get_y1();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(s, n))
		m_npc = x;
		break;
		}
	case 1303: { // jclr #[n],a0,[x]
		u32 s = get_a0();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(s, n))
		m_npc = x;
		break;
		}
	case 1304: { // jclr #[n],b0,[x]
		u32 s = get_b0();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(s, n))
		m_npc = x;
		break;
		}
	case 1305: { // jclr #[n],a2,[x]
		u32 s = get_a2();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(s, n))
		m_npc = x;
		break;
		}
	case 1306: { // jclr #[n],b2,[x]
		u32 s = get_b2();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(s, n))
		m_npc = x;
		break;
		}
	case 1307: { // jclr #[n],a1,[x]
		u32 s = get_a1();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(s, n))
		m_npc = x;
		break;
		}
	case 1308: { // jclr #[n],b1,[x]
		u32 s = get_b1();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(s, n))
		m_npc = x;
		break;
		}
	case 1309: { // jclr #[n],a,[x]
		u32 s_h = get_ah();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(s_h, n))
		m_npc = x;
		break;
		}
	case 1310: { // jclr #[n],b,[x]
		u32 s_h = get_bh();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(s_h, n))
		m_npc = x;
		break;
		}
	case 1311: { // jclr #[n],r,[x]
		u32 s = get_r(BIT(opcode, 8, 6) & 7);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(s, n))
		m_npc = x;
		break;
		}
	case 1312: { // jclr #[n],n,[x]
		u32 s = get_n(BIT(opcode, 8, 6) & 7);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(s, n))
		m_npc = x;
		break;
		}
	case 1313: { // jclr #[n],m,[x]
		u32 s = get_m(BIT(opcode, 8, 6) & 7);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(s, n))
		m_npc = x;
		break;
		}
	case 1314: { // jclr #[n],ep,[x]
		u32 s = get_ep();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(s, n))
		m_npc = x;
		break;
		}
	case 1315: { // jclr #[n],vba,[x]
		u32 s = get_vba();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(s, n))
		m_npc = x;
		break;
		}
	case 1316: { // jclr #[n],sc,[x]
		u32 s = get_sc();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(s, n))
		m_npc = x;
		break;
		}
	case 1317: { // jclr #[n],sz,[x]
		u32 s = get_sz();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(s, n))
		m_npc = x;
		break;
		}
	case 1318: { // jclr #[n],sr,[x]
		u32 s = get_sr();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(s, n))
		m_npc = x;
		break;
		}
	case 1319: { // jclr #[n],omr,[x]
		u32 s = get_omr();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(s, n))
		m_npc = x;
		break;
		}
	case 1320: { // jclr #[n],sp,[x]
		u32 s = get_sp();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(s, n))
		m_npc = x;
		break;
		}
	case 1321: { // jclr #[n],ssh,[x]
		u32 s = get_ssh();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(s, n))
		m_npc = x;
		break;
		}
	case 1322: { // jclr #[n],ssl,[x]
		u32 s = get_ssl();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(s, n))
		m_npc = x;
		break;
		}
	case 1323: { // jclr #[n],la,[x]
		u32 s = get_la();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(s, n))
		m_npc = x;
		break;
		}
	case 1324: { // jclr #[n],lc,[x]
		u32 s = get_lc();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(s, n))
		m_npc = x;
		break;
		}
	case 1325: { // jmp (r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		m_npc = ea;
		break;
		}
	case 1326: { // jmp (r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		m_npc = ea;
		break;
		}
	case 1327: { // jmp (r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		m_npc = ea;
		break;
		}
	case 1328: { // jmp (r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		m_npc = ea;
		break;
		}
	case 1329: { // jmp (r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		m_npc = ea;
		break;
		}
	case 1330: { // jmp (r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		m_npc = ea;
		break;
		}
	case 1331: { // jmp -(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		m_npc = ea;
		break;
		}
	case 1332: { // jmp [abs]
		u32 abs = exv;
		m_npc = abs;
		break;
		}
	case 1333: { // jmp [x]
		u32 x = BIT(opcode, 0, 12);
		m_npc = x;
		break;
		}
	case 1334: { // jscc [x]
		bool cc = test_cc();
		u32 x = BIT(opcode, 0, 12);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1335: { // jsge [x]
		bool cc = test_ge();
		u32 x = BIT(opcode, 0, 12);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1336: { // jsne [x]
		bool cc = test_ne();
		u32 x = BIT(opcode, 0, 12);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1337: { // jspl [x]
		bool cc = test_pl();
		u32 x = BIT(opcode, 0, 12);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1338: { // jsnn [x]
		bool cc = test_nn();
		u32 x = BIT(opcode, 0, 12);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1339: { // jsec [x]
		bool cc = test_ec();
		u32 x = BIT(opcode, 0, 12);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1340: { // jslc [x]
		u32 cc = get_lc();
		u32 x = BIT(opcode, 0, 12);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1341: { // jsgt [x]
		bool cc = test_gt();
		u32 x = BIT(opcode, 0, 12);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1342: { // jscs [x]
		bool cc = test_cs();
		u32 x = BIT(opcode, 0, 12);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1343: { // jslt [x]
		bool cc = test_lt();
		u32 x = BIT(opcode, 0, 12);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1344: { // jseq [x]
		bool cc = test_eq();
		u32 x = BIT(opcode, 0, 12);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1345: { // jsmi [x]
		bool cc = test_mi();
		u32 x = BIT(opcode, 0, 12);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1346: { // jsnr [x]
		bool cc = test_nr();
		u32 x = BIT(opcode, 0, 12);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1347: { // jses [x]
		bool cc = test_es();
		u32 x = BIT(opcode, 0, 12);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1348: { // jsls [x]
		bool cc = test_ls();
		u32 x = BIT(opcode, 0, 12);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1349: { // jsle [x]
		bool cc = test_le();
		u32 x = BIT(opcode, 0, 12);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1350: { // jscc (r)-n
		bool cc = test_cc();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1351: { // jsge (r)-n
		bool cc = test_ge();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1352: { // jsne (r)-n
		bool cc = test_ne();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1353: { // jspl (r)-n
		bool cc = test_pl();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1354: { // jsnn (r)-n
		bool cc = test_nn();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1355: { // jsec (r)-n
		bool cc = test_ec();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1356: { // jslc (r)-n
		u32 cc = get_lc();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1357: { // jsgt (r)-n
		bool cc = test_gt();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1358: { // jscs (r)-n
		bool cc = test_cs();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1359: { // jslt (r)-n
		bool cc = test_lt();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1360: { // jseq (r)-n
		bool cc = test_eq();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1361: { // jsmi (r)-n
		bool cc = test_mi();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1362: { // jsnr (r)-n
		bool cc = test_nr();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1363: { // jses (r)-n
		bool cc = test_es();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1364: { // jsls (r)-n
		bool cc = test_ls();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1365: { // jsle (r)-n
		bool cc = test_le();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1366: { // jscc (r)+n
		bool cc = test_cc();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1367: { // jsge (r)+n
		bool cc = test_ge();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1368: { // jsne (r)+n
		bool cc = test_ne();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1369: { // jspl (r)+n
		bool cc = test_pl();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1370: { // jsnn (r)+n
		bool cc = test_nn();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1371: { // jsec (r)+n
		bool cc = test_ec();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1372: { // jslc (r)+n
		u32 cc = get_lc();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1373: { // jsgt (r)+n
		bool cc = test_gt();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1374: { // jscs (r)+n
		bool cc = test_cs();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1375: { // jslt (r)+n
		bool cc = test_lt();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1376: { // jseq (r)+n
		bool cc = test_eq();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1377: { // jsmi (r)+n
		bool cc = test_mi();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1378: { // jsnr (r)+n
		bool cc = test_nr();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1379: { // jses (r)+n
		bool cc = test_es();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1380: { // jsls (r)+n
		bool cc = test_ls();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1381: { // jsle (r)+n
		bool cc = test_le();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1382: { // jscc (r)-
		bool cc = test_cc();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1383: { // jsge (r)-
		bool cc = test_ge();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1384: { // jsne (r)-
		bool cc = test_ne();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1385: { // jspl (r)-
		bool cc = test_pl();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1386: { // jsnn (r)-
		bool cc = test_nn();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1387: { // jsec (r)-
		bool cc = test_ec();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1388: { // jslc (r)-
		u32 cc = get_lc();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1389: { // jsgt (r)-
		bool cc = test_gt();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1390: { // jscs (r)-
		bool cc = test_cs();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1391: { // jslt (r)-
		bool cc = test_lt();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1392: { // jseq (r)-
		bool cc = test_eq();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1393: { // jsmi (r)-
		bool cc = test_mi();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1394: { // jsnr (r)-
		bool cc = test_nr();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1395: { // jses (r)-
		bool cc = test_es();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1396: { // jsls (r)-
		bool cc = test_ls();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1397: { // jsle (r)-
		bool cc = test_le();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1398: { // jscc (r)+
		bool cc = test_cc();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1399: { // jsge (r)+
		bool cc = test_ge();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1400: { // jsne (r)+
		bool cc = test_ne();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1401: { // jspl (r)+
		bool cc = test_pl();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1402: { // jsnn (r)+
		bool cc = test_nn();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1403: { // jsec (r)+
		bool cc = test_ec();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1404: { // jslc (r)+
		u32 cc = get_lc();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1405: { // jsgt (r)+
		bool cc = test_gt();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1406: { // jscs (r)+
		bool cc = test_cs();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1407: { // jslt (r)+
		bool cc = test_lt();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1408: { // jseq (r)+
		bool cc = test_eq();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1409: { // jsmi (r)+
		bool cc = test_mi();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1410: { // jsnr (r)+
		bool cc = test_nr();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1411: { // jses (r)+
		bool cc = test_es();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1412: { // jsls (r)+
		bool cc = test_ls();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1413: { // jsle (r)+
		bool cc = test_le();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1414: { // jscc (r)
		bool cc = test_cc();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1415: { // jsge (r)
		bool cc = test_ge();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1416: { // jsne (r)
		bool cc = test_ne();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1417: { // jspl (r)
		bool cc = test_pl();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1418: { // jsnn (r)
		bool cc = test_nn();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1419: { // jsec (r)
		bool cc = test_ec();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1420: { // jslc (r)
		u32 cc = get_lc();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1421: { // jsgt (r)
		bool cc = test_gt();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1422: { // jscs (r)
		bool cc = test_cs();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1423: { // jslt (r)
		bool cc = test_lt();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1424: { // jseq (r)
		bool cc = test_eq();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1425: { // jsmi (r)
		bool cc = test_mi();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1426: { // jsnr (r)
		bool cc = test_nr();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1427: { // jses (r)
		bool cc = test_es();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1428: { // jsls (r)
		bool cc = test_ls();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1429: { // jsle (r)
		bool cc = test_le();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1430: { // jscc (r+n)
		bool cc = test_cc();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1431: { // jsge (r+n)
		bool cc = test_ge();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1432: { // jsne (r+n)
		bool cc = test_ne();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1433: { // jspl (r+n)
		bool cc = test_pl();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1434: { // jsnn (r+n)
		bool cc = test_nn();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1435: { // jsec (r+n)
		bool cc = test_ec();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1436: { // jslc (r+n)
		u32 cc = get_lc();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1437: { // jsgt (r+n)
		bool cc = test_gt();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1438: { // jscs (r+n)
		bool cc = test_cs();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1439: { // jslt (r+n)
		bool cc = test_lt();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1440: { // jseq (r+n)
		bool cc = test_eq();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1441: { // jsmi (r+n)
		bool cc = test_mi();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1442: { // jsnr (r+n)
		bool cc = test_nr();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1443: { // jses (r+n)
		bool cc = test_es();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1444: { // jsls (r+n)
		bool cc = test_ls();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1445: { // jsle (r+n)
		bool cc = test_le();
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1446: { // jscc -(r)
		bool cc = test_cc();
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1447: { // jsge -(r)
		bool cc = test_ge();
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1448: { // jsne -(r)
		bool cc = test_ne();
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1449: { // jspl -(r)
		bool cc = test_pl();
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1450: { // jsnn -(r)
		bool cc = test_nn();
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1451: { // jsec -(r)
		bool cc = test_ec();
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1452: { // jslc -(r)
		u32 cc = get_lc();
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1453: { // jsgt -(r)
		bool cc = test_gt();
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1454: { // jscs -(r)
		bool cc = test_cs();
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1455: { // jslt -(r)
		bool cc = test_lt();
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1456: { // jseq -(r)
		bool cc = test_eq();
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1457: { // jsmi -(r)
		bool cc = test_mi();
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1458: { // jsnr -(r)
		bool cc = test_nr();
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1459: { // jses -(r)
		bool cc = test_es();
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1460: { // jsls -(r)
		bool cc = test_ls();
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1461: { // jsle -(r)
		bool cc = test_le();
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		}
		break;
		}
	case 1462: { // jscc [abs]
		bool cc = test_cc();
		u32 abs = exv;
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = abs;
		}
		break;
		}
	case 1463: { // jsge [abs]
		bool cc = test_ge();
		u32 abs = exv;
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = abs;
		}
		break;
		}
	case 1464: { // jsne [abs]
		bool cc = test_ne();
		u32 abs = exv;
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = abs;
		}
		break;
		}
	case 1465: { // jspl [abs]
		bool cc = test_pl();
		u32 abs = exv;
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = abs;
		}
		break;
		}
	case 1466: { // jsnn [abs]
		bool cc = test_nn();
		u32 abs = exv;
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = abs;
		}
		break;
		}
	case 1467: { // jsec [abs]
		bool cc = test_ec();
		u32 abs = exv;
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = abs;
		}
		break;
		}
	case 1468: { // jslc [abs]
		u32 cc = get_lc();
		u32 abs = exv;
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = abs;
		}
		break;
		}
	case 1469: { // jsgt [abs]
		bool cc = test_gt();
		u32 abs = exv;
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = abs;
		}
		break;
		}
	case 1470: { // jscs [abs]
		bool cc = test_cs();
		u32 abs = exv;
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = abs;
		}
		break;
		}
	case 1471: { // jslt [abs]
		bool cc = test_lt();
		u32 abs = exv;
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = abs;
		}
		break;
		}
	case 1472: { // jseq [abs]
		bool cc = test_eq();
		u32 abs = exv;
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = abs;
		}
		break;
		}
	case 1473: { // jsmi [abs]
		bool cc = test_mi();
		u32 abs = exv;
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = abs;
		}
		break;
		}
	case 1474: { // jsnr [abs]
		bool cc = test_nr();
		u32 abs = exv;
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = abs;
		}
		break;
		}
	case 1475: { // jses [abs]
		bool cc = test_es();
		u32 abs = exv;
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = abs;
		}
		break;
		}
	case 1476: { // jsls [abs]
		bool cc = test_ls();
		u32 abs = exv;
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = abs;
		}
		break;
		}
	case 1477: { // jsle [abs]
		bool cc = test_le();
		u32 abs = exv;
		if(cc) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = abs;
		}
		break;
		}
	case 1478: { // jsclr #[n],x:(r)-n,[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(m_x.read_dword(ea), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1479: { // jsclr #[n],y:(r)-n,[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(m_y.read_dword(ea), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1480: { // jsclr #[n],x:(r)+n,[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(m_x.read_dword(ea), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1481: { // jsclr #[n],y:(r)+n,[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(m_y.read_dword(ea), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1482: { // jsclr #[n],x:(r)-,[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(m_x.read_dword(ea), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1483: { // jsclr #[n],y:(r)-,[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(m_y.read_dword(ea), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1484: { // jsclr #[n],x:(r)+,[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(m_x.read_dword(ea), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1485: { // jsclr #[n],y:(r)+,[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(m_y.read_dword(ea), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1486: { // jsclr #[n],x:(r),[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(m_x.read_dword(ea), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1487: { // jsclr #[n],y:(r),[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(m_y.read_dword(ea), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1488: { // jsclr #[n],x:(r+n),[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(m_x.read_dword(ea), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1489: { // jsclr #[n],y:(r+n),[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(m_y.read_dword(ea), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1490: { // jsclr #[n],x:-(r),[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(m_x.read_dword(ea), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1491: { // jsclr #[n],y:-(r),[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(m_y.read_dword(ea), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1492: { // jsclr #[n],x:[aa],[x]
		u32 aa = BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(m_x.read_dword(aa), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1493: { // jsclr #[n],y:[aa],[x]
		u32 aa = BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(m_y.read_dword(aa), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1494: { // jsclr #[n],x:[pp],[x]
		u32 pp = 0xffffc0 + BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(m_x.read_dword(pp), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1495: { // jsclr #[n],y:[pp],[x]
		u32 pp = 0xffffc0 + BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(m_y.read_dword(pp), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1496: { // jsclr #[n],x:[qq],[x]
		u32 qq = 0xffff80 + BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(m_x.read_dword(qq), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1497: { // jsclr #[n],y:[qq],[x]
		u32 qq = 0xffff80 + BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(m_y.read_dword(qq), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1498: { // jsclr #[n],x0,[x]
		u32 s = get_x0();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1499: { // jsclr #[n],x1,[x]
		u32 s = get_x1();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1500: { // jsclr #[n],y0,[x]
		u32 s = get_y0();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1501: { // jsclr #[n],y1,[x]
		u32 s = get_y1();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1502: { // jsclr #[n],a0,[x]
		u32 s = get_a0();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1503: { // jsclr #[n],b0,[x]
		u32 s = get_b0();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1504: { // jsclr #[n],a2,[x]
		u32 s = get_a2();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1505: { // jsclr #[n],b2,[x]
		u32 s = get_b2();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1506: { // jsclr #[n],a1,[x]
		u32 s = get_a1();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1507: { // jsclr #[n],b1,[x]
		u32 s = get_b1();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1508: { // jsclr #[n],a,[x]
		u32 s_h = get_ah();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(s_h, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1509: { // jsclr #[n],b,[x]
		u32 s_h = get_bh();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(s_h, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1510: { // jsclr #[n],r,[x]
		u32 s = get_r(BIT(opcode, 8, 6) & 7);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1511: { // jsclr #[n],n,[x]
		u32 s = get_n(BIT(opcode, 8, 6) & 7);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1512: { // jsclr #[n],m,[x]
		u32 s = get_m(BIT(opcode, 8, 6) & 7);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1513: { // jsclr #[n],ep,[x]
		u32 s = get_ep();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1514: { // jsclr #[n],vba,[x]
		u32 s = get_vba();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1515: { // jsclr #[n],sc,[x]
		u32 s = get_sc();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1516: { // jsclr #[n],sz,[x]
		u32 s = get_sz();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1517: { // jsclr #[n],sr,[x]
		u32 s = get_sr();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1518: { // jsclr #[n],omr,[x]
		u32 s = get_omr();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1519: { // jsclr #[n],sp,[x]
		u32 s = get_sp();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1520: { // jsclr #[n],ssh,[x]
		u32 s = get_ssh();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1521: { // jsclr #[n],ssl,[x]
		u32 s = get_ssl();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1522: { // jsclr #[n],la,[x]
		u32 s = get_la();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1523: { // jsclr #[n],lc,[x]
		u32 s = get_lc();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(!BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1524: { // jset #[n],x:(r)-n,[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(m_x.read_dword(ea), n))
		m_npc = x;
		break;
		}
	case 1525: { // jset #[n],y:(r)-n,[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(m_y.read_dword(ea), n))
		m_npc = x;
		break;
		}
	case 1526: { // jset #[n],x:(r)+n,[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(m_x.read_dword(ea), n))
		m_npc = x;
		break;
		}
	case 1527: { // jset #[n],y:(r)+n,[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(m_y.read_dword(ea), n))
		m_npc = x;
		break;
		}
	case 1528: { // jset #[n],x:(r)-,[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(m_x.read_dword(ea), n))
		m_npc = x;
		break;
		}
	case 1529: { // jset #[n],y:(r)-,[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(m_y.read_dword(ea), n))
		m_npc = x;
		break;
		}
	case 1530: { // jset #[n],x:(r)+,[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(m_x.read_dword(ea), n))
		m_npc = x;
		break;
		}
	case 1531: { // jset #[n],y:(r)+,[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(m_y.read_dword(ea), n))
		m_npc = x;
		break;
		}
	case 1532: { // jset #[n],x:(r),[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(m_x.read_dword(ea), n))
		m_npc = x;
		break;
		}
	case 1533: { // jset #[n],y:(r),[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(m_y.read_dword(ea), n))
		m_npc = x;
		break;
		}
	case 1534: { // jset #[n],x:(r+n),[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(m_x.read_dword(ea), n))
		m_npc = x;
		break;
		}
	case 1535: { // jset #[n],y:(r+n),[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(m_y.read_dword(ea), n))
		m_npc = x;
		break;
		}
	case 1536: { // jset #[n],x:-(r),[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(m_x.read_dword(ea), n))
		m_npc = x;
		break;
		}
	case 1537: { // jset #[n],y:-(r),[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(m_y.read_dword(ea), n))
		m_npc = x;
		break;
		}
	case 1538: { // jset #[n],x:[aa],[x]
		u32 aa = BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(m_x.read_dword(aa), n))
		m_npc = x;
		break;
		}
	case 1539: { // jset #[n],y:[aa],[x]
		u32 aa = BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(m_y.read_dword(aa), n))
		m_npc = x;
		break;
		}
	case 1540: { // jset #[n],x:[pp],[x]
		u32 pp = 0xffffc0 + BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(m_x.read_dword(pp), n))
		m_npc = x;
		break;
		}
	case 1541: { // jset #[n],y:[pp],[x]
		u32 pp = 0xffffc0 + BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(m_y.read_dword(pp), n))
		m_npc = x;
		break;
		}
	case 1542: { // jset #[n],x:[qq],[x]
		u32 qq = 0xffff80 + BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(m_x.read_dword(qq), n))
		m_npc = x;
		break;
		}
	case 1543: { // jset #[n],y:[qq],[x]
		u32 qq = 0xffff80 + BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(m_y.read_dword(qq), n))
		m_npc = x;
		break;
		}
	case 1544: { // jset #[n],x0,[x]
		u32 s = get_x0();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(s, n))
		m_npc = x;
		break;
		}
	case 1545: { // jset #[n],x1,[x]
		u32 s = get_x1();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(s, n))
		m_npc = x;
		break;
		}
	case 1546: { // jset #[n],y0,[x]
		u32 s = get_y0();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(s, n))
		m_npc = x;
		break;
		}
	case 1547: { // jset #[n],y1,[x]
		u32 s = get_y1();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(s, n))
		m_npc = x;
		break;
		}
	case 1548: { // jset #[n],a0,[x]
		u32 s = get_a0();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(s, n))
		m_npc = x;
		break;
		}
	case 1549: { // jset #[n],b0,[x]
		u32 s = get_b0();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(s, n))
		m_npc = x;
		break;
		}
	case 1550: { // jset #[n],a2,[x]
		u32 s = get_a2();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(s, n))
		m_npc = x;
		break;
		}
	case 1551: { // jset #[n],b2,[x]
		u32 s = get_b2();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(s, n))
		m_npc = x;
		break;
		}
	case 1552: { // jset #[n],a1,[x]
		u32 s = get_a1();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(s, n))
		m_npc = x;
		break;
		}
	case 1553: { // jset #[n],b1,[x]
		u32 s = get_b1();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(s, n))
		m_npc = x;
		break;
		}
	case 1554: { // jset #[n],a,[x]
		u32 s_h = get_ah();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(s_h, n))
		m_npc = x;
		break;
		}
	case 1555: { // jset #[n],b,[x]
		u32 s_h = get_bh();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(s_h, n))
		m_npc = x;
		break;
		}
	case 1556: { // jset #[n],r,[x]
		u32 s = get_r(BIT(opcode, 8, 6) & 7);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(s, n))
		m_npc = x;
		break;
		}
	case 1557: { // jset #[n],n,[x]
		u32 s = get_n(BIT(opcode, 8, 6) & 7);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(s, n))
		m_npc = x;
		break;
		}
	case 1558: { // jset #[n],m,[x]
		u32 s = get_m(BIT(opcode, 8, 6) & 7);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(s, n))
		m_npc = x;
		break;
		}
	case 1559: { // jset #[n],ep,[x]
		u32 s = get_ep();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(s, n))
		m_npc = x;
		break;
		}
	case 1560: { // jset #[n],vba,[x]
		u32 s = get_vba();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(s, n))
		m_npc = x;
		break;
		}
	case 1561: { // jset #[n],sc,[x]
		u32 s = get_sc();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(s, n))
		m_npc = x;
		break;
		}
	case 1562: { // jset #[n],sz,[x]
		u32 s = get_sz();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(s, n))
		m_npc = x;
		break;
		}
	case 1563: { // jset #[n],sr,[x]
		u32 s = get_sr();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(s, n))
		m_npc = x;
		break;
		}
	case 1564: { // jset #[n],omr,[x]
		u32 s = get_omr();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(s, n))
		m_npc = x;
		break;
		}
	case 1565: { // jset #[n],sp,[x]
		u32 s = get_sp();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(s, n))
		m_npc = x;
		break;
		}
	case 1566: { // jset #[n],ssh,[x]
		u32 s = get_ssh();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(s, n))
		m_npc = x;
		break;
		}
	case 1567: { // jset #[n],ssl,[x]
		u32 s = get_ssl();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(s, n))
		m_npc = x;
		break;
		}
	case 1568: { // jset #[n],la,[x]
		u32 s = get_la();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(s, n))
		m_npc = x;
		break;
		}
	case 1569: { // jset #[n],lc,[x]
		u32 s = get_lc();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(s, n))
		m_npc = x;
		break;
		}
	case 1570: { // jsr (r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		break;
		}
	case 1571: { // jsr (r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		break;
		}
	case 1572: { // jsr (r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		break;
		}
	case 1573: { // jsr (r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		break;
		}
	case 1574: { // jsr (r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		break;
		}
	case 1575: { // jsr (r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		break;
		}
	case 1576: { // jsr -(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = ea;
		break;
		}
	case 1577: { // jsr [abs]
		u32 abs = exv;
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = abs;
		break;
		}
	case 1578: { // jsr [x]
		u32 x = BIT(opcode, 0, 12);
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		break;
		}
	case 1579: { // jsset #[n],x:(r)-n,[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(m_x.read_dword(ea), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1580: { // jsset #[n],y:(r)-n,[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(m_y.read_dword(ea), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1581: { // jsset #[n],x:(r)+n,[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(m_x.read_dword(ea), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1582: { // jsset #[n],y:(r)+n,[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(m_y.read_dword(ea), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1583: { // jsset #[n],x:(r)-,[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(m_x.read_dword(ea), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1584: { // jsset #[n],y:(r)-,[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(m_y.read_dword(ea), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1585: { // jsset #[n],x:(r)+,[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(m_x.read_dword(ea), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1586: { // jsset #[n],y:(r)+,[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(m_y.read_dword(ea), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1587: { // jsset #[n],x:(r),[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(m_x.read_dword(ea), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1588: { // jsset #[n],y:(r),[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(m_y.read_dword(ea), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1589: { // jsset #[n],x:(r+n),[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(m_x.read_dword(ea), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1590: { // jsset #[n],y:(r+n),[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(m_y.read_dword(ea), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1591: { // jsset #[n],x:-(r),[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(m_x.read_dword(ea), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1592: { // jsset #[n],y:-(r),[x]
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(m_y.read_dword(ea), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1593: { // jsset #[n],x:[aa],[x]
		u32 aa = BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(m_x.read_dword(aa), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1594: { // jsset #[n],y:[aa],[x]
		u32 aa = BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(m_y.read_dword(aa), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1595: { // jsset #[n],x:[pp],[x]
		u32 pp = 0xffffc0 + BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(m_x.read_dword(pp), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1596: { // jsset #[n],y:[pp],[x]
		u32 pp = 0xffffc0 + BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(m_y.read_dword(pp), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1597: { // jsset #[n],x:[qq],[x]
		u32 qq = 0xffff80 + BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(m_x.read_dword(qq), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1598: { // jsset #[n],y:[qq],[x]
		u32 qq = 0xffff80 + BIT(opcode, 8, 6);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(m_y.read_dword(qq), n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1599: { // jsset #[n],x0,[x]
		u32 s = get_x0();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1600: { // jsset #[n],x1,[x]
		u32 s = get_x1();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1601: { // jsset #[n],y0,[x]
		u32 s = get_y0();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1602: { // jsset #[n],y1,[x]
		u32 s = get_y1();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1603: { // jsset #[n],a0,[x]
		u32 s = get_a0();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1604: { // jsset #[n],b0,[x]
		u32 s = get_b0();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1605: { // jsset #[n],a2,[x]
		u32 s = get_a2();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1606: { // jsset #[n],b2,[x]
		u32 s = get_b2();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1607: { // jsset #[n],a1,[x]
		u32 s = get_a1();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1608: { // jsset #[n],b1,[x]
		u32 s = get_b1();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1609: { // jsset #[n],a,[x]
		u32 s_h = get_ah();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(s_h, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1610: { // jsset #[n],b,[x]
		u32 s_h = get_bh();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(s_h, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1611: { // jsset #[n],r,[x]
		u32 s = get_r(BIT(opcode, 8, 6) & 7);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1612: { // jsset #[n],n,[x]
		u32 s = get_n(BIT(opcode, 8, 6) & 7);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1613: { // jsset #[n],m,[x]
		u32 s = get_m(BIT(opcode, 8, 6) & 7);
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1614: { // jsset #[n],ep,[x]
		u32 s = get_ep();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1615: { // jsset #[n],vba,[x]
		u32 s = get_vba();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1616: { // jsset #[n],sc,[x]
		u32 s = get_sc();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1617: { // jsset #[n],sz,[x]
		u32 s = get_sz();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1618: { // jsset #[n],sr,[x]
		u32 s = get_sr();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1619: { // jsset #[n],omr,[x]
		u32 s = get_omr();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1620: { // jsset #[n],sp,[x]
		u32 s = get_sp();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1621: { // jsset #[n],ssh,[x]
		u32 s = get_ssh();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1622: { // jsset #[n],ssl,[x]
		u32 s = get_ssl();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1623: { // jsset #[n],la,[x]
		u32 s = get_la();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1624: { // jsset #[n],lc,[x]
		u32 s = get_lc();
		u32 n = BIT(opcode, 0, 5);
		u32 x = exv;
		if(BIT(s, n)) {
		inc_sp();
		set_ssh(m_npc);
		set_ssl(get_sr());
		m_npc = x;
		}
		break;
		}
	case 1625: { // lra r,x0
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		set_x0(m_pc + r);
		break;
		}
	case 1626: { // lra r,x1
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		set_x1(m_pc + r);
		break;
		}
	case 1627: { // lra r,y0
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		set_y0(m_pc + r);
		break;
		}
	case 1628: { // lra r,y1
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		set_y1(m_pc + r);
		break;
		}
	case 1629: { // lra r,a0
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		set_a0(m_pc + r);
		break;
		}
	case 1630: { // lra r,b0
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		set_b0(m_pc + r);
		break;
		}
	case 1631: { // lra r,a2
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		set_a2(m_pc + r);
		break;
		}
	case 1632: { // lra r,b2
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		set_b2(m_pc + r);
		break;
		}
	case 1633: { // lra r,a1
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		set_a1(m_pc + r);
		break;
		}
	case 1634: { // lra r,b1
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		set_b1(m_pc + r);
		break;
		}
	case 1635: { // lra r,a
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		set_a(m_pc + r);
		break;
		}
	case 1636: { // lra r,b
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		set_b(m_pc + r);
		break;
		}
	case 1637: { // lra r,r
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		set_r(BIT(opcode, 0, 5) & 7, m_pc + r);
		break;
		}
	case 1638: { // lra r,n
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		set_n(BIT(opcode, 0, 5) & 7, m_pc + r);
		break;
		}
	case 1639: { // lra #[i],x0
		u32 i = (m_pc+exv) & 0xffffff;
		set_x0(i);
		break;
		}
	case 1640: { // lra #[i],x1
		u32 i = (m_pc+exv) & 0xffffff;
		set_x1(i);
		break;
		}
	case 1641: { // lra #[i],y0
		u32 i = (m_pc+exv) & 0xffffff;
		set_y0(i);
		break;
		}
	case 1642: { // lra #[i],y1
		u32 i = (m_pc+exv) & 0xffffff;
		set_y1(i);
		break;
		}
	case 1643: { // lra #[i],a0
		u32 i = (m_pc+exv) & 0xffffff;
		set_a0(i);
		break;
		}
	case 1644: { // lra #[i],b0
		u32 i = (m_pc+exv) & 0xffffff;
		set_b0(i);
		break;
		}
	case 1645: { // lra #[i],a2
		u32 i = (m_pc+exv) & 0xffffff;
		set_a2(i);
		break;
		}
	case 1646: { // lra #[i],b2
		u32 i = (m_pc+exv) & 0xffffff;
		set_b2(i);
		break;
		}
	case 1647: { // lra #[i],a1
		u32 i = (m_pc+exv) & 0xffffff;
		set_a1(i);
		break;
		}
	case 1648: { // lra #[i],b1
		u32 i = (m_pc+exv) & 0xffffff;
		set_b1(i);
		break;
		}
	case 1649: { // lra #[i],a
		u32 i = (m_pc+exv) & 0xffffff;
		set_a(i);
		break;
		}
	case 1650: { // lra #[i],b
		u32 i = (m_pc+exv) & 0xffffff;
		set_b(i);
		break;
		}
	case 1651: { // lra #[i],r
		u32 i = (m_pc+exv) & 0xffffff;
		set_r(BIT(opcode, 0, 5) & 7, i);
		break;
		}
	case 1652: { // lra #[i],n
		u32 i = (m_pc+exv) & 0xffffff;
		set_n(BIT(opcode, 0, 5) & 7, i);
		break;
		}
	case 1653: { // lsl #[i],a
		u32 d_h = get_ah();
		u32 i = BIT(opcode, 1, 5);
		u32 r = (d_h) << i;
		m_ccr &= ~(CCR_N|CCR_Z|CCR_V|CCR_C);
		if(BIT(r, 24)) {
		m_ccr |= CCR_C;
		}
		if(BIT(r, 23)) {
		m_ccr |= CCR_N;
		}
		r &= 0xffffff;
		if(!r) {
		m_ccr |= CCR_Z;
		}
		set_ah(r);
		break;
		}
	case 1654: { // lsl #[i],b
		u32 d_h = get_bh();
		u32 i = BIT(opcode, 1, 5);
		u32 r = (d_h) << i;
		m_ccr &= ~(CCR_N|CCR_Z|CCR_V|CCR_C);
		if(BIT(r, 24)) {
		m_ccr |= CCR_C;
		}
		if(BIT(r, 23)) {
		m_ccr |= CCR_N;
		}
		r &= 0xffffff;
		if(!r) {
		m_ccr |= CCR_Z;
		}
		set_bh(r);
		break;
		}
	case 1655: { // lsl a1,a
		u32 d_h = get_ah();
		u32 s = get_a1();
		u32 r = (d_h) << s;
		m_ccr &= ~(CCR_N|CCR_Z|CCR_V|CCR_C);
		if(BIT(r, 24)) {
		m_ccr |= CCR_C;
		}
		if(BIT(r, 23)) {
		m_ccr |= CCR_N;
		}
		r &= 0xffffff;
		if(!r) {
		m_ccr |= CCR_Z;
		}
		set_ah(r);
		break;
		}
	case 1656: { // lsl a1,b
		u32 d_h = get_bh();
		u32 s = get_a1();
		u32 r = (d_h) << s;
		m_ccr &= ~(CCR_N|CCR_Z|CCR_V|CCR_C);
		if(BIT(r, 24)) {
		m_ccr |= CCR_C;
		}
		if(BIT(r, 23)) {
		m_ccr |= CCR_N;
		}
		r &= 0xffffff;
		if(!r) {
		m_ccr |= CCR_Z;
		}
		set_bh(r);
		break;
		}
	case 1657: { // lsl b1,a
		u32 d_h = get_ah();
		u32 s = get_b1();
		u32 r = (d_h) << s;
		m_ccr &= ~(CCR_N|CCR_Z|CCR_V|CCR_C);
		if(BIT(r, 24)) {
		m_ccr |= CCR_C;
		}
		if(BIT(r, 23)) {
		m_ccr |= CCR_N;
		}
		r &= 0xffffff;
		if(!r) {
		m_ccr |= CCR_Z;
		}
		set_ah(r);
		break;
		}
	case 1658: { // lsl b1,b
		u32 d_h = get_bh();
		u32 s = get_b1();
		u32 r = (d_h) << s;
		m_ccr &= ~(CCR_N|CCR_Z|CCR_V|CCR_C);
		if(BIT(r, 24)) {
		m_ccr |= CCR_C;
		}
		if(BIT(r, 23)) {
		m_ccr |= CCR_N;
		}
		r &= 0xffffff;
		if(!r) {
		m_ccr |= CCR_Z;
		}
		set_bh(r);
		break;
		}
	case 1659: { // lsl x0,a
		u32 d_h = get_ah();
		u32 s = get_x0();
		u32 r = (d_h) << s;
		m_ccr &= ~(CCR_N|CCR_Z|CCR_V|CCR_C);
		if(BIT(r, 24)) {
		m_ccr |= CCR_C;
		}
		if(BIT(r, 23)) {
		m_ccr |= CCR_N;
		}
		r &= 0xffffff;
		if(!r) {
		m_ccr |= CCR_Z;
		}
		set_ah(r);
		break;
		}
	case 1660: { // lsl x0,b
		u32 d_h = get_bh();
		u32 s = get_x0();
		u32 r = (d_h) << s;
		m_ccr &= ~(CCR_N|CCR_Z|CCR_V|CCR_C);
		if(BIT(r, 24)) {
		m_ccr |= CCR_C;
		}
		if(BIT(r, 23)) {
		m_ccr |= CCR_N;
		}
		r &= 0xffffff;
		if(!r) {
		m_ccr |= CCR_Z;
		}
		set_bh(r);
		break;
		}
	case 1661: { // lsl y0,a
		u32 d_h = get_ah();
		u32 s = get_y0();
		u32 r = (d_h) << s;
		m_ccr &= ~(CCR_N|CCR_Z|CCR_V|CCR_C);
		if(BIT(r, 24)) {
		m_ccr |= CCR_C;
		}
		if(BIT(r, 23)) {
		m_ccr |= CCR_N;
		}
		r &= 0xffffff;
		if(!r) {
		m_ccr |= CCR_Z;
		}
		set_ah(r);
		break;
		}
	case 1662: { // lsl y0,b
		u32 d_h = get_bh();
		u32 s = get_y0();
		u32 r = (d_h) << s;
		m_ccr &= ~(CCR_N|CCR_Z|CCR_V|CCR_C);
		if(BIT(r, 24)) {
		m_ccr |= CCR_C;
		}
		if(BIT(r, 23)) {
		m_ccr |= CCR_N;
		}
		r &= 0xffffff;
		if(!r) {
		m_ccr |= CCR_Z;
		}
		set_bh(r);
		break;
		}
	case 1663: { // lsl x1,a
		u32 d_h = get_ah();
		u32 s = get_x1();
		u32 r = (d_h) << s;
		m_ccr &= ~(CCR_N|CCR_Z|CCR_V|CCR_C);
		if(BIT(r, 24)) {
		m_ccr |= CCR_C;
		}
		if(BIT(r, 23)) {
		m_ccr |= CCR_N;
		}
		r &= 0xffffff;
		if(!r) {
		m_ccr |= CCR_Z;
		}
		set_ah(r);
		break;
		}
	case 1664: { // lsl x1,b
		u32 d_h = get_bh();
		u32 s = get_x1();
		u32 r = (d_h) << s;
		m_ccr &= ~(CCR_N|CCR_Z|CCR_V|CCR_C);
		if(BIT(r, 24)) {
		m_ccr |= CCR_C;
		}
		if(BIT(r, 23)) {
		m_ccr |= CCR_N;
		}
		r &= 0xffffff;
		if(!r) {
		m_ccr |= CCR_Z;
		}
		set_bh(r);
		break;
		}
	case 1665: { // lsl y1,a
		u32 d_h = get_ah();
		u32 s = get_y1();
		u32 r = (d_h) << s;
		m_ccr &= ~(CCR_N|CCR_Z|CCR_V|CCR_C);
		if(BIT(r, 24)) {
		m_ccr |= CCR_C;
		}
		if(BIT(r, 23)) {
		m_ccr |= CCR_N;
		}
		r &= 0xffffff;
		if(!r) {
		m_ccr |= CCR_Z;
		}
		set_ah(r);
		break;
		}
	case 1666: { // lsl y1,b
		u32 d_h = get_bh();
		u32 s = get_y1();
		u32 r = (d_h) << s;
		m_ccr &= ~(CCR_N|CCR_Z|CCR_V|CCR_C);
		if(BIT(r, 24)) {
		m_ccr |= CCR_C;
		}
		if(BIT(r, 23)) {
		m_ccr |= CCR_N;
		}
		r &= 0xffffff;
		if(!r) {
		m_ccr |= CCR_Z;
		}
		set_bh(r);
		break;
		}
	case 1667: { // lsr #[i],a
		unhandled("lsr #[i],a");
		break;
		}
	case 1668: { // lsr #[i],b
		unhandled("lsr #[i],b");
		break;
		}
	case 1669: { // lsr a1,a
		unhandled("lsr a1,a");
		break;
		}
	case 1670: { // lsr a1,b
		unhandled("lsr a1,b");
		break;
		}
	case 1671: { // lsr b1,a
		unhandled("lsr b1,a");
		break;
		}
	case 1672: { // lsr b1,b
		unhandled("lsr b1,b");
		break;
		}
	case 1673: { // lsr x0,a
		unhandled("lsr x0,a");
		break;
		}
	case 1674: { // lsr x0,b
		unhandled("lsr x0,b");
		break;
		}
	case 1675: { // lsr y0,a
		unhandled("lsr y0,a");
		break;
		}
	case 1676: { // lsr y0,b
		unhandled("lsr y0,b");
		break;
		}
	case 1677: { // lsr x1,a
		unhandled("lsr x1,a");
		break;
		}
	case 1678: { // lsr x1,b
		unhandled("lsr x1,b");
		break;
		}
	case 1679: { // lsr y1,a
		unhandled("lsr y1,a");
		break;
		}
	case 1680: { // lsr y1,b
		unhandled("lsr y1,b");
		break;
		}
	case 1681: { // lua (r)-n,x0
		int ea_r = BIT(opcode, 8, 5) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_x0(ea);
		break;
		}
	case 1682: { // lua (r)-n,x1
		int ea_r = BIT(opcode, 8, 5) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_x1(ea);
		break;
		}
	case 1683: { // lua (r)-n,y0
		int ea_r = BIT(opcode, 8, 5) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_y0(ea);
		break;
		}
	case 1684: { // lua (r)-n,y1
		int ea_r = BIT(opcode, 8, 5) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_y1(ea);
		break;
		}
	case 1685: { // lua (r)-n,a0
		int ea_r = BIT(opcode, 8, 5) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_a0(ea);
		break;
		}
	case 1686: { // lua (r)-n,b0
		int ea_r = BIT(opcode, 8, 5) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_b0(ea);
		break;
		}
	case 1687: { // lua (r)-n,a2
		int ea_r = BIT(opcode, 8, 5) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_a2(ea);
		break;
		}
	case 1688: { // lua (r)-n,b2
		int ea_r = BIT(opcode, 8, 5) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_b2(ea);
		break;
		}
	case 1689: { // lua (r)-n,a1
		int ea_r = BIT(opcode, 8, 5) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_a1(ea);
		break;
		}
	case 1690: { // lua (r)-n,b1
		int ea_r = BIT(opcode, 8, 5) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_b1(ea);
		break;
		}
	case 1691: { // lua (r)-n,a
		int ea_r = BIT(opcode, 8, 5) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_ah(ea);
		break;
		}
	case 1692: { // lua (r)-n,b
		int ea_r = BIT(opcode, 8, 5) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_bh(ea);
		break;
		}
	case 1693: { // lua (r)-n,r
		int ea_r = BIT(opcode, 8, 5) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_r(BIT(opcode, 0, 5) & 7, ea);
		break;
		}
	case 1694: { // lua (r)-n,n
		int ea_r = BIT(opcode, 8, 5) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_n(BIT(opcode, 0, 5) & 7, ea);
		break;
		}
	case 1695: { // lua (r)+n,x0
		int ea_r = BIT(opcode, 8, 5) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_x0(ea);
		break;
		}
	case 1696: { // lua (r)+n,x1
		int ea_r = BIT(opcode, 8, 5) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_x1(ea);
		break;
		}
	case 1697: { // lua (r)+n,y0
		int ea_r = BIT(opcode, 8, 5) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_y0(ea);
		break;
		}
	case 1698: { // lua (r)+n,y1
		int ea_r = BIT(opcode, 8, 5) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_y1(ea);
		break;
		}
	case 1699: { // lua (r)+n,a0
		int ea_r = BIT(opcode, 8, 5) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_a0(ea);
		break;
		}
	case 1700: { // lua (r)+n,b0
		int ea_r = BIT(opcode, 8, 5) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_b0(ea);
		break;
		}
	case 1701: { // lua (r)+n,a2
		int ea_r = BIT(opcode, 8, 5) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_a2(ea);
		break;
		}
	case 1702: { // lua (r)+n,b2
		int ea_r = BIT(opcode, 8, 5) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_b2(ea);
		break;
		}
	case 1703: { // lua (r)+n,a1
		int ea_r = BIT(opcode, 8, 5) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_a1(ea);
		break;
		}
	case 1704: { // lua (r)+n,b1
		int ea_r = BIT(opcode, 8, 5) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_b1(ea);
		break;
		}
	case 1705: { // lua (r)+n,a
		int ea_r = BIT(opcode, 8, 5) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_ah(ea);
		break;
		}
	case 1706: { // lua (r)+n,b
		int ea_r = BIT(opcode, 8, 5) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_bh(ea);
		break;
		}
	case 1707: { // lua (r)+n,r
		int ea_r = BIT(opcode, 8, 5) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_r(BIT(opcode, 0, 5) & 7, ea);
		break;
		}
	case 1708: { // lua (r)+n,n
		int ea_r = BIT(opcode, 8, 5) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_n(BIT(opcode, 0, 5) & 7, ea);
		break;
		}
	case 1709: { // lua (r)-,x0
		int ea_r = BIT(opcode, 8, 5) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_x0(ea);
		break;
		}
	case 1710: { // lua (r)-,x1
		int ea_r = BIT(opcode, 8, 5) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_x1(ea);
		break;
		}
	case 1711: { // lua (r)-,y0
		int ea_r = BIT(opcode, 8, 5) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_y0(ea);
		break;
		}
	case 1712: { // lua (r)-,y1
		int ea_r = BIT(opcode, 8, 5) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_y1(ea);
		break;
		}
	case 1713: { // lua (r)-,a0
		int ea_r = BIT(opcode, 8, 5) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_a0(ea);
		break;
		}
	case 1714: { // lua (r)-,b0
		int ea_r = BIT(opcode, 8, 5) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_b0(ea);
		break;
		}
	case 1715: { // lua (r)-,a2
		int ea_r = BIT(opcode, 8, 5) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_a2(ea);
		break;
		}
	case 1716: { // lua (r)-,b2
		int ea_r = BIT(opcode, 8, 5) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_b2(ea);
		break;
		}
	case 1717: { // lua (r)-,a1
		int ea_r = BIT(opcode, 8, 5) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_a1(ea);
		break;
		}
	case 1718: { // lua (r)-,b1
		int ea_r = BIT(opcode, 8, 5) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_b1(ea);
		break;
		}
	case 1719: { // lua (r)-,a
		int ea_r = BIT(opcode, 8, 5) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_ah(ea);
		break;
		}
	case 1720: { // lua (r)-,b
		int ea_r = BIT(opcode, 8, 5) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_bh(ea);
		break;
		}
	case 1721: { // lua (r)-,r
		int ea_r = BIT(opcode, 8, 5) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_r(BIT(opcode, 0, 5) & 7, ea);
		break;
		}
	case 1722: { // lua (r)-,n
		int ea_r = BIT(opcode, 8, 5) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_n(BIT(opcode, 0, 5) & 7, ea);
		break;
		}
	case 1723: { // lua (r)+,x0
		int ea_r = BIT(opcode, 8, 5) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_x0(ea);
		break;
		}
	case 1724: { // lua (r)+,x1
		int ea_r = BIT(opcode, 8, 5) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_x1(ea);
		break;
		}
	case 1725: { // lua (r)+,y0
		int ea_r = BIT(opcode, 8, 5) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_y0(ea);
		break;
		}
	case 1726: { // lua (r)+,y1
		int ea_r = BIT(opcode, 8, 5) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_y1(ea);
		break;
		}
	case 1727: { // lua (r)+,a0
		int ea_r = BIT(opcode, 8, 5) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_a0(ea);
		break;
		}
	case 1728: { // lua (r)+,b0
		int ea_r = BIT(opcode, 8, 5) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_b0(ea);
		break;
		}
	case 1729: { // lua (r)+,a2
		int ea_r = BIT(opcode, 8, 5) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_a2(ea);
		break;
		}
	case 1730: { // lua (r)+,b2
		int ea_r = BIT(opcode, 8, 5) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_b2(ea);
		break;
		}
	case 1731: { // lua (r)+,a1
		int ea_r = BIT(opcode, 8, 5) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_a1(ea);
		break;
		}
	case 1732: { // lua (r)+,b1
		int ea_r = BIT(opcode, 8, 5) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_b1(ea);
		break;
		}
	case 1733: { // lua (r)+,a
		int ea_r = BIT(opcode, 8, 5) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_ah(ea);
		break;
		}
	case 1734: { // lua (r)+,b
		int ea_r = BIT(opcode, 8, 5) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_bh(ea);
		break;
		}
	case 1735: { // lua (r)+,r
		int ea_r = BIT(opcode, 8, 5) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_r(BIT(opcode, 0, 5) & 7, ea);
		break;
		}
	case 1736: { // lua (r)+,n
		int ea_r = BIT(opcode, 8, 5) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_n(BIT(opcode, 0, 5) & 7, ea);
		break;
		}
	case 1737: { // lua (r+[o]),r
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = util::sext(bitswap<7>(opcode, 13, 12, 11, 7, 6, 5, 4), 7);
		set_r(BIT(opcode, 0, 4) & 7, r + o);
		break;
		}
	case 1738: { // lua (r+[o]),n
		u32 r = get_r(BIT(opcode, 8, 3) & 7);
		u32 o = util::sext(bitswap<7>(opcode, 13, 12, 11, 7, 6, 5, 4), 7);
		set_n(BIT(opcode, 0, 4) & 7, r + o);
		break;
		}
	case 1739: { // mac +y1,#[i],a
		unhandled("mac +y1,#[i],a");
		break;
		}
	case 1740: { // mac -y1,#[i],a
		unhandled("mac -y1,#[i],a");
		break;
		}
	case 1741: { // mac +y1,#[i],b
		unhandled("mac +y1,#[i],b");
		break;
		}
	case 1742: { // mac -y1,#[i],b
		unhandled("mac -y1,#[i],b");
		break;
		}
	case 1743: { // mac +x0,#[i],a
		unhandled("mac +x0,#[i],a");
		break;
		}
	case 1744: { // mac -x0,#[i],a
		unhandled("mac -x0,#[i],a");
		break;
		}
	case 1745: { // mac +x0,#[i],b
		unhandled("mac +x0,#[i],b");
		break;
		}
	case 1746: { // mac -x0,#[i],b
		unhandled("mac -x0,#[i],b");
		break;
		}
	case 1747: { // mac +y0,#[i],a
		unhandled("mac +y0,#[i],a");
		break;
		}
	case 1748: { // mac -y0,#[i],a
		unhandled("mac -y0,#[i],a");
		break;
		}
	case 1749: { // mac +y0,#[i],b
		unhandled("mac +y0,#[i],b");
		break;
		}
	case 1750: { // mac -y0,#[i],b
		unhandled("mac -y0,#[i],b");
		break;
		}
	case 1751: { // mac +x1,#[i],a
		unhandled("mac +x1,#[i],a");
		break;
		}
	case 1752: { // mac -x1,#[i],a
		unhandled("mac -x1,#[i],a");
		break;
		}
	case 1753: { // mac +x1,#[i],b
		unhandled("mac +x1,#[i],b");
		break;
		}
	case 1754: { // mac -x1,#[i],b
		unhandled("mac -x1,#[i],b");
		break;
		}
	case 1755: { // maci +#[i],y1,a
		unhandled("maci +#[i],y1,a");
		break;
		}
	case 1756: { // maci -#[i],y1,a
		unhandled("maci -#[i],y1,a");
		break;
		}
	case 1757: { // maci +#[i],y1,b
		unhandled("maci +#[i],y1,b");
		break;
		}
	case 1758: { // maci -#[i],y1,b
		unhandled("maci -#[i],y1,b");
		break;
		}
	case 1759: { // maci +#[i],x0,a
		unhandled("maci +#[i],x0,a");
		break;
		}
	case 1760: { // maci -#[i],x0,a
		unhandled("maci -#[i],x0,a");
		break;
		}
	case 1761: { // maci +#[i],x0,b
		unhandled("maci +#[i],x0,b");
		break;
		}
	case 1762: { // maci -#[i],x0,b
		unhandled("maci -#[i],x0,b");
		break;
		}
	case 1763: { // maci +#[i],y0,a
		unhandled("maci +#[i],y0,a");
		break;
		}
	case 1764: { // maci -#[i],y0,a
		unhandled("maci -#[i],y0,a");
		break;
		}
	case 1765: { // maci +#[i],y0,b
		unhandled("maci +#[i],y0,b");
		break;
		}
	case 1766: { // maci -#[i],y0,b
		unhandled("maci -#[i],y0,b");
		break;
		}
	case 1767: { // maci +#[i],x1,a
		unhandled("maci +#[i],x1,a");
		break;
		}
	case 1768: { // maci -#[i],x1,a
		unhandled("maci -#[i],x1,a");
		break;
		}
	case 1769: { // maci +#[i],x1,b
		unhandled("maci +#[i],x1,b");
		break;
		}
	case 1770: { // maci -#[i],x1,b
		unhandled("maci -#[i],x1,b");
		break;
		}
	case 1771: { // macsu +x0,x0,a
		unhandled("macsu +x0,x0,a");
		break;
		}
	case 1772: { // macsu +y0,y0,a
		unhandled("macsu +y0,y0,a");
		break;
		}
	case 1773: { // macsu +x1,x0,a
		unhandled("macsu +x1,x0,a");
		break;
		}
	case 1774: { // macsu +y1,y0,a
		unhandled("macsu +y1,y0,a");
		break;
		}
	case 1775: { // macsu +x1,x1,a
		unhandled("macsu +x1,x1,a");
		break;
		}
	case 1776: { // macsu +y1,y1,a
		unhandled("macsu +y1,y1,a");
		break;
		}
	case 1777: { // macsu +x0,x1,a
		unhandled("macsu +x0,x1,a");
		break;
		}
	case 1778: { // macsu +y0,y1,a
		unhandled("macsu +y0,y1,a");
		break;
		}
	case 1779: { // macsu +x0,y1,a
		unhandled("macsu +x0,y1,a");
		break;
		}
	case 1780: { // macsu +y0,x0,a
		unhandled("macsu +y0,x0,a");
		break;
		}
	case 1781: { // macsu +x1,y0,a
		unhandled("macsu +x1,y0,a");
		break;
		}
	case 1782: { // macsu +y1,x1,a
		unhandled("macsu +y1,x1,a");
		break;
		}
	case 1783: { // macsu +y1,x0,a
		unhandled("macsu +y1,x0,a");
		break;
		}
	case 1784: { // macsu +x0,y0,a
		unhandled("macsu +x0,y0,a");
		break;
		}
	case 1785: { // macsu +y0,x1,a
		unhandled("macsu +y0,x1,a");
		break;
		}
	case 1786: { // macsu +x1,y1,a
		unhandled("macsu +x1,y1,a");
		break;
		}
	case 1787: { // macsu -x0,x0,a
		unhandled("macsu -x0,x0,a");
		break;
		}
	case 1788: { // macsu -y0,y0,a
		unhandled("macsu -y0,y0,a");
		break;
		}
	case 1789: { // macsu -x1,x0,a
		unhandled("macsu -x1,x0,a");
		break;
		}
	case 1790: { // macsu -y1,y0,a
		unhandled("macsu -y1,y0,a");
		break;
		}
	case 1791: { // macsu -x1,x1,a
		unhandled("macsu -x1,x1,a");
		break;
		}
	case 1792: { // macsu -y1,y1,a
		unhandled("macsu -y1,y1,a");
		break;
		}
	case 1793: { // macsu -x0,x1,a
		unhandled("macsu -x0,x1,a");
		break;
		}
	case 1794: { // macsu -y0,y1,a
		unhandled("macsu -y0,y1,a");
		break;
		}
	case 1795: { // macsu -x0,y1,a
		unhandled("macsu -x0,y1,a");
		break;
		}
	case 1796: { // macsu -y0,x0,a
		unhandled("macsu -y0,x0,a");
		break;
		}
	case 1797: { // macsu -x1,y0,a
		unhandled("macsu -x1,y0,a");
		break;
		}
	case 1798: { // macsu -y1,x1,a
		unhandled("macsu -y1,x1,a");
		break;
		}
	case 1799: { // macsu -y1,x0,a
		unhandled("macsu -y1,x0,a");
		break;
		}
	case 1800: { // macsu -x0,y0,a
		unhandled("macsu -x0,y0,a");
		break;
		}
	case 1801: { // macsu -y0,x1,a
		unhandled("macsu -y0,x1,a");
		break;
		}
	case 1802: { // macsu -x1,y1,a
		unhandled("macsu -x1,y1,a");
		break;
		}
	case 1803: { // macsu +x0,x0,b
		unhandled("macsu +x0,x0,b");
		break;
		}
	case 1804: { // macsu +y0,y0,b
		unhandled("macsu +y0,y0,b");
		break;
		}
	case 1805: { // macsu +x1,x0,b
		unhandled("macsu +x1,x0,b");
		break;
		}
	case 1806: { // macsu +y1,y0,b
		unhandled("macsu +y1,y0,b");
		break;
		}
	case 1807: { // macsu +x1,x1,b
		unhandled("macsu +x1,x1,b");
		break;
		}
	case 1808: { // macsu +y1,y1,b
		unhandled("macsu +y1,y1,b");
		break;
		}
	case 1809: { // macsu +x0,x1,b
		unhandled("macsu +x0,x1,b");
		break;
		}
	case 1810: { // macsu +y0,y1,b
		unhandled("macsu +y0,y1,b");
		break;
		}
	case 1811: { // macsu +x0,y1,b
		unhandled("macsu +x0,y1,b");
		break;
		}
	case 1812: { // macsu +y0,x0,b
		unhandled("macsu +y0,x0,b");
		break;
		}
	case 1813: { // macsu +x1,y0,b
		unhandled("macsu +x1,y0,b");
		break;
		}
	case 1814: { // macsu +y1,x1,b
		unhandled("macsu +y1,x1,b");
		break;
		}
	case 1815: { // macsu +y1,x0,b
		unhandled("macsu +y1,x0,b");
		break;
		}
	case 1816: { // macsu +x0,y0,b
		unhandled("macsu +x0,y0,b");
		break;
		}
	case 1817: { // macsu +y0,x1,b
		unhandled("macsu +y0,x1,b");
		break;
		}
	case 1818: { // macsu +x1,y1,b
		unhandled("macsu +x1,y1,b");
		break;
		}
	case 1819: { // macsu -x0,x0,b
		unhandled("macsu -x0,x0,b");
		break;
		}
	case 1820: { // macsu -y0,y0,b
		unhandled("macsu -y0,y0,b");
		break;
		}
	case 1821: { // macsu -x1,x0,b
		unhandled("macsu -x1,x0,b");
		break;
		}
	case 1822: { // macsu -y1,y0,b
		unhandled("macsu -y1,y0,b");
		break;
		}
	case 1823: { // macsu -x1,x1,b
		unhandled("macsu -x1,x1,b");
		break;
		}
	case 1824: { // macsu -y1,y1,b
		unhandled("macsu -y1,y1,b");
		break;
		}
	case 1825: { // macsu -x0,x1,b
		unhandled("macsu -x0,x1,b");
		break;
		}
	case 1826: { // macsu -y0,y1,b
		unhandled("macsu -y0,y1,b");
		break;
		}
	case 1827: { // macsu -x0,y1,b
		unhandled("macsu -x0,y1,b");
		break;
		}
	case 1828: { // macsu -y0,x0,b
		unhandled("macsu -y0,x0,b");
		break;
		}
	case 1829: { // macsu -x1,y0,b
		unhandled("macsu -x1,y0,b");
		break;
		}
	case 1830: { // macsu -y1,x1,b
		unhandled("macsu -y1,x1,b");
		break;
		}
	case 1831: { // macsu -y1,x0,b
		unhandled("macsu -y1,x0,b");
		break;
		}
	case 1832: { // macsu -x0,y0,b
		unhandled("macsu -x0,y0,b");
		break;
		}
	case 1833: { // macsu -y0,x1,b
		unhandled("macsu -y0,x1,b");
		break;
		}
	case 1834: { // macsu -x1,y1,b
		unhandled("macsu -x1,y1,b");
		break;
		}
	case 1835: { // macuu +x0,x0,a
		unhandled("macuu +x0,x0,a");
		break;
		}
	case 1836: { // macuu +y0,y0,a
		unhandled("macuu +y0,y0,a");
		break;
		}
	case 1837: { // macuu +x1,x0,a
		unhandled("macuu +x1,x0,a");
		break;
		}
	case 1838: { // macuu +y1,y0,a
		unhandled("macuu +y1,y0,a");
		break;
		}
	case 1839: { // macuu +x1,x1,a
		unhandled("macuu +x1,x1,a");
		break;
		}
	case 1840: { // macuu +y1,y1,a
		unhandled("macuu +y1,y1,a");
		break;
		}
	case 1841: { // macuu +x0,x1,a
		unhandled("macuu +x0,x1,a");
		break;
		}
	case 1842: { // macuu +y0,y1,a
		unhandled("macuu +y0,y1,a");
		break;
		}
	case 1843: { // macuu +x0,y1,a
		unhandled("macuu +x0,y1,a");
		break;
		}
	case 1844: { // macuu +y0,x0,a
		unhandled("macuu +y0,x0,a");
		break;
		}
	case 1845: { // macuu +x1,y0,a
		unhandled("macuu +x1,y0,a");
		break;
		}
	case 1846: { // macuu +y1,x1,a
		unhandled("macuu +y1,x1,a");
		break;
		}
	case 1847: { // macuu +y1,x0,a
		unhandled("macuu +y1,x0,a");
		break;
		}
	case 1848: { // macuu +x0,y0,a
		unhandled("macuu +x0,y0,a");
		break;
		}
	case 1849: { // macuu +y0,x1,a
		unhandled("macuu +y0,x1,a");
		break;
		}
	case 1850: { // macuu +x1,y1,a
		unhandled("macuu +x1,y1,a");
		break;
		}
	case 1851: { // macuu -x0,x0,a
		unhandled("macuu -x0,x0,a");
		break;
		}
	case 1852: { // macuu -y0,y0,a
		unhandled("macuu -y0,y0,a");
		break;
		}
	case 1853: { // macuu -x1,x0,a
		unhandled("macuu -x1,x0,a");
		break;
		}
	case 1854: { // macuu -y1,y0,a
		unhandled("macuu -y1,y0,a");
		break;
		}
	case 1855: { // macuu -x1,x1,a
		unhandled("macuu -x1,x1,a");
		break;
		}
	case 1856: { // macuu -y1,y1,a
		unhandled("macuu -y1,y1,a");
		break;
		}
	case 1857: { // macuu -x0,x1,a
		unhandled("macuu -x0,x1,a");
		break;
		}
	case 1858: { // macuu -y0,y1,a
		unhandled("macuu -y0,y1,a");
		break;
		}
	case 1859: { // macuu -x0,y1,a
		unhandled("macuu -x0,y1,a");
		break;
		}
	case 1860: { // macuu -y0,x0,a
		unhandled("macuu -y0,x0,a");
		break;
		}
	case 1861: { // macuu -x1,y0,a
		unhandled("macuu -x1,y0,a");
		break;
		}
	case 1862: { // macuu -y1,x1,a
		unhandled("macuu -y1,x1,a");
		break;
		}
	case 1863: { // macuu -y1,x0,a
		unhandled("macuu -y1,x0,a");
		break;
		}
	case 1864: { // macuu -x0,y0,a
		unhandled("macuu -x0,y0,a");
		break;
		}
	case 1865: { // macuu -y0,x1,a
		unhandled("macuu -y0,x1,a");
		break;
		}
	case 1866: { // macuu -x1,y1,a
		unhandled("macuu -x1,y1,a");
		break;
		}
	case 1867: { // macuu +x0,x0,b
		unhandled("macuu +x0,x0,b");
		break;
		}
	case 1868: { // macuu +y0,y0,b
		unhandled("macuu +y0,y0,b");
		break;
		}
	case 1869: { // macuu +x1,x0,b
		unhandled("macuu +x1,x0,b");
		break;
		}
	case 1870: { // macuu +y1,y0,b
		unhandled("macuu +y1,y0,b");
		break;
		}
	case 1871: { // macuu +x1,x1,b
		unhandled("macuu +x1,x1,b");
		break;
		}
	case 1872: { // macuu +y1,y1,b
		unhandled("macuu +y1,y1,b");
		break;
		}
	case 1873: { // macuu +x0,x1,b
		unhandled("macuu +x0,x1,b");
		break;
		}
	case 1874: { // macuu +y0,y1,b
		unhandled("macuu +y0,y1,b");
		break;
		}
	case 1875: { // macuu +x0,y1,b
		unhandled("macuu +x0,y1,b");
		break;
		}
	case 1876: { // macuu +y0,x0,b
		unhandled("macuu +y0,x0,b");
		break;
		}
	case 1877: { // macuu +x1,y0,b
		unhandled("macuu +x1,y0,b");
		break;
		}
	case 1878: { // macuu +y1,x1,b
		unhandled("macuu +y1,x1,b");
		break;
		}
	case 1879: { // macuu +y1,x0,b
		unhandled("macuu +y1,x0,b");
		break;
		}
	case 1880: { // macuu +x0,y0,b
		unhandled("macuu +x0,y0,b");
		break;
		}
	case 1881: { // macuu +y0,x1,b
		unhandled("macuu +y0,x1,b");
		break;
		}
	case 1882: { // macuu +x1,y1,b
		unhandled("macuu +x1,y1,b");
		break;
		}
	case 1883: { // macuu -x0,x0,b
		unhandled("macuu -x0,x0,b");
		break;
		}
	case 1884: { // macuu -y0,y0,b
		unhandled("macuu -y0,y0,b");
		break;
		}
	case 1885: { // macuu -x1,x0,b
		unhandled("macuu -x1,x0,b");
		break;
		}
	case 1886: { // macuu -y1,y0,b
		unhandled("macuu -y1,y0,b");
		break;
		}
	case 1887: { // macuu -x1,x1,b
		unhandled("macuu -x1,x1,b");
		break;
		}
	case 1888: { // macuu -y1,y1,b
		unhandled("macuu -y1,y1,b");
		break;
		}
	case 1889: { // macuu -x0,x1,b
		unhandled("macuu -x0,x1,b");
		break;
		}
	case 1890: { // macuu -y0,y1,b
		unhandled("macuu -y0,y1,b");
		break;
		}
	case 1891: { // macuu -x0,y1,b
		unhandled("macuu -x0,y1,b");
		break;
		}
	case 1892: { // macuu -y0,x0,b
		unhandled("macuu -y0,x0,b");
		break;
		}
	case 1893: { // macuu -x1,y0,b
		unhandled("macuu -x1,y0,b");
		break;
		}
	case 1894: { // macuu -y1,x1,b
		unhandled("macuu -y1,x1,b");
		break;
		}
	case 1895: { // macuu -y1,x0,b
		unhandled("macuu -y1,x0,b");
		break;
		}
	case 1896: { // macuu -x0,y0,b
		unhandled("macuu -x0,y0,b");
		break;
		}
	case 1897: { // macuu -y0,x1,b
		unhandled("macuu -y0,x1,b");
		break;
		}
	case 1898: { // macuu -x1,y1,b
		unhandled("macuu -x1,y1,b");
		break;
		}
	case 1899: { // maccr +y1,#[i],a
		unhandled("maccr +y1,#[i],a");
		break;
		}
	case 1900: { // maccr -y1,#[i],a
		unhandled("maccr -y1,#[i],a");
		break;
		}
	case 1901: { // maccr +y1,#[i],b
		unhandled("maccr +y1,#[i],b");
		break;
		}
	case 1902: { // maccr -y1,#[i],b
		unhandled("maccr -y1,#[i],b");
		break;
		}
	case 1903: { // maccr +x0,#[i],a
		unhandled("maccr +x0,#[i],a");
		break;
		}
	case 1904: { // maccr -x0,#[i],a
		unhandled("maccr -x0,#[i],a");
		break;
		}
	case 1905: { // maccr +x0,#[i],b
		unhandled("maccr +x0,#[i],b");
		break;
		}
	case 1906: { // maccr -x0,#[i],b
		unhandled("maccr -x0,#[i],b");
		break;
		}
	case 1907: { // maccr +y0,#[i],a
		unhandled("maccr +y0,#[i],a");
		break;
		}
	case 1908: { // maccr -y0,#[i],a
		unhandled("maccr -y0,#[i],a");
		break;
		}
	case 1909: { // maccr +y0,#[i],b
		unhandled("maccr +y0,#[i],b");
		break;
		}
	case 1910: { // maccr -y0,#[i],b
		unhandled("maccr -y0,#[i],b");
		break;
		}
	case 1911: { // maccr +x1,#[i],a
		unhandled("maccr +x1,#[i],a");
		break;
		}
	case 1912: { // maccr -x1,#[i],a
		unhandled("maccr -x1,#[i],a");
		break;
		}
	case 1913: { // maccr +x1,#[i],b
		unhandled("maccr +x1,#[i],b");
		break;
		}
	case 1914: { // maccr -x1,#[i],b
		unhandled("maccr -x1,#[i],b");
		break;
		}
	case 1915: { // macri +#[i],y1,a
		unhandled("macri +#[i],y1,a");
		break;
		}
	case 1916: { // macri -#[i],y1,a
		unhandled("macri -#[i],y1,a");
		break;
		}
	case 1917: { // macri +#[i],y1,b
		unhandled("macri +#[i],y1,b");
		break;
		}
	case 1918: { // macri -#[i],y1,b
		unhandled("macri -#[i],y1,b");
		break;
		}
	case 1919: { // macri +#[i],x0,a
		unhandled("macri +#[i],x0,a");
		break;
		}
	case 1920: { // macri -#[i],x0,a
		unhandled("macri -#[i],x0,a");
		break;
		}
	case 1921: { // macri +#[i],x0,b
		unhandled("macri +#[i],x0,b");
		break;
		}
	case 1922: { // macri -#[i],x0,b
		unhandled("macri -#[i],x0,b");
		break;
		}
	case 1923: { // macri +#[i],y0,a
		unhandled("macri +#[i],y0,a");
		break;
		}
	case 1924: { // macri -#[i],y0,a
		unhandled("macri -#[i],y0,a");
		break;
		}
	case 1925: { // macri +#[i],y0,b
		unhandled("macri +#[i],y0,b");
		break;
		}
	case 1926: { // macri -#[i],y0,b
		unhandled("macri -#[i],y0,b");
		break;
		}
	case 1927: { // macri +#[i],x1,a
		unhandled("macri +#[i],x1,a");
		break;
		}
	case 1928: { // macri -#[i],x1,a
		unhandled("macri -#[i],x1,a");
		break;
		}
	case 1929: { // macri +#[i],x1,b
		unhandled("macri +#[i],x1,b");
		break;
		}
	case 1930: { // macri -#[i],x1,b
		unhandled("macri -#[i],x1,b");
		break;
		}
	case 1931: { // merge a1,a
		unhandled("merge a1,a");
		break;
		}
	case 1932: { // merge a1,b
		unhandled("merge a1,b");
		break;
		}
	case 1933: { // merge b1,a
		unhandled("merge b1,a");
		break;
		}
	case 1934: { // merge b1,b
		unhandled("merge b1,b");
		break;
		}
	case 1935: { // merge x0,a
		unhandled("merge x0,a");
		break;
		}
	case 1936: { // merge x0,b
		unhandled("merge x0,b");
		break;
		}
	case 1937: { // merge y0,a
		unhandled("merge y0,a");
		break;
		}
	case 1938: { // merge y0,b
		unhandled("merge y0,b");
		break;
		}
	case 1939: { // merge x1,a
		unhandled("merge x1,a");
		break;
		}
	case 1940: { // merge x1,b
		unhandled("merge x1,b");
		break;
		}
	case 1941: { // merge y1,a
		unhandled("merge y1,a");
		break;
		}
	case 1942: { // merge y1,b
		unhandled("merge y1,b");
		break;
		}
	case 1943: { // movec x:(r)-n,m
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_m(BIT(opcode, 0, 5) & 7, m_x.read_dword(ea));
		break;
		}
	case 1944: { // movec x:(r)-n,ep
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_ep(m_x.read_dword(ea));
		break;
		}
	case 1945: { // movec x:(r)-n,vba
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_vba(m_x.read_dword(ea));
		break;
		}
	case 1946: { // movec x:(r)-n,sc
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_sc(m_x.read_dword(ea));
		break;
		}
	case 1947: { // movec x:(r)-n,sz
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_sz(m_x.read_dword(ea));
		break;
		}
	case 1948: { // movec x:(r)-n,sr
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_sr(m_x.read_dword(ea));
		break;
		}
	case 1949: { // movec x:(r)-n,omr
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_omr(m_x.read_dword(ea));
		break;
		}
	case 1950: { // movec x:(r)-n,sp
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_sp(m_x.read_dword(ea));
		break;
		}
	case 1951: { // movec x:(r)-n,ssh
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_ssh(m_x.read_dword(ea));
		break;
		}
	case 1952: { // movec x:(r)-n,ssl
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_ssl(m_x.read_dword(ea));
		break;
		}
	case 1953: { // movec x:(r)-n,la
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_la(m_x.read_dword(ea));
		break;
		}
	case 1954: { // movec x:(r)-n,lc
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_lc(m_x.read_dword(ea));
		break;
		}
	case 1955: { // movec y:(r)-n,m
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_m(BIT(opcode, 0, 5) & 7, m_y.read_dword(ea));
		break;
		}
	case 1956: { // movec y:(r)-n,ep
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_ep(m_y.read_dword(ea));
		break;
		}
	case 1957: { // movec y:(r)-n,vba
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_vba(m_y.read_dword(ea));
		break;
		}
	case 1958: { // movec y:(r)-n,sc
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_sc(m_y.read_dword(ea));
		break;
		}
	case 1959: { // movec y:(r)-n,sz
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_sz(m_y.read_dword(ea));
		break;
		}
	case 1960: { // movec y:(r)-n,sr
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_sr(m_y.read_dword(ea));
		break;
		}
	case 1961: { // movec y:(r)-n,omr
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_omr(m_y.read_dword(ea));
		break;
		}
	case 1962: { // movec y:(r)-n,sp
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_sp(m_y.read_dword(ea));
		break;
		}
	case 1963: { // movec y:(r)-n,ssh
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_ssh(m_y.read_dword(ea));
		break;
		}
	case 1964: { // movec y:(r)-n,ssl
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_ssl(m_y.read_dword(ea));
		break;
		}
	case 1965: { // movec y:(r)-n,la
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_la(m_y.read_dword(ea));
		break;
		}
	case 1966: { // movec y:(r)-n,lc
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_lc(m_y.read_dword(ea));
		break;
		}
	case 1967: { // movec x:(r)+n,m
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_m(BIT(opcode, 0, 5) & 7, m_x.read_dword(ea));
		break;
		}
	case 1968: { // movec x:(r)+n,ep
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_ep(m_x.read_dword(ea));
		break;
		}
	case 1969: { // movec x:(r)+n,vba
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_vba(m_x.read_dword(ea));
		break;
		}
	case 1970: { // movec x:(r)+n,sc
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_sc(m_x.read_dword(ea));
		break;
		}
	case 1971: { // movec x:(r)+n,sz
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_sz(m_x.read_dword(ea));
		break;
		}
	case 1972: { // movec x:(r)+n,sr
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_sr(m_x.read_dword(ea));
		break;
		}
	case 1973: { // movec x:(r)+n,omr
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_omr(m_x.read_dword(ea));
		break;
		}
	case 1974: { // movec x:(r)+n,sp
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_sp(m_x.read_dword(ea));
		break;
		}
	case 1975: { // movec x:(r)+n,ssh
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_ssh(m_x.read_dword(ea));
		break;
		}
	case 1976: { // movec x:(r)+n,ssl
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_ssl(m_x.read_dword(ea));
		break;
		}
	case 1977: { // movec x:(r)+n,la
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_la(m_x.read_dword(ea));
		break;
		}
	case 1978: { // movec x:(r)+n,lc
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_lc(m_x.read_dword(ea));
		break;
		}
	case 1979: { // movec y:(r)+n,m
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_m(BIT(opcode, 0, 5) & 7, m_y.read_dword(ea));
		break;
		}
	case 1980: { // movec y:(r)+n,ep
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_ep(m_y.read_dword(ea));
		break;
		}
	case 1981: { // movec y:(r)+n,vba
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_vba(m_y.read_dword(ea));
		break;
		}
	case 1982: { // movec y:(r)+n,sc
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_sc(m_y.read_dword(ea));
		break;
		}
	case 1983: { // movec y:(r)+n,sz
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_sz(m_y.read_dword(ea));
		break;
		}
	case 1984: { // movec y:(r)+n,sr
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_sr(m_y.read_dword(ea));
		break;
		}
	case 1985: { // movec y:(r)+n,omr
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_omr(m_y.read_dword(ea));
		break;
		}
	case 1986: { // movec y:(r)+n,sp
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_sp(m_y.read_dword(ea));
		break;
		}
	case 1987: { // movec y:(r)+n,ssh
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_ssh(m_y.read_dword(ea));
		break;
		}
	case 1988: { // movec y:(r)+n,ssl
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_ssl(m_y.read_dword(ea));
		break;
		}
	case 1989: { // movec y:(r)+n,la
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_la(m_y.read_dword(ea));
		break;
		}
	case 1990: { // movec y:(r)+n,lc
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_lc(m_y.read_dword(ea));
		break;
		}
	case 1991: { // movec x:(r)-,m
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_m(BIT(opcode, 0, 5) & 7, m_x.read_dword(ea));
		break;
		}
	case 1992: { // movec x:(r)-,ep
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_ep(m_x.read_dword(ea));
		break;
		}
	case 1993: { // movec x:(r)-,vba
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_vba(m_x.read_dword(ea));
		break;
		}
	case 1994: { // movec x:(r)-,sc
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_sc(m_x.read_dword(ea));
		break;
		}
	case 1995: { // movec x:(r)-,sz
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_sz(m_x.read_dword(ea));
		break;
		}
	case 1996: { // movec x:(r)-,sr
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_sr(m_x.read_dword(ea));
		break;
		}
	case 1997: { // movec x:(r)-,omr
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_omr(m_x.read_dword(ea));
		break;
		}
	case 1998: { // movec x:(r)-,sp
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_sp(m_x.read_dword(ea));
		break;
		}
	case 1999: { // movec x:(r)-,ssh
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_ssh(m_x.read_dword(ea));
		break;
		}
	case 2000: { // movec x:(r)-,ssl
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_ssl(m_x.read_dword(ea));
		break;
		}
	case 2001: { // movec x:(r)-,la
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_la(m_x.read_dword(ea));
		break;
		}
	case 2002: { // movec x:(r)-,lc
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_lc(m_x.read_dword(ea));
		break;
		}
	case 2003: { // movec y:(r)-,m
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_m(BIT(opcode, 0, 5) & 7, m_y.read_dword(ea));
		break;
		}
	case 2004: { // movec y:(r)-,ep
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_ep(m_y.read_dword(ea));
		break;
		}
	case 2005: { // movec y:(r)-,vba
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_vba(m_y.read_dword(ea));
		break;
		}
	case 2006: { // movec y:(r)-,sc
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_sc(m_y.read_dword(ea));
		break;
		}
	case 2007: { // movec y:(r)-,sz
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_sz(m_y.read_dword(ea));
		break;
		}
	case 2008: { // movec y:(r)-,sr
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_sr(m_y.read_dword(ea));
		break;
		}
	case 2009: { // movec y:(r)-,omr
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_omr(m_y.read_dword(ea));
		break;
		}
	case 2010: { // movec y:(r)-,sp
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_sp(m_y.read_dword(ea));
		break;
		}
	case 2011: { // movec y:(r)-,ssh
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_ssh(m_y.read_dword(ea));
		break;
		}
	case 2012: { // movec y:(r)-,ssl
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_ssl(m_y.read_dword(ea));
		break;
		}
	case 2013: { // movec y:(r)-,la
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_la(m_y.read_dword(ea));
		break;
		}
	case 2014: { // movec y:(r)-,lc
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_lc(m_y.read_dword(ea));
		break;
		}
	case 2015: { // movec x:(r)+,m
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_m(BIT(opcode, 0, 5) & 7, m_x.read_dword(ea));
		break;
		}
	case 2016: { // movec x:(r)+,ep
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_ep(m_x.read_dword(ea));
		break;
		}
	case 2017: { // movec x:(r)+,vba
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_vba(m_x.read_dword(ea));
		break;
		}
	case 2018: { // movec x:(r)+,sc
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_sc(m_x.read_dword(ea));
		break;
		}
	case 2019: { // movec x:(r)+,sz
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_sz(m_x.read_dword(ea));
		break;
		}
	case 2020: { // movec x:(r)+,sr
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_sr(m_x.read_dword(ea));
		break;
		}
	case 2021: { // movec x:(r)+,omr
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_omr(m_x.read_dword(ea));
		break;
		}
	case 2022: { // movec x:(r)+,sp
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_sp(m_x.read_dword(ea));
		break;
		}
	case 2023: { // movec x:(r)+,ssh
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_ssh(m_x.read_dword(ea));
		break;
		}
	case 2024: { // movec x:(r)+,ssl
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_ssl(m_x.read_dword(ea));
		break;
		}
	case 2025: { // movec x:(r)+,la
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_la(m_x.read_dword(ea));
		break;
		}
	case 2026: { // movec x:(r)+,lc
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_lc(m_x.read_dword(ea));
		break;
		}
	case 2027: { // movec y:(r)+,m
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_m(BIT(opcode, 0, 5) & 7, m_y.read_dword(ea));
		break;
		}
	case 2028: { // movec y:(r)+,ep
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_ep(m_y.read_dword(ea));
		break;
		}
	case 2029: { // movec y:(r)+,vba
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_vba(m_y.read_dword(ea));
		break;
		}
	case 2030: { // movec y:(r)+,sc
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_sc(m_y.read_dword(ea));
		break;
		}
	case 2031: { // movec y:(r)+,sz
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_sz(m_y.read_dword(ea));
		break;
		}
	case 2032: { // movec y:(r)+,sr
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_sr(m_y.read_dword(ea));
		break;
		}
	case 2033: { // movec y:(r)+,omr
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_omr(m_y.read_dword(ea));
		break;
		}
	case 2034: { // movec y:(r)+,sp
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_sp(m_y.read_dword(ea));
		break;
		}
	case 2035: { // movec y:(r)+,ssh
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_ssh(m_y.read_dword(ea));
		break;
		}
	case 2036: { // movec y:(r)+,ssl
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_ssl(m_y.read_dword(ea));
		break;
		}
	case 2037: { // movec y:(r)+,la
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_la(m_y.read_dword(ea));
		break;
		}
	case 2038: { // movec y:(r)+,lc
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_lc(m_y.read_dword(ea));
		break;
		}
	case 2039: { // movec x:(r),m
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_m(BIT(opcode, 0, 5) & 7, m_x.read_dword(ea));
		break;
		}
	case 2040: { // movec x:(r),ep
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_ep(m_x.read_dword(ea));
		break;
		}
	case 2041: { // movec x:(r),vba
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_vba(m_x.read_dword(ea));
		break;
		}
	case 2042: { // movec x:(r),sc
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_sc(m_x.read_dword(ea));
		break;
		}
	case 2043: { // movec x:(r),sz
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_sz(m_x.read_dword(ea));
		break;
		}
	case 2044: { // movec x:(r),sr
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_sr(m_x.read_dword(ea));
		break;
		}
	case 2045: { // movec x:(r),omr
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_omr(m_x.read_dword(ea));
		break;
		}
	case 2046: { // movec x:(r),sp
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_sp(m_x.read_dword(ea));
		break;
		}
	case 2047: { // movec x:(r),ssh
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_ssh(m_x.read_dword(ea));
		break;
		}
	case 2048: { // movec x:(r),ssl
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_ssl(m_x.read_dword(ea));
		break;
		}
	case 2049: { // movec x:(r),la
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_la(m_x.read_dword(ea));
		break;
		}
	case 2050: { // movec x:(r),lc
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_lc(m_x.read_dword(ea));
		break;
		}
	case 2051: { // movec y:(r),m
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_m(BIT(opcode, 0, 5) & 7, m_y.read_dword(ea));
		break;
		}
	case 2052: { // movec y:(r),ep
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_ep(m_y.read_dword(ea));
		break;
		}
	case 2053: { // movec y:(r),vba
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_vba(m_y.read_dword(ea));
		break;
		}
	case 2054: { // movec y:(r),sc
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_sc(m_y.read_dword(ea));
		break;
		}
	case 2055: { // movec y:(r),sz
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_sz(m_y.read_dword(ea));
		break;
		}
	case 2056: { // movec y:(r),sr
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_sr(m_y.read_dword(ea));
		break;
		}
	case 2057: { // movec y:(r),omr
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_omr(m_y.read_dword(ea));
		break;
		}
	case 2058: { // movec y:(r),sp
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_sp(m_y.read_dword(ea));
		break;
		}
	case 2059: { // movec y:(r),ssh
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_ssh(m_y.read_dword(ea));
		break;
		}
	case 2060: { // movec y:(r),ssl
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_ssl(m_y.read_dword(ea));
		break;
		}
	case 2061: { // movec y:(r),la
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_la(m_y.read_dword(ea));
		break;
		}
	case 2062: { // movec y:(r),lc
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_lc(m_y.read_dword(ea));
		break;
		}
	case 2063: { // movec x:(r+n),m
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_m(BIT(opcode, 0, 5) & 7, m_x.read_dword(ea));
		break;
		}
	case 2064: { // movec x:(r+n),ep
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_ep(m_x.read_dword(ea));
		break;
		}
	case 2065: { // movec x:(r+n),vba
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_vba(m_x.read_dword(ea));
		break;
		}
	case 2066: { // movec x:(r+n),sc
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_sc(m_x.read_dword(ea));
		break;
		}
	case 2067: { // movec x:(r+n),sz
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_sz(m_x.read_dword(ea));
		break;
		}
	case 2068: { // movec x:(r+n),sr
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_sr(m_x.read_dword(ea));
		break;
		}
	case 2069: { // movec x:(r+n),omr
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_omr(m_x.read_dword(ea));
		break;
		}
	case 2070: { // movec x:(r+n),sp
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_sp(m_x.read_dword(ea));
		break;
		}
	case 2071: { // movec x:(r+n),ssh
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_ssh(m_x.read_dword(ea));
		break;
		}
	case 2072: { // movec x:(r+n),ssl
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_ssl(m_x.read_dword(ea));
		break;
		}
	case 2073: { // movec x:(r+n),la
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_la(m_x.read_dword(ea));
		break;
		}
	case 2074: { // movec x:(r+n),lc
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_lc(m_x.read_dword(ea));
		break;
		}
	case 2075: { // movec y:(r+n),m
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_m(BIT(opcode, 0, 5) & 7, m_y.read_dword(ea));
		break;
		}
	case 2076: { // movec y:(r+n),ep
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_ep(m_y.read_dword(ea));
		break;
		}
	case 2077: { // movec y:(r+n),vba
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_vba(m_y.read_dword(ea));
		break;
		}
	case 2078: { // movec y:(r+n),sc
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_sc(m_y.read_dword(ea));
		break;
		}
	case 2079: { // movec y:(r+n),sz
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_sz(m_y.read_dword(ea));
		break;
		}
	case 2080: { // movec y:(r+n),sr
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_sr(m_y.read_dword(ea));
		break;
		}
	case 2081: { // movec y:(r+n),omr
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_omr(m_y.read_dword(ea));
		break;
		}
	case 2082: { // movec y:(r+n),sp
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_sp(m_y.read_dword(ea));
		break;
		}
	case 2083: { // movec y:(r+n),ssh
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_ssh(m_y.read_dword(ea));
		break;
		}
	case 2084: { // movec y:(r+n),ssl
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_ssl(m_y.read_dword(ea));
		break;
		}
	case 2085: { // movec y:(r+n),la
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_la(m_y.read_dword(ea));
		break;
		}
	case 2086: { // movec y:(r+n),lc
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_lc(m_y.read_dword(ea));
		break;
		}
	case 2087: { // movec x:-(r),m
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_m(BIT(opcode, 0, 5) & 7, m_x.read_dword(ea));
		break;
		}
	case 2088: { // movec x:-(r),ep
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_ep(m_x.read_dword(ea));
		break;
		}
	case 2089: { // movec x:-(r),vba
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_vba(m_x.read_dword(ea));
		break;
		}
	case 2090: { // movec x:-(r),sc
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_sc(m_x.read_dword(ea));
		break;
		}
	case 2091: { // movec x:-(r),sz
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_sz(m_x.read_dword(ea));
		break;
		}
	case 2092: { // movec x:-(r),sr
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_sr(m_x.read_dword(ea));
		break;
		}
	case 2093: { // movec x:-(r),omr
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_omr(m_x.read_dword(ea));
		break;
		}
	case 2094: { // movec x:-(r),sp
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_sp(m_x.read_dword(ea));
		break;
		}
	case 2095: { // movec x:-(r),ssh
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_ssh(m_x.read_dword(ea));
		break;
		}
	case 2096: { // movec x:-(r),ssl
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_ssl(m_x.read_dword(ea));
		break;
		}
	case 2097: { // movec x:-(r),la
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_la(m_x.read_dword(ea));
		break;
		}
	case 2098: { // movec x:-(r),lc
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_lc(m_x.read_dword(ea));
		break;
		}
	case 2099: { // movec y:-(r),m
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_m(BIT(opcode, 0, 5) & 7, m_y.read_dword(ea));
		break;
		}
	case 2100: { // movec y:-(r),ep
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_ep(m_y.read_dword(ea));
		break;
		}
	case 2101: { // movec y:-(r),vba
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_vba(m_y.read_dword(ea));
		break;
		}
	case 2102: { // movec y:-(r),sc
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_sc(m_y.read_dword(ea));
		break;
		}
	case 2103: { // movec y:-(r),sz
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_sz(m_y.read_dword(ea));
		break;
		}
	case 2104: { // movec y:-(r),sr
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_sr(m_y.read_dword(ea));
		break;
		}
	case 2105: { // movec y:-(r),omr
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_omr(m_y.read_dword(ea));
		break;
		}
	case 2106: { // movec y:-(r),sp
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_sp(m_y.read_dword(ea));
		break;
		}
	case 2107: { // movec y:-(r),ssh
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_ssh(m_y.read_dword(ea));
		break;
		}
	case 2108: { // movec y:-(r),ssl
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_ssl(m_y.read_dword(ea));
		break;
		}
	case 2109: { // movec y:-(r),la
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_la(m_y.read_dword(ea));
		break;
		}
	case 2110: { // movec y:-(r),lc
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_lc(m_y.read_dword(ea));
		break;
		}
	case 2111: { // movec m,x:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s1 = get_m(BIT(opcode, 0, 5) & 7);
		m_x.write_dword(ea, s1);
		break;
		}
	case 2112: { // movec ep,x:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s1 = get_ep();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2113: { // movec vba,x:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s1 = get_vba();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2114: { // movec sc,x:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s1 = get_sc();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2115: { // movec sz,x:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s1 = get_sz();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2116: { // movec sr,x:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s1 = get_sr();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2117: { // movec omr,x:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s1 = get_omr();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2118: { // movec sp,x:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s1 = get_sp();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2119: { // movec ssh,x:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s1 = get_ssh();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2120: { // movec ssl,x:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s1 = get_ssl();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2121: { // movec la,x:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s1 = get_la();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2122: { // movec lc,x:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s1 = get_lc();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2123: { // movec m,y:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s1 = get_m(BIT(opcode, 0, 5) & 7);
		m_y.write_dword(ea, s1);
		break;
		}
	case 2124: { // movec ep,y:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s1 = get_ep();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2125: { // movec vba,y:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s1 = get_vba();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2126: { // movec sc,y:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s1 = get_sc();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2127: { // movec sz,y:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s1 = get_sz();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2128: { // movec sr,y:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s1 = get_sr();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2129: { // movec omr,y:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s1 = get_omr();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2130: { // movec sp,y:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s1 = get_sp();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2131: { // movec ssh,y:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s1 = get_ssh();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2132: { // movec ssl,y:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s1 = get_ssl();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2133: { // movec la,y:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s1 = get_la();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2134: { // movec lc,y:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s1 = get_lc();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2135: { // movec m,x:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s1 = get_m(BIT(opcode, 0, 5) & 7);
		m_x.write_dword(ea, s1);
		break;
		}
	case 2136: { // movec ep,x:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s1 = get_ep();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2137: { // movec vba,x:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s1 = get_vba();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2138: { // movec sc,x:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s1 = get_sc();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2139: { // movec sz,x:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s1 = get_sz();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2140: { // movec sr,x:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s1 = get_sr();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2141: { // movec omr,x:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s1 = get_omr();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2142: { // movec sp,x:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s1 = get_sp();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2143: { // movec ssh,x:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s1 = get_ssh();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2144: { // movec ssl,x:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s1 = get_ssl();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2145: { // movec la,x:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s1 = get_la();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2146: { // movec lc,x:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s1 = get_lc();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2147: { // movec m,y:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s1 = get_m(BIT(opcode, 0, 5) & 7);
		m_y.write_dword(ea, s1);
		break;
		}
	case 2148: { // movec ep,y:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s1 = get_ep();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2149: { // movec vba,y:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s1 = get_vba();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2150: { // movec sc,y:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s1 = get_sc();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2151: { // movec sz,y:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s1 = get_sz();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2152: { // movec sr,y:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s1 = get_sr();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2153: { // movec omr,y:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s1 = get_omr();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2154: { // movec sp,y:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s1 = get_sp();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2155: { // movec ssh,y:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s1 = get_ssh();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2156: { // movec ssl,y:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s1 = get_ssl();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2157: { // movec la,y:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s1 = get_la();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2158: { // movec lc,y:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s1 = get_lc();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2159: { // movec m,x:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s1 = get_m(BIT(opcode, 0, 5) & 7);
		m_x.write_dword(ea, s1);
		break;
		}
	case 2160: { // movec ep,x:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s1 = get_ep();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2161: { // movec vba,x:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s1 = get_vba();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2162: { // movec sc,x:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s1 = get_sc();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2163: { // movec sz,x:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s1 = get_sz();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2164: { // movec sr,x:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s1 = get_sr();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2165: { // movec omr,x:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s1 = get_omr();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2166: { // movec sp,x:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s1 = get_sp();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2167: { // movec ssh,x:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s1 = get_ssh();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2168: { // movec ssl,x:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s1 = get_ssl();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2169: { // movec la,x:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s1 = get_la();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2170: { // movec lc,x:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s1 = get_lc();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2171: { // movec m,y:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s1 = get_m(BIT(opcode, 0, 5) & 7);
		m_y.write_dword(ea, s1);
		break;
		}
	case 2172: { // movec ep,y:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s1 = get_ep();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2173: { // movec vba,y:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s1 = get_vba();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2174: { // movec sc,y:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s1 = get_sc();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2175: { // movec sz,y:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s1 = get_sz();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2176: { // movec sr,y:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s1 = get_sr();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2177: { // movec omr,y:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s1 = get_omr();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2178: { // movec sp,y:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s1 = get_sp();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2179: { // movec ssh,y:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s1 = get_ssh();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2180: { // movec ssl,y:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s1 = get_ssl();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2181: { // movec la,y:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s1 = get_la();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2182: { // movec lc,y:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s1 = get_lc();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2183: { // movec m,x:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 s1 = get_m(BIT(opcode, 0, 5) & 7);
		m_x.write_dword(ea, s1);
		break;
		}
	case 2184: { // movec ep,x:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 s1 = get_ep();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2185: { // movec vba,x:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 s1 = get_vba();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2186: { // movec sc,x:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 s1 = get_sc();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2187: { // movec sz,x:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 s1 = get_sz();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2188: { // movec sr,x:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 s1 = get_sr();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2189: { // movec omr,x:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 s1 = get_omr();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2190: { // movec sp,x:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 s1 = get_sp();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2191: { // movec ssh,x:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 s1 = get_ssh();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2192: { // movec ssl,x:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 s1 = get_ssl();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2193: { // movec la,x:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 s1 = get_la();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2194: { // movec lc,x:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 s1 = get_lc();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2195: { // movec m,y:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 s1 = get_m(BIT(opcode, 0, 5) & 7);
		m_y.write_dword(ea, s1);
		break;
		}
	case 2196: { // movec ep,y:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 s1 = get_ep();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2197: { // movec vba,y:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 s1 = get_vba();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2198: { // movec sc,y:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 s1 = get_sc();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2199: { // movec sz,y:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 s1 = get_sz();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2200: { // movec sr,y:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 s1 = get_sr();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2201: { // movec omr,y:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 s1 = get_omr();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2202: { // movec sp,y:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 s1 = get_sp();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2203: { // movec ssh,y:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 s1 = get_ssh();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2204: { // movec ssl,y:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 s1 = get_ssl();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2205: { // movec la,y:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 s1 = get_la();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2206: { // movec lc,y:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 s1 = get_lc();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2207: { // movec m,x:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		u32 s1 = get_m(BIT(opcode, 0, 5) & 7);
		m_x.write_dword(ea, s1);
		break;
		}
	case 2208: { // movec ep,x:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		u32 s1 = get_ep();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2209: { // movec vba,x:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		u32 s1 = get_vba();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2210: { // movec sc,x:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		u32 s1 = get_sc();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2211: { // movec sz,x:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		u32 s1 = get_sz();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2212: { // movec sr,x:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		u32 s1 = get_sr();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2213: { // movec omr,x:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		u32 s1 = get_omr();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2214: { // movec sp,x:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		u32 s1 = get_sp();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2215: { // movec ssh,x:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		u32 s1 = get_ssh();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2216: { // movec ssl,x:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		u32 s1 = get_ssl();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2217: { // movec la,x:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		u32 s1 = get_la();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2218: { // movec lc,x:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		u32 s1 = get_lc();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2219: { // movec m,y:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		u32 s1 = get_m(BIT(opcode, 0, 5) & 7);
		m_y.write_dword(ea, s1);
		break;
		}
	case 2220: { // movec ep,y:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		u32 s1 = get_ep();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2221: { // movec vba,y:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		u32 s1 = get_vba();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2222: { // movec sc,y:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		u32 s1 = get_sc();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2223: { // movec sz,y:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		u32 s1 = get_sz();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2224: { // movec sr,y:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		u32 s1 = get_sr();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2225: { // movec omr,y:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		u32 s1 = get_omr();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2226: { // movec sp,y:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		u32 s1 = get_sp();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2227: { // movec ssh,y:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		u32 s1 = get_ssh();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2228: { // movec ssl,y:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		u32 s1 = get_ssl();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2229: { // movec la,y:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		u32 s1 = get_la();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2230: { // movec lc,y:(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		u32 s1 = get_lc();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2231: { // movec m,x:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		u32 s1 = get_m(BIT(opcode, 0, 5) & 7);
		m_x.write_dword(ea, s1);
		break;
		}
	case 2232: { // movec ep,x:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		u32 s1 = get_ep();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2233: { // movec vba,x:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		u32 s1 = get_vba();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2234: { // movec sc,x:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		u32 s1 = get_sc();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2235: { // movec sz,x:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		u32 s1 = get_sz();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2236: { // movec sr,x:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		u32 s1 = get_sr();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2237: { // movec omr,x:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		u32 s1 = get_omr();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2238: { // movec sp,x:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		u32 s1 = get_sp();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2239: { // movec ssh,x:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		u32 s1 = get_ssh();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2240: { // movec ssl,x:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		u32 s1 = get_ssl();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2241: { // movec la,x:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		u32 s1 = get_la();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2242: { // movec lc,x:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		u32 s1 = get_lc();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2243: { // movec m,y:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		u32 s1 = get_m(BIT(opcode, 0, 5) & 7);
		m_y.write_dword(ea, s1);
		break;
		}
	case 2244: { // movec ep,y:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		u32 s1 = get_ep();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2245: { // movec vba,y:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		u32 s1 = get_vba();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2246: { // movec sc,y:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		u32 s1 = get_sc();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2247: { // movec sz,y:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		u32 s1 = get_sz();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2248: { // movec sr,y:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		u32 s1 = get_sr();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2249: { // movec omr,y:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		u32 s1 = get_omr();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2250: { // movec sp,y:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		u32 s1 = get_sp();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2251: { // movec ssh,y:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		u32 s1 = get_ssh();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2252: { // movec ssl,y:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		u32 s1 = get_ssl();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2253: { // movec la,y:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		u32 s1 = get_la();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2254: { // movec lc,y:(r+n)
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		u32 s1 = get_lc();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2255: { // movec m,x:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		u32 s1 = get_m(BIT(opcode, 0, 5) & 7);
		m_x.write_dword(ea, s1);
		break;
		}
	case 2256: { // movec ep,x:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		u32 s1 = get_ep();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2257: { // movec vba,x:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		u32 s1 = get_vba();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2258: { // movec sc,x:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		u32 s1 = get_sc();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2259: { // movec sz,x:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		u32 s1 = get_sz();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2260: { // movec sr,x:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		u32 s1 = get_sr();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2261: { // movec omr,x:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		u32 s1 = get_omr();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2262: { // movec sp,x:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		u32 s1 = get_sp();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2263: { // movec ssh,x:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		u32 s1 = get_ssh();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2264: { // movec ssl,x:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		u32 s1 = get_ssl();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2265: { // movec la,x:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		u32 s1 = get_la();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2266: { // movec lc,x:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		u32 s1 = get_lc();
		m_x.write_dword(ea, s1);
		break;
		}
	case 2267: { // movec m,y:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		u32 s1 = get_m(BIT(opcode, 0, 5) & 7);
		m_y.write_dword(ea, s1);
		break;
		}
	case 2268: { // movec ep,y:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		u32 s1 = get_ep();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2269: { // movec vba,y:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		u32 s1 = get_vba();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2270: { // movec sc,y:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		u32 s1 = get_sc();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2271: { // movec sz,y:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		u32 s1 = get_sz();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2272: { // movec sr,y:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		u32 s1 = get_sr();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2273: { // movec omr,y:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		u32 s1 = get_omr();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2274: { // movec sp,y:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		u32 s1 = get_sp();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2275: { // movec ssh,y:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		u32 s1 = get_ssh();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2276: { // movec ssl,y:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		u32 s1 = get_ssl();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2277: { // movec la,y:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		u32 s1 = get_la();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2278: { // movec lc,y:-(r)
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		u32 s1 = get_lc();
		m_y.write_dword(ea, s1);
		break;
		}
	case 2279: { // movec x:[abs],m
		u32 abs = exv;
		set_m(BIT(opcode, 0, 5) & 7, m_x.read_dword(abs));
		break;
		}
	case 2280: { // movec x:[abs],ep
		u32 abs = exv;
		set_ep(m_x.read_dword(abs));
		break;
		}
	case 2281: { // movec x:[abs],vba
		u32 abs = exv;
		set_vba(m_x.read_dword(abs));
		break;
		}
	case 2282: { // movec x:[abs],sc
		u32 abs = exv;
		set_sc(m_x.read_dword(abs));
		break;
		}
	case 2283: { // movec x:[abs],sz
		u32 abs = exv;
		set_sz(m_x.read_dword(abs));
		break;
		}
	case 2284: { // movec x:[abs],sr
		u32 abs = exv;
		set_sr(m_x.read_dword(abs));
		break;
		}
	case 2285: { // movec x:[abs],omr
		u32 abs = exv;
		set_omr(m_x.read_dword(abs));
		break;
		}
	case 2286: { // movec x:[abs],sp
		u32 abs = exv;
		set_sp(m_x.read_dword(abs));
		break;
		}
	case 2287: { // movec x:[abs],ssh
		u32 abs = exv;
		set_ssh(m_x.read_dword(abs));
		break;
		}
	case 2288: { // movec x:[abs],ssl
		u32 abs = exv;
		set_ssl(m_x.read_dword(abs));
		break;
		}
	case 2289: { // movec x:[abs],la
		u32 abs = exv;
		set_la(m_x.read_dword(abs));
		break;
		}
	case 2290: { // movec x:[abs],lc
		u32 abs = exv;
		set_lc(m_x.read_dword(abs));
		break;
		}
	case 2291: { // movec y:[abs],m
		u32 abs = exv;
		set_m(BIT(opcode, 0, 5) & 7, m_y.read_dword(abs));
		break;
		}
	case 2292: { // movec y:[abs],ep
		u32 abs = exv;
		set_ep(m_y.read_dword(abs));
		break;
		}
	case 2293: { // movec y:[abs],vba
		u32 abs = exv;
		set_vba(m_y.read_dword(abs));
		break;
		}
	case 2294: { // movec y:[abs],sc
		u32 abs = exv;
		set_sc(m_y.read_dword(abs));
		break;
		}
	case 2295: { // movec y:[abs],sz
		u32 abs = exv;
		set_sz(m_y.read_dword(abs));
		break;
		}
	case 2296: { // movec y:[abs],sr
		u32 abs = exv;
		set_sr(m_y.read_dword(abs));
		break;
		}
	case 2297: { // movec y:[abs],omr
		u32 abs = exv;
		set_omr(m_y.read_dword(abs));
		break;
		}
	case 2298: { // movec y:[abs],sp
		u32 abs = exv;
		set_sp(m_y.read_dword(abs));
		break;
		}
	case 2299: { // movec y:[abs],ssh
		u32 abs = exv;
		set_ssh(m_y.read_dword(abs));
		break;
		}
	case 2300: { // movec y:[abs],ssl
		u32 abs = exv;
		set_ssl(m_y.read_dword(abs));
		break;
		}
	case 2301: { // movec y:[abs],la
		u32 abs = exv;
		set_la(m_y.read_dword(abs));
		break;
		}
	case 2302: { // movec y:[abs],lc
		u32 abs = exv;
		set_lc(m_y.read_dword(abs));
		break;
		}
	case 2303: { // movec #[i],m
		u32 i = exv;
		set_m(BIT(opcode, 0, 5) & 7, i);
		break;
		}
	case 2304: { // movec #[i],ep
		u32 i = exv;
		set_ep(i);
		break;
		}
	case 2305: { // movec #[i],vba
		u32 i = exv;
		set_vba(i);
		break;
		}
	case 2306: { // movec #[i],sc
		u32 i = exv;
		set_sc(i);
		break;
		}
	case 2307: { // movec #[i],sz
		u32 i = exv;
		set_sz(i);
		break;
		}
	case 2308: { // movec #[i],sr
		u32 i = exv;
		set_sr(i);
		break;
		}
	case 2309: { // movec #[i],omr
		u32 i = exv;
		set_omr(i);
		break;
		}
	case 2310: { // movec #[i],sp
		u32 i = exv;
		set_sp(i);
		break;
		}
	case 2311: { // movec #[i],ssh
		u32 i = exv;
		set_ssh(i);
		break;
		}
	case 2312: { // movec #[i],ssl
		u32 i = exv;
		set_ssl(i);
		break;
		}
	case 2313: { // movec #[i],la
		u32 i = exv;
		set_la(i);
		break;
		}
	case 2314: { // movec #[i],lc
		u32 i = exv;
		set_lc(i);
		break;
		}
	case 2315: { // movec m,x:[abs]
		u32 abs = exv;
		u32 s1 = get_m(BIT(opcode, 0, 5) & 7);
		m_x.write_dword(abs, s1);
		break;
		}
	case 2316: { // movec ep,x:[abs]
		u32 abs = exv;
		u32 s1 = get_ep();
		m_x.write_dword(abs, s1);
		break;
		}
	case 2317: { // movec vba,x:[abs]
		u32 abs = exv;
		u32 s1 = get_vba();
		m_x.write_dword(abs, s1);
		break;
		}
	case 2318: { // movec sc,x:[abs]
		u32 abs = exv;
		u32 s1 = get_sc();
		m_x.write_dword(abs, s1);
		break;
		}
	case 2319: { // movec sz,x:[abs]
		u32 abs = exv;
		u32 s1 = get_sz();
		m_x.write_dword(abs, s1);
		break;
		}
	case 2320: { // movec sr,x:[abs]
		u32 abs = exv;
		u32 s1 = get_sr();
		m_x.write_dword(abs, s1);
		break;
		}
	case 2321: { // movec omr,x:[abs]
		u32 abs = exv;
		u32 s1 = get_omr();
		m_x.write_dword(abs, s1);
		break;
		}
	case 2322: { // movec sp,x:[abs]
		u32 abs = exv;
		u32 s1 = get_sp();
		m_x.write_dword(abs, s1);
		break;
		}
	case 2323: { // movec ssh,x:[abs]
		u32 abs = exv;
		u32 s1 = get_ssh();
		m_x.write_dword(abs, s1);
		break;
		}
	case 2324: { // movec ssl,x:[abs]
		u32 abs = exv;
		u32 s1 = get_ssl();
		m_x.write_dword(abs, s1);
		break;
		}
	case 2325: { // movec la,x:[abs]
		u32 abs = exv;
		u32 s1 = get_la();
		m_x.write_dword(abs, s1);
		break;
		}
	case 2326: { // movec lc,x:[abs]
		u32 abs = exv;
		u32 s1 = get_lc();
		m_x.write_dword(abs, s1);
		break;
		}
	case 2327: { // movec m,y:[abs]
		u32 abs = exv;
		u32 s1 = get_m(BIT(opcode, 0, 5) & 7);
		m_y.write_dword(abs, s1);
		break;
		}
	case 2328: { // movec ep,y:[abs]
		u32 abs = exv;
		u32 s1 = get_ep();
		m_y.write_dword(abs, s1);
		break;
		}
	case 2329: { // movec vba,y:[abs]
		u32 abs = exv;
		u32 s1 = get_vba();
		m_y.write_dword(abs, s1);
		break;
		}
	case 2330: { // movec sc,y:[abs]
		u32 abs = exv;
		u32 s1 = get_sc();
		m_y.write_dword(abs, s1);
		break;
		}
	case 2331: { // movec sz,y:[abs]
		u32 abs = exv;
		u32 s1 = get_sz();
		m_y.write_dword(abs, s1);
		break;
		}
	case 2332: { // movec sr,y:[abs]
		u32 abs = exv;
		u32 s1 = get_sr();
		m_y.write_dword(abs, s1);
		break;
		}
	case 2333: { // movec omr,y:[abs]
		u32 abs = exv;
		u32 s1 = get_omr();
		m_y.write_dword(abs, s1);
		break;
		}
	case 2334: { // movec sp,y:[abs]
		u32 abs = exv;
		u32 s1 = get_sp();
		m_y.write_dword(abs, s1);
		break;
		}
	case 2335: { // movec ssh,y:[abs]
		u32 abs = exv;
		u32 s1 = get_ssh();
		m_y.write_dword(abs, s1);
		break;
		}
	case 2336: { // movec ssl,y:[abs]
		u32 abs = exv;
		u32 s1 = get_ssl();
		m_y.write_dword(abs, s1);
		break;
		}
	case 2337: { // movec la,y:[abs]
		u32 abs = exv;
		u32 s1 = get_la();
		m_y.write_dword(abs, s1);
		break;
		}
	case 2338: { // movec lc,y:[abs]
		u32 abs = exv;
		u32 s1 = get_lc();
		m_y.write_dword(abs, s1);
		break;
		}
	case 2339: { // movec x:[aa],m
		u32 aa = BIT(opcode, 8, 6);
		set_m(BIT(opcode, 0, 5) & 7, m_x.read_dword(aa));
		break;
		}
	case 2340: { // movec x:[aa],ep
		u32 aa = BIT(opcode, 8, 6);
		set_ep(m_x.read_dword(aa));
		break;
		}
	case 2341: { // movec x:[aa],vba
		u32 aa = BIT(opcode, 8, 6);
		set_vba(m_x.read_dword(aa));
		break;
		}
	case 2342: { // movec x:[aa],sc
		u32 aa = BIT(opcode, 8, 6);
		set_sc(m_x.read_dword(aa));
		break;
		}
	case 2343: { // movec x:[aa],sz
		u32 aa = BIT(opcode, 8, 6);
		set_sz(m_x.read_dword(aa));
		break;
		}
	case 2344: { // movec x:[aa],sr
		u32 aa = BIT(opcode, 8, 6);
		set_sr(m_x.read_dword(aa));
		break;
		}
	case 2345: { // movec x:[aa],omr
		u32 aa = BIT(opcode, 8, 6);
		set_omr(m_x.read_dword(aa));
		break;
		}
	case 2346: { // movec x:[aa],sp
		u32 aa = BIT(opcode, 8, 6);
		set_sp(m_x.read_dword(aa));
		break;
		}
	case 2347: { // movec x:[aa],ssh
		u32 aa = BIT(opcode, 8, 6);
		set_ssh(m_x.read_dword(aa));
		break;
		}
	case 2348: { // movec x:[aa],ssl
		u32 aa = BIT(opcode, 8, 6);
		set_ssl(m_x.read_dword(aa));
		break;
		}
	case 2349: { // movec x:[aa],la
		u32 aa = BIT(opcode, 8, 6);
		set_la(m_x.read_dword(aa));
		break;
		}
	case 2350: { // movec x:[aa],lc
		u32 aa = BIT(opcode, 8, 6);
		set_lc(m_x.read_dword(aa));
		break;
		}
	case 2351: { // movec y:[aa],m
		u32 aa = BIT(opcode, 8, 6);
		set_m(BIT(opcode, 0, 5) & 7, m_y.read_dword(aa));
		break;
		}
	case 2352: { // movec y:[aa],ep
		u32 aa = BIT(opcode, 8, 6);
		set_ep(m_y.read_dword(aa));
		break;
		}
	case 2353: { // movec y:[aa],vba
		u32 aa = BIT(opcode, 8, 6);
		set_vba(m_y.read_dword(aa));
		break;
		}
	case 2354: { // movec y:[aa],sc
		u32 aa = BIT(opcode, 8, 6);
		set_sc(m_y.read_dword(aa));
		break;
		}
	case 2355: { // movec y:[aa],sz
		u32 aa = BIT(opcode, 8, 6);
		set_sz(m_y.read_dword(aa));
		break;
		}
	case 2356: { // movec y:[aa],sr
		u32 aa = BIT(opcode, 8, 6);
		set_sr(m_y.read_dword(aa));
		break;
		}
	case 2357: { // movec y:[aa],omr
		u32 aa = BIT(opcode, 8, 6);
		set_omr(m_y.read_dword(aa));
		break;
		}
	case 2358: { // movec y:[aa],sp
		u32 aa = BIT(opcode, 8, 6);
		set_sp(m_y.read_dword(aa));
		break;
		}
	case 2359: { // movec y:[aa],ssh
		u32 aa = BIT(opcode, 8, 6);
		set_ssh(m_y.read_dword(aa));
		break;
		}
	case 2360: { // movec y:[aa],ssl
		u32 aa = BIT(opcode, 8, 6);
		set_ssl(m_y.read_dword(aa));
		break;
		}
	case 2361: { // movec y:[aa],la
		u32 aa = BIT(opcode, 8, 6);
		set_la(m_y.read_dword(aa));
		break;
		}
	case 2362: { // movec y:[aa],lc
		u32 aa = BIT(opcode, 8, 6);
		set_lc(m_y.read_dword(aa));
		break;
		}
	case 2363: { // movec m,x:[aa]
		u32 aa = BIT(opcode, 8, 6);
		u32 s1 = get_m(BIT(opcode, 0, 5) & 7);
		m_x.write_dword(aa, s1);
		break;
		}
	case 2364: { // movec ep,x:[aa]
		u32 aa = BIT(opcode, 8, 6);
		u32 s1 = get_ep();
		m_x.write_dword(aa, s1);
		break;
		}
	case 2365: { // movec vba,x:[aa]
		u32 aa = BIT(opcode, 8, 6);
		u32 s1 = get_vba();
		m_x.write_dword(aa, s1);
		break;
		}
	case 2366: { // movec sc,x:[aa]
		u32 aa = BIT(opcode, 8, 6);
		u32 s1 = get_sc();
		m_x.write_dword(aa, s1);
		break;
		}
	case 2367: { // movec sz,x:[aa]
		u32 aa = BIT(opcode, 8, 6);
		u32 s1 = get_sz();
		m_x.write_dword(aa, s1);
		break;
		}
	case 2368: { // movec sr,x:[aa]
		u32 aa = BIT(opcode, 8, 6);
		u32 s1 = get_sr();
		m_x.write_dword(aa, s1);
		break;
		}
	case 2369: { // movec omr,x:[aa]
		u32 aa = BIT(opcode, 8, 6);
		u32 s1 = get_omr();
		m_x.write_dword(aa, s1);
		break;
		}
	case 2370: { // movec sp,x:[aa]
		u32 aa = BIT(opcode, 8, 6);
		u32 s1 = get_sp();
		m_x.write_dword(aa, s1);
		break;
		}
	case 2371: { // movec ssh,x:[aa]
		u32 aa = BIT(opcode, 8, 6);
		u32 s1 = get_ssh();
		m_x.write_dword(aa, s1);
		break;
		}
	case 2372: { // movec ssl,x:[aa]
		u32 aa = BIT(opcode, 8, 6);
		u32 s1 = get_ssl();
		m_x.write_dword(aa, s1);
		break;
		}
	case 2373: { // movec la,x:[aa]
		u32 aa = BIT(opcode, 8, 6);
		u32 s1 = get_la();
		m_x.write_dword(aa, s1);
		break;
		}
	case 2374: { // movec lc,x:[aa]
		u32 aa = BIT(opcode, 8, 6);
		u32 s1 = get_lc();
		m_x.write_dword(aa, s1);
		break;
		}
	case 2375: { // movec m,y:[aa]
		u32 aa = BIT(opcode, 8, 6);
		u32 s1 = get_m(BIT(opcode, 0, 5) & 7);
		m_y.write_dword(aa, s1);
		break;
		}
	case 2376: { // movec ep,y:[aa]
		u32 aa = BIT(opcode, 8, 6);
		u32 s1 = get_ep();
		m_y.write_dword(aa, s1);
		break;
		}
	case 2377: { // movec vba,y:[aa]
		u32 aa = BIT(opcode, 8, 6);
		u32 s1 = get_vba();
		m_y.write_dword(aa, s1);
		break;
		}
	case 2378: { // movec sc,y:[aa]
		u32 aa = BIT(opcode, 8, 6);
		u32 s1 = get_sc();
		m_y.write_dword(aa, s1);
		break;
		}
	case 2379: { // movec sz,y:[aa]
		u32 aa = BIT(opcode, 8, 6);
		u32 s1 = get_sz();
		m_y.write_dword(aa, s1);
		break;
		}
	case 2380: { // movec sr,y:[aa]
		u32 aa = BIT(opcode, 8, 6);
		u32 s1 = get_sr();
		m_y.write_dword(aa, s1);
		break;
		}
	case 2381: { // movec omr,y:[aa]
		u32 aa = BIT(opcode, 8, 6);
		u32 s1 = get_omr();
		m_y.write_dword(aa, s1);
		break;
		}
	case 2382: { // movec sp,y:[aa]
		u32 aa = BIT(opcode, 8, 6);
		u32 s1 = get_sp();
		m_y.write_dword(aa, s1);
		break;
		}
	case 2383: { // movec ssh,y:[aa]
		u32 aa = BIT(opcode, 8, 6);
		u32 s1 = get_ssh();
		m_y.write_dword(aa, s1);
		break;
		}
	case 2384: { // movec ssl,y:[aa]
		u32 aa = BIT(opcode, 8, 6);
		u32 s1 = get_ssl();
		m_y.write_dword(aa, s1);
		break;
		}
	case 2385: { // movec la,y:[aa]
		u32 aa = BIT(opcode, 8, 6);
		u32 s1 = get_la();
		m_y.write_dword(aa, s1);
		break;
		}
	case 2386: { // movec lc,y:[aa]
		u32 aa = BIT(opcode, 8, 6);
		u32 s1 = get_lc();
		m_y.write_dword(aa, s1);
		break;
		}
	case 2387: { // movec x0,m
		u32 s2 = get_x0();
		set_m(BIT(opcode, 0, 5) & 7, s2);
		break;
		}
	case 2388: { // movec x0,ep
		u32 s2 = get_x0();
		set_ep(s2);
		break;
		}
	case 2389: { // movec x0,vba
		u32 s2 = get_x0();
		set_vba(s2);
		break;
		}
	case 2390: { // movec x0,sc
		u32 s2 = get_x0();
		set_sc(s2);
		break;
		}
	case 2391: { // movec x0,sz
		u32 s2 = get_x0();
		set_sz(s2);
		break;
		}
	case 2392: { // movec x0,sr
		u32 s2 = get_x0();
		set_sr(s2);
		break;
		}
	case 2393: { // movec x0,omr
		u32 s2 = get_x0();
		set_omr(s2);
		break;
		}
	case 2394: { // movec x0,sp
		u32 s2 = get_x0();
		set_sp(s2);
		break;
		}
	case 2395: { // movec x0,ssh
		u32 s2 = get_x0();
		set_ssh(s2);
		break;
		}
	case 2396: { // movec x0,ssl
		u32 s2 = get_x0();
		set_ssl(s2);
		break;
		}
	case 2397: { // movec x0,la
		u32 s2 = get_x0();
		set_la(s2);
		break;
		}
	case 2398: { // movec x0,lc
		u32 s2 = get_x0();
		set_lc(s2);
		break;
		}
	case 2399: { // movec x1,m
		u32 s2 = get_x1();
		set_m(BIT(opcode, 0, 5) & 7, s2);
		break;
		}
	case 2400: { // movec x1,ep
		u32 s2 = get_x1();
		set_ep(s2);
		break;
		}
	case 2401: { // movec x1,vba
		u32 s2 = get_x1();
		set_vba(s2);
		break;
		}
	case 2402: { // movec x1,sc
		u32 s2 = get_x1();
		set_sc(s2);
		break;
		}
	case 2403: { // movec x1,sz
		u32 s2 = get_x1();
		set_sz(s2);
		break;
		}
	case 2404: { // movec x1,sr
		u32 s2 = get_x1();
		set_sr(s2);
		break;
		}
	case 2405: { // movec x1,omr
		u32 s2 = get_x1();
		set_omr(s2);
		break;
		}
	case 2406: { // movec x1,sp
		u32 s2 = get_x1();
		set_sp(s2);
		break;
		}
	case 2407: { // movec x1,ssh
		u32 s2 = get_x1();
		set_ssh(s2);
		break;
		}
	case 2408: { // movec x1,ssl
		u32 s2 = get_x1();
		set_ssl(s2);
		break;
		}
	case 2409: { // movec x1,la
		u32 s2 = get_x1();
		set_la(s2);
		break;
		}
	case 2410: { // movec x1,lc
		u32 s2 = get_x1();
		set_lc(s2);
		break;
		}
	case 2411: { // movec y0,m
		u32 s2 = get_y0();
		set_m(BIT(opcode, 0, 5) & 7, s2);
		break;
		}
	case 2412: { // movec y0,ep
		u32 s2 = get_y0();
		set_ep(s2);
		break;
		}
	case 2413: { // movec y0,vba
		u32 s2 = get_y0();
		set_vba(s2);
		break;
		}
	case 2414: { // movec y0,sc
		u32 s2 = get_y0();
		set_sc(s2);
		break;
		}
	case 2415: { // movec y0,sz
		u32 s2 = get_y0();
		set_sz(s2);
		break;
		}
	case 2416: { // movec y0,sr
		u32 s2 = get_y0();
		set_sr(s2);
		break;
		}
	case 2417: { // movec y0,omr
		u32 s2 = get_y0();
		set_omr(s2);
		break;
		}
	case 2418: { // movec y0,sp
		u32 s2 = get_y0();
		set_sp(s2);
		break;
		}
	case 2419: { // movec y0,ssh
		u32 s2 = get_y0();
		set_ssh(s2);
		break;
		}
	case 2420: { // movec y0,ssl
		u32 s2 = get_y0();
		set_ssl(s2);
		break;
		}
	case 2421: { // movec y0,la
		u32 s2 = get_y0();
		set_la(s2);
		break;
		}
	case 2422: { // movec y0,lc
		u32 s2 = get_y0();
		set_lc(s2);
		break;
		}
	case 2423: { // movec y1,m
		u32 s2 = get_y1();
		set_m(BIT(opcode, 0, 5) & 7, s2);
		break;
		}
	case 2424: { // movec y1,ep
		u32 s2 = get_y1();
		set_ep(s2);
		break;
		}
	case 2425: { // movec y1,vba
		u32 s2 = get_y1();
		set_vba(s2);
		break;
		}
	case 2426: { // movec y1,sc
		u32 s2 = get_y1();
		set_sc(s2);
		break;
		}
	case 2427: { // movec y1,sz
		u32 s2 = get_y1();
		set_sz(s2);
		break;
		}
	case 2428: { // movec y1,sr
		u32 s2 = get_y1();
		set_sr(s2);
		break;
		}
	case 2429: { // movec y1,omr
		u32 s2 = get_y1();
		set_omr(s2);
		break;
		}
	case 2430: { // movec y1,sp
		u32 s2 = get_y1();
		set_sp(s2);
		break;
		}
	case 2431: { // movec y1,ssh
		u32 s2 = get_y1();
		set_ssh(s2);
		break;
		}
	case 2432: { // movec y1,ssl
		u32 s2 = get_y1();
		set_ssl(s2);
		break;
		}
	case 2433: { // movec y1,la
		u32 s2 = get_y1();
		set_la(s2);
		break;
		}
	case 2434: { // movec y1,lc
		u32 s2 = get_y1();
		set_lc(s2);
		break;
		}
	case 2435: { // movec a0,m
		u32 s2 = get_a0();
		set_m(BIT(opcode, 0, 5) & 7, s2);
		break;
		}
	case 2436: { // movec a0,ep
		u32 s2 = get_a0();
		set_ep(s2);
		break;
		}
	case 2437: { // movec a0,vba
		u32 s2 = get_a0();
		set_vba(s2);
		break;
		}
	case 2438: { // movec a0,sc
		u32 s2 = get_a0();
		set_sc(s2);
		break;
		}
	case 2439: { // movec a0,sz
		u32 s2 = get_a0();
		set_sz(s2);
		break;
		}
	case 2440: { // movec a0,sr
		u32 s2 = get_a0();
		set_sr(s2);
		break;
		}
	case 2441: { // movec a0,omr
		u32 s2 = get_a0();
		set_omr(s2);
		break;
		}
	case 2442: { // movec a0,sp
		u32 s2 = get_a0();
		set_sp(s2);
		break;
		}
	case 2443: { // movec a0,ssh
		u32 s2 = get_a0();
		set_ssh(s2);
		break;
		}
	case 2444: { // movec a0,ssl
		u32 s2 = get_a0();
		set_ssl(s2);
		break;
		}
	case 2445: { // movec a0,la
		u32 s2 = get_a0();
		set_la(s2);
		break;
		}
	case 2446: { // movec a0,lc
		u32 s2 = get_a0();
		set_lc(s2);
		break;
		}
	case 2447: { // movec b0,m
		u32 s2 = get_b0();
		set_m(BIT(opcode, 0, 5) & 7, s2);
		break;
		}
	case 2448: { // movec b0,ep
		u32 s2 = get_b0();
		set_ep(s2);
		break;
		}
	case 2449: { // movec b0,vba
		u32 s2 = get_b0();
		set_vba(s2);
		break;
		}
	case 2450: { // movec b0,sc
		u32 s2 = get_b0();
		set_sc(s2);
		break;
		}
	case 2451: { // movec b0,sz
		u32 s2 = get_b0();
		set_sz(s2);
		break;
		}
	case 2452: { // movec b0,sr
		u32 s2 = get_b0();
		set_sr(s2);
		break;
		}
	case 2453: { // movec b0,omr
		u32 s2 = get_b0();
		set_omr(s2);
		break;
		}
	case 2454: { // movec b0,sp
		u32 s2 = get_b0();
		set_sp(s2);
		break;
		}
	case 2455: { // movec b0,ssh
		u32 s2 = get_b0();
		set_ssh(s2);
		break;
		}
	case 2456: { // movec b0,ssl
		u32 s2 = get_b0();
		set_ssl(s2);
		break;
		}
	case 2457: { // movec b0,la
		u32 s2 = get_b0();
		set_la(s2);
		break;
		}
	case 2458: { // movec b0,lc
		u32 s2 = get_b0();
		set_lc(s2);
		break;
		}
	case 2459: { // movec a2,m
		u32 s2 = get_a2();
		set_m(BIT(opcode, 0, 5) & 7, s2);
		break;
		}
	case 2460: { // movec a2,ep
		u32 s2 = get_a2();
		set_ep(s2);
		break;
		}
	case 2461: { // movec a2,vba
		u32 s2 = get_a2();
		set_vba(s2);
		break;
		}
	case 2462: { // movec a2,sc
		u32 s2 = get_a2();
		set_sc(s2);
		break;
		}
	case 2463: { // movec a2,sz
		u32 s2 = get_a2();
		set_sz(s2);
		break;
		}
	case 2464: { // movec a2,sr
		u32 s2 = get_a2();
		set_sr(s2);
		break;
		}
	case 2465: { // movec a2,omr
		u32 s2 = get_a2();
		set_omr(s2);
		break;
		}
	case 2466: { // movec a2,sp
		u32 s2 = get_a2();
		set_sp(s2);
		break;
		}
	case 2467: { // movec a2,ssh
		u32 s2 = get_a2();
		set_ssh(s2);
		break;
		}
	case 2468: { // movec a2,ssl
		u32 s2 = get_a2();
		set_ssl(s2);
		break;
		}
	case 2469: { // movec a2,la
		u32 s2 = get_a2();
		set_la(s2);
		break;
		}
	case 2470: { // movec a2,lc
		u32 s2 = get_a2();
		set_lc(s2);
		break;
		}
	case 2471: { // movec b2,m
		u32 s2 = get_b2();
		set_m(BIT(opcode, 0, 5) & 7, s2);
		break;
		}
	case 2472: { // movec b2,ep
		u32 s2 = get_b2();
		set_ep(s2);
		break;
		}
	case 2473: { // movec b2,vba
		u32 s2 = get_b2();
		set_vba(s2);
		break;
		}
	case 2474: { // movec b2,sc
		u32 s2 = get_b2();
		set_sc(s2);
		break;
		}
	case 2475: { // movec b2,sz
		u32 s2 = get_b2();
		set_sz(s2);
		break;
		}
	case 2476: { // movec b2,sr
		u32 s2 = get_b2();
		set_sr(s2);
		break;
		}
	case 2477: { // movec b2,omr
		u32 s2 = get_b2();
		set_omr(s2);
		break;
		}
	case 2478: { // movec b2,sp
		u32 s2 = get_b2();
		set_sp(s2);
		break;
		}
	case 2479: { // movec b2,ssh
		u32 s2 = get_b2();
		set_ssh(s2);
		break;
		}
	case 2480: { // movec b2,ssl
		u32 s2 = get_b2();
		set_ssl(s2);
		break;
		}
	case 2481: { // movec b2,la
		u32 s2 = get_b2();
		set_la(s2);
		break;
		}
	case 2482: { // movec b2,lc
		u32 s2 = get_b2();
		set_lc(s2);
		break;
		}
	case 2483: { // movec a1,m
		u32 s2 = get_a1();
		set_m(BIT(opcode, 0, 5) & 7, s2);
		break;
		}
	case 2484: { // movec a1,ep
		u32 s2 = get_a1();
		set_ep(s2);
		break;
		}
	case 2485: { // movec a1,vba
		u32 s2 = get_a1();
		set_vba(s2);
		break;
		}
	case 2486: { // movec a1,sc
		u32 s2 = get_a1();
		set_sc(s2);
		break;
		}
	case 2487: { // movec a1,sz
		u32 s2 = get_a1();
		set_sz(s2);
		break;
		}
	case 2488: { // movec a1,sr
		u32 s2 = get_a1();
		set_sr(s2);
		break;
		}
	case 2489: { // movec a1,omr
		u32 s2 = get_a1();
		set_omr(s2);
		break;
		}
	case 2490: { // movec a1,sp
		u32 s2 = get_a1();
		set_sp(s2);
		break;
		}
	case 2491: { // movec a1,ssh
		u32 s2 = get_a1();
		set_ssh(s2);
		break;
		}
	case 2492: { // movec a1,ssl
		u32 s2 = get_a1();
		set_ssl(s2);
		break;
		}
	case 2493: { // movec a1,la
		u32 s2 = get_a1();
		set_la(s2);
		break;
		}
	case 2494: { // movec a1,lc
		u32 s2 = get_a1();
		set_lc(s2);
		break;
		}
	case 2495: { // movec b1,m
		u32 s2 = get_b1();
		set_m(BIT(opcode, 0, 5) & 7, s2);
		break;
		}
	case 2496: { // movec b1,ep
		u32 s2 = get_b1();
		set_ep(s2);
		break;
		}
	case 2497: { // movec b1,vba
		u32 s2 = get_b1();
		set_vba(s2);
		break;
		}
	case 2498: { // movec b1,sc
		u32 s2 = get_b1();
		set_sc(s2);
		break;
		}
	case 2499: { // movec b1,sz
		u32 s2 = get_b1();
		set_sz(s2);
		break;
		}
	case 2500: { // movec b1,sr
		u32 s2 = get_b1();
		set_sr(s2);
		break;
		}
	case 2501: { // movec b1,omr
		u32 s2 = get_b1();
		set_omr(s2);
		break;
		}
	case 2502: { // movec b1,sp
		u32 s2 = get_b1();
		set_sp(s2);
		break;
		}
	case 2503: { // movec b1,ssh
		u32 s2 = get_b1();
		set_ssh(s2);
		break;
		}
	case 2504: { // movec b1,ssl
		u32 s2 = get_b1();
		set_ssl(s2);
		break;
		}
	case 2505: { // movec b1,la
		u32 s2 = get_b1();
		set_la(s2);
		break;
		}
	case 2506: { // movec b1,lc
		u32 s2 = get_b1();
		set_lc(s2);
		break;
		}
	case 2507: { // movec a,m
		u64 s2 = get_a();
		set_m(BIT(opcode, 0, 5) & 7, s2);
		break;
		}
	case 2508: { // movec a,ep
		u64 s2 = get_a();
		set_ep(s2);
		break;
		}
	case 2509: { // movec a,vba
		u64 s2 = get_a();
		set_vba(s2);
		break;
		}
	case 2510: { // movec a,sc
		u64 s2 = get_a();
		set_sc(s2);
		break;
		}
	case 2511: { // movec a,sz
		u64 s2 = get_a();
		set_sz(s2);
		break;
		}
	case 2512: { // movec a,sr
		u64 s2 = get_a();
		set_sr(s2);
		break;
		}
	case 2513: { // movec a,omr
		u64 s2 = get_a();
		set_omr(s2);
		break;
		}
	case 2514: { // movec a,sp
		u64 s2 = get_a();
		set_sp(s2);
		break;
		}
	case 2515: { // movec a,ssh
		u64 s2 = get_a();
		set_ssh(s2);
		break;
		}
	case 2516: { // movec a,ssl
		u64 s2 = get_a();
		set_ssl(s2);
		break;
		}
	case 2517: { // movec a,la
		u64 s2 = get_a();
		set_la(s2);
		break;
		}
	case 2518: { // movec a,lc
		u64 s2 = get_a();
		set_lc(s2);
		break;
		}
	case 2519: { // movec b,m
		u64 s2 = get_b();
		set_m(BIT(opcode, 0, 5) & 7, s2);
		break;
		}
	case 2520: { // movec b,ep
		u64 s2 = get_b();
		set_ep(s2);
		break;
		}
	case 2521: { // movec b,vba
		u64 s2 = get_b();
		set_vba(s2);
		break;
		}
	case 2522: { // movec b,sc
		u64 s2 = get_b();
		set_sc(s2);
		break;
		}
	case 2523: { // movec b,sz
		u64 s2 = get_b();
		set_sz(s2);
		break;
		}
	case 2524: { // movec b,sr
		u64 s2 = get_b();
		set_sr(s2);
		break;
		}
	case 2525: { // movec b,omr
		u64 s2 = get_b();
		set_omr(s2);
		break;
		}
	case 2526: { // movec b,sp
		u64 s2 = get_b();
		set_sp(s2);
		break;
		}
	case 2527: { // movec b,ssh
		u64 s2 = get_b();
		set_ssh(s2);
		break;
		}
	case 2528: { // movec b,ssl
		u64 s2 = get_b();
		set_ssl(s2);
		break;
		}
	case 2529: { // movec b,la
		u64 s2 = get_b();
		set_la(s2);
		break;
		}
	case 2530: { // movec b,lc
		u64 s2 = get_b();
		set_lc(s2);
		break;
		}
	case 2531: { // movec r,m
		u32 s2 = get_r(BIT(opcode, 8, 6) & 7);
		set_m(BIT(opcode, 0, 5) & 7, s2);
		break;
		}
	case 2532: { // movec r,ep
		u32 s2 = get_r(BIT(opcode, 8, 6) & 7);
		set_ep(s2);
		break;
		}
	case 2533: { // movec r,vba
		u32 s2 = get_r(BIT(opcode, 8, 6) & 7);
		set_vba(s2);
		break;
		}
	case 2534: { // movec r,sc
		u32 s2 = get_r(BIT(opcode, 8, 6) & 7);
		set_sc(s2);
		break;
		}
	case 2535: { // movec r,sz
		u32 s2 = get_r(BIT(opcode, 8, 6) & 7);
		set_sz(s2);
		break;
		}
	case 2536: { // movec r,sr
		u32 s2 = get_r(BIT(opcode, 8, 6) & 7);
		set_sr(s2);
		break;
		}
	case 2537: { // movec r,omr
		u32 s2 = get_r(BIT(opcode, 8, 6) & 7);
		set_omr(s2);
		break;
		}
	case 2538: { // movec r,sp
		u32 s2 = get_r(BIT(opcode, 8, 6) & 7);
		set_sp(s2);
		break;
		}
	case 2539: { // movec r,ssh
		u32 s2 = get_r(BIT(opcode, 8, 6) & 7);
		set_ssh(s2);
		break;
		}
	case 2540: { // movec r,ssl
		u32 s2 = get_r(BIT(opcode, 8, 6) & 7);
		set_ssl(s2);
		break;
		}
	case 2541: { // movec r,la
		u32 s2 = get_r(BIT(opcode, 8, 6) & 7);
		set_la(s2);
		break;
		}
	case 2542: { // movec r,lc
		u32 s2 = get_r(BIT(opcode, 8, 6) & 7);
		set_lc(s2);
		break;
		}
	case 2543: { // movec n,m
		u32 s2 = get_n(BIT(opcode, 8, 6) & 7);
		set_m(BIT(opcode, 0, 5) & 7, s2);
		break;
		}
	case 2544: { // movec n,ep
		u32 s2 = get_n(BIT(opcode, 8, 6) & 7);
		set_ep(s2);
		break;
		}
	case 2545: { // movec n,vba
		u32 s2 = get_n(BIT(opcode, 8, 6) & 7);
		set_vba(s2);
		break;
		}
	case 2546: { // movec n,sc
		u32 s2 = get_n(BIT(opcode, 8, 6) & 7);
		set_sc(s2);
		break;
		}
	case 2547: { // movec n,sz
		u32 s2 = get_n(BIT(opcode, 8, 6) & 7);
		set_sz(s2);
		break;
		}
	case 2548: { // movec n,sr
		u32 s2 = get_n(BIT(opcode, 8, 6) & 7);
		set_sr(s2);
		break;
		}
	case 2549: { // movec n,omr
		u32 s2 = get_n(BIT(opcode, 8, 6) & 7);
		set_omr(s2);
		break;
		}
	case 2550: { // movec n,sp
		u32 s2 = get_n(BIT(opcode, 8, 6) & 7);
		set_sp(s2);
		break;
		}
	case 2551: { // movec n,ssh
		u32 s2 = get_n(BIT(opcode, 8, 6) & 7);
		set_ssh(s2);
		break;
		}
	case 2552: { // movec n,ssl
		u32 s2 = get_n(BIT(opcode, 8, 6) & 7);
		set_ssl(s2);
		break;
		}
	case 2553: { // movec n,la
		u32 s2 = get_n(BIT(opcode, 8, 6) & 7);
		set_la(s2);
		break;
		}
	case 2554: { // movec n,lc
		u32 s2 = get_n(BIT(opcode, 8, 6) & 7);
		set_lc(s2);
		break;
		}
	case 2555: { // movec m,m
		u32 s2 = get_m(BIT(opcode, 8, 6) & 7);
		set_m(BIT(opcode, 0, 5) & 7, s2);
		break;
		}
	case 2556: { // movec m,ep
		u32 s2 = get_m(BIT(opcode, 8, 6) & 7);
		set_ep(s2);
		break;
		}
	case 2557: { // movec m,vba
		u32 s2 = get_m(BIT(opcode, 8, 6) & 7);
		set_vba(s2);
		break;
		}
	case 2558: { // movec m,sc
		u32 s2 = get_m(BIT(opcode, 8, 6) & 7);
		set_sc(s2);
		break;
		}
	case 2559: { // movec m,sz
		u32 s2 = get_m(BIT(opcode, 8, 6) & 7);
		set_sz(s2);
		break;
		}
	case 2560: { // movec m,sr
		u32 s2 = get_m(BIT(opcode, 8, 6) & 7);
		set_sr(s2);
		break;
		}
	case 2561: { // movec m,omr
		u32 s2 = get_m(BIT(opcode, 8, 6) & 7);
		set_omr(s2);
		break;
		}
	case 2562: { // movec m,sp
		u32 s2 = get_m(BIT(opcode, 8, 6) & 7);
		set_sp(s2);
		break;
		}
	case 2563: { // movec m,ssh
		u32 s2 = get_m(BIT(opcode, 8, 6) & 7);
		set_ssh(s2);
		break;
		}
	case 2564: { // movec m,ssl
		u32 s2 = get_m(BIT(opcode, 8, 6) & 7);
		set_ssl(s2);
		break;
		}
	case 2565: { // movec m,la
		u32 s2 = get_m(BIT(opcode, 8, 6) & 7);
		set_la(s2);
		break;
		}
	case 2566: { // movec m,lc
		u32 s2 = get_m(BIT(opcode, 8, 6) & 7);
		set_lc(s2);
		break;
		}
	case 2567: { // movec ep,m
		u32 s2 = get_ep();
		set_m(BIT(opcode, 0, 5) & 7, s2);
		break;
		}
	case 2568: { // movec ep,ep
		u32 s2 = get_ep();
		set_ep(s2);
		break;
		}
	case 2569: { // movec ep,vba
		u32 s2 = get_ep();
		set_vba(s2);
		break;
		}
	case 2570: { // movec ep,sc
		u32 s2 = get_ep();
		set_sc(s2);
		break;
		}
	case 2571: { // movec ep,sz
		u32 s2 = get_ep();
		set_sz(s2);
		break;
		}
	case 2572: { // movec ep,sr
		u32 s2 = get_ep();
		set_sr(s2);
		break;
		}
	case 2573: { // movec ep,omr
		u32 s2 = get_ep();
		set_omr(s2);
		break;
		}
	case 2574: { // movec ep,sp
		u32 s2 = get_ep();
		set_sp(s2);
		break;
		}
	case 2575: { // movec ep,ssh
		u32 s2 = get_ep();
		set_ssh(s2);
		break;
		}
	case 2576: { // movec ep,ssl
		u32 s2 = get_ep();
		set_ssl(s2);
		break;
		}
	case 2577: { // movec ep,la
		u32 s2 = get_ep();
		set_la(s2);
		break;
		}
	case 2578: { // movec ep,lc
		u32 s2 = get_ep();
		set_lc(s2);
		break;
		}
	case 2579: { // movec vba,m
		u32 s2 = get_vba();
		set_m(BIT(opcode, 0, 5) & 7, s2);
		break;
		}
	case 2580: { // movec vba,ep
		u32 s2 = get_vba();
		set_ep(s2);
		break;
		}
	case 2581: { // movec vba,vba
		u32 s2 = get_vba();
		set_vba(s2);
		break;
		}
	case 2582: { // movec vba,sc
		u32 s2 = get_vba();
		set_sc(s2);
		break;
		}
	case 2583: { // movec vba,sz
		u32 s2 = get_vba();
		set_sz(s2);
		break;
		}
	case 2584: { // movec vba,sr
		u32 s2 = get_vba();
		set_sr(s2);
		break;
		}
	case 2585: { // movec vba,omr
		u32 s2 = get_vba();
		set_omr(s2);
		break;
		}
	case 2586: { // movec vba,sp
		u32 s2 = get_vba();
		set_sp(s2);
		break;
		}
	case 2587: { // movec vba,ssh
		u32 s2 = get_vba();
		set_ssh(s2);
		break;
		}
	case 2588: { // movec vba,ssl
		u32 s2 = get_vba();
		set_ssl(s2);
		break;
		}
	case 2589: { // movec vba,la
		u32 s2 = get_vba();
		set_la(s2);
		break;
		}
	case 2590: { // movec vba,lc
		u32 s2 = get_vba();
		set_lc(s2);
		break;
		}
	case 2591: { // movec sc,m
		u32 s2 = get_sc();
		set_m(BIT(opcode, 0, 5) & 7, s2);
		break;
		}
	case 2592: { // movec sc,ep
		u32 s2 = get_sc();
		set_ep(s2);
		break;
		}
	case 2593: { // movec sc,vba
		u32 s2 = get_sc();
		set_vba(s2);
		break;
		}
	case 2594: { // movec sc,sc
		u32 s2 = get_sc();
		set_sc(s2);
		break;
		}
	case 2595: { // movec sc,sz
		u32 s2 = get_sc();
		set_sz(s2);
		break;
		}
	case 2596: { // movec sc,sr
		u32 s2 = get_sc();
		set_sr(s2);
		break;
		}
	case 2597: { // movec sc,omr
		u32 s2 = get_sc();
		set_omr(s2);
		break;
		}
	case 2598: { // movec sc,sp
		u32 s2 = get_sc();
		set_sp(s2);
		break;
		}
	case 2599: { // movec sc,ssh
		u32 s2 = get_sc();
		set_ssh(s2);
		break;
		}
	case 2600: { // movec sc,ssl
		u32 s2 = get_sc();
		set_ssl(s2);
		break;
		}
	case 2601: { // movec sc,la
		u32 s2 = get_sc();
		set_la(s2);
		break;
		}
	case 2602: { // movec sc,lc
		u32 s2 = get_sc();
		set_lc(s2);
		break;
		}
	case 2603: { // movec sz,m
		u32 s2 = get_sz();
		set_m(BIT(opcode, 0, 5) & 7, s2);
		break;
		}
	case 2604: { // movec sz,ep
		u32 s2 = get_sz();
		set_ep(s2);
		break;
		}
	case 2605: { // movec sz,vba
		u32 s2 = get_sz();
		set_vba(s2);
		break;
		}
	case 2606: { // movec sz,sc
		u32 s2 = get_sz();
		set_sc(s2);
		break;
		}
	case 2607: { // movec sz,sz
		u32 s2 = get_sz();
		set_sz(s2);
		break;
		}
	case 2608: { // movec sz,sr
		u32 s2 = get_sz();
		set_sr(s2);
		break;
		}
	case 2609: { // movec sz,omr
		u32 s2 = get_sz();
		set_omr(s2);
		break;
		}
	case 2610: { // movec sz,sp
		u32 s2 = get_sz();
		set_sp(s2);
		break;
		}
	case 2611: { // movec sz,ssh
		u32 s2 = get_sz();
		set_ssh(s2);
		break;
		}
	case 2612: { // movec sz,ssl
		u32 s2 = get_sz();
		set_ssl(s2);
		break;
		}
	case 2613: { // movec sz,la
		u32 s2 = get_sz();
		set_la(s2);
		break;
		}
	case 2614: { // movec sz,lc
		u32 s2 = get_sz();
		set_lc(s2);
		break;
		}
	case 2615: { // movec sr,m
		u32 s2 = get_sr();
		set_m(BIT(opcode, 0, 5) & 7, s2);
		break;
		}
	case 2616: { // movec sr,ep
		u32 s2 = get_sr();
		set_ep(s2);
		break;
		}
	case 2617: { // movec sr,vba
		u32 s2 = get_sr();
		set_vba(s2);
		break;
		}
	case 2618: { // movec sr,sc
		u32 s2 = get_sr();
		set_sc(s2);
		break;
		}
	case 2619: { // movec sr,sz
		u32 s2 = get_sr();
		set_sz(s2);
		break;
		}
	case 2620: { // movec sr,sr
		u32 s2 = get_sr();
		set_sr(s2);
		break;
		}
	case 2621: { // movec sr,omr
		u32 s2 = get_sr();
		set_omr(s2);
		break;
		}
	case 2622: { // movec sr,sp
		u32 s2 = get_sr();
		set_sp(s2);
		break;
		}
	case 2623: { // movec sr,ssh
		u32 s2 = get_sr();
		set_ssh(s2);
		break;
		}
	case 2624: { // movec sr,ssl
		u32 s2 = get_sr();
		set_ssl(s2);
		break;
		}
	case 2625: { // movec sr,la
		u32 s2 = get_sr();
		set_la(s2);
		break;
		}
	case 2626: { // movec sr,lc
		u32 s2 = get_sr();
		set_lc(s2);
		break;
		}
	case 2627: { // movec omr,m
		u32 s2 = get_omr();
		set_m(BIT(opcode, 0, 5) & 7, s2);
		break;
		}
	case 2628: { // movec omr,ep
		u32 s2 = get_omr();
		set_ep(s2);
		break;
		}
	case 2629: { // movec omr,vba
		u32 s2 = get_omr();
		set_vba(s2);
		break;
		}
	case 2630: { // movec omr,sc
		u32 s2 = get_omr();
		set_sc(s2);
		break;
		}
	case 2631: { // movec omr,sz
		u32 s2 = get_omr();
		set_sz(s2);
		break;
		}
	case 2632: { // movec omr,sr
		u32 s2 = get_omr();
		set_sr(s2);
		break;
		}
	case 2633: { // movec omr,omr
		u32 s2 = get_omr();
		set_omr(s2);
		break;
		}
	case 2634: { // movec omr,sp
		u32 s2 = get_omr();
		set_sp(s2);
		break;
		}
	case 2635: { // movec omr,ssh
		u32 s2 = get_omr();
		set_ssh(s2);
		break;
		}
	case 2636: { // movec omr,ssl
		u32 s2 = get_omr();
		set_ssl(s2);
		break;
		}
	case 2637: { // movec omr,la
		u32 s2 = get_omr();
		set_la(s2);
		break;
		}
	case 2638: { // movec omr,lc
		u32 s2 = get_omr();
		set_lc(s2);
		break;
		}
	case 2639: { // movec sp,m
		u32 s2 = get_sp();
		set_m(BIT(opcode, 0, 5) & 7, s2);
		break;
		}
	case 2640: { // movec sp,ep
		u32 s2 = get_sp();
		set_ep(s2);
		break;
		}
	case 2641: { // movec sp,vba
		u32 s2 = get_sp();
		set_vba(s2);
		break;
		}
	case 2642: { // movec sp,sc
		u32 s2 = get_sp();
		set_sc(s2);
		break;
		}
	case 2643: { // movec sp,sz
		u32 s2 = get_sp();
		set_sz(s2);
		break;
		}
	case 2644: { // movec sp,sr
		u32 s2 = get_sp();
		set_sr(s2);
		break;
		}
	case 2645: { // movec sp,omr
		u32 s2 = get_sp();
		set_omr(s2);
		break;
		}
	case 2646: { // movec sp,sp
		u32 s2 = get_sp();
		set_sp(s2);
		break;
		}
	case 2647: { // movec sp,ssh
		u32 s2 = get_sp();
		set_ssh(s2);
		break;
		}
	case 2648: { // movec sp,ssl
		u32 s2 = get_sp();
		set_ssl(s2);
		break;
		}
	case 2649: { // movec sp,la
		u32 s2 = get_sp();
		set_la(s2);
		break;
		}
	case 2650: { // movec sp,lc
		u32 s2 = get_sp();
		set_lc(s2);
		break;
		}
	case 2651: { // movec ssh,m
		u32 s2 = get_ssh();
		set_m(BIT(opcode, 0, 5) & 7, s2);
		break;
		}
	case 2652: { // movec ssh,ep
		u32 s2 = get_ssh();
		set_ep(s2);
		break;
		}
	case 2653: { // movec ssh,vba
		u32 s2 = get_ssh();
		set_vba(s2);
		break;
		}
	case 2654: { // movec ssh,sc
		u32 s2 = get_ssh();
		set_sc(s2);
		break;
		}
	case 2655: { // movec ssh,sz
		u32 s2 = get_ssh();
		set_sz(s2);
		break;
		}
	case 2656: { // movec ssh,sr
		u32 s2 = get_ssh();
		set_sr(s2);
		break;
		}
	case 2657: { // movec ssh,omr
		u32 s2 = get_ssh();
		set_omr(s2);
		break;
		}
	case 2658: { // movec ssh,sp
		u32 s2 = get_ssh();
		set_sp(s2);
		break;
		}
	case 2659: { // movec ssh,ssh
		u32 s2 = get_ssh();
		set_ssh(s2);
		break;
		}
	case 2660: { // movec ssh,ssl
		u32 s2 = get_ssh();
		set_ssl(s2);
		break;
		}
	case 2661: { // movec ssh,la
		u32 s2 = get_ssh();
		set_la(s2);
		break;
		}
	case 2662: { // movec ssh,lc
		u32 s2 = get_ssh();
		set_lc(s2);
		break;
		}
	case 2663: { // movec ssl,m
		u32 s2 = get_ssl();
		set_m(BIT(opcode, 0, 5) & 7, s2);
		break;
		}
	case 2664: { // movec ssl,ep
		u32 s2 = get_ssl();
		set_ep(s2);
		break;
		}
	case 2665: { // movec ssl,vba
		u32 s2 = get_ssl();
		set_vba(s2);
		break;
		}
	case 2666: { // movec ssl,sc
		u32 s2 = get_ssl();
		set_sc(s2);
		break;
		}
	case 2667: { // movec ssl,sz
		u32 s2 = get_ssl();
		set_sz(s2);
		break;
		}
	case 2668: { // movec ssl,sr
		u32 s2 = get_ssl();
		set_sr(s2);
		break;
		}
	case 2669: { // movec ssl,omr
		u32 s2 = get_ssl();
		set_omr(s2);
		break;
		}
	case 2670: { // movec ssl,sp
		u32 s2 = get_ssl();
		set_sp(s2);
		break;
		}
	case 2671: { // movec ssl,ssh
		u32 s2 = get_ssl();
		set_ssh(s2);
		break;
		}
	case 2672: { // movec ssl,ssl
		u32 s2 = get_ssl();
		set_ssl(s2);
		break;
		}
	case 2673: { // movec ssl,la
		u32 s2 = get_ssl();
		set_la(s2);
		break;
		}
	case 2674: { // movec ssl,lc
		u32 s2 = get_ssl();
		set_lc(s2);
		break;
		}
	case 2675: { // movec la,m
		u32 s2 = get_la();
		set_m(BIT(opcode, 0, 5) & 7, s2);
		break;
		}
	case 2676: { // movec la,ep
		u32 s2 = get_la();
		set_ep(s2);
		break;
		}
	case 2677: { // movec la,vba
		u32 s2 = get_la();
		set_vba(s2);
		break;
		}
	case 2678: { // movec la,sc
		u32 s2 = get_la();
		set_sc(s2);
		break;
		}
	case 2679: { // movec la,sz
		u32 s2 = get_la();
		set_sz(s2);
		break;
		}
	case 2680: { // movec la,sr
		u32 s2 = get_la();
		set_sr(s2);
		break;
		}
	case 2681: { // movec la,omr
		u32 s2 = get_la();
		set_omr(s2);
		break;
		}
	case 2682: { // movec la,sp
		u32 s2 = get_la();
		set_sp(s2);
		break;
		}
	case 2683: { // movec la,ssh
		u32 s2 = get_la();
		set_ssh(s2);
		break;
		}
	case 2684: { // movec la,ssl
		u32 s2 = get_la();
		set_ssl(s2);
		break;
		}
	case 2685: { // movec la,la
		u32 s2 = get_la();
		set_la(s2);
		break;
		}
	case 2686: { // movec la,lc
		u32 s2 = get_la();
		set_lc(s2);
		break;
		}
	case 2687: { // movec lc,m
		u32 s2 = get_lc();
		set_m(BIT(opcode, 0, 5) & 7, s2);
		break;
		}
	case 2688: { // movec lc,ep
		u32 s2 = get_lc();
		set_ep(s2);
		break;
		}
	case 2689: { // movec lc,vba
		u32 s2 = get_lc();
		set_vba(s2);
		break;
		}
	case 2690: { // movec lc,sc
		u32 s2 = get_lc();
		set_sc(s2);
		break;
		}
	case 2691: { // movec lc,sz
		u32 s2 = get_lc();
		set_sz(s2);
		break;
		}
	case 2692: { // movec lc,sr
		u32 s2 = get_lc();
		set_sr(s2);
		break;
		}
	case 2693: { // movec lc,omr
		u32 s2 = get_lc();
		set_omr(s2);
		break;
		}
	case 2694: { // movec lc,sp
		u32 s2 = get_lc();
		set_sp(s2);
		break;
		}
	case 2695: { // movec lc,ssh
		u32 s2 = get_lc();
		set_ssh(s2);
		break;
		}
	case 2696: { // movec lc,ssl
		u32 s2 = get_lc();
		set_ssl(s2);
		break;
		}
	case 2697: { // movec lc,la
		u32 s2 = get_lc();
		set_la(s2);
		break;
		}
	case 2698: { // movec lc,lc
		u32 s2 = get_lc();
		set_lc(s2);
		break;
		}
	case 2699: { // movec m,x0
		u32 s1 = get_m(BIT(opcode, 0, 5) & 7);
		set_x0(s1);
		break;
		}
	case 2700: { // movec ep,x0
		u32 s1 = get_ep();
		set_x0(s1);
		break;
		}
	case 2701: { // movec vba,x0
		u32 s1 = get_vba();
		set_x0(s1);
		break;
		}
	case 2702: { // movec sc,x0
		u32 s1 = get_sc();
		set_x0(s1);
		break;
		}
	case 2703: { // movec sz,x0
		u32 s1 = get_sz();
		set_x0(s1);
		break;
		}
	case 2704: { // movec sr,x0
		u32 s1 = get_sr();
		set_x0(s1);
		break;
		}
	case 2705: { // movec omr,x0
		u32 s1 = get_omr();
		set_x0(s1);
		break;
		}
	case 2706: { // movec sp,x0
		u32 s1 = get_sp();
		set_x0(s1);
		break;
		}
	case 2707: { // movec ssh,x0
		u32 s1 = get_ssh();
		set_x0(s1);
		break;
		}
	case 2708: { // movec ssl,x0
		u32 s1 = get_ssl();
		set_x0(s1);
		break;
		}
	case 2709: { // movec la,x0
		u32 s1 = get_la();
		set_x0(s1);
		break;
		}
	case 2710: { // movec lc,x0
		u32 s1 = get_lc();
		set_x0(s1);
		break;
		}
	case 2711: { // movec m,x1
		u32 s1 = get_m(BIT(opcode, 0, 5) & 7);
		set_x1(s1);
		break;
		}
	case 2712: { // movec ep,x1
		u32 s1 = get_ep();
		set_x1(s1);
		break;
		}
	case 2713: { // movec vba,x1
		u32 s1 = get_vba();
		set_x1(s1);
		break;
		}
	case 2714: { // movec sc,x1
		u32 s1 = get_sc();
		set_x1(s1);
		break;
		}
	case 2715: { // movec sz,x1
		u32 s1 = get_sz();
		set_x1(s1);
		break;
		}
	case 2716: { // movec sr,x1
		u32 s1 = get_sr();
		set_x1(s1);
		break;
		}
	case 2717: { // movec omr,x1
		u32 s1 = get_omr();
		set_x1(s1);
		break;
		}
	case 2718: { // movec sp,x1
		u32 s1 = get_sp();
		set_x1(s1);
		break;
		}
	case 2719: { // movec ssh,x1
		u32 s1 = get_ssh();
		set_x1(s1);
		break;
		}
	case 2720: { // movec ssl,x1
		u32 s1 = get_ssl();
		set_x1(s1);
		break;
		}
	case 2721: { // movec la,x1
		u32 s1 = get_la();
		set_x1(s1);
		break;
		}
	case 2722: { // movec lc,x1
		u32 s1 = get_lc();
		set_x1(s1);
		break;
		}
	case 2723: { // movec m,y0
		u32 s1 = get_m(BIT(opcode, 0, 5) & 7);
		set_y0(s1);
		break;
		}
	case 2724: { // movec ep,y0
		u32 s1 = get_ep();
		set_y0(s1);
		break;
		}
	case 2725: { // movec vba,y0
		u32 s1 = get_vba();
		set_y0(s1);
		break;
		}
	case 2726: { // movec sc,y0
		u32 s1 = get_sc();
		set_y0(s1);
		break;
		}
	case 2727: { // movec sz,y0
		u32 s1 = get_sz();
		set_y0(s1);
		break;
		}
	case 2728: { // movec sr,y0
		u32 s1 = get_sr();
		set_y0(s1);
		break;
		}
	case 2729: { // movec omr,y0
		u32 s1 = get_omr();
		set_y0(s1);
		break;
		}
	case 2730: { // movec sp,y0
		u32 s1 = get_sp();
		set_y0(s1);
		break;
		}
	case 2731: { // movec ssh,y0
		u32 s1 = get_ssh();
		set_y0(s1);
		break;
		}
	case 2732: { // movec ssl,y0
		u32 s1 = get_ssl();
		set_y0(s1);
		break;
		}
	case 2733: { // movec la,y0
		u32 s1 = get_la();
		set_y0(s1);
		break;
		}
	case 2734: { // movec lc,y0
		u32 s1 = get_lc();
		set_y0(s1);
		break;
		}
	case 2735: { // movec m,y1
		u32 s1 = get_m(BIT(opcode, 0, 5) & 7);
		set_y1(s1);
		break;
		}
	case 2736: { // movec ep,y1
		u32 s1 = get_ep();
		set_y1(s1);
		break;
		}
	case 2737: { // movec vba,y1
		u32 s1 = get_vba();
		set_y1(s1);
		break;
		}
	case 2738: { // movec sc,y1
		u32 s1 = get_sc();
		set_y1(s1);
		break;
		}
	case 2739: { // movec sz,y1
		u32 s1 = get_sz();
		set_y1(s1);
		break;
		}
	case 2740: { // movec sr,y1
		u32 s1 = get_sr();
		set_y1(s1);
		break;
		}
	case 2741: { // movec omr,y1
		u32 s1 = get_omr();
		set_y1(s1);
		break;
		}
	case 2742: { // movec sp,y1
		u32 s1 = get_sp();
		set_y1(s1);
		break;
		}
	case 2743: { // movec ssh,y1
		u32 s1 = get_ssh();
		set_y1(s1);
		break;
		}
	case 2744: { // movec ssl,y1
		u32 s1 = get_ssl();
		set_y1(s1);
		break;
		}
	case 2745: { // movec la,y1
		u32 s1 = get_la();
		set_y1(s1);
		break;
		}
	case 2746: { // movec lc,y1
		u32 s1 = get_lc();
		set_y1(s1);
		break;
		}
	case 2747: { // movec m,a0
		u32 s1 = get_m(BIT(opcode, 0, 5) & 7);
		set_a0(s1);
		break;
		}
	case 2748: { // movec ep,a0
		u32 s1 = get_ep();
		set_a0(s1);
		break;
		}
	case 2749: { // movec vba,a0
		u32 s1 = get_vba();
		set_a0(s1);
		break;
		}
	case 2750: { // movec sc,a0
		u32 s1 = get_sc();
		set_a0(s1);
		break;
		}
	case 2751: { // movec sz,a0
		u32 s1 = get_sz();
		set_a0(s1);
		break;
		}
	case 2752: { // movec sr,a0
		u32 s1 = get_sr();
		set_a0(s1);
		break;
		}
	case 2753: { // movec omr,a0
		u32 s1 = get_omr();
		set_a0(s1);
		break;
		}
	case 2754: { // movec sp,a0
		u32 s1 = get_sp();
		set_a0(s1);
		break;
		}
	case 2755: { // movec ssh,a0
		u32 s1 = get_ssh();
		set_a0(s1);
		break;
		}
	case 2756: { // movec ssl,a0
		u32 s1 = get_ssl();
		set_a0(s1);
		break;
		}
	case 2757: { // movec la,a0
		u32 s1 = get_la();
		set_a0(s1);
		break;
		}
	case 2758: { // movec lc,a0
		u32 s1 = get_lc();
		set_a0(s1);
		break;
		}
	case 2759: { // movec m,b0
		u32 s1 = get_m(BIT(opcode, 0, 5) & 7);
		set_b0(s1);
		break;
		}
	case 2760: { // movec ep,b0
		u32 s1 = get_ep();
		set_b0(s1);
		break;
		}
	case 2761: { // movec vba,b0
		u32 s1 = get_vba();
		set_b0(s1);
		break;
		}
	case 2762: { // movec sc,b0
		u32 s1 = get_sc();
		set_b0(s1);
		break;
		}
	case 2763: { // movec sz,b0
		u32 s1 = get_sz();
		set_b0(s1);
		break;
		}
	case 2764: { // movec sr,b0
		u32 s1 = get_sr();
		set_b0(s1);
		break;
		}
	case 2765: { // movec omr,b0
		u32 s1 = get_omr();
		set_b0(s1);
		break;
		}
	case 2766: { // movec sp,b0
		u32 s1 = get_sp();
		set_b0(s1);
		break;
		}
	case 2767: { // movec ssh,b0
		u32 s1 = get_ssh();
		set_b0(s1);
		break;
		}
	case 2768: { // movec ssl,b0
		u32 s1 = get_ssl();
		set_b0(s1);
		break;
		}
	case 2769: { // movec la,b0
		u32 s1 = get_la();
		set_b0(s1);
		break;
		}
	case 2770: { // movec lc,b0
		u32 s1 = get_lc();
		set_b0(s1);
		break;
		}
	case 2771: { // movec m,a2
		u32 s1 = get_m(BIT(opcode, 0, 5) & 7);
		set_a2(s1);
		break;
		}
	case 2772: { // movec ep,a2
		u32 s1 = get_ep();
		set_a2(s1);
		break;
		}
	case 2773: { // movec vba,a2
		u32 s1 = get_vba();
		set_a2(s1);
		break;
		}
	case 2774: { // movec sc,a2
		u32 s1 = get_sc();
		set_a2(s1);
		break;
		}
	case 2775: { // movec sz,a2
		u32 s1 = get_sz();
		set_a2(s1);
		break;
		}
	case 2776: { // movec sr,a2
		u32 s1 = get_sr();
		set_a2(s1);
		break;
		}
	case 2777: { // movec omr,a2
		u32 s1 = get_omr();
		set_a2(s1);
		break;
		}
	case 2778: { // movec sp,a2
		u32 s1 = get_sp();
		set_a2(s1);
		break;
		}
	case 2779: { // movec ssh,a2
		u32 s1 = get_ssh();
		set_a2(s1);
		break;
		}
	case 2780: { // movec ssl,a2
		u32 s1 = get_ssl();
		set_a2(s1);
		break;
		}
	case 2781: { // movec la,a2
		u32 s1 = get_la();
		set_a2(s1);
		break;
		}
	case 2782: { // movec lc,a2
		u32 s1 = get_lc();
		set_a2(s1);
		break;
		}
	case 2783: { // movec m,b2
		u32 s1 = get_m(BIT(opcode, 0, 5) & 7);
		set_b2(s1);
		break;
		}
	case 2784: { // movec ep,b2
		u32 s1 = get_ep();
		set_b2(s1);
		break;
		}
	case 2785: { // movec vba,b2
		u32 s1 = get_vba();
		set_b2(s1);
		break;
		}
	case 2786: { // movec sc,b2
		u32 s1 = get_sc();
		set_b2(s1);
		break;
		}
	case 2787: { // movec sz,b2
		u32 s1 = get_sz();
		set_b2(s1);
		break;
		}
	case 2788: { // movec sr,b2
		u32 s1 = get_sr();
		set_b2(s1);
		break;
		}
	case 2789: { // movec omr,b2
		u32 s1 = get_omr();
		set_b2(s1);
		break;
		}
	case 2790: { // movec sp,b2
		u32 s1 = get_sp();
		set_b2(s1);
		break;
		}
	case 2791: { // movec ssh,b2
		u32 s1 = get_ssh();
		set_b2(s1);
		break;
		}
	case 2792: { // movec ssl,b2
		u32 s1 = get_ssl();
		set_b2(s1);
		break;
		}
	case 2793: { // movec la,b2
		u32 s1 = get_la();
		set_b2(s1);
		break;
		}
	case 2794: { // movec lc,b2
		u32 s1 = get_lc();
		set_b2(s1);
		break;
		}
	case 2795: { // movec m,a1
		u32 s1 = get_m(BIT(opcode, 0, 5) & 7);
		set_a1(s1);
		break;
		}
	case 2796: { // movec ep,a1
		u32 s1 = get_ep();
		set_a1(s1);
		break;
		}
	case 2797: { // movec vba,a1
		u32 s1 = get_vba();
		set_a1(s1);
		break;
		}
	case 2798: { // movec sc,a1
		u32 s1 = get_sc();
		set_a1(s1);
		break;
		}
	case 2799: { // movec sz,a1
		u32 s1 = get_sz();
		set_a1(s1);
		break;
		}
	case 2800: { // movec sr,a1
		u32 s1 = get_sr();
		set_a1(s1);
		break;
		}
	case 2801: { // movec omr,a1
		u32 s1 = get_omr();
		set_a1(s1);
		break;
		}
	case 2802: { // movec sp,a1
		u32 s1 = get_sp();
		set_a1(s1);
		break;
		}
	case 2803: { // movec ssh,a1
		u32 s1 = get_ssh();
		set_a1(s1);
		break;
		}
	case 2804: { // movec ssl,a1
		u32 s1 = get_ssl();
		set_a1(s1);
		break;
		}
	case 2805: { // movec la,a1
		u32 s1 = get_la();
		set_a1(s1);
		break;
		}
	case 2806: { // movec lc,a1
		u32 s1 = get_lc();
		set_a1(s1);
		break;
		}
	case 2807: { // movec m,b1
		u32 s1 = get_m(BIT(opcode, 0, 5) & 7);
		set_b1(s1);
		break;
		}
	case 2808: { // movec ep,b1
		u32 s1 = get_ep();
		set_b1(s1);
		break;
		}
	case 2809: { // movec vba,b1
		u32 s1 = get_vba();
		set_b1(s1);
		break;
		}
	case 2810: { // movec sc,b1
		u32 s1 = get_sc();
		set_b1(s1);
		break;
		}
	case 2811: { // movec sz,b1
		u32 s1 = get_sz();
		set_b1(s1);
		break;
		}
	case 2812: { // movec sr,b1
		u32 s1 = get_sr();
		set_b1(s1);
		break;
		}
	case 2813: { // movec omr,b1
		u32 s1 = get_omr();
		set_b1(s1);
		break;
		}
	case 2814: { // movec sp,b1
		u32 s1 = get_sp();
		set_b1(s1);
		break;
		}
	case 2815: { // movec ssh,b1
		u32 s1 = get_ssh();
		set_b1(s1);
		break;
		}
	case 2816: { // movec ssl,b1
		u32 s1 = get_ssl();
		set_b1(s1);
		break;
		}
	case 2817: { // movec la,b1
		u32 s1 = get_la();
		set_b1(s1);
		break;
		}
	case 2818: { // movec lc,b1
		u32 s1 = get_lc();
		set_b1(s1);
		break;
		}
	case 2819: { // movec m,a
		u32 s1 = get_m(BIT(opcode, 0, 5) & 7);
		set_a(s1);
		break;
		}
	case 2820: { // movec ep,a
		u32 s1 = get_ep();
		set_a(s1);
		break;
		}
	case 2821: { // movec vba,a
		u32 s1 = get_vba();
		set_a(s1);
		break;
		}
	case 2822: { // movec sc,a
		u32 s1 = get_sc();
		set_a(s1);
		break;
		}
	case 2823: { // movec sz,a
		u32 s1 = get_sz();
		set_a(s1);
		break;
		}
	case 2824: { // movec sr,a
		u32 s1 = get_sr();
		set_a(s1);
		break;
		}
	case 2825: { // movec omr,a
		u32 s1 = get_omr();
		set_a(s1);
		break;
		}
	case 2826: { // movec sp,a
		u32 s1 = get_sp();
		set_a(s1);
		break;
		}
	case 2827: { // movec ssh,a
		u32 s1 = get_ssh();
		set_a(s1);
		break;
		}
	case 2828: { // movec ssl,a
		u32 s1 = get_ssl();
		set_a(s1);
		break;
		}
	case 2829: { // movec la,a
		u32 s1 = get_la();
		set_a(s1);
		break;
		}
	case 2830: { // movec lc,a
		u32 s1 = get_lc();
		set_a(s1);
		break;
		}
	case 2831: { // movec m,b
		u32 s1 = get_m(BIT(opcode, 0, 5) & 7);
		set_b(s1);
		break;
		}
	case 2832: { // movec ep,b
		u32 s1 = get_ep();
		set_b(s1);
		break;
		}
	case 2833: { // movec vba,b
		u32 s1 = get_vba();
		set_b(s1);
		break;
		}
	case 2834: { // movec sc,b
		u32 s1 = get_sc();
		set_b(s1);
		break;
		}
	case 2835: { // movec sz,b
		u32 s1 = get_sz();
		set_b(s1);
		break;
		}
	case 2836: { // movec sr,b
		u32 s1 = get_sr();
		set_b(s1);
		break;
		}
	case 2837: { // movec omr,b
		u32 s1 = get_omr();
		set_b(s1);
		break;
		}
	case 2838: { // movec sp,b
		u32 s1 = get_sp();
		set_b(s1);
		break;
		}
	case 2839: { // movec ssh,b
		u32 s1 = get_ssh();
		set_b(s1);
		break;
		}
	case 2840: { // movec ssl,b
		u32 s1 = get_ssl();
		set_b(s1);
		break;
		}
	case 2841: { // movec la,b
		u32 s1 = get_la();
		set_b(s1);
		break;
		}
	case 2842: { // movec lc,b
		u32 s1 = get_lc();
		set_b(s1);
		break;
		}
	case 2843: { // movec m,r
		u32 s1 = get_m(BIT(opcode, 0, 5) & 7);
		set_r(BIT(opcode, 8, 6) & 7, s1);
		break;
		}
	case 2844: { // movec ep,r
		u32 s1 = get_ep();
		set_r(BIT(opcode, 8, 6) & 7, s1);
		break;
		}
	case 2845: { // movec vba,r
		u32 s1 = get_vba();
		set_r(BIT(opcode, 8, 6) & 7, s1);
		break;
		}
	case 2846: { // movec sc,r
		u32 s1 = get_sc();
		set_r(BIT(opcode, 8, 6) & 7, s1);
		break;
		}
	case 2847: { // movec sz,r
		u32 s1 = get_sz();
		set_r(BIT(opcode, 8, 6) & 7, s1);
		break;
		}
	case 2848: { // movec sr,r
		u32 s1 = get_sr();
		set_r(BIT(opcode, 8, 6) & 7, s1);
		break;
		}
	case 2849: { // movec omr,r
		u32 s1 = get_omr();
		set_r(BIT(opcode, 8, 6) & 7, s1);
		break;
		}
	case 2850: { // movec sp,r
		u32 s1 = get_sp();
		set_r(BIT(opcode, 8, 6) & 7, s1);
		break;
		}
	case 2851: { // movec ssh,r
		u32 s1 = get_ssh();
		set_r(BIT(opcode, 8, 6) & 7, s1);
		break;
		}
	case 2852: { // movec ssl,r
		u32 s1 = get_ssl();
		set_r(BIT(opcode, 8, 6) & 7, s1);
		break;
		}
	case 2853: { // movec la,r
		u32 s1 = get_la();
		set_r(BIT(opcode, 8, 6) & 7, s1);
		break;
		}
	case 2854: { // movec lc,r
		u32 s1 = get_lc();
		set_r(BIT(opcode, 8, 6) & 7, s1);
		break;
		}
	case 2855: { // movec m,n
		u32 s1 = get_m(BIT(opcode, 0, 5) & 7);
		set_n(BIT(opcode, 8, 6) & 7, s1);
		break;
		}
	case 2856: { // movec ep,n
		u32 s1 = get_ep();
		set_n(BIT(opcode, 8, 6) & 7, s1);
		break;
		}
	case 2857: { // movec vba,n
		u32 s1 = get_vba();
		set_n(BIT(opcode, 8, 6) & 7, s1);
		break;
		}
	case 2858: { // movec sc,n
		u32 s1 = get_sc();
		set_n(BIT(opcode, 8, 6) & 7, s1);
		break;
		}
	case 2859: { // movec sz,n
		u32 s1 = get_sz();
		set_n(BIT(opcode, 8, 6) & 7, s1);
		break;
		}
	case 2860: { // movec sr,n
		u32 s1 = get_sr();
		set_n(BIT(opcode, 8, 6) & 7, s1);
		break;
		}
	case 2861: { // movec omr,n
		u32 s1 = get_omr();
		set_n(BIT(opcode, 8, 6) & 7, s1);
		break;
		}
	case 2862: { // movec sp,n
		u32 s1 = get_sp();
		set_n(BIT(opcode, 8, 6) & 7, s1);
		break;
		}
	case 2863: { // movec ssh,n
		u32 s1 = get_ssh();
		set_n(BIT(opcode, 8, 6) & 7, s1);
		break;
		}
	case 2864: { // movec ssl,n
		u32 s1 = get_ssl();
		set_n(BIT(opcode, 8, 6) & 7, s1);
		break;
		}
	case 2865: { // movec la,n
		u32 s1 = get_la();
		set_n(BIT(opcode, 8, 6) & 7, s1);
		break;
		}
	case 2866: { // movec lc,n
		u32 s1 = get_lc();
		set_n(BIT(opcode, 8, 6) & 7, s1);
		break;
		}
	case 2867: { // movec m,m
		u32 s1 = get_m(BIT(opcode, 0, 5) & 7);
		set_m(BIT(opcode, 8, 6) & 7, s1);
		break;
		}
	case 2868: { // movec ep,m
		u32 s1 = get_ep();
		set_m(BIT(opcode, 8, 6) & 7, s1);
		break;
		}
	case 2869: { // movec vba,m
		u32 s1 = get_vba();
		set_m(BIT(opcode, 8, 6) & 7, s1);
		break;
		}
	case 2870: { // movec sc,m
		u32 s1 = get_sc();
		set_m(BIT(opcode, 8, 6) & 7, s1);
		break;
		}
	case 2871: { // movec sz,m
		u32 s1 = get_sz();
		set_m(BIT(opcode, 8, 6) & 7, s1);
		break;
		}
	case 2872: { // movec sr,m
		u32 s1 = get_sr();
		set_m(BIT(opcode, 8, 6) & 7, s1);
		break;
		}
	case 2873: { // movec omr,m
		u32 s1 = get_omr();
		set_m(BIT(opcode, 8, 6) & 7, s1);
		break;
		}
	case 2874: { // movec sp,m
		u32 s1 = get_sp();
		set_m(BIT(opcode, 8, 6) & 7, s1);
		break;
		}
	case 2875: { // movec ssh,m
		u32 s1 = get_ssh();
		set_m(BIT(opcode, 8, 6) & 7, s1);
		break;
		}
	case 2876: { // movec ssl,m
		u32 s1 = get_ssl();
		set_m(BIT(opcode, 8, 6) & 7, s1);
		break;
		}
	case 2877: { // movec la,m
		u32 s1 = get_la();
		set_m(BIT(opcode, 8, 6) & 7, s1);
		break;
		}
	case 2878: { // movec lc,m
		u32 s1 = get_lc();
		set_m(BIT(opcode, 8, 6) & 7, s1);
		break;
		}
	case 2879: { // movec m,ep
		u32 s1 = get_m(BIT(opcode, 0, 5) & 7);
		set_ep(s1);
		break;
		}
	case 2880: { // movec ep,ep
		u32 s1 = get_ep();
		set_ep(s1);
		break;
		}
	case 2881: { // movec vba,ep
		u32 s1 = get_vba();
		set_ep(s1);
		break;
		}
	case 2882: { // movec sc,ep
		u32 s1 = get_sc();
		set_ep(s1);
		break;
		}
	case 2883: { // movec sz,ep
		u32 s1 = get_sz();
		set_ep(s1);
		break;
		}
	case 2884: { // movec sr,ep
		u32 s1 = get_sr();
		set_ep(s1);
		break;
		}
	case 2885: { // movec omr,ep
		u32 s1 = get_omr();
		set_ep(s1);
		break;
		}
	case 2886: { // movec sp,ep
		u32 s1 = get_sp();
		set_ep(s1);
		break;
		}
	case 2887: { // movec ssh,ep
		u32 s1 = get_ssh();
		set_ep(s1);
		break;
		}
	case 2888: { // movec ssl,ep
		u32 s1 = get_ssl();
		set_ep(s1);
		break;
		}
	case 2889: { // movec la,ep
		u32 s1 = get_la();
		set_ep(s1);
		break;
		}
	case 2890: { // movec lc,ep
		u32 s1 = get_lc();
		set_ep(s1);
		break;
		}
	case 2891: { // movec m,vba
		u32 s1 = get_m(BIT(opcode, 0, 5) & 7);
		set_vba(s1);
		break;
		}
	case 2892: { // movec ep,vba
		u32 s1 = get_ep();
		set_vba(s1);
		break;
		}
	case 2893: { // movec vba,vba
		u32 s1 = get_vba();
		set_vba(s1);
		break;
		}
	case 2894: { // movec sc,vba
		u32 s1 = get_sc();
		set_vba(s1);
		break;
		}
	case 2895: { // movec sz,vba
		u32 s1 = get_sz();
		set_vba(s1);
		break;
		}
	case 2896: { // movec sr,vba
		u32 s1 = get_sr();
		set_vba(s1);
		break;
		}
	case 2897: { // movec omr,vba
		u32 s1 = get_omr();
		set_vba(s1);
		break;
		}
	case 2898: { // movec sp,vba
		u32 s1 = get_sp();
		set_vba(s1);
		break;
		}
	case 2899: { // movec ssh,vba
		u32 s1 = get_ssh();
		set_vba(s1);
		break;
		}
	case 2900: { // movec ssl,vba
		u32 s1 = get_ssl();
		set_vba(s1);
		break;
		}
	case 2901: { // movec la,vba
		u32 s1 = get_la();
		set_vba(s1);
		break;
		}
	case 2902: { // movec lc,vba
		u32 s1 = get_lc();
		set_vba(s1);
		break;
		}
	case 2903: { // movec m,sc
		u32 s1 = get_m(BIT(opcode, 0, 5) & 7);
		set_sc(s1);
		break;
		}
	case 2904: { // movec ep,sc
		u32 s1 = get_ep();
		set_sc(s1);
		break;
		}
	case 2905: { // movec vba,sc
		u32 s1 = get_vba();
		set_sc(s1);
		break;
		}
	case 2906: { // movec sc,sc
		u32 s1 = get_sc();
		set_sc(s1);
		break;
		}
	case 2907: { // movec sz,sc
		u32 s1 = get_sz();
		set_sc(s1);
		break;
		}
	case 2908: { // movec sr,sc
		u32 s1 = get_sr();
		set_sc(s1);
		break;
		}
	case 2909: { // movec omr,sc
		u32 s1 = get_omr();
		set_sc(s1);
		break;
		}
	case 2910: { // movec sp,sc
		u32 s1 = get_sp();
		set_sc(s1);
		break;
		}
	case 2911: { // movec ssh,sc
		u32 s1 = get_ssh();
		set_sc(s1);
		break;
		}
	case 2912: { // movec ssl,sc
		u32 s1 = get_ssl();
		set_sc(s1);
		break;
		}
	case 2913: { // movec la,sc
		u32 s1 = get_la();
		set_sc(s1);
		break;
		}
	case 2914: { // movec lc,sc
		u32 s1 = get_lc();
		set_sc(s1);
		break;
		}
	case 2915: { // movec m,sz
		u32 s1 = get_m(BIT(opcode, 0, 5) & 7);
		set_sz(s1);
		break;
		}
	case 2916: { // movec ep,sz
		u32 s1 = get_ep();
		set_sz(s1);
		break;
		}
	case 2917: { // movec vba,sz
		u32 s1 = get_vba();
		set_sz(s1);
		break;
		}
	case 2918: { // movec sc,sz
		u32 s1 = get_sc();
		set_sz(s1);
		break;
		}
	case 2919: { // movec sz,sz
		u32 s1 = get_sz();
		set_sz(s1);
		break;
		}
	case 2920: { // movec sr,sz
		u32 s1 = get_sr();
		set_sz(s1);
		break;
		}
	case 2921: { // movec omr,sz
		u32 s1 = get_omr();
		set_sz(s1);
		break;
		}
	case 2922: { // movec sp,sz
		u32 s1 = get_sp();
		set_sz(s1);
		break;
		}
	case 2923: { // movec ssh,sz
		u32 s1 = get_ssh();
		set_sz(s1);
		break;
		}
	case 2924: { // movec ssl,sz
		u32 s1 = get_ssl();
		set_sz(s1);
		break;
		}
	case 2925: { // movec la,sz
		u32 s1 = get_la();
		set_sz(s1);
		break;
		}
	case 2926: { // movec lc,sz
		u32 s1 = get_lc();
		set_sz(s1);
		break;
		}
	case 2927: { // movec m,sr
		u32 s1 = get_m(BIT(opcode, 0, 5) & 7);
		set_sr(s1);
		break;
		}
	case 2928: { // movec ep,sr
		u32 s1 = get_ep();
		set_sr(s1);
		break;
		}
	case 2929: { // movec vba,sr
		u32 s1 = get_vba();
		set_sr(s1);
		break;
		}
	case 2930: { // movec sc,sr
		u32 s1 = get_sc();
		set_sr(s1);
		break;
		}
	case 2931: { // movec sz,sr
		u32 s1 = get_sz();
		set_sr(s1);
		break;
		}
	case 2932: { // movec sr,sr
		u32 s1 = get_sr();
		set_sr(s1);
		break;
		}
	case 2933: { // movec omr,sr
		u32 s1 = get_omr();
		set_sr(s1);
		break;
		}
	case 2934: { // movec sp,sr
		u32 s1 = get_sp();
		set_sr(s1);
		break;
		}
	case 2935: { // movec ssh,sr
		u32 s1 = get_ssh();
		set_sr(s1);
		break;
		}
	case 2936: { // movec ssl,sr
		u32 s1 = get_ssl();
		set_sr(s1);
		break;
		}
	case 2937: { // movec la,sr
		u32 s1 = get_la();
		set_sr(s1);
		break;
		}
	case 2938: { // movec lc,sr
		u32 s1 = get_lc();
		set_sr(s1);
		break;
		}
	case 2939: { // movec m,omr
		u32 s1 = get_m(BIT(opcode, 0, 5) & 7);
		set_omr(s1);
		break;
		}
	case 2940: { // movec ep,omr
		u32 s1 = get_ep();
		set_omr(s1);
		break;
		}
	case 2941: { // movec vba,omr
		u32 s1 = get_vba();
		set_omr(s1);
		break;
		}
	case 2942: { // movec sc,omr
		u32 s1 = get_sc();
		set_omr(s1);
		break;
		}
	case 2943: { // movec sz,omr
		u32 s1 = get_sz();
		set_omr(s1);
		break;
		}
	case 2944: { // movec sr,omr
		u32 s1 = get_sr();
		set_omr(s1);
		break;
		}
	case 2945: { // movec omr,omr
		u32 s1 = get_omr();
		set_omr(s1);
		break;
		}
	case 2946: { // movec sp,omr
		u32 s1 = get_sp();
		set_omr(s1);
		break;
		}
	case 2947: { // movec ssh,omr
		u32 s1 = get_ssh();
		set_omr(s1);
		break;
		}
	case 2948: { // movec ssl,omr
		u32 s1 = get_ssl();
		set_omr(s1);
		break;
		}
	case 2949: { // movec la,omr
		u32 s1 = get_la();
		set_omr(s1);
		break;
		}
	case 2950: { // movec lc,omr
		u32 s1 = get_lc();
		set_omr(s1);
		break;
		}
	case 2951: { // movec m,sp
		u32 s1 = get_m(BIT(opcode, 0, 5) & 7);
		set_sp(s1);
		break;
		}
	case 2952: { // movec ep,sp
		u32 s1 = get_ep();
		set_sp(s1);
		break;
		}
	case 2953: { // movec vba,sp
		u32 s1 = get_vba();
		set_sp(s1);
		break;
		}
	case 2954: { // movec sc,sp
		u32 s1 = get_sc();
		set_sp(s1);
		break;
		}
	case 2955: { // movec sz,sp
		u32 s1 = get_sz();
		set_sp(s1);
		break;
		}
	case 2956: { // movec sr,sp
		u32 s1 = get_sr();
		set_sp(s1);
		break;
		}
	case 2957: { // movec omr,sp
		u32 s1 = get_omr();
		set_sp(s1);
		break;
		}
	case 2958: { // movec sp,sp
		u32 s1 = get_sp();
		set_sp(s1);
		break;
		}
	case 2959: { // movec ssh,sp
		u32 s1 = get_ssh();
		set_sp(s1);
		break;
		}
	case 2960: { // movec ssl,sp
		u32 s1 = get_ssl();
		set_sp(s1);
		break;
		}
	case 2961: { // movec la,sp
		u32 s1 = get_la();
		set_sp(s1);
		break;
		}
	case 2962: { // movec lc,sp
		u32 s1 = get_lc();
		set_sp(s1);
		break;
		}
	case 2963: { // movec m,ssh
		u32 s1 = get_m(BIT(opcode, 0, 5) & 7);
		set_ssh(s1);
		break;
		}
	case 2964: { // movec ep,ssh
		u32 s1 = get_ep();
		set_ssh(s1);
		break;
		}
	case 2965: { // movec vba,ssh
		u32 s1 = get_vba();
		set_ssh(s1);
		break;
		}
	case 2966: { // movec sc,ssh
		u32 s1 = get_sc();
		set_ssh(s1);
		break;
		}
	case 2967: { // movec sz,ssh
		u32 s1 = get_sz();
		set_ssh(s1);
		break;
		}
	case 2968: { // movec sr,ssh
		u32 s1 = get_sr();
		set_ssh(s1);
		break;
		}
	case 2969: { // movec omr,ssh
		u32 s1 = get_omr();
		set_ssh(s1);
		break;
		}
	case 2970: { // movec sp,ssh
		u32 s1 = get_sp();
		set_ssh(s1);
		break;
		}
	case 2971: { // movec ssh,ssh
		u32 s1 = get_ssh();
		set_ssh(s1);
		break;
		}
	case 2972: { // movec ssl,ssh
		u32 s1 = get_ssl();
		set_ssh(s1);
		break;
		}
	case 2973: { // movec la,ssh
		u32 s1 = get_la();
		set_ssh(s1);
		break;
		}
	case 2974: { // movec lc,ssh
		u32 s1 = get_lc();
		set_ssh(s1);
		break;
		}
	case 2975: { // movec m,ssl
		u32 s1 = get_m(BIT(opcode, 0, 5) & 7);
		set_ssl(s1);
		break;
		}
	case 2976: { // movec ep,ssl
		u32 s1 = get_ep();
		set_ssl(s1);
		break;
		}
	case 2977: { // movec vba,ssl
		u32 s1 = get_vba();
		set_ssl(s1);
		break;
		}
	case 2978: { // movec sc,ssl
		u32 s1 = get_sc();
		set_ssl(s1);
		break;
		}
	case 2979: { // movec sz,ssl
		u32 s1 = get_sz();
		set_ssl(s1);
		break;
		}
	case 2980: { // movec sr,ssl
		u32 s1 = get_sr();
		set_ssl(s1);
		break;
		}
	case 2981: { // movec omr,ssl
		u32 s1 = get_omr();
		set_ssl(s1);
		break;
		}
	case 2982: { // movec sp,ssl
		u32 s1 = get_sp();
		set_ssl(s1);
		break;
		}
	case 2983: { // movec ssh,ssl
		u32 s1 = get_ssh();
		set_ssl(s1);
		break;
		}
	case 2984: { // movec ssl,ssl
		u32 s1 = get_ssl();
		set_ssl(s1);
		break;
		}
	case 2985: { // movec la,ssl
		u32 s1 = get_la();
		set_ssl(s1);
		break;
		}
	case 2986: { // movec lc,ssl
		u32 s1 = get_lc();
		set_ssl(s1);
		break;
		}
	case 2987: { // movec m,la
		u32 s1 = get_m(BIT(opcode, 0, 5) & 7);
		set_la(s1);
		break;
		}
	case 2988: { // movec ep,la
		u32 s1 = get_ep();
		set_la(s1);
		break;
		}
	case 2989: { // movec vba,la
		u32 s1 = get_vba();
		set_la(s1);
		break;
		}
	case 2990: { // movec sc,la
		u32 s1 = get_sc();
		set_la(s1);
		break;
		}
	case 2991: { // movec sz,la
		u32 s1 = get_sz();
		set_la(s1);
		break;
		}
	case 2992: { // movec sr,la
		u32 s1 = get_sr();
		set_la(s1);
		break;
		}
	case 2993: { // movec omr,la
		u32 s1 = get_omr();
		set_la(s1);
		break;
		}
	case 2994: { // movec sp,la
		u32 s1 = get_sp();
		set_la(s1);
		break;
		}
	case 2995: { // movec ssh,la
		u32 s1 = get_ssh();
		set_la(s1);
		break;
		}
	case 2996: { // movec ssl,la
		u32 s1 = get_ssl();
		set_la(s1);
		break;
		}
	case 2997: { // movec la,la
		u32 s1 = get_la();
		set_la(s1);
		break;
		}
	case 2998: { // movec lc,la
		u32 s1 = get_lc();
		set_la(s1);
		break;
		}
	case 2999: { // movec m,lc
		u32 s1 = get_m(BIT(opcode, 0, 5) & 7);
		set_lc(s1);
		break;
		}
	case 3000: { // movec ep,lc
		u32 s1 = get_ep();
		set_lc(s1);
		break;
		}
	case 3001: { // movec vba,lc
		u32 s1 = get_vba();
		set_lc(s1);
		break;
		}
	case 3002: { // movec sc,lc
		u32 s1 = get_sc();
		set_lc(s1);
		break;
		}
	case 3003: { // movec sz,lc
		u32 s1 = get_sz();
		set_lc(s1);
		break;
		}
	case 3004: { // movec sr,lc
		u32 s1 = get_sr();
		set_lc(s1);
		break;
		}
	case 3005: { // movec omr,lc
		u32 s1 = get_omr();
		set_lc(s1);
		break;
		}
	case 3006: { // movec sp,lc
		u32 s1 = get_sp();
		set_lc(s1);
		break;
		}
	case 3007: { // movec ssh,lc
		u32 s1 = get_ssh();
		set_lc(s1);
		break;
		}
	case 3008: { // movec ssl,lc
		u32 s1 = get_ssl();
		set_lc(s1);
		break;
		}
	case 3009: { // movec la,lc
		u32 s1 = get_la();
		set_lc(s1);
		break;
		}
	case 3010: { // movec lc,lc
		u32 s1 = get_lc();
		set_lc(s1);
		break;
		}
	case 3011: { // movec #[i],m
		u32 i = BIT(opcode, 8, 8);
		set_m(BIT(opcode, 0, 5) & 7, i);
		break;
		}
	case 3012: { // movec #[i],ep
		u32 i = BIT(opcode, 8, 8);
		set_ep(i);
		break;
		}
	case 3013: { // movec #[i],vba
		u32 i = BIT(opcode, 8, 8);
		set_vba(i);
		break;
		}
	case 3014: { // movec #[i],sc
		u32 i = BIT(opcode, 8, 8);
		set_sc(i);
		break;
		}
	case 3015: { // movec #[i],sz
		u32 i = BIT(opcode, 8, 8);
		set_sz(i);
		break;
		}
	case 3016: { // movec #[i],sr
		u32 i = BIT(opcode, 8, 8);
		set_sr(i);
		break;
		}
	case 3017: { // movec #[i],omr
		u32 i = BIT(opcode, 8, 8);
		set_omr(i);
		break;
		}
	case 3018: { // movec #[i],sp
		u32 i = BIT(opcode, 8, 8);
		set_sp(i);
		break;
		}
	case 3019: { // movec #[i],ssh
		u32 i = BIT(opcode, 8, 8);
		set_ssh(i);
		break;
		}
	case 3020: { // movec #[i],ssl
		u32 i = BIT(opcode, 8, 8);
		set_ssl(i);
		break;
		}
	case 3021: { // movec #[i],la
		u32 i = BIT(opcode, 8, 8);
		set_la(i);
		break;
		}
	case 3022: { // movec #[i],lc
		u32 i = BIT(opcode, 8, 8);
		set_lc(i);
		break;
		}
	case 3023: { // movem p:(r)-n,x0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_x0(m_p.read_dword(ea));
		break;
		}
	case 3024: { // movem p:(r)-n,x1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_x1(m_p.read_dword(ea));
		break;
		}
	case 3025: { // movem p:(r)-n,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_y0(m_p.read_dword(ea));
		break;
		}
	case 3026: { // movem p:(r)-n,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_y1(m_p.read_dword(ea));
		break;
		}
	case 3027: { // movem p:(r)-n,a0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_a0(m_p.read_dword(ea));
		break;
		}
	case 3028: { // movem p:(r)-n,b0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_b0(m_p.read_dword(ea));
		break;
		}
	case 3029: { // movem p:(r)-n,a2
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_a2(m_p.read_dword(ea));
		break;
		}
	case 3030: { // movem p:(r)-n,b2
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_b2(m_p.read_dword(ea));
		break;
		}
	case 3031: { // movem p:(r)-n,a1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_a1(m_p.read_dword(ea));
		break;
		}
	case 3032: { // movem p:(r)-n,b1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_b1(m_p.read_dword(ea));
		break;
		}
	case 3033: { // movem p:(r)-n,a
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_ah(m_p.read_dword(ea));
		break;
		}
	case 3034: { // movem p:(r)-n,b
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_bh(m_p.read_dword(ea));
		break;
		}
	case 3035: { // movem p:(r)-n,r
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_r(BIT(opcode, 0, 6) & 7, m_p.read_dword(ea));
		break;
		}
	case 3036: { // movem p:(r)-n,n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_n(BIT(opcode, 0, 6) & 7, m_p.read_dword(ea));
		break;
		}
	case 3037: { // movem p:(r)-n,m
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_m(BIT(opcode, 0, 6) & 7, m_p.read_dword(ea));
		break;
		}
	case 3038: { // movem p:(r)-n,ep
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_ep(m_p.read_dword(ea));
		break;
		}
	case 3039: { // movem p:(r)-n,vba
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_vba(m_p.read_dword(ea));
		break;
		}
	case 3040: { // movem p:(r)-n,sc
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_sc(m_p.read_dword(ea));
		break;
		}
	case 3041: { // movem p:(r)-n,sz
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_sz(m_p.read_dword(ea));
		break;
		}
	case 3042: { // movem p:(r)-n,sr
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_sr(m_p.read_dword(ea));
		break;
		}
	case 3043: { // movem p:(r)-n,omr
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_omr(m_p.read_dword(ea));
		break;
		}
	case 3044: { // movem p:(r)-n,sp
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_sp(m_p.read_dword(ea));
		break;
		}
	case 3045: { // movem p:(r)-n,ssh
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_ssh(m_p.read_dword(ea));
		break;
		}
	case 3046: { // movem p:(r)-n,ssl
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_ssl(m_p.read_dword(ea));
		break;
		}
	case 3047: { // movem p:(r)-n,la
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_la(m_p.read_dword(ea));
		break;
		}
	case 3048: { // movem p:(r)-n,lc
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		set_lc(m_p.read_dword(ea));
		break;
		}
	case 3049: { // movem p:(r)+n,x0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_x0(m_p.read_dword(ea));
		break;
		}
	case 3050: { // movem p:(r)+n,x1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_x1(m_p.read_dword(ea));
		break;
		}
	case 3051: { // movem p:(r)+n,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_y0(m_p.read_dword(ea));
		break;
		}
	case 3052: { // movem p:(r)+n,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_y1(m_p.read_dword(ea));
		break;
		}
	case 3053: { // movem p:(r)+n,a0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_a0(m_p.read_dword(ea));
		break;
		}
	case 3054: { // movem p:(r)+n,b0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_b0(m_p.read_dword(ea));
		break;
		}
	case 3055: { // movem p:(r)+n,a2
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_a2(m_p.read_dword(ea));
		break;
		}
	case 3056: { // movem p:(r)+n,b2
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_b2(m_p.read_dword(ea));
		break;
		}
	case 3057: { // movem p:(r)+n,a1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_a1(m_p.read_dword(ea));
		break;
		}
	case 3058: { // movem p:(r)+n,b1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_b1(m_p.read_dword(ea));
		break;
		}
	case 3059: { // movem p:(r)+n,a
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_ah(m_p.read_dword(ea));
		break;
		}
	case 3060: { // movem p:(r)+n,b
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_bh(m_p.read_dword(ea));
		break;
		}
	case 3061: { // movem p:(r)+n,r
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_r(BIT(opcode, 0, 6) & 7, m_p.read_dword(ea));
		break;
		}
	case 3062: { // movem p:(r)+n,n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_n(BIT(opcode, 0, 6) & 7, m_p.read_dword(ea));
		break;
		}
	case 3063: { // movem p:(r)+n,m
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_m(BIT(opcode, 0, 6) & 7, m_p.read_dword(ea));
		break;
		}
	case 3064: { // movem p:(r)+n,ep
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_ep(m_p.read_dword(ea));
		break;
		}
	case 3065: { // movem p:(r)+n,vba
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_vba(m_p.read_dword(ea));
		break;
		}
	case 3066: { // movem p:(r)+n,sc
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_sc(m_p.read_dword(ea));
		break;
		}
	case 3067: { // movem p:(r)+n,sz
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_sz(m_p.read_dword(ea));
		break;
		}
	case 3068: { // movem p:(r)+n,sr
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_sr(m_p.read_dword(ea));
		break;
		}
	case 3069: { // movem p:(r)+n,omr
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_omr(m_p.read_dword(ea));
		break;
		}
	case 3070: { // movem p:(r)+n,sp
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_sp(m_p.read_dword(ea));
		break;
		}
	case 3071: { // movem p:(r)+n,ssh
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_ssh(m_p.read_dword(ea));
		break;
		}
	case 3072: { // movem p:(r)+n,ssl
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_ssl(m_p.read_dword(ea));
		break;
		}
	case 3073: { // movem p:(r)+n,la
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_la(m_p.read_dword(ea));
		break;
		}
	case 3074: { // movem p:(r)+n,lc
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		set_lc(m_p.read_dword(ea));
		break;
		}
	case 3075: { // movem p:(r)-,x0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_x0(m_p.read_dword(ea));
		break;
		}
	case 3076: { // movem p:(r)-,x1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_x1(m_p.read_dword(ea));
		break;
		}
	case 3077: { // movem p:(r)-,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_y0(m_p.read_dword(ea));
		break;
		}
	case 3078: { // movem p:(r)-,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_y1(m_p.read_dword(ea));
		break;
		}
	case 3079: { // movem p:(r)-,a0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_a0(m_p.read_dword(ea));
		break;
		}
	case 3080: { // movem p:(r)-,b0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_b0(m_p.read_dword(ea));
		break;
		}
	case 3081: { // movem p:(r)-,a2
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_a2(m_p.read_dword(ea));
		break;
		}
	case 3082: { // movem p:(r)-,b2
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_b2(m_p.read_dword(ea));
		break;
		}
	case 3083: { // movem p:(r)-,a1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_a1(m_p.read_dword(ea));
		break;
		}
	case 3084: { // movem p:(r)-,b1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_b1(m_p.read_dword(ea));
		break;
		}
	case 3085: { // movem p:(r)-,a
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_ah(m_p.read_dword(ea));
		break;
		}
	case 3086: { // movem p:(r)-,b
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_bh(m_p.read_dword(ea));
		break;
		}
	case 3087: { // movem p:(r)-,r
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_r(BIT(opcode, 0, 6) & 7, m_p.read_dword(ea));
		break;
		}
	case 3088: { // movem p:(r)-,n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_n(BIT(opcode, 0, 6) & 7, m_p.read_dword(ea));
		break;
		}
	case 3089: { // movem p:(r)-,m
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_m(BIT(opcode, 0, 6) & 7, m_p.read_dword(ea));
		break;
		}
	case 3090: { // movem p:(r)-,ep
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_ep(m_p.read_dword(ea));
		break;
		}
	case 3091: { // movem p:(r)-,vba
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_vba(m_p.read_dword(ea));
		break;
		}
	case 3092: { // movem p:(r)-,sc
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_sc(m_p.read_dword(ea));
		break;
		}
	case 3093: { // movem p:(r)-,sz
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_sz(m_p.read_dword(ea));
		break;
		}
	case 3094: { // movem p:(r)-,sr
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_sr(m_p.read_dword(ea));
		break;
		}
	case 3095: { // movem p:(r)-,omr
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_omr(m_p.read_dword(ea));
		break;
		}
	case 3096: { // movem p:(r)-,sp
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_sp(m_p.read_dword(ea));
		break;
		}
	case 3097: { // movem p:(r)-,ssh
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_ssh(m_p.read_dword(ea));
		break;
		}
	case 3098: { // movem p:(r)-,ssl
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_ssl(m_p.read_dword(ea));
		break;
		}
	case 3099: { // movem p:(r)-,la
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_la(m_p.read_dword(ea));
		break;
		}
	case 3100: { // movem p:(r)-,lc
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		set_lc(m_p.read_dword(ea));
		break;
		}
	case 3101: { // movem p:(r)+,x0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_x0(m_p.read_dword(ea));
		break;
		}
	case 3102: { // movem p:(r)+,x1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_x1(m_p.read_dword(ea));
		break;
		}
	case 3103: { // movem p:(r)+,y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_y0(m_p.read_dword(ea));
		break;
		}
	case 3104: { // movem p:(r)+,y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_y1(m_p.read_dword(ea));
		break;
		}
	case 3105: { // movem p:(r)+,a0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_a0(m_p.read_dword(ea));
		break;
		}
	case 3106: { // movem p:(r)+,b0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_b0(m_p.read_dword(ea));
		break;
		}
	case 3107: { // movem p:(r)+,a2
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_a2(m_p.read_dword(ea));
		break;
		}
	case 3108: { // movem p:(r)+,b2
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_b2(m_p.read_dword(ea));
		break;
		}
	case 3109: { // movem p:(r)+,a1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_a1(m_p.read_dword(ea));
		break;
		}
	case 3110: { // movem p:(r)+,b1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_b1(m_p.read_dword(ea));
		break;
		}
	case 3111: { // movem p:(r)+,a
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_ah(m_p.read_dword(ea));
		break;
		}
	case 3112: { // movem p:(r)+,b
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_bh(m_p.read_dword(ea));
		break;
		}
	case 3113: { // movem p:(r)+,r
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_r(BIT(opcode, 0, 6) & 7, m_p.read_dword(ea));
		break;
		}
	case 3114: { // movem p:(r)+,n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_n(BIT(opcode, 0, 6) & 7, m_p.read_dword(ea));
		break;
		}
	case 3115: { // movem p:(r)+,m
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_m(BIT(opcode, 0, 6) & 7, m_p.read_dword(ea));
		break;
		}
	case 3116: { // movem p:(r)+,ep
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_ep(m_p.read_dword(ea));
		break;
		}
	case 3117: { // movem p:(r)+,vba
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_vba(m_p.read_dword(ea));
		break;
		}
	case 3118: { // movem p:(r)+,sc
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_sc(m_p.read_dword(ea));
		break;
		}
	case 3119: { // movem p:(r)+,sz
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_sz(m_p.read_dword(ea));
		break;
		}
	case 3120: { // movem p:(r)+,sr
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_sr(m_p.read_dword(ea));
		break;
		}
	case 3121: { // movem p:(r)+,omr
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_omr(m_p.read_dword(ea));
		break;
		}
	case 3122: { // movem p:(r)+,sp
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_sp(m_p.read_dword(ea));
		break;
		}
	case 3123: { // movem p:(r)+,ssh
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_ssh(m_p.read_dword(ea));
		break;
		}
	case 3124: { // movem p:(r)+,ssl
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_ssl(m_p.read_dword(ea));
		break;
		}
	case 3125: { // movem p:(r)+,la
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_la(m_p.read_dword(ea));
		break;
		}
	case 3126: { // movem p:(r)+,lc
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		set_lc(m_p.read_dword(ea));
		break;
		}
	case 3127: { // movem p:(r),x0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_x0(m_p.read_dword(ea));
		break;
		}
	case 3128: { // movem p:(r),x1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_x1(m_p.read_dword(ea));
		break;
		}
	case 3129: { // movem p:(r),y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_y0(m_p.read_dword(ea));
		break;
		}
	case 3130: { // movem p:(r),y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_y1(m_p.read_dword(ea));
		break;
		}
	case 3131: { // movem p:(r),a0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_a0(m_p.read_dword(ea));
		break;
		}
	case 3132: { // movem p:(r),b0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_b0(m_p.read_dword(ea));
		break;
		}
	case 3133: { // movem p:(r),a2
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_a2(m_p.read_dword(ea));
		break;
		}
	case 3134: { // movem p:(r),b2
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_b2(m_p.read_dword(ea));
		break;
		}
	case 3135: { // movem p:(r),a1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_a1(m_p.read_dword(ea));
		break;
		}
	case 3136: { // movem p:(r),b1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_b1(m_p.read_dword(ea));
		break;
		}
	case 3137: { // movem p:(r),a
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_ah(m_p.read_dword(ea));
		break;
		}
	case 3138: { // movem p:(r),b
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_bh(m_p.read_dword(ea));
		break;
		}
	case 3139: { // movem p:(r),r
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_r(BIT(opcode, 0, 6) & 7, m_p.read_dword(ea));
		break;
		}
	case 3140: { // movem p:(r),n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_n(BIT(opcode, 0, 6) & 7, m_p.read_dword(ea));
		break;
		}
	case 3141: { // movem p:(r),m
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_m(BIT(opcode, 0, 6) & 7, m_p.read_dword(ea));
		break;
		}
	case 3142: { // movem p:(r),ep
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_ep(m_p.read_dword(ea));
		break;
		}
	case 3143: { // movem p:(r),vba
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_vba(m_p.read_dword(ea));
		break;
		}
	case 3144: { // movem p:(r),sc
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_sc(m_p.read_dword(ea));
		break;
		}
	case 3145: { // movem p:(r),sz
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_sz(m_p.read_dword(ea));
		break;
		}
	case 3146: { // movem p:(r),sr
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_sr(m_p.read_dword(ea));
		break;
		}
	case 3147: { // movem p:(r),omr
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_omr(m_p.read_dword(ea));
		break;
		}
	case 3148: { // movem p:(r),sp
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_sp(m_p.read_dword(ea));
		break;
		}
	case 3149: { // movem p:(r),ssh
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_ssh(m_p.read_dword(ea));
		break;
		}
	case 3150: { // movem p:(r),ssl
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_ssl(m_p.read_dword(ea));
		break;
		}
	case 3151: { // movem p:(r),la
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_la(m_p.read_dword(ea));
		break;
		}
	case 3152: { // movem p:(r),lc
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		set_lc(m_p.read_dword(ea));
		break;
		}
	case 3153: { // movem p:(r+n),x0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_x0(m_p.read_dword(ea));
		break;
		}
	case 3154: { // movem p:(r+n),x1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_x1(m_p.read_dword(ea));
		break;
		}
	case 3155: { // movem p:(r+n),y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_y0(m_p.read_dword(ea));
		break;
		}
	case 3156: { // movem p:(r+n),y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_y1(m_p.read_dword(ea));
		break;
		}
	case 3157: { // movem p:(r+n),a0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_a0(m_p.read_dword(ea));
		break;
		}
	case 3158: { // movem p:(r+n),b0
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_b0(m_p.read_dword(ea));
		break;
		}
	case 3159: { // movem p:(r+n),a2
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_a2(m_p.read_dword(ea));
		break;
		}
	case 3160: { // movem p:(r+n),b2
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_b2(m_p.read_dword(ea));
		break;
		}
	case 3161: { // movem p:(r+n),a1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_a1(m_p.read_dword(ea));
		break;
		}
	case 3162: { // movem p:(r+n),b1
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_b1(m_p.read_dword(ea));
		break;
		}
	case 3163: { // movem p:(r+n),a
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_ah(m_p.read_dword(ea));
		break;
		}
	case 3164: { // movem p:(r+n),b
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_bh(m_p.read_dword(ea));
		break;
		}
	case 3165: { // movem p:(r+n),r
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_r(BIT(opcode, 0, 6) & 7, m_p.read_dword(ea));
		break;
		}
	case 3166: { // movem p:(r+n),n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_n(BIT(opcode, 0, 6) & 7, m_p.read_dword(ea));
		break;
		}
	case 3167: { // movem p:(r+n),m
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_m(BIT(opcode, 0, 6) & 7, m_p.read_dword(ea));
		break;
		}
	case 3168: { // movem p:(r+n),ep
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_ep(m_p.read_dword(ea));
		break;
		}
	case 3169: { // movem p:(r+n),vba
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_vba(m_p.read_dword(ea));
		break;
		}
	case 3170: { // movem p:(r+n),sc
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_sc(m_p.read_dword(ea));
		break;
		}
	case 3171: { // movem p:(r+n),sz
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_sz(m_p.read_dword(ea));
		break;
		}
	case 3172: { // movem p:(r+n),sr
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_sr(m_p.read_dword(ea));
		break;
		}
	case 3173: { // movem p:(r+n),omr
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_omr(m_p.read_dword(ea));
		break;
		}
	case 3174: { // movem p:(r+n),sp
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_sp(m_p.read_dword(ea));
		break;
		}
	case 3175: { // movem p:(r+n),ssh
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_ssh(m_p.read_dword(ea));
		break;
		}
	case 3176: { // movem p:(r+n),ssl
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_ssl(m_p.read_dword(ea));
		break;
		}
	case 3177: { // movem p:(r+n),la
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_la(m_p.read_dword(ea));
		break;
		}
	case 3178: { // movem p:(r+n),lc
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = calc_add_r(ea_r, m_n[ea_r]);
		set_lc(m_p.read_dword(ea));
		break;
		}
	case 3179: { // movem p:-(r),x0
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_x0(m_p.read_dword(ea));
		break;
		}
	case 3180: { // movem p:-(r),x1
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_x1(m_p.read_dword(ea));
		break;
		}
	case 3181: { // movem p:-(r),y0
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_y0(m_p.read_dword(ea));
		break;
		}
	case 3182: { // movem p:-(r),y1
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_y1(m_p.read_dword(ea));
		break;
		}
	case 3183: { // movem p:-(r),a0
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_a0(m_p.read_dword(ea));
		break;
		}
	case 3184: { // movem p:-(r),b0
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_b0(m_p.read_dword(ea));
		break;
		}
	case 3185: { // movem p:-(r),a2
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_a2(m_p.read_dword(ea));
		break;
		}
	case 3186: { // movem p:-(r),b2
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_b2(m_p.read_dword(ea));
		break;
		}
	case 3187: { // movem p:-(r),a1
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_a1(m_p.read_dword(ea));
		break;
		}
	case 3188: { // movem p:-(r),b1
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_b1(m_p.read_dword(ea));
		break;
		}
	case 3189: { // movem p:-(r),a
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_ah(m_p.read_dword(ea));
		break;
		}
	case 3190: { // movem p:-(r),b
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_bh(m_p.read_dword(ea));
		break;
		}
	case 3191: { // movem p:-(r),r
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_r(BIT(opcode, 0, 6) & 7, m_p.read_dword(ea));
		break;
		}
	case 3192: { // movem p:-(r),n
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_n(BIT(opcode, 0, 6) & 7, m_p.read_dword(ea));
		break;
		}
	case 3193: { // movem p:-(r),m
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_m(BIT(opcode, 0, 6) & 7, m_p.read_dword(ea));
		break;
		}
	case 3194: { // movem p:-(r),ep
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_ep(m_p.read_dword(ea));
		break;
		}
	case 3195: { // movem p:-(r),vba
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_vba(m_p.read_dword(ea));
		break;
		}
	case 3196: { // movem p:-(r),sc
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_sc(m_p.read_dword(ea));
		break;
		}
	case 3197: { // movem p:-(r),sz
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_sz(m_p.read_dword(ea));
		break;
		}
	case 3198: { // movem p:-(r),sr
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_sr(m_p.read_dword(ea));
		break;
		}
	case 3199: { // movem p:-(r),omr
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_omr(m_p.read_dword(ea));
		break;
		}
	case 3200: { // movem p:-(r),sp
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_sp(m_p.read_dword(ea));
		break;
		}
	case 3201: { // movem p:-(r),ssh
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_ssh(m_p.read_dword(ea));
		break;
		}
	case 3202: { // movem p:-(r),ssl
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_ssl(m_p.read_dword(ea));
		break;
		}
	case 3203: { // movem p:-(r),la
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_la(m_p.read_dword(ea));
		break;
		}
	case 3204: { // movem p:-(r),lc
		int ea_r = BIT(opcode, 8, 6) & 7;
		add_r(ea_r, -1);
		u32 ea = get_r(ea_r);
		set_lc(m_p.read_dword(ea));
		break;
		}
	case 3205: { // movem x0,p:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s = get_x0();
		m_p.write_dword(ea, s);
		break;
		}
	case 3206: { // movem x1,p:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s = get_x1();
		m_p.write_dword(ea, s);
		break;
		}
	case 3207: { // movem y0,p:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s = get_y0();
		m_p.write_dword(ea, s);
		break;
		}
	case 3208: { // movem y1,p:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s = get_y1();
		m_p.write_dword(ea, s);
		break;
		}
	case 3209: { // movem a0,p:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s = get_a0();
		m_p.write_dword(ea, s);
		break;
		}
	case 3210: { // movem b0,p:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s = get_b0();
		m_p.write_dword(ea, s);
		break;
		}
	case 3211: { // movem a2,p:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s = get_a2();
		m_p.write_dword(ea, s);
		break;
		}
	case 3212: { // movem b2,p:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s = get_b2();
		m_p.write_dword(ea, s);
		break;
		}
	case 3213: { // movem a1,p:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s = get_a1();
		m_p.write_dword(ea, s);
		break;
		}
	case 3214: { // movem b1,p:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s = get_b1();
		m_p.write_dword(ea, s);
		break;
		}
	case 3215: { // movem a,p:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s_h = get_ah();
		m_p.write_dword(ea, s_h);
		break;
		}
	case 3216: { // movem b,p:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s_h = get_bh();
		m_p.write_dword(ea, s_h);
		break;
		}
	case 3217: { // movem r,p:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s = get_r(BIT(opcode, 0, 6) & 7);
		m_p.write_dword(ea, s);
		break;
		}
	case 3218: { // movem n,p:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s = get_n(BIT(opcode, 0, 6) & 7);
		m_p.write_dword(ea, s);
		break;
		}
	case 3219: { // movem m,p:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s = get_m(BIT(opcode, 0, 6) & 7);
		m_p.write_dword(ea, s);
		break;
		}
	case 3220: { // movem ep,p:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s = get_ep();
		m_p.write_dword(ea, s);
		break;
		}
	case 3221: { // movem vba,p:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s = get_vba();
		m_p.write_dword(ea, s);
		break;
		}
	case 3222: { // movem sc,p:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s = get_sc();
		m_p.write_dword(ea, s);
		break;
		}
	case 3223: { // movem sz,p:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s = get_sz();
		m_p.write_dword(ea, s);
		break;
		}
	case 3224: { // movem sr,p:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s = get_sr();
		m_p.write_dword(ea, s);
		break;
		}
	case 3225: { // movem omr,p:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s = get_omr();
		m_p.write_dword(ea, s);
		break;
		}
	case 3226: { // movem sp,p:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s = get_sp();
		m_p.write_dword(ea, s);
		break;
		}
	case 3227: { // movem ssh,p:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s = get_ssh();
		m_p.write_dword(ea, s);
		break;
		}
	case 3228: { // movem ssl,p:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s = get_ssl();
		m_p.write_dword(ea, s);
		break;
		}
	case 3229: { // movem la,p:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s = get_la();
		m_p.write_dword(ea, s);
		break;
		}
	case 3230: { // movem lc,p:(r)-n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -m_n[ea_r]);
		u32 s = get_lc();
		m_p.write_dword(ea, s);
		break;
		}
	case 3231: { // movem x0,p:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s = get_x0();
		m_p.write_dword(ea, s);
		break;
		}
	case 3232: { // movem x1,p:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s = get_x1();
		m_p.write_dword(ea, s);
		break;
		}
	case 3233: { // movem y0,p:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s = get_y0();
		m_p.write_dword(ea, s);
		break;
		}
	case 3234: { // movem y1,p:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s = get_y1();
		m_p.write_dword(ea, s);
		break;
		}
	case 3235: { // movem a0,p:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s = get_a0();
		m_p.write_dword(ea, s);
		break;
		}
	case 3236: { // movem b0,p:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s = get_b0();
		m_p.write_dword(ea, s);
		break;
		}
	case 3237: { // movem a2,p:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s = get_a2();
		m_p.write_dword(ea, s);
		break;
		}
	case 3238: { // movem b2,p:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s = get_b2();
		m_p.write_dword(ea, s);
		break;
		}
	case 3239: { // movem a1,p:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s = get_a1();
		m_p.write_dword(ea, s);
		break;
		}
	case 3240: { // movem b1,p:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s = get_b1();
		m_p.write_dword(ea, s);
		break;
		}
	case 3241: { // movem a,p:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s_h = get_ah();
		m_p.write_dword(ea, s_h);
		break;
		}
	case 3242: { // movem b,p:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s_h = get_bh();
		m_p.write_dword(ea, s_h);
		break;
		}
	case 3243: { // movem r,p:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s = get_r(BIT(opcode, 0, 6) & 7);
		m_p.write_dword(ea, s);
		break;
		}
	case 3244: { // movem n,p:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s = get_n(BIT(opcode, 0, 6) & 7);
		m_p.write_dword(ea, s);
		break;
		}
	case 3245: { // movem m,p:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s = get_m(BIT(opcode, 0, 6) & 7);
		m_p.write_dword(ea, s);
		break;
		}
	case 3246: { // movem ep,p:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s = get_ep();
		m_p.write_dword(ea, s);
		break;
		}
	case 3247: { // movem vba,p:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s = get_vba();
		m_p.write_dword(ea, s);
		break;
		}
	case 3248: { // movem sc,p:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s = get_sc();
		m_p.write_dword(ea, s);
		break;
		}
	case 3249: { // movem sz,p:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s = get_sz();
		m_p.write_dword(ea, s);
		break;
		}
	case 3250: { // movem sr,p:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s = get_sr();
		m_p.write_dword(ea, s);
		break;
		}
	case 3251: { // movem omr,p:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s = get_omr();
		m_p.write_dword(ea, s);
		break;
		}
	case 3252: { // movem sp,p:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s = get_sp();
		m_p.write_dword(ea, s);
		break;
		}
	case 3253: { // movem ssh,p:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s = get_ssh();
		m_p.write_dword(ea, s);
		break;
		}
	case 3254: { // movem ssl,p:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s = get_ssl();
		m_p.write_dword(ea, s);
		break;
		}
	case 3255: { // movem la,p:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s = get_la();
		m_p.write_dword(ea, s);
		break;
		}
	case 3256: { // movem lc,p:(r)+n
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, m_n[ea_r]);
		u32 s = get_lc();
		m_p.write_dword(ea, s);
		break;
		}
	case 3257: { // movem x0,p:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s = get_x0();
		m_p.write_dword(ea, s);
		break;
		}
	case 3258: { // movem x1,p:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s = get_x1();
		m_p.write_dword(ea, s);
		break;
		}
	case 3259: { // movem y0,p:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s = get_y0();
		m_p.write_dword(ea, s);
		break;
		}
	case 3260: { // movem y1,p:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s = get_y1();
		m_p.write_dword(ea, s);
		break;
		}
	case 3261: { // movem a0,p:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s = get_a0();
		m_p.write_dword(ea, s);
		break;
		}
	case 3262: { // movem b0,p:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s = get_b0();
		m_p.write_dword(ea, s);
		break;
		}
	case 3263: { // movem a2,p:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s = get_a2();
		m_p.write_dword(ea, s);
		break;
		}
	case 3264: { // movem b2,p:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s = get_b2();
		m_p.write_dword(ea, s);
		break;
		}
	case 3265: { // movem a1,p:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s = get_a1();
		m_p.write_dword(ea, s);
		break;
		}
	case 3266: { // movem b1,p:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s = get_b1();
		m_p.write_dword(ea, s);
		break;
		}
	case 3267: { // movem a,p:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s_h = get_ah();
		m_p.write_dword(ea, s_h);
		break;
		}
	case 3268: { // movem b,p:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s_h = get_bh();
		m_p.write_dword(ea, s_h);
		break;
		}
	case 3269: { // movem r,p:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s = get_r(BIT(opcode, 0, 6) & 7);
		m_p.write_dword(ea, s);
		break;
		}
	case 3270: { // movem n,p:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s = get_n(BIT(opcode, 0, 6) & 7);
		m_p.write_dword(ea, s);
		break;
		}
	case 3271: { // movem m,p:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s = get_m(BIT(opcode, 0, 6) & 7);
		m_p.write_dword(ea, s);
		break;
		}
	case 3272: { // movem ep,p:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s = get_ep();
		m_p.write_dword(ea, s);
		break;
		}
	case 3273: { // movem vba,p:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s = get_vba();
		m_p.write_dword(ea, s);
		break;
		}
	case 3274: { // movem sc,p:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s = get_sc();
		m_p.write_dword(ea, s);
		break;
		}
	case 3275: { // movem sz,p:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s = get_sz();
		m_p.write_dword(ea, s);
		break;
		}
	case 3276: { // movem sr,p:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s = get_sr();
		m_p.write_dword(ea, s);
		break;
		}
	case 3277: { // movem omr,p:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s = get_omr();
		m_p.write_dword(ea, s);
		break;
		}
	case 3278: { // movem sp,p:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s = get_sp();
		m_p.write_dword(ea, s);
		break;
		}
	case 3279: { // movem ssh,p:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s = get_ssh();
		m_p.write_dword(ea, s);
		break;
		}
	case 3280: { // movem ssl,p:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s = get_ssl();
		m_p.write_dword(ea, s);
		break;
		}
	case 3281: { // movem la,p:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s = get_la();
		m_p.write_dword(ea, s);
		break;
		}
	case 3282: { // movem lc,p:(r)-
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, -1);
		u32 s = get_lc();
		m_p.write_dword(ea, s);
		break;
		}
	case 3283: { // movem x0,p:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 s = get_x0();
		m_p.write_dword(ea, s);
		break;
		}
	case 3284: { // movem x1,p:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 s = get_x1();
		m_p.write_dword(ea, s);
		break;
		}
	case 3285: { // movem y0,p:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 s = get_y0();
		m_p.write_dword(ea, s);
		break;
		}
	case 3286: { // movem y1,p:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 s = get_y1();
		m_p.write_dword(ea, s);
		break;
		}
	case 3287: { // movem a0,p:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 s = get_a0();
		m_p.write_dword(ea, s);
		break;
		}
	case 3288: { // movem b0,p:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 s = get_b0();
		m_p.write_dword(ea, s);
		break;
		}
	case 3289: { // movem a2,p:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 s = get_a2();
		m_p.write_dword(ea, s);
		break;
		}
	case 3290: { // movem b2,p:(r)+
		int ea_r = BIT(opcode, 8, 6) & 7;
		u32 ea = get_r(ea_r);
		add_r(ea_r, 1);
		u32 s = get_b2();
		m_p.write_dword(ea, 