// Copyright 2024 Mathias Bynens. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
author: Mathias Bynens
description: >
  Unicode property escapes for `Script=Todhri`
info: |
  Generated by https://github.com/mathiasbynens/unicode-property-escapes-tests
  Unicode v16.0.0
esid: sec-static-semantics-unicodematchproperty-p
features: [regexp-unicode-property-escapes]
includes: [regExpUtils.js]
---*/

const matchSymbols = buildString({
  loneCodePoints: [],
  ranges: [
    [0x0105C0, 0x0105F3]
  ]
});
testPropertyEscapes(
  /^\p{Script=Todhri}+$/u,
  matchSymbols,
  "\\p{Script=Todhri}"
);
testPropertyEscapes(
  /^\p{Script=Todr}+$/u,
  matchSymbols,
  "\\p{Script=Todr}"
);
testPropertyEscapes(
  /^\p{sc=Todhri}+$/u,
  matchSymbols,
  "\\p{sc=Todhri}"
);
testPropertyEscapes(
  /^\p{sc=Todr}+$/u,
  matchSymbols,
  "\\p{sc=Todr}"
);

const nonMatchSymbols = buildString({
  loneCodePoints: [],
  ranges: [
    [0x00DC00, 0x00DFFF],
    [0x000000, 0x00DBFF],
    [0x00E000, 0x0105BF],
    [0x0105F4, 0x10FFFF]
  ]
});
testPropertyEscapes(
  /^\P{Script=Todhri}+$/u,
  nonMatchSymbols,
  "\\P{Script=Todhri}"
);
testPropertyEscapes(
  /^\P{Script=Todr}+$/u,
  nonMatchSymbols,
  "\\P{Script=Todr}"
);
testPropertyEscapes(
  /^\P{sc=Todhri}+$/u,
  nonMatchSymbols,
  "\\P{sc=Todhri}"
);
testPropertyEscapes(
  /^\P{sc=Todr}+$/u,
  nonMatchSymbols,
  "\\P{sc=Todr}"
);

reportCompare(0, 0);
